<?php

namespace App\Http\Controllers\Site\Calendar;

use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicCalendarSubheadColor;
use App\Models\Event\Event;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Response;

class CalendarController extends Controller
{
    private $event;

    public function __construct(Event $event)
    {
//        $this->middleware('login');
        $this->event = $event;
        $this->middleware('auth');


    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //dd('fff');
        $viewType ="Academic Calendar";

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.calendar.index', compact('monthIncrement', 'weekDays', 'monthName', 'year', 'eventModel','viewType'));
    }
    public function monthlyView()
    {
        $viewType ="Academic Monthly Calendar";

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.calendar.index', compact('monthIncrement', 'weekDays', 'monthName', 'year', 'eventModel','viewType'));
    }
    public function yearlyView()
    {
        $viewType ="Academic Yearly Calendar";

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.calendar.index', compact('monthIncrement', 'weekDays', 'monthName', 'year', 'eventModel','viewType'));
    }
    public function listView()
    {
        $viewType ="Academic Calendar list";

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.calendar.index', compact('monthIncrement', 'weekDays', 'monthName', 'year', 'eventModel','viewType'));
    }

    public function getCalendarTitleList($head_id)
    {
//        return 'ok';
        $event_list = $this->event->where('academic_calendar_head_id', $head_id)->get();

        if(count($event_list)>0){
            $event = $event_list->pluck('title');

            $event_unique = $event->unique();

//        $eventList = Event::where('identification_number', 103)->with('academicCalendarHead')->first();

            foreach ($event_unique as $key => $value){

                $eventList[$key] = $this->event->where('title', $value)->with('academicCalendarHead')->first();
            }
            if(count($eventList)){
                return $eventList;
            }else{
//                throw new Error('event not found');
                return Response::json(['message' => 'Sorry! event not found!'], 411);
            }

        }else{
            return Response::json(['message' => 'Sorry! event not found!'], 411);

        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function getCalendarList($monthIncrement)
    {
               /*    $inputMonth = '2013-05-01';
                   $rr = date('F Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
                   $month = date("m", strtotime($inputMonth));
                   $year = date("Y", strtotime($inputMonth));
                   $getdate = getdate(mktime(null, null, null, $month, 1, $year));*/

//        return $monthIncrement;

        $eventModel = new Event();


        $dateComponents = getdate(mktime(null, null, null, date('m') + $monthIncrement, 1, date('Y')));
//        return $dateComponents;

        $month = $dateComponents['mon'];
        $year = $dateComponents['year'];
        $daysOfWeek = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        //  $daysOfWeek = array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');

        // What is the first day of the month in question?
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

        // How many days does this month contain?
        $numberDays = date('t', $firstDayOfMonth);


        // Retrieve some information about the first day of the
        // month in question.
        $dateComponents = getdate($firstDayOfMonth);

        // What is the name of the month in question?
        $monthName = $dateComponents['month'];
        $dayOfWeek = $dateComponents['wday'];
        $currentDay = 1;

//      =====================empty column check=====================

        $totalNumberDays = $numberDays + $dayOfWeek;
//        return $totalNumberDays;

        $dateColumnsNumbers = $totalNumberDays / 7;


        if (is_float($dateColumnsNumbers)){

            $roundNumber = round($dateColumnsNumbers);
            $multipliedNumber =  $roundNumber *7;

            if($multipliedNumber < $totalNumberDays){

                $increseased_number =  $roundNumber + 1;
                $undateColumnsNumbers = $increseased_number * 7 - $totalNumberDays;

            }else if($multipliedNumber > $totalNumberDays){

                $undateColumnsNumbers = $multipliedNumber - $totalNumberDays;
            }

        }else{
            $undateColumnsNumbers = 0;
        }

//        return $undateColumnsNumbers;


//      ========================empty column check end===========================

        $arrayData=array();
        for($b=1; $b<=$dayOfWeek; $b++){
            $arrayData[]="";

        }

        for ($i=1; $i<=$numberDays; $i++){

            $currentDayRel=str_pad($i, 2, "0", STR_PAD_LEFT);
            $date=$year.'-'.$month.'-'.$currentDayRel;

            $arrayData[][$i] = Event::where('activate_date', $date)->where('status',1)->with('academicCalendarHead')->get();

        }

        for($c=1; $c<=$undateColumnsNumbers; $c++){

            $arrayData[]="";

        }
//        dd($arrayData);


        $finalArrayData = array();

        foreach ($arrayData as $key => $value){
            if($key<7){
                $finalArrayData['first_row'][$key] = $value;
            }elseif ($key>6 && $key<14){
                $finalArrayData['second_row'][$key] = $value;
            }elseif ($key>13 && $key<21){
                $finalArrayData['third_row'][$key] = $value;
            }elseif ($key>20 && $key<28){
                $finalArrayData['fourth_row'][$key] = $value;
            }elseif ($key>27 && $key<35){
                $finalArrayData['fifth_row'][$key] = $value;
            }elseif ($key>34 && $key<42){
                $finalArrayData['sixth_row'][$key] = $value;
            }
        }

        $ac_calendar_head = AcademicCalendarHead::get();

//        dd($finalArrayData);
        return response()->json([$monthIncrement, $year, $daysOfWeek, $eventModel, $dayOfWeek,
            $finalArrayData, $numberDays, $month, $monthName, $undateColumnsNumbers, $ac_calendar_head], 200);

//        return view('default.admin.calendar.calendar-list', compact('monthIncrement', 'year', 'daysOfWeek', 'eventModel',
//            'dayOfWeek', 'calendar', 'currentDay', 'numberDays', 'month', 'monthName', 'year'));
    }


    public function getYearlyCalendarList($academic_year=null)
    {
//        return $academic_year;
        $daysOfMonth = array('1', '2', '3', '4', '5', '6', '7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31');
        $ac_calendar_head = AcademicCalendarHead::get();
        if($academic_year==null){
            $dateComponents = getdate();
            $year = $dateComponents['year'];
            $yr = $year;
            $year_arr = [];
            for($i=1; $i<=10; $i++){
                $year_arr[] = $yr;
                $yr-=1;
            }
        }else{
            $year = $academic_year;

            $dateComponents = getdate();
            $yer = $dateComponents['year'];
            $yr = $yer;
            $year_arr = [];
            for($i=1; $i<=10; $i++){
                $year_arr[] = $yr;
                $yr-=1;
            }
        }


        $data = [];

        for($m=1; $m<=12; ++$m){
            $month_name = date('F', mktime(0, 0, 0, $m, 1));//mktime(hour,minute,second,month,day,year,is_dst)

            if($month_name=='January'){
                $data[0][] = 'Jan';

                $nmonth_id = date('m',strtotime('January'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));

                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[0][1] =  $day_name;

            }else if($month_name=='February'){
                $data[1][] = 'Feb';

                $nmonth_id = date('m',strtotime('February'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 1;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[1][1] =  $day_name;


            }else if($month_name=='March'){
//                $data[] = 'Mar';
                $data[2][] = 'Mar';

                $nmonth_id = date('m',strtotime('March'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[2][1] =  $day_name;

            }else if($month_name=='April'){
//                $data[] = 'Apr';

                $data[3][] = 'Apr';

                $nmonth_id = date('m',strtotime('Apr'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[3][1] =  $day_name;

            }else if($month_name=='May'){
//                $data[] = 'May';

                $data[4][] = 'May';

                $nmonth_id = date('m',strtotime('May'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[4][1] =  $day_name;

            }else if($month_name=='June'){
//                $data[] = 'Jun';

                $data[5][] = 'Jun';

                $nmonth_id = date('m',strtotime('Jun'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[5][1] =  $day_name;

            }else if($month_name=='July'){
//                $data[] = 'Jul';

                $data[6][] = 'Jul';

                $nmonth_id = date('m',strtotime('Jul'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[6][1] =  $day_name;

            }else if($month_name=='August'){
//                $data[] = 'Aug';

                $data[7][] = 'Aug';

                $nmonth_id = date('m',strtotime('Aug'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                           $ev['title'][] = $v->title;
                           $ev['title_color_id'][] = $v->subhead_color_id;
                           $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                           $ev['activate_date'][] =$v->activate_date;
                           $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

//                        return $day_name;
                        $i += 1;
                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[7][1] =  $day_name;

            }else if($month_name=='September'){
//                $data[] = 'Sep';

                $data[8][] = 'Sep';

                $nmonth_id = date('m',strtotime('Sep'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[8][1] =  $day_name;

            }else if($month_name=='October'){
//                $data[] = 'Oct';

                $data[9][] = 'Oct';

                $nmonth_id = date('m',strtotime('Oct'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[9][1] =  $day_name;

            }else if($month_name=='November'){
//                $data[] = 'Nov';

                $data[10][] = 'Nov';

                $nmonth_id = date('m',strtotime('Nov'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[10][1] =  $day_name;

            }else if($month_name=='December'){
//                $data[] = 'Dec';

                $data[11][] = 'Dec';

                $nmonth_id = date('m',strtotime('Dec'));
                $date = $year.'-'.$nmonth_id.'-'.'01';

                $end = $year.'-'.$nmonth_id.'-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while(strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = Event::where('activate_date',$date)->where('status', 1)->with('academicCalendarHead')->get();

                    if(count($event)>0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] =$v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    }else{
//                        $event_details = "";
                        $day_name[$i][1] = [];
                        $day_name[$i][2] = [];
                        $day_name[$i][3] = [];
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = [];
                        $i+=1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[11][1] =  $day_name;

            }
        }

        return response()->json([$daysOfMonth,$ac_calendar_head, $data, $year, $year_arr], 200, [], JSON_NUMERIC_CHECK);
    }



    public function getCalendarSubHeadColorList($acSubHeadId)
    {
       $sub_head_color = AcademicCalendarSubheadColor::where('academic_calendar_head_id', $acSubHeadId)->get();

        return $sub_head_color;

//        return response()->json($acSubHeadId, 200, [], JSON_NUMERIC_CHECK);

    }







}
