<?php

namespace App\Http\Controllers\Site\Employee\Attendance;

use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Event\Event;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\Site\SiteInfo;
use App\Models\User\EmployeeHistory;
use App\Traits\Site\Leave\Employee\LeaveFunction;
use Auth;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use DateInterval;
use DatePeriod;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Site\Duty\Employee\DutyFunction;
use Session;
use PDF;
use Exception;
use Response;


class AttendanceReportController extends Controller
{
    use LeaveFunction, DutyFunction;

    private $employeeAttendance;
    private $employee;
    private $siteInfo;


    public function __construct(EmployeeAttendance $employeeAttendance, Employee $employee, SiteInfo $siteInfo)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->employeeAttendance = $employeeAttendance;
        $this->employee = $employee;
        $this->siteInfo = $siteInfo;
    }


    public function getAttendanceReport($acc_shift_id, $att_date)
    {
        try {
            $report_tittle = 'Employee Attendance Report';
            $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));


            if ($acc_shift_id != '0') {
                $emp_list = $this->employeeAttendance->with(['employee' => function ($query) {
                    $query->select(['id', 'designation_id']);
                }])->with('employee.designation')
                    ->whereHas('shiftDetail', function ($q) use ($acc_shift_id) {
                        $q->where('academic_shift_id', $acc_shift_id);
                    })->where('present_date', $att_date)
                    ->get();
            } else {
                $emp_list = $this->employeeAttendance->with(['employee' => function ($query) {
                    $query->select('id', 'designation_id');
                }])->where('present_date', $att_date)
                    ->get();
            }


            $path = public_path() . '/pdf';

            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.report', compact('att_date', 'report_tittle', 'emp_list', 'site'));


            // $pdf->save($path.'/my_pdf_name.pdf', 'UTF-8');
            // return response()->download($path.'/my_pdf_name.pdf');


            return $pdf->stream(time() . '-shift-details.pdf');
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function getDateAndShiftWiseReport(Request $request)
    {
        try {


            $att_date = $request->att_date;
            $acc_shift_id = $request->acc_shift_id;


            $report_tittle = 'Employee Attendance Report';
            $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));

            // 2024-04-21
            if ($acc_shift_id) {
                $emp_list = $this->employeeAttendance->with(['employee' => function ($query) {
                    $query->select(['id', 'designation_id'])
                    ->orderBy('employee_serial', 'ASC');
                }])->with('employee.designation')
                    ->whereHas('shiftDetail', function ($q) use ($acc_shift_id) {
                        $q->where('academic_shift_id', $acc_shift_id);
                    })
                    ->where('present_date', $att_date)

                    ->get();
            } else {
                $emp_list = $this->employeeAttendance->with(['employee' => function ($query) {
                    $query->select('id', 'designation_id')
                        ->orderBy('employee_serial', 'ASC');
                }])->where('present_date', $att_date)
                    ->get();
            }

            $emp_list = $emp_list->sortBy(function($attendance) {
                return $attendance->employee->employee_serial ?? 0;
            })->values();

            $report_tittle2 = "";


            $path = storage_path() . '/pdf';

            $time = Auth::user()->id . '-' . Carbon::now()->unix();

            //view('default.admin.site.employee.attendance.report.report', compact('att_date', 'report_tittle', 'emp_list', 'site'));
            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.report', compact('att_date', 'report_tittle2', 'report_tittle', 'emp_list', 'site'));


            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
            //  return response()->download($path.'/'.$time.'.pdf');

            $name = $time . '.pdf';

            return Response::json(['message' => $name], 200);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function getYearlyReport(Request $request)
    {
        try {

            //  \Log::info($request);
            //return $request;

            $report_type = $request->report_type;
            $year = $request->year;
            $emp_id = $request->user_id;
            $acc_shift_id = $request->acc_shift_id;


            if ($report_type == 2) { //all month wise


                if (!$emp_id || !$year) {
                    throw new Error('Employee Or Year Not Selected!');
                }


                $the_acc_year = AcademicYear::findOrFail($year);


                $start_date = $the_acc_year->start_date;
                $end_date = $the_acc_year->end_date;


                $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));


                $report_tittle = 'Employee Yearly Attendance Report';


                $employee_full_name = $this->employee
                    ->where('id', $emp_id)
                    ->first()->full_name ?? '';


                $data = [];
                $sl = 0;

                $start = new DateTime($start_date);
                $start->modify('first day of this month');
                $end = new DateTime($end_date);
                $end->modify('first day of next month');
                $interval = DateInterval::createFromDateString('1 month');
                $period = new DatePeriod($start, $interval, $end);




                foreach ($period as $key => $dt) {
                    //                    return $dt->toString();

                    $year = $dt->format("Y");
                    $month = $dt->format("m");


                    //                      dd($year,$month);


                    $attendances = $this->employeeAttendance
                        /*   ->whereHas('shiftDetail',function ($query)use ($acc_shift_id) {
                               $query->where('academic_shift_id', $acc_shift_id);
                           })*/
                        ->where('user_id', $emp_id)
                        ->where('present_year', $year)
                        ->where('present_month', $month)
                        ->get();

                    \Log::info($attendances->count());
                    //   $acc_calendar_head_ids = AcademicCalendarHead::where('head_key', 'holiday')->pluck('id');

                    $holidays_number = Event::where('year', $year)
                        ->where('month', $month)
                        // ->whereIn('academic_calendar_head_id', $acc_calendar_head_ids)
                        ->where('attendance_active_for_employee', 0)
                        ->count();
                    $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

                    $numberDays = date('t', $firstDayOfMonth);

                    $total_class = $numberDays - $holidays_number;

                    //===========================employee leave days===========================

                    $employee_history_id = EmployeeHistory::where('user_id', $emp_id)->where('status', 1)->first();

                    $emp_history_details = SiteEmployeeLeaveHistory::where('employee_history_id', $employee_history_id->id)
                        ->whereMonth('from_date', $month)
                        ->where('leave_status', 'approved')
                        ->get();

                    $leave_count = 0;
                    foreach ($emp_history_details as $item) {
                        $leave_count = +$item->spend_leave_days;
                    }
                    //===========================end employee leave days===========================


                    $attendances_count = $attendances->count();
                    $absent_count = ($total_class - $attendances_count);
                    $leave_count = $attendances->count();
                    $late_count = $attendances->where('late_status', 1)->count();


                    //   dd($emp_count);


                    $data[$sl]['total_class'] = $total_class;
                    $data[$sl]['total_present'] = $attendances_count;
                    $data[$sl]['total_absent'] = $absent_count ?? 'n/a';
                    $data[$sl]['total_leave'] = $leave_count ?? 'n/a';
                    $data[$sl]['total_late'] = $late_count ?? 'n/a';
                    $data[$sl]['year'] = $year;
                    $data[$sl]['month'] = $month;

                    $sl++;
                }

                //     dd($data);

                $pdf = PDF::loadView('default.admin.site.employee.attendance.report.emp-yearly-report', compact('employee_full_name', 'start_date', 'end_date', 'report_tittle', 'data', 'site'));
                //  return $pdf->stream(time() . '-routine.pdf');


                $path = storage_path() . '/pdf';

                $time = Auth::user()->id . '-' . Carbon::now()->unix();


                $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
                //  return response()->download($path.'/'.$time.'.pdf');

                $name = $time . '.pdf';

                return Response::json(['message' => $name], 200);
            }
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function getMonthAndShiftWiseReport(Request $request)
    {
        // try {
        //   dd($request->all());

        $att_type = $request->report_type; // emp wise
        $emp_id = $request->user_id; // emp wise
        $acc_shift_id = $request->acc_shift_id; // emp wise
        $start_date = $request->date_range['start'];
        $end_date = $request->date_range['end'];

        //   \Log::info($request);


        $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));
        $shift_name = 'n/a';

        $data = [];
        $employee_full_name = '';

        if ($att_type == 1) {


            // if (!$acc_shift_id) {
            //     throw new Error('Shift Not Selected!');
            // }1

            $report_tittle = 'Employee Date and Shift Attendance Report';

            if ($acc_shift_id) {
                $shift_name = AcademicShift::findOrFail($acc_shift_id)->shift_name;
            } else {
                $shift_name = 'n/a';
            }

            $begin = new DateTime($start_date);
            $end = new DateTime($end_date);


            $interval = DateInterval::createFromDateString('1 day');
            $period = new DatePeriod($begin, $interval, $end);


            $sl = 0;


            foreach ($period as $key => $dt) {

                $date = $dt->format("Y-m-d");


                $attendances = $this->employeeAttendance
                    ->when(isset($acc_shift_id), function ($query) use ($acc_shift_id) {
                        return $query->whereHas('shiftDetail', function ($query) use ($acc_shift_id) {
                            $query->where('academic_shift_id', $acc_shift_id);
                        });
                    })
                    ->where('present_date', $date)
                    ->get();
                //   dd($attendances);

                $employee = $this->employee
                    ->when(isset($acc_shift_id), function ($query) use ($acc_shift_id) {
                        return $query->whereHas('empShifts', function ($q) use ($acc_shift_id) {
                            $q->where('academic_shift_id', $acc_shift_id);
                        });
                    })
                    ->where('dept_join_date', '<', $date)
                    ->get();
                //  dd($employee);
                //===================leave days==================

                $leave_days = $this->getTotalLeaveByDay($date, $acc_shift_id, $employee);
                $duty_days = $this->getTotalDutyByDay($date, $acc_shift_id, $employee);

                //===================end leave days==================

                $attendances_count = $attendances->count();
                $emp_count = $employee->count();

                $late_count = $attendances->where('late_status', 1)->count();

                $present_leave_duty = $attendances_count + $leave_days + $duty_days;

                $absent_count = ($emp_count - $present_leave_duty);


                $data[$sl]['total_emp'] = $emp_count;
                $data[$sl]['total_present'] = $attendances_count;
                $data[$sl]['total_absent'] = $absent_count ?? 'n/a';
                $data[$sl]['total_leave'] = $leave_days ?? 0;
                $data[$sl]['total_duty'] = $duty_days ?? 0;
                $data[$sl]['total_late'] = $late_count ?? 'n/a';
                $data[$sl]['date'] = $date;

                $sl++;
            }



            // view('default.admin.site.employee.attendance.report.monthly-report-all-emp', compact('start_date', 'end_date', 'report_tittle',
            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.monthly-report-all-emp', compact(
                'start_date',
                'end_date',
                'report_tittle',
                'data',
                'shift_name',
                'site'
            ));
            //       return $pdf->stream(time() . '-routine.pdf');


        } elseif ($att_type == 2) {


            if (!$emp_id || !$request->date_range) {
                throw new Error('Employee Or Date Not Selected!');
            }


            $employee_full_name = $this->employee
                ->where('id', $emp_id)
                ->first()->full_name ?? '';


            $begin = new DateTime($start_date);
            $end = new DateTime($end_date);

            $interval = DateInterval::createFromDateString('1 day');
            $period = new DatePeriod($begin, $interval, $end);

            $sl = 0;

            foreach ($period as $key => $dt) {

                $date = $dt->format("Y-m-d");

                $emp_attendances_check = $this->employeeAttendance
                    ->where('user_id', $emp_id)
                    ->where('present_date', $date)
                    ->first();

                if ($emp_attendances_check) {
                    $data[$sl]['data'] = $emp_attendances_check;
                    $data[$sl]['date'] = $date;
                    $data[$sl]['type'] = $emp_attendances_check;
                } else {

                    $day_off = Event::where('activate_date', $date)
                        ->where('status', 1)
                        ->where('attendance_active_for_employee', 0)
                        ->first();

                    if ($day_off) {
                        $data[$sl]['data'] = null;
                        $data[$sl]['date'] = $date;
                        $data[$sl]['type'] = 'Day Off';
                    } else {
                        $leave_status = $this->getEmployeeInLeave($emp_id, $date);
                        if ($leave_status) {
                            $data[$sl]['data'] = null;
                            $data[$sl]['date'] = $date;
                            $data[$sl]['type'] = 'Leave';
                        } else {
                            $duty_status = $this->getEmployeeInDuty($emp_id, $date);
                            if ($duty_status) {
                                $data[$sl]['data'] = null;
                                $data[$sl]['date'] = $date;
                                $data[$sl]['type'] = 'On Duty';
                            } else {
                                $data[$sl]['data'] = null;
                                $data[$sl]['date'] = $date;
                                $data[$sl]['type'] = 'Absent';
                            }
                        }
                    }
                }

                $sl++;
            }



            $report_tittle = 'Employee Date and Shift Attendance Report';
            $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));


            if (count($data) < 1) {
                return Response::json(['message' => 'No Data Found For The Criteria'], 410);
            }


            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('start_date', 'end_date', 'employee_full_name', 'report_tittle', 'data', 'site'));
        }

        //dd('hj');


        // $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('start_date', 'end_date', 'employee_full_name', 'report_tittle', 'data', 'site'));
        //return $pdf->stream(time() . '-routine.pdf');


        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);


        // } catch (Exception $exception) {
        //     return Response::json(['message' => $exception->getMessage()], 410);
        // }
    }

    public function getMonthAndShiftWiseShortReport(Request $request)
    {
        // try {

        // year month wise day list
        $year = $request->year;
        $month = $request->month;
        $startOfMonth = Carbon::create($year, $month, 1);
        $endOfMonth = $startOfMonth->copy()->endOfMonth();

        $days = CarbonPeriod::create($startOfMonth, $endOfMonth);

        $daysList = [];
        foreach ($days as $key => $day) {
            $daysList[$key]['full_date'] = $day->format('Y-m-d');
            $daysList[$key]['short_date'] = $day->format('d');
        }

        // employee list
        $employees = Employee::where('user_type', 'employee')
            ->where('status', true)
            ->with('latestPhoto')
            ->select(['id', 'employee_id', 'biometric_id', 'username'])
            ->orderBy('employee_serial', 'ASC')
            ->get();


        $employee_data_list = [];
        foreach ($employees as $e_key => $emp) {

            $employee_data_list[$e_key]['employee_name'] = $emp->full_name;

            $emp_attendances = $this->employeeAttendance
                ->where('user_id', $emp->id)
                ->get();

            $sl = 0;
            $data = [];
            $employee_full_name = '';

            foreach ($daysList as $key => $dt) {

                $date = $dt['full_date'];
                $short_date = $dt['short_date'];


                $emp_attendances_check = $emp_attendances
                    ->where('present_date', $date)
                    ->first();

                $data[$sl]['date'] = $date;
                $data[$sl]['short_date'] = $short_date;

                if ($emp_attendances_check) {
                    $data[$sl]['data'] = $emp_attendances_check;
                    $data[$sl]['type'] = 'P';
                } else {

                    $day_off = Event::where('activate_date', $date)
                        ->where('status', 1)
                        ->where('attendance_active_for_employee', 0)
                        ->first();

                    if ($day_off) {
                        $data[$sl]['data'] = null;
                        $data[$sl]['type'] = 'Off';
                    } else {
                        $leave_status = $this->getEmployeeInLeave($emp->id, $date);
                        if ($leave_status) {
                            $data[$sl]['data'] = null;
                            $data[$sl]['type'] = 'L';
                        } else {
                            $duty_status = $this->getEmployeeInDuty($emp->id, $date);
                            if ($duty_status) {
                                $data[$sl]['data'] = null;
                                $data[$sl]['type'] = 'Duty';
                            } else {
                                $data[$sl]['data'] = null;
                                $data[$sl]['type'] = 'A';
                            }
                        }
                    }
                }

                $sl++;
            }


            $total_present = count(collect($data)->where('type', 'P'));
            $total_absent = count(collect($data)->where('type', 'A'));
            $total_leave = count(collect($data)->where('type', 'L'));
            $total_off_day = count(collect($data)->where('type', 'Off'));
            $total_duty = count(collect($data)->where('type', 'Duty'));

            $employee_data_list[$e_key]['employee_attendance'] = $data;
            $employee_data_list[$e_key]['total_present'] = $total_present;
            $employee_data_list[$e_key]['total_absent'] = $total_absent;
            $employee_data_list[$e_key]['total_leave'] = $total_leave;
            $employee_data_list[$e_key]['total_off_day'] = $total_off_day;
            $employee_data_list[$e_key]['total_duty'] = $total_duty;

            // dd($total_present);

        }

        $shifName = AcademicShift::findOrFail($request->acc_shift_id)->shift_name;
        $yearName = $request->year;
        $monthName = DateTime::createFromFormat('!m', $request->month)->format('F');
        $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));

        $report_tittle = '';

        //  return $employee_data_list;

        $pdf = PDF::loadView(
            'default.admin.site.employee.attendance.report.monthly-short-report-all-emp',
            compact('employee_data_list', 'daysList', 'report_tittle', 'shifName', 'yearName', 'monthName', 'site')
        );

        $time = Auth::user()->id . '-' . Carbon::now()->unix();

        $pdf->setPaper('A4', 'landscape');

        $path = storage_path() . '/pdf';



        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);


        //////////////////




        $att_type = $request->report_type; // emp wise
        $emp_id = $request->user_id; // emp wise
        $acc_shift_id = $request->acc_shift_id; // emp wise
        $start_date = $request->date_range['start'];
        $end_date = $request->date_range['end'];

        //   \Log::info($request);


        $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));
        $shift_name = 'n/a';

        $data = [];
        $employee_full_name = '';

        if ($att_type == 1) {


            // if (!$acc_shift_id) {
            //     throw new Error('Shift Not Selected!');
            // }1

            $report_tittle = 'Employee Date and Shift Attendance Report';

            if ($acc_shift_id) {
                $shift_name = AcademicShift::findOrFail($acc_shift_id)->shift_name;
            } else {
                $shift_name = 'n/a';
            }

            $begin = new DateTime($start_date);
            $end = new DateTime($end_date);


            $interval = DateInterval::createFromDateString('1 day');
            $period = new DatePeriod($begin, $interval, $end);


            $sl = 0;


            foreach ($period as $key => $dt) {

                $date = $dt->format("Y-m-d");


                $attendances = $this->employeeAttendance
                    ->when(isset($acc_shift_id), function ($query) use ($acc_shift_id) {
                        return $query->whereHas('shiftDetail', function ($query) use ($acc_shift_id) {
                            $query->where('academic_shift_id', $acc_shift_id);
                        });
                    })
                    ->where('present_date', $date)
                    ->get();
                //   dd($attendances);

                $employee = $this->employee
                    ->when(isset($acc_shift_id), function ($query) use ($acc_shift_id) {
                        return $query->whereHas('empShifts', function ($q) use ($acc_shift_id) {
                            $q->where('academic_shift_id', $acc_shift_id);
                        });
                    })
                    ->where('dept_join_date', '<', $date)
                    ->get();
                //  dd($employee);
                //===================leave days==================

                $leave_days = $this->getTotalLeaveByDay($date, $acc_shift_id, $employee);
                $duty_days = $this->getTotalDutyByDay($date, $acc_shift_id, $employee);

                //===================end leave days==================

                $attendances_count = $attendances->count();
                $emp_count = $employee->count();

                $late_count = $attendances->where('late_status', 1)->count();

                $present_leave_duty = $attendances_count + $leave_days + $duty_days;

                $absent_count = ($emp_count - $present_leave_duty);


                $data[$sl]['total_emp'] = $emp_count;
                $data[$sl]['total_present'] = $attendances_count;
                $data[$sl]['total_absent'] = $absent_count ?? 'n/a';
                $data[$sl]['total_leave'] = $leave_days ?? 0;
                $data[$sl]['total_duty'] = $duty_days ?? 0;
                $data[$sl]['total_late'] = $late_count ?? 'n/a';
                $data[$sl]['date'] = $date;

                $sl++;
            }



            // view('default.admin.site.employee.attendance.report.monthly-report-all-emp', compact('start_date', 'end_date', 'report_tittle',
            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.monthly-report-all-emp', compact(
                'start_date',
                'end_date',
                'report_tittle',
                'data',
                'shift_name',
                'site'
            ));
            //       return $pdf->stream(time() . '-routine.pdf');


        } elseif ($att_type == 2) {


            if (!$emp_id || !$request->date_range) {
                throw new Error('Employee Or Date Not Selected!');
            }


            $employee_full_name = $this->employee
                ->where('id', $emp_id)
                ->first()->full_name ?? '';


            $begin = new DateTime($start_date);
            $end = new DateTime($end_date);

            $interval = DateInterval::createFromDateString('1 day');
            $period = new DatePeriod($begin, $interval, $end);

            $sl = 0;

            foreach ($period as $key => $dt) {

                $date = $dt->format("Y-m-d");

                $emp_attendances_check = $this->employeeAttendance
                    ->where('user_id', $emp_id)
                    ->where('present_date', $date)
                    ->first();

                if ($emp_attendances_check) {
                    $data[$sl]['data'] = $emp_attendances_check;
                    $data[$sl]['date'] = $date;
                    $data[$sl]['type'] = $emp_attendances_check;
                } else {

                    $day_off = Event::where('activate_date', $date)
                        ->where('status', 1)
                        ->where('attendance_active_for_employee', 0)
                        ->first();

                    if ($day_off) {
                        $data[$sl]['data'] = null;
                        $data[$sl]['date'] = $date;
                        $data[$sl]['type'] = 'Day Off';
                    } else {
                        $leave_status = $this->getEmployeeInLeave($emp_id, $date);
                        if ($leave_status) {
                            $data[$sl]['data'] = null;
                            $data[$sl]['date'] = $date;
                            $data[$sl]['type'] = 'Leave';
                        } else {
                            $duty_status = $this->getEmployeeInDuty($emp_id, $date);
                            if ($duty_status) {
                                $data[$sl]['data'] = null;
                                $data[$sl]['date'] = $date;
                                $data[$sl]['type'] = 'On Duty';
                            } else {
                                $data[$sl]['data'] = null;
                                $data[$sl]['date'] = $date;
                                $data[$sl]['type'] = 'Absent';
                            }
                        }
                    }
                }

                $sl++;
            }



            $report_tittle = 'Employee Date and Shift Attendance Report';
            $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));


            if (count($data) < 1) {
                return Response::json(['message' => 'No Data Found For The Criteria'], 410);
            }


            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('start_date', 'end_date', 'employee_full_name', 'report_tittle', 'data', 'site'));
        }

        //dd('hj');


        // $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('start_date', 'end_date', 'employee_full_name', 'report_tittle', 'data', 'site'));
        //return $pdf->stream(time() . '-routine.pdf');


        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);


        // } catch (Exception $exception) {
        //     return Response::json(['message' => $exception->getMessage()], 410);
        // }
    }


    // public function getMonthlyEmpAttendanceReport()
    public function getMonthlyEmpAttendanceReport(Request $request)
    {
        try {

            /*  $month_id = $request->month_id;
              $acc_shift_id = $request->acc_shift_id;*/


            $att_type = $request->att_type; // emp wise
            $emp_id = $request->user_id; //795;// emp wise
            $start_date = $request->date_range['start'];
            $end_date = $request->date_range["end"];

            $data = [];
            $employee_full_name = '';


            if ($att_type == 1) {
            } elseif ($att_type == 2) {


                $employee_full_name = $this->employee
                    ->where('id', $emp_id)
                    ->first()->full_name ?? '';


                $begin = new DateTime($start_date);
                $end = new DateTime($end_date);

                $interval = DateInterval::createFromDateString('1 day');
                $period = new DatePeriod($begin, $interval, $end);

                $sl = 0;

                foreach ($period as $key => $dt) {

                    $date = $dt->format("Y-m-d");


                    $emp_attendances_check = $this->employeeAttendance
                        ->where('user_id', $emp_id)
                        ->where('present_date', $date)
                        ->first();

                    if ($emp_attendances_check) {
                        $data[$sl]['data'] = $emp_attendances_check;
                        $data[$sl]['date'] = $date;
                        $data[$sl]['type'] = $emp_attendances_check;
                    } else {
                        $data[$sl]['data'] = null;
                        $data[$sl]['date'] = $date;
                        $data[$sl]['type'] = 'Absent';
                    }


                    $sl++;


                    //  dd($emp_attendances_check);


                }

                //dd(($data[1]['data']==null));


                $report_tittle = 'Employee Date and Shift Attendance Report';
                $site = $this->siteInfo->findOrFail(Session::get('SITE_ID'));


                if (count($data) < 1) {
                    return Response::json(['message' => 'No Data Found For The Criteria'], 410);
                }
            }

            //dd('hj');


            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('start_date', 'end_date', 'employee_full_name', 'report_tittle', 'data', 'site'));
            return $pdf->stream(time() . '-routine.pdf');


            $path = storage_path() . '/pdf';

            $time = Auth::user()->id . '-' . Carbon::now()->unix();

            $pdf = PDF::loadView('default.admin.site.employee.attendance.report.month-wise-report', compact('month_name', 'year', 'report_tittle', 'emp_list', 'site'));


            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
            //  return response()->download($path.'/'.$time.'.pdf');

            $name = $time . '.pdf';

            return Response::json(['message' => $name], 200);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function openReport($name)
    {
        try {


            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $name);

            // if ($name_split[0] != $user_id) {
            //     return 'You are unauthorized!';
            // }


            if (!file_exists(storage_path('pdf/' . $name))) {

                return "The file existed only for 1 day and deleted today!";
            }


            return response()->file(storage_path('pdf/' . $name));
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }
}
