<?php

namespace App\Http\Controllers\Site\Employee\Report;

use App\Forms\DataHelper;
use App\Models\Site\Employee\Employee;
use App\Models\User\EmployeeHistory;
use App\Traits\Site\GlobalFunctionsTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use View;

class EmployeeReportController extends Controller
{


    use DataHelper, GlobalFunctionsTrait;

    private $carbon_now;

    private $employeeHistory;
    private $employee;


    public function __construct(Employee $employee, EmployeeHistory $employeeHistory)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->employeeHistory = $employeeHistory;
        $this->employee = $employee;

    }


    public function reportMaster()
    {

/*
        $empUserlist = $this->employee->with(['latestPhoto', 'gender', 'religion', 'designation',
            'presentCountry', 'permanentCountry', 'presentDivision', 'permanentDivision', 'presentDistrict',
            'permanentDistrict', 'presentThana', 'permanentThana', 'bloodGroup'])
            ->get()->transform(function ($value){
                return [
                    'permanent_address'=>$value->permanent_address.' '.$value->permanent_thana->thana_name.' '.
                ];
            });

        $card_data = $empUserlist;

        //  dd($empUserlist,$empHistory);


      return view('default.site.employee.id-card.card-report-back', compact('card_data'));
        $view = View::make('default.site.employee.id-card.card-report-back', compact('card_data'));


        $contents = $view->render();
//            return $contents;
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
        $mpdf->Output();
        return $contents;*/


        $viewType = 'Employee Report Master';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.employee.report.report-master', compact('viewType'));
    }


    public function getStudents(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;


            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';


            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
                throw new Error('Select * marked Fields');
            }
            $student_list = [];


            $student_list = $this->studentHistory
                ->where('academic_version_id', $data['academic_version_id'])
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', $status)
                ->whereHas('student', function ($q) use ($search_txt, $txt) {
                    $q->where('status', 1)
                        ->when($search_txt, function ($q) use ($txt) {
                            return $q->where(function ($query) use ($txt) {
                                $query->where('username', 'LIKE', $txt)
                                    ->orWhere('email', 'LIKE', $txt)
                                    ->orWhere('contact_number', 'LIKE', $txt)
                                    ->orWhereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);

                            });
                        });
                })
                ->with(['student' => function ($q) {
                    $q->select('user_type', 'id', 'username');
                }])
                //->orderByTranslation('first_name', 'ASC')
                ->where('status', 1)
                ->select('id', 'user_id')
                ->paginate($paginate);


            if (count($student_list) < 1) {
                throw new Error('No Student Found!');
            }


            return Response::json($student_list, 200);

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function getTotListPdf(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;

            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
                throw new Error('Select * marked Fields');
            }


            $student_history = $this->studentHistory
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', 1)
                ->whereHas('student', function ($q) {
                    $q->where('status', 1);
                })
                ->with(['student' => function ($q) {
                    $q->select('user_type', 'id', 'username', 'contact_number', 'date_of_birth');
                }])
                ->where('status', 1)
                // ->select('id', 'user_id','academic_subject_ids','')
                //->limit(5)
                ->get();


            if (count($student_history) < 1) {
                throw new Error('No Student Found!');
            }

            $page_tittle = "Student Tot Report";
            $report_tittle = "<b>Student Tot Report</b> <br/>";
            $report_tittle2 = '';


            //  dd($student_history[0]->academic_subject_ids);

            $report_tittle .= '<b>Version:</b>' . ($student_history[0]->version->version_name ?? 'n/a');
            $report_tittle .= '<b> Year:</b>' . ($student_history[0]->year->year_name ?? 'n/a');
            $report_tittle .= ' <b> Shift:</b>' . ($student_history[0]->shift->shift_name ?? 'n/a');

            if ($data['academic_department_id'] && $student_history[0]->department) {
                $report_tittle .= ' <b>Dept:</b>' . ($student_history[0]->department->name ?? 'n/a');
            }

            if ($data['academic_class_id'] && $student_history[0]->stClass) {
                $report_tittle .= ' <br/><b>Class:</b>' . ($student_history[0]->stClass->class_name ?? 'n/a');
            }

            if ($data['academic_class_group_id'] && $student_history[0]->classGroup) {
                $report_tittle .= ' <b>Group:</b>' . ($student_history[0]->classGroup->group_name ?? 'n/a');
            }

            if ($data['academic_section_id'] && $student_history[0]->section) {
                $report_tittle .= ' <b>Section:</b>' . ($student_history[0]->section->section_name ?? 'n/a');
            }


//            return view('default.site.student.report.tort-list-report', compact('student_history', 'viewType'));


            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.tort-list-report')) {
                $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.report.tort-list-report', compact('student_history', 'page_tittle', 'report_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
            } else {
                $pdf = PDF::loadView('default.site.student.report.tort-list-report', compact('student_history', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
            }

            //  $pdf = PDF::loadView('pdf.test_pdf');
            //  return $pdf->stream('test_pdf.pdf');

            return $pdf->stream(time() . '-student-tot-list.pdf');

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function detailsPdfReport(Request $request)
    {

        try {

            $report_tittle = "<b>Student Details Report</b> <br/>";
            $history_id = $request->history_id;

            $student_history = $this->studentHistory->with(['student' => function ($query) {
                $query->orderBy('id', 'desc')->limit(1);
            }])->findOrFail($history_id);


            $report_tittle3 = '';


            $report_tittle3 .= '<b>Version:</b>' . ($student_history->version->version_name ?? 'n/a');
            $report_tittle3 .= '<b> Year:</b>' . ($student_history->year->year_name ?? 'n/a');
            $report_tittle3 .= ' <b> Shift:</b>' . ($student_history->shift->shift_name ?? 'n/a');

            if ($student_history->department) {
                $report_tittle .= ' <b>Dept:</b>' . ($student_history->department->name ?? 'n/a');
            }

            $report_tittle3 .= ' <br/><b>Class:</b>' . ($student_history->stClass->class_name ?? 'n/a');

            if ($student_history->classGroup) {
                $report_tittle3 .= ' <b>Group:</b>' . ($student_history->classGroup->group_name ?? 'n/a');
            }

            if ($student_history->section) {
                $report_tittle3 .= ' <b>Section:</b>' . ($student_history->section->section_name ?? 'n/a');
            }

            //return view('default.site.student.report.details-pdf', compact('student_history', 'viewType'));
            $report_tittle2 = '';
            $page_tittle = $student_history->student->username . " Details Report";


            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.details-pdf')) {
                $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.report.details-pdf', compact('student_history', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_tittle3'))->setPaper('a4');
            } else {
                $pdf = PDF::loadView('default.site.student.report.details-pdf', compact('student_history', 'report_tittle', 'page_tittle', 'report_tittle2', 'report_tittle3'))->setPaper('a4');
            }

            //  $pdf = PDF::loadView('pdf.test_pdf');
            //  return $pdf->stream('test_pdf.pdf');

            return $pdf->stream($student_history->student->username . '-details.pdf');
        } catch (Exception $exception) {
            return $exception->getMessage();
        }

    }


    public function getRoutinePdf(Request $requests)
    {
        //  dd($request->history_id);


        try {

            $his_id = $requests->history_id;


            if (!$his_id || !$requests->academic_period_type_id) {
                return "Please Select Period Type!";
            }


            $request = $this->studentHistory->findOrfail($his_id);

            if (!$request) {
                return "The Student History Not Found!";
            }

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
            $data['academic_period_type_id'] = $requests->academic_period_type_id == 'null' ? 0 : $requests->academic_period_type_id;


            $subject_ids = $request->academic_subject_ids[1];

            //   dd($subject_ids);

            $getRoutineDetails = $this->routineDetail
                ->with(['routineAllocations' => function ($q) use ($subject_ids) {
                    $q->whereIn('subject_id', $subject_ids);
                }])
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->orderBy('id', 'ASC')
                ->get();

            //   dd($getRoutineDetails);

            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {

                $week_array[$weekDay->weekday_name] = $getRoutineDetails->where('weekday', $weekDay->weekday_key) ?? [];

                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }

            $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week

            $report_tittle2 = "<b>Routine For:</b>" . $request->student->full_name;
            $report_tittle = $this->reportTitle($getRoutineDetails[0]);

            $br_col[] = -1;


            // return view('default.student.routine.routine-report', compact('week_array', 'headingList', 'max_col_count', 'site', 'report_tittle', 'br_col', 'report_tittle2'));
            $pdf = PDF::loadView('default.student.routine.routine-report', compact('week_array', 'headingList', 'max_col_count', 'site', 'report_tittle', 'br_col', 'report_tittle2'));
            return $pdf->stream($request->student->username . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


    public function getSiteBaseStudentStatistics(Request $request)
    {


        $data = $request->all();


        $getStudentList = StudentHistory::select('academic_year_id', 'academic_version_id', 'academic_shift_id',
            'academic_class_id', 'academic_department_id', 'academic_section_id', 'academic_class_group_id',
            'academic_student_category_id', 'academic_student_admission_type_id')
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
//            ->when($data['academic_shift_id'], function ($query) use ($data) {
//                return $query->where('academic_shift_id', $data['academic_shift_id']);
//            })
//            ->when($data['academic_class_id'], function ($query) use ($data) {
//                return $query->where('academic_class_id', $data['academic_class_id']);
//            })
//            ->when($data['academic_department_id'], function ($query) use ($data) {
//                return $query->where('academic_department_id', $data['academic_department_id']);
//            })
//            ->when($data['academic_section_id'], function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
//            ->when($data['academic_class_group_id'], function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
            ->where('status', 1)
            ->where('transfer_status', 0)
            ->get();


        $totalStudent = count($getStudentList);

        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }


        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);


                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();


                    $class_array = $this->getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present);


                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;


            }


            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;

        }


        return compact('student_count_array', 'department_present', 'class_group_present', 'section_present', 'totalStudent');


    }


    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }


            }


            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }


    public function getSiteBaseStudentAttendanceStatisticsCount(Request $request)
    {


        $date_formate = Carbon::parse($request->present_date);
        $present_date = $date_formate->format('Y-m-d');


        $data = $request->all();


        $getStudentListFull = StudentHistory::with(['attendance' => function ($query) use ($present_date) {
            $query->where('present_date', $present_date);
            $query->select('id', 'student_history_id', 'late_status');

        }])
            ->select('id', 'academic_year_id', 'academic_version_id', 'academic_shift_id',
                'academic_class_id', 'academic_department_id', 'academic_section_id', 'academic_class_group_id',
                'academic_student_category_id', 'academic_student_admission_type_id')
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
//            ->when($data['academic_shift_id'], function ($query) use ($data) {
//                return $query->where('academic_shift_id', $data['academic_shift_id']);
//            })
//            ->when($data['academic_class_id'], function ($query) use ($data) {
//                return $query->where('academic_class_id', $data['academic_class_id']);
//            })
//            ->when($data['academic_department_id'], function ($query) use ($data) {
//                return $query->where('academic_department_id', $data['academic_department_id']);
//            })
//            ->when($data['academic_section_id'], function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
//            ->when($data['academic_class_group_id'], function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
//            ->where('status', 1)
            ->where('transfer_status', 0)
            ->get();


        $getStudentLists = [];
        $getStudentList_array = Array();
        foreach ($getStudentListFull as $key => $value) {

            if ($value->attendance) {
                $getStudentList_array['student_attendance_status'] = 1;
                $getStudentList_array['late_status'] = $value->attendance->late_status;

            } else {
                $getStudentList_array['student_attendance_status'] = 0;
                $getStudentList_array['late_status'] = 0;
            }


            $getStudentLists[$key] = array_merge($getStudentList_array, $value->toArray());
        }


        $getStudentList = collect($getStudentLists);


        $totalStudent = count($getStudentList);
        $totalPresentStudent = count($getStudentList->where('student_attendance_status', 1));
        $totalLateStudent = count($getStudentList->where('late_status', 1));


        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }


        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);

            $version_arr['version_present_student_count'] = count($filtered_version_list->where('student_attendance_status', 1));
            $version_arr['version_late_student_count'] = count($filtered_version_list->where('late_status', 1));


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);

                $shift_arr['shift_present_student_count'] = count($filtered_shift_list->where('student_attendance_status', 1));
                $shift_arr['shift_late_student_count'] = count($filtered_shift_list->where('late_status', 1));


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);


                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);

                        $department_arr['department_present_student_count'] = count($filtered_department_list->where('student_attendance_status', 1));
                        $department_arr['department_late_student_count'] = count($filtered_department_list->where('late_status', 1));


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionAttendanceCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();


                    $class_array = $this->getClassGroupSectionAttendanceCount($classList, $filtered_shift_list, $class_group_present);


                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;


            }


            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;

        }


        return compact('student_count_array', 'department_present', 'class_group_present',
            'section_present', 'totalStudent', 'totalPresentStudent', 'totalLateStudent');


    }


    private function getClassGroupSectionAttendanceCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);

            $class_arr['class_present_student_count'] = count($filtered_class_list->where('student_attendance_status', 1));
            $class_arr['class_late_student_count'] = count($filtered_class_list->where('late_status', 1));


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);

                    $class_group_arr['class_group_present_student_count'] = count($filtered_class_group_list->where('student_attendance_status', 1));
                    $class_group_arr['class_group_late_student_count'] = count($filtered_class_group_list->where('late_status', 1));


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);

                        $section_arr['section_present_student_count'] = count($filtered_section_list->where('student_attendance_status', 1));
                        $section_arr['section_late_student_count'] = count($filtered_section_list->where('late_status', 1));


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);

                    $section_arr['section_present_student_count'] = count($filtered_section_list->where('student_attendance_status', 1));
                    $section_arr['section_late_student_count'] = count($filtered_section_list->where('late_status', 1));

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }


            }


            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }


}
