<?php

namespace App\Http\Controllers\Site\Employee\Routine;

use App\Forms\DataHelper;
use App\Models\Academic\AcademicSubject;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Routine\ClassTiming;
use App\Models\Site\Routine\ClassTimingDetail;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Routine\SubjectWeeklyClass;
use App\Models\Site\Routine\WeekdayClassTiming;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Traits\Site\Routine\RoutineFunction;
use Auth;
use Error;
use PDF;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class EmployeeRoutineController extends Controller
{

    use DataHelper, RoutineFunction;

    private $siteShiftClassGroupSectionSetting;
    private $routineDetail;
    private $routineAllocation;
    private $weekdayClassTiming;
    private $classTiming;
    private $classTimingDetail;
    private $academicSubject;
    private $subGroupCondSetting;
    private $weeklyClass;
    private $siteEmployeeSubject;
    private $employee;

    public function __construct(RoutineDetail $routineDetail, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting, AcademicSubject $academicSubject,
                                Employee $employee,
                                SubjectGroupConditionSetting $subGroupCondSetting, SubjectWeeklyClass $weeklyClass, SiteEmployeeDepartmentClassSubject $siteEmployeeSubject,
                                RoutineAllocation $routineAllocation, WeekdayClassTiming $weekdayClassTiming, ClassTiming $classTiming, ClassTimingDetail $classTimingDetail)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->routineDetail = $routineDetail;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->routineAllocation = $routineAllocation;
        $this->weekdayClassTiming = $weekdayClassTiming;
        $this->classTiming = $classTiming;
        $this->classTimingDetail = $classTimingDetail;
        $this->academicSubject = $academicSubject;
        $this->subGroupCondSetting = $subGroupCondSetting;
        $this->weeklyClass = $weeklyClass;
        $this->siteEmployeeSubject = $siteEmployeeSubject;
        $this->employee = $employee;
    }


    public function index()
    {
        try {
            $viewType = 'Routine Master View';
            return view('default.admin.site.employee.routine.master', compact('viewType'));
        } catch (Exception $exception) {
        }
    }

    public function getRoutineDetails(Request $request)
    {
        //  DB::beginTransaction();

        try {
            $message = 'Nothing';

            $emp_id = \Auth::user()->id;

            $data = [];
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;

            if (!$data['academic_year_id'] || !$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }


            $headingList = [];


            $getRoutineDetails = $this->routineDetail
                ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id);
                })->with(['routineAllocations' => function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id)
                        ->with(['employee' => function ($q1) use ($emp_id) {
                            $q1->select(['id']);
                        }]);
                }])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->orderBy('start_time')
                ->get();


            //  dd($getRoutineDetails);


            if (count($getRoutineDetails) < 1) {// no routine found

                throw new Error('No Routine Found!');
            }


            $message = 'Generated At ' . ($getRoutineDetails[0]->created_at ?? '');
            $weekDays = array();
            $data = [];
            foreach ($this->getWeekDay() as $k => $weekDay) {
                $weekDays[$k] = $weekDay;
                $data[$k]['week'] = $weekDay->weekday_name;

                $ff = $getRoutineDetails->where('weekday', $weekDay->weekday_key);

                $data[$k]['week_data'] = [];
                if (count($ff) > 0) {


                    $sl = 0;

                    $ff = $getRoutineDetails->where('weekday', $weekDay->weekday_key);
                    foreach ($ff as $kk => $value) {

                        $data[$k]['week_data'][$sl]['name'] = $value->name;
                        $data[$k]['week_data'][$sl]['start_time'] = $value->start_time;
                        $data[$k]['week_data'][$sl]['end_time'] = $value->end_time;
                        $data[$k]['week_data'][$sl]['dept'] = $value->dept->name ?? null;
                        $data[$k]['week_data'][$sl]['class'] = $value->academicClass->class_name;
                        $data[$k]['week_data'][$sl]['class_group'] = ($value->classGroup->group_name ?? null);
                        $data[$k]['week_data'][$sl]['section'] = ($value->academicSection->section_name ?? null);
                        $data[$k]['week_data'][$sl]['routine_allocations'] = $value->routineAllocations;

                        $sl = $sl + 1;

                    }

                }
            }

            //  dd($data);

            $total_period = count($getRoutineDetails);

            if (count($getRoutineDetails) <= 0) {
                return Response::json(['message' => 'Generate Routine Error!'], 410);
            }

            return Response::json([$weekDays, $data, $total_period], 200);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function getRoutineForTheTeacher(Request $request)
    {
        //  DB::beginTransaction();

        try {
            $message = 'Nothing';

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;
            $data['teacher_id'] = $request->teacher_id == 'null' ? 0 : $request->teacher_id;

            //   dd( $data['academic_period_type_id']);


            if (!$data['academic_period_type_id'] || !$data['teacher_id']) {
                return Response::json(['message' => 'Select Period Type Or Teacher'], 410);
            }

            $getRoutineDetails = $this->routineDetail
                ->whereHas('routineAllocations', function ($q) use ($data) {
                    $q->where('employee_id', $data['teacher_id']);
                })
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('status', true)
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->with(['routineAllocations' => function ($q) use ($data) {
                    $q->where('employee_id', $data['teacher_id']);
                }, 'academicClass', 'academicSection', 'classGroup', 'routineAllocations.room', 'routineAllocations.subject'])
                //   ->groupBy(['academic_class_id','start_time','weekday'])
                ->orderBy('start_time', 'ASC')
                ->get();


            //  dd($data);


            if (count($getRoutineDetails) >= 1) {//create weekday history first time for a section

                $message = 'Generated First Time At ' . ($getRoutineDetails[0]->created_at ?? '');

            } else {
                $message = 'No Routine Found!';
            }

            $weekDays = array();
            foreach ($this->getWeekDay() as $k => $weekDay) {
                $weekDays[$k] = $weekDay;
            }


            $total_period = count($getRoutineDetails);

            if (count($getRoutineDetails) <= 0) {
                return Response::json(['message' => 'No Routine Found!'], 410);
            }

            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {
                $week_array[$weekDay->weekday_name] = $getRoutineDetails->where('weekday', $weekDay->weekday_key) ?? [];
                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }


            $headingList = [];

            for ($i = 0; $i < $max_col_count; $i++) {
                $headingList[$i] = $i;
            }


            //dd($headingList);

            return Response::json([$weekDays, $getRoutineDetails, $headingList, $message, $total_period], 200);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    
    public function routineReport(Request $request)
    {

        try {
            $message = 'Nothing';


            $data = [];

            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;
            $emp_id = $request->teacher_id ?? Auth::user()->id;

            // dd($request->teacher_id , Auth::user()->id);

            if (!$data['academic_year_id'] || !$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $headingList = [];

            $get_routine_details = $this->routineDetail
                ->whereHas('routineAllocations', function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id)
                        ->where('status', 1)
                        ->with(['employee' => function ($q1) use ($emp_id) {
                            $q1->select(['id']);
                        }]);
                })->with(['routineAllocations' => function ($q) use ($emp_id) {
                    $q->where('employee_id', $emp_id)
                        ->where('status', 1);
                }, 'batch'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->orderBy('start_time', 'ASC')
                ->get();

            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {
                $week_array[$weekDay->weekday_name] = $get_routine_details->where('weekday', $weekDay->weekday_key) ?? [];
                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }

            // $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week
            //  dd($get_routine_details[0]->routineAllocations);

            $total_period = count($get_routine_details);
            $report_tittle = '';
            $report_tittle2 = "<b>Total Period:</b>" . $total_period;


            $report_tittle .= "Class Routine For <b>" . (auth()->user()->full_name ?? '') . "</b>";
            $report_tittle .= "<br> <b>Year:</b>" . ($get_routine_details[0]->academicYear->year_name ?? '') . "";
            $report_tittle .= "<b> Period Type:</b>" . ($get_routine_details[0]->academicPeriodType->type_name ?? '');


            // return view('default.site.employee.routine.routine-report', compact('week_array', 'headingList', 'total_period', 'max_col_count', 'site', 'report_tittle', 'report_tittle2'));
            $pdf = PDF::loadView('default.site.employee.routine.routine-report', compact('week_array', 'total_period', 'max_col_count', 'report_tittle', 'report_tittle2'));
            return $pdf->stream(time() . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


    public function teacherPeriodAndHourReport(Request $request)
    {

        try {

            $type = $request->type;//1==accGr wise and 2 == site wise

            if (!$type) {
                return Response::json(['message' => 'Select Type'], 410);
            }


            $emps = $this->employee
                ->whereHas('activeHistory')
                ->select('id', 'username', 'email', 'employee_serial')
                //->where('username', 'e190090006')
                ->orderBy('employee_serial', 'ASC')
                //->limit(25)
                ->get();

            //  dd($emps);

            $data = [];


            foreach ($emps as $k => $emp) {

                $id = $emp->id;
                $data[$k]['id'] = $emp->id;
                $data[$k]['username'] = $emp->username;
                $data[$k]['employee_serial'] = $emp->employee_serial;
                $data[$k]['full_name'] = $emp->full_name;
                $data[$k]['allotted_hours'] = $this->getHourAllocatedToTeacher($id, $type);
                $data[$k]['allotted_periods'] = $this->getPeriodAllocatedToTeacher($id, $type);
                $data[$k]['weekly_class'] = $this->getTeacherWeeklyPeriod($emp, $type);

            }


            //    dd($data);

            if (count($data) < 1) {
                throw new Error("No Data Found!");
            }

            if ($type == 1) {
                $type = ' report for ' . Session::get('ACADEMIC_GROUP_NAME');

            } else if ($type == 2) {

                $type = ' Full report';
            }

            $report_tittle = 'Employee Wise Weekly & Assigned ' . $type;
            $report_tittle2 = "";

            // return view('default.site.employee.routine.period-hour-report', compact('week_array', 'headingList', 'total_period', 'max_col_count', 'site', 'report_tittle', 'report_tittle2'));
            $pdf = PDF::loadView('default.site.employee.routine.period-hour-report', compact('data', 'report_tittle', 'report_tittle2'));
            return $pdf->stream(time() . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


}
