<?php

namespace App\Http\Controllers\Site\EmployeeLeave;

use App\Models\Academic\AcademicFiscalYear;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Designation\Designation;
use App\Models\Gender\Gender;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveGenerate;
use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Employee\Employee;
use Response;
use Session;

class SiteLeavePolicyController extends Controller
{
    private $siteLeavePolicy;
    private $siteInfo;
    private $academicLeaveType;
    private $academicLeaveCategory;
    private $designation;
    private $academicFiscalYear;
    private $gender;
    private $siteInfoSetting;

    public function __construct(SiteLeavePolicy $siteLeavePolicy, SiteInfo $siteInfo, AcademicLeaveType $academicLeaveType,
                                AcademicLeaveCategory $academicLeaveCategory, Designation $designation, AcademicFiscalYear $academicFiscalYear, Gender $gender, SiteInfoSetting $siteInfoSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteLeavePolicy = $siteLeavePolicy;
        $this->siteInfo = $siteInfo;
        $this->academicLeaveType = $academicLeaveType;
        $this->academicLeaveCategory = $academicLeaveCategory;
        $this->designation = $designation;
        $this->academicFiscalYear = $academicFiscalYear;
        $this->gender = $gender;
        $this->siteInfoSetting = $siteInfoSetting;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Create Leave Policy';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.sites.employee-leave.leave-policy-view', compact('viewType'));
    }

    public function leaveApprove()
    {
        $viewType = 'Create Leave Policy';
        return view('default.admin.layouts.master', compact('viewType'));

//        return view('default.admin.sites.employee-leave.leave-approve-view', compact('viewType'));
    }


    public function leaveTypeLeaveCategoryDesignationList(Request $request)
    {

        $academic_leave_type = $request->searchWithAcademicLeaveType;
        $policy = $request->searchWithPolicy;
        $academic_leave_category = $request->searchWithacademicLeaveCategory;
        $designation = $request->searchWithdesignation;
        $paginate = $request->paginate;

        $leave_policy_list = $this->siteLeavePolicy->with('academicLeaveType','academicLeaveCategory','designation')
            ->when($academic_leave_type, function($query) use($academic_leave_type){
                return $query->whereHas('academicLeaveType', function ($q) use ($academic_leave_type){
                    $q->where('id', $academic_leave_type);
                });
            })
            ->when($academic_leave_category, function($query) use($academic_leave_category){
                return $query->whereHas('academicLeaveCategory', function ($q) use ($academic_leave_category){
                    $q->where('id', $academic_leave_category);
                });
            })
            ->when($designation, function($query) use($designation){
                return $query->whereHas('designation', function ($q) use ($designation){
                    $q->where('id', $designation);
                });
            })
            ->when($policy, function($query) use($policy){

                $query->where('id', $policy);

            })
            ->orderBy('id','ASC')
            ->paginate($paginate);

        $leave_policy_list_for_search = $this->siteLeavePolicy->get();




        $siteInfoSettingDetails =  $this->siteInfoSetting->where('site_id', Session::get('SITE_ID'))->first();

         $defined_designation_ids=Employee::whereIn('designation_id', explode(',',$siteInfoSettingDetails->designation_ids))->pluck('designation_id')->unique();


        $designation_list = $this->designation->whereIn('id',$defined_designation_ids)->get();

        $leave_type_list = $this->academicLeaveType->whereIn('id',  explode(',', $siteInfoSettingDetails->academic_leave_type_ids))
                            ->get();

        $leave_ctegory_list = $this->academicLeaveCategory->whereIn('id', explode(',', $siteInfoSettingDetails->academic_leave_cetagory_ids))->get();


       $academic_fiscal_year_list = $this->academicFiscalYear->whereIn('id', explode(',', $siteInfoSettingDetails->academic_fiscal_year_ids))
                                ->orderBy('serial_no','DESC')
                                ->get();
      //  $academic_year_list = AcademicYear::whereIn('id', explode(',', $siteInfoSettingDetails->academic_year_ids))->orderBy('serial_no','DESC')->get();

        $gender_list = $this->gender->whereIn('id', explode(',', $siteInfoSettingDetails->gender_ids))->get();


        return response()->json([$leave_policy_list, $leave_type_list, $leave_ctegory_list, $designation_list, $academic_fiscal_year_list, $gender_list, $leave_policy_list_for_search], 200, [], JSON_NUMERIC_CHECK);

    }

    public function getLeavePolicyList()
    {
        $leave_policy_list = $this->siteLeavePolicy->get();
        return response()->json($leave_policy_list, 200, [], JSON_NUMERIC_CHECK);

    }

    public function searchedLeavePolicyList(Request $request)
    {
//        return $request;

        $academic_leave_type = $request->searchWithAcademicLeaveType;
        $policy = $request->searchWithPolicy;
        $academic_leave_category = $request->searchWithacademicLeaveCategory;
        $designation = $request->searchWithdesignation;
        $paginate = $request->paginate;

        $leave_policy_list = $this->siteLeavePolicy->with('academicLeaveType','academicLeaveCategory','designation')
            ->when($academic_leave_type, function($query) use($academic_leave_type){
                return $query->whereHas('academicLeaveType', function ($q) use ($academic_leave_type){
                    $q->where('id', $academic_leave_type);
                });
            })
            ->when($academic_leave_category, function($query) use($academic_leave_category){
                return $query->whereHas('academicLeaveCategory', function ($q) use ($academic_leave_category){
                    $q->where('id', $academic_leave_category);
                });
            })
            ->when($designation, function($query) use($designation){
                return $query->whereHas('designation', function ($q) use ($designation){
                    $q->where('id', $designation);
                });
            })
            ->when($policy, function($query) use($policy){

                $query->where('id', $policy);

            })
            ->orderBy('id','ASC')
            ->paginate($paginate);

        return $leave_policy_list;

//        $leave_policy_lists = $this->siteLeavePolicy->with('academicLeaveType','academicLeaveCategory','designation')->whereHas('academicLeaveType', function($q) use($searchItem) {
//            $q->where('name', 'LIKE', $searchItem);
//        })->get();
//        if(count($leave_policy_lists)>0){
//            return $leave_policy_lists;
//        }else{
//            $leave_policy_lists = $this->siteLeavePolicy->with('academicLeaveType','academicLeaveCategory','designation')->whereHas('academicLeaveCategory', function($q) use($searchItem) {
//                $q->where('name', 'LIKE', $searchItem);
//            })->get();
//            if (count($leave_policy_lists)>0){
//                return $leave_policy_lists;
//            }else{
//                $leave_policy_lists = $this->siteLeavePolicy->with('academicLeaveType','academicLeaveCategory','designation')->whereHas('designation', function($q) use($searchItem) {
//                    $q->where('name', 'LIKE', $searchItem);
//                })->get();
//                if(count($leave_policy_lists)>0){
//                    return $leave_policy_lists;
//                }else{
//                    $leave_policy_lists = $this->siteLeavePolicy->with('academicLeaveType','academicLeaveCategory','designation')->where('policy_title', 'LIKE', $searchItem)->get();
//                    if(count($leave_policy_lists)>0){
//                        return $leave_policy_lists;
//                    }
//                }
//            }
//        }

    }

    public function createLeavePolicy(Request $request)
    {
//        return $request;

            $this->validate($request,[

                'academicLeaveType' => 'required',
                'academicLeaveCategory' => 'required',
                'designation' => 'required',
                'leaveDays' => 'required',
                'policyTitle' => 'required',


            ]);



        $siteLeavePolicyf=SiteLeavePolicy::create([
            'academic_leave_type_id' => $request->academicLeaveType,
            'academic_leave_category_id' => $request->academicLeaveCategory,
            'policy_title' => $request->policyTitle,
            'leave_days' => $request->leaveDays,
            'add_to_next_year' => $request->addToNextYear,
            'wages_payable' => $request->wagesPolicy,
            'employee_designation_id' => $request->designation,
            'policy_details' => $request->policyDetails,
            'multiple_generate' => $request->multipleGenerate,
            'gender_id' => $request->gender_id,
            'status' => $request->status
        ]);
        return ['message' => 'Successfully Saved!'];


    }

    public function updateLeavePolicy(Request $request)
    {
//        return $request;
        $this->validate($request,[
            'academicLeaveType' => 'required',
            'academicLeaveCategory' => 'required',
            'designation' => 'required',
            'leaveDays' => 'required',
            'policyTitle' => 'required',
        ]);


        $leavePolicyUpdate = $this->siteLeavePolicy->findOrFail($request->id);

        $leavePolicyUpdate->update([
            'academic_leave_type_id' => $request->academicLeaveType,
            'academic_leave_category_id' => $request->academicLeaveCategory,
            'policy_title' => $request->policyTitle,
            'leave_days' => $request->leaveDays,
            'add_to_next_year' => $request->addToNextYear,
            'wages_payable' => $request->wagesPolicy,
            'employee_designation_id' => $request->designation,
            'policy_details' => $request->policyDetails,
            'multiple_generate' => $request->multipleGenerate,
            'gender_id' => $request->gender_id,
            'status' => $request->status
        ]);
        return Response::json(['message' => 'Information Successfully Updated!'], 200);

//        return ['message' => 'Successfully Updated!'];
    }

    public function deleteLeavePolicy($id)
    {
        //return 'ok';
        //$academicfeeToDelete = $this->academicFee->findOrFail($id);

        $leave_generate_data = SiteEmployeeLeaveGenerate::where('site_leave_policy_id', $id)->first();
        if($leave_generate_data){
            return Response::json(['message' => 'Sorry! can not be deleted! leave already genrated!'], 411);

        }
        $leavePolicyDelete = $this->siteLeavePolicy->findOrFail($id);

        $leavePolicyDelete->delete();
        return Response::json(['message' => 'Information Successfully Deleted!'], 200);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
