<?php

namespace App\Http\Controllers\Site\EmployeePanel\Exam;

use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteAnswerPaperDistributionDetail;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteExamRoutine;
use Response;

class EmployeeExamMarksEntryController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }


    public function index()
    {
        $viewType = 'Employee Exam Marks Entry Page';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.employeepanel.exam.employee-exam-marks-entry', compact('viewType'));

    }

    public function getSiteEmployeeBaseClassExaminationList(Request $request){

        $data = $request->all();

        $examinationAll = SiteExamDeclares::with(['examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
//            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
//            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
//                return $query->where('academic_session_id', $data['academic_session_id']);
//            })
         //   ->where('exam_declared_by','site')
            ->distinct('examination_id')
            ->get(['examination_id']);


        $declaredExaminationIds=$examinationAll->pluck('examination_id')->unique();

        $getEmployeeExaminationids= SiteAnswerPaperDistributionDetail::where('user_id', Auth::id())
            ->whereIn('examination_id', $declaredExaminationIds)
            ->pluck('examination_id')->unique();

        $examinationList=Examination::whereIn('id', $getEmployeeExaminationids)->get();

        return $examinationList;
    }

    public function getSiteEmployeeBaseExaminationSubjectList(Request $request){

        $data = $request->all();

        $subjectList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
         //   ->where('exam_declared_by','site')
            ->get();

        $subject_list_array=[];
        foreach ($subjectList as $key => $value) {

            if(count($value['site_subject_group_condition_setting_ids'])>0){
                $subject_list_array[]=$value['site_subject_group_condition_setting_ids'];
            }

        }

        $collection = collect($subject_list_array);
        $collapsed = $collection->collapse();
        $subjectConditionIDs=array_unique($collapsed->pluck('id')->toArray());

     
        $getEmployeeSubject= SiteAnswerPaperDistributionDetail::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->where('user_id', Auth::id())
            ->whereIn('site_subject_group_condition_setting_id', $subjectConditionIDs)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->pluck('site_subject_group_condition_setting_id');

         //  dd($getEmployeeSubject);

        $subjectIDs_array=SubjectGroupConditionSetting::whereIn('id', $getEmployeeSubject)->get();

        return $subjectIDs_array;

    }


    public function getSiteEmployeeBaseAnswerPaperList(Request $request){

        $data = $request->all();

        $getEmployeeSubject= SiteAnswerPaperDistributionDetail::with(['department', 'stClass', 'classGroup',
            'session', 'section', 'academicExamType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->where('user_id', Auth::id())
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->orderBy('academic_session_id')
            ->get();

        return $getEmployeeSubject;

    }


    public function getSiteEmployeeBaseStudentMarksEntryList(Request $request){


        $getList=SiteAnswerPaperDistributionDetail::where('id', $request->sit_answer_paper_distribution_detail_id)
            ->first();

        $t1 = Carbon::parse($getList->marks_update_at);
        $t2 = Carbon::parse(Carbon::now());
        $timeDuration = $t2->diffInHours($t1);
        if($timeDuration>48){
           // $time_range=false;
            $time_range=true;
        }else{
            $time_range=true;
        }

        $studentIds=StudentHistory::where('academic_version_id', $getList->academic_version_id)
            ->where('academic_year_id', $getList->academic_year_id)
            ->where('academic_shift_id', $getList->academic_shift_id)
            ->where('academic_class_id', $getList->academic_class_id)

            ->when(!empty($getList['academic_department_id']), function ($query) use ($getList) {
                return $query->where('academic_department_id', $getList['academic_department_id']);
            })
            ->when(!empty($getList['academic_class_group_id']), function ($query) use ($getList) {
                return $query->where('academic_class_group_id', $getList['academic_class_group_id']);
            })
            ->when(!empty($getList['academic_section_id']), function ($query) use ($getList) {
                return $query->where('academic_section_id', $getList['academic_section_id']);
            })
            ->when(!empty($getList['academic_session_id']), function ($query) use ($getList) {
                return $query->where('academic_session_id', $getList['academic_session_id']);
            })
            ->where('student_roll_number', '>=', $getList->roll_from)
            ->where('student_roll_number', '<=', $getList->roll_to)
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($getList){
            $query->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id);
            $query->where('academic_exam_type_id', $getList->academic_exam_type_id);
            $query->with(['academicExamType']);

        },
            'studentHistory'=>function($querys) use ($getList){

                $querys->with(['classGroup', 'session', 'section']);
                $querys->select('id', 'user_id','student_roll_number_prefix', 'student_roll_number', 'academic_class_group_id', 'academic_section_id', 'academic_session_id');
                $querys->when(!empty($getList['academic_class_group_id']), function ($q) use ($getList) {
                    return $q->where('academic_class_group_id', $getList['academic_class_group_id']);
                });
            }])
            ->where('site_exam_declare_id', $getList->site_exam_declare_id)
            ->whereIn('student_history_id', $studentIds)
            ->get();

//return $declaredStudentList;

        $student_list=[];
        $class_group_present=[];
        $section_present=[];
        $session_present=[];
        foreach ($declaredStudentList as $key => $value) {

            if(count($value->siteExamDeclareStudentSubject)>0){
                $student_list[]=$value;
            }

            if($value->studentHistory->academic_class_group_id){
                $class_group_present[]=$value->studentHistory->academic_class_group_id;
            }
            if($value->studentHistory->academic_section_id){
                $section_present[]=$value->studentHistory->academic_section_id;
            }
            if($value->studentHistory->academic_session_id){
                $session_present[]=$value->studentHistory->academic_session_id;
            }

        }

        //Class Group Present
        if(count($class_group_present)>0){
            $academic_class_group_present_status=true;
        }else{
            $academic_class_group_present_status=false;
        }

        //Class Group Present
        if(count($section_present)>0){
            $academic_section_present_status=true;
        }else{
            $academic_section_present_status=false;
        }

        //Class Group Present
        if(count($session_present)>0){
            $academic_session_present_status=true;
        }else{
            $academic_session_present_status=false;
        }

        $student_asc_list=array_values(array_sort(collect($student_list), function ($value) {
            return $value['student_roll_number'];
        }));

        $getExamType=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->where('site_exam_declare_id',  $getList->site_exam_declare_id)
            ->whereIn('student_history_id', $studentIds)
            ->where('academic_exam_type_id', $getList->academic_exam_type_id)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();

        return compact('student_asc_list', 'getExamType', 'academic_class_group_present_status',
            'academic_section_present_status', 'academic_session_present_status', 'time_range');
    }



    public function siteEmployeeExamTypeStudentNumberEntry(Request $request){

        $data = $request->all();
        $examination=Examination::where('id',$request->examination_id)->first();

        $checkPermission=$this->checkExamMarkEntryPermission($data,$examination);

        if($checkPermission['status']!='200'){
            return Response::json(['message' => $checkPermission['message'], 'status' => $checkPermission['status']], $checkPermission['status']);
        }


        SiteAnswerPaperDistributionDetail::where('id', $request->sit_answer_paper_distribution_detail_id)
            ->update([
                'marks_update_at'=>Carbon::now(),
            ]);


        foreach ($request->StudentListForMarksEntry as $key => $value) {
            

            $count=0;
            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {

                if($values['obtaine_marks']>$values['subject_exam_type_mark'] || $values['obtaine_marks']<0){
                    $count++;
                }else{

                    $checkCreated=SiteExamDeclareStudentSubject::where('id', $values['id'])->first();

                    //==== this condition add for exam type countable mark      
                    if($values['exam_type_countable_marks_status']){
                        $countable_obtaine_marks = ($values['exam_type_countable_persent_of_obtain_marks'] * $values['obtaine_marks'])/100;
                    }else{
                        $countable_obtaine_marks = $values['obtaine_marks'];
                    }
                    //===


                    // $t1 = Carbon::parse($checkCreated->created_at);
                    // $t2 = Carbon::parse(Carbon::now());
                    // $duration = $t2->diffInHours($t1);
                    //&& $duration<=48
                    if($checkCreated->obtaine_marks!=$values['obtaine_marks']){
                        SiteExamDeclareStudentSubject::where('id', $values['id'])
                            ->update([
                                'countable_obtaine_marks'=>ceil($countable_obtaine_marks),
                                'obtaine_marks'=>$values['obtaine_marks'],
                                'marks_input_by'=>Auth::id(),
                                'created_at'=>Carbon::now(),
                            ]);
                    }

                }
            }
        }

        return Response::json(['message' => 'Number Entry Successfully!', 'mode' => 'Create!'], 200);

    }


      public function checkExamMarkEntryPermission($data, $examination){

            if($examination->use_key=='site_group'){ // only group exam

            $checkSetting = SiteExaminationExamTypeSetting::with(['academicExamType'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('examination_id', $data['examination_id'])
                ->orderBy('position_show')
                ->first();


                if($checkSetting){
                    if($checkSetting->examiner_exam_mark_entry_permission==false){
                        return ['status'=>'403','message' => 'You have no permission!'];
                    }
                    $deadlineInput = $checkSetting->exam_mark_entry_deadline ?? null;

                    $now = Carbon::now('Asia/Dhaka');
                    $deadline = Carbon::parse($deadlineInput, 'Asia/Dhaka');

                    if ($now->greaterThanOrEqualTo($deadline)) {
                        return ['status'=>'403','message' => 'Time is over!'];
                    }
                }

            }

            return ['status'=>'200','message' => 'pass successfully!'];

        }






}
