<?php

namespace App\Http\Controllers\Site\EmployeePanel\Exam;

use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteAnswerPaperDistributionDetail;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudent;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Exam\SiteGroupAnswerPaperDistributionDetail;
use App\Models\SiteGroup\Exam\SiteGroupExamDeclareStore;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamPeaperToken;
use Response;
use Session;

class EmployeeSiteGroupExamMarksEntryController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }


    public function index()
    {
        $viewType = 'Employee Exam Marks Entry Page';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.employeepanel.exam.employee-exam-marks-entry', compact('viewType'));

    }

    public function getSiteGroupEmployeeBaseClassExaminationList(Request $request){

        $data = $request->all();

        $site_info=SiteInfo::find(Session::get('SITE_ID'));
      
        Session::put('SITE_GROUP_ID', $site_info->site_group_id);
       //  dd(Session::all());
        $examinationAll=SiteGroupExamDeclareStore::with('examination')
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->get();


        $declaredExaminationIds=$examinationAll->pluck('examination_id')->unique();
        $declaredExamDeclareIds=$examinationAll->pluck('id')->unique();
      
        $getEmployeeExaminationids= SiteGroupAnswerPaperDistributionDetail::where('user_id', Auth::id())
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('site_group_exam_declare_id', $declaredExamDeclareIds)
            ->whereIn('examination_id', $declaredExaminationIds)
            ->pluck('examination_id')
            ->unique();

 //       $examinationList=Examination::whereIn('id', $getEmployeeExaminationids)->get();

        $ExamGroupDeclareList=$examinationAll->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id);

        return $ExamGroupDeclareList;
    }

    public function getSiteGroupEmployeeBaseExaminationSubjectList(Request $request){



        $getEmployeeSubjectIds= SiteGroupAnswerPaperDistributionDetail::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('site_group_exam_declare_id', $request->group_exam_declare_id)
            ->where('user_id', Auth::id())
            ->pluck('academic_subject_id')
            ->unique();


        $subject_array=AcademicSubject::whereIn('id', $getEmployeeSubjectIds)->get();

        return $subject_array;

    }

    public function getSiteGroupEmployeeBaseExaminationTypeList(Request $request){

        $getEmployeeExamTypeIds= SiteGroupAnswerPaperDistributionDetail::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('site_group_exam_declare_id', $request->group_exam_declare_id)
            ->where('academic_subject_id', $request->academic_subject_id)
            ->where('user_id', Auth::id())
            ->pluck('academic_exam_type_id')
            ->unique();

        $exam_type_list=AcademicExamType::whereIn('id', $getEmployeeExamTypeIds)->get();

        return $exam_type_list;

    }


   

    public function getSiteGroupEmployeeBaseStudentMarksEntryList(Request $request){



        $getList= SiteGroupAnswerPaperDistributionDetail::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('site_group_exam_declare_id', $request->group_exam_declare_id)
            ->where('academic_subject_id', $request->academic_subject_id)
            ->where('academic_exam_type_id', $request->academic_exam_type_id)
            ->where('user_id', Auth::id())
            ->get();


        $mark_type_list=[];
        $key=0;
        foreach($getList as $distribution){
            $token_from=$distribution->token_from-100000;
            $token_to=$distribution->token_to-100000;
            
            $exam_declare_student_subject_list=SiteGroupStudentExamPeaperToken::where('id', '>=', $token_from)
                ->where('id', '<=', $token_to)
                ->get();

              //  dd($getList);

            foreach($exam_declare_student_subject_list as $item){

                $answer_paper=GlobalSiteExamDeclareStudentSubject::where('id',$item->site_exam_declare_student_subject_id)
                    ->select('id','subject_exam_type_mark','pass_mark','obtaine_marks')
                    ->first();
                    
                $mark_type_list[$key]['peaper_token_no']=$item->peaper_token_no;
                $mark_type_list[$key]['pass_mark']=$answer_paper->pass_mark;
                $mark_type_list[$key]['subject_exam_type_mark']=$answer_paper->subject_exam_type_mark;
                $mark_type_list[$key]['obtaine_marks']=$answer_paper->obtaine_marks;
                $mark_type_list[$key]['exam_held_status']=$answer_paper->exam_held_status;
                $mark_type_list[$key]['exam_attendance_status']=$answer_paper->exam_attendance_status;
                $mark_type_list[$key]['site_exam_declare_student_subject_id']=$answer_paper->id;
                $mark_type_list[$key]['sit_answer_paper_distribution_detail_id']=$distribution->id;
                $key++;
            }
        }
      //  dd($mark_type_list);
       return $mark_type_list;

    }



    public function saveSiteGroupEmployeeExamTypeStudentNumberEntry(Request $request){

   
        foreach($request->StudentListForMarksEntry as $value){
            // SiteGroupAnswerPaperDistributionDetail::where('id', $value['sit_answer_paper_distribution_detail_id'])
            // ->update([
            //     'marks_update_at'=>Carbon::now(),
            // ]);
            $checkCreated=GlobalSiteExamDeclareStudentSubject::where('id', $value['site_exam_declare_student_subject_id'])->first();

            // if($values['exam_type_countable_marks_status']){
            //     $countable_obtaine_marks = ($values['exam_type_countable_persent_of_obtain_marks'] * $values['obtaine_marks'])/100;
            // }else{
            //     $countable_obtaine_marks = $values['obtaine_marks'];
            // }

            if($checkCreated->obtaine_marks!=$value['obtaine_marks']){
                GlobalSiteExamDeclareStudentSubject::where('id', $value['site_exam_declare_student_subject_id'])
                    ->update([
                        'countable_obtaine_marks'=>ceil($value['obtaine_marks']),
                        'obtaine_marks'=>ceil($value['obtaine_marks']),
                        'marks_input_by'=>Auth::id(),
                        'created_at'=>Carbon::now(),
                    ]);
            }
        }

        return Response::json(['message' => 'Number Entry Successfully!', 'mode' => 'Create!'], 200);

    }


}
