<?php

namespace App\Http\Controllers\Site\Exam\ExamRoomInvigilator;

use App\Models\Academic\AcademicShift;
use App\Models\Examinations\Examination;
use App\Models\Room\Room;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\SiteEmployeeSiteShift;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamInvigilatorRoomSetup;
use App\Models\Site\Exam\SiteExamInvigilatorSelection;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Room\SiteBaseExamRoomSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteExamRoomInvigilatorSettingController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }


    public function index()
    {
        $viewType = 'Room Invigilator setting';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.exam.site-base-exam-room-invigilator-setting', compact('viewType'));

    }


    //==================Invigilator Selection=======================

    public function getSiteYearBaseExaminationList(Request $request){



        $data = $request->all();

        $examination_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('status', true)
            ->pluck('examination_id')->unique()->values();

        $examinationlist=Examination::whereIn('id', $examination_ids)->get();

        return compact('examinationlist');

    }



    public function getExaminationBaseExamTimeList(Request $request){

        $data = $request->all();

        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->pluck('id');



        $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->orderBy('exam_start_time')
            ->pluck('exam_start_time')->unique()->filter()->values();


        $exam_date_array=[];
        $exam_date_arr=Array();
        foreach ($exam_date as $key => $value) {

            $exam_date_arr['exam_start_time']=$value;
            $exam_date_array[$key]=$exam_date_arr;
        }

        return $exam_date_array;

    }

    public function getExaminationBaseEmployeeList(Request $request){

        $data = $request->all();

        $employee_list= Employee::with(['activeHistory'=>function($query){
            $query->select('id','user_id', 'is_teacher');
        }])
            ->select('id', 'employee_serial')
            ->where('status', true)
//            ->whereIn('id', $shift_base_employee_ids)
            ->orderBy('employee_serial')
            ->get();


        $invigilator_list=SiteExamInvigilatorSelection::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->where('status', true)
            ->select('id','user_id')
            ->get();

    
    
        $shift_base_employee_shifts=SiteEmployeeSiteShift::whereIn('user_id', $employee_list->pluck('id'))
            ->where('status', true)
            ->get();

        $shift_detail=AcademicShift::get();

        $emp_shift_array=[];
        $emp_shift_arr=Array();
        foreach ($employee_list as $key => $value) {

            $check_date=$invigilator_list->where('user_id', $value->id)->first();
          //  return $check_date;
            if(!$request->academic_shift_id){

                $shift_ids=$shift_base_employee_shifts->where('user_id', $value->id)->pluck('academic_shift_id')->unique()->values();


                if($value['activeHistory']['is_teacher']){
                    $emp_shift_arr['employee_type']='Teacher';
                }
                else{
                    $emp_shift_arr['employee_type']='Staff';
                }


                $shift_list=$shift_detail->whereIn('id', $shift_ids);

                $emp_shift_arr['shift_list']=$shift_list;
                if($check_date){
                    $emp_shift_arr['select_employee_id']=true;
                }else{
                    $emp_shift_arr['select_employee_id']=false;
                }

                $emp_shift_array[$key]=array_merge($value->toArray(), $emp_shift_arr);


            }
            else{

                $shift_ids=$shift_base_employee_shifts->where('user_id', $value->id)->pluck('academic_shift_id')->unique()->values();
                $selected_shift_ids=$shift_base_employee_shifts
                    ->where('user_id', $value->id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->pluck('academic_shift_id')
                    ->unique()->values();

                if(count($shift_ids)==0 || count($selected_shift_ids)>0){

                    if($value['activeHistory']['is_teacher']){
                        $emp_shift_arr['employee_type']='Teacher';
                    }
                    else{
                        $emp_shift_arr['employee_type']='Staff';
                    }


                    $shift_list=$shift_detail->whereIn('id', $shift_ids);

                    $emp_shift_arr['shift_list']=$shift_list;

                    if($check_date){
                        $emp_shift_arr['select_employee_id']=true;
                    }else{
                        $emp_shift_arr['select_employee_id']=false;
                    }

                    $emp_shift_array[$key]=array_merge($value->toArray(), $emp_shift_arr);
                }

            }

        }

        $emp_shift_list=collect($emp_shift_array)->values();

        return $emp_shift_list;

    }


    public function createUpdateSiteExamInvigilatorSelection(Request $request){

        $data = $request->all();

  // dd($data);

        $invigilator_list=SiteExamInvigilatorSelection::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->select('id','user_id')
            ->get();
   

        $invigilator_ids=$invigilator_list->pluck('id');

        $checked_ids=[];
        $created=[];
       
        foreach ($request->EmployeeList as $key => $value) {
           
            if($value['select_employee_id']){
                $checkDate=$invigilator_list->where('user_id', $value['id'])->first();
              
                if($checkDate){
                    $checked_ids[]=$checkDate->id;

                    if(!$checkDate->status){
                        $checkDate->status=true;
                        $checkDate->activation_date=Carbon::today();

                        $checkDate->save();
                    }
                }else{
                    $created[] = [
                        'user_id' => $value['id'],
                        'academic_year_id' => $request->academic_year_id,
                        'academic_version_id' => $request->academic_version_id,
                        'academic_shift_id' => $request->academic_shift_id,
                        'examination_id' => $request->examination_id,
                        'exam_start_time' => date("H:i", strtotime($request->examination_time)),
                        'activation_date' => Carbon::today(),
//                    'pause_date' => ,

                        'status' => true,
                        'site_id' => Session::get('SITE_ID'),

                    ];
                }

            }

        }

  //      return dd($created);

        $siteExamInvigilatorCheck=array_diff($invigilator_ids->toArray(), $checked_ids);
    
        if(count($siteExamInvigilatorCheck)>0){
            SiteExamInvigilatorSelection::whereIn('id', $siteExamInvigilatorCheck)
                ->update([
                    'status' => false,
                    'pause_date' => Carbon::today(),
                ]);
        }

        if(count($created)>0){
            SiteExamInvigilatorSelection::insert($created);
        }

        return Response::json(['message' => 'Data Save Successfully', 'mode' => 'success' ], 200);


    }




    //==================Invigilator Setup=======================


    /**
     * @param Request $request
     */
    public function getExamInvigilatorRoomList(Request $request){

        $data = $request->all();

        $declaredSubjectList = SiteExamDeclares::with(['department', 'stClass', 'examRoutine'])
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id','site_subject_group_condition_setting_ids', 'academic_class_id', 'academic_department_id']);

          

        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();


        $exam_time_base_site_exam_type_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->pluck('id')
            ->unique()
            ->filter();

        $room_ids=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $exam_time_base_site_exam_type_list)
            ->pluck('room_id')
            ->unique()
            ->filter()
            ->values(); 
            

        $room_list=Room::whereIn('id', $room_ids)->get();

        $site_base_exam_room_setting_ids = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $exam_time_base_site_exam_type_list)
            ->whereIn('room_id', $room_ids)
            ->pluck('site_base_exam_room_setting_id')->unique()->values();

        if(count($site_base_exam_room_setting_ids)>0){
            $SiteBaseExamRoomSettingList = SiteBaseExamRoomSetting::whereIn('id', $site_base_exam_room_setting_ids)->get();
        }else{
            $SiteBaseExamRoomSettingList = [];
        }

        $invigilator_list=SiteExamInvigilatorRoomSetup::with(['activeEmployee'])
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->whereIn('room_id', $room_ids)
            ->select('id','room_id','user_id')
            ->get();
           

        $get_employee_list=$this->empListForSetup($request);

      
       // return $get_employee_list;
        $employee_list=$get_employee_list->whereNotIn('id', $invigilator_list->pluck('user_id')->unique())->values();

        $selected_employee_list=$get_employee_list->whereIn('id', $invigilator_list->pluck('user_id')->unique())->values();
        $selected_other_employee_list=$invigilator_list->whereNotIn('user_id', $get_employee_list->pluck('id')->unique())->values();
       // return $get_employee_list;
        $roomlist=[];
        $roomlist_arr=Array();
        foreach ($room_list as $key => $value) {
            if(count($SiteBaseExamRoomSettingList)>0){
                $seat_count=$SiteBaseExamRoomSettingList
                    ->where('room_id', $value->id)
                    ->where('status', true)
                    ->count();
            }else{
                $seat_count=0;
            }

            $roomlist_arr['select_room_id']=false;
            $roomlist_arr['seat_booked_count']=$seat_count;

            $room_invgi_ids=$invigilator_list->where('room_id', $value->id)->pluck('user_id');
            $room_invigilator_det=$selected_employee_list->whereIn('id', $room_invgi_ids);

          

            if(count($room_invigilator_det)>0){
                $employee_details=$room_invigilator_det;
            }else{
                $employee_details=[];
            }

            $check_data=$selected_other_employee_list->where('room_id', $value->id);

         

            if(count($check_data)>0){
                $data_array=[];
                foreach ($check_data as $keys => $values) {

                    $data_array[]=$values->activeEmployee;
                }
            }else{
                $data_array=[];
            }



            if(count($employee_details)==0 && count($data_array)==0){
                $employee_details_array=[];
            }
            else if(count($employee_details)==0 && count($data_array)>0){
                $employee_details_array=$data_array;
            }
            else if(count($employee_details)>0 && count($data_array)==0){
                $employee_details_array=$employee_details;
            }
            else if(count($employee_details)>0 && count($data_array)>0){
                $employee_details_array=array_merge($employee_details->toArray(), $data_array);
            }

            $roomlist_arr['employee_list']=$employee_details_array;
            $roomlist_arr['invigilator_count']=count($employee_details);

            $roomlist[$key]= array_merge($value->toArray(), $roomlist_arr);
        }
       

        $checkInvigilatordeclared=SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->first();

        if($checkInvigilatordeclared){
            $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->where('exam_start_date', '!=', $request->examination_date)
                ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
//                ->where('exam_start_date', '>=', Carbon::today())  //previous day will not show
                ->orderBy('exam_start_date')
                ->pluck('exam_start_date')->unique()->filter()->values();
        }else{
            $exam_date=[];
        }



        $exam_date_copy_array=[];
        $exam_date_copy_arr=Array();
        foreach ($exam_date as $key => $value) {

            $exam_date_copy_arr['exam_date']=$value;
            $exam_date_copy_array[$key]=$exam_date_copy_arr;
        }


     //   return $employee_list;


        return compact('roomlist', 'employee_list', 'exam_date_copy_array');

    }




    private function empListForSetup($request){

        $data = $request->all();

        $invigilator_list=SiteExamInvigilatorSelection::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->where('status', true)
            ->select('id','user_id')
            ->get();

          

        $employee_list= Employee::with(['activeHistory'=>function($query){
            $query->select('id','user_id', 'is_teacher');
        }])
            ->whereIn('id', $invigilator_list->pluck('user_id')->unique()->values())
            ->select('id', 'employee_serial')
            ->where('status', true)
            ->orderBy('employee_serial')
            ->get();


        $shift_base_employee_shifts=SiteEmployeeSiteShift::whereIn('user_id', $employee_list->pluck('id'))
            ->where('status', true)
            ->get();

        $shift_detail=AcademicShift::get();

        $emp_shift_array=[];
        $emp_shift_arr=Array();
        foreach ($employee_list as $key => $value) {

//            $check_date=$invigilator_list->where('user_id', $value->id)->first();

            if(!$request->academic_shift_id){

                $shift_ids=$shift_base_employee_shifts->where('user_id', $value->id)->pluck('academic_shift_id')->unique()->values();


                if($value['activeHistory']['is_teacher']){
                    $emp_shift_arr['employee_type']='Teacher';
                }
                else{
                    $emp_shift_arr['employee_type']='Staff';
                }


                $shift_list=$shift_detail->whereIn('id', $shift_ids);

                $emp_shift_arr['shift_list']=$shift_list;
//                if($check_date){
//                    $emp_shift_arr['select_employee_id']=true;
//                }else{
//                    $emp_shift_arr['select_employee_id']=false;
//                }

                $emp_shift_arr['select_employee_id']=false;
                $emp_shift_array[$key]=array_merge($value->toArray(), $emp_shift_arr);


            }
            else{

                $shift_ids=$shift_base_employee_shifts->where('user_id', $value->id)->pluck('academic_shift_id')->unique()->values();
                $selected_shift_ids=$shift_base_employee_shifts
                    ->where('user_id', $value->id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->pluck('academic_shift_id')
                    ->unique()->values();

                if(count($shift_ids)==0 || count($selected_shift_ids)>0){

                    if($value['activeHistory']['is_teacher']){
                        $emp_shift_arr['employee_type']='Teacher';
                    }
                    else{
                        $emp_shift_arr['employee_type']='Staff';
                    }


                    $shift_list=$shift_detail->whereIn('id', $shift_ids);

                    $emp_shift_arr['shift_list']=$shift_list;

//                    if($check_date){
//                        $emp_shift_arr['select_employee_id']=true;
//                    }else{
//                        $emp_shift_arr['select_employee_id']=false;
//                    }
                    $emp_shift_arr['select_employee_id']=false;

                    $emp_shift_array[$key]=array_merge($value->toArray(), $emp_shift_arr);
                }

            }



        }

        $emp_shift_list=collect($emp_shift_array)->values();

        return $emp_shift_list;

    }







    public function randomlyExamRoomInvigilatorSet(Request $request){

        $selected_room_detail= collect($request->RoomList)->where('select_room_id', true);
        $selected_employee_detail= collect($request->EmployeeList)->where('select_employee_id', true);

        if(count($selected_room_detail)>0 && count($selected_employee_detail)>0){

            $selected_room_list= $selected_room_detail;
            $selected_employee_list= $selected_employee_detail;
        }
        else if(count($selected_room_detail)==0 && count($selected_employee_detail)==0){

            $selected_room_list= collect($request->RoomList);
            $selected_employee_list= collect($request->EmployeeList);
        }
        else if(count($selected_room_detail)==0 && count($selected_employee_detail)>0){

            $selected_room_list= collect($request->RoomList);
            $selected_employee_list= $selected_employee_detail;
        }
        else if(count($selected_room_detail)>0 && count($selected_employee_detail)==0){

            $selected_room_list= $selected_room_detail;
            $selected_employee_list= collect($request->EmployeeList);
        }



        $highest_number_of_invigilator=$selected_room_list->max('invigilator_number');

        $selected_employee_ids=$selected_employee_list->pluck('id');

        if(count($selected_room_list)>count($selected_employee_ids)){
            return Response::json([
                'message' => '<b style="color:red">Total Number of Invigilator can not less then Total Room Number!.</b>',
                'mode' => 'Error!'
            ], 200);
        }
        $random_employee_ids=$selected_employee_ids->shuffle();



        $emp_array=[];
        $room_array=[];
        $room_emp_combine_array=[];
        for($i=1;$i<=$highest_number_of_invigilator;$i++){

            $selected_room_ids=$selected_room_list
                ->where('invigilator_count', '<', $i)
                ->where('invigilator_number', '>=', $i)
                ->pluck('id');
            $random_room_ids=$selected_room_ids->shuffle();

            if(count($emp_array)>0){
                $seated_emp=collect($emp_array)->collapse();
                $rest_emp=array_diff($random_employee_ids->toArray(), $seated_emp->toArray());


                $take_fixed_emp=collect($rest_emp)->take(count($random_room_ids));


            }else{
                $take_fixed_emp=$random_employee_ids->take(count($random_room_ids));
            }




            $emp_room_array=[];
            $emp_room_arr=Array();
            $room_count=0;
            foreach ($random_room_ids as $key => $value) {

                $emp_count=0;
                foreach ($take_fixed_emp as $keys => $values) {

                    if($room_count==$emp_count){

                        $emp_room_arr['room_id']=$value;
                        $emp_room_arr['employee_id']=$values;


                        $emp_room_array[$room_count]=$emp_room_arr;


                    }
                    $emp_count++;
                }
                $room_count++;
            }



            $emp_array[]=$take_fixed_emp;
            $room_array[]=$random_room_ids;
            $room_emp_combine_array[]=$emp_room_array;

        }


        $combined_list=collect($room_emp_combine_array)->collapse();


        $declared_employee_ids=$combined_list->pluck('employee_id');
        $employee_list= collect($request->EmployeeList)->whereNotIn('id', $declared_employee_ids)->values();


        $room_arr=Array();
        $roomlist=[];
        foreach (collect($request->RoomList) as $key => $value) {

            $check_data=$combined_list->where('room_id', $value['id'])->first();
            if($check_data){
                $emp_ids=$combined_list->where('room_id', $value['id'])->pluck('employee_id');
                $selected_employee_list= collect($request->EmployeeList)->whereIn('id', $emp_ids);

                $room_arr['employee_list']=array_merge($selected_employee_list->toArray(), $value['employee_list']);
                $room_arr['invigilator_count']=count($room_arr['employee_list']);


            }else{
                $room_arr['employee_list']=$value['employee_list'];
                $room_arr['invigilator_count']=count($value['employee_list']);

            }

            $roomlist[$key]=array_merge($value, $room_arr);
        }

        return compact( 'roomlist', 'employee_list');
    }





    public function singleExamRoomInvigilatorSet(Request $request){

        $selected_room_list= collect($request->RoomList)->where('select_room_id', true);
        $selected_employee_list= collect($request->EmployeeList)->where('select_employee_id', true);

        if(count($selected_room_list)>1){

            return Response::json([
                'message' => '<b style="color:red">You Can not Select Multiple Room. Must Select Single Room!.</b>',
                'mode' => 'Error!'
            ], 200);
        }
        else if(count($selected_room_list)==0){
            return Response::json([
                'message' => '<b style="color:red">Please Select Room!.</b>',
                'mode' => 'Error!'
            ], 200);
        }
        else if(count($selected_employee_list)==0){
            return Response::json([
                'message' => '<b style="color:red">Please Select Employee!.</b>',
                'mode' => 'Error!'
            ], 200);
        }


        $selected_single_room_detail=$selected_room_list->first();


        $roomlist=[];
        $roomlist_arr=Array();
        foreach (collect($request->RoomList) as $key => $value) {


            if($value['id']==$selected_single_room_detail['id']){

                $roomlist_arr['employee_list'] = array_merge($selected_employee_list->toArray(), $value['employee_list']);
                $roomlist_arr['invigilator_count'] = count($roomlist_arr['employee_list']);


            }else{
                $roomlist_arr['employee_list'] = $value['employee_list'];
                $roomlist_arr['invigilator_count'] = count($value['employee_list']);
            }


            $roomlist[$key]=array_merge($value, $roomlist_arr);

        }


    


        $selected_employee_ids=$selected_employee_list->pluck('id');

        $employee_list=collect($request->EmployeeList)->whereNotIn('id', $selected_employee_ids)->values();

        return compact( 'roomlist', 'employee_list');

    }



    public function removeExamRoomInvigilatorSet(Request $request){

        $test[]=$request->single_employee;

        $employee_list= collect(array_merge(collect($request->EmployeeList)->toArray(), $test))->values();


        $single_emp=$request->single_employee['id'];



        $roomlist=[];
        $roomlist_arr=Array();
        foreach (collect($request->RoomList) as $key => $value) {

            $check_data=collect($value['employee_list'])->where('id', $single_emp)->first();

            if($check_data){
                $get_data=collect($value['employee_list'])->where('id', '!=', $single_emp);

                $roomlist_arr['employee_list'] = $get_data;
                $roomlist_arr['invigilator_count'] =count($get_data);
            }else{
                $roomlist_arr['employee_list'] = $value['employee_list'];
                $roomlist_arr['invigilator_count'] =count($value['employee_list']);
            }


            $roomlist[$key]=array_merge($value, $roomlist_arr);

        }
        return compact( 'roomlist', 'employee_list');
    }

    public function saveUpdateExamRoomInvigilatorSet(Request $request){

        $status_list=SiteExamInvigilatorRoomSetup::where('exam_start_date',  $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->pluck('status')
            ->unique()
            ->filter();

       $today= (Carbon::today())->toDateString();

        if($today> $request->examination_date){
            return Response::json(['message' => 'Time Over. You Can not Change any Data!',
                'mode' => 'Error' ], 200);
        }
        else if(count($status_list)==1){

            return Response::json(['message' => 'This Duty Roster Already Published. You Can not Change any Data!',
                'mode' => 'Error' ], 200);

        }
        else if(count($status_list)==0){

            $selected_emp_ids=[];
            foreach (collect($request->RoomList) as $key => $value) {
                $selected_emp_ids[]=collect($value['employee_list'])->pluck('id');
            }

            $selected_invigilator_list=SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->examination_date)
                ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
                ->whereIn('user_id', collect($selected_emp_ids)->collapse())
                ->where('status', false)
                ->select('id','room_id','user_id')
                ->get();







            $created=[];
            $invigilator_setup_ids=[];
            foreach (collect($request->RoomList) as $key => $value) {

                foreach ($value['employee_list'] as $keys => $values) {

                    $check_data=$selected_invigilator_list->where('user_id', $values['id'])->first();

                    if($check_data){
                        $invigilator_setup_ids[]=$check_data->id;

                        $check_data->room_id=$value['id'];
                        $check_data->exam_start_date=$request->examination_date;
                        $check_data->academic_year_id=$request->academic_year_id;
                        $check_data->academic_version_id=$request->academic_version_id;
                        $check_data->academic_shift_id=$request->academic_shift_id;
                        $check_data->examination_id=$request->examination_id;
                        $check_data->exam_start_time=date("H:i", strtotime($request->examination_time));
                        $check_data->save();

                    }else{
                        $created[] = [
                            'room_id' => $value['id'],
                            'user_id' => $values['id'],
                            'exam_start_date' => $request->examination_date,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_shift_id' => $request->academic_shift_id,
                            'examination_id' => $request->examination_id,
                            'exam_start_time' => date("H:i", strtotime($request->examination_time)),
                            'status' => false,
                            'site_id' => Session::get('SITE_ID'),

                        ];
                    }

                }

            }



            if(count($created)>0){
                SiteExamInvigilatorRoomSetup::insert($created);
            }



            $non_selected_emp_ids=collect($request->EmployeeList)->pluck('id');

            SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->examination_date)
                ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
                ->whereIn('user_id', $non_selected_emp_ids)
                ->delete();


            return Response::json(['message' => 'Data Save Successfully', 'mode' => 'success' ], 200);
        }


    }





    public function copyExamRoomInvigilatorSetToOtherDate(Request $request){

        $data = $request->all();

        $declaredSubjectList = SiteExamDeclares::with(['department', 'stClass', 'examRoutine'])
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id','site_subject_group_condition_setting_ids', 'academic_class_id', 'academic_department_id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();


        $exam_time_base_site_exam_type_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->pluck('id')
            ->unique()
            ->filter();

        $room_ids=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $exam_time_base_site_exam_type_list)
            ->pluck('room_id')
            ->unique()
            ->filter()
            ->values();



        $selected_invigilator_list=SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->whereIn('room_id', $room_ids)
            ->where('status', true)
            ->select('id','room_id','user_id')
            ->get();



        $created=[];
        $invigilator_setup_ids=[];
        $invigilator_previous_set_ids=[];
        foreach ($request->selected_exam_date_array as $key => $value) {

            $date_base_invigilator_list=SiteExamInvigilatorRoomSetup::where('exam_start_date', $value)
                ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
                ->whereIn('room_id', $room_ids)
                ->where('status', true)
                ->select('id','room_id','user_id')
                ->get();

            $invigilator_previous_set_ids[]=$date_base_invigilator_list->pluck('id');

            foreach ($selected_invigilator_list as $keys => $values) {

                $check_data=$date_base_invigilator_list->where('user_id', $values->user_id)->first();

                if($check_data){
                    $invigilator_setup_ids[]=$check_data->id;

                    $check_data->room_id=$values['id'];
                    $check_data->exam_start_date=$value;
                    $check_data->academic_year_id=$request->academic_year_id;
                    $check_data->academic_version_id=$request->academic_version_id;
                    $check_data->academic_shift_id=$request->academic_shift_id;
                    $check_data->examination_id=$request->examination_id;
                    $check_data->exam_start_time=date("H:i", strtotime($request->examination_time));
                    $check_data->save();

                }else{
                    $created[] = [
                        'room_id' => $values['room_id'],
                        'user_id' => $values['user_id'],
                        'exam_start_date' => $value,
                        'academic_year_id' => $request->academic_year_id,
                        'academic_version_id' => $request->academic_version_id,
                        'academic_shift_id' => $request->academic_shift_id,
                        'examination_id' => $request->examination_id,
                        'exam_start_time' => date("H:i", strtotime($request->examination_time)),
                        'status' => false,
                        'site_id' => Session::get('SITE_ID'),

                    ];
                }



            }

        }



        if(count($created)>0){
            SiteExamInvigilatorRoomSetup::insert($created);
        }



        $diff_set_ids=array_diff(collect($invigilator_previous_set_ids)->collapse()->toArray(), $invigilator_setup_ids);


        SiteExamInvigilatorRoomSetup::whereIn('id', $diff_set_ids)
            ->delete();



         return Response::json(['message' => 'Data Copy Successfully', 'mode' => 'success' ], 200);


    }




//==========================Invigilator Report=====================


    public function getExaminationDateTimeListForInvigilatorList(Request $request){


        $data = $request->all();

        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->pluck('id');



        $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->orderBy('exam_start_date')
            ->pluck('exam_start_date')->unique()->filter();

        $exam_date_array=[];
        $exam_date_arr=Array();
        $count=0;
        foreach ($exam_date as $key => $value) {

            $exam_date_arr['exam_date']=$value;
            $exam_date_array[$count]=$exam_date_arr;
            $count++;
        }


        $exam_time=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('status', true)
            ->orderBy('exam_start_time')
            ->pluck('exam_start_time')->unique()->filter();

        $exam_time_array=[];
        $exam_time_arr=Array();
        $counts=0;
        foreach ($exam_time as $key => $value) {

            $exam_time_arr['exam_time']=$value;
            $exam_time_array[$counts]=$exam_time_arr;
            $counts++;
        }

        return compact('exam_date_array','exam_time_array');

    }

    public function siteDateRoomInvigilatorList(Request $request){


        $data = $request->all();

      //  dd( $data);

        $declaredSubjectList = SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id','site_subject_group_condition_setting_ids', 'academic_class_id', 'academic_department_id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();



        $exam_time_base_site_exam_type_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            // ->when(!empty($data['examination_date']), function ($query) use ($data) {
            //     return $query->whereIn('exam_start_date', $data['examination_date']);
            // })
            // ->when(!empty($data['examination_time']), function ($query) use ($data) {
            //     return $query->whereIn('exam_start_time', $data['examination_time']);
            // })
            ->select('id', 'exam_start_date', 'exam_start_time', 'site_subject_group_condition_setting_id')
            ->get();

        $exam_time_base_site_exam_type_ids=$exam_time_base_site_exam_type_list->pluck('id')->unique()->values();

       
        $siteExamDeclareStudentSubjectList=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $exam_time_base_site_exam_type_ids)
            ->select('id', 'student_history_id', 'site_exam_routine_id', 'site_subject_group_condition_setting_id', 'room_id')
            ->where('status', true)
            ->get();


        $room_list=Room::whereIn('id', $siteExamDeclareStudentSubjectList->pluck('room_id')->unique()->values())->get();


        $subject_list=SubjectGroupConditionSetting::with(['academicClass'])
            ->whereIn('id', $siteExamDeclareStudentSubjectList->pluck('site_subject_group_condition_setting_id')->unique()->values())
            ->get();



        $exam_date_list=SiteExamRoutine::whereIn('id', $exam_time_base_site_exam_type_ids)
            ->orderBy('exam_start_date')
            ->pluck('exam_start_date')->unique()->filter();


        $date_arr=Array();
        $date_array=[];
        foreach ($exam_date_list as $keyDate => $valueDate) {

            $date_base_routin_list=$exam_time_base_site_exam_type_list
                ->where('exam_start_date', $valueDate);

            $date_base_student_subject=$siteExamDeclareStudentSubjectList
                ->whereIn('site_exam_routine_id', $date_base_routin_list->pluck('id'))->values();

            $exam_time_list=$exam_time_base_site_exam_type_list
                ->where('exam_start_date', $valueDate)
                ->pluck('exam_start_time')->unique()->filter();



            $time_arr=Array();
            $time_array=[];
            foreach ($exam_time_list as $keyTime => $valueTime) {

                $time_base_routin_ids=$date_base_routin_list->where('exam_start_time', $valueTime)->pluck('id');

                $time_base_student_subject=$date_base_student_subject
                    ->whereIn('site_exam_routine_id', $time_base_routin_ids)->values();



                $room_ids=$siteExamDeclareStudentSubjectList->whereIn('site_exam_routine_id', $time_base_routin_ids)
                    ->pluck('room_id')
                    ->unique()
                    ->filter()
                    ->values();

                $room_arr=Array();
                $room_array=[];
                foreach ($room_ids as $keyRoom => $valueRoom) {

                    $invigilator_list=SiteExamInvigilatorRoomSetup::with(['activeEmployee'])
                        ->where('room_id', $valueRoom)
                        ->where('exam_start_date', $valueDate)
                        ->where('exam_start_time', $valueTime)
                        ->select('user_id')
                        ->get();


                    $room_base_student_subject=$time_base_student_subject
                        ->where('room_id', $valueRoom)->values();



                    $room_base_student_subject_condition_ids=$time_base_student_subject
                        ->where('room_id', $valueRoom)
                        ->pluck('site_subject_group_condition_setting_id')
                        ->unique()
                        ->values();

                    $subject_arr=Array();
                    $subject_array=[];
                    foreach ($room_base_student_subject_condition_ids as $keySubject => $valueSubject) {

                        $subject_detail=$subject_list->where('id', $valueSubject)->first();

                        $subject_base_student_count=$room_base_student_subject
                            ->where('site_subject_group_condition_setting_id', $valueSubject)
                            ->pluck('student_history_id')
                            ->unique()
                            ->count();

                        $subject_arr['subject_condition_id']=$valueSubject;
                        $subject_arr['subject_name']= $subject_detail->subject_name;
                        $subject_arr['class_name']= $subject_detail->academicClass->class_name;
                        $subject_arr['student_count']= $subject_base_student_count;

                        $subject_array[$keySubject]=$subject_arr;
                    }


                    $room_detail=$room_list->where('id', $valueRoom)->first();

                    $room_arr['room_name']= $room_detail->room_name_ex;
                    $room_arr['room_id']= $valueRoom;
                    $room_arr['class_subject_list']= collect($subject_array)->values();
                    $room_arr['invigilator_list']= $invigilator_list;

                    $room_array[$keyRoom]=$room_arr;

                }


                $status_list=SiteExamInvigilatorRoomSetup::where('exam_start_date', $valueDate)
                    ->where('exam_start_time', $valueTime)
                    ->pluck('status')
                    ->unique()
                    ->filter();

                if(count($status_list)==1){
                    $time_arr['status']= true;
                }
                else if(count($status_list)==0){
                    $time_arr['status']= false;
                }


                $time_arr['exam_time']= $valueTime;
                $time_arr['room_list']= collect($room_array)->values();
                $time_arr['row_span']= count($room_array);

                $time_array[$keyTime]=$time_arr;
            }


            $date_arr['exam_date']= $valueDate;
            $date_arr['time_list']= $time_array;
            $date_arr['row_span']= collect($time_array)->sum('row_span') + count($time_array);

            $date_array[$keyDate]=$date_arr;

        }


        $invigilatorList=collect($date_array)->values();

        return compact('invigilatorList');


    }



    // Delete Publish Pause Invigilator

    public function publishPauseDeleteDutyRoster(Request $request){



        $data = $request->all();

        $declaredSubjectList = SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();


        $exam_time_base_site_exam_type_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->exam_date)
            ->where('exam_start_time', date("H:i", strtotime($request->exam_time)))
            ->pluck('id')
            ->unique()
            ->filter();

        $check_data=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $exam_time_base_site_exam_type_list)
            ->where('exam_held_status', true)
            ->first();




        if($request->action_type=='publish'){

            $check_present_data= SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->exam_date)
                ->where('exam_start_time', $request->exam_time)->first();

            if($check_present_data){
                SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->exam_date)
                    ->where('exam_start_time', $request->exam_time)
                    ->update([
                        'status'=>true
                    ]);

                return Response::json(['message' => 'Duty Roster Publish Successfully', 'mode' => 'success' ], 200);
            }else{
                return Response::json(['message' => 'You can not publish before Setup Invigilator to Exam Room!',
                    'mode' => 'Error' ], 200);
            }





        }
        else if($request->action_type=='pause'){

            SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->exam_date)
                ->where('exam_start_time', $request->exam_time)
                ->update([
                    'status'=>false
                ]);

            return Response::json(['message' => 'Duty Roster Pause Successfully', 'mode' => 'success' ], 200);

        }
        else if($request->action_type=='delete'){


            if($check_data){
                return Response::json(['message' => 'Time Over. You Can not Delete Data!',
                    'mode' => 'Error' ], 200);
            }
            else{

                SiteExamInvigilatorRoomSetup::where('exam_start_date', $request->exam_date)
                    ->where('exam_start_time', $request->exam_time)
                    ->delete();

                return Response::json(['message' => 'Duty Roster Delete Successfully', 'mode' => 'success' ], 200);
            }


        }





    }







}
