<?php

namespace App\Http\Controllers\Site\Exam\SeatPlan;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSeatPlanStyle;
use App\Models\Academic\AcademicSeatPlanType;
use App\Models\Academic\AcademicSection;
use App\Models\Examinations\Examination;
use App\Models\Room\Room;
use App\Models\Site\Exam\GlobalSiteExamRoutine;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamInvigilatorRoomSetup;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Room\SiteBaseExamRoomSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use PhpParser\Node\Stmt\Continue_;
use Response;

class SiteExamSeatPlanGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }


    public function index()
    {
        $viewType = 'Site Seat Plan Setting Page';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.exam.site-base-seat-plan-setting', compact('viewType'));
    }


    public function getSiteVersionYearShiftBaseExaminationList(Request $request){

        $examinationIDs=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($request->academic_class_id),function($q) use ($request){
              return $q->where('academic_class_id', $request->academic_class_id);
            })
        //    ->where('exam_declared_by','site')
            ->pluck('examination_id')
            ->unique();

        if(count($examinationIDs)>0){

            $examinationlist=Examination::whereIn('id', $examinationIDs)->get();
        }else{
            $examinationlist=[];
        }


        return compact('examinationlist');


    }




    public function getExaminationDateListForSeatPlan(Request $request){

        $data = $request->all();

        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->pluck('id');



        $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->orderBy('exam_start_date')
            ->pluck('exam_start_date')->unique()->filter();

        $exam_date_array=[];
        $exam_date_arr=Array();
        $count=0;
        foreach ($exam_date as $key => $value) {

            $exam_date_arr['exam_date']=$value;
            $exam_date_array[$count]=$exam_date_arr;
            $count++;
        }


        return $exam_date_array;

    }






    public function getExaminationTimeListForSeatPlan(Request $request){

        $data = $request->all();

        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->pluck('id');



        $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->orderBy('exam_start_time')
            ->pluck('exam_start_time')->unique()->filter();

        $exam_date_array=[];
        $exam_date_arr=Array();
        $count=0;
        foreach ($exam_date as $key => $value) {

            $exam_date_arr['exam_time']=$value;
            $exam_date_array[$count]=$exam_date_arr;
            $count++;
        }


        return $exam_date_array;

    }

    public function getExamRoomDeptClassExamtypeList(Request $request){

        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('id');

        $exam_time_base_declare_ids=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->pluck('site_exam_declare_id')->unique()->filter();

        $routine_ids=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->orderBy('exam_start_date')
            ->pluck('id')->values();


        $exam_declare_list=SiteExamDeclares::whereIn('id', $exam_time_base_declare_ids)
            ->get();

        $department_ids=$exam_declare_list->pluck('academic_department_id')->unique()->filter();
        $class_ids=$exam_declare_list->pluck('academic_class_id')->unique()->filter();


        $exam_room_ids=SiteBaseExamRoomSetting::where('status', true)
            ->pluck('room_id')
            ->unique()
            ->filter();

    
        $only_roomlist=Room::whereIn('id', $exam_room_ids)
            ->orderBy('building_id')
            ->orderBy('floor_id')
            ->orderBy('id')
            ->get();

         //   dd($only_roomlist);

         
        $routine_ids_for_room=GlobalSiteExamRoutine::where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->orderBy('exam_start_date')
            ->pluck('id')->values();

        $site_base_exam_room_setting_ids = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids_for_room)
            ->whereIn('room_id', $exam_room_ids)
            ->pluck('site_base_exam_room_setting_id')->unique()->values();

        if(count($site_base_exam_room_setting_ids)>0){
            $SiteBaseExamRoomSettingList = SiteBaseExamRoomSetting::whereIn('id', $site_base_exam_room_setting_ids)->get();
        }else{
            $SiteBaseExamRoomSettingList = [];
        }


        $roomlist=[];
        $roomlist_arr=Array();
        foreach ($only_roomlist as $key => $value) {
            if(count($SiteBaseExamRoomSettingList)>0){
                $seat_count=$SiteBaseExamRoomSettingList
                    ->where('room_id', $value->id)
                    ->where('status', true)
                    ->count();
            }else{
                $seat_count=0;
            }

            $roomlist_arr['seat_booked_count']=$seat_count;
            $roomlist_arr['select_room_id']=false;
            $roomlist[$key]= array_merge($value->toArray(), $roomlist_arr);
        }

       

        $shiftClassGroupSectionSetting = SiteShiftClassGroupSectionSetting::with(['academicDepartment',
            'academicClass','academicClassGroup', 'academicClassGroup'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->get();

        $class_group_ids=$shiftClassGroupSectionSetting->pluck('academic_class_group_id')->unique()->filter();


        $rest_get_Student_history_ids = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereNotNull('room_id')
            ->pluck('student_history_id')
            ->unique()
            ->values();

        if(count($department_ids)<=0){

            $shiftClassGroupSectionSettingList=$shiftClassGroupSectionSetting;

            $getClassGroupSectionArray=$this->getClassGroupSectionArray($class_ids,
                $class_group_ids, $shiftClassGroupSectionSettingList, $request, $rest_get_Student_history_ids);

        }
        else{


            $department_arr=Array();
            $department_array=[];
            foreach ($department_ids as $key => $value) {

                $shiftClassGroupSectionSettingList=$shiftClassGroupSectionSetting
                    ->where('academic_department_id', $value);

                $getClassGroupSectionArray=$this->getClassGroupSectionArray($class_ids,
                    $class_group_ids, $shiftClassGroupSectionSettingList, $request, $rest_get_Student_history_ids);

                $dept=AcademicDepartment::where('id', $value)->first();

                $department_arr['id']=$value;
                $department_arr['department_name']=$dept->name;
                $department_arr['select_department_id']= false;
                $department_arr['class_list']=$getClassGroupSectionArray;

                $department_array[$key]=$department_arr;
            }

        }

        if(count($department_ids)<=0){

            $dept_class_list=$getClassGroupSectionArray;
            $dept_present=false;
        }
        else{

            $dept_class_list=$department_array;
            $dept_present=true;

        }


        $seat_plan_type_list=AcademicSeatPlanType::where('status', true)->get();
        // Date list for routine

        $checkRoutineSeatdeclared=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereNotNull('room_id')
            ->first();

        if($checkRoutineSeatdeclared){
            $exam_date=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->where('exam_start_date', '!=', $request->examination_date)
                ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
                ->where('exam_start_date', '>=', Carbon::today())  //previous day will not show
                ->orderBy('exam_start_date')
                ->pluck('exam_start_date')->unique()->filter()->values();
        }else{
            $exam_date=[];
        }

        $exam_date_copy_array=[];
        $exam_date_copy_arr=Array();
        foreach ($exam_date as $key => $value) {

            $exam_date_copy_arr['exam_date']=$value;
            $exam_date_copy_array[$key]=$exam_date_copy_arr;
        }



        $room_base_seat_plan_list = [];
        if($checkRoutineSeatdeclared) {

            $routineSeatdeclared = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                ->whereNotNull('room_id')
                ->get();

            $seat_plan_room_ids = $routineSeatdeclared->pluck('room_id')->unique()->filter()->values();
            $room_detail=Room::whereIn('id', $seat_plan_room_ids)->get();


            $invigilator_list=SiteExamInvigilatorRoomSetup::with(['activeEmployee'])
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_version_id', $request->academic_version_id)
                ->where('examination_id', $request->examination_id)
                ->where('exam_start_date', $request->examination_date)
                ->where('exam_start_time', $request->examination_time)
                ->whereIn('room_id', $seat_plan_room_ids)
                ->get();



            $room_arr = Array();
            foreach ($room_detail as $key => $value) {


                if(count($invigilator_list)>0){
                    $room_invigilator_list=$invigilator_list->where('room_id', $value->id);

                    $invigilator_arr=Array();
                    $invigilator_array=[];
                    foreach ($room_invigilator_list as $keyst => $valuest) {

                        $invigilator_arr['id']=$valuest->user_id;
                        $invigilator_arr['full_name']=$valuest->activeEmployee?$valuest->activeEmployee->full_name:'';

                        $invigilator_array[$keyst]=$invigilator_arr;
                    }
                }else{
                    $invigilator_array=[];
                }
                $invigilator_final_list=collect($invigilator_array)->values();


                $single_room_student = $routineSeatdeclared->where('room_id', $value->id);

                $student_history_ids = $single_room_student->pluck('student_history_id')
                    ->unique()->filter()->values();


                $madeClassGroupSectionArray=$this->madeClassGroupSectionArray($student_history_ids);
                $class_array=$madeClassGroupSectionArray[0];

                $academic_seat_plan_type_ids = $single_room_student->pluck('academic_seat_plan_type_id')
                    ->unique()->filter()->values();

                $academic_seat_plan_type_list = collect(AcademicSeatPlanType::whereIn('id', $academic_seat_plan_type_ids)
                    ->pluck('name'))->implode(', ');

                $academic_seat_plan_style_ids = $single_room_student->pluck('academic_seat_plan_style_id')
                    ->unique()->filter()->values();

                $academic_seat_plan_style_list = collect(AcademicSeatPlanStyle::whereIn('id', $academic_seat_plan_style_ids)
                    ->pluck('name'))->implode(', ');


                $room_arr['seat_plan_type_list'] = $academic_seat_plan_type_list;
                $room_arr['seat_plan_style_list'] = $academic_seat_plan_style_list;
                $room_arr['row_span'] = collect($class_array)->sum('row_span') + count($class_array);
                $room_arr['class_list'] = $class_array;
                $room_arr['invigilator_list'] = $invigilator_final_list;

                $room_base_seat_plan_list[$key] = array_merge($value->toArray(), $room_arr);

            }

        }
        // Rest Of Student which student not get the exam seat plan

        $routineLeftStudentSubject = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereNull('room_id')
            ->get();


       $rest_Student_history_ids = $routineLeftStudentSubject->pluck('student_history_id')->unique()->values();

        $restmadeClassGroupSectionArray=$this->madeClassGroupSectionArray($rest_Student_history_ids);
        $rest_class_array=$restmadeClassGroupSectionArray[0];
//        $rest_class_group_present=$restmadeClassGroupSectionArray[1];
//        $rest_class_section_present=$restmadeClassGroupSectionArray[2];



        return response()->json(
            [
                'roomlist'=>$roomlist,
                'dept_class_list'=>$dept_class_list,
                'dept_present'=>$dept_present,
                'seat_plan_type_list'=>$seat_plan_type_list,
                'exam_date_copy_array'=>$exam_date_copy_array,
                'room_base_seat_plan_list'=>$room_base_seat_plan_list,
                'rest_class_array'=>$rest_class_array,


            ]);


    }




    private function madeClassGroupSectionArray($student_history_ids){


        $studentList = StudentHistory::whereIn('id', $student_history_ids)
            ->select('id', 'academic_class_id', 'student_roll_number', 'academic_class_group_id', 'academic_section_id')
            ->orderBy('academic_class_id', 'asc')
            ->orderBy('academic_class_group_id', 'asc')
            ->orderBy('academic_section_id', 'asc')
            ->orderBy('student_roll_number', 'asc')
            ->get();



        $class_group_present=count($studentList->pluck('academic_class_group_id')->unique())>0?true:false;
        $class_section_present=count($studentList->pluck('academic_section_id')->unique())>0?true:false;


        $class_list_detail = AcademicClass::whereIn('id', $studentList->pluck('academic_class_id')
            ->unique()->filter()->values())->get();
        $class_group_list_detail = AcademicClassGroup::whereIn('id', $studentList->pluck('academic_class_group_id')
            ->unique()->filter()->values())->get();
        $class_section_detail = AcademicSection::whereIn('id', $studentList->pluck('academic_section_id')
            ->unique()->filter()->values())->get();



        $academic_class_ids = $studentList->pluck('academic_class_id')
            ->unique()->filter()->values();


        $class_arr = Array();
        $class_array = [];
        foreach ($academic_class_ids as $keyClass => $valueClass) {

            $single_class_detail = $class_list_detail->where('id', $valueClass)->first();

            $class_base_student = $studentList->where('academic_class_id', $valueClass);

            $class_student_roll_array = $class_base_student
                ->pluck('student_roll_number');

            $class_group_ids = $class_base_student->pluck('academic_class_group_id')
                ->unique()->filter()->values();

            $class_section_ids = $class_base_student->pluck('academic_section_id')
                ->unique()->filter()->values();


            $group_array = [];
            if (count($class_group_ids) > 0) {
                $group_arr = Array();
                foreach ($class_group_ids as $keyGroup => $valueGroup) {

                    $single_class_group = $class_group_list_detail->where('id', $valueGroup)->first();

                    $class_group_base_student = $class_base_student->where('academic_class_group_id', $valueGroup);

                    $group_student_roll_array = $class_group_base_student
                        ->pluck('student_roll_number');

                    $class_group_section_ids = $class_group_base_student->pluck('academic_section_id')
                        ->unique()->filter()->values();


                    $section_array = [];
                    if (count($class_group_section_ids) > 0) {
                        $section_arr = Array();
                        foreach ($class_group_section_ids as $keySection => $valueSection) {

                            $single_class_section = $class_section_detail->where('id', $valueSection)->first();

                            $student_roll_array = $class_group_base_student
                                ->where('academic_section_id', $valueSection)
                                ->pluck('student_roll_number');


                            $section_arr['section_id'] = $valueSection;
                            $section_arr['section_name'] = $single_class_section->section_name;
                            $section_arr['min_roll_number'] = min($student_roll_array->toArray());
                            $section_arr['max_roll_number'] = max($student_roll_array->toArray());
                            $section_arr['student_roll_number'] = collect($student_roll_array)->implode(', ');
                            $section_arr['student_count'] = count($student_roll_array);

                            $section_array[$keySection] = $section_arr;

                        }
                    }


                    if (count($section_array) == 0) {
                        $group_arr['min_roll_number'] = min($group_student_roll_array->toArray());
                        $group_arr['max_roll_number'] = max($group_student_roll_array->toArray());
                        $group_arr['student_roll_number'] = collect($group_student_roll_array)->implode(', ');
                    } else {
                        $group_arr['min_roll_number'] = null;
                        $group_arr['max_roll_number'] = null;
                        $group_arr['student_roll_number'] = null;
                    }
                    $group_arr['group_id'] = $valueGroup;
                    $group_arr['group_name'] = $single_class_group->group_name;
                    $group_arr['student_count'] = count($group_student_roll_array);
                    $group_arr['row_span'] = count($class_group_section_ids);
                    $group_arr['section_array'] = $section_array;


                    $group_array[] = $group_arr;
                }
                $section_arrays=[];
            } else {

                $section_arrays = [];
                if (count($class_section_ids) > 0) {

                    $section_arrs = Array();
                    foreach ($class_section_ids as $keySection => $valueSection) {

                        $single_class_section = $class_section_detail->where('id', $valueSection)->first();

                        $student_roll_array = $class_base_student
                            ->where('academic_section_id', $valueSection)
                            ->pluck('student_roll_number');


                        $section_arrs['section_id'] = $valueSection;
                        $section_arrs['section_name'] = $single_class_section->section_name;
                        $section_arrs['min_roll_number'] = min($student_roll_array->toArray());
                        $section_arrs['max_roll_number'] = max($student_roll_array->toArray());
                        $section_arrs['student_roll_number'] = collect($student_roll_array)->implode(', ');
                        $section_arrs['student_count'] = count($student_roll_array);


                        $section_arrays[$keySection] = $section_arrs;
                    }

                }
                $group_array=[];
            }


            if (count($group_array) == 0 && count($section_arrays) == 0) {
                $class_arr['min_roll_number'] = min($class_student_roll_array->toArray());
                $class_arr['max_roll_number'] = max($class_student_roll_array->toArray());
                $class_arr['student_roll_number'] = collect($class_student_roll_array)->implode(', ');
                $class_arr['student_count'] = count($class_student_roll_array);
                $class_arr['row_span'] = 3;
            } else {
                if(count($group_array)==0 && count($section_arrays)> 0){
                    $class_arr['row_span'] = count($section_arrays);
                }
                else if(count($group_array)>0 && count($section_arrays)==0){

                    $class_arr['row_span'] = collect($group_array)->sum('row_span') + count($group_array);
                }
                $class_arr['min_roll_number'] = null;
                $class_arr['max_roll_number'] = null;
                $class_arr['student_roll_number'] = null;
                $class_arr['student_count'] = null;
            }


            $class_arr['class_id'] = $valueClass;
            $class_arr['class_name'] = $single_class_detail->class_name;
            $class_arr['group_list'] = $group_array;
            $class_arr['section_list'] = $section_arrays;


            $class_array[$keyClass] = $class_arr;


        }

        return [$class_array, $class_group_present, $class_section_present];
    }





    public function getAcademicExamSeatPlanStyleList(Request $request){

        $exam_seat_plan_style_list=AcademicSeatPlanStyle::where('academic_seat_plan_type_id', $request->seat_plan_type_id)->get();

        return $exam_seat_plan_style_list;
    }



    private function getClassGroupSectionArray($class_ids, $class_group_ids, $shiftClassGroupSectionSettingList,
                                               $request, $rest_get_Student_history_ids){


        $class_arr=Array();
        $class_array=[];
        $count=0;
        foreach ($class_ids as $key => $value) {

            $student_list=StudentHistory::
                where('academic_year_id', $request->academic_year_id)
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $value)
                ->where('status', true)
                ->get();


            $declared_class_student_count=$student_list->whereIn('id', $rest_get_Student_history_ids)->count();


            $student_count = $student_list
                ->count();


            $checkGroup=$shiftClassGroupSectionSettingList->where('academic_class_id', $value)
                ->whereIn('academic_class_group_id', $class_group_ids);


            if(count($checkGroup)>0){

                $checkedGroupIDs=$checkGroup->pluck('academic_class_group_id')->unique();

                $group_section_arr=Array();
                $group_section_array=[];
                foreach ($checkedGroupIDs as $keyGroup => $valueGroup) {

                    $student_group_count = $student_list->where('academic_class_group_id', $valueGroup)
                        ->count();

                    $seat_declaredstudent_group_count = $student_list->whereIn('id', $rest_get_Student_history_ids)
                        ->where('academic_class_group_id', $valueGroup)
                        ->count();



                    $checkSection=$checkGroup->where('academic_class_group_id', $valueGroup)->first();

                    if($checkSection->academic_section_ids){

                        $section_lists_table=AcademicSection::whereIn('id', explode(',', $checkSection->academic_section_ids))
                            ->get();

                        $section_lists_arr=Array();
                        $section_lists=[];
                        foreach ($section_lists_table as $keysetion => $valuesection) {

                            $student_section_count = $student_list
                                ->where('academic_section_id', $valuesection->id)
                                ->where('academic_class_group_id', $valueGroup)
                                ->count();

                            $seat_declared_student_section_count = $student_list
                                ->where('academic_section_id', $valuesection->id)
                                ->where('academic_class_group_id', $valueGroup)
                                ->whereIn('id', $rest_get_Student_history_ids)
                                ->count();

                            $section_lists_arr['id']=$valuesection->id;
                            $section_lists_arr['section_name']=$valuesection->section_name;
                            $section_lists_arr['select_section_id']=false;
                            $section_lists_arr['section_student_count']=$student_section_count;
                            $section_lists_arr['seat_declared_section_student_count']=$seat_declared_student_section_count;

                            $section_lists[$keysetion]=$section_lists_arr;
                        }


                    }else{
                        $section_lists=[];
                    }

                    $group_section_arr['academic_class_group_id']=$checkSection->academic_class_group_id;
                    $group_section_arr['group_name']=$checkSection->academicClassGroup->group_name;
                    $group_section_arr['group_student_count']=$student_group_count;
                    $group_section_arr['seat_declared_group_student_count']=$seat_declaredstudent_group_count;
                    $group_section_arr['select_class_group_id']=false;
                    $group_section_arr['section_list']=$section_lists;

                    $group_section_array[$keyGroup]=$group_section_arr;

                }

                $section_list=[];

            }
            else{
                $checkSection=$shiftClassGroupSectionSettingList->where('academic_class_id', $value)
                    ->where('academic_class_group_id', '=', null)
                    ->first();

                if($checkSection->academic_section_ids){

                    $section_lists_table=AcademicSection::whereIn('id', explode(',', $checkSection->academic_section_ids))
                        ->get();

                    $section_lists_arr=Array();
                    $section_list=[];
                    foreach ($section_lists_table as $keysetion => $valuesection) {

                        $student_section_count = $student_list
                            ->where('academic_section_id', $valuesection->id)
                            ->count();

                        $seat_declared_student_section_count = $student_list
                            ->where('academic_section_id', $valuesection->id)
                            ->whereIn('id', $rest_get_Student_history_ids)
                            ->count();


                        $section_lists_arr['id']=$valuesection->id;
                        $section_lists_arr['section_name']=$valuesection->section_name;
                        $section_lists_arr['select_section_id']=false;
                        $section_lists_arr['section_student_count']=$student_section_count;
                        $section_lists_arr['seat_declared_section_student_count']=$seat_declared_student_section_count;

                        $section_list[$keysetion]=$section_lists_arr;
                    }



                }else{
                    $section_list=[];
                }
                $group_section_array=[];
            }

            $firstClass=$shiftClassGroupSectionSettingList->where('academic_class_id', $value)->first();


            $class_arr['section_list']=$section_list;
            $class_arr['class_group_list']=$group_section_array;
            $class_arr['id']=$value;
            $class_arr['class_name']= $firstClass->academicClass->class_name;
            $class_arr['total_student']= $student_count;
            $class_arr['seat_declared_total_student']= $declared_class_student_count;
            $class_arr['select_class_id']= false;



            $class_array[$count]=$class_arr;
            $count++;

        }

        return $class_array;

    }








    public function getExamDeptClassExamtypeBaseSubjectList(Request $request){


        $selected_class_ids=[];
        foreach ($request->DeptClassList as $key => $value) {

            if($value['select_class_id']){

                $selected_class_ids[]=$value['id'];
            }
        }

        $data = $request->all();



        $declaredSubjectList = SiteExamDeclares::with(['department', 'stClass', 'examRoutine'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->whereIn('academic_class_id', $selected_class_ids)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->get(['id','site_subject_group_condition_setting_ids', 'academic_class_id', 'academic_department_id']);



        $exam_declare_ids=$declaredSubjectList->pluck('id')->unique();


        $exam_time_base_site_exam_type_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))->get();


        $exam_time_base_site_exam_type_ids=$exam_time_base_site_exam_type_list
            ->pluck('academic_exam_type_id')
            ->unique()
            ->filter();

        $exam_time_base_subject_ids=$exam_time_base_site_exam_type_list
            ->pluck('site_subject_group_condition_setting_id')
            ->unique()
            ->filter();

        $exam_type_list=AcademicExamType::whereIn('id', $exam_time_base_site_exam_type_ids)->get();




        $class_list_arr=Array();
        $class_list_array=[];
        foreach ($declaredSubjectList as $key => $value) {

            $checkSubject=collect($value->site_subject_group_condition_setting_ids)
                ->whereIn('id', $exam_time_base_subject_ids);


            $subject_arr=Array();
            $subject_array=[];
            foreach ($checkSubject as $keys => $values) {

                $examTypeRoutineList= collect($value->examRoutine)
                    ->where('site_subject_group_condition_setting_id', $values->id);

                $exam_type_arr=Array();
                $exam_type_array=[];
                foreach ($examTypeRoutineList as $keyse => $valuese) {

                    $checkExamType=$exam_type_list->where('id', $valuese['academic_exam_type_id'])->first();



                    if($checkExamType){
                        $exam_type_arr['id']=$valuese['academic_exam_type_id'];
                        $exam_type_arr['exam_type_name']=$valuese['exam_type_name'];
                        $exam_type_arr['select_exam_type_id']=true;

                        $exam_type_array[$keyse]=$exam_type_arr;
                    }


                }

                $subject_arr['site_subject_group_condition_setting_id']=$values->id;
                $subject_arr['subject_name']=$values->subject_name;
                $subject_arr['subject_code']=$values->subject_code;
                $subject_arr['subject_position']=$values->subject_position;
                $subject_arr['select_subject_id']=true;
                $subject_arr['exam_type_list']=$exam_type_array;

                $subject_array[$keys]=$subject_arr;
            }

            $class_list_arr['class_id']=$value->stClass->id;
            $class_list_arr['class_name']=$value->stClass->class_name;
            $class_list_arr['select_class_id']=true;
            $class_list_arr['subject_list']=$subject_array;

            $class_list_array[$key]=$class_list_arr;
        }





        return compact('class_list_array');
    }






    public function siteExamSeatPlanAutoGenerate(Request $request){


        $examDateTime = Carbon::createFromFormat('Y-m-d H:i:s', "$request->examination_date $request->examination_time");
        $today=Carbon::now();
//        if($today>$examDateTime){
//            return Response::json(['message' => 'Due to the time out, You can not generate seat plan!.',
//                'mode' => 'Error!'], 200);
//        }
//        else if($today<$examDateTime){
//            $interval = $today->diffInHours($examDateTime);
//
//            if($interval<12){
//                return Response::json(['message' => 'Due to the time out, You can not generate seat plan!.',
//                    'mode' => 'Error!'], 200);
//            }
//        }



        $class_detail=$this->seatPlanValidation($request);



        $class_student_count_array=$class_detail[0];
        $class_individual_student_count_list=$class_detail[1];





        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('id');


        $exam_time_base_declare_routine_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->get();

        $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter()->values();

        $exam_time_base_declare_ids=$exam_time_base_declare_routine_list->pluck('site_exam_declare_id')->unique()->filter();


        $exam_declare_list=SiteExamDeclares::whereIn('id', $exam_time_base_declare_ids)
            ->get();




        $selectedRoomList=collect($request->RoomList)->where('select_room_id', true);



        $room_ids=$selectedRoomList->pluck('id')->unique();

        $all_room_setting_list=SiteBaseExamRoomSetting::whereIn('room_id',$room_ids)
            ->where('status', true)
            ->orderBy('room_id')
            ->orderBy('column_position')
            ->orderBy('seat_number')
            ->get();
        $room_all_setting_ids=$all_room_setting_list->pluck('id');


        $routine_ids_for_room=GlobalSiteExamRoutine::where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->orderBy('exam_start_date')
            ->pluck('id')->values();

        $exam_declare_ids_for_room=GlobalSiteExamRoutine::where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
//            ->orderBy('exam_start_date')
            ->pluck('site_exam_declare_id')->unique()->values();

        $check_room_setting_ids=SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $exam_declare_ids_for_room)
            ->whereIn('site_exam_routine_id', $routine_ids_for_room)
            ->pluck('site_base_exam_room_setting_id')
            ->unique()
            ->values();


        $room_setting_intersect_id=array_intersect($room_all_setting_ids->toArray(), $check_room_setting_ids->toArray());




        if($request->seat_plan_type_key_name=='allclass'){
            $room_setting_list=$all_room_setting_list->whereNotIn('id', $room_setting_intersect_id);
        }
        else if($request->seat_plan_type_key_name=='seperateroom'){

            $get_room_list=$all_room_setting_list->whereNotIn('id', $room_setting_intersect_id);
            $setting_room_ids=$get_room_list->pluck('room_id')->unique()->values();



            $separeted_room_ids=[];
            foreach ($setting_room_ids as $key => $value) {

                $main_setting_seat_count=$all_room_setting_list->where('room_id', $value)->count();
                $empty_setting_seat_count=$get_room_list->where('room_id', $value)->count();

                if($main_setting_seat_count==$empty_setting_seat_count){
                    $separeted_room_ids[]= $value;
                }

            }

            $room_setting_list=$get_room_list->whereIn('room_id', $separeted_room_ids);

        }

        $declared_student_count=array_sum($class_student_count_array);



        if(count($room_setting_list)<$declared_student_count){
            return Response::json(['message' => 'Your Selected Exam Seat Amout is Less Then Total Student!',
                'mode' => 'Error!'], 200);
        }
        //  End Total Student & Seat number validation




        $seatCombinationTypeBaseClassStudentRoomList=$this->seatCombinationTypeBaseClassStudentRoomList($request,
            $class_individual_student_count_list, $room_setting_list, $exam_time_base_declare_ids, $exam_declare_list);





        if($request->dept_present==false){

            if($request->seat_plan_type_key_name=='allclass'){
                $this->AllClassRoomSeatPlan($request, $seatCombinationTypeBaseClassStudentRoomList);

//                return $class_seat_combination;
            }
            else if($request->seat_plan_type_key_name=='seperateroom'){



                foreach ($seatCombinationTypeBaseClassStudentRoomList as $keyClass => $valueClass) {

                    $this->seperateRoomSeatPlan($request, $valueClass);


                }
            }



        }

        return Response::json(['message' => 'Save Successfully!', 'mode' => 'Save!'], 200);

    }


    private function seatPlanValidation($request){


        //   Total Student & Seat number validation

        $class_individual_student_count_list=[];
        $class_individual_student_count_arr=Array();
        foreach ($request->DeptClassList as $key => $value) {



            if($value['select_class_id']){

                $student_list=StudentHistory::
                where('academic_year_id', $request->academic_year_id)
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_class_id', $value['id'])
                    ->where('status', true)
                    ->get();


                $class_student=[];
                $student_history_ids=[];
                if(count($value['class_group_list'])<=0){

                    if(count($value['section_list'])<=0){

                        $student_history_ids[] = $student_list->pluck('id');

//                        $class_student_count_array[]=$value['total_student'];
                        $class_student[]=$value['total_student'];
                    }else{

                        foreach ($value['section_list'] as $keys => $values) {
                            if($values['select_section_id']){


                                $student_history_ids[] = $student_list
                                    ->where('academic_section_id', $values['id'])
                                    ->pluck('id');


//                                $class_student_count_array[]=$values['section_student_count'];
                                $class_student[]=$values['section_student_count'];
                            }
                        }
                    }


                }else{



                    foreach ($value['class_group_list'] as $keyt => $valuet) {
                        if($valuet['select_class_group_id']){

                            if(count($valuet['section_list'])<=0){


                                $student_history_ids[] = $student_list
                                    ->where('academic_class_group_id', $valuet['academic_class_group_id'])
                                    ->pluck('id');

//                                $class_student_count_array[]=$valuet['group_student_count'];
                                $class_student[]=$valuet['group_student_count'];
                            }else{


                                foreach ($valuet['section_list'] as $keys => $values) {
                                    if($values['select_section_id']){

                                        $student_history_ids[] = $student_list
                                            ->where('academic_section_id', $values['id'])
                                            ->where('academic_class_group_id', $valuet['academic_class_group_id'])
                                            ->pluck('id');

//                                        $class_student_count_array[]=$values['section_student_count'];
                                        $class_student[]=$values['section_student_count'];
                                    }

                                }
                            }
                        }
                    }
                }

                $class_individual_student_count_arr['class_id']=$value['id'];
//                $class_individual_student_count_arr['class_name']=$value['id'];
//                $class_individual_student_count_arr['student_count']=array_sum($class_student);
                $class_individual_student_count_arr['student_history_ids']=collect($student_history_ids)->collapse();

                $class_individual_student_count_list[$key]=$class_individual_student_count_arr;

            }




        }







        $class_student_count_array=[];
        $class_student_count_list=[];
        $class_student_count_list_arr=Array();
        foreach ($class_individual_student_count_list as $key => $value){


            $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_version_id', $request->academic_version_id)
                ->where('examination_id', $request->examination_id)
                ->where('academic_class_id', $value['class_id'])
                ->pluck('id');



            $class_subject_list=collect($request->SubjectList)->where('select_class_id', true)
                ->where('class_id', $value['class_id'])->first();



            $site_subject_group_condition_setting_ids= collect($class_subject_list['subject_list'])
                ->where('select_subject_id', true)
                ->pluck('site_subject_group_condition_setting_id');

            $SiteExamDeclareStudentSubject=SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $exam_declare_ids)
                ->whereIn('site_subject_group_condition_setting_id', $site_subject_group_condition_setting_ids)
                ->whereIn('student_history_id', $value['student_history_ids'])
                ->whereNull('room_id')
                ->pluck('student_history_id')
                ->unique()
                ->values();




            $class_student_count_array[]=count($SiteExamDeclareStudentSubject);

            $class_student_count_list_arr['class_id']=$value['class_id'];
            $class_student_count_list_arr['student_count']=count($SiteExamDeclareStudentSubject);
            $class_student_count_list_arr['student_history_ids']=$SiteExamDeclareStudentSubject;


            $class_student_count_list[$key]=$class_student_count_list_arr;

        }







        return [$class_student_count_array, $class_student_count_list];

    }







    private function seatCombinationTypeBaseClassStudentRoomList($request, $class_individual_student_count_list,
                                                          $room_setting_list, $exam_time_base_declare_ids, $exam_declare_list){



        if($request->seat_plan_type_key_name=='allclass'){

            $class_student_room_arr=Array();
            $class_student_room_array=[];
            $room_all_setting_ids=[];
            foreach ($class_individual_student_count_list as $key => $value) {


                if(count(collect($room_all_setting_ids)->collapse())>0){
                    $class_room_setting_list=$room_setting_list
                        ->whereNotIn('id',collect($room_all_setting_ids)->collapse())
                        ->take($value['student_count']);

                    $room_all_setting_ids[]=$class_room_setting_list->pluck('id');
                }else{
                    $class_room_setting_list=$room_setting_list->take($value['student_count']);
                    $room_all_setting_ids[]=$class_room_setting_list->pluck('id');
                }

//                \Log::info([count($class_room_setting_list), $value['student_count']]);

                if(count($class_room_setting_list)<$value['student_count']){
                    return Response::json(['message' => 'Your Selected Exam Seat Amout is Less Then Total Student!',
                        'mode' => 'Error!'], 200);
                }


                $class_student_room_arr['room_ids']=$class_room_setting_list->pluck('room_id')->unique();
                $class_student_room_arr['room_setting_list']=$class_room_setting_list;
                $class_student_room_arr['room_setting_list_count']=count($class_room_setting_list);


                $class_student_room_array[$key]=array_merge($value, $class_student_room_arr);

            }
        }
        else if($request->seat_plan_type_key_name=='seperateroom'){



            $rooms_ids=[];
            $class_student_room_arr=Array();
            $class_student_room_array=[];
            foreach ($class_individual_student_count_list as $key => $value) {

                if(count(collect($rooms_ids)->collapse())>0){



                    $class_room_setting_pre_list=$room_setting_list
                        ->whereNotIn('room_id',collect($rooms_ids)->collapse())
                        ->take($value['student_count']);



                    if(count($class_room_setting_pre_list)<$value['student_count']){
                        return Response::json(['message' => 'Your Selected Exam Room Base Seat Amout is Less Then Total Student!',
                            'mode' => 'Error!'], 200);
                    }
                    else{

                        $rooms_ids[]=$class_room_setting_pre_list->pluck('room_id')->unique();

                        $class_room_setting_list=$room_setting_list
                            ->whereIn('room_id', $class_room_setting_pre_list->pluck('room_id')->unique());
                    }


                }
                else{

                    $class_room_setting_pre_list=$room_setting_list->take($value['student_count']);

                    if(count($class_room_setting_pre_list)<$value['student_count']){
                        return Response::json(['message' => 'Your Selected Exam Room Base Seat Amout is Less Then Total Student!',
                            'mode' => 'Error!'], 200);
                    }
                    else{

                        $rooms_ids[]=$class_room_setting_pre_list->pluck('room_id')->unique();

                        $class_room_setting_list=$room_setting_list
                            ->whereIn('room_id', $class_room_setting_pre_list->pluck('room_id')->unique());
                    }


                }




                $class_student_room_arr['room_ids']=$class_room_setting_list->pluck('room_id')->unique();
                $class_student_room_arr['room_setting_list']=$class_room_setting_list;
                $class_student_room_arr['room_setting_list_count']=count($class_room_setting_list);


                $class_student_room_array[$key]=array_merge($value, $class_student_room_arr);

            }


        }




        $subject_base_arr=Array();
        $subject_base_array=[];
        foreach ($class_student_room_array as $key => $value) {


            $class_subject_list=collect($request->SubjectList)->where('select_class_id', true)
                ->where('class_id', $value['class_id'])->first();

            $site_subject_group_condition_setting_ids= collect($class_subject_list['subject_list'])
                ->pluck('site_subject_group_condition_setting_id');


            $declared_subject_base_student_array=[];
            foreach ($class_subject_list['subject_list'] as $keys => $values) {

                $selected_exam_type=collect($values['exam_type_list'])
                    ->where('select_exam_type_id', true)
                    ->pluck('id');


                $declared_subject_base_student_array[]= SiteExamDeclareStudentSubject::
                where('site_subject_group_condition_setting_id', $values['site_subject_group_condition_setting_id'])
                    ->whereIn('academic_exam_type_id', $selected_exam_type)
                    ->whereIn('student_history_id', $value['student_history_ids'])
                    ->whereIn('site_exam_declare_id', $exam_time_base_declare_ids)
                    ->pluck('id');

            }



            $get_exam_declare_id=$exam_declare_list->where('academic_class_id', $value['class_id'])
                ->first();

            $subject_base_arr['site_exam_declare_student_subject_ids']=collect($declared_subject_base_student_array)->collapse();
            $subject_base_arr['exam_declare_id']=$get_exam_declare_id->id;

            $subject_base_array[]=array_merge($value, $subject_base_arr);
        }




        return $subject_base_array;

    }









    private function seperateRoomSeatPlan($request, $classDetail){

//return $classDetail;
        if($request->seat_plan_style_key_name=='onebyoneclass' || $request->seat_plan_style_key_name=='sectioncombination' || $request->seat_plan_style_key_name=='ztype'){


            $studentList=StudentHistory::whereIn('id', $classDetail['student_history_ids'])
                ->select('id', 'student_roll_number', 'academic_class_group_id', 'academic_section_id')
                ->orderBy('academic_class_group_id', 'asc')
                ->orderBy('academic_section_id', 'asc')
                ->orderBy('student_roll_number', 'asc')
                ->get();
        }
        else if($request->seat_plan_style_key_name=='random'){

            $studentList=StudentHistory::whereIn('id', $classDetail['student_history_ids'])
                ->select('id', 'student_roll_number', 'academic_class_group_id', 'academic_section_id')
                ->inRandomOrder()
                ->get();
        }




        $declared_subject_base_student_list=SiteExamDeclareStudentSubject::
            whereIn('id', $classDetail['site_exam_declare_student_subject_ids'])
            ->select('id', 'student_history_id')
            ->get();






        if($request->seat_plan_style_key_name=='sectioncombination' || $request->seat_plan_style_key_name=='ztype'){



            $classGroupIds=$studentList->pluck('academic_class_group_id')->unique()->filter();
            $sectionIds=$studentList->pluck('academic_section_id')->unique()->filter();

            if($request->seat_plan_style_key_name=='ztype' && count($classGroupIds)>2){
                return Response::json(['message' => 'Z Type Seat Plan Can not Support More Then 2 Group!',
                    'mode' => 'Error!'], 200);
            }

            if($request->seat_plan_style_key_name=='ztype' && count($sectionIds)>2){
                return Response::json(['message' => 'Z Type Seat Plan Can not Support More Then 2 Section!',
                    'mode' => 'Error!'], 200);
            }


            if(count($classGroupIds)>0){




                $group_count=count($sectionIds);
                $group_present_number=1;
                $group_seat_get_student=[];
                $group_seat_fill_up=[];
                foreach ($classGroupIds as $keyGroup => $valueGroup) {

                    $groupStudentList=$studentList->where('academic_class_group_id', $valueGroup)->values();



                    $group_student_ids=$groupStudentList
                        ->pluck('id')->unique();

                    $group_declared_subject_base_student_list=$declared_subject_base_student_list
                        ->whereIn('student_history_id', $group_student_ids);



                    $countcg=0;
                    foreach ($classDetail['room_ids'] as $keyRoom => $valueRoom) {

                        $roomList=collect($classDetail['room_setting_list'])
                            ->where('room_id', $valueRoom);


                        $room_column_ids=$roomList->pluck('column_position')->unique();

                        foreach ($room_column_ids as $keyRoomSetting => $valueRoomSetting) {

                            $seat_list = $roomList->where('column_position', $valueRoomSetting);

                            foreach ($seat_list as $keySeat => $valueSeat) {



                                if (count($groupStudentList) > $countcg) {
                                    $single_student = $groupStudentList[$countcg];



                                    $declared_student_subject_ids = $group_declared_subject_base_student_list
                                        ->where('student_history_id', $single_student->id)
                                        ->pluck('id')
                                        ->unique()->filter();

                                } else {
                                    $single_student = null;
                                }



                                if ($single_student) {



                                    if ($group_count == 1) {
                                        $group_seat_fill_up[] = $valueSeat->id;
                                        $group_seat_get_student[] = $single_student->id;

                                        $seat_set_column[]=$valueSeat->column_position;

                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                        $countcg++;


                                    }
                                    else {



                                        if($request->seat_plan_style_key_name=='ztype'){

                                            if($group_present_number%2==1){
                                                if($valueSeat->column_position%2==1){

                                                    if($valueSeat->seat_number%2==1){
                                                        $group_seat_fill_up[] = $valueSeat->id;
                                                        $group_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                        $countcg++;
                                                    }
                                                }
                                                else if($valueSeat->column_position%2==0){

                                                    if($valueSeat->seat_number%2==0){
                                                        $group_seat_fill_up[] = $valueSeat->id;
                                                        $group_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                        $countcg++;
                                                    }

                                                }
                                            }
                                            else{

                                                if($valueSeat->column_position%2==1){

                                                    if($valueSeat->seat_number%2==0){
                                                        $group_seat_fill_up[] = $valueSeat->id;
                                                        $group_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                        $countcg++;
                                                    }
                                                }
                                                else if($valueSeat->column_position%2==0){

                                                    if($valueSeat->seat_number%2==1){
                                                        $group_seat_fill_up[] = $valueSeat->id;
                                                        $group_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                        $countcg++;
                                                    }

                                                }

                                            }



                                        }
                                        else if($request->seat_plan_style_key_name=='sectioncombination'){

                                            if ($group_present_number % $group_count == $valueSeat->column_position % $group_count
                                                && $valueSeat->column_position%$group_present_number==0) {


                                                $group_seat_fill_up[] = $valueSeat->id;
                                                $group_seat_get_student[] = $single_student->id;


                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                $countcg++;

                                            }

                                        }



                                    }



                                }

                            }


                        }
                    }
                    $group_present_number++;



                }


                if(count($group_seat_get_student)<count($studentList)){

                    $restOfStudent=collect($studentList)->whereNotIn('id', $group_seat_get_student)->values();
                    $restOfSeat=collect($classDetail['room_setting_list'])
                        ->whereNotIn('id', $group_seat_fill_up)->values();


                    foreach ($restOfStudent as $k => $v){
                        $single_set = $restOfSeat[$k];

                        $declared_student_subject_idst = $group_declared_subject_base_student_list
                            ->where('student_history_id', $v->id)
                            ->pluck('id')
                            ->unique()
                            ->filter();

                        if($single_set){

                            $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_idst,
                                $single_set, $single_set->room_id, $request->seat_plan_type_id, $request->seat_plan_style_id);

                        }

                    }


                }



            }
            else{
                if(count($sectionIds)>0){



                    $section_count=count($sectionIds);
                    $section_present_number=1;
                    $seat_get_student=[];
                    $seat_fill_up=[];
                    foreach ($sectionIds as $keySection => $valueSection) {

                        $SectionStudentList=$studentList->where('academic_section_id', $valueSection)->values();

                        $section_student_ids=$studentList
                            ->where('academic_section_id', $valueSection)
                            ->pluck('id')->unique();

                        $section_declared_subject_base_student_list=$declared_subject_base_student_list
                            ->whereIn('student_history_id', $section_student_ids);



                        $counts=0;
                        foreach ($classDetail['room_ids'] as $keyRoom => $valueRoom) {

                            $roomList=collect($classDetail['room_setting_list'])
                                ->where('room_id', $valueRoom);


                            $room_column_ids=$roomList->pluck('column_position')->unique();

                            foreach ($room_column_ids as $keyRoomSetting => $valueRoomSetting) {

                                $seat_list = $roomList->where('column_position', $valueRoomSetting);

                                foreach ($seat_list as $keySeat => $valueSeat) {



                                    if (count($SectionStudentList) > $counts) {
                                        $single_student = $SectionStudentList[$counts];



                                        $declared_student_subject_ids = $section_declared_subject_base_student_list
                                            ->where('student_history_id', $single_student->id)
                                            ->pluck('id')
                                            ->unique()->filter();

                                    } else {
                                        $single_student = null;
                                    }



                                    if ($single_student) {



                                            if ($section_count == 1) {
                                                $seat_fill_up[] = $valueSeat->id;
                                                $seat_get_student[] = $single_student->id;


                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);

                                                $counts++;


                                            }
                                            else {

                                                if($request->seat_plan_style_key_name=='ztype'){

                                                    if($section_present_number%2==1){
                                                        if($valueSeat->column_position%2==1){

                                                            if($valueSeat->seat_number%2==1){
                                                                $seat_fill_up[] = $valueSeat->id;
                                                                $seat_get_student[] = $single_student->id;



                                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                                $counts++;
                                                            }
                                                        }else if($valueSeat->column_position%2==0){

                                                            if($valueSeat->seat_number%2==0){
                                                                $seat_fill_up[] = $valueSeat->id;
                                                                $seat_get_student[] = $single_student->id;



                                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);

                                                                $counts++;
                                                            }

                                                        }
                                                    }
                                                    else{

                                                        if($valueSeat->column_position%2==1){

                                                            if($valueSeat->seat_number%2==0){
                                                                $seat_fill_up[] = $valueSeat->id;
                                                                $seat_get_student[] = $single_student->id;


                                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                                $counts++;
                                                            }
                                                        }
                                                        else if($valueSeat->column_position%2==0){

                                                            if($valueSeat->seat_number%2==1){
                                                                $seat_fill_up[] = $valueSeat->id;
                                                                $seat_get_student[] = $single_student->id;


                                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);

                                                                $counts++;
                                                            }

                                                        }

                                                    }



                                                }
                                                else if($request->seat_plan_style_key_name=='sectioncombination'){

                                                    if ($section_present_number % $section_count == $valueSeat->column_position % $section_count
                                                        && $valueSeat->column_position%$section_present_number==0) {

                                                        $seat_fill_up[] = $valueSeat->id;
                                                        $seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


                                                        $counts++;

                                                    }
                                                }





                                            }



                                    }

                                }


                            }
                        }
                        $section_present_number++;



                    }


                    if(count($seat_get_student)<count($studentList)){


                        $restOfStudent=collect($studentList)->whereNotIn('id', $seat_get_student)->values();
                        $restOfSeat=collect($classDetail['room_setting_list'])
                            ->whereNotIn('id', $seat_fill_up)->values();

                        foreach ($restOfStudent as $k => $v){
                            $single_set = $restOfSeat[$k];

                            $declared_student_subject_ids = $section_declared_subject_base_student_list
                                ->where('student_history_id', $v->id)
                                ->pluck('id')
                                ->unique()->filter();

                            if($single_set){

                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                    $single_set, $single_set->room_id, $request->seat_plan_type_id, $request->seat_plan_style_id);

                            }

                        }


                    }




                }
                else{

                }

            }



        }
        else if($request->seat_plan_style_key_name=='onebyoneclass' || $request->seat_plan_style_key_name=='random'){

            $count=0;
            foreach ($classDetail['room_ids'] as $keyRoom => $valueRoom) {

                $roomList=collect($classDetail['room_setting_list'])
                    ->where('room_id', $valueRoom);


                $room_column_ids=$roomList->pluck('column_position')->unique();

                foreach ($room_column_ids as $keyRoomSetting => $valueRoomSetting) {

                    $seat_list=$roomList->where('column_position', $valueRoomSetting);

                    foreach ($seat_list as $keySeat => $valueSeat) {

                        if(count($studentList)>$count){
                            $single_student= $studentList[$count];

                            $declared_student_subject_ids= $declared_subject_base_student_list
                                ->where('student_history_id', $single_student->id)
                                ->pluck('id')
                                ->unique();

                        }else{
                            $single_student=null;
                        }


                        if($single_student){

                            $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);

                            $count++;

                        }
                    }
                }

            }

        }


    }





    private function AllClassRoomSeatPlan($request, $seatCombinationTypeBaseClassStudentRoomList){


        $student_history_ids= collect($seatCombinationTypeBaseClassStudentRoomList)->pluck('student_history_ids')->collapse()->unique();
        $room_setting_list= collect($seatCombinationTypeBaseClassStudentRoomList)->pluck('room_setting_list')->collapse()->unique();
        $room_ids= collect($seatCombinationTypeBaseClassStudentRoomList)->pluck('room_ids')->collapse()->unique();
        $site_exam_declare_student_subject_ids= collect($seatCombinationTypeBaseClassStudentRoomList)
            ->pluck('site_exam_declare_student_subject_ids')->collapse()->unique();




        if($request->seat_plan_style_key_name=='onebyoneclass' || $request->seat_plan_style_key_name=='classcombination' || $request->seat_plan_style_key_name=='ztype'){
            $studentList=StudentHistory::whereIn('id', $student_history_ids)
                ->select('id', 'academic_class_id', 'student_roll_number', 'academic_class_group_id', 'academic_section_id')
                ->orderBy('academic_class_id', 'asc')
                ->orderBy('academic_class_group_id', 'asc')
                ->orderBy('academic_section_id', 'asc')
                ->orderBy('student_roll_number', 'asc')
                ->get();
        }
        else if($request->seat_plan_style_key_name=='random'){

            $studentList=StudentHistory::whereIn('id', $student_history_ids)
                ->select('id', 'student_roll_number')
                ->inRandomOrder()
                ->get();
        }




        $declared_subject_base_student_list=SiteExamDeclareStudentSubject::
        whereIn('id', $site_exam_declare_student_subject_ids)
            ->select('id', 'student_history_id')
            ->get();




        if($request->seat_plan_style_key_name=='classcombination' || $request->seat_plan_style_key_name=='ztype'){



            if($request->seat_plan_style_key_name=='ztype' && count($seatCombinationTypeBaseClassStudentRoomList)>2){
                return Response::json(['message' => 'Z Type Seat Plan Can not Support More Then 2 Class!',
                    'mode' => 'Error!'], 200);
            }



            if(count($seatCombinationTypeBaseClassStudentRoomList)>0){




                $class_count=count($seatCombinationTypeBaseClassStudentRoomList);
                $class_present_number=1;
                $class_seat_get_student=[];
                $class_seat_fill_up=[];
                foreach ($seatCombinationTypeBaseClassStudentRoomList as $keyClass => $valueClass) {

                    $classStudentList=$studentList->where('academic_class_id', $valueClass['class_id'])->values();


                    $group_declared_subject_base_student_list=$declared_subject_base_student_list
                        ->whereIn('student_history_id', $valueClass['student_history_ids']);

//return $studentList;

                    $countc=0;
                    foreach ($room_ids as $keyRoom => $valueRoom) {

                        $roomList=collect($room_setting_list)
                            ->where('room_id', $valueRoom);


                        $room_column_ids=$roomList->pluck('column_position')->unique();

                        foreach ($room_column_ids as $keyRoomSetting => $valueRoomSetting) {

                            $seat_list = $roomList->where('column_position', $valueRoomSetting);

                            foreach ($seat_list as $keySeat => $valueSeat) {



                                if (count($classStudentList) > $countc) {
                                    $single_student = $classStudentList[$countc];



                                    $declared_student_subject_ids = $group_declared_subject_base_student_list
                                        ->where('student_history_id', $single_student->id)
                                        ->pluck('id')
                                        ->unique()->filter();

                                } else {
                                    $single_student = null;
                                }



                                if ($single_student) {



                                    if ($class_count == 1) {
                                        $class_seat_fill_up[] = $valueSeat->id;
                                        $class_seat_get_student[] = $single_student->id;

                                        $seat_set_column[]=$valueSeat->column_position;


                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


//                                        SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
//                                            ->update([
//                                                'site_base_exam_room_setting_id' => $valueSeat->id,
//                                                'room_id' => $valueRoom,
//                                                'column_position' => $valueSeat->column_position,
//                                                'seat_number' => $valueSeat->seat_number,
//                                                'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                                'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                            ]);

                                        $countc++;


                                    }
                                    else {



                                        if($request->seat_plan_style_key_name=='ztype'){

                                            if($class_present_number%2==1){
                                                if($valueSeat->column_position%2==1){

                                                    if($valueSeat->seat_number%2==1){
                                                        $class_seat_fill_up[] = $valueSeat->id;
                                                        $class_seat_get_student[] = $single_student->id;



                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


//                                                        SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
//                                                            ->update([
//                                                                'site_base_exam_room_setting_id' => $valueSeat->id,
//                                                                'room_id' => $valueRoom,
//                                                                'column_position' => $valueSeat->column_position,
//                                                                'seat_number' => $valueSeat->seat_number,
//                                                                'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                                                'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                                            ]);


                                                        $countc++;
                                                    }
                                                }
                                                else if($valueSeat->column_position%2==0){

                                                    if($valueSeat->seat_number%2==0){
                                                        $class_seat_fill_up[] = $valueSeat->id;
                                                        $class_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


//                                                        SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
//                                                            ->update([
//                                                                'site_base_exam_room_setting_id' => $valueSeat->id,
//                                                                'room_id' => $valueRoom,
//                                                                'column_position' => $valueSeat->column_position,
//                                                                'seat_number' => $valueSeat->seat_number,
//                                                                'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                                                'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                                            ]);


                                                        $countc++;
                                                    }

                                                }
                                            }
                                            else{

                                                if($valueSeat->column_position%2==1){

                                                    if($valueSeat->seat_number%2==0){
                                                        $class_seat_fill_up[] = $valueSeat->id;
                                                        $class_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


//                                                        SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
//                                                            ->update([
//                                                                'site_base_exam_room_setting_id' => $valueSeat->id,
//                                                                'room_id' => $valueRoom,
//                                                                'column_position' => $valueSeat->column_position,
//                                                                'seat_number' => $valueSeat->seat_number,
//                                                                'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                                                'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                                            ]);


                                                        $countc++;
                                                    }
                                                }
                                                else if($valueSeat->column_position%2==0){

                                                    if($valueSeat->seat_number%2==1){
                                                        $class_seat_fill_up[] = $valueSeat->id;
                                                        $class_seat_get_student[] = $single_student->id;


                                                        $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                            $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


//                                                        SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
//                                                            ->update([
//                                                                'site_base_exam_room_setting_id' => $valueSeat->id,
//                                                                'room_id' => $valueRoom,
//                                                                'column_position' => $valueSeat->column_position,
//                                                                'seat_number' => $valueSeat->seat_number,
//                                                                'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                                                'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                                            ]);


                                                        $countc++;
                                                    }

                                                }

                                            }



                                        }
                                        else if($request->seat_plan_style_key_name=='classcombination'){

                                            if ($class_present_number % $class_count == $valueSeat->column_position % $class_count
                                                && $valueSeat->column_position%$class_present_number==0) {

                                                $class_seat_fill_up[] = $valueSeat->id;
                                                $class_seat_get_student[] = $single_student->id;


                                                $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                                    $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);


//                                                SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
//                                                    ->update([
//                                                        'site_base_exam_room_setting_id' => $valueSeat->id,
//                                                        'room_id' => $valueRoom,
//                                                        'column_position' => $valueSeat->column_position,
//                                                        'seat_number' => $valueSeat->seat_number,
//                                                        'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                                        'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                                    ]);


                                                $countc++;

                                            }

                                        }



                                    }



                                }

                            }


                        }
                    }
                    $class_present_number++;



                }


                if(count($class_seat_get_student)<count($studentList)){

                    \Log::info('ok');

                    $restOfStudent=collect($studentList)->whereNotIn('id', $class_seat_get_student)->values();
                    $restOfSeat=collect($room_setting_list)
                        ->whereNotIn('id', $class_seat_fill_up)->values();


                    foreach ($restOfStudent as $k => $v){
                        $single_set = $restOfSeat[$k];

                        $declared_student_subject_idst = $group_declared_subject_base_student_list
                            ->where('student_history_id', $v->id)
                            ->pluck('id')
                            ->unique()
                            ->filter();

                        if($single_set){

                            $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_idst,
                                $single_set, $single_set->room_id, $request->seat_plan_type_id, $request->seat_plan_style_id);

//                            SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_idst)
//                                ->update([
//                                    'site_base_exam_room_setting_id' => $single_set->id,
//                                    'room_id' => $single_set->room_id,
//                                    'column_position' => $single_set->column_position,
//                                    'seat_number' => $single_set->seat_number,
//                                    'academic_seat_plan_type_id'=>$request->seat_plan_type_id,
//                                    'academic_seat_plan_style_id'=>$request->seat_plan_style_id,
//                                ]);
                        }

                    }


                }



            }




        }







        else if($request->seat_plan_style_key_name=='onebyoneclass' || $request->seat_plan_style_key_name=='random'){

            $count=0;

            foreach ($room_ids as $keyRoom => $valueRoom) {

                $roomList=collect($room_setting_list)
                    ->where('room_id', $valueRoom);


                $room_column_ids=$roomList->pluck('column_position')->unique();

                foreach ($room_column_ids as $keyRoomSetting => $valueRoomSetting) {

                    $seat_list = $roomList->where('column_position', $valueRoomSetting);

                    foreach ($seat_list as $keySeat => $valueSeat) {



                        if (count($studentList) > $count) {
                            $single_student = $studentList[$count];



                            $declared_student_subject_ids = $declared_subject_base_student_list
                                ->where('student_history_id', $single_student->id)
                                ->pluck('id')
                                ->unique()->filter();

                        }
                        else {
                            $single_student = null;
                        }


                        if($single_student){

                            $this->updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids,
                                $valueSeat, $valueRoom, $request->seat_plan_type_id, $request->seat_plan_style_id);



                            $count++;

                        }
                    }
                }

            }

        }







    }



    private function updateSiteExamDeclareStudentSubjectSeatPlan($declared_student_subject_ids, $valueSeat,$valueRoom,
                                                            $seat_plan_type_id, $seat_plan_style_id){

        SiteExamDeclareStudentSubject::whereIn('id', $declared_student_subject_ids)
            ->update([
                'Site_base_exam_room_setting_id'=>$valueSeat->id,
                'room_id'=>$valueRoom,
                'column_position'=>$valueSeat->column_position,
                'seat_number'=>$valueSeat->seat_number,

                'academic_seat_plan_type_id'=>$seat_plan_type_id,
                'academic_seat_plan_style_id'=>$seat_plan_style_id,


            ]);

    }






    public function siteDateTimeBaseSeatPlanCopyToOhterDateTime(Request $request){


        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('id');


        // Date list for routine
        $routine_ids=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->orderBy('exam_start_date')
            ->pluck('id')->values();

        $checkRoutineSeatdeclared=SiteExamDeclareStudentSubject::select('id', 'student_history_id',
            'site_exam_routine_id', 'academic_exam_type_id', 'site_subject_group_condition_setting_id',
            'site_base_exam_room_setting_id', 'room_id', 'column_position', 'seat_number',
            'academic_seat_plan_type_id', 'academic_seat_plan_style_id')
            ->whereIn('site_exam_routine_id', $routine_ids)
            ->whereNotNull('room_id')
            ->get();

        $fixed_student_history_ids=$checkRoutineSeatdeclared->pluck('student_history_id')->unique();
        $fixed_exam_type_ids=$checkRoutineSeatdeclared->pluck('academic_exam_type_id')->unique();


        $selected_date_routine_list=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->whereIn('exam_start_date', $request->selected_exam_date_array)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->orderBy('exam_start_date')
            ->get();



        $checkedDateStudentSubjectList=SiteExamDeclareStudentSubject::select('id', 'student_history_id',
            'site_exam_routine_id', 'academic_exam_type_id', 'site_subject_group_condition_setting_id',
            'site_base_exam_room_setting_id', 'room_id', 'column_position', 'seat_number',
            'academic_seat_plan_type_id', 'academic_seat_plan_style_id')
            ->whereIn('site_exam_routine_id', $selected_date_routine_list->pluck('id')->unique())
            ->whereIn('student_history_id', $fixed_student_history_ids)
            ->whereIn('academic_exam_type_id', $fixed_exam_type_ids)
//            ->whereNotNull('room_id')
            ->get();



        foreach ($fixed_student_history_ids as $key => $value) {

            foreach ($fixed_exam_type_ids as $keys => $values) {

                $get_single_student_seat_plan=$checkRoutineSeatdeclared
                    ->where('student_history_id', $value)
                    ->where('academic_exam_type_id', $values)
                    ->first();

                $get_single_student_for_seat_plan_copy=$checkedDateStudentSubjectList
                    ->where('student_history_id', $value)
                    ->where('academic_exam_type_id', $values);

                if($request->copy_type=='fullcopy'){

                    if(count($get_single_student_for_seat_plan_copy)>0){
                        SiteExamDeclareStudentSubject::whereIn('id', $get_single_student_for_seat_plan_copy->pluck('id')->unique())
                            ->update([
                                'Site_base_exam_room_setting_id'=>$get_single_student_seat_plan->site_base_exam_room_setting_id,
                                'room_id'=>$get_single_student_seat_plan->room_id,
                                'column_position'=>$get_single_student_seat_plan->column_position,
                                'seat_number'=>$get_single_student_seat_plan->seat_number,

                                'academic_seat_plan_type_id'=>$get_single_student_seat_plan->academic_seat_plan_type_id,
                                'academic_seat_plan_style_id'=>$get_single_student_seat_plan->academic_seat_plan_style_id,


                            ]);
                    }

                }
                else if($request->copy_type=='copyonlynew'){

                    if(count($get_single_student_for_seat_plan_copy)>0){

                        foreach ($get_single_student_for_seat_plan_copy as $keyst => $valuest) {

                            if(!$valuest->room_id){
                                SiteExamDeclareStudentSubject::where('id', $valuest->id)
                                    ->update([
                                        'Site_base_exam_room_setting_id'=>$get_single_student_seat_plan->site_base_exam_room_setting_id,
                                        'room_id'=>$get_single_student_seat_plan->room_id,
                                        'column_position'=>$get_single_student_seat_plan->column_position,
                                        'seat_number'=>$get_single_student_seat_plan->seat_number,

                                        'academic_seat_plan_type_id'=>$get_single_student_seat_plan->academic_seat_plan_type_id,
                                        'academic_seat_plan_style_id'=>$get_single_student_seat_plan->academic_seat_plan_style_id,


                                    ]);
                            }

                        }

                    }

                }






            }

        }


        return Response::json(['message' => 'Copy Successfully!', 'mode' => 'Save!'], 200);




    }





    public function siteExamSeatPlanFullDelete(Request $request){


        $examDateTime = Carbon::createFromFormat('Y-m-d H:i:s', "$request->examination_date $request->examination_time");
        $today=Carbon::now();
//        if($today>$examDateTime){
//            return Response::json(['message' => 'Due to the time out, You can not delete this seat plan!.',
//                'mode' => 'Error!'], 200);
//        }else{
//            $interval = $today->diffInHours($examDateTime);
//
//            if($interval<12){
//                return Response::json(['message' => 'Due to the time out, You can not delete this seat plan!.',
//                    'mode' => 'Error!'], 200);
//            }
//        }


        $exam_declare_ids=SiteExamDeclares::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('id');


        // Date list for routine
        $routine_ids=SiteExamRoutine::whereIn('site_exam_declare_id', $exam_declare_ids)
            ->where('exam_start_date', $request->examination_date)
            ->where('exam_start_time', date("H:i", strtotime($request->examination_time)))
            ->orderBy('exam_start_date')
            ->pluck('id')->values();

        $checkRoutineSeatdeclaredIDs=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereNotNull('room_id')
            ->pluck('id');


        SiteExamDeclareStudentSubject::whereIn('id', $checkRoutineSeatdeclaredIDs)
            ->update([
                'Site_base_exam_room_setting_id'=>null,
                'room_id'=>null,
                'column_position'=>null,
                'seat_number'=>null,

                'academic_seat_plan_type_id'=>null,
                'academic_seat_plan_style_id'=>null,


            ]);

        return Response::json(['message' => 'Delete Successfully!', 'mode' => 'delete!'], 200);
    }















}
