<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Exam\Question\SiteExamStudentQuestion;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Student\StudentHistory;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Mpdf\Tag\P;
use Response;
use Session;

class SiteBaseExamAttendanceController extends ProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Site Exam Attendance Page';

        return view('default.admin.layouts.master', compact('viewType'));
        //        return view('default.admin.site.exam.site-base-exam-attendance', compact('viewType'));

    }



    public function getSiteExaminationBaseSubjectListForAttendance(Request $request)
    {

        $data = $request->all();

        $declareListIds = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('id');


        $studentHistoryIds = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


        $site_subject_group_condition_setting_ids = SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $declareListIds)
            ->whereIn('student_history_id', $studentHistoryIds)
            ->pluck('site_subject_group_condition_setting_id')
            ->unique()
            ->values();

        $subjectIDs_array = SubjectGroupConditionSetting::whereIn('id', $site_subject_group_condition_setting_ids)->get();

        return $subjectIDs_array;
    }


    public function getSiteStudentListForAttendance(Request $request)
    {

        $data = $request->all();
      
        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('id');



        $this->getMachineDataAndUpdate($request, $examDeclaredList);

        $studentIds = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number', 'asc')
            ->where('status', true)
            ->pluck('id');


        $declaredStudentList = SiteExamDeclareStudent::with([
            'siteExamDeclareStudentSubject' => function ($query) use ($request) {
                $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);
                $query->with(['academicExamType']);
                $query->select(
                    'id',
                    'site_subject_group_condition_setting_id',
                    'academic_exam_type_id',
                    'examination_id',
                    'site_exam_routine_id',
                    'student_history_id',
                    'site_exam_declare_id',
                    'site_exam_declare_student_id',
                    'exam_attendance_status',
                    'exam_held_status',
                    'attendance_submit_by',
                    'attendance_submit_by_machine'
                );
            },
            'studentHistory' => function ($querys) use ($data) {
                $querys->select('id', 'user_id', 'student_roll_number_prefix', 'student_roll_number');
                $querys->with('siteGroupStudentExamRoll');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                })

                    ->orderBy('student_roll_number_prefix', 'asc')
                    ->orderBy('student_roll_number', 'asc');
            }
        ])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->get();

        $declaredStudentList->transform(function ($item) {
            $item->student_exam_roll_number = $item->studentHistory->siteGroupStudentExamRoll->roll ?? '';
            return $item;
        });

        $student_list = [];
        foreach ($declaredStudentList as $key => $value) {

            if (count($value->siteExamDeclareStudentSubject) > 0) {
                $student_list[] = $value;
            }
        }


        $student_asc_list = array_values(array_sort(collect($student_list), function ($value) {
            return $value['student_roll_number'];
        }));

        ////

        $examinationIDs = SiteSubjectExaminationMark::where('examination_id', $request->examination_id)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->pluck('id')
            ->unique()
            ->filter();

        $examTypeIDs = SiteSubjectExaminationExamTypeMark::whereIn('site_subject_examination_mark_id', $examinationIDs)
            ->pluck('academic_exam_type_id')
            ->unique()
            ->filter();

        ////


        $get_type_ids = SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->whereIn('academic_exam_type_id', $examTypeIDs)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->where('status', true)
            ->pluck('academic_exam_type_id')
            ->unique()
            ->values();


      //  $get_type_ids = $getExamTypeList->pluck('academic_exam_type_id')->unique()->values();

        $getExamType = SiteExaminationExamTypeSetting::with(['academicExamType'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->whereIn('academic_exam_type_id', $get_type_ids)
            ->where('direct_result_input', false)
            ->where('examination_id', $data['examination_id'])
            ->orderBy('position_show')
            ->get();

        //  dd($get_type_ids);


        // $exam_type_arr = array();
        // $exam_type_array = [];
        // foreach ($getExamType as $key => $value) {

        //     $selected_student_count = $getExamTypeList
        //         ->where('academic_exam_type_id', $value->academic_exam_type_id)
        //         ->where('exam_attendance_status', true)
        //         ->whereRaw('obtaine_marks >= pass_mark')
        //         ->count();

        //     $passed_student_count=$getExamTypeList->where('academic_exam_type_id', $value->academic_exam_type_id)
        //         ->where('exam_attendance_status', true)
        //         ->count();


        //     $passed_student_count = SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclaredList)
        //         ->whereIn('student_history_id', $studentIds)
        //         ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
        //         ->where('academic_exam_type_id', $value->academic_exam_type_id)
        //         ->where('exam_attendance_status', true)
        //         ->where('status', true)
        //         ->whereRaw('obtaine_marks >= pass_mark')
        //         ->count();

        //     $failed_student_count = SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclaredList)
        //         ->whereIn('student_history_id', $studentIds)
        //         ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
        //         ->where('academic_exam_type_id', $value->academic_exam_type_id)
        //         ->where('exam_attendance_status', true)
        //         ->where('status', true)
        //         ->whereRaw('obtaine_marks < pass_mark')
        //         ->count();


        //     $exam_type_arr['selected_student_count'] = $selected_student_count;
        //     $exam_type_arr['passed_student_count'] = $passed_student_count;
        //     $exam_type_arr['failed_student_count'] = $failed_student_count;
        //     $exam_type_arr['select_all'] = false;


        //     $exam_type_array[$key] = array_merge($exam_type_arr, $value->toArray());
        // }

        return [$student_asc_list, $getExamType];
    }

    public function getSiteDepartmentClassBaseExamination(Request $request)
    {

        $data = $request->all();

        $examinationAll = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('examination_id')
            ->unique();



        $examination_list = Examination::whereIn('id', $examinationAll)->get();


        return $examination_list;
    }




    private function getMachineDataAndUpdate($request, $examDeclaredList)
    {

        $date = Carbon::today();

        $exam_routine_list = SiteExamRoutine::whereIn('site_exam_declare_id', $examDeclaredList)
                ->where('exam_start_date', Carbon::today())
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->get();

            if(count($exam_routine_list)){

            $routine_ids = $exam_routine_list->pluck('id')->unique()->filter();
            $routine_exam_start_date = $exam_routine_list->pluck('exam_start_date')->first();
            $routine_exam_end_time = $exam_routine_list->pluck('exam_end_time')->first();


            $routine_base_student_ids = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                ->pluck('student_history_id')
                ->unique()
                ->values();


            //        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)->update([
            //            'exam_held_status'=>false,
            //            'attendance_submit_by_machine'=>false,
            //            'attendance_update_at'=>null,
            //            'attendance_submit_by'=>null,
            //            'exam_attendance_status'=>false,
            //        ]);


            $check_student_punch_status = StudentAttendance::where('present_date', $routine_exam_start_date)
                ->where('present_date', $date->format('Y-m-d'))
                ->whereIn('student_history_id', $routine_base_student_ids)
                ->select('id', 'student_history_id', 'late_status')
                ->first();


            if ($check_student_punch_status) {


                $check_exam_held_status_all_student = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                    ->where('exam_attendance_status', true)
                    ->first();

                if (!$check_exam_held_status_all_student) {

                    SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)->update([
                        'exam_held_status' => true,
                    ]);
                }



                $machin_student_ids = StudentAttendance::where('present_date', $routine_exam_start_date)
                    ->where('present_date', $date->format('Y-m-d'))
                    ->where('in_time', '<', $routine_exam_end_time)
                    ->whereIn('student_history_id', $routine_base_student_ids)
                    ->pluck('student_history_id')
                    ->unique()
                    ->filter();


                SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                    ->whereIn('student_history_id', $machin_student_ids)
                    ->where('exam_attendance_status', false)
                    ->where('attendance_submit_by', null)
                    ->update([
                        'exam_held_status' => true,
                        'exam_attendance_status' => true,
                        'attendance_submit_by_machine' => true,
                        'attendance_update_at' => Carbon::now(),
                    ]);
            }
        }
    }


    // public function checkExaminationPermission($request, $permission_key){
      
            
    //         $examTypeSett = SiteExaminationExamTypeSetting::where('academic_year_id', $request->academic_year_id)
    //             ->where('academic_class_id', $request->academic_class_id)
    //             ->where('examination_id', $request->examination_id)
    //             ->where('site_attendace_permission', true)
    //             ->first();

    //        /// dd($request->all());

    //         if($examTypeSett){
    //             if($examTypeSett->routine_wise_exam_attendace){

    //                 $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
    //                     ->where('academic_year_id', $request->academic_year_id)
    //                     ->where('academic_shift_id', $request->academic_shift_id)
    //                     ->where('academic_class_id', $request->academic_class_id)
    //                     ->where('examination_id', $request->examination_id)
    //                     ->first();
    //                 if(!$examDeclaredList){
    //                     $response=['status'=>false,'message'=>'Exam Declare not found!'];
    //                 }

    //                 $date = Carbon::today();
    //                 $exam_routine_list = SiteExamRoutine::where('site_exam_declare_id', $examDeclaredList->id)
    //                     ->where('exam_start_date', $date->format('Y-m-d'))
    //                     ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
    //                     ->get();

    //                     if(!count($exam_routine_list)){
    //                         $response= ['status'=>false,'message'=>'There has been no announcement about the exam today!'];
    //                     }
    //             }

    //             $response= ['status'=>true,'message'=>'success'];

    //         }else{
    //             $response= ['status'=>false,'message'=>'You have no permission, Please contact to admin'];
    //         }

    //         return $response;

    // }


    public function siteStudentExamAttendanceEntry(Request $request)
    {

        $data = $request->all();
      

        $getExamSettingsList = SiteExaminationExamTypeSetting::with(['academicExamType'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('examination_id', $data['examination_id'])
            ->orderBy('position_show')
            ->get();

          $examRoutineList = SiteExamRoutine::where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)->get();

        // $checkPermission=$this->checkExaminationPermission($request,'site_attendace_permission');

        // if($checkPermission['status']==false){
        //     return Response::json(['message' => $checkPermission['message'], 'status'=>'403'], 403);
        // }


        $examination=Examination::where('id',$request->examination_id)->first();

        $exam_type_array = [];
        foreach ($request->StudentListForAttendance as $key => $value) {

            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {
                $exam_type_array[] = $values;
            }
        }


        $exam_type_Ids = collect($exam_type_array)->pluck('academic_exam_type_id')->unique()->filter();

        $exam_heald_exam_type = [];
        foreach ($exam_type_Ids as $key => $value) {

            $check_exam_heald = collect($exam_type_array)
                ->where('academic_exam_type_id', $value)
                ->where('exam_attendance_status', true)
                ->first();

            if ($check_exam_heald) {

                $exam_heald_exam_type[] = $check_exam_heald;
            }
        }

        foreach ($request->StudentListForAttendance as $key => $value) {

            $examRoutineList = $examRoutineList->where('site_exam_declare_id', $value['site_exam_declare_id']);

            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {

                /////

                $checkPermission=$this->checkExamAttendancePermission($getExamSettingsList, $examRoutineList, $examination, $values);

               if($checkPermission['status']!='200'){
                    return Response::json(['message' => $checkPermission['message'], 'status'=>$checkPermission['status']], $checkPermission['status']);
                }

                //////

                if ($values['exam_attendance_status'] == true) {
                    $exam_attendance_status = true;
                } else {
                    $exam_attendance_status = false;
                }

                $exam_held_status = false;

            //////

                $check_data = collect($exam_heald_exam_type)->where('academic_exam_type_id', $values['academic_exam_type_id'])->first();

                if ($check_data) {
                    $exam_held_status = true;
                } else {
                    $exam_held_status = false;
                }

                $exam_attendance_status = $values['exam_attendance_status'];

                SiteExamDeclareStudentSubject::where('id', $values['id'])
                    ->where(function ($query) {
                        $query->where('obtaine_marks', 0)
                            ->orWhereNull('obtaine_marks');
                    })
                    ->update([
                        'exam_attendance_status' => $exam_attendance_status,
                        'exam_held_status' => $exam_held_status,
                        'attendance_update_at' => Carbon::now(),
                        'attendance_submit_by' => Auth::user()->id,
                    ]);
            }
        }

        return Response::json(['message' => 'Attendance Entry Successfully!', 'mode' => 'Create!'], 200);
    }



    //===========Online exam attendance

    public function getExamDateBaseExamTimeForAdmin(Request $request)
    {

        $exam_date = Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_list = SiteExamRoutine::where('exam_start_date', $exam_date)
            ->where('status', true)
            ->pluck('exam_start_time')
            ->unique()
            ->values();

        $exam_date_array = [];
        $exam_date_arr = array();
        foreach ($exam_time_list as $key => $value) {

            $exam_date_arr['exam_start_time'] = $value;
            $exam_date_array[$key] = $exam_date_arr;
        }

        return $exam_date_array;
    }

    public function getExamDateTimeBaseOnlineExamStatistics(Request $request)
    {

        $exam_date = Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_base_declare_routine_list = SiteExamRoutine::where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->get();



        $routine_ids = $exam_time_base_declare_routine_list->pluck('id')->unique()->filter();


        //        $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
        //            ->where('exam_start_date', $exam_date)
        //            ->where('exam_start_time', $request->examination_time)
        //            ->where('status', true)
        //            ->pluck('room_id')->unique();




        $routine_base_student = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->select(
                'id',
                'room_id',
                'column_position',
                'student_history_id',
                'site_exam_routine_id',
                'seat_number',
                'academic_exam_type_id',
                'exam_attendance_status',
                'site_subject_group_condition_setting_id',
                'exam_held_status',
                'attendance_submit_by',
                'attendance_submit_by_machine',
                'online_exam_status',
                'online_exam_present_by_student',
                'online_exam_start_by_teacher',
                'online_exam_start',
                'online_exam_end',
                'online_exam_end_time',
                'online_exam_pause',
                'online_exam_pause_time',
                'online_exam_apply_for_restart',
                'online_exam_restart_apply_time',
                'online_exam_restart_apply_amount',
                'online_exam_restart_approve',
                'obtaine_marks'
            )
            ->get();

        $exam_type_ids = $routine_base_student->pluck('academic_exam_type_id')->unique()->values();

        $exam_type_array = AcademicExamType::whereIn('id', $exam_type_ids)->get();


        $exam_type_arr = array();
        $exam_type_list = [];
        foreach ($exam_type_array as $key => $value) {

            $exam_type_base_student = $routine_base_student->where('academic_exam_type_id', $value->id);
            $online_exam_check = $exam_type_base_student->where('online_exam_status', true)->first();

            $online_exam_present_by_student = $exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', false)
                ->count();

            $online_exam_restart_by_student = $exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', true)
                ->where('online_exam_apply_for_restart', true)
                ->where('online_exam_restart_approve', false)
                ->count();

            $online_exam_end = $exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', true)
                ->where('online_exam_end', false)
                ->count();


            $online_exam_end_cancel = $exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', true)
                ->where('online_exam_end', true)
                ->count();


            $exam_type_arr['id'] = $value->id;
            $exam_type_arr['marks_type'] = $value->marks_type;
            $exam_type_arr['online_exam_status'] = $online_exam_check ? true : false;
            $exam_type_arr['online_exam_present_by_student'] = $online_exam_present_by_student;
            $exam_type_arr['online_exam_restart_by_student'] = $online_exam_restart_by_student;
            $exam_type_arr['online_exam_end'] = $online_exam_end;
            $exam_type_arr['online_exam_end_cancel'] = $online_exam_end_cancel;

            $exam_type_arr['show_loading'] = false;


            $exam_type_list[$key] = $exam_type_arr;
        }

        return response()->json(
            [
                'exam_type_list' => $exam_type_list,
            ]
        );
    }



    public function startOnlineExamForAllStudent(Request $request)
    {

        $exam_date = Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_base_declare_routine_list = SiteExamRoutine::where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->get();


        $routine_ids = $exam_time_base_declare_routine_list->pluck('id')->unique()->filter();


        $student_list = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', false)
            ->where('online_exam_end', false)
            ->get();


        $user_name = Employee::where('id', \Auth::user()->id)->first();
        //=====Log Start
        $issue = new    IssueDetail();
        $issue->issue_type = 'exam:admin-start';
        $issue->issue_details = "Admin Start the exam. " . count($student_list) . "student.";
        $issue->bearer_type = 'site';
        $issue->bearer_id = \Session::get('SITE_ID');
        $issue->username = $user_name->username;
        $issue->ip_address = request()->ip();
        $issue->save();

        //=====Log End

        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', false)
            ->where('online_exam_end', false)
            ->update([
                'online_exam_start_by_teacher' => true,
                'exam_attendance_status' => true,
                'attendance_submit_by' => Auth::user()->id,
                'attendance_update_at' => Carbon::now(),

            ]);

        return Response::json(['message' => 'Exam Start Successfully!', 'mode' => 'Create!'], 200);
    }



    public function reStartOnlineExamForAllStudent(Request $request)
    {

        $exam_date = Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_base_declare_routine_list = SiteExamRoutine::where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->get();



        $routine_ids = $exam_time_base_declare_routine_list->pluck('id')->unique()->filter();

        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', true)
            ->where('online_exam_apply_for_restart', true)
            ->where('online_exam_end', false)
            ->where('online_exam_restart_approve', false)
            ->update([
                'online_exam_restart_approve' => true,

            ]);


        return Response::json(['message' => 'Exam Start Successfully!', 'mode' => 'Create!'], 200);
    }


    public function endOnlineExamForAllStudent(Request $request)
    {

        $exam_date = Carbon::parse($request->exam_date)->format('Y-m-d');
        $current_time = Carbon::now();

        $exam_time_base_declare_routine_list = SiteExamRoutine::where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->get();

        $routine_ids = $exam_time_base_declare_routine_list->pluck('id')->unique()->filter();

        $student_list_for_end = SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', true)
            ->where('online_exam_end', false)
            ->get();


        if (count($student_list_for_end) > 0) {
            foreach ($student_list_for_end as $keys => $values) {

                $question_list_detail = SiteExamStudentQuestion::where('site_exam_declare_student_subject_id', $values->id)
                    ->get();
                $question_ids = $question_list_detail->pluck('site_exam_question_id')->unique();

                $exam_question_all_list = SiteExamQuestion::whereIn('id', $question_ids)->get();

                $exam_question_total_number = $exam_question_all_list->sum('mark');

                $exam_obtain_mark = [];
                foreach ($question_list_detail as $key => $value) {

                    $answer_check = array_diff(explode(',', $value->answer_ids), explode(',', $value->student_answer_ids));
                    if (count($answer_check) == 0) {
                        $right_answere_marks = SiteExamQuestion::where('id', $value->site_exam_question_id)->first();
                        $exam_obtain_mark[] = $right_answere_marks->mark;
                    }
                }

                $obtain_exam_marks_total = array_sum($exam_obtain_mark);



                if ($exam_question_total_number) {
                    $obtain_final_marks = ($obtain_exam_marks_total * $values->subject_exam_type_mark) / $exam_question_total_number;
                } else {
                    $obtain_final_marks = 0;
                }

                SiteExamDeclareStudentSubject::where('id', $values->id)
                    ->update([
                        'online_exam_end' => true,
                        'online_exam_end_time' => $current_time->toTimeString(),
                        'obtaine_marks' => $obtain_final_marks,
                    ]);
            }
        }



        $user_name = Employee::where('id', \Auth::user()->id)->first();
        //=====Log Start
        $issue = new    IssueDetail();
        $issue->issue_type = 'exam:admin-end';
        $issue->issue_details = "Admin End the exam. " . count($student_list_for_end) . "student.";
        $issue->bearer_type = 'site';
        $issue->bearer_id = \Session::get('SITE_ID');
        $issue->username = $user_name->username;
        $issue->ip_address = request()->ip();
        $issue->save();

        //=====Log End




        return Response::json(['message' => 'Exam End Successfully!', 'mode' => 'Create!'], 200);
    }


    public function endCancelOnlineExamForAllStudent(Request $request)
    {

        $exam_date = Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_base_declare_routine_list = SiteExamRoutine::where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->get();



        $routine_ids = $exam_time_base_declare_routine_list->pluck('id')->unique()->filter();




        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', true)
            ->where('online_exam_end', true)
            ->update([
                'online_exam_restart_approve' => true,
                'online_exam_apply_for_restart' => true,
                'online_exam_time_left' => $request->exam_time_left ? $request->exam_time_left : 0,
                'online_exam_end' => false,

            ]);



        return Response::json(['message' => 'Exam Start Successfully!', 'mode' => 'Create!'], 200);
    }


    //===============End Exam Cancel
    public function getSiteStudentListForEndExamCancel(Request $request)
    {



        $data = $request->all();



        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            //            ->where('site_subject_group_condition_setting_ids', $request->site_subject_group_condition_setting_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            //            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            //            })
            //            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
            //                return $query->where('academic_section_id', $data['academic_section_id']);
            //            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->pluck('id');



        $this->getMachineDataAndUpdate($request, $examDeclaredList);




        $studentIds = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


        $declaredStudentList = SiteExamDeclareStudent::with([
            'siteExamDeclareStudentSubject' => function ($query) use ($request) {
                $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);
                $query->with(['academicExamType']);
                $query->select(
                    'id',
                    'academic_exam_type_id',
                    'examination_id',
                    'site_exam_routine_id',
                    'student_history_id',
                    'site_exam_declare_id',
                    'site_exam_declare_student_id',
                    'exam_attendance_status',
                    'exam_held_status',
                    'attendance_submit_by',
                    'attendance_submit_by_machine',
                    'exam_attendance_status',
                    'site_subject_group_condition_setting_id',
                    'online_exam_status',
                    'online_exam_start',
                    'online_exam_end',
                    'online_exam_end_time',
                    'obtaine_marks'
                );
            },
            'studentHistory' => function ($querys) use ($data) {

                $querys->select('id', 'user_id', 'student_roll_number');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                });
            }
        ])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->get();




        $student_list = [];
        $student_listarr = array();
        foreach ($declaredStudentList as $key => $value) {

            if (count($value->siteExamDeclareStudentSubject) > 0) {

                $student_list[] = $value;
            }
        }

        $student_asc_list = array_values(array_sort(collect($student_list), function ($value) {
            return $value['student_roll_number'];
        }));


        $getExamType = SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();



        $exam_type_arr = array();
        $exam_type_array = [];
        foreach ($getExamType as $key => $value) {

            $selected_student_count = SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->count();



            $exam_type_arr['selected_student_count'] = $selected_student_count;
            $exam_type_arr['select_all'] = false;


            $exam_type_array[$key] = array_merge($exam_type_arr, $value->toArray());
        }




        return [$student_asc_list, $exam_type_array];
    }




    public function studentEndOnlineExamCancel(Request $request)
    {

        SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->where('online_exam_status', true)
            ->where('online_exam_end', true)
            ->update([
                'online_exam_restart_approve' => true,
                'online_exam_apply_for_restart' => true,
                'online_exam_time_left' => 0,
                'online_exam_end' => false,

            ]);


        $get_data = SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->where('online_exam_status', true)
            ->first();

        return response()->json(
            [
                'online_exam_status' => $get_data->online_exam_status,
                'online_exam_end' => $get_data->online_exam_end,

            ]
        );
    }

        
    public function checkExamAttendancePermission($getExamSettingsList, $examRoutineList, $examination, $values){
        if(Session::get('USER_TYPE')=='site'){
            if($examination->use_key=='site_group'){

                $checkSetting=$getExamSettingsList->where('academic_exam_type_id', $values['academic_exam_type_id'])->first();

                if($checkSetting){
                    if($checkSetting->site_attendace_permission==false){
                        return ['message'=>'You have no permission to take attendance!','status'=>'403'];
                    }

                    if($checkSetting->routine_wise_exam_attendace==false){
                        $date = Carbon::today();
                        $checkRoutine = $examRoutineList->where('academic_exam_type_id', $values['academic_exam_type_id'])
                            ->where('exam_start_date', $date->format('Y-m-d'))
                            ->first();

                        if(!$checkRoutine){
                                return ['message'=>'There has been no announcement about the exam today!','status'=>'403'];
                        }
            
                    }
                }
                
            }
        }

            return ['message'=>'pass success','status'=>'200'];
    }

}
