<?php

namespace App\Http\Controllers\Site\Exam;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use Carbon\Carbon;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupExamDeclareStore;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Illuminate\Support\Facades\Log;
use Response;
use Session;

use PDF;
use Illuminate\Support\facades\Http;



class SiteBaseExamMarksController extends Controller
{
    private $siteExamDeclareStudentSubject;
    public function __construct(SiteExamDeclareStudentSubject $siteExamDeclareStudentSubject)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteExamDeclareStudentSubject = $siteExamDeclareStudentSubject;
    }

    public function index()
    {
        $viewType = 'Site Exam Marks Entry Page';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site.exam.site-base-exam-marks-entry', compact('viewType'));
    }
public function studetnsSubjectMarkStatisticsList(Request $request)
{
    $data     = $request->all();
    $groupId  = Session::get('ACADEMIC_GROUP_ID');
    $site_id  = Session::get('SITE_ID');

    // Fetch declared exam for selected filters
    $examDeclar = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->where('examination_id', $request->examination_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->first();

    // Get students based on academic filters
    $studentHistories = StudentHistory::where([
        ['academic_version_id', $request->academic_version_id],
        ['academic_shift_id', $request->academic_shift_id],
        ['academic_year_id', $request->academic_year_id],
        ['academic_class_id', $request->academic_class_id],
        ['status', true],
    ])
        ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
        ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
        ->when(!empty($data['academic_section_id']), fn($q) => $q->where('academic_section_id', $data['academic_section_id']))
        ->when(!empty($data['academic_session_id']), fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
        ->get();

    // Get declared exams for the current site
    $siteExamDeclares = GlobalSiteExamDeclares::where([
        ['academic_group_id', $groupId],
        ['academic_version_id', $request->academic_version_id],
        ['academic_year_id', $request->academic_year_id],
        ['academic_shift_id', $request->academic_shift_id],
        ['academic_class_id', $request->academic_class_id],
        ['examination_id', $examDeclar->examination_id],
        // ['exam_declared_by', 'site_group'],
        ['site_id', $site_id],
    ])->get();

    // If no declared exams found, return early
    if ($siteExamDeclares->isEmpty()) {
        return [
            'site_results' => [],

        ];
    }

    $siteExamDeclareIds = $siteExamDeclares->pluck('id');
    $siteInfo = GlobalSiteInfo::find($site_id);
    $AcademicExamType = AcademicExamType::get()->keyBy('id');
    $results = [];



    $studentsForSite   = $studentHistories->where('site_id', $site_id);
    $studentHistoryIds = $studentsForSite->pluck('id');

    $subjectConditions = GlobalSubjectGroupConditionSetting::where([
        ['academic_group_id', $groupId],
        ['site_id', $site_id],
        ['academic_year_id', $request->academic_year_id],
        ['academic_class_id', $request->academic_class_id],
    ])->get();

    if ($subjectConditions->isNotEmpty()) {
        foreach ($subjectConditions as $subjectConditionItem) {
            $subjectName = AcademicSubject::find($subjectConditionItem->academic_subject_id)->subject_name ?? 'Unknown';

            $siteData = [
                'id' => $site_id,
                'site_name' => $siteInfo->site_name ?? 'Unknown',
                'subject_name' => $subjectName,
                'exam_type_summary' => [],
                'total_student' => 0,
                'total_present_student' => 0,
                'total_with_marks_count' => 0,
                'total_without_marks_count' => 0,
            ];

            $query = GlobalSiteExamDeclareStudentSubject::whereIn('student_history_id', $studentHistoryIds)
                ->whereIn('site_exam_declare_id', $siteExamDeclareIds)
                ->where([
                    ['examination_id', $examDeclar->examination_id],
                    ['site_subject_group_condition_setting_id', $subjectConditionItem->id],
                ]);

            $examSubjects = $query->get();
            $groupedByExamType = $examSubjects->groupBy('academic_exam_type_id');

            foreach ($groupedByExamType as $typeId => $subjects) {
                $count   = $subjects->count();
                $present = $subjects->where('exam_attendance_status', true);
                $absent  = $subjects->where('exam_attendance_status', false)->count();

                $withMarks = $present->filter(fn($item) => !is_null($item->obtaine_marks))->count();
                $withoutMarks = $present->count() - $withMarks;

                $siteData['exam_type_summary'][] = [
                    'academic_exam_type_id' => $typeId,
                    'exam_type'             => $AcademicExamType[$typeId]->marks_type ?? 'Unknown',
                    'total'                 => $count,
                    'present'               => $present->count(),
                    'absent'                => $absent,
                    'with_marks_count'      => $withMarks,
                    'without_marks_count'   => $withoutMarks,
                ];

                $siteData['total_student']             += $count;
                $siteData['total_present_student']     += $present->count();
                $siteData['total_with_marks_count']    += $withMarks;
                $siteData['total_without_marks_count'] += $withoutMarks;
            }



            $results[] = $siteData;
        }
    }

    return [
        'site_results' => $results,

    ];
}

    public function studetnsSubjectMarkList(Request $request)
    {

        $this->validate($request, [
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "examination_id" => "required",
        ]);

        $data = $request->all();

        $examDeclare = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->first();
        //     dd($examDeclare);

        $site_info = SiteInfo::find(Session::get('SITE_ID'));
        $academic_class_group = AcademicClassGroup::find($data['academic_class_group_id']);

        $section = AcademicSection::find($request->academic_section_id);

        $header_data = [
            'examination_name' => $examDeclare->examination ? $examDeclare->examination->examination_name : '',
            'year_name' => $examDeclare->year ? $examDeclare->year->year_name : '',
            'class_name' => $examDeclare->stClass ? $examDeclare->stClass->class_name : '',
            'department_name' => $examDeclare->department ? $examDeclare->department->name : '',
            'group_name' => $academic_class_group ? $academic_class_group->group_name : '',
            'section_name' => $section ? $section->section_name : '',
            'site_name' => $site_info->site_name,
            'site_address' => $site_info->address,
        ];

        // return $header_data;

        //======

        $examination_id = $examDeclare->examination_id ?? '';
        //    $examDeclaredIds=$examDeclare->pluck('id');
        $examDeclaredId = $examDeclare->id;
        //  dd($examDeclare->pluck('id'));

        $students_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->with('student')
            ->orderBy('student_roll_number')
            ->pluck('id');


        $all_exam_type_ids = SiteExamDeclareStudentSubject::whereIn('student_history_id', $students_history_ids)
            ->where('site_exam_declare_id', $examDeclaredId)
            ->pluck('academic_exam_type_id')->unique();



        $examTypeList = AcademicExamType::whereIn('id', $all_exam_type_ids)->select('id', 'marks_type')->get();



        $subjectList = SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->where('site_exam_declare_id', $examDeclaredId)
            ->whereIn('student_history_id', $students_history_ids)
            ->groupBy('site_subject_group_condition_setting_id')
            ->with(['subjectGroupConditionSetting' => function ($query) {
                //   $query->select('academic_subject_id');
                $query->with('academicSubject');
            }])
            ->select('academic_exam_type_id', 'site_subject_group_condition_setting_id')
            ->get();

        //   return $subjectList;

        $subject_list = [];

        foreach ($subjectList as $key => $subject) {
            $subject_list[$key]['subject_name'] = $subject->subjectGroupConditionSetting->academicSubject->subject_name;
            $subject_list[$key]['site_subject_group_condition_setting_id'] = $subject->site_subject_group_condition_setting_id;
        }


        $student_list = StudentHistory::with(['siteExamDeclareStudentSubject' => function ($query) use ($examDeclaredId, $examination_id) {
            $query->where('examination_id', $examination_id)
                ->with(['subjectGroupConditionSetting' => function ($q) {
                    $q->select('id', 'academic_subject_id', 'subject_code');
                    $q->orderBy('subject_position');
                }]);
            $query->with('academicExamType');

            $query->where('site_exam_declare_id', $examDeclaredId);
            //  $query->with('sameSubject');
            $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
            //  $query->groupBy('site_subject_group_condition_setting_id');
            //  $query->select('id','obtaine_marks','site_exam_declare_id','academic_exam_type_id','student_history_id', 'site_subject_group_condition_setting_id');
        }])
            ->with([
                'department',
                'stClass',
                'shift',
                'classGroup',
                'section',
                'session',
                'year',
                'academicStudentCategory',
                'student' => function ($query) {
                    $query->with(['gender', 'religion', 'latestPhoto' => function ($query) {
                        $query->select('name', 'path', 'imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id');
                }
            ])
            ->whereIn('id', $students_history_ids)
            ->select(
                'id',
                'user_id',
                'student_roll_number',
                'academic_year_id',
                'academic_department_id',
                'academic_class_id',
                'academic_shift_id',
                'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id',
                'academic_section_id',
                'academic_session_id',
                'student_roll_number_prefix'
            )
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_department_id')
            ->orderBy('academic_session_id')
            ->get();

        $student_array = [];

        foreach ($student_list as $key => $history) {

            $declare_subjectss = [];
            //   return $subject_list;
            foreach ($subject_list as $keysy => $subject) {
                $StudentSubjects = $history->siteExamDeclareStudentSubject
                    ->where('site_subject_group_condition_setting_id', $subject['site_subject_group_condition_setting_id']);

                //         $StudentSubjects22= $history->siteExamDeclareStudentSubject
                //         ->where('site_subject_group_condition_setting_id', 10425);
                //       //  ->where('examination_id',$examDeclare->examination_id);
                //    //    return $StudentSubjects22;


                $exam_type = [];
                foreach ($examTypeList as $keys => $examType) {

                    $st_exam_type = $StudentSubjects->where('academic_exam_type_id', $examType->id)
                        ->first();

                    if ($st_exam_type) {
                        $exam_type[$keys]['obtaine_marks'] = $st_exam_type->obtaine_marks;
                        $exam_type[$keys]['academic_exam_type_id'] = $st_exam_type->academic_exam_type_id;
                        $exam_type[$keys]['exam_type'] = $examType->marks_type;
                    } else {
                        $exam_type[$keys]['obtaine_marks'] = "";
                        $exam_type[$keys]['academic_exam_type_id'] = $examType->id;
                        $exam_type[$keys]['exam_type'] = $examType->marks_type;
                    }
                }

                $declare_subjectss[$keysy]['exam_types'] = $exam_type;
                $declare_subjectss[$keysy]['site_subject_group_condition_setting_id'] = $subject['site_subject_group_condition_setting_id'];
            }

            $student_array[$key]['full_name'] = $history->full_name;
            $student_array[$key]['student_full_roll_number'] = $history->student_full_roll_number;
            $student_array[$key]['shift'] = $history->shift ? $history->shift->shift_name : '';
            $student_array[$key]['section'] = $history->section ? $history->section->section_name : '';
            $student_array[$key]['year'] = $history->year ? $history->year->year_name : '';
            $student_array[$key]['subject_list'] = $declare_subjectss;
        }

        return [$student_array, $examTypeList, $header_data, $subject_list];
    }


    public function studetnsSubjectMarkListPdf(Request $requests)
    {
        $studetnData = $this->studetnsSubjectMarkList($requests);
        $students_mark_list = $studetnData[0];
        $exam_type_list = $studetnData[1];
        $subject_list = $studetnData[3];

        $report_tittle = "";
        $report_tittle2 = "";
        $report_tittle .= "<b>Year: </b>";
        $report_tittle .= " <b>Shift: </b>" . ($primary_result_tabulation[0]['student_history']['shift']['shift_name'] ?? '');
        //   $report_tittle .= " <b>Shift: </b>" . ($primary_result_tabulation[0]['student_history']['shift']['shift_name'] ?? '');


        $pdf = PDF::loadView(
            'default.admin.site.exam.report.site-base-student-exam-entry-mark-report',
            compact('report_tittle', 'report_tittle2', 'students_mark_list', 'exam_type_list', 'subject_list')
        )
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';


        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
}
