<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Employee\EmpExamCommitteePosition;
use App\Models\Site\ExamCommittee\simpleSiteExamCommitteeSetting;
use App\Models\Site\ExamCommittee\SiteExamCommitteeEmployeeSetting;
use App\Models\Site\ExamCommittee\SiteExamCommitteeSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\User\User;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteExamCommitteeDeclareController extends Controller
{
    private $siteExamCommitteeSetting;
    private $simpleSiteExamCommitteeSetting;

    public function __construct(SiteExamCommitteeSetting $siteExamCommitteeSetting,
                                simpleSiteExamCommitteeSetting $simpleSiteExamCommitteeSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->siteExamCommitteeSetting = $siteExamCommitteeSetting;
        $this->simpleSiteExamCommitteeSetting = $simpleSiteExamCommitteeSetting;
    }

    public function index()
    {
        $viewType = 'Site Exam Committee Declare Page';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.site.exam.site-exam-committee-declare', compact('viewType'));

    }


    public function getYearDeptClassShiftVersionEmployeeList(){

        $site_info_setting = SiteInfoSetting::first();



        $academic_version_ids = explode(',', $site_info_setting->academic_version_ids) ?? null;
        $academicVersionList = AcademicVersion::select('id', 'version_name')
            ->whereIn('id', $academic_version_ids)
            ->get();


        $shift_ids = explode(',', $site_info_setting->shift_ids) ?? null;
        $shiftList = AcademicShift::select('id')
            ->whereIn('id', $shift_ids)
            ->get();


        $academic_year_ids = explode(',', $site_info_setting->academic_year_ids) ?? null;
        $academicYearList = AcademicYear::select('id', 'year_name')
            ->whereIn('id', $academic_year_ids)
            ->get();


        $academicDepartmentList = [];
        if ($site_info_setting->academic_department_ids) {
            $academicDepartment = explode(',', $site_info_setting->academic_department_ids) ?? null;
            $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
                ->whereIn('id', $academicDepartment)->get();
        }
        $academicClass = explode(',', $site_info_setting->academic_class_ids) ?? null;
        $academicClassList = AcademicClass::select('id', 'class_name')
            ->whereIn('id', $academicClass)
            ->orderBy('serial_no', 'ASC')
            ->get();


        $emp = User::where('user_type', 'employee')
            ->where('status', true)
            ->with(['latestPhoto'])
            ->with(['designation'])
            ->select('id', 'designation_id')
            ->get();


        $emp_exam_committee_position_ids = explode(',', $site_info_setting->emp_exam_committee_position_ids) ?? null;
        $position_ids_list = EmpExamCommitteePosition::select('id', 'name')
            ->whereIn('id', $emp_exam_committee_position_ids)
            ->get();



        $emp_array=[];
        $emp_arr=Array();
        foreach ($emp as $key => $value) {
            $emp_arr['emp_exam_committee_position_id']=null;
            $emp_arr['selected_for_committee']=false;

            $emp_array[$key]=array_merge($value->toArray(), $emp_arr);
        }




        $examCommitteeList=SiteExamCommitteeSetting::with(['siteExamCommitteeEmployee'=>function($query){
            $query->with(['empExamCommitteePosition', 'user'=>function($q){
                $q->select('id');
            }]);
            $query->where('status', true);
            $query->whereNull('release_date');

        }])
        ->get();




        return [$academicVersionList, $shiftList, $academicYearList,
            $academicDepartmentList, $academicClassList, $emp_array, $position_ids_list, $examCommitteeList];


    }




    public function createSiteBaseEmpExamCommittee(Request $request, simpleSiteExamCommitteeSetting $examcommittee){


        try {
            $this->validate($request, [
                "start_date" => "required",
                "end_date" => "required",
                "committee_name" => "required",
                "shift_ids" => "required",
                "academic_version_ids" => "required",
                "academic_year_ids" => "required",
                "academic_class_ids" => "required",

            ]);



            $examcommittee->duration_from_date =$request->start_date;
            $examcommittee->duration_to_date =$request->end_date;
            $examcommittee->extended_date =$request->extended_date;
            $examcommittee->committee_name =$request->committee_name;

            $examcommittee->academic_group_id =Session::get('ACADEMIC_GROUP_ID');
            $examcommittee->site_id =Session::get('SITE_ID');

            $examcommittee->academic_shift_ids =implode(',', $request->shift_ids);
            $examcommittee->academic_version_ids =implode(',', $request->academic_version_ids);
            $examcommittee->academic_year_ids =implode(',', $request->academic_year_ids);
            $examcommittee->academic_department_ids =implode(',', $request->academic_department_ids);
            $examcommittee->academic_class_ids =implode(',', $request->academic_class_ids);
//            $examcommittee->academic_class_group_ids =$request->;


            $examcommittee->save();
            $examCommitteeID= $examcommittee->id;





            $charges=[];
            foreach ($request->EmployeeList as $key => $value) {

                if($value['selected_for_committee']){
                    $charges[] = [
                        'site_exam_committee_setting_id' => $examCommitteeID,
                        'user_id' => $value['id'],
                        'emp_exam_committee_position_id' => $value['emp_exam_committee_position_id'],
                        'status' => true,

                    ];
                }
            }
            if(count($charges)>0){
                SiteExamCommitteeEmployeeSetting::insert($charges);
            }





            return Response::json(['message' => 'Exam Committee Create Successfully!', 'mode' => 'Create!'], 200);



        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }

    }



    public function updateSiteBaseEmpExamCommittee(Request $request){





        try {
            $this->validate($request, [
                "start_date" => "required",
                "end_date" => "required",
                "committee_name" => "required",
                "shift_ids" => "required",
                "academic_version_ids" => "required",
                "academic_year_ids" => "required",
                "academic_class_ids" => "required",

            ]);


            $examcommittee=simpleSiteExamCommitteeSetting::where('id', $request->committee_declare_id)->first();



            $examcommittee->duration_from_date =$request->start_date;
            $examcommittee->duration_to_date =$request->end_date;
            $examcommittee->extended_date =$request->extended_date;
            $examcommittee->committee_name =$request->committee_name;


            $examcommittee->academic_shift_ids =implode(',', $request->shift_ids);
            $examcommittee->academic_version_ids =implode(',', $request->academic_version_ids);
            $examcommittee->academic_year_ids =implode(',', $request->academic_year_ids);
            $examcommittee->academic_department_ids =$request->academic_department_ids?implode(',', $request->academic_department_ids):null;
            $examcommittee->academic_class_ids =implode(',', $request->academic_class_ids);
//            $examcommittee->academic_class_group_ids =$request->;


            $examcommittee->save();



            $today=Carbon::today();



            $charges=[];
            $employeeArr=[];
            foreach ($request->EmployeeList as $key => $value) {

                if($value['selected_for_committee']){

                    $empl=SiteExamCommitteeEmployeeSetting::where('site_exam_committee_setting_id', $request->committee_declare_id)
                        ->where('user_id',$value['id'])
                        ->whereNull('release_date')
                        ->where('status', true)
                        ->first();

//                    \Log::info($empl);

                    if($empl){

                        $empl->emp_exam_committee_position_id=$value['emp_exam_committee_position_id'];
                        $empl->status=true;
                        $empl->save();
                    }else{
                        $charges[] = [
                            'site_exam_committee_setting_id' => $request->committee_declare_id,
                            'user_id' => $value['id'],
                            'emp_exam_committee_position_id' => $value['emp_exam_committee_position_id'],
                            'status' => true,

                        ];
                    }



                }else{
                    $emp=SiteExamCommitteeEmployeeSetting::where('site_exam_committee_setting_id', $request->committee_declare_id)
                        ->where('user_id',$value['id'])
                        ->first();

                    $diff_in_days = $today->diffInDays($request->start_date);

                    if($emp){

                        if($diff_in_days>2){
                            $emp->release_date=$today;
                            $emp->status=false;
                            $emp->save();
                        }else{
                            $employeeArr[]=$emp->id;
                        }

                    }
                }
            }
            if(count($charges)>0){
                SiteExamCommitteeEmployeeSetting::insert($charges);
            }

            if(count($employeeArr)>0){
                SiteExamCommitteeEmployeeSetting::whereIn('id', $employeeArr)->delete();
            }






            return Response::json(['message' => 'Exam Committee Create Successfully!', 'mode' => 'Create!'], 200);



        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }





    }






}
