<?php

namespace App\Http\Controllers\Site\FeeReport;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\User;
//use User
use Auth;
use Carbon\Carbon;
//use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Arr;
use PDF;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeType;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\Fee\SiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Site\Fee\StudentFeeTrait;
use DateTime;
use phpDocumentor\Reflection\Types\Array_;
use Psy\Test\Exception\RuntimeExceptionTest;
use Response;
use Session;

class SiteFeeReportController extends ProjectController
{

    use StudentFeeTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    private $siteStudentFeeGenerate;
    private $siteStudentFeeDemandSlipDetails;
    private $siteStudentFeeWaiverOfferHistory;

    public function __construct(SiteStudentFeeGenerate $siteStudentFeeGenerate, SiteStudentFeeDemandSlipDetails $siteStudentFeeDemandSlipDetails,
                                SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory)
    {
        $this->middleware('auth');
         $this->middleware('sitepagechecker');
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
        $this->siteStudentFeeDemandSlipDetails = $siteStudentFeeDemandSlipDetails;
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;

    }

//    public function __construct()
//    {
//
//        $this->middleware('auth');
//        $this->middleware('sitepagechecker');
//
//
//
//    }


    public function index()
    {
        $viewType = 'Fee report';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.sites.fee.fee-report.payment-report', compact('viewType'));
    }

    public function getAcademicYearList()
    {
        $the_site_info_setting = SiteInfoSetting::first();

        if (!$the_site_info_setting) {
            return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
        }

        $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('id','DESC')->get();

        $dateComponents = getdate();
        $year = $dateComponents['year'];

        return [$academicYearList,$year];

    }

    public function getSingleStudentPaymentReportList(Request $request)
    {
        $academic_year_id = $request->academic_year_id;

        $request->validate([
            'user_id' => 'required',
        ]);

        if ($request->user_id) {
            $userList = Student::where('username', $request->user_id)->select('id')->first();
            if ($userList) {
                $checkPrevClassSlip=[];
                $prev_total_amount=0;

                if($academic_year_id){
                    $studentHistoryList = GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('site_id', Session::get('SITE_ID'))
                        ->where('academic_year_id',$academic_year_id)
                        ->orderBy('id','desc')
                        ->get();
                    $student_history_ids=$studentHistoryList->pluck('id');

                    $presentStudentHistory=StudentHistory::whereIn('id',$student_history_ids)->first();

                    $checkPrevClassSlip = GlobalSiteStudentFeeDemandSlipDetails::whereIn('due_transfer_to_promoted_student_history_id', $student_history_ids)
                        ->where('site_id', Session::get('SITE_ID'))
                        ->orderBy('id', 'desc')
                        ->first(); 

                    if($checkPrevClassSlip){
                        if(!$checkPrevClassSlip->previous_academic_class_due_status){
                            $prev_total_amount=$checkPrevClassSlip->total_amount;
                        }
                    }

                }else{
                    $studentHistoryList = GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('site_id', Session::get('SITE_ID'))
                    //    ->where('status', 1)
                        ->get();

                    $student_history_ids=$studentHistoryList->pluck('id');

                    $presentStudentHistory=StudentHistory::whereIn('id',$student_history_ids)->where('status',true)->first();

                }

            } else {
                throw new Error('Sorry! Student not found');
            }

           // dd($studentHistoryList);

            if(count($studentHistoryList)<0){
                throw new Error('Sorry! Student not found');
            }

            $academic_group_ids=$studentHistoryList->pluck('academic_group_id');

//            return $studentHistoryList;
            // $head_ids_list = GlobalSiteInfoSetting::where('site_id', Session::get('SITE_ID'))
            //         ->whereIn('academic_group_id',$academic_group_ids)
            //         ->get();

            // $head_list = AcademicFeeHead::whereIn('id', explode(',', $head_ids_list->academic_fee_head_ids))->get();


            // Step 1: Get all settings for the site and groups
            $head_id_settings = GlobalSiteInfoSetting::where('site_id', Session::get('SITE_ID'))
                ->whereIn('academic_group_id', $academic_group_ids)
                ->pluck('academic_fee_head_ids') // Only fetch needed column
                ->filter() // Remove nulls
                ->toArray();

            // Step 2: Flatten and clean the comma-separated IDs
            $head_ids = collect($head_id_settings)
                ->flatMap(function ($ids) {
                    return explode(',', $ids);
                })
                ->unique()
                ->filter()
                ->map(fn($id) => (int) trim($id)) // Ensure integer IDs
                ->values()
                ->all();

            // Step 3: Fetch the actual fee heads
            $head_list = AcademicFeeHead::whereIn('id', $head_ids)->get();

            $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $student_history_ids)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->whereIn('academic_group_id',$academic_group_ids)
                 //   ->pluck('fee_amount');
                 //   ->pluck('waiver_amount');
                    ->get();


            $total_amount = 0;
            $total_generated_amount = 0;
            $total_paid_amount = 0;
            $total_due = 0;
            $total_payable_amount = 0;
            $total_fee_fine = 0;
            $total_not_paid_demand_slip_delay_fine = 0;
            $voucherArr = [];
            $fee_generate_id_key=0;
            $fee_generate_id_array=[];

            $fee_waiver_id_key=0;
            $fee_waiver_id_array=[];
            $total_slip_amount=0;
            if(count($demand_slip_details)>0){
                foreach ($demand_slip_details as $key => $value){
                    $total_slip_amount+=$value->fee_amount;

                    //=====================fee generated id list======================

                    $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);

                    foreach($fee_generate_id_splite as $fee_generate_id){
                        $fee_generate_id_array[$fee_generate_id_key]=$fee_generate_id;
                        $fee_generate_id_key++;
                    }


                    //=====================fee waiver id list======================

                    $waiver_generate_id_splite = explode(',', $value->site_student_fee_waiver_offer_history_ids);

                    foreach($waiver_generate_id_splite as $fee_waiver_id){
                        $fee_waiver_id_array[$fee_waiver_id_key]=$fee_waiver_id;
                        $fee_waiver_id_key++;
                    }


                    //=====================total payment======================
                    $payment_history = GlobalSiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $value->id)
                            ->where('site_id', Session::get('SITE_ID'))
                            ->where('academic_group_id',$value->academic_group_id)
                            ->orderBy('id','DESC')
                            ->get();

                    

                    if(count($payment_history)>0){
                        foreach ($payment_history as $kk => $vv){
                            $total_paid_amount+=$vv->paid_amount;
                        }
                    }

                  
                    
                    //=====================total waiver=======================
                    // $student_waiver = SiteStudentFeeWaiverOfferHistory::where('site_student_fee_demand_slip_detail_id', $value->id)
                    //     ->where('demand_slip_create_status', 1)
                    //     ->get();
                    // if(count($student_waiver)>0){
                    //     foreach ($student_waiver as $kkk => $vvv){
                    //         $total_waiver_amount+=$vvv->amount;
                    //     }

                    // }
                    //===============total demand slip delay fine==============
                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();

                    if($value->status == 1 && $value->payment_from_date){

                        $start_date = $value->payment_from_date;
                        $end_date = $value->payment_to_date;

                        $period = CarbonPeriod::create($start_date, $end_date);

                        $delay_fine_test = 1;
                        foreach ($period as $date) {
                            $formated_date =  $date->format('Y-m-d');
                            if($formated_date == $today_date){
                                $delay_fine_test = 0;
                            }
                        }

                        if($delay_fine_test==1){
                            $total_not_paid_demand_slip_delay_fine+=$value->delay_fine;
                        }


                    }



                }


                    //================table data===============
                 //   $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);
                    $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_array)->orderBy('id','ASC')->get();

                  
                    $paymentHistoryArr = [];
                    $srl=0;

                    if (count($fee_generate_details) > 0) {

                        foreach ($fee_generate_details as $k => $v) {

//                            $paymentHistoryArr[$key][$k]['taken_by'] = Employee::where('id', $value->created_by)->first();


                            $fee_allocation_detail = GlobalSiteStudentFeeFineAllocation::
                                with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                                ->where('site_id', Session::get('SITE_ID'))
                                ->whereIn('academic_group_id',$academic_group_ids)
                                ->where('id', $v->site_student_fee_fine_allocation_id)
                                ->first();

                            $paymentHistoryArr[$srl]['fee_item'] = AcademicFeeSubHead::where('id', $fee_allocation_detail->academic_fee_sub_head_id)->first();
                            $paymentHistoryArr[$srl]['amount'] = $v->amount;
                            $total_amount+= $v->amount;


                            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {
                                $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                                $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                                $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->examination_name;

                            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                                $fee_type = AcademicGeneralFeeType::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            }

                      //================total generated amount===============
                            $total_generated_amount += $v->amount;
                            $srl++;

                        }

                    }

                    //  $total_generated_amountee=$fee_generate_details->sum('amount');

                   

                    //==================Waiver List =========
                    $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $fee_waiver_id_array)->get();

                    $total_waiver_amount = 0;
                    $waiver_allocation_details_arr=[];
                    $waiver_srl=0;

                    if(count($waiver_generate_list)>0){
                        foreach ($waiver_generate_list as $key => $value){

                            if($value->site_student_fee_fine_allocation_id){


                                $waiver_allocation_detail= GlobalSiteStudentFeeFineAllocation::
                                    with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                                    ->where('site_id', Session::get('SITE_ID'))
                                    ->whereIn('academic_group_id',$academic_group_ids)
                                    ->where('id',$value->site_student_fee_fine_allocation_id)
                                    ->first();

                                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->examination_name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;
                                }

                                if($value->percantage_status){
                                    $std_fee_generate = SiteStudentFeeGenerate::where('site_student_fee_fine_allocation_id', $value->site_student_fee_fine_allocation_id)
                                        ->whereIn('student_history_id',$student_history_ids)
                                        ->first();

                                        $amount=($std_fee_generate->amount*$value->amount)/100;

                                        $waiver_amount=$amount;

                                }else{
                                    $waiver_amount=$value->amount;
                                }

                                $total_waiver_amount+=$waiver_amount;



                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;
                                $waiver_allocation_details_arr[$waiver_srl]['amount']=$waiver_amount;


//                                $waiver_allocation_details_array[$waiver_srl]=array_merge($waiver_allocation_details_arr, $value->toArray());
                                $waiver_srl++;
                            }

                        }
                    }




            }else{
                return Response::json(['message' => 'payment not generated yet!'], 411);
            }

            //=====================total fee fine======================
            $student_fee_fine = GlobalSiteStudentFeeFine::whereIn('student_history_id', $student_history_ids)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->whereIn('academic_group_id',$academic_group_ids)
                    ->get();

            if(count($student_fee_fine)>0){
                foreach ($student_fee_fine as $kke => $vvl){
                    $total_fee_fine+=$vvl->fine_amount;
                }
            }

           

          /// other class fee calculate
               

         
              

            //=========================total due=======================
        //    $generated_mission = $total_slip_amount - $total_generated_amount;
            $generated_mission = 0;

            $total_payable_amount = ($total_generated_amount + $total_fee_fine + $total_not_paid_demand_slip_delay_fine+$generated_mission)-$total_waiver_amount;
            $total_due = ($total_payable_amount+$prev_total_amount) - $total_paid_amount;

            $total_paid_amount=$total_paid_amount-$prev_total_amount;

      // নতুন ফিল্ডগুলো
            $voucherArr['name'] = $presentStudentHistory->full_name;
            $voucherArr['username'] = $presentStudentHistory->student->username;
            $voucherArr['roll'] = $presentStudentHistory->student_full_roll_number ?? '';
            $voucherArr['father_name'] = $presentStudentHistory->student->father_name ?? '';
            $voucherArr['mother_name'] = $presentStudentHistory->student->mother_name ?? '';
            $voucherArr['version_name'] = $presentStudentHistory->version->version_name ?? '';
            $voucherArr['class_name'] = $presentStudentHistory->stClass ? $presentStudentHistory->stClass->class_name : '';
            $voucherArr['year_name'] = $presentStudentHistory->year ? $presentStudentHistory->year->year_name : '';
            $voucherArr['shift_name'] = $presentStudentHistory->shift ? $presentStudentHistory->shift->shift_name : '';
            $voucherArr['group_name'] = $presentStudentHistory->classGroup ? $presentStudentHistory->classGroup->group_name : '';
            $voucherArr['section_name'] = $presentStudentHistory->section ? $presentStudentHistory->section->section_name : '';
            $voucherArr['session_name'] = $presentStudentHistory->session ? $presentStudentHistory->session->session_name : '';
            $voucherArr['department_name'] = $presentStudentHistory->department ? $presentStudentHistory->department->department_name : '';
            $voucherArr['type_name'] = $presentStudentHistory->studentType ? $presentStudentHistory->studentType->student_type_name : '';

            $voucherArr['total_amount'] = 0;
            $voucherArr['taken_by '] = "";
            $voucherArr['total_generated_amount'] = number_format($total_generated_amount);
            $voucherArr['fee_fine'] = number_format( $total_fee_fine + $total_not_paid_demand_slip_delay_fine);
            $voucherArr['total_waiver_amount'] = number_format($total_waiver_amount);
            $voucherArr['total_payable_amount'] = number_format($total_payable_amount);
            $voucherArr['previous_paid_amount'] = number_format($prev_total_amount);
            $voucherArr['total_paid_amount'] = number_format($total_paid_amount);
            $voucherArr['total_due'] = number_format($total_due);
            $voucherArr['std_id'] = $presentStudentHistory->id;
            $voucherArr['generated_mission_amount'] = $generated_mission??"null";

  //dd($voucherArr);
            return [$paymentHistoryArr, $voucherArr, $head_list,  $total_amount, $waiver_allocation_details_arr, $total_waiver_amount];

        } else {
            return Response::json(['message' => 'Sorry! please search with student ID'], 411);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getSiteFeeHeadBaseTypeList(Request $request)
    {

        $student_history=GlobalStudentHistory::FindOrFail($request->student_histories_id);
      //  dd($student_history->academic_group_id);
        if ($request->checked_fee_head_id != null) {

            $feeheadlist = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
            $headBaseValue = null;
            $headBaseTypelist = Array();
            if ($feeheadlist->head_key == 'monthly') {
                $headBaseTypelist = AcademicMonthName::orderBy('serial_no','desc')->get();
                $headBaseValue = 'monthly';

                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            } else if ($feeheadlist->head_key == 'examination') {

                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

                $selectedSiteGroupList = GlobalSiteInfoSetting::where('site_id',Session::get('SITE_ID'))
                            ->where('academic_group_id',$student_history->academic_group_id)
                            ->first();


                $Examinationlist = Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                $headBaseTypelist = [];
                $headBaseTypelistArr = Array();
                foreach ($Examinationlist as $key => $value) {

                    $headBaseTypelistArr['id'] = $value->id;
                    $headBaseTypelistArr['name'] = $value->examination_name;

                    $headBaseTypelist[$key] = array_merge($headBaseTypelistArr);
                }
                $headBaseValue = 'examination';

            } else if ($feeheadlist->head_key == 'admission') {
                $headBaseTypelist = AcademicAdmissionFeeType::get();
                $headBaseValue = 'admission';
                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            } else if ($feeheadlist->head_key == 'general') {

                $headBaseTypelist = AcademicGeneralFeeType::get();
                $headBaseValue = 'general';
                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            }
            if ($fee_details) {

                $fee_details_list = $fee_details[0];
                $fee_waiver_list = $fee_details[1];
                $total_amount = $fee_details[2];
                $total_waiver_amount = $fee_details[3];
                return response()->json([$headBaseValue, $headBaseTypelist, $fee_details_list, $fee_waiver_list, $total_amount, $total_waiver_amount], 200, [], JSON_NUMERIC_CHECK);

            } else {
                throw new Error('Sorry! Payment not completed at yet!');
            }

        }


    }


    public function getHeadBaseSingleStudentPaymentList($request, $feeheadlist)
    {


        $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('student_history_id', $request->student_histories_id)
            ->where('site_id',Session::get('SITE_ID'))
            ->get();

        $srl = 0;
        $waiver_srl = 0;
        $tot_waiver_amount = 0;
        $total_amount = 0;
        $fee_generate_id_key = 0;
        $fee_waiver_id_key = 0;
        $fee_generate_id_array = [];
        $fee_waiver_id_array = [];
        $feehead = $request->fee_head_name;


        if (count($demand_slip_details) > 0) {

            foreach ($demand_slip_details as $key => $value) {



                   //=====================fee generated id list======================

                   $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);

                   foreach($fee_generate_id_splite as $fee_generate_id){
                       $fee_generate_id_array[$fee_generate_id_key]=$fee_generate_id;
                       $fee_generate_id_key++;
                   }


                   //=====================fee waiver id list======================

                   $waiver_generate_id_splite = explode(',', $value->site_student_fee_waiver_offer_history_ids);

                   foreach($waiver_generate_id_splite as $fee_waiver_id){
                       $fee_waiver_id_array[$fee_waiver_id_key]=$fee_waiver_id;
                       $fee_waiver_id_key++;
                   }




            }

             //===============fee details====================
             $feeheadlist = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
             $headBaseValue = null;
             $headBaseTypelist = Array();
             $feeGenerateHistoryArr =[];

            if(count($request->select_month_ids)>0){
                $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_array)
                ->where('academic_fee_head_id', $request->checked_fee_head_id)
                ->when(count($request->select_month_ids), function($q) use ($request){
                    $q->whereIn('fee_head_type_id',$request->select_month_ids);
                })
                ->get();

            }else{
                if($request->checked_admission_examination_general_id){

                    $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_array)
                    ->where('academic_fee_head_id', $request->checked_fee_head_id)
                    ->where('fee_head_type_id',$request->checked_admission_examination_general_id)
                    ->get();

                }else{

                    $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_array)
                    ->where('academic_fee_head_id', $request->checked_fee_head_id)
                    ->get();

                }
            }


             if (count($fee_generate_details) > 0) {
                 foreach ($fee_generate_details as $k => $v) {

                    $fee_allocation_detail = GlobalSiteStudentFeeFineAllocation::
                        with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                        ->where('id', $v->site_student_fee_fine_allocation_id)
                        ->when($feehead!=null, function($q) use ($feehead){
                            $q->whereHas('academicFeeHead', function ($q1) use ($feehead) {
                                return $q1->where('head_key', $feehead);
                            });
                        })
                        ->first();

                        // $waiver_allocation_detail= SiteStudentFeeFineAllocation::whereHas('academicFeeHead', function ($q1) use ($feehead) {
                        //     return $q1->where('head_key', $feehead);
                        // })
                        //     ->with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                        //     ->where('id',$vvl->site_student_fee_fine_allocation_id)
                        //     ->first();

                     $total_amount+= $v->amount;
                     $feeGenerateHistoryArr[$srl]['fee_item'] = AcademicFeeSubHead::where('id', $fee_allocation_detail->academic_fee_sub_head_id)->first();
                     $feeGenerateHistoryArr[$srl]['amount'] = $v->amount;


                     if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {

                         $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                         $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->name;


                     } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {

                         $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                         $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                     } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {

                         $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                         $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->examination_name;

                     }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){

                        $fee_type = AcademicGeneralFeeType::where('id', $v->fee_head_type_id)->first();
                        $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->name;
                    }

                     $srl++;
                 }
             }


                //==================Waiver Details =========
             $waiver_allocation_details_arr=[];
                $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $fee_waiver_id_array)
                ->when(count($request->select_month_ids)>0,function($q) use ($request){
                    $q->whereIn('fee_head_type_id', $request->select_month_ids);
                })
                ->when($request->checked_admission_examination_general_id!=null,function($q) use ($request){
                    $q->where('fee_head_type_id', $request->checked_admission_examination_general_id);
                })
                ->get();

                if(count($waiver_generate_list)>0){
                    foreach ($waiver_generate_list as $kk => $vvl){

                        if($vvl->site_student_fee_fine_allocation_id){


                            $waiver_allocation_detail= GlobalSiteStudentFeeFineAllocation::whereHas('academicFeeHead', function ($q1) use ($feeheadlist) {
                                    return $q1->where('head_key', $feeheadlist->head_key);
                                })
                                ->with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                                ->where('id',$vvl->site_student_fee_fine_allocation_id)
                                ->first();

                            if($waiver_allocation_detail){
                                $tot_waiver_amount+=$vvl->amount;
                                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                                    $waiver_type = AcademicAdmissionFeeType::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                                    $waiver_type = AcademicMonthName::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                                    $waiver_type = Examination::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->examination_name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                                    $waiver_type = AcademicGeneralFeeType::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;
                                }

                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;
                                $waiver_allocation_details_arr[$waiver_srl]['amount']=$vvl->amount;

                                $waiver_srl++;
                            }


                        }

                    }
                }

               // dd($tot_waiver_amount);





            $total_amount = number_format($total_amount);
            $tot_waiver_amount = number_format($tot_waiver_amount);

            return [$feeGenerateHistoryArr,$waiver_allocation_details_arr,$total_amount, $tot_waiver_amount];
        }







        return 'ok';

        $payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $request->student_histories_id)

            ->with('siteStudentFeeDemandSlipDetails')
            ->get();
//        return $payment_history;

//        $total_amount = 0;

        if (count($payment_history) > 0) {


            $paymentHistoryArr = Array();
            foreach ($payment_history as $key => $value) {
                $first[] = $value->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids;
                $fee_generate_id_splite = explode(',', $value->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids);
//                $first[] = $fee_generate_id_splite;
                $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->where('academic_fee_head_id', $request->checked_fee_head_id)->with('siteStudentFeeFineAllocation')->get();


                if (count($fee_generate_details) > 0) {

                    foreach ($fee_generate_details as $k => $v) {

                        $paymentHistoryArr[$key][$k]['fee_item'] = AcademicFeeSubHead::where('id', $v->siteStudentFeeFineAllocation->academic_fee_sub_head_id)->first();
                        $paymentHistoryArr[$key][$k]['amount'] = $v->amount;
//                        $createdDate = new DateTime($value->payment_date);
//                        $formatedDate = $createdDate->format('Y-m-d');
//
//                        $paymentHistoryArr[$key][$k]['taken_date'] = $formatedDate;
//                        $paymentHistoryArr[$key][$k]['taken_by'] = Employee::where('id', $value->created_by)->first();

//                        $total_amount+=$v->amount;

                        $fee_allocation_detail = SiteStudentFeeFineAllocation::
                        with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                            ->where('id', $v->site_student_fee_fine_allocation_id)->first();


                        if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {

                            $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key][$k]['fee_type_name'] = $fee_type->name;


                        } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                            $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key][$k]['fee_type_name'] = $fee_type->name;

                        } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                            $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key][$k]['fee_type_name'] = $fee_type->examination_name;
                        }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){

                            $fee_type = AcademicGeneralFeeType::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key]['fee_type_name'] = $fee_type->name;
                        }
                    }
                }
            }

            return $paymentHistoryArr;
        }
    }


    public function getSiteFeeHeadFeeTypeBaseFeeList(Request $request)
    {

        if ($request->checked_fee_head_id != null) {

            $feeheadlist = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
            $headBaseValue = null;
            $headBaseTypelist = Array();
            if ($feeheadlist->head_key == 'monthly') {
                $headBaseTypelist = AcademicMonthName::orderBy('serial_no','desc')->get();
                $headBaseValue = 'monthly';

                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            } else if ($feeheadlist->head_key == 'examination') {

                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

                $selectedSiteGroupList = SiteInfoSetting::first();
                $Examinationlist = Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                $headBaseTypelist = [];
                $headBaseTypelistArr = Array();
                foreach ($Examinationlist as $key => $value) {

                    $headBaseTypelistArr['id'] = $value->id;
                    $headBaseTypelistArr['name'] = $value->examination_name;

                    $headBaseTypelist[$key] = array_merge($headBaseTypelistArr);
                }
                $headBaseValue = 'examination';

            } else if ($feeheadlist->head_key == 'admission') {
                $headBaseTypelist = AcademicAdmissionFeeType::get();
                $headBaseValue = 'admission';
                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);



            } else if ($feeheadlist->head_key == 'general') {

                $headBaseTypelist = AcademicGeneralFeeType::get();
                $headBaseValue = 'general';
                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            }

          //  return $fee_details;
            if ($fee_details) {

                $fee_details_list = $fee_details[0];
                $fee_waiver_list = $fee_details[1];
                $total_amount = $fee_details[2];
                $total_waiver_amount = $fee_details[3];
                return response()->json([$headBaseValue, $headBaseTypelist, $fee_details_list, $fee_waiver_list, $total_amount, $total_waiver_amount], 200, [], JSON_NUMERIC_CHECK);

            } else {
                throw new Error('Sorry! Payment not completed at yet!');
            }

        }
        else {
            throw new Error('Select Fee Head!');
        }


    }

    public function getSiteSingleStudentFeeSummary(Request $request)
    {
//        return $request;
        $academic_year_id = $request->academic_year_id;

        if ($request->user_name) {
            $userList = Student::where('username', $request->user_name)->select('id')->first();
            if ($userList) {
                if($academic_year_id){
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('academic_year_id',$academic_year_id)
                        ->orderBy('id','desc')
                        ->first();

                }else{
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('status', 1)
                        ->first();
                }

            } else {
                throw new Error('Sorry! Student not found');
            }

            $payment_slip_details = SiteStudentFeePaymentHistory::where('student_history_id', $studentHistoryList->id)->with('user')->get();
            $dataArr = [];
            $total_paid_amount = 0;
            if(count($payment_slip_details)>0){
                foreach ($payment_slip_details as $key => $value){
                    $dataArr[$key]['id'] = $value->id;
                    $dataArr[$key]['voucher_no'] = $value->voucher_no;
                    $dataArr[$key]['payment_date'] = $value->payment_date;
                    $dataArr[$key]['created_by'] = $value->user->full_name ?? "";
                    $dataArr[$key]['paid_amount'] = $value->paid_amount;
                    $dataArr[$key]['paid_by'] = $value->paid_by;

                    $total_paid_amount+=$value->paid_amount;
                }
            }else{
                throw new Error('Sorry! payment not taken at yet');
            }
            $stdDetailsArray['std_id'] = $studentHistoryList->id;
            $stdDetailsArray['std_name'] = $studentHistoryList->student ? $studentHistoryList->student->full_name : "";
            $stdDetailsArray['department_name'] = $studentHistoryList->department ? $studentHistoryList->department->class_name : "";
            $stdDetailsArray['class_name'] = $studentHistoryList->stClass->class_name;
            $stdDetailsArray['group_name'] = $studentHistoryList->accGroup ? $studentHistoryList->accGroup->group_name : "";
            $stdDetailsArray['section_name'] = $studentHistoryList->section ? $studentHistoryList->section->section_name : "";

            return [$dataArr, $stdDetailsArray, $total_paid_amount];

        }else{
            throw new Error('Sorry! Please write student ID');
        }
    }


    public function getSiteFeeHeadClassBaseFeeList(Request $request)
    {
        $data = $request->all();

      
        $allStudentHstoryList = GlobalStudentHistory::with('student')
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('status', $request->student_status) // only prasent student
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$request->academic_group_id)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('academic_shift_id')
            ->get();

        $student_hstory_ids=$allStudentHstoryList->pluck('id');

    
        $studentSlipList = GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $student_hstory_ids)
            ->where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$request->academic_group_id)
            ->get();

      //  $student_hstory_ids=$studentSlipList->pluck('student_history_id');

        $paymentHistoryList = GlobalSiteStudentFeePaymentHistory::whereIn('student_history_id', $student_hstory_ids)
            ->where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id',$request->academic_group_id)
            ->get();

     //   $student_hstory_list=$allStudentHstoryList->whereIn('id',$student_hstory_ids)->values();

        if (count($allStudentHstoryList) > 0) {
            $gross_total_paid_amount = 0;
            $gross_total_due_paid_amount = 0;
            $gross_total_due_amount = 0;
            $gross_total_generate_amount = 0;
            $gross_total_payable_amount = 0;
            $gross_waiver_amount = 0;
            $gross_fee_fine = 0;

         //  $payment_history_list=[];
            foreach ($allStudentHstoryList as $key => $value) {
              
                $payment_history_list = $paymentHistoryList->where('student_history_id', $value->id);
             
                $total_paid_amount = 0;

                $site_student_fee_generate_ids = $studentSlipList->where('student_history_id', $value->id)
                    ->pluck('site_student_fee_generate_ids');

                $site_student_fee_waiver_offer_history_ids = $studentSlipList->where('student_history_id', $value->id)
                    ->pluck('site_student_fee_waiver_offer_history_ids');

                $fee_generate_ids = $site_student_fee_generate_ids
                    ->flatMap(fn($item) => explode(',', $item))
                    ->unique()
                    ->values();

                $fee_waiver_ids = $site_student_fee_waiver_offer_history_ids
                    ->flatMap(fn($item) => explode(',', $item))
                    ->unique()
                    ->values();

                $fee_generated_sum=0;
                foreach($fee_generate_ids as $fee_id){
                    $fee=SiteStudentFeeGenerate::where('id',$fee_id)->first();
                    if($fee){
                        $fee_generated_sum +=$fee->amount;
                    }
                }
                $fee_waiver_sum=0;
                foreach($fee_waiver_ids as $waiver_id){
                    $waiver=SiteStudentFeeWaiverOfferHistory::where('id',$waiver_id)->first();
                    if($waiver){

                        if($waiver->percantage_status){
                            $std_fee_generate = SiteStudentFeeGenerate::where('student_history_id',$value->id)
                                ->where('site_student_fee_fine_allocation_id', $waiver->site_student_fee_fine_allocation_id)
                                ->first();

                                $amount=($std_fee_generate->amount*$waiver->amount)/100;

                                $waiver_amount=$amount;

                        }else{
                            $waiver_amount=$waiver->amount;
                        }

                        $fee_waiver_sum+=$waiver_amount;
                    }
                }
          

             /// other class fee calculate
                $checkPrevClassSlip = GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id', $value->id)
                //    ->where('previous_academic_class_due_status', 1)
                    ->where('site_id', Session::get('SITE_ID'))
                    // ->where('status', 1)
                    ->orderBy('id', 'desc')
                    ->first(); 

                $prev_paid_total_amount=0;
                if($checkPrevClassSlip){
                    if(!$checkPrevClassSlip->previous_academic_class_due_status){
                        $prev_paid_total_amount=$checkPrevClassSlip->total_amount;
                    }
                }


                $dataListArr[$key]['total_generate_amount'] = $fee_generated_sum;
                $dataListArr[$key]['total_waiver_amount'] = $fee_waiver_sum;

                $user_details = Student::where('id', $value->user_id)->first();

                $dataListArr[$key]['student_history_id'] = $value->id??null;
                $dataListArr[$key]['student_roll_number'] = $value->student_full_roll_number??null;
                $dataListArr[$key]['std_name'] = $user_details->full_name??null;
                $dataListArr[$key]['reg_no'] = $user_details->username??null;

                $total_paid_amount=$payment_history_list->sum('paid_amount');

                $fee_fine = GlobalSiteStudentFeeFine::where('student_history_id', $value->id)
                    ->where('site_id',Session::get('SITE_ID'))
                    ->where('academic_group_id',$value->academic_group_id)
                    ->sum('fine_amount');

                $total_paid_amount=$total_paid_amount-$prev_paid_total_amount;

                $total_payable_amount = ($fee_generated_sum + $fee_fine) - $fee_waiver_sum;
                $due_amount = $total_payable_amount- $total_paid_amount;


                $dataListArr[$key]['prev_paid_total_amount'] = $prev_paid_total_amount;
                $dataListArr[$key]['total_paid_amount'] = $total_paid_amount;
                $dataListArr[$key]['fee_fine'] = $fee_fine;
                $dataListArr[$key]['total_payable_amount'] = $total_payable_amount;
                $dataListArr[$key]['due'] = $due_amount;

                $gross_total_paid_amount += $dataListArr[$key]['total_paid_amount']??0;
                $gross_total_due_amount += $dataListArr[$key]['due'];
                $gross_total_generate_amount += $dataListArr[$key]['total_generate_amount'];
                $gross_total_payable_amount += $total_payable_amount;
                $gross_total_due_paid_amount += $prev_paid_total_amount;

                $gross_waiver_amount += $dataListArr[$key]['total_waiver_amount']??0;
                $gross_fee_fine += $dataListArr[$key]['fee_fine'];
            }

            if($request->amount_condition=='due'){
                $dataListArr=collect($dataListArr)->where('due','!=',0)->values();
            }
            if($request->amount_condition=='paid'){
                $dataListArr=collect($dataListArr)->where('due','==',0)->values();
            }

            return [$dataListArr, $gross_total_paid_amount, $gross_total_due_amount, $gross_total_generate_amount , $gross_waiver_amount,$gross_fee_fine,$gross_total_payable_amount,$gross_total_due_paid_amount];
        }
        throw new Error('payment not found!');
    }


    public function getSubHeadList(Request $request)
    {

        $data = $request->all();
        $academicFeeGroup=AcademicFeeGroup::get();

        $FeeGroupsID=$academicFeeGroup->whereIn('head_key', ['classbase','studentbase'])->pluck('id');

        $siteSettings=GlobalSiteInfoSetting::where('site_id',Session::get('SITE_ID'))
                    ->where('academic_group_id', $request->academic_group_id)
                    ->first();

        $feeHeadList= AcademicFeeHead::whereIn('id', explode(',', $siteSettings->academic_fee_head_ids))->get();
    //    $FeeTypes= AcademicGeneralFeeType::whereIn('id', explode(',', $siteSettings->academic_fee_head_ids))->get();


        $siteFeeAllocation=GlobalSiteStudentFeeFineAllocation::whereIn('academic_fee_group_id',$FeeGroupsID)
            ->where('academic_version_id',$request->academic_version_id)
            ->where('academic_shift_id',$request->academic_shift_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->where('site_id',Session::get('SITE_ID'))
            ->where('academic_group_id', $request->academic_group_id)
            ->where('status', true)
            ->get();

        $headeWiseAllocation=$siteFeeAllocation->pluck('academic_fee_head_id')->unique()->filter();

        $headArray=[];
        $headList=[];
        $head_key=0;
        foreach ($feeHeadList as $value) {

            $headeWiseAllocation=$siteFeeAllocation->where('academic_fee_head_id',$value->id);
            $sub_head_ids=$headeWiseAllocation->pluck('academic_fee_sub_head_id')->unique()->filter();
            if(count($sub_head_ids)){

                $subHeadList=[];
                $sub_head_key=0;
                foreach($sub_head_ids as $sub_head_id){
                    $subHead=AcademicFeeSubHead::where('id',$sub_head_id)->first();
                    $subHeadList[$sub_head_key]['select_academic_fee_sub_head']=false;
                    $subHeadList[$sub_head_key]['academic_fee_head_id']=$value->id;
                    $subHeadList[$sub_head_key]['academic_fee_sub_head_id']=$sub_head_id;
                    $subHeadList[$sub_head_key]['name']=$subHead->name;
                    $sub_head_key++;
                }

                
                $typeList=[];
                $head_type_key=0;
              //  $feeheadlist = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
                $headBaseValue = null;
                $headBaseTypelist = array();
                if ($value->head_key == 'monthly') {
                    $headBaseTypelist = AcademicMonthName::get();
                    $headBaseValue = 'monthly';
                } else if ($value->head_key == 'examination') {

                    $selectedSiteGroupList = SiteInfoSetting::first();
                    $Examinationlist = Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                    $headBaseTypelist = [];
                    $headBaseTypelistArr = array();
                    foreach ($Examinationlist as $key => $values) {

                        $headBaseTypelistArr['id'] = $values->id;
                        $headBaseTypelistArr['name'] = $values->examination_name;

                        $headBaseTypelist[$key] = array_merge($headBaseTypelistArr);
                    }
                    $headBaseValue = 'examination';
                } else if ($value->head_key == 'admission') {
                    $headBaseTypelist = AcademicAdmissionFeeType::get();
                    $headBaseValue = 'admission';
                } else if ($value->head_key == 'general') {
                    $headBaseTypelist = AcademicGeneralFeeType::get();
                    $headBaseValue = 'general';
                }

                $headBaseTypelist['select_fee_type']=false;

                $headList[$head_key]['head_key']=$headBaseValue;
                $headList[$head_key]['select_academic_fee_head']=false;
                $headList[$head_key]['academic_fee_head']=$value;
                $headList[$head_key]['academic_sub_head_list']=$subHeadList;
                $headList[$head_key]['headBaseTypelist']=$headBaseTypelist;
                $head_key++;
            }

        }

        return $headList;

    }



    // public function getSiteSubHeadGeneralFeeList2(Request $request){

    //     //=== class ids selected=======

    //     $class_ids=[];
    //     if(count($request->academic_class_ids)){
    //         $class_ids=$request->academic_class_ids;

    //     }else{
    //         foreach($request->academic_class_list as $key=>$class_item){
    //             $class_ids[]=$class_item['id'];
    //         }
    //     }

    //     //=== head and sub-head ids selected=======
    //     $academic_fee_head_ids=[];
    //     $academic_fee_sub_head_ids=[];
    //     $sub_key=0;
    //     foreach($request->headWiseSubHeadList as $key=>$head_item){
    //         if($head_item['select_academic_fee_head']){
    //             $academic_fee_head_ids[$key]=$head_item['academic_fee_head']['id'];
    //             foreach($head_item['academic_sub_head_list'] as $sub_head_item){
    //                 if($sub_head_item['select_academic_fee_sub_head']){
    //                     $academic_fee_sub_head_ids[$sub_key]=$sub_head_item['academic_fee_sub_head_id'];
    //                     $sub_key++;
    //                 }

    //             }
    //         }
    //     }

    //     $academic_fee_sub_head_ids=collect($academic_fee_sub_head_ids)->unique();

    //     $FeeGroupsID=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])->pluck('id');


    //     $fee_sub_head_allocation_ids=GlobalSiteStudentFeeFineAllocation::where('academic_version_id',$request->academic_version_id)
    //         ->where('academic_shift_id',$request->academic_shift_id)
    //         ->where('academic_year_id',$request->academic_year_id)
    //         ->whereIn('academic_class_id',$class_ids)
    //         ->whereIn('academic_fee_head_id',$academic_fee_head_ids)
    //         ->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids)
    //         ->whereIn('academic_fee_group_id',$FeeGroupsID)
    //         ->where('site_id',Session::get('SITE_ID'))
    //         ->where('academic_group_id', $request->academic_group_id)
    //         //->get();
    //         ->pluck('id')
    //         ->unique()
    //         ->filter();



    //     $fee_generated_list=SiteStudentFeeGenerate::whereIn('academic_fee_head_id',$academic_fee_head_ids)
    //         ->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids)
    //         ->whereIn('site_student_fee_fine_allocation_id',$fee_sub_head_allocation_ids)
    //         ->get();

    //   //  $fee_generated_ids=$fee_generated_list->pluck('id')->unique()->filter();
    //     $fee_generated_std_history_ids=$fee_generated_list->pluck('student_history_id')->unique()->filter()->values();

    //     $student_arra=[];
    //     $std_key=0;
    //     $total_pay_amount=0;

    //     $studentHistoryList=GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section','session','studentType'])
    //         ->whereIn('id',$fee_generated_std_history_ids)
    //         ->whereIn('academic_class_id',$class_ids)
    //         ->orderBy('academic_class_id')
    //         ->orderBy('academic_class_group_id')
    //         ->orderBy('student_roll_number')
    //         ->get();


    //     foreach($studentHistoryList as $studentHistory){

    //         if($studentHistory){

    //         $fee_history_array=[];
    //         $sub_h_key=0;
    //         $sub_total_pay_amount=0;

    //         foreach($academic_fee_sub_head_ids as $sub_head){

    //             $fee_generated_idss=$fee_generated_list
    //                 ->where('academic_fee_sub_head_id',$sub_head)
    //                 ->where('student_history_id',$studentHistory->id)
    //                 ->pluck('id')
    //                 ->unique()
    //                 ->filter()
    //                 ->values();


    //         if(count($fee_generated_idss)){

    //             $payment_history_ids = GlobalSiteStudentFeePaymentHistory::where('site_id',Session::get('SITE_ID'))
    //                 ->where('academic_group_id', $request->academic_group_id)
    //                 ->when(isset($request->start_date) && isset($request->end_date),function($q) use ($request){
    //                     $q->whereBetween('payment_date', [$request->start_date, $request->end_date]);
    //                 })
    //                 ->where('student_history_id', $studentHistory->id)
    //                 ->select('id')
    //                 ->pluck('id');


    //             $headPaymentHistory=SiteStudentHeadWiseFeePaymentHistory::with('collectedBy')
    //                 ->whereIn('student_fee_generate_id',$fee_generated_idss)
    //                 ->where('site_student_fee_payment_history_id','!=',null)
    //                 ->where('student_history_id',$studentHistory->id)
    //                 ->whereIn('site_student_fee_payment_history_id',$payment_history_ids)
    //                 ->orderBy('id','DESC')
    //               //  ->select('id','pay_amount','sub_total_waiver_amount','sub_total_due_amount')
    //                 ->get();

    //             $sub_sub_total_pay_amount=0;
    //             $sub_total_waiver_amount=0;
    //             $sub_total_due_amount=0;
    //             foreach($headPaymentHistory as $key=>$pay_history){
    //                 $sub_sub_total_pay_amount+=$pay_history->pay_amount;
    //                 $sub_total_waiver_amount+=$pay_history->sub_total_waiver_amount;
    //                 $sub_total_due_amount+=$pay_history->sub_total_due_amount;
    //             }

    //             $lastItem=$headPaymentHistory->first();

    //             if($lastItem){
    //                 $subHead=AcademicFeeSubHead::findOrFail($sub_head);
    //                 $fee_history_array[$sub_h_key]['total_pay_amount']=$sub_sub_total_pay_amount;
    //                 $fee_history_array[$sub_h_key]['total_waiver_amount']=$sub_total_waiver_amount;
    //                 $fee_history_array[$sub_h_key]['total_due_amount']=$sub_total_due_amount;
    //                 $fee_history_array[$sub_h_key]['sub_head_id']=$subHead->id;
    //                 $fee_history_array[$sub_h_key]['sub_head']=$subHead;
    //                 $fee_history_array[$sub_h_key]['payment_history_list']=$headPaymentHistory;

    //                 $sub_total_pay_amount+=$sub_sub_total_pay_amount;
    //                 $sub_h_key++;

    //             }else{
    //                  $subHead=AcademicFeeSubHead::findOrFail($sub_head);
    //                 $fee_history_array[$sub_h_key]['total_pay_amount']='0';
    //                 $fee_history_array[$sub_h_key]['total_waiver_amount']='0';
    //                 $fee_history_array[$sub_h_key]['total_due_amount']='0';
    //                 $fee_history_array[$sub_h_key]['sub_head_id']=$subHead->id;
    //                 $fee_history_array[$sub_h_key]['sub_head']=$subHead;
    //                 $fee_history_array[$sub_h_key]['payment_history_list']='0';

    //                 $sub_total_pay_amount+='0.00';
    //                 $sub_h_key++;
    //             }
    //           }else{
    //                 $subHead=AcademicFeeSubHead::findOrFail($sub_head);
    //                 $fee_history_array[$sub_h_key]['total_pay_amount']='0';
    //                 $fee_history_array[$sub_h_key]['total_waiver_amount']='0';
    //                 $fee_history_array[$sub_h_key]['total_due_amount']='0';
    //                 $fee_history_array[$sub_h_key]['sub_head_id']=$subHead->id;
    //                 $fee_history_array[$sub_h_key]['sub_head']=$subHead;
    //                 $fee_history_array[$sub_h_key]['payment_history_list']='0';

    //                 $sub_total_pay_amount+='0';
    //                 $sub_h_key++;

    //           }
    //         }

    //         if(count($fee_history_array)){
    //             $student_arra[$std_key]['student_history']=$studentHistory;
    //             $student_arra[$std_key]['sub_head_list']=$fee_history_array;
    //             $student_arra[$std_key]['sub_total_pay_amount']=$sub_total_pay_amount;
    //             $total_pay_amount+=$sub_total_pay_amount;
    //             $std_key++;
    //         }
    //     }
    //     }
     

    //     // $sub_head_id_array=[];
    //     // $sub_head_key=0;

    //     // foreach($student_arra as $item){
    //     //     foreach($item['sub_head_list'] as $items){
    //     //         $sub_head_id_array[$sub_head_key]=$items['sub_head_id'];
    //     //         $sub_head_key++;
    //     //     }
    //     // }
    //     $sub_head_list=AcademicFeeSubHead::whereIn('id',$academic_fee_sub_head_ids)->get();
    //     $sub_total_array=[];
    //     foreach($sub_head_list as $key=>$subhead){
    //         $sub_total=0;
    //         foreach($student_arra as $student_item){
    //            $sub_total+=collect($student_item['sub_head_list'])->where('sub_head_id',$subhead->id)->sum('total_pay_amount');
    //         }
    //         $sub_total_array[$key]['subhead_total']=$sub_total;
    //         $sub_total_array[$key]['subhead_id']=$subhead->id;
    //         $sub_total_array[$key]['subhead_name']=$subhead->name;
    //     }

    //     $grossReport=[
    //         'total_pay_amount'=>$total_pay_amount,
    //         'subhead_total_array'=>$sub_total_array
    //     ];

    //     return [$student_arra,$sub_head_list,$grossReport];

    // }

//     public function getSiteSubHeadGeneralFeeList(Request $request)
// {
//     $class_ids = $request->academic_class_ids ?: collect($request->academic_class_list)->pluck('id')->toArray();

//     $academic_fee_head_ids = [];
//     $academic_fee_sub_head_ids = [];
//     $genral_fee_type_ids = $admission_fee_type_ids = $monthly_fee_type_ids = $examination_fee_type_ids = [];

//     foreach ($request->headWiseSubHeadList as $head_item) {
//         if (!$head_item['select_academic_fee_head']) {
//             continue;
//         }

//         $academic_fee_head_ids[] = $head_item['academic_fee_head']['id'];

//         foreach ($head_item['academic_sub_head_list'] as $sub_head_item) {
//             if ($sub_head_item['select_academic_fee_sub_head']) {
//                 $academic_fee_sub_head_ids[] = $sub_head_item['academic_fee_sub_head_id'];
//             }
//         }

//         $fee_type_ids = collect($head_item['headBaseTypelist'])
//             ->where('select_fee_type_id', true)
//             ->pluck('id')
//             ->filter()
//             ->unique()
//             ->values();

//         if(!count($fee_type_ids)){

//         $fee_type_ids = collect($head_item['headBaseTypelist'])
//         //    ->where('select_fee_type_id', true)
//             ->pluck('id')
//             ->filter()
//             ->unique()
//             ->values();
//         }

//         switch ($head_item['head_key']) {
//             case 'general':      $genral_fee_type_ids     = $fee_type_ids; break;
//             case 'admission':    $admission_fee_type_ids  = $fee_type_ids; break;
//             case 'monthly':      $monthly_fee_type_ids    = $fee_type_ids; break;
//             case 'examination':  $examination_fee_type_ids= $fee_type_ids; break;
//         }
//     }

//     // যদি sub head না পাওয়া যায়, সবগুলা নিই
//     if (empty($academic_fee_sub_head_ids)) {
//         foreach ($request->headWiseSubHeadList as $head_item) {
//             $academic_fee_head_ids[] = $head_item['academic_fee_head']['id'];
//             foreach ($head_item['academic_sub_head_list'] as $sub_head_item) {
//                 $academic_fee_sub_head_ids[] = $sub_head_item['academic_fee_sub_head_id'];
//             }
//         }
//     }

//     $academic_fee_sub_head_ids = array_values(array_unique($academic_fee_sub_head_ids));

//     // একবারেই group ids আনা
//     $feeGroupIds = AcademicFeeGroup::whereIn('head_key', ['classbase', 'studentbase'])->pluck('id');

//     // Allocation IDs
//     $fee_sub_head_allocation_ids = GlobalSiteStudentFeeFineAllocation::query()
//         ->where([
//             'academic_version_id' => $request->academic_version_id,
//             'academic_shift_id'   => $request->academic_shift_id,
//             'academic_year_id'    => $request->academic_year_id,
//             'site_id'             => Session::get('SITE_ID'),
//             'academic_group_id'   => $request->academic_group_id,
//         ])
//         ->whereIn('academic_class_id', $class_ids)
//         ->whereIn('academic_fee_head_id', $academic_fee_head_ids)
//         ->whereIn('academic_fee_sub_head_id', $academic_fee_sub_head_ids)
//         ->whereIn('academic_fee_group_id', $feeGroupIds)
//         ->pluck('id');

//     // একবারেই সব fee generated list আনা
//     $fee_generated_list = SiteStudentFeeGenerate::query()
//         ->whereIn('academic_fee_head_id', $academic_fee_head_ids)
//         ->whereIn('academic_fee_sub_head_id', $academic_fee_sub_head_ids)
//         ->whereIn('site_student_fee_fine_allocation_id', $fee_sub_head_allocation_ids)
//         ->get();

//     // filter একবারেই
//     $all_generated_ids = collect()
//         ->merge($fee_generated_list->whereIn('fee_head_type_id', $genral_fee_type_ids)->pluck('id'))
//         ->merge($fee_generated_list->whereIn('fee_head_type_id', $admission_fee_type_ids)->pluck('id'))
//         ->merge($fee_generated_list->whereIn('fee_head_type_id', $monthly_fee_type_ids)->pluck('id'))
//         ->merge($fee_generated_list->whereIn('fee_head_type_id', $examination_fee_type_ids)->pluck('id'))
//         ->unique()
//         ->values();

//     $fee_generated_list = $fee_generated_list->whereIn('id', $all_generated_ids);

//     $fee_generated_std_history_ids = $fee_generated_list->pluck('student_history_id')->unique();

//     // Student list eager load সহ
//     $studentHistoryList = GlobalStudentHistory::with([
//             'student', 'stClass', 'accGroup', 'section', 'session', 'studentType'
//         ])
//         ->whereIn('id', $fee_generated_std_history_ids)
//         ->whereIn('academic_class_id', $class_ids)
//         ->when($request->academic_class_group_ids, fn($q) => $q->whereIn('academic_class_group_id', $request->academic_class_group_ids))
//         ->when($request->academic_class_section_ids, fn($q) => $q->whereIn('academic_section_id', $request->academic_class_section_ids))
//         ->orderBy('academic_class_id')
//         ->orderBy('academic_class_group_id')
//         ->orderBy('academic_section_id')
//         ->orderBy('student_roll_number')
//         ->get();

//     // PaymentHistory একবারে
//     $PaymentHistory = GlobalSiteStudentFeePaymentHistory::query()
//         ->where('site_id', Session::get('SITE_ID'))
//         ->where('academic_group_id', $request->academic_group_id)
//         ->when($request->start_date && $request->end_date, fn($q) => $q->whereBetween('payment_date', [$request->start_date, $request->end_date]))
//         ->get()
//         ->groupBy('student_history_id');  // গ্রুপ করে নিলাম

//     // Fine একবারে
//     $FineHistory = SiteStudentFeeFine::query()
//         ->whereIn('student_history_id', $fee_generated_std_history_ids)
//         ->get()
//         ->groupBy('student_history_id');

//     $subHeads = AcademicFeeSubHead::whereIn('id', $academic_fee_sub_head_ids)->get()->keyBy('id');

//     $student_arra = [];
//     $total_pay_amount = $total_fine_amount = 0;


//         foreach ($studentHistoryList as $studentHistory) {
//             $fee_history_array = [];
//             $sub_total_pay_amount = 0;

//             foreach ($academic_fee_sub_head_ids as $sub_head_id) {
//                 $fee_generated_ids = $fee_generated_list
//                     ->where('academic_fee_sub_head_id', $sub_head_id)
//                     ->where('student_history_id', $studentHistory->id)
//                     ->pluck('id');

//                 if ($fee_generated_ids->isNotEmpty()) {
//                     $payment_history_ids = $PaymentHistory->get($studentHistory->id, collect())->pluck('id');

//                     $headPaymentHistory = SiteStudentHeadWiseFeePaymentHistory::with('collectedBy')
//                         ->whereIn('student_fee_generate_id', $fee_generated_ids)
//                         ->whereNotNull('site_student_fee_payment_history_id')
//                         ->where('student_history_id', $studentHistory->id)
//                         ->whereIn('site_student_fee_payment_history_id', $payment_history_ids)
//                         ->get();

//                     $total_pay_amount1 = $headPaymentHistory->sum('pay_amount');
//                     $subHead = $subHeads[$sub_head_id] ?? null;

//                     $fee_history_array[] = [
//                         'total_pay_amount'    => $total_pay_amount1,
//                         'sub_head_id'         => $sub_head_id,
//                         'sub_head'            => $subHead,
//                         'payment_history_list'=> $headPaymentHistory,
//                     ];

//                     $sub_total_pay_amount += $total_pay_amount1;
//                 } else {
//                     $fee_history_array[] = [
//                         'total_pay_amount' => 0,
//                         'sub_head_id'      => $sub_head_id,
//                         'sub_head'         => $subHeads[$sub_head_id] ?? null,
//                         'payment_history_list' => [],
//                     ];
//                 }
//             }

//             $fine_amount = $FineHistory->get($studentHistory->id, collect())->sum('fine_amount');

//             if (collect($fee_history_array)->sum('total_pay_amount') > 0 || $fine_amount > 0) {
//                 $student_arra[] = [
//                     'student_history'     => $studentHistory,
//                     'sub_head_list'       => $fee_history_array,
//                     'fine_amount'         => $fine_amount,
//                     'sub_total_pay_amount'=> $sub_total_pay_amount + $fine_amount,
//                 ];
//                 $total_pay_amount += $sub_total_pay_amount;
//                 $total_fine_amount += $fine_amount;
//             }
//         }

    
//     $sub_total_array = $subHeads->map(function ($subhead) use ($student_arra) {
//         $sub_total = collect($student_arra)->sum(function ($item) use ($subhead) {
//             return collect($item['sub_head_list'])->where('sub_head_id', $subhead->id)->sum('total_pay_amount');
//         });

//         return [
//             'subhead_total' => $sub_total,
//             'subhead_id'    => $subhead->id,
//             'subhead_name'  => $subhead->name,
//         ];
//     })->values();

//     $grossReport = [
//         'total_pay_amount'   => $total_pay_amount + $total_fine_amount,
//         'total_fine_amount'  => $total_fine_amount,
//         'subhead_total_array'=> $sub_total_array,
//     ];

//     return [$student_arra, $subHeads->values(), $grossReport];
// }



    public function getSiteSubHeadGeneralFeeList(Request $request)
    {
       // set_time_limit(300);

        $class_ids = count($request->academic_class_ids)
            ? $request->academic_class_ids
            : collect($request->academic_class_list)->pluck('id')->toArray();

         
        $academic_fee_head_ids = [];
        $academic_fee_sub_head_ids = [];
        $subHeads=[];
        $genral_fee_type_ids=[];
        $admission_fee_type_ids=[];
        $monthly_fee_type_ids=[];
        $examination_fee_type_ids=[];
        foreach ($request->headWiseSubHeadList as $head_item) {
            if ($head_item['select_academic_fee_head']) {
                $academic_fee_head_ids[] = $head_item['academic_fee_head']['id'];
                foreach ($head_item['academic_sub_head_list'] as $sub_head_item) {
                    if ($sub_head_item['select_academic_fee_sub_head']) {
                        $academic_fee_sub_head_ids[] = $sub_head_item['academic_fee_sub_head_id'];
                    }
                }

                // general fee type ids
                if ($head_item['head_key'] == 'general') {
                    $fee_type_ids = collect($head_item['headBaseTypelist'])
                        ->where('select_fee_type_id', true)
                        ->pluck('id')
                        ->filter()
                        ->unique()
                        ->values();

                    if(count($fee_type_ids)){
                        $genral_fee_type_ids=$fee_type_ids;
                      
                    }else{
                        $genral_fee_type_ids=collect($head_item['headBaseTypelist'])
                        ->pluck('id')
                        ->filter()
                        ->unique()
                        ->values();
                    }


                }elseif($head_item['head_key'] == 'admission') {
                    
                    $fee_type_ids = collect($head_item['headBaseTypelist'])
                        ->where('select_fee_type_id', true)
                        ->pluck('id')
                        ->filter()
                        ->unique()
                        ->values();

                    if(count($fee_type_ids)){
                        $admission_fee_type_ids=$fee_type_ids;
                      
                    }else{
                        $admission_fee_type_ids=collect($head_item['headBaseTypelist'])
                            ->pluck('id')
                            ->filter()
                            ->unique()
                            ->values();
                    }

                
                }elseif($head_item['head_key'] == 'monthly') {
                    $fee_type_ids = collect($head_item['headBaseTypelist'])
                        ->where('select_fee_type_id', true)
                        ->pluck('id')
                        ->filter()
                        ->unique()
                        ->values();

                    if(count($fee_type_ids)){
                        $monthly_fee_type_ids=$fee_type_ids;
                      
                    }else{
                        $monthly_fee_type_ids=collect($head_item['headBaseTypelist'])
                            ->pluck('id')
                            ->filter()
                            ->unique()
                            ->values();
                    }


                }elseif($head_item['head_key'] == 'examination') {
                    $fee_type_ids = collect($head_item['headBaseTypelist'])
                        ->where('select_fee_type_id', true)
                        ->pluck('id')
                        ->filter()
                        ->unique()
                        ->values();

                    if(count($fee_type_ids)){
                        $examination_fee_type_ids=$fee_type_ids;
                      
                    }else{
                        $examination_fee_type_ids=collect($head_item['headBaseTypelist'])
                            ->pluck('id')
                            ->filter()
                            ->unique()
                            ->values();
                    }

                } 

            }

        $subHeads = AcademicFeeSubHead::whereIn('id', $academic_fee_sub_head_ids)->get()->keyBy('id');

        }

      

        $academic_fee_sub_head_ids = collect($academic_fee_sub_head_ids)->unique()->values();
       
        if(count($academic_fee_sub_head_ids)==0){
           
            foreach ($request->headWiseSubHeadList as $head_item) {
                $academic_fee_head_ids[] = $head_item['academic_fee_head']['id'];
                foreach ($head_item['academic_sub_head_list'] as $sub_head_item) {
                    $academic_fee_sub_head_ids[] = $sub_head_item['academic_fee_sub_head_id'];
                }
            }

        $academic_fee_sub_head_ids = collect($academic_fee_sub_head_ids)->unique()->values();

        }

        $feeGroupIds = AcademicFeeGroup::whereIn('head_key', ['classbase', 'studentbase'])->pluck('id');
        

        $fee_sub_head_allocation_ids = GlobalSiteStudentFeeFineAllocation::where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->whereIn('academic_class_id', $class_ids)
            ->whereIn('academic_fee_head_id', $academic_fee_head_ids)
            ->whereIn('academic_fee_sub_head_id', $academic_fee_sub_head_ids)
            ->whereIn('academic_fee_group_id', $feeGroupIds)
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $request->academic_group_id)
            ->pluck('id')
            ->unique()
            ->filter()
            ->values();
       

     
        $fee_generated_list = SiteStudentFeeGenerate::whereIn('academic_fee_head_id', $academic_fee_head_ids)
            ->whereIn('academic_fee_sub_head_id', $academic_fee_sub_head_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $fee_sub_head_allocation_ids)
            // ->when(count($request->general_fee_type_ids), function ($q) use ($request) {
            //     $q->whereIn('fee_head_type_id', $request->general_fee_type_ids);
            // })
            ->get();

  
        if(count($genral_fee_type_ids)){
            $general_generated_ids = $fee_generated_list->whereIn('fee_head_type_id', $genral_fee_type_ids)->pluck('id')->unique()->values();
        }
        if(count($genral_fee_type_ids)){
            $admission_generated_ids = $fee_generated_list->whereIn('fee_head_type_id', $admission_fee_type_ids)->pluck('id')->unique()->values();
        }
        if(count($monthly_fee_type_ids)){
            $monthly_generated_ids = $fee_generated_list->whereIn('fee_head_type_id', $monthly_fee_type_ids)->pluck('id')->unique()->values();
        }
        if(count($examination_fee_type_ids)){
            $examination_generated_ids = $fee_generated_list->whereIn('fee_head_type_id', $examination_fee_type_ids)->pluck('id')->unique()->values();
        }

        $all_generated_ids = collect()
            ->merge($general_generated_ids ?? [])
            ->merge($admission_generated_ids ?? [])
            ->merge($monthly_generated_ids ?? [])
            ->merge($examination_generated_ids ?? [])
            ->unique()
            ->values();

         //   dd($genral_fee_type_ids,$admission_fee_type_ids,$monthly_fee_type_ids,$examination_fee_type_ids);

     
        $feeGeneratedList = $fee_generated_list
            ->when(count($all_generated_ids),function($q) use ($all_generated_ids){
                return $q->whereIn('id',$all_generated_ids);
            });
       
        $fee_generated_std_history_ids = $feeGeneratedList
            ->pluck('student_history_id')
            ->unique()
            ->filter()
            ->values();

             //  dd($feeGeneratedList);


        $studentHistoryList = GlobalStudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'session', 'studentType'])
            ->whereIn('id', $fee_generated_std_history_ids)
            ->whereIn('academic_class_id', $class_ids)
            ->when(count($request->academic_class_group_ids), function ($q) use ($request) {
                $q->whereIn('academic_class_group_id', $request->academic_class_group_ids);
            })
            ->when(count($request->academic_class_section_ids), function ($q) use ($request) {
                $q->whereIn('academic_section_id', $request->academic_class_section_ids);
            })
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->orderBy('student_roll_number')
            ->get();

        $studentHistoryListIds = $studentHistoryList->pluck('id');
 
  // dd($fee_generated_std_history_ids);
        $student_arra = [];
        $subheadIdArra = [];
        $total_pay_amount = 0;
        $total_fine_amount = 0;

     
        $PaymentHistory = GlobalSiteStudentFeePaymentHistory::where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $request->academic_group_id)
            ->when(isset($request->start_date) && isset($request->end_date), function ($q) use ($request) {
               return $q->whereBetween('payment_date', [$request->start_date, $request->end_date]);
            })
            ->get();




            //////
        $PaymentHistoryIds = $PaymentHistory->pluck('id');

        $fee_generated_list=$fee_generated_list->when(count($all_generated_ids),function($q) use ($all_generated_ids) {
           return $q->whereIn('id',$all_generated_ids);
        });
      //  ->whereIn('student_history_id',$fee_generated_std_history_ids);


        $headPaymentHistores = SiteStudentHeadWiseFeePaymentHistory::with('collectedBy')
            ->whereIn('site_student_fee_payment_history_id', $PaymentHistoryIds)
            ->whereNotNull('site_student_fee_payment_history_id')
            ->orderBy('id', 'DESC')
            ->get();

          $prevSlips=GlobalSiteStudentFeeDemandSlipDetails::whereIn('due_transfer_to_promoted_student_history_id',$fee_generated_std_history_ids)
                ->where('previous_academic_class_due_status',false)
                ->where('site_id', Session::get('SITE_ID'))
                ->get();


          $preheadPaymentHistores = SiteStudentHeadWiseFeePaymentHistory::with('collectedBy')
            //    ->whereIn('student_fee_generate_id', $previous_class_due_site_student_fee_generate_ids)
                ->whereNotNull('site_student_fee_payment_history_id')
                ->whereIn('student_history_id', $studentHistoryListIds)
                ->whereIn('site_student_fee_payment_history_id', $PaymentHistoryIds)
                ->orderBy('id', 'DESC')
                ->get();

           $globalSiteStudentFeeFine=GlobalSiteStudentFeeFine::whereIn('student_history_id', $studentHistoryListIds)
                ->whereIn('site_student_fee_payment_history_id', $PaymentHistoryIds)
                ->where('site_id', Session::get('SITE_ID'))
                ->where('academic_group_id', $request->academic_group_id)
                ->get();

            //////

         

       //      dd($academic_fee_sub_head_ids);
        foreach ($studentHistoryList as $studentHistory) {
            $fee_history_array = [];
            $sub_total_pay_amount = 0;

             $payment_history_ids =$PaymentHistory
                        ->where('student_history_id', $studentHistory->id)
                        ->pluck('id');

            //            dd($fee_generated_list);

            $student_fee_generated_list=$fee_generated_list->where('student_history_id', $studentHistory->id);

            $student_headPaymentHistores=$headPaymentHistores->where('student_history_id', $studentHistory->id)
                    ->whereIn('site_student_fee_payment_history_id', $payment_history_ids);
           
            $prevSlip=$prevSlips->where('due_transfer_to_promoted_student_history_id',$studentHistory->id)->first();

            $previous_class_due_site_student_fee_generate_ids=[];
            $pre_sub_sub_total_pay_amount=0;

            if($prevSlip){
                $previous_class_due_site_student_fee_generate_ids = explode(',', $prevSlip->site_student_fee_generate_ids);

                $preheadPaymentHistory = $preheadPaymentHistores
                    ->whereIn('student_fee_generate_id', $previous_class_due_site_student_fee_generate_ids)
                    ->whereNotNull('site_student_fee_payment_history_id')
                    ->where('student_history_id', $prevSlip->student_history_id)
                    ->whereIn('site_student_fee_payment_history_id', $payment_history_ids);

                 $pre_sub_sub_total_pay_amount = $preheadPaymentHistory->sum('pay_amount');
            }

          

            foreach ($academic_fee_sub_head_ids as $sub_head_id) {
                $fee_generated_ids = $student_fee_generated_list
                    ->where('academic_fee_sub_head_id', $sub_head_id)
                //    ->where('student_history_id', $studentHistory->id)
                    ->pluck('id')
                    ->unique()
                    ->values();

                if ($fee_generated_ids->isNotEmpty()) {
                    

                    $headPaymentHistory = $student_headPaymentHistores
                        ->whereIn('student_fee_generate_id', $fee_generated_ids);
                    
                    
                        if(count($headPaymentHistory)>0){
                            $subheadIdArra[] = $sub_head_id;
                        }

                         $total_pay_amount1 = $headPaymentHistory->sum('pay_amount');
                         $sub_sub_total_pay_amount = $total_pay_amount1+$pre_sub_sub_total_pay_amount;
                    // $sub_total_waiver_amount = $headPaymentHistory->sum('sub_total_waiver_amount');
                    //  $sub_total_due_amount = $headPaymentHistory->sum('sub_total_due_amount');

                        $subHead = $subHeads[$sub_head_id] ?? null;

                        $fee_history_array[] = [
                            'total_pay_amount' => $sub_sub_total_pay_amount,
                        //  'total_waiver_amount' => $sub_total_waiver_amount,
                        //  'total_due_amount' => $sub_total_due_amount,
                            'sub_head_id' => $sub_head_id,
                            'sub_head' => $subHead,
                            'payment_history_list' => $headPaymentHistory,
                        ];

                    
                        $sub_total_pay_amount += $sub_sub_total_pay_amount;
                   
                   
                } else {
                    $subHead = $subHeads[$sub_head_id] ?? null;
                    $fee_history_array[] = [
                        'total_pay_amount' => 0,
                       // 'total_waiver_amount' => 0,
                       // 'total_due_amount' => 0,
                        'sub_head_id' => $sub_head_id,
                        'sub_head' => $subHead,
                        'payment_history_list' => [],
                    ];
                }

                 
            }



             $fine_amount=$globalSiteStudentFeeFine->where('student_history_id', $studentHistory->id)
                ->whereIn('site_student_fee_payment_history_id', $payment_history_ids)
                ->sum('fine_amount');

            if (collect($fee_history_array)->sum('total_pay_amount') > 0 || $fine_amount>0) {
                $student_arra[] = [
                    'student_history' => $studentHistory,
                    'sub_head_list' => $fee_history_array,
                    'fine_amount' => $fine_amount,
                    'sub_total_pay_amount' => $sub_total_pay_amount+$fine_amount,
                ];
                $total_pay_amount += $sub_total_pay_amount;
                $total_fine_amount += $fine_amount;
            }
        }
        //

        if(!count($subHeads)){
            $academic_fee_sub_head_ids = collect($subheadIdArra)->unique()->values();
        }

        $subHeads = AcademicFeeSubHead::whereIn('id', $academic_fee_sub_head_ids)->get()->keyBy('id');


        $sub_total_array = $subHeads->map(function ($subhead) use ($student_arra,$total_fine_amount) {
            $sub_total = collect($student_arra)->sum(function ($item) use ($subhead) {
                return collect($item['sub_head_list'])->where('sub_head_id', $subhead->id)->sum('total_pay_amount');
            });

            return [
                'subhead_total' => $sub_total,
                'subhead_id' => $subhead->id,
                'subhead_name' => $subhead->name,
            ];
        })->values();

        $grossReport = [
            'total_pay_amount' => $total_pay_amount+$total_fine_amount,
            'total_fine_amount' => $total_fine_amount,
            'subhead_total_array' => $sub_total_array,
        ];

        return [$student_arra, $subHeads->values(), $grossReport];
    }



    public function studentBasePaymentPdfShow($student_history_id){

        //=========check student==========
        $checkStudent=StudentHistory::where('id',$student_history_id)->first();
        if(!$checkStudent){
           return 'Sorry! Student not found!';
        }

        //=========slip history==========
        $slipList=SiteStudentFeeDemandSlipDetails::with('siteStudentFeePaymentHistory','studentHistory')
            ->where('student_history_id',$student_history_id)
            // ->select('id','site_student_fee_generate_ids','previous_site_student_fee_demand_slip_detail_id','fee_amount','previous_due',
            // 'created_date','total_amount','waiver_amount','special_waiver_amount','payment_fine_status','payment_from_date','payment_to_date','status')
            ->orderBy('id','ASC')
            ->get();
            
        $payment_array=[];
        $sl_no=1;
        $key=0;
        foreach($slipList as $slip){

            $prev_slip=SiteStudentFeeDemandSlipDetails::where('id',$slip->previous_site_student_fee_demand_slip_detail_id)
                    ->select('site_student_fee_generate_ids','site_student_fee_waiver_offer_history_ids','waiver_amount')
                    ->where('student_history_id',$slip->student_history_id)
                    ->first();

            if($prev_slip){
                $prev_generate_ids=explode(',',$prev_slip->site_student_fee_generate_ids);
                $prev_waiver_offer_ids=explode(',',$prev_slip->site_student_fee_waiver_offer_history_ids);

                $prev_waiver_amount=$prev_slip->waiver_amount;
            }else{
                $prev_generate_ids=[];
                $prev_waiver_offer_ids=[];
                $prev_waiver_amount=0;
            }

           
            $generate_ids=explode(',',$slip->site_student_fee_generate_ids);
            $waiver_offer_ids=explode(',',$slip->site_student_fee_waiver_offer_history_ids);

            $difference_ids=[];
            if(count($prev_generate_ids)){
                $difference_ids = array_diff($generate_ids, $prev_generate_ids);
                $difference_waiver_ids = array_diff($waiver_offer_ids, $prev_waiver_offer_ids);
            }else{
                if(count($generate_ids)){
                    $difference_ids = $generate_ids;
                    $difference_waiver_ids = $waiver_offer_ids;
                }
            }

            //=========subhead finding==========

            $feeGenerateList=SiteStudentFeeGenerate::whereIn('id',$difference_ids)
                ->select('id','academic_fee_head_id','academic_fee_sub_head_id','fee_head_type_id','amount')
                ->get();
             
            $fee_generate_array=[];
            foreach($feeGenerateList as $keys=>$feeGenerate){
                
            $feeheadlist = AcademicFeeHead::where('id', $feeGenerate->academic_fee_head_id)->first();

            if ($feeheadlist->head_key == 'monthly') {
                $headBaseTypelist = AcademicMonthName::where('id', $feeGenerate->fee_head_type_id)->first();
                $fee_generate_array[$keys]['head_type']=$headBaseTypelist->name;
                

            } else if ($feeheadlist->head_key == 'examination') {

                $headBaseTypelist = Examination::where('id', $feeGenerate->fee_head_type_id)->first();
                $fee_generate_array[$keys]['head_type']=$headBaseTypelist->examination_name;
              

            } else if ($feeheadlist->head_key == 'admission') {

                $headBaseTypelist = AcademicAdmissionFeeType::where('id', $feeGenerate->fee_head_type_id)->first();
                $fee_generate_array[$keys]['head_type']=$headBaseTypelist->name;

            } else if ($feeheadlist->head_key == 'general') {

                $headBaseTypelist = AcademicGeneralFeeType::where('id', $feeGenerate->fee_head_type_id)->first();
                $fee_generate_array[$keys]['head_type']=$headBaseTypelist->name;
            }
            

                $fee_generate_array[$keys]['id']=$feeGenerate->id;
                $fee_generate_array[$keys]['head_name']=$feeGenerate->academicFeeHead->name;
                $fee_generate_array[$keys]['sub_head_name']=$feeGenerate->academicFeeSubHead->name;
                $fee_generate_array[$keys]['amount']=$feeGenerate->amount;
            }

            $created_date = Carbon::parse($slip->created_date)->format('d-m-Y');
  
            $debit_amount=$slip->total_amount-$slip->previous_due;
            $total_due_mount=$slip->total_amount;
           // $total_waiver_amount=$slip->waiver_amount+$slip->special_waiver_amount;
            $total_waiver_amount=$slip->waiver_amount;//-$prev_waiver_amount;//-$prev_slip?$prev_slip->waiver_amount:0;

            $total_fine_amount=$this->getSlipFine($slip);
            $total_debit_amount=$debit_amount+$total_fine_amount;
            $total_due_amount=$total_due_mount+$total_fine_amount;


            ///===== previous class due ======
             $prev_class_slip=SiteStudentFeeDemandSlipDetails::select('id','total_amount','previous_site_student_fee_demand_slip_detail_id','due_transfer_to_promoted_student_history_id','student_history_id')
                ->where('due_transfer_to_promoted_student_history_id',$checkStudent->id)
                ->where('id',$slip->previous_site_student_fee_demand_slip_detail_id)
                ->first();
            if($prev_class_slip){
                $total_debit_amount += $prev_class_slip->total_amount;
                $total_fine_amount += $this->getSlipFine($prev_class_slip);
            }

            ///======


            $payment_array[$key]['fee_generated_list']=$fee_generate_array;
            $payment_array[$key]['invoice_no']=$slip->slip_no;
            $payment_array[$key]['fine_amount']=number_format($total_fine_amount,2);
            $payment_array[$key]['waiver_amount']=number_format($total_waiver_amount,2);
            $payment_array[$key]['debit_amount']=number_format($total_debit_amount,2);
            $payment_array[$key]['credit_amount']='0.00';
            $payment_array[$key]['total_due_mount']=number_format($total_due_amount,2);
            $payment_array[$key]['tr_id']="";
            $payment_array[$key]['paid_by']="-";
            $payment_array[$key]['collected_by']="-";
            $payment_array[$key]['created_date']=$created_date;
            $payment_array[$key]['tran_type']="Payable";
            $key++;
            
            if(count($slip->siteStudentFeePaymentHistory)>0){
                $pay_his_ids=[];
                foreach($slip->siteStudentFeePaymentHistory as $keysss=>$payment_history){

                    $pay_his_ids[$keysss]=$payment_history->id;

                    $created_date = Carbon::parse($payment_history->payment_date)->format('d-m-Y');

                    $feeGenerateList=SiteStudentFeeGenerate::whereIn('id',$generate_ids)
                        ->select('id','academic_fee_head_id','academic_fee_sub_head_id','fee_head_type_id','amount')
                        ->where('student_history_id',$slip->student_history_id)
                        ->get();

                       
                    $fee_generate_array=[];
                    foreach($feeGenerateList as $keys=>$feeGenerate){
                        $fee_generate_array[$keys]['id']=$feeGenerate->id;
                        $fee_generate_array[$keys]['head_name']=$feeGenerate->academicFeeHead->name;
                        $fee_generate_array[$keys]['sub_head_name']=$feeGenerate->academicFeeSubHead->name;
                    }

                    $total_pa_amount=SiteStudentFeePaymentHistory::whereIn('id',$pay_his_ids)->select('id','paid_amount')->sum('paid_amount');

                    $total_pay_fine_amount=$this->getPayFineAmount($payment_history);
                    $slip_total_amount=$slip->total_amount+$total_pay_fine_amount;

                    $payment_array[$key]['fine_amount']=number_format($total_pay_fine_amount,2);
                    $payment_array[$key]['waiver_amount']=number_format($total_waiver_amount,2);

                    $payment_array[$key]['fee_generated_list']=$fee_generate_array;
                    $payment_array[$key]['invoice_no']=$payment_history->voucher_no;
                    $payment_array[$key]['debit_amount']='0.00';
                    $payment_array[$key]['credit_amount']=number_format($payment_history->paid_amount,2);
                    $payment_array[$key]['total_due_mount']=number_format($slip_total_amount-$total_pa_amount,2);
                    $payment_array[$key]['tr_id']=$payment_history->transaction_id;
                    $payment_array[$key]['paid_by']=$payment_history->paid_by;
                    $payment_array[$key]['collected_by']=$payment_history->user->first_name??"";
                    $payment_array[$key]['created_date']=$created_date;
                    $payment_array[$key]['tran_type']="Paid";

                    $key++;
                }
            }
        }

        //=========total amoutn count==========

        $total_fine_amount = collect($payment_array)->where('tran_type','Paid')->sum(function ($item) {
            return (float) str_replace(',', '', $item['fine_amount']);
        });
        $total_debit_amount = collect($payment_array)->sum(function ($item) {
            return (float) str_replace(',', '', $item['debit_amount']);
        });

        $total_credit_amount = collect($payment_array)->sum(function ($item) {
            return (float) str_replace(',', '', $item['credit_amount']);
        });

        $total_waiver_amount = collect($payment_array)->sum(function ($item) {
            return (float) str_replace(',', '', $item['waiver_amount']);
        });

        $total_due_amount = $total_debit_amount-$total_credit_amount;
      
        //=========student details==========
        $student_detail=[
            'student_history_id'=>$checkStudent->id,
            'student_roll_number'=>$checkStudent->student_roll_number,
            'std_name'=>$checkStudent->student->full_name??null,
            'username'=>$checkStudent->student->username??null,
            'contact_number'=>$checkStudent->student->contact_number??null,
            'version_name'=>$checkStudent->version->version_name,
            'year_name'=>$checkStudent->year->year_name,
            'shift_name'=>$checkStudent->shift->shift_name,
            'class_name'=>$checkStudent->stClass->class_name,
            'group_name'=>$checkStudent->accGroup ? $checkStudent->accGroup->group_name : "",
            'section_name'=>$checkStudent->section ? $checkStudent->section->section_name : "",
            'session_name'=>$checkStudent->session ? $checkStudent->session->session_name : "",
            'category_name'=>$checkStudent->academicStudentCategory ? $checkStudent->academicStudentCategory->category_name : "",
            'type_name'=>$checkStudent->studentType?$checkStudent->studentType->student_type_name : "",
            'roll'=>$checkStudent->student_full_roll_number,
        ];

       
       
        $data['site'] = SiteInfo::where('id', session()->get('SITE_ID'))->first();
        $data['student_detail'] =$student_detail;
        $data['payment_array'] = $payment_array;
        $data['total_fine_amount'] = number_format($total_fine_amount,2);
        $data['total_debit_amount'] = number_format($total_debit_amount,2);
        $data['total_credit_amount'] = number_format($total_credit_amount,2);
        $data['total_due_amount'] = number_format($total_due_amount,2);
        $data['total_waiver_amount'] = number_format($total_waiver_amount,2);

        $title_view = 'Student Payment Summary';
        $report_tittle = '<b>Student Payment Summary</b><br>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.student-wise-slip-and-payment-history-report-pdf', compact('data','title_view',
            'report_tittle2','report_tittle'));
        $pdf->setPaper('A4', 'portrait');
        return $pdf->stream(time() . '-student-slip-and-payment-history.pdf');

          
    }

    public function createSubHeadWisePaymentReportPdf(Request $request)
    {

        $site_id = (int)session()->get('SITE_ID');
        $site = SiteInfo::where('id', $site_id)->first();

        $class_shift_details = AcademicShift::where('id', $request->academic_shift_id)->first();
        $class_list = AcademicClass::whereIn('id', $request->academic_class_ids)->get();
        $class_group_list = AcademicClassGroup::whereIn('id', $request->academic_class_group_ids)->get();
        $section_list = AcademicSection::whereIn('id', $request->academic_class_section_ids)->get();

        $session_ids=collect($request->paymentList)
            ->where('student_history.academic_session_id','!=',0)
            ->pluck('student_history.academic_session_id')
            ->unique()
            ->values();

        $session_present=count($session_ids)?true:false;

        $class_group_present=count($class_group_list)?true:false;
        $section_present=count($section_list)?true:false;

        $from_date = $request->start_date;
        $to_date = $request->end_date;

        $paymentList = $request->paymentList;
        $subHeadList = $request->subHeadList;
        $grossReport = $request->grossReport;

        $title_view = 'General report';

   
        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $report_tittle = '<b>General Subhead Wise Report</b>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.sub-head-wise-payment-report-pdf', compact('title_view',
            'report_tittle2','report_tittle','print_date','class_group_present','section_present','session_present','class_shift_details','class_list', 'class_group_list', 'section_list', 'from_date', 'to_date','site','paymentList','subHeadList','grossReport'));

      //  return $pdf->stream(time() . '-sub-head-wise-payment-report.pdf');

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();

     //   return $pdf->stream(time() . '-student-payment.pdf');

        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);

    }

    // public function getGroupStudentGeneralFeeList(Request $request)
    // {
    //     $data = [
    //         'academic_class_id' => $request->academic_class_id ?? null,
    //         'academic_year_id' => $request->academic_year_id ?? null,
    //         'academic_group_id' => session()->get('ACADEMIC_GROUP_ID') ?? null,
    //         'academic_version_id' => $request->academic_version_id ?? null,
    //         'academic_shift_id' => $request->academic_shift_id ?? null,
    //         'academic_session_id' => $request->academic_session_id ?? null,
    //         'academic_student_admission_type_id' => $request->academic_student_admission_type_id ?? null,
    //         'academic_student_category_id' => $request->academic_student_category_id ?? null,
    //         'academic_student_type_id' => $request->academic_student_type_id ?? null,
    //         'academic_class_group_id' => $request->academic_class_group_id ?? null,
    //         'site_id' => $request->site_id ?? null,
    //         'start_date' => $request->start_date ?? null,
    //         'end_date' => $request->end_date ?? null,
    //     ];

    //     $final_data = [];
    //     $gross_generate = $gross_paid = $gross_waiver = $gross_fine = 0;

    //     $siteLists = $data['site_id'] ?
    //         GlobalSiteInfo::where('id', $data['site_id'])->get() :
    //         GlobalSiteInfo::whereIn('id', $this->siteIds())->orderByDesc('id')->get();

    //     foreach ($siteLists as $site) {
    //         $site_id = $site->id;

    //         $studentHistories = GlobalStudentHistory::where('site_id', $site_id)
    //             ->when($data['academic_version_id'], fn($q) => $q->where('academic_version_id', $data['academic_version_id']))
    //             ->when($data['academic_shift_id'], fn($q) => $q->where('academic_shift_id', $data['academic_shift_id']))
    //             ->when($data['academic_year_id'], fn($q) => $q->where('academic_year_id', $data['academic_year_id']))
    //             ->when($data['academic_class_id'], fn($q) => $q->where('academic_class_id', $data['academic_class_id']))
    //             ->when($data['academic_class_group_id'], fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
    //             ->when($data['academic_session_id'], fn($q) => $q->where('academic_session_id', $data['academic_session_id']))
    //             ->when($data['academic_student_admission_type_id'], fn($q) => $q->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']))
    //             ->when($data['academic_student_category_id'], fn($q) => $q->where('academic_student_category_id', $data['academic_student_category_id']))
    //             ->when($data['academic_student_type_id'], fn($q) => $q->where('academic_student_type_id', $data['academic_student_type_id']))
    //             ->where('academic_group_id', $data['academic_group_id'])
    //             ->where('status', true)
    //             ->select('id', 'user_id')
    //             ->get();

    //         if ($studentHistories->isEmpty()) {
    //             continue;
    //         }

    //         $studentHistoryIds = $studentHistories->pluck('id');

    //         $paymentHistories = GlobalSiteStudentFeePaymentHistory::whereIn('student_history_id', $studentHistoryIds)
    //             ->where('site_id', $site_id)
    //             ->where('academic_group_id', $data['academic_group_id'])
    //             ->when($data['start_date'] && $data['end_date'], fn($q) => $q->whereBetween('payment_date', [$data['start_date'], $data['end_date']]))
    //             ->get()->groupBy('student_history_id');

    //         $feeFines = GlobalSiteStudentFeeFine::whereIn('student_history_id', $studentHistoryIds)
    //             ->where('site_id', $site_id)
    //             ->where('academic_group_id', $data['academic_group_id'])
    //             ->get()->groupBy('student_history_id');

    //         $demandSlipDetails = GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIds)
    //             ->where('site_id', $site_id)
    //             ->where('academic_group_id', $data['academic_group_id'])
    //             ->get()->groupBy('student_history_id');

    //         $allGenerateIds = $demandSlipDetails->flatMap(fn($group) => $group->pluck('site_student_fee_generate_ids')->flatMap(fn($v) => explode(',', $v)))->unique();
    //         $allWaiverIds = $demandSlipDetails->flatMap(fn($group) => $group->pluck('site_student_fee_waiver_offer_history_ids')->flatMap(fn($v) => explode(',', $v)))->unique();

    //         $feeGenerateMap = GlobalSiteStudentFeeGenerate::whereIn('id', $allGenerateIds)->get()->keyBy('id');
    //         $waiverMap = GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $allWaiverIds)->get()->keyBy('id');

    //         $site_total_generate = $site_total_paid = $site_total_waiver = $site_total_fine = 0;

    //         foreach ($studentHistories as $student) {
    //             $generate_amount = $waiver_amount = $fine_amount = $paid_amount = 0;

    //             $stdDetails = $demandSlipDetails[$student->id] ?? collect();
    //             $generate_ids = $stdDetails->pluck('site_student_fee_generate_ids')->flatMap(fn($v) => explode(',', $v))->unique();
    //             $waiver_ids = $stdDetails->pluck('site_student_fee_waiver_offer_history_ids')->flatMap(fn($v) => explode(',', $v))->unique();

    //             foreach ($generate_ids as $id) {
    //                 $generate_amount += $feeGenerateMap[$id]->amount ?? 0;
    //             }

    //             foreach ($waiver_ids as $id) {
    //                 $waiver = $waiverMap[$id] ?? null;
    //                 if ($waiver) {
    //                     if ($waiver->percantage_status) {
    //                         $relatedFee = GlobalSiteStudentFeeGenerate::where('student_history_id', $student->id)
    //                             ->where('site_student_fee_fine_allocation_id', $waiver->site_student_fee_fine_allocation_id)
    //                             ->first();
    //                         if ($relatedFee) {
    //                             $waiver_amount += ($relatedFee->amount * $waiver->amount) / 100;
    //                         }
    //                     } else {
    //                         $waiver_amount += $waiver->amount;
    //                     }
    //                 }
    //             }

    //             $paid_amount = ($paymentHistories[$student->id] ?? collect())->sum('paid_amount');
    //             $fine_amount = ($feeFines[$student->id] ?? collect())->sum('fine_amount');

    //             $site_total_generate += $generate_amount;
    //             $site_total_paid += $paid_amount;
    //             $site_total_waiver += $waiver_amount;
    //             $site_total_fine += $fine_amount;
    //         }

    //         $total_payable = ($site_total_generate + $site_total_fine) - $site_total_waiver;
    //         $total_due = $total_payable - $site_total_paid;

    //         $class = AcademicClass::find($data['academic_class_id']);

    //         $final_data[] = [
    //             'total_generate_amount' => $site_total_generate,
    //             'total_paid_amount' => $site_total_paid,
    //             'total_waiver_amount' => $site_total_waiver,
    //             'total_fine_amount' => $site_total_fine,
    //             'total_due_amount' => $total_due,
    //             'total_payable_amount' => $total_payable,
    //             'class_name' => $class->class_name ?? 'All class',
    //             'site_name' => $site->site_name,
    //         ];

    //         $gross_generate += $site_total_generate;
    //         $gross_paid += $site_total_paid;
    //         $gross_waiver += $site_total_waiver;
    //         $gross_fine += $site_total_fine;
    //     }

    //     $gross_total_payable = ($gross_generate + $gross_fine) - $gross_waiver;
    //     $gross_total_due = $gross_total_payable - $gross_paid;

    //     $gross_report = [
    //         'gross_total_generate_amount' => $gross_generate,
    //         'gross_total_paid_amount' => $gross_paid,
    //         'gross_total_waiver_amount' => $gross_waiver,
    //         'gross_total_fine_amount' => $gross_fine,
    //         'gross_total_due_amount' => $gross_total_due,
    //         'gross_total_payable_amount' => $gross_total_payable,
    //     ];

    //     return [$final_data, $gross_report];
    // }

    public function getSiteGeneralFeeList2(Request $request)
    {
        if (!count($request->academic_class_ids)) {
            throw new \Exception('No class selected.');
        }
    
        $siteId = Session::get('SITE_ID');
        $versionId = $request->academic_version_id;
        $yearId = $request->academic_year_id;
        $shiftId = $request->academic_shift_id;
        $groupId = $request->academic_group_id;
    
        $grossTotals = [
            'generate' => 0,
            'paid' => 0,
            'waiver' => 0,
            'fine' => 0,
            'due' => 0,
        ];
    
        $finalData = [];
    
        foreach ($request->academic_class_ids as $index => $classId) {
            $classTotals = [
                'generate' => 0,
                'paid' => 0,
                'waiver' => 0,
                'fine' => 0,
            ];
    
            // Fetch all students of this class
            $students = GlobalStudentHistory::where([
                    'academic_class_id' => $classId,
                    'academic_version_id' => $versionId,
                    'academic_year_id' => $yearId,
                    'academic_shift_id' => $shiftId,
                    'site_id' => $siteId,
                    'academic_group_id' => $groupId,
                    'status' => 1
                ])
                ->select('id', 'academic_group_id')
                ->get();
    
            $studentIds = $students->pluck('id');
    
            if ($studentIds->isEmpty()) {
                continue;
            }
    
            // Payment History
            $paymentQuery = GlobalSiteStudentFeePaymentHistory::whereIn('student_history_id', $studentIds)
                ->where('site_id', $siteId)
                ->where('academic_group_id', $groupId);
    
            if ($request->start_date && $request->end_date) {
                $paymentQuery->whereBetween('payment_date', [$request->start_date, $request->end_date]);
            }
    
            $totalPaid = $paymentQuery->sum('paid_amount');
            $classTotals['paid'] = $totalPaid;
    
            // Demand Slip Details
            $slipDetails = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentIds)
                ->where('site_id', $siteId)
                ->where('academic_group_id', $groupId)
                ->get();
    
            foreach ($slipDetails as $detail) {
                // Calculate generate and waiver
                $generateIds = collect(explode(',', $detail->site_student_fee_generate_ids))->filter();
                $waiverIds = collect(explode(',', $detail->site_student_fee_waiver_offer_history_ids))->filter();
    
                foreach ($generateIds as $genId) {
                    $fee = SiteStudentFeeGenerate::find($genId);
                    if ($fee) {
                        $classTotals['generate'] += $fee->amount;
                    }
                }
    
                foreach ($waiverIds as $waiverId) {
                    $waiver = SiteStudentFeeWaiverOfferHistory::find($waiverId);
                    if ($waiver) {
                        $waiverAmount = 0;
                        if ($waiver->percantage_status) {
                            $feeGen = SiteStudentFeeGenerate::where('student_history_id', $detail->student_history_id)
                                ->where('site_student_fee_fine_allocation_id', $waiver->site_student_fee_fine_allocation_id)
                                ->first();
                            if ($feeGen) {
                                $waiverAmount = ($feeGen->amount * $waiver->amount) / 100;
                            }
                        } else {
                            $waiverAmount = $waiver->amount;
                        }
                        $classTotals['waiver'] += $waiverAmount;
                    }
                }
            }
    
            // Fine
            $fineAmount = GlobalSiteStudentFeeFine::whereIn('student_history_id', $studentIds)
                ->where('site_id', $siteId)
                ->where('academic_group_id', $groupId)
                ->sum('fine_amount');
            $classTotals['fine'] = $fineAmount;
    
            // Totals
            $payable = ($classTotals['generate'] + $classTotals['fine']) - $classTotals['waiver'];
            $due = $payable - $classTotals['paid'];
    
            // Store in final data
            $class = AcademicClass::find($classId);

            $finalData[$index] = [
                'class_name' => $class ? $class->class_name : 'Unknown',
                'total_generate_amount' => $classTotals['generate'],
                'total_paid_amount' => $classTotals['paid'],
                'total_waiver_amount' => $classTotals['waiver'],
                'total_fine_amount' => $classTotals['fine'],
                'total_payable_amount' => $payable,
                'total_due_amount' => $due,
            ];
            
    
            // Add to gross
            $grossTotals['generate'] += $classTotals['generate'];
            $grossTotals['paid'] += $classTotals['paid'];
            $grossTotals['waiver'] += $classTotals['waiver'];
            $grossTotals['fine'] += $classTotals['fine'];
            $grossTotals['due'] += $due;
        }
    
        // Prepare final gross report
        $grossReport = [
            'gross_total_generate_amount' => $grossTotals['generate'],
            'gross_total_paid_amount' => $grossTotals['paid'],
            'gross_total_waiver_amount' => $grossTotals['waiver'],
            'gross_total_fine_amount' => $grossTotals['fine'],
            'gross_total_payable_amount' => ($grossTotals['generate'] + $grossTotals['fine']) - $grossTotals['waiver'],
            'gross_total_due_amount' => $grossTotals['due'],
        ];
    
        return [$finalData, $grossReport];
    }
    
    

    public function getSiteGeneralFeeList(Request $request)
    {
        if (count($request->academic_class_ids) > 0) {

            $gross_total_generate_amount = 0;
            $gross_total_paid_amount = 0;
            $gross_total_waiver_amount = 0;
            $gross_total_fine_amount = 0;
            $gross_total_due_amount = 0;
            $final_data=[];
            foreach ($request->academic_class_ids as $key => $value) {
                $total_generate_amount = 0;
                $total_paid_amount = 0;
                $total_waiver_amount = 0;
                $total_fine_amount = 0;

                $student_class_base_history_list = GlobalStudentHistory::where('academic_class_id', $value)
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $request->academic_group_id)
                   // ->where('academic_class_group_id', 2)
                    ->where('status', 1)
                    ->with('stClass')
                    ->get();

                if (count($student_class_base_history_list) > 0) {

                    foreach ($student_class_base_history_list as $ke => $va) {

                        $std_generate_amount = 0;
                        $std_paid_amount = 0;
                        $std_waiver_amount = 0;
                        if ($request->start_date && $request->end_date) {
                            $std_payment_history = GlobalSiteStudentFeePaymentHistory::where('student_history_id', $va->id)
                                ->whereBetween('payment_date', [$request->start_date, $request->end_date])
                                ->where('site_id', Session::get('SITE_ID'))
                                ->where('academic_group_id', $request->academic_group_id)
                               // ->with('siteStudentFeeDemandSlipDetails')
                                ->get();
                        }else {
                            $std_payment_history = GlobalSiteStudentFeePaymentHistory::where('student_history_id', $va->id)
                                        ->where('site_id', Session::get('SITE_ID'))
                                        ->where('academic_group_id', $request->academic_group_id)
                                      //  ->with('siteStudentFeeDemandSlipDetails')
                                        ->get();
                        }


                            if (count($std_payment_history) > 0) {
                                foreach ($std_payment_history as $kk => $vv) {
                                    $std_paid_amount += $vv->paid_amount;

                                }
                            }

                            // $student_demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('student_history_id', $va->id)
                            //         ->where('site_id', Session::get('SITE_ID'))
                            //         ->where('academic_group_id', $request->academic_group_id)
                            //       //  ->where('status', 1)
                            //         ->get();



                            // if (count($student_demand_slip_details)) {
                            //     foreach($student_demand_slip_details as $vass){
                            //         $std_generate_amount+=$vass->fee_amount;
                            //         $std_waiver_amount+=$vass->waiver_amount;
                            //     }
                            // }


                        $site_student_fee_generate_ids = SiteStudentFeeDemandSlipDetails::where('student_history_id', $va->id)
                            ->where('site_id',Session::get('SITE_ID'))
                            ->where('academic_group_id',$va->academic_group_id)
                            ->pluck('site_student_fee_generate_ids');

                        $site_student_fee_waiver_offer_history_ids = SiteStudentFeeDemandSlipDetails::where('student_history_id', $va->id)
                            ->where('academic_group_id',$va->academic_group_id)
                            ->pluck('site_student_fee_waiver_offer_history_ids');

                      //  dd($site_student_fee_waiver_offer_history_ids);

                        $fee_generate_ids = $site_student_fee_generate_ids
                            ->flatMap(fn($item) => explode(',', $item))
                            ->unique()
                            ->values();

                        $fee_waiver_ids = $site_student_fee_waiver_offer_history_ids
                            ->flatMap(fn($item) => explode(',', $item))
                            ->unique()
                            ->values();


                            $std_generate_amount=0;
                            foreach($fee_generate_ids as $fee_id){
                                $fee=SiteStudentFeeGenerate::where('id',$fee_id)->first();
                                if($fee){
                                    $std_generate_amount +=$fee->amount;
                                }
                            }


                            $std_waiver_amount=0;
                            foreach($fee_waiver_ids as $waiver_id){
                                $waiver=SiteStudentFeeWaiverOfferHistory::where('id',$waiver_id)->first();
                                if($waiver){

                                    if($waiver->percantage_status){
                                        $std_fee_generate = SiteStudentFeeGenerate::where('student_history_id',$va->id)
                                            ->where('site_student_fee_fine_allocation_id', $waiver->site_student_fee_fine_allocation_id)
                                            ->first();

                                            $amount=($std_fee_generate->amount*$waiver->amount)/100;

                                            $waiver_amount=$amount;

                                    }else{
                                        $waiver_amount=$waiver->amount;
                                    }

                                    $std_waiver_amount+=$waiver_amount;
                                }
                            }


                            $total_generate_amount += $std_generate_amount;
                            $total_paid_amount += $std_paid_amount;
                            $total_waiver_amount += $std_waiver_amount;



                        $fee_fine_details = GlobalSiteStudentFeeFine::where('student_history_id', $va->id)
                            ->where('site_id', Session::get('SITE_ID'))
                            ->where('academic_group_id', $request->academic_group_id)
                            ->get();

                        $fee_fine = 0;
                        if (count($fee_fine_details)){
                            foreach ($fee_fine_details as $kkk => $vvv){
                                $fee_fine+= $vvv->fine_amount;
                            }
                        }

                        $total_fine_amount+= $fee_fine;

                    }
                }


                $std_ids= $student_class_base_history_list = GlobalStudentHistory::where('academic_class_id', $value)
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $request->academic_group_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                   // ->where('academic_class_group_id', 2)
                    ->where('status', 1)
                    ->pluck('id');
                  //  ->get();

                $std_payment_history = GlobalSiteStudentFeePaymentHistory::whereIn('student_history_id',$std_ids )
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $request->academic_group_id)
                    ->get();
                // $std_due_amounts = $std_payment_history->sum('due_amount');
                // dd($std_due_amounts);

                $total_payable_amount = ($total_generate_amount + $total_fine_amount) - $total_waiver_amount;

                $total_due_amount = $total_payable_amount - $total_paid_amount;

                $final_data[$key]['total_generate_amount'] = $total_generate_amount;
                $final_data[$key]['total_paid_amount'] = $total_paid_amount;
                $final_data[$key]['total_waiver_amount'] = $total_waiver_amount;
                $final_data[$key]['total_fine_amount'] = $total_fine_amount;
                $final_data[$key]['total_due_amount'] = $total_due_amount;
                $final_data[$key]['total_payable_amount'] = $total_payable_amount;

                $class_name = AcademicClass::where('id', $value)->first();
                $final_data[$key]['class_name'] = $class_name->class_name;

                $gross_total_generate_amount += $final_data[$key]['total_generate_amount'];
                $gross_total_paid_amount += $final_data[$key]['total_paid_amount'];
                $gross_total_waiver_amount += $final_data[$key]['total_waiver_amount'];
                $gross_total_fine_amount += $final_data[$key]['total_fine_amount'];
                $gross_total_due_amount += $final_data[$key]['total_due_amount'];

           //     dd($final_data);

            }
            $gross_total_payable_amount = ($gross_total_generate_amount + $gross_total_fine_amount) - $gross_total_waiver_amount;

            $gross_report['gross_total_generate_amount'] = $gross_total_generate_amount;
            $gross_report['gross_total_paid_amount'] = $gross_total_paid_amount;
            $gross_report['gross_total_waiver_amount'] = $gross_total_waiver_amount;
            $gross_report['gross_total_fine_amount'] = $gross_total_fine_amount;
            $gross_report['gross_total_due_amount'] = $gross_total_due_amount;
            $gross_report['gross_total_payable_amount'] = $gross_total_payable_amount;



            return [$final_data, $gross_report];

        }

        else if (count($request->academic_class_list) > 0) {

            $gross_total_generate_amount = 0;
            $gross_total_payable_amount = 0;
            $gross_total_paid_amount = 0;
            $gross_total_waiver_amount = 0;
            $gross_total_fine_amount = 0;
            $gross_total_due_amount = 0;

            foreach ($request->academic_class_list as $key => $value) {

                $total_generate_amount = 0;
                $total_paid_amount = 0;
                $total_waiver_amount = 0;
                $total_fine_amount = 0;
                $total_due_amount = 0;

                $student_class_base_history_list = GlobalStudentHistory::where('academic_class_id', $value['id'])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $request->academic_group_id)
                    ->where('status', 1)
                    ->with('stClass')
                    ->get();

                if (count($student_class_base_history_list) > 0) {


                    foreach ($student_class_base_history_list as $ke => $va) {

                        if ($request->start_date && $request->end_date) {
                            $std_payment_history = GlobalSiteStudentFeePaymentHistory::where('student_history_id', $va->id)
                                ->whereBetween('payment_date', [$request->start_date, $request->end_date])
                                ->where('site_id', Session::get('SITE_ID'))
                                ->where('academic_group_id', $request->academic_group_id)
                                ->with('siteStudentFeeDemandSlipDetails')
                                ->get();

                        } else {
                            $std_payment_history = GlobalSiteStudentFeePaymentHistory::where('student_history_id', $va->id)
                                ->where('site_id', Session::get('SITE_ID'))
                                ->where('academic_group_id', $request->academic_group_id)
                                ->with('siteStudentFeeDemandSlipDetails')
                                ->get();
                        }



                        if (count($std_payment_history) > 0) {
                            foreach ($std_payment_history as $kk => $vv) {
                                $total_paid_amount += $vv->paid_amount;
                            }
                        }

                        $demand_slip = GlobalSiteStudentFeeDemandSlipDetails::where('student_history_id',  $va->id)
                                ->where('site_id', Session::get('SITE_ID'))
                                ->where('academic_group_id', $request->academic_group_id)
                                ->get();

                        if (count($demand_slip)>0) {
                            foreach ($demand_slip as $kkk => $vvv){
                                $total_waiver_amount+= $vvv->waiver_amount + $vvv->special_waiver_amount;
                                $total_generate_amount+= $vvv->fee_amount;
                            }


                        }


                        $fee_fine = 0;
                        $fee_fine_details = GlobalSiteStudentFeeFine::where('student_history_id', $va->id)
                                ->where('site_id', Session::get('SITE_ID'))
                                ->where('academic_group_id', $request->academic_group_id)
                                ->get();

                        if (count($fee_fine_details)){
                            foreach ($fee_fine_details as $kkk => $vvv){
                                $fee_fine+= $vvv->fine_amount;
                            }
                        }
                        $total_fine_amount+= $fee_fine;

                    }
                }
                $total_payable_amount = ($total_generate_amount + $total_fine_amount) - $total_waiver_amount;

                $final_data[$key]['total_generate_amount'] = $total_generate_amount;
                $final_data[$key]['total_payable_amount'] = $total_payable_amount;
                $final_data[$key]['total_paid_amount'] = $total_paid_amount;
                $final_data[$key]['total_waiver_amount'] = $total_waiver_amount;
                $final_data[$key]['total_fine_amount'] = $total_fine_amount;
                $final_data[$key]['total_due_amount'] = $total_payable_amount - $total_paid_amount;
                $class_name = AcademicClass::where('id', $value['id'])->first();
                $final_data[$key]['class_name'] = $class_name->class_name;



                $gross_total_generate_amount += $final_data[$key]['total_generate_amount'];
                $gross_total_payable_amount += $final_data[$key]['total_payable_amount'];
                $gross_total_paid_amount += $final_data[$key]['total_paid_amount'];
                $gross_total_waiver_amount += $final_data[$key]['total_waiver_amount'];
                $gross_total_fine_amount += $final_data[$key]['total_fine_amount'];
                $gross_total_due_amount += $final_data[$key]['total_due_amount'];

            }
            $gross_report['gross_total_generate_amount'] = $gross_total_generate_amount;
            $gross_report['gross_total_payable_amount'] = $gross_total_payable_amount;
            $gross_report['gross_total_paid_amount'] = $gross_total_paid_amount;
            $gross_report['gross_total_waiver_amount'] = $gross_total_waiver_amount;
            $gross_report['gross_total_fine_amount'] = $gross_total_fine_amount;
            $gross_report['gross_total_due_amount'] = $gross_total_due_amount;

             return [$final_data, $gross_report];
        }

        else {
            throw new Error('student not found');
        }


    }

    public function pdfStudentWisePaymentReport(Request $request)
    {


        \Log::info($request);
        return $request;

        $pdf = PDF::loadView('default.admin.site.student-fee.report.student-wise-payment-pdf', compact('data'));
        return $pdf->stream(time() . '-student-payment.pdf');
    }

    public function showIndividualStudentPaymentSummaryReportPdf($user_name, $year_id = null)
    {
        $academic_year_id = $year_id;

        if ($user_name) {
            $userList = Student::where('username', $user_name)->select('id')->first();
            if ($userList) {


                if($academic_year_id){
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
                        ->where('user_id', $userList->id)
                        ->where('academic_year_id',$academic_year_id)
                        ->orderBy('id','desc')
                        ->first();

                }else{
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
                        ->where('user_id', $userList->id)
                        ->where('status', 1)
                        ->first();
                }

            } else {
                throw new Error('Sorry! Student not found');
            }

            $payment_slip_details = SiteStudentFeePaymentHistory::where('student_history_id', $studentHistoryList->id)->with('user')->get();
            $dataArr = [];
            $total_paid_amount = 0;
            if(count($payment_slip_details)>0){
                foreach ($payment_slip_details as $key => $value){
                    $dataArr[$key]['id'] = $value->id;
                    $dataArr[$key]['voucher_no'] = $value->voucher_no;
                    $dataArr[$key]['payment_date'] = $value->payment_date;
                    $dataArr[$key]['created_by'] = $value->user->full_name ?? "";
                    $dataArr[$key]['paid_amount'] = $value->paid_amount;

                    $total_paid_amount+=$value->paid_amount;
                }
            }else{
                throw new Error('Sorry! payment not taken at yet');
            }
            $stdDetailsArray['std_id'] = $studentHistoryList->id;
            $stdDetailsArray['std_name'] = $studentHistoryList->student ? $studentHistoryList->student->full_name : "";
            $stdDetailsArray['department_name'] = $studentHistoryList->department ? $studentHistoryList->department->class_name : "";
            $stdDetailsArray['class_name'] = $studentHistoryList->stClass->class_name;
            $stdDetailsArray['group_name'] = $studentHistoryList->accGroup ? $studentHistoryList->accGroup->group_name : "";
            $stdDetailsArray['section_name'] = $studentHistoryList->section ? $studentHistoryList->section->section_name : "";

//            return [$dataArr, $stdDetailsArray, $total_paid_amount];
            $title_view = 'Student Payment Summary';
            $report_tittle = '<b>Student Payment Summary Report</b><br>';
            $report_tittle2  = '';



            $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-summary-report-pdf', compact('title_view','report_tittle','report_tittle2','dataArr','stdDetailsArray','total_paid_amount'));
            return $pdf->stream(time() . '-student-payment-summary.pdf');

        }else{
            throw new Error('Sorry! Please write student ID');
        }


    }

    public function createClassBasePaymentReportPdf(Request $request)
    {
//        return $request;
        $site_id = (int)session()->get('SITE_ID');
        $site = SiteInfo::where('id', $site_id)->first();
//        return $site_id;

        $class_details = AcademicClass::where('id', $request->academic_class_id)->select('class_name')->first();
        $class_group_details = AcademicClassGroup::where('id', $request->academic_class_group_id)->select('group_name')->first();
        $class_section_details = AcademicSection::where('id', $request->academic_section_id)->select('section_name')->first();
        $class_shift_details = AcademicShift::where('id', $request->academic_shift_id)->first();
        $from_date = $request->start_date;
        $to_date = $request->end_date;

        $title_view = 'Class Wise report';

        $all_student_total_payment_list = $request->allStudentTotalPaymentHistoryList;

        $all_std_total_paid_amount = $request->allStudentTotalPaidAmount;
        $all_student_total_paid_amount = number_format($all_std_total_paid_amount);

        $all_std_total_due_amount = $request->allStudentTotalDueAmount;
        $all_student_total_due_amount = number_format($all_std_total_due_amount);

        $all_std_total_generate_amount = $request->allStudentTotalGenerateAmount;
        $all_std_total_generate_amount = number_format($all_std_total_generate_amount);

        $all_std_total_payable_amount = $request->allStudentTotalPayableAmount;
        $all_student_total_payable_amount = number_format($all_std_total_payable_amount);

        $all_std_total_waiver_amount = $request->allStudentTotalWaiverAmount;
        $all_student_total_waiver_amount = number_format($all_std_total_waiver_amount);

        $all_std_total_fee_fine_amount = $request->allStudentTotalFeeFineAmount;
        $all_std_total_fee_fine_amount = number_format($all_std_total_fee_fine_amount);

        $gross_total_due_paid_amount = $request->gross_total_due_paid_amount;
        $gross_total_due_paid_amount = number_format($gross_total_due_paid_amount);

        $report_tittle = '<b>Class Wise Payment Report</b><br>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-class-wise-report-pdf', compact('title_view','class_details', 'class_group_details', 'class_section_details',
            'class_shift_details', 'report_tittle','report_tittle2', 'from_date', 'to_date', 'all_student_total_payment_list','all_student_total_paid_amount',
            'all_student_total_due_amount','all_student_total_payable_amount','all_student_total_waiver_amount','all_std_total_fee_fine_amount','all_std_total_generate_amount','site','gross_total_due_paid_amount'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);
//        return $class_shift_details->shift_name;

    }

    public function classBasePaymentPdfShow($data)
    {
//        return $data;

        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }


            if (!file_exists(storage_path('pdf/' . $data))) {

                return "The file existed only for 1 day and deleted today!";

            }

            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function createGeneralPaymentReportPdf(Request $request)
    {
//        return $request;

        $site_id = (int)session()->get('SITE_ID');
        $site = SiteInfo::where('id', $site_id)->first();

        $class_shift_details = AcademicShift::where('id', $request->academic_shift_id)->first();
        $from_date = $request->start_date;
        $to_date = $request->end_date;

        $title_view = 'General report';

        $all_class_total_payment_list = $request->allClassTotalPaymentList;
        $total_paid_amnt = $request->totalPaidAmount;
        $total_paid_amount = number_format($total_paid_amnt);

        $total_due_amnt = $request->totalDueAmount;
        $total_due_amount = number_format($total_due_amnt);

        $total_generate_amnt = $request->totalGenerateAmount;
        $total_generate_amount = number_format($total_generate_amnt);

        $total_payable_amnt = $request->totalPayableAmount;
        $total_payable_amount = number_format($total_payable_amnt);

        $total_waiver_amnt = $request->totalWaiverAmount;
        $total_waiver_amount = number_format($total_waiver_amnt);

        $total_fee_fine_amnt = $request->totalFeeFine;
        $total_fee_fine_amnt = number_format($total_fee_fine_amnt);

        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $report_tittle = '<b>General Fee Report</b>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.general-payment-report-pdf', compact('title_view',
            'report_tittle2','report_tittle','print_date','class_shift_details', 'from_date', 'to_date', 'all_class_total_payment_list','total_paid_amount',
            'total_due_amount','total_payable_amount','total_waiver_amount','total_fee_fine_amnt','total_generate_amount','site'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');

        $name = $time . '.pdf';



        return Response::json(['message' => $name], 200);

    }

    public function showGeneralReportPdf($data)
    {
       // return $data;
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            // if ($name_split[0] != $user_id) {
            //     return 'You are unauthorized!';
            // }


            // if (!file_exists(storage_path('pdf/' . $data))) {

            //     return "The file existed only for 1 day and deleted today!";

            // }


            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function createIndividualPaymentReportPdf(Request $request)
    {
//return $request;
        $title_view = 'Individual report';
        $std_fee_list =  $request->single_student_fee_list;
        $std_fee_waiver_list =  $request->waiver_allocation_details;

        $total_fee_amount = $request->total_fee_amount;
        $total_waiver_amount = number_format($request->total_waiver_amount);

//dd($std_fee_waiver_list, $total_fee_amount, $total_waiver_amount);
        $fee_head = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();

        $std_details = $request->student_details;

        $report_tittle = '<b>Student Wise Payment Report</b><br>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-student-wise-report-pdf',
            compact('title_view','report_tittle','report_tittle2','std_fee_list',
                'fee_head','std_details','std_fee_waiver_list','total_fee_amount','total_waiver_amount'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();

        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');

        $name = $time . '.pdf';
        return Response::json(['message' => $name], 200);

    }

    public function showIndividualPaymentReportPdf($data)
    {
//        return $data;
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }


            if (!file_exists(storage_path('pdf/' . $data))) {

                return "The file existed only for 1 day and deleted today!";

            }


            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
