<?php

namespace App\Http\Controllers\Site\Option;

use App\Models\Edu\SitePayment\SitePayment;
use App\Models\Edu\SMS\SmsFollowUp;
use App\Models\Site\Employee\Employee;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteMembership;
use App\Models\Student\StudentHistory;
use App\Traits\Site\SiteInfoTrait;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicPermissionType;
use App\Models\Site\Employee\SiteEmployeeOtherPermission;
use App\Models\Site\SiteInfoSetting;
use App\Models\User\UserMessage;
use Illuminate\Support\Facades\Session as FacadesSession;
use Illuminate\Validation\ValidationException;
use Response;
use Session;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Zend\Diactoros\Response\JsonResponse;

class SiteOptionController extends Controller
{
    use SiteInfoTrait;


    private $siteInfo;
    private $siteMembership;

    public function __construct(SiteInfo $siteInfo, SiteMembership $siteMembership)
    {
        $this->middleware('auth');
      //  $this->middleware('sitepagechecker');

        $this->siteInfo = $siteInfo;
        $this->siteMembership = $siteMembership;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
//        $fdg = "2021-04-21";
//        $createTime = date('Y-m-d H:i:s', strtotime($fdg));
//        return $createTime;

        $viewType = 'Options View and change';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.options.view', compact('viewType'));
    }


    public function getSiteOptions()
    {
        $site_id = Session::get('SITE_ID');

        $site_info = $this->siteInfo->where('id', $site_id)
            ->select([
                'id', 'site_alias', 'site_logo', 'site_name_native_language', 'site_alias', 'emp_categorie_ids', 'site_phone', 'site_email',
                'status', 'emp_in_sms', 'emp_out_sms', 'google_map_address','std_fee_paid_sms','web_student_fee_collection_status','student_fee_collection_status',
                'admission_fee_collection_status','admission_fee_paid_sms','website_result_show_by_username','show_subhead_in_payment_slip'
            ])
            ->first();

        $site_membership = $this->siteMembership->where('site_id', $site_id)
            ->with('package')
            ->select([
                'id', 'sms_balance', 'edu_package_id', 'payment_type', 'payment_installment', 'per_sms_cost', 'sms_send_type',
                'payment_amount', 'discount_type', 'discount', 'sms_bearer', 'billing_start_date', 'sms_send_company'
            ])
            ->first();


        $total_student = StudentHistory::
        where('status', 1)
            ->whereHas('student')
            ->count();

        $total_employee = Employee::where('user_type', 'employee')->where('status', true)->count();
        $last_payment = SitePayment::where('status_code', 'Approved')->latest()->first()->paid_amount ?? 0;

        return response()->json([$site_info, $site_membership, $total_student, $total_employee, $last_payment], 200, []);
    }

    public function update(Request $request)
    {
        try {
            $this->validate($request, [
                'site_email' => 'email'
            ]);


            $site_id = Session::get('SITE_ID');

            $site_info = $this->siteInfo->where('id', $site_id)->first();
            $site_info->site_name = $request->site_name;
            $site_info->short_name = $request->short_name;
            $site_info->site_name_native_language = $request->site_name_native_language;
            $site_info->address = $request->address;
            $site_info->site_email = $request->site_email;
            $site_info->site_phone = $request->site_phone;
            $site_info->emp_in_sms = $request->emp_in_sms;
            $site_info->emp_out_sms = $request->emp_out_sms;
            $site_info->emp_out_sms = $request->emp_out_sms;
            $site_info->google_map_address = $request->google_map_address;
            $site_info->std_fee_paid_sms = $request->std_fee_paid_sms;
            $site_info->web_student_fee_collection_status = $request->web_student_fee_collection_status;
            $site_info->student_fee_collection_status = $request->student_fee_collection_status;
            $site_info->admission_fee_collection_status = $request->admission_fee_collection_status;
            $site_info->admission_fee_paid_sms = $request->admission_fee_paid_sms;
            $site_info->website_result_show_by_username = $request->website_result_show_by_username;
            $site_info->show_subhead_in_payment_slip = $request->show_subhead_in_payment_slip;
            $site_info = $this->siteLogo($request, $site_info);
            $site_info->save();

            return Response::json(['message' => 'Updated Successfully'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function delete($id)
    {
        $the_role = $this->batch->findOrFail($id);
        $the_role->delete();
        return Response::json(['message' => 'Deleted Successfully', 'mode' => 'Updated!'], 200);
    }


    //CUSTOM METHOD---------------------------------

    public function getBatches(Request $request)
    {

        try {
            $batchDetails = [];

            return response()->json([$batchDetails], 200, []);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);


        }


    }

    public function getSiteSmsFollowUpData(Request $request)
    {

        $s_date = $request->s_date;
        $e_date = $request->e_date;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;

        $txt = '%' . $search_txt . '%';

        $data = SmsFollowUp::
        when($search_txt, function ($q) use ($txt) {
            $q->where('msg_numbers', 'LIKE', $txt);
        })
            ->whereDate('created_at', '>=', $s_date)
            ->whereDate('created_at', '<=', $e_date)
            ->where('institution_type', 'site')
            ->where('institution_id', Session::get('SITE_ID'))
            ->orderBy('id', 'DESC')
            ->select('id', 'msg_txt', 'sent_masking', 'msg_numbers', 'sent_status', 'res_msg_id', 'res_status', 'res_sms_count', 'edu_charged_from_client', 'returned_charges', 'created_at')
            ->paginate($paginate);


        if (count($data) < 1) {
            throw new Error('No SMS Log Data Found');
        }
        return response()->json($data, 200, []);

    }

    public function getUserMessageListUpData(Request $request)
    {
  
        $s_date = $request->s_date;
        $e_date = $request->e_date;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;

        $txt = '%' . $search_txt . '%';

        $data = UserMessage::with('user')
            ->whereDate('created_at', '>=', $s_date)
            ->whereDate('created_at', '<=', $e_date)
            ->where('message_type_key', 'message')
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        if (count($data) < 1) {
            throw new Error('No SMS Log Data Found');
        }
        return response()->json($data, 200, []);

    }

    public function getEmployeePermissionOption()
    {

        $employees = Employee::with('siteRoles')
            ->with(['latestPhoto'])
            ->with(['designation'])
            ->select('id', 'username', 'user_type', 'email', 'contact_number', 'status', 'finger_taken', 'attendance_sms', 'designation_id', 'signature', 'institute_head')
            ->where('status', true)
            ->orderBy('employee_serial', 'DESC')
            ->get();

    $academic_class_ids_array=SiteInfoSetting::where('site_id',Session::get('SITE_ID'))
        ->where('status',true)
        ->whereHas('academicGroup')
        ->select('academic_group_id', 'academic_class_ids')
        ->groupBy('academic_group_id')
        ->get();
      //  dd($academic_class_ids_array);
    
        $academic_class_array = [];

        foreach ($academic_class_ids_array as $key=>$item) {
            $academic_gorup=AcademicGroup::where('id',explode(',',$item->academic_group_id))
                ->select('id','academic_group_name','serial')
                ->first();

            $academic_class_list=AcademicClass::whereIn('id',explode(',',$item->academic_class_ids))
                ->select('id','class_name','serial_no')
                ->get();
        
            $academic_class_array[$key]['select_academic_group_id']=false;
            $academic_class_array[$key]['academic_group_name']=$academic_gorup->academic_group_name;
            $academic_class_array[$key]['academic_group_id']=$academic_gorup->id;

            $class_array=[];
            foreach($academic_class_list as $keys=>$class){
                $class_array[$keys]['select_academic_class_id']=false;
                $class_array[$keys]['academic_class_id']=$class->id;
                $class_array[$keys]['academic_class_name']=$class->class_name;
            }

            $academic_class_array[$key]['academic_classes']=$class_array;
            
        }

       // dd($academic_class_list);
    
        $permission_type_list=AcademicPermissionType::where('status',true)->get();


        // employee permission list

        $permission_list=SiteEmployeeOtherPermission::with(['employee'=>function($q){
            $q->with('designation');
        },'academicGroup'])->get();

        // site information

        $site_info=SiteInfo::where('id',Session::get('SITE_ID'))->select('id','all_admin_fee_collection_status')->first();

        return response()->json(
            [
                'employee_list'=>$employees,
                'data_list'=>$academic_class_array,
                'permission_type_list'=>$permission_type_list,
                'permission_list'=>$permission_list,
                'site_info'=>$site_info,
            ], 200);
    }


    public function getEmployeePermissionData($user_id){


        $academic_class_ids_array=SiteInfoSetting::where('site_id',Session::get('SITE_ID'))
            ->where('status',true)
            ->whereHas('academicGroup')
            ->select('academic_group_id', 'academic_class_ids')
            ->groupBy('academic_group_id')
            ->get();

            $academic_class_array = [];

            foreach ($academic_class_ids_array as $key=>$item) {
                $academic_gorup=AcademicGroup::where('id',explode(',',$item->academic_group_id))
                    ->select('id','academic_group_name','serial')
                    ->first();
    
                $academic_class_list=AcademicClass::whereIn('id',explode(',',$item->academic_class_ids))
                    ->select('id','class_name','serial_no')
                    ->get();
                    
                $permission_item=SiteEmployeeOtherPermission::where('user_id',$user_id)->where('academic_group_id',$item->academic_group_id)->first();

               // $permission_list->where('academic_group_id',$item->academic_group_id)->first();
                
                if($permission_item){
                    $academic_class_array[$key]['select_academic_group_id']=true;
                }else{
                    $academic_class_array[$key]['select_academic_group_id']=false;
                }
            
                $academic_class_array[$key]['academic_group_name']=$academic_gorup->academic_group_name;
                $academic_class_array[$key]['academic_group_id']=$academic_gorup->id;
                
                $class_array=[];
            
                foreach($academic_class_list as $keys=>$class){
                    if($permission_item){
                        $class_arrays=$permission_item->fee_permission_class_ids[1];
                       
                       
                        foreach($class_arrays as $class_id){
                            if($class_id==$class->id){
                                if($class_id){
                                    $class_array[$keys]['select_academic_class_id']=true;
                                }else{
                                    $class_array[$keys]['select_academic_class_id']=false;
                                }
                            }
                            // else{
                            //     $class_array[$keys]['select_academic_class_id']=false;
                            // }
                        
                        }
                    }else{
                        $class_array[$keys]['select_academic_class_id']=false;
                    }
                    
                    $class_array[$keys]['academic_class_id']=$class->id;
                    $class_array[$keys]['academic_class_name']=$class->class_name;
                }
    
                $academic_class_array[$key]['academic_classes']=$class_array;
                
            }

            return $academic_class_array;

          //  dd($permission_list);

    }


    public function saveEmployeePermissionOption(Request $request){


        $site_info=SiteInfo::where('id',Session::get('SITE_ID'))->first();

      //  dd($site_info);
        $site_info->all_admin_fee_collection_status=$request->all_admin_fee_collection_status;
        $site_info->save();
       if($request->user_id){
        
        foreach($request->data_list as $item){
            if($item['select_academic_group_id']){
                $chekc_data=SiteEmployeeOtherPermission::where('user_id',$request->user_id)
                    ->where('academic_group_id',$item['academic_group_id'])
                    ->first();

                if($request->all_admin_fee_collection_status==false){
                    $class_id_array=[];
                 
                    foreach($item['academic_classes'] as $key=>$class_item){
                        if(isset($class_item['select_academic_class_id'])){
                            if($class_item['select_academic_class_id']){
                                $class_id_array[$key]=$class_item['academic_class_id'];
                            }
                        }
                    }
                   
                    $fee_permission_class_ids=implode(',',$class_id_array);
                   
                }

                if($chekc_data){

                    if(!$request->all_admin_fee_collection_status){
                      //  dd($chekc_data);
                        $chekc_data->fee_permission_class_ids=$fee_permission_class_ids;
                    }

                    $chekc_data->save();

                }else{
                    $emp_perm=new SiteEmployeeOtherPermission;
                    $emp_perm->user_id=$request->user_id;
                    $emp_perm->academic_group_id=$item['academic_group_id'];

                    if($request->all_admin_fee_collection_status==false){
                        $emp_perm->fee_permission_class_ids=$fee_permission_class_ids;
                    }

                    $emp_perm->save();
                }
            }else{
                $chekc_data=SiteEmployeeOtherPermission::where('user_id',$request->user_id)
                    ->where('academic_group_id',$item['academic_group_id'])
                    ->first();
                    if($chekc_data){
                        $chekc_data->delete();
                    }
                   
            }
        }
    }
        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);

    }

    public function deleteEmployeePermissionOption(Request $request){
        SiteEmployeeOtherPermission::findOrFail($request->id)->delete();
      
       return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);

    }

    public function getGeoLocationQrCodeGenerate(){

        $domain=request()->root();
        $url_param='/site/employee/attendance/employee-attendance-by-qrcode';
        $full_url=$domain.$url_param;
        $logo='http://eduworld.localhost:8000/image/edu.png';
      //  dd($full_url);

        $data = request('data', $full_url); // Data from query parameter
        $qrcode=QrCode::size(500)->format('svg')->generate($data);
        
        $fileName = 'qr-code.svg';

        return response($qrcode, 200, [
            'Content-Type' => 'image/svg+xml',
            'Content-Disposition' => "attachment; filename=\"{$fileName}\"",
        ]);
    }

    public function getGeoLocationQrCodeDownload(){

        dd(Session::all());
        $data = request('data', ''); // Get data from query parameters
    
        // Generate the QR code in JPG format
        $qrCodeImage = QrCode::format('eps') // Use PNG first as JPG requires conversion
            ->size(300)
            ->generate($data);

            dd($qrCodeImage);

        // Define the filename
        $fileName = 'qr-code.jpg';

        // Save the PNG QR code as a temporary file
        $tempPngPath = storage_path('qr-code.png');
        file_put_contents($tempPngPath, $qrCodeImage);

        // Convert the PNG to JPG using Imagick
        $imagick = new Imagick($tempPngPath);
        $imagick->setImageFormat('jpeg'); // Convert PNG to JPG
        $tempJpgPath = storage_path($fileName);
        $imagick->writeImage($tempJpgPath);

        // Clean up the temporary PNG file
        unlink($tempPngPath);

        // Return the JPG file as a downloadable response
        return response()->download($tempJpgPath)->deleteFileAfterSend(true);
    }
//
}
