<?php

namespace App\Http\Controllers\Site\Payment;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicOnlinePaymentMarchentType;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicPaymentType;
use App\Models\Edu\PaymentGateway\EduPaymentGateway;
use App\Models\Edu\SitePayment\SiteInvoice;
use App\Models\Site\Payment\PaymentGateway;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicFeeType;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Payment\SitePaymentGateway;
use Carbon\Carbon;
use Auth;
use Illuminate\Support\Facades\Storage;
use Session;
use Response;
use File;
use Error;

class PaymentGatewayController extends Controller
{
    use PaymentGatewayTrait;

    private $paymentGateway;
    private $academicPaymentType;
    private $academicOnlinePaymentMethod;
    private $academicOnlinePaymentMarchentType;
    private $invoice;


    public function __construct(SitePaymentGateway $paymentGateway,
                                AcademicPaymentType $academicPaymentType,
                                AcademicOnlinePaymentMethod $academicOnlinePaymentMethod,
                                AcademicOnlinePaymentMarchentType $academicOnlinePaymentMarchentType,
                                SiteInvoice $invoice)
    {
        $this->middleware('auth');
        //$this->middleware('eduworlduserchecker');
         $this->middleware('sitepagechecker');
        $this->paymentGateway = $paymentGateway;
        $this->academicPaymentType = $academicPaymentType;
        $this->academicOnlinePaymentMethod = $academicOnlinePaymentMethod;
        $this->academicOnlinePaymentMarchentType = $academicOnlinePaymentMarchentType;
        $this->invoice = $invoice;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ="Payment Gateway";
        return view('default.admin.layouts.master',compact('viewType'));
    }
    public function eduPaymentMethodList()
    {
        $payment_method_keys = EduPaymentGateway::pluck('academic_payment_method_key');
        $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)->get();
        return $payment_method_list;
    }

    public function bkashPaymentPage($invoice_no = null, $total_amount = null)
    {
//        return 'ok';
        $viewType = 'Site Payment';

        return view('default.admin.site.site-payment.site-bkash-payment', compact('viewType', 'invoice_no', 'total_amount'));



//        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function sonaliPaymentPage($invoice_no = null, $total_amount = null)
    {

        $viewType = 'Site Payment';

        return view('default.admin.site.site-payment.site-bkash-payment', compact('viewType', 'invoice_no', 'total_amount'));
    }

    public function getPaymentGatewayList()
    {
        $payment_gateway_list =  $this->paymentGateway->where('status', 1)->get();
        return $payment_gateway_list;
    }

    public function getPaymentGatewayPaymentTypeList()
    {
        $payment_type_list =  $this->academicPaymentType->get();
        return $payment_type_list;
    }

    public function getPaymentGatewayPaymentMethodList($payment_type_key)
    {
        $payment_method_list =  $this->academicOnlinePaymentMethod->where('payment_type_key', $payment_type_key)->get();
        return $payment_method_list;
    }

    public function getPaymentGatewayPaymentMarchentTypeList($payment_marchent_key)
    {
//        return 'ok';
        $payment_method =  $this->academicOnlinePaymentMethod->where('name_key', $payment_marchent_key)->first();
        if($payment_marchent_key=='cellfin'){
            $academicFeeType=[];
           // $academicFeeType=AcademicFeeType::where('status',true)->get();
            $payment_marchent_list =  [];
        }else{
            $payment_marchent_list =  $this->academicOnlinePaymentMarchentType->where('academic_online_payment_method_id', $payment_method->id)->get();
            $academicFeeType=[];
        }
        return [$payment_marchent_list, $academicFeeType];
    }

    public function getPaymentGatewayListWithPagination(Request $request)
    {
        $paginate = $request->paginate ?? 15;
        $search_txt = $request->search_txt;
        $search_with_payment_type = $request->search_with_payment_type;
        $search_with_payment_method = $request->search_with_payment_method;
        $search_with_payment_marchent_type_id = $request->search_with_payment_marchent_type_id;
//        return $search_with_payment_type;

        $txt = '%' . $search_txt . '%';


        $payment_gateway_list =  SitePaymentGateway::when($search_with_payment_type, function ($q) use($search_with_payment_type){
                $q->where('academic_payment_type_key', $search_with_payment_type);
            })
            ->when($search_with_payment_method, function ($q) use($search_with_payment_method){
                $q->where('academic_payment_method_key', $search_with_payment_method);

            })
            ->when($search_with_payment_marchent_type_id, function ($qr) use($search_with_payment_marchent_type_id){
                $qr->where('academic_online_payment_marchent_type_id', $search_with_payment_marchent_type_id);

            })
            ->when($search_txt, function ($q) use($txt){
                $q->where('user_name', 'LIKE', $txt)
                    ->orWhere('password', 'LIKE', $txt)
                    ->orWhere('transaction_code', 'LIKE', $txt);

            })
            ->with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType','academicFeeType'])
            ->paginate($paginate);

        $data_for_dropdown = SitePaymentGateway::get();
        $payment_method_keys = $data_for_dropdown->pluck('academic_payment_method_key');
        $payment_type_head_keys = $data_for_dropdown->pluck('academic_payment_type_key');
        $payment_marcent_type_ids = $data_for_dropdown->pluck('academic_online_payment_marchent_type_id');

        $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)->get();

        $payment_type_list = AcademicPaymentType::whereIn('name_key', $payment_type_head_keys)->get();

        $payment_marchent_type_list = AcademicOnlinePaymentMarchentType::whereIn('id', $payment_marcent_type_ids)->get();

        return [$payment_gateway_list, $payment_type_list, $payment_method_list, $payment_marchent_type_list] ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, SitePaymentGateway $paymentGateway)
    {
        $user_id=Auth::user()->id;
        $username=Auth::user()->username;
        $site_id=Session::get('SITE_ID');

        if($username!='rayhan'){
             return Response::json(['message' => 'Permission denied', 'mode' => 'Error!'], 411);
        }

        // $institute_head = Employee::where('id', $user_id)->where('institute_head', 1)->first();
        // if(!$institute_head){
        //     return Response::json(['message' => 'Permission denied. Only the institute head has access.', 'mode' => 'Error!'], 411);
        // }
        //==============validation=============
        if($request->academic_payment_method_key == 'nagad'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'nagad'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'non-marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "authorization" => "required",
                "api_link" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'bkash'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "create_url" => "required",
                "execute_url" => "required",
                "token_url" => "required",
                "script" => "required",
                "app_key" => "required",
                "app_secret" => "required",

            ]);
        }else if($request->academic_payment_method_key == 'cellfin'){
            $this->validate($request, [
                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
            //    "academic_fee_type_id" => "required",
                "iid" => "required",

            ]);

          $gateway= GlobalSitePaymentGateway::where('iid',$request->iid)->first();
          
          if($gateway){
            return Response::json(['message' => 'This IID Already Added', 'mode' => 'Error!'], 411);
          }

        }else if($request->academic_payment_method_key=='sonali_pay'){
            $this->validate($request, [
                "user_name" => "required",
                "partner_number" => "required",
            ]);
        }
        else if($request->academic_payment_method_key=='ncc_always'){
            $this->validate($request, [
                "user_name" => "required",
                "partner_number" => "required",
            ]);
        }else{
            return Response::json(['message' => 'You do not have permission for this payment type.', 'mode' => 'Error!'], 411);
        }

     
        if (count($paymentGateway->ownFields) > 0) {
            
            foreach ($paymentGateway->ownFields as $field) {
               
                if ($request->{$field}) {
                    $paymentGateway->{$field} = $request->{$field};
                }
            }
            $paymentGateway->created_by = Auth::user()->id;
            $paymentGateway->created_date = Carbon::today();

            if($paymentGateway->save()){
               
                $add_sett='';
                $add_sett.=$paymentGateway->academic_payment_type_key?'academic_payment_type_key:'.$request->academic_payment_type_key.', ':'';
                $add_sett.=$paymentGateway->academic_payment_method_key?'academic_payment_method_key:'.$request->academic_payment_method_key.', ':'';
                $add_sett.=$paymentGateway->user_name?'user_name:'.$request->user_name.', ':'';
                $add_sett.=$paymentGateway->password?'password,(hide)':'';
                $add_sett.=$paymentGateway->partner_number?'partner_number:'.$request->partner_number.', ':'';
                $add_sett.=$paymentGateway->partner_code?'partner_code:'.$request->partner_code.', ':'';
                $add_sett.=$paymentGateway->iid?'iid:'.$request->iid.', ':'';
        
                $issue = new IssueDetail();
                $issue->issue_type='payment-gateway-setting';
                $issue->issuer_type='site';
                $issue->issue_details='Added:- '.$add_sett;
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();
            }
        }

        return Response::json(['message' => 'Payment Gateway Successfully Saved!', 'mode' => 'Saved!'], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request->academic_online_payment_marchent_type_id['id'];
        $user_id=Auth::user()->id;
        $username=Auth::user()->username;
        $site_id=Session::get('SITE_ID');

        if($username!='rayhan'){
            return Response::json(['message' => 'Permission denied', 'mode' => 'Error!'], 411);
       }

        // $institute_head = Employee::where('id', $user_id)->where('institute_head', 1)->first();
        // if(!$institute_head){
        //     return Response::json(['message' => 'Permission denied. Only the institute head has access.', 'mode' => 'Error!'], 411);
        // }

        //==============validation=============
        if($request->academic_payment_method_key == 'nagad'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'nagad'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'non-marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "authorization" => "required",
                "api_link" => "required",


            ]);
        } else if($request->academic_payment_method_key == 'bkash'
            && $request->academic_online_payment_marchent_type_id
            && $request->academic_online_payment_marchent_type_id['name_key'] == 'marchent'){
            $this->validate($request, [

                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
                "academic_online_payment_marchent_type_id" => "required",
                "user_name" => "required",
                "password" => "required",
                "partner_code" => "required",
                "partner_number" => "required",
                "create_url" => "required",
                "execute_url" => "required",
                "token_url" => "required",
                "script" => "required",
                "app_key" => "required",
                "app_secret" => "required",

            ]);
        
        } else if($request->academic_payment_method_key=='cellfin'){
            $this->validate($request, [
                "academic_payment_type_key" => "required",
                "academic_payment_method_key" => "required",
              //  "academic_fee_type_id" => "required",
                "iid" => "required",
            ]);
        }else if($request->academic_payment_method_key=='sonali_pay'){
            $this->validate($request, [
                "user_name" => "required",
                "partner_number" => "required",
            ]);
        }else{
            return Response::json(['message' => 'You do not have permission for this payment type.', 'mode' => 'Error!'], 411);
        }

        $paymentGateway = SitePaymentGateway::findOrFail($request->id);

   
        $change_sett='';
        $change_sett.=$paymentGateway->academic_payment_type_key!=$request->academic_payment_type_key?'academic_payment_type_key:'.$request->academic_payment_type_key.', ':'';
        $change_sett.=$paymentGateway->academic_payment_method_key!=$request->academic_payment_method_key?'academic_payment_method_key:'.$request->academic_payment_method_key.', ':'';
        $change_sett.=$paymentGateway->user_name!=$request->user_name?'user_name:'.$request->user_name.', ':'';
        $change_sett.=$paymentGateway->password!=$request->password?'password,(hide)':'';
        $change_sett.=$paymentGateway->partner_number!=$request->partner_number?'partner_number:'.$request->partner_number.', ':'';
        $change_sett.=$paymentGateway->partner_code!=$request->partner_code?'partner_code:'.$request->partner_code.', ':'';
        $change_sett.=$paymentGateway->iid!=$request->iid?'iid:'.$request->iid.', ':'';

        if (count($paymentGateway->ownFields) > 0) {
            foreach ($paymentGateway->ownFields as $field) {
                if ($request->{$field}) {
                    $paymentGateway->{$field} = $request->{$field};
                }
            }
            $paymentGateway->created_by = Auth::user()->id;
            $paymentGateway->created_date = Carbon::today();
            $paymentGateway->status = $request->status;
            
            if($paymentGateway->save() && $change_sett!=''){
                $issue = new IssueDetail();
                $issue->issue_type='payment-gateway-setting';
                $issue->issuer_type='site';
                $issue->issue_details='Changes:- '.$change_sett;
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();
            }
        }
        return Response::json(['message' => 'Payment Gateway Successfully Updated!', 'mode' => 'Updated!'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        return Response::json(['message' => 'You have not permission!', 'mode' => 'Error!'], 411);
        // $paymentGateway = SitePaymentGateway::where('id',$id)->delete();
        // return Response::json(['message' => 'Payment Gateway Successfully Deleted!', 'mode' => 'Deleted!'], 200);
    }

    //=====================================bkash transaction for site========================================

    public function getToken(){
//        return 'ok';
        $token = $this->token();

        return $token;
    }

    public function createBkashPayment(){
        $create_payment = $this->createPayment();
        return $create_payment;
    }

    public function executeBakashPayment(Request $request){
        $execute_payment = $this->executePayment($request);
        return $execute_payment;
    }
}
