<?php

namespace App\Http\Controllers\Site\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Carbon;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;

use Auth;
use Response;
use DB;
use Exception;
use Illuminate\Validation\Rules\Unique;
use Session;


class QuizRoomController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }


    public function getActiveQuizList(Request $request){

      try{
        $current_date = Carbon::now()->format('Y-m-d');

        $active_quiz_list = QuizDeclares::with(['quizDeclareSettings'=>function($qq){
            $qq->select('quiz_declare_id','start_date_time','end_date_time','is_cancel','is_end','is_start','question_per_student','duration');
        },'quiz'=>function($q){
            $q->select('id','quiz_name');
        },'quizDeclareStudents'])
       //->where('declare_key','site')
        ->withCount('quizDeclareStudents')
        ->withCount('presentStudent')
        ->paginate($request->paginate);

          return response()->json($active_quiz_list);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    


    public function getQuizEventStudentsInfo(Request $request){
       try{
        $activeQuizInfo = QuizDeclares::with(['quiz','quizDeclareSettings'])
                        ->withCount('quizDeclareStudents')
                        ->where('id', $request->quiz_declared_id)
                        ->first();

                    $total_question_count = count($activeQuizInfo->question_ids);
                    $activeQuizInfo->setAttribute('total_question_count', $total_question_count);


            return response()->json($activeQuizInfo);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
            
    }

    public function getPreSentStudents(Request $request){

     try{
       $present_student_count = QuizDeclareStudents::where('quiz_declare_id', $request->quiz_declared_id)
                        ->where('join_status',1)
                        ->count();
         return response()->json($present_student_count);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function quizStartByAdmin(Request $request){
        try{
        $active_quiz = QuizDeclareSettings::where('id', $request->quiz_declared_id)
                    ->update([
                        'is_start'=>1,
                      
                    ]);
            if($active_quiz){
                return response()->json(['message'=>'Quiz Start Succefully', 'mode'=>'success'],200);
            }
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

     
}
