<?php

namespace App\Http\Controllers\Site\Quiz\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;

class SiteQuizReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    public function index()
    {
        $viewType = "Quiz";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function quizListForReport()
    {
    $quizDeclareList=QuizDeclareSettings::with(['quizDeclare'=>function($query){
                $query->with('quiz');
            }])
            ->whereHas('quizDeclare')
            ->where('is_start',1)
           // ->where('is_end',1)
            ->get();
        return response()->json(['quiz_list'=>$quizDeclareList]);
    }

    public function getSiteQuizReport(Request $request)
    {
        $data= $request->all();

        $data = [];
        $data['quiz_declare_id'] = $request->quiz_declare_id;
        $data['student_limit'] = $request->student_limit;
        $data['form_marks'] = $request->form_marks;
        $data['to_marks'] = $request->to_marks;


        $this->validate($request, [
            'quiz_declare_id' => 'required',
        ]);
       
        $quizSettings=QuizDeclareSettings::with(['quizDeclare'=>function($query1) use ($data){
                $query1->with(['quizDeclareStudents'=>function($query2) use ($data){
                    $query2->with(['studentHistory'=>function($query3){
                        $query3->with('student','year','shift','department','stClass','classGroup','session','section','religion');
                    },'quizDeclare'])

                    ->when($data['student_limit'], function ($query) use ($data) {
                        return $query->take($data['student_limit']);
                    })
                    ->when($data['form_marks'], function ($query) use ($data) {
                        return $query->where('mark','<=',$data['form_marks']);
                    })
                    ->when($data['to_marks'], function ($query) use ($data) {
                        return $query->where('mark','>=',$data['to_marks']);
                    })
                    ->orderBy('mark','DESC')
                    ->orderBy('quiz_time_by_second','ASC')
                    ->where('join_status',1);
                }, 'quiz']);
            }])
            ->where('quiz_declare_id',$request->quiz_declare_id)
            ->where('is_start',1)
           // ->where('is_end',1)
            ->first();
         

            $quiz_name = $quizSettings->quizDeclare->quiz->quiz_name;
            $start_date = $quizSettings->start_date;
            $start_time = $quizSettings->start_time;
            $duration = $quizSettings->duration;
            $question_per_student = $quizSettings->question_per_student;
            $student_list = $quizSettings->quizDeclare->quizDeclareStudents;

            //student infor
            $quiz_infos=[
                'quiz_name'=>$quiz_name,
                'start_date'=>$start_date,
                'start_time'=>$start_time,
                'duration'=>$duration,
                'question_per_student'=>$question_per_student,
            ];

            $student_info=[];
            foreach($student_list as $item){
                $student_info[]=[
                    'student_name'=>$item->studentHistory?$item->studentHistory->full_name:null,
                    'join_status'=>$item->join_status,
                    'marks'=>$item->mark,
                    'total_question'=>$item->total_question,
                    'total_answer'=>$item->total_answer,
                    'total_right_answer'=>$item->total_right_answer,
                    'total_wrong_answer'=>$item->total_wrong_answer,
                    'quiz_time'=>$item->quiz_time,
                    'quiz_time_by_second'=>$item->quiz_time_by_second,
                    'marks'=>$item->mark,
                    'year'=>$item->studentHistory->year?$item->studentHistory->year->year_name:null,
                    'shift'=>$item->studentHistory->shift?$item->studentHistory->shift->shift_name:null,
                    'department'=>$item->studentHistory->department?$item->studentHistory->department->department_name:null,
                    'stClass'=>$item->studentHistory->shift?$item->studentHistory->stClass->class_name:null,
                    'classGroup'=>$item->studentHistory->classGroup?$item->studentHistory->classGroup->group_name:null,
                    'session'=>$item->studentHistory->session?$item->studentHistory->session->session_name:null,
                    'section'=>$item->studentHistory->section?$item->studentHistory->section->section_name:null,
                    'religion'=>$item->studentHistory->religion?$item->studentHistory->religion->religion_name:null,
                ];
            }
          
        
        return response()->json([
            'quiz_infos'=>$quiz_infos,
            'student_list'=>$student_info,
        ]);
    }
}
