<?php

namespace App\Http\Controllers\Site\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Quiz\SiteQuiz;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use App\Models\Student\StudentHistory;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclares;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Academic\AcademicSubjectTopic;
use App\Models\Site\Quiz\Question\StudentQuizAnswerDetails;

use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Exam\Question\SiteExamQuestionDeclare;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\SiteInfo;

use Illuminate\Support\Carbon;

use Auth;
use Response;
use DB;
use Exception;
use Illuminate\Validation\Rules\Unique;
use Session;

class SiteBaseQuizDeclareController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    public function index()
    {
        $viewType = "Exam Question";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    
    public function createQuiz(Request $request){

        try{
            $site_id = Session::get('SITE_ID');

         //   dd($site_id);
            $this->validate($request, [
                'quiz_name' => 'required',
            ]);
          
            $quiz = new SiteQuiz();
            $quiz->site_id = $site_id;
            $quiz->quiz_name = $request->quiz_name;
            $quiz->quiz_key = $request->quiz_key;
            $quiz->quiz_note = $request->quiz_note;
            $quiz->status = $request->status;

            $quiz->save();
    
            return response()->json(['message'=>'Quiz Add Successfully', 'status'=>true]);
    
        }catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    
    }

    public function getQuizlist(){
        $quiz_list = SiteQuiz::where('site_id', Session::get('SITE_ID'))->orderBy('id', 'DESC')->paginate(10);
 
        return response()->json(['quiz_list'=>$quiz_list]);
     }

     
    public function quizEdit(Request $request){
        $quiz_item = SiteQuiz::findOrFail($request->quiz_id);

        return response()->json(['quiz_item'=>$quiz_item],200);

    }


    public function quizUpate(Request $request){
        try{
            $this->validate($request, [
                'quiz_name' => 'required',
            ]);

          
            $quiz =  SiteQuiz::findOrFail($request->id);
            $quiz->quiz_name = $request->quiz_name;
            $quiz->quiz_key = $request->quiz_key;
            $quiz->quiz_note = $request->quiz_note;
            $quiz->status = $request->status;
            $quiz->save();
    
            return response()->json(['message'=>'Quiz Update Successfully', 'status'=>true]);
    
        }catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }

        }


        public function quizDelete(Request $request){
            DB::beginTransaction();

           try{
            $quiz =  SiteQuiz::findOrFail($request->quiz_id);
            
           if($quiz->delete()){
                $quizDeclare = QuizDeclares::where('quiz_id',$request->quiz_id);
           
                $quizDeclare_ids = $quizDeclare->pluck('id');
                $quizDeclare->delete();
                QuizDeclareSettings::whereIn('quiz_declare_id', $quizDeclare_ids)->delete();
                QuizDeclareStudents::whereIn('quiz_declare_id', $quizDeclare_ids)->delete();
                StudentQuizAnswerDetails::whereIn('quiz_declare_id', $quizDeclare_ids)->delete();
     
           }
           
            return response()->json(['message'=>'Quiz Delete Successfully', 'status'=>true]);
            DB::commit();
        }catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
        }

        public function activeQuizList($declare_key){

          $site_id = Session::get('SITE_ID');
            if($declare_key=='group'){
               
                $site_info = SiteInfo::where('id', $site_id)->first();
                $site_group_id = $site_info->site_group_id;
    
                $declaredQuizList = QuizDeclares::with('quiz')->where('site_group_id',$site_group_id)
                                    ->get();
                $quizDeclaredIds = $declaredQuizList->pluck('quiz_id');
    
                $active_quiz_list = SiteQuiz::whereIn('id',$quizDeclaredIds)
                                    ->where('status',true)
                                    ->orderBy('id', 'DESC')
                                    ->get();
    
            }else{
                $active_quiz_list = SiteQuiz::where('site_id', $site_id)->orderBy('id', 'DESC')
                                ->where('status',true)
                                ->get();
    
            }

            return response()->json(['active_quiz_list'=>$active_quiz_list]);
        }


        public function getStudentListForQuizDeclare(Request $requests)
         {

            $this->validate($requests, [
                "academic_class_ids" => "required",
                "academic_year_id" => "required",
                "academic_shift_id" => "required",
                "declare_key" => "required",
                "quiz_id" => "required",
            ]);

            try {

                ini_set('memory_limit', '-1');

                $data = $requests->all();
                $current_date = Carbon::now()->format('Y-m-d');

                $student_array = StudentHistory::select('id', 'user_id', 'student_roll_number')
                    ->with(['student' => function ($query) {
                        $query->select('id');
                        $query->where('user_type', 'student');

                    }])
                    ->where('academic_version_id', $requests->academic_version_id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_class_ids']), function ($query) use ($data) {
                        return $query->whereIn('academic_class_id', $data['academic_class_ids']);
                    })
                    ->where('status', true)
                    ->orderBy('student_roll_number', 'ASC')
                    ->get();

                    $student_ids=$student_array->pluck('id')->filter()->unique();


                // $student_arr=Array();
                // $studentList=[];
                // foreach ($student_array as $key => $value) {
                //     $student_arr['id']=$value->id;
                //     $student_arr['full_name']=$value->full_name;
                //     $student_arr['student_roll_number']=$value->student_roll_number;
                //     $student_arr['student_full_roll_number']=$value->student_full_roll_number;

                //     $studentList[$key]=$student_arr;
                // }

                $declaredQuizList = QuizDeclares::with(['quizDeclareSettings','year','quiz'
                        ])
                    ->withCount('quizDeclareStudents')
                    // ->where('academic_version_id', $requests->academic_version_id)
                     ->where('academic_year_id', $requests->academic_year_id)
                    // ->where('academic_shift_id', $requests->academic_shift_id)
                    //   ->where('academic_class_id', $requests->academic_class_id)
                    ->where('quiz_id', $requests->quiz_id)
                    // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    //     return $query->where('academic_department_id', $data['academic_department_id']);
                    // })
                    // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    // })
                    // ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    //     return $query->where('academic_section_id', $data['academic_section_id']);
                    // })
                    // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    //     return $query->where('academic_session_id', $data['academic_session_id']);
                    // })
                    ->orderBy('id','DESC')
                    ->get();

                
                    $quizDeclaredIds = $declaredQuizList->pluck('id');

                  $current_date = Carbon::now()->format('Y-m-d');


                  $quizDeclaredIdss = $declaredQuizList->where('declare_key','site')->pluck('id');
                  
                //   $quiz_declare_setting=QuizDeclareSettings::whereIn('quiz_declare_id',$quizDeclaredIdss)
                //   //  ->where('start_date', '>=', $current_date)
                //     ->first();
                       
                    $quiz_declare_setting = QuizDeclareSettings::whereIn('quiz_declare_id',$quizDeclaredIdss)
                        ->whereHas('quizDeclare', function ($q){
                                        $q->where('declare_key', '=', 'site');
                                    })
                        ->orderBy('id','DESC')
                        ->first();
                       // dd($quiz_declare_setting);

                   //quiz_declares

                $declared_student_ids=QuizDeclareStudents::whereIn('quiz_declare_id',$quizDeclaredIds)
                    ->whereIn('student_history_id',$student_ids)
                    ->pluck('student_history_id')
                    ->unique()
                    ->filter();
                    
               
                return response()->json(
                    [
                        'studentList' => $student_array,
                        'declaredQuizList' => $declaredQuizList,
                        'select_student_user_id' => $declared_student_ids,
                        'quiz_declare_setting' => $quiz_declare_setting,
                         
                    ]);

            } catch (Exception $exception) {
                return Response::json(['message' => $exception->getMessage()], 410);
            }

    }

    public function createAndUpdateSiteBaseQuizDeclare(Request $requests, QuizDeclares $quizDeclares){


       DB::beginTransaction();

           try {

            $this->validate($requests, [
                'academic_year_id' => 'required',
                'quiz_id' => 'required',
            ]);

            $data=$requests->all();
            $siteQuizDeclareId=$requests->quiz_declare_id;
   
            $checkQuizDeclared=$quizDeclares
                    ->where('academic_year_id', $requests->academic_year_id)
                    ->where('quiz_id', $requests->quiz_id)
                    ->first();

            if($requests->first_time_update==1){
      
        // check group quiz
           
            if($checkQuizDeclared){
            $siteQuizDeclareId = $checkQuizDeclared->id;


            $quizDeclareSetting = QuizDeclareSettings::where('quiz_declare_id',$siteQuizDeclareId)
                    ->whereHas('quizDeclare', function ($q){
                                    $q->where('declare_key', '=', 'site');
                                })
                    ->first();

              //  dd($quizDeclareSetting);
            if($quizDeclareSetting){
                
              //  $checkQuizDeclared->save();

                $quizDeclareSetting->start_date = $requests->start_date;
                $quizDeclareSetting->start_time =date("H:i", strtotime($requests->start_time));
                $quizDeclareSetting->end_time = date("H:i", strtotime($requests->end_time));
                $quizDeclareSetting->start_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->start_time));
                $quizDeclareSetting->end_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->end_time));
               
                $quizDeclareSetting->duration = $requests->duration;
                $quizDeclareSetting->question_per_student = $requests->question_per_student;
                $quizDeclareSetting->result_show_to_student_panel_status = $requests->result_show_to_student_panel_status;
                $quizDeclareSetting->is_start = 1;
                $quizDeclareSetting->save();
            }

        }else{
            $this->validate($requests, [
                'start_date' => 'required',
                'start_time' => 'required',
                'end_time' => 'required',
                'duration' => 'required',
                'question_per_student' => 'required',
            ]);

            $quiz_declare = new QuizDeclares();
        
            $quiz_declare->academic_year_id=$requests->academic_year_id;
            $quiz_declare->quiz_id=$requests->quiz_id;
            $quiz_declare->created_by=Auth::user()->id;
            $quiz_declare->status=true;
        
            if($quiz_declare->save()){
                $siteQuizDeclareId = $quiz_declare->id;
                
                $quizDeclareSetting = new QuizDeclareSettings();

                $quizDeclareSetting->quiz_declare_id = $siteQuizDeclareId;
                $quizDeclareSetting->start_date = $requests->start_date;
                $quizDeclareSetting->start_time =date("H:i", strtotime($requests->start_time));
                $quizDeclareSetting->end_time = date("H:i", strtotime($requests->end_time));
                $quizDeclareSetting->start_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->start_time));
                $quizDeclareSetting->end_date_time = $requests->start_date.' '.date("H:i", strtotime($requests->end_time));

                $quizDeclareSetting->duration = $requests->duration;
                $quizDeclareSetting->question_per_student = $requests->question_per_student;
                $quizDeclareSetting->result_show_to_student_panel_status = $requests->result_show_to_student_panel_status;
                $quizDeclareSetting->is_start = 1;

                $quizDeclareSetting->save();

            }
        }
    }

            $count_student=count($requests->select_student_user_id);
          if($count_student>0){
            /// check students


            if($requests->first_time_update==1){

                $ten_student_history_id=collect($requests->select_student_user_id)->take(50);
                $studentRest=array_diff($requests->select_student_user_id, $ten_student_history_id->toArray());

                $completed_student_id_array=$ten_student_history_id;
               
            }
            else if($requests->first_time_update==0){

                $ten_student_history_id=collect($requests->select_student_rest_history_id)->take(50);
                $studentRest=array_diff($requests->select_student_rest_history_id, $ten_student_history_id->toArray());

                $completed_student_id_array=array_merge($requests->completed_student_id_array, $ten_student_history_id->toArray());
            }

            $completed_percent=ceil(count($completed_student_id_array)*100/$count_student);
       
            $declare_student_list = QuizDeclareStudents::where('quiz_declare_id',$siteQuizDeclareId)->get();

                if(count($completed_student_id_array)>0 ){
                    
                    $created=[];
                    foreach ($completed_student_id_array as $key => $value) {
                        $checkStudent = $declare_student_list->where('student_history_id',$value)->first();
                        if(!$checkStudent){
                            $created[] = [
                                'quiz_declare_id' => $siteQuizDeclareId,
                                'student_history_id' => $value,
                            ];
                        }
                    
                    }

                    if(count($created)>0){
                        QuizDeclareStudents::insert($created);
                    }

                }
            }else{
                $studentRest=[];
                $completed_student_id_array=[];
            }
                DB::commit();

                $academic_year_id=$requests->academic_year_id;
                $quiz_id=$requests->quiz_id;
                $quiz_declare_id=$siteQuizDeclareId;
              
                if(count($studentRest)>0){
                    return compact('studentRest', 'count_student',
                        'completed_student_id_array', 'completed_percent','academic_year_id','quiz_id','quiz_declare_id');
                }else{
                 //   dd(count($studentRest));
                    return Response::json(['message' => 'information Update Successfully!', 'mode' => 'Update',
                        'completed_student_id_array' => $completed_student_id_array,
                        'count_student' => $count_student ], 200);
                }
    
       
 
           
            return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function deleteSiteBaseQuizDeclare(Request $requests){

        try {

            $declared_quiz = QuizDeclares::where('id', $requests->quiz_declare_id)
                        ->where('declare_key','site')
                        ->first();

                if($declared_quiz){
                    
                    if($declared_quiz->delete()){
                        QuizDeclareSettings::where('quiz_declare_id',$requests->quiz_declare_id)->delete();
                       
                        QuizDeclareStudents::where('quiz_declare_id', $requests->quiz_declare_id)->delete();
                       
                        StudentQuizAnswerDetails::where('quiz_declare_id', $requests->quiz_declare_id)->delete();
                    }
                    return Response::json(['message' => 'Delete Successfully!', 'mode' => 'Update!'], 200);

                }else{
                    return Response::json(['message' => 'You have no access'], 410);
                }
       

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }



     
    
    
 

    // getSubjectTopicListForQuizQuestionDeclare

}
