<?php

namespace App\Http\Controllers\Site\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Student\StudentHistory;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Academic\AcademicSubjectTopic;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Exam\Question\SiteExamQuestionDeclare;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Quiz\GlobalSiteQuizQuestionInfo;
use App\Models\Site\Quiz\Question\SiteQuizQuestionForStudent;
use App\Models\Site\Quiz\SiteQuizQuestion;
use App\Models\Site\Quiz\SiteQuizQuestionInfo;
use Auth;
use Response;
use DB;
use Exception;
use Illuminate\Support\Carbon;
use Illuminate\Validation\Rules\Unique;
use Session;

class SiteBaseQuizQuestionDeclareController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    public function getSubjectTopicListForQuizQuestionDeclare(Request $request)
    {
      
       $topic_list = AcademicSubjectTopic::whereIn('academic_subject_id', $request->academic_subject_ids)
       ->where('module_key','quiz')
       ->get();

       return response()->json($topic_list);

    }

    public function getActiveSubjectListByYearClassForQuizDeclare(Request $requests)
    {
        $data=$requests->all();
        try {
  
        $sGroupCondSettings = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
                ->whereIn('academic_class_id', $data['academic_class_ids'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->groupBy('academic_subject_id')
                ->get();

        return response()->json($sGroupCondSettings);

        } catch (Exception $exception) {
            return $exception->getMessage();

        }
     }

     
    public function getQuestionListForQuizDeclare(Request $request){
 
         $data = $request->all();
         $academic_year_id = $data['academic_year_id'];
         $topic_ids = $data['quiz_topic_ids'];

            $current_date = Carbon::now()->format('Y-m-d');

            $quiz_declare_list = QuizDeclares::with('quiz')
                    ->whereHas('quizDeclareSettings', function ($q) use ($current_date) {
                            $q->where('start_date', '>=', $current_date);
                        })
                    ->where('declare_key','site')
                    ->get();


            $question_info=SiteQuizQuestionInfo::where('academic_version_id', $data['academic_version_id'])
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_ids']), function ($query2) use ($data) {
                        return $query2->where('academic_class_id', $data['academic_class_ids']);
                    })
                    ->when(!empty($data['academic_subject_ids']), function ($query3) use ($data) {
                        return $query3->whereIn('academic_subject_id', $data['academic_subject_ids']);
                    })
                    // ->when(!empty($data['quiz_topic_ids']), function ($query3) use ($data) {
                    //     return $query3->whereIn('academic_subject_topic_id', $data['quiz_topic_ids']);
                    // })
                    ->get();
            //   dd($question_info);
       
              $question_ids=$question_info->pluck('id');
           //   dd($question_ids);
               $question_list=SiteQuizQuestion::whereIn('site_exam_question_info_id', $question_ids)
                   ->when(!empty($data['question_level']), function ($query3) use ($data) {
                        return $query3->where('question_level', $data['question_level']);
                    })
                   ->where('module_key','quiz')
                   ->where('question_status','approved')
                   ->orderBy('id','desc')
                   ->get();


         return response()->json([
                'quiz_declare_list'=>$quiz_declare_list,
                'question_list'=>$question_list,
            ]);
      
 
     }

     
     public function getSelectedQuizDeclareSettings(Request $requests){

        $dexlared_quiz = QuizDeclareSettings::with('quizDeclare')->where('quiz_declare_id', $requests->quiz_declare_id)->first();
        
        return $dexlared_quiz;
  
    }


     public function createQuizQuestionDeclare(Request $requests){
        
        $this->validate($requests, [
            "question_per_student" => "required",
            "quiz_declare_id" => "required",
        ]);
        
        $data = $requests->all();

        try {
            $quiz_questions_ids = implode(',',$data['site_quiz_question_ids']);

            $quiz_declare=QuizDeclares::find($data['quiz_declare_id']);
           
            $quiz_declare->question_ids=$quiz_questions_ids;
            $quiz_declare->save();
            
            $quiz_declare_settings=QuizDeclareSettings::where('quiz_declare_id', $data['quiz_declare_id'])->first();
            $quiz_declare_settings->question_per_student=$data['question_per_student'];
            $quiz_declare_settings->save();

            // student declare
           // dd($quiz_declare->question_ids[1]);
           $declare_question = $quiz_declare->question_ids[1];


              $declare_student_list =  QuizDeclareStudents::where('quiz_declare_id', $quiz_declare->id)
                        ->where('join_status', 0)
                        ->get();
                
            foreach($declare_student_list as $declare_student){
                $quiz_questions_ids = SiteQuizQuestionForStudent::whereIn('id', $declare_question)
                    ->where('module_key','quiz')
                    ->inRandomOrder()
                    ->limit($data['question_per_student'])
                    ->pluck('id')
                    ->unique()
                    ->filter();
                   

                $questions_ids = implode(',',$quiz_questions_ids->toArray());
               // dd($questions_ids);
               QuizDeclareStudents::where('id',$declare_student->id)
               ->update([
                'student_question_ids'=>$questions_ids
               ]);
              
            }

            return Response::json(['message' => 'Question Declare Successfully', 'mode'=>'success'], 200);

        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
           

    }
     
}
