<?php


namespace App\Http\Controllers\Site\Result\Certification;

use App\Models\Site\Employee\Employee;

use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use File;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Result\Certification\SiteCertificationSetting;
use Image;
use PDF;
use Response;
use Session;

class SiteCertificationLetterController extends Controller
{
    private $studentHistory;
    public function __construct(StudentHistory $studentHistory)
    {
        $this->middleware('auth');
        // $this->middleware('sitepagechecker');
        $this->studentHistory = $studentHistory;
    }


    public function index()
    {
        $viewType = 'Site certification';

        return view('default.admin.layouts.master', compact('viewType'));
        //        return view('default.admin.site.result.site-base-result-report', compact('viewType'));

    }
    public function CreateSiteCertificationSetting(Request $request)
    {
        $existing_setting_list =  SiteCertificationSetting::first();
        if ($existing_setting_list) {

            if ($request->border_image == "borderimage.png") {
                $border_image = $request->border_image;
            } else if ($request->border_image == $existing_setting_list->border_image) {
                $border_image = $existing_setting_list->border_image;
            } else {

                $image_path = "img/site/certification/" . $existing_setting_list->border_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }



                $name = time() . 'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                $border_image = $name;

                Image::make($request->border_image)
                    //                ->resize(440, 442)
                    ->save(public_path('img/site/certification/') . $name);
            }
        } else {

            if ($request->border_image) {
                if ($request->border_image == "borderimage.png") {
                    $border_image = $request->border_image;
                } else {

                    $name = time() . 'border' . '.' . explode('/', explode(':', substr($request->border_image, 0, strpos($request->border_image, ';')))[1])[1];
                    $border_image = $name;

                    Image::make($request->border_image)
                        //                ->resize(440, 442)
                        ->save(public_path('img/site/certification/') . $name);
                }
            } else {
                $border_image = null;
            }
        }

        if ($existing_setting_list) {
            if ($request->watermark_image == "watermarkimage.png") {
                $watermark_image = $request->watermark_image;
            } else if ($request->watermark_image == $existing_setting_list->watermark_image) {
                $watermark_image = $existing_setting_list->watermark_image;
            } else {

                $image_path = "img/site/certification/" . $existing_setting_list->watermark_image;  // Value is not URL but directory file path
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }

                $name = time() . 'watermark' . '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                $watermark_image = $name;

                Image::make($request->watermark_image)
                    //                ->resize(440, 442)
                    ->save(public_path('img/site/certification/') . $name);
            }
        } else {

            if ($request->watermark_image) {
                if ($request->watermark_image == "watermarkimage.png") {
                    $watermark_image = $request->watermark_image;
                } else {

                    $name = time() . 'watermark' . '.' . explode('/', explode(':', substr($request->watermark_image, 0, strpos($request->watermark_image, ';')))[1])[1];
                    $watermark_image = $name;

                    Image::make($request->watermark_image)
                        //                ->resize(440, 442)
                        ->save(public_path('img/site/certification/') . $name);
                }
            } else {
                $watermark_image = null;
            }
        }

        if ($existing_setting_list) {

            foreach ($existing_setting_list->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                    $existing_setting_list->{$ownFields} = $request->{$ownFields};
                }
            }
            $existing_setting_list->border_image = $border_image;
            $existing_setting_list->watermark_image = $watermark_image;
            $existing_setting_list->content = $request->content;
            $existing_setting_list->background_color = $request->certification_background_color ?? 'white';
            $existing_setting_list->initial_referance_prefix = $request->initial_referance_prefix;
            $existing_setting_list->initial_referance_number = $request->initial_referance_number;
            $existing_setting_list->initial_referance_suffix = $request->initial_referance_suffix;
            $existing_setting_list->site_id = (int)session()->get('SITE_ID');

            $existing_setting_list->save();
            return 'done 2';
        } else {
            $sitecertificationSetting =  new SiteCertificationSetting();
            foreach ($sitecertificationSetting->ownFields as $ownFields) {
                if ($request->{$ownFields}) {
                    $sitecertificationSetting->{$ownFields} = $request->{$ownFields};
                }
            }
            $sitecertificationSetting->border_image = $border_image;
            $sitecertificationSetting->watermark_image = $watermark_image;
            $sitecertificationSetting->content = $request->content;
            $sitecertificationSetting->background_color = $request->certification_background_color ?? 'white';
            $sitecertificationSetting->initial_referance_prefix = $request->initial_referance_prefix;
            $sitecertificationSetting->initial_referance_number = $request->initial_referance_number;
            $sitecertificationSetting->initial_referance_suffix = $request->initial_referance_suffix;
            $sitecertificationSetting->site_id = (int)session()->get('SITE_ID');


            $sitecertificationSetting->save();
            return 'done 1';
        }
    }
    public function GetSiteStudentListForCertification(Request $request)
    {

        $data = $request->all();


        $students   = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->with(['student' => function ($query) {
                $query->with('bloodGroup');
            }])

            ->whereHas('idCard')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->where('status', 1)

            ->get();

        $SiteCertificationSetting =  SiteCertificationSetting::first();
        $content =  $SiteCertificationSetting->content;

        $SiteStudentCertificationList = [];

        foreach ($students as $key => $student) {
            // Reset $content for each student to avoid overwriting previous replacements
            $studentContent = $SiteCertificationSetting->content;

            $placeholders = [
                '{name}' => $student->student->full_name ?? '',
                '{roll}' => $student->student->student_roll_number ?? '',
                '{mother_name}' => $student->student->mother_name ?? '',
                '{father_name}' => $student->student->father_name ?? '',
                '{blood_group}' => $student->student->bloodGroup->blood_group_name ?? '',
                '{date_of_birth}' => $student->student->date_of_birth ?? '',
                '{shift_name}' => $student->shift->shift_name ?? '',
                '{department_name}' => $student->department->name ?? '',
                '{class_name}' => $student->stClass->class_name ?? '',
                '{group_name}' => $student->classGroup->group_name ?? '',
                '{section_name}' => $student->section->section_name ?? '',
                '{session_name}' => $student->session->session_name ?? '',
            ];

            // Replace placeholders with actual values for this specific student
            $studentContent = strtr($studentContent, $placeholders);

            $SiteStudentCertificationList[$key]['name'] = $student->student->full_name;
            $SiteStudentCertificationList[$key]['student_roll_number'] = $student->student_roll_number;
            $SiteStudentCertificationList[$key]['username'] = $student->student->username ?? '';
            $SiteStudentCertificationList[$key]['father_name'] = $student->student->father_name ?? '';
            $SiteStudentCertificationList[$key]['mother_name'] = $student->student->mother_name ?? '';
            $SiteStudentCertificationList[$key]['shift_name'] = $student->shift->shift_name ?? '';
            $SiteStudentCertificationList[$key]['department_name'] = $student->department->name ?? '';
            $SiteStudentCertificationList[$key]['class_name'] = $student->stClass->class_name ?? '';
            $SiteStudentCertificationList[$key]['group_name'] = $student->classGroup->group_name ?? '';
            $SiteStudentCertificationList[$key]['section_name'] = $student->section->section_name ?? '';
            $SiteStudentCertificationList[$key]['session_name'] = $student->session->session_name ?? '';
            $SiteStudentCertificationList[$key]['blood_group'] = $student->student->bloodGroup->blood_group_name ?? '';
            $SiteStudentCertificationList[$key]['date_of_birth'] = $student->student->date_of_birth ?? null;
            $SiteStudentCertificationList[$key]['CertificationContent'] = $studentContent; // Use the modified content
        }
        return $SiteStudentCertificationList;
    }
    public function CertificationPdfDownload(Request $request)
    {
         $student_detail =  $request->student_history;

        ini_set('memory_limit', '-1');


        $page_tittle = "Certification Letter";
        $report_tittle = "<b>Certification Letter</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Certification Letter";




        if (count($student_detail) <= 0) {
            return response()->json(['message' => 'Student Result Status Failed'], 422);
        }



        $data = $request->all();




        $site = SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id', 'site_logo', 'district_id', 'board_id', 'eiin', 'college_code', 'nu_code')
            ->first();


        //        return compact('student_detail', 'site');
        $setting_list = SiteCertificationSetting::first();

        $institute_head = Employee::where('institute_head', 1)->first();

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';
        //    dd($student_detail->student);

        $pdf = PDF::loadView(
            'default.admin.site.result.certification.site-certification-pdf',
            compact(
                'student_detail',
                'site',
                'setting_list',
                'signature',
                'designation',
                'report_tittle',
                'page_tittle',
                'report_tittle2',
                'title_view'
            )
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }
}
