<?php

namespace App\Http\Controllers\Site\Result;

use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Academic\AcademicReportCardDesignation;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Employee\Employee;

use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Result\SiteExamResultReportSetting;
use Exception;
use Illuminate\Support\Facades\Schema;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use Illuminate\Support\Facades\Log;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Result\SiteStudentCombineResultDetail;

use Auth;
use PDF;
use Response;
use Image;
use Illuminate\Support\facades\Http;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultSystemSettingStore;
use App\Traits\Site\Result\ExamResultTrait;
use DateInterval;
use DatePeriod;
use DateTime;
use Session;

class SiteBaseResultReportController extends ProjectController
{
    use ExamResultTrait;

    private $siteExamCommitteeSetting;
    private $simpleSiteExamCommitteeSetting;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Site Result Report';
        return view('default.admin.layouts.master', compact('viewType'));
    }



    public function getSiteBaseStudentAndPrimaryResultList(Request $request)
    {
      //  dd($this->checkSiteGroupResultPermission($request));

        // if (!$this->checkSiteGroupResultPermission($request)) {
        //     return Response::json(['message' => 'You have no permission!'], 401);
        // }

        $data = $request->all();

        $studentList = $this->getStudenthistoryList($request);
        $student_ids = $studentList->pluck('id');
        $primary_exam_type_ids = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list = AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)
            ->get(['id', 'name','use_key']);
        
    
        return [$studentList, $result_primary_type_list];
    }


    public function getSiteBaseStudentAndCombineResultList(Request $request)
    {
        $data = $request->all();

        $studentList = $this->getStudenthistoryList($request);
        $student_ids = $studentList->pluck('id');

        $resultSettingList = SiteResultCombineSetting::with(['academicResultCombineType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

        $academic_result_combine_type_Ids = $resultSettingList->pluck('academic_result_combine_type_id')->unique()->filter();
        $combine_array = [];

        foreach ($academic_result_combine_type_Ids as $key => $value) {
            $check_primary_type_Ids = $resultSettingList->where('academic_result_combine_type_id', $value)
                ->pluck('academic_result_primary_type_id')->unique();

            $siteExamDeclares_primary_type_ids = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
                ->whereIn('academic_result_primary_type_id', $check_primary_type_Ids)
                ->pluck('academic_result_primary_type_id')->unique();

            if (count($check_primary_type_Ids) == count($siteExamDeclares_primary_type_ids)) {
                $combine_list = $resultSettingList->where('academic_result_combine_type_id', $value)->first();
                $combine_array[] = $combine_list->academic_result_combine_type_id;
            }
        }

        $academic_result_combine_type = AcademicResultCombineType::whereIn('id', $combine_array)->get();
        $test_arr = array();
        $resultlist = [];
        foreach ($academic_result_combine_type as $key => $value) {

            $test_arr['loading_result_generate_image'] = false;
            $resultlist[$key] = array_merge($test_arr, $value->toArray());
        }

        return [$studentList, $resultlist];
    }

    public function getSiteBaseStudentAndPrimaryResultListForEmployee(Request $request)
    {

        if (!$this->checkSiteGroupResultPermission($request)) {
            return Response::json(['message' => 'You have no permission!'], 401);
        }

        $data = $request->all();
        $studentList = $this->getStudenthistoryList($request);
        $student_ids = $studentList->pluck('id');

        $primary_exam_type_ids = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->where('result_employee_publish_status', true)
            ->where('result_generated_by', 'site')
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list = AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)
            //  ->where('use_key','site')
            ->get(['id', 'name']);


        return [$studentList, $result_primary_type_list];
    }



    public function getSiteStudentAndPrimaryResultTypeBaseResultDetail(Request $request)
    {

        $data = $request->all();

        if (!$this->checkSiteGroupResultPermission($request)) {
            return Response::json(['message' => 'You have no permission!'], 401);
        }

        $title_list = AcademicReportCardDesignation::orderBy('serial', 'ASC')->get();

        $data['academic_group_id']=Session::get('ACADEMIC_GROUP_ID');
        $data['site_id']=Session::get('SITE_ID');
        $student_ids=$data['select_student_user_ids'];
       
        $primaryResultList =  $this->primaryResultTypeBaseResultDetails($data, $student_ids, 'site_admin');

        if ($primaryResultList['status']!='200') {
            return Response::json(['message' => $primaryResultList['message'],'status'=>$primaryResultList['status']], 404);
        }
                
        return [$primaryResultList['result_array'], $primaryResultList['result_setting_array'], $title_list. 'status'=>$primaryResultList['status']];



//         $dataaa = SiteStudentPrimaryResultDetailForTabulation::with(['studentHistory' => function ($query) {
//             $query->select('id','user_id','academic_shift_id','academic_class_id','academic_department_id','academic_session_id','academic_student_category_id','board_registration_number','academic_class_group_id','academic_section_id','academic_year_id','student_roll_number_prefix','student_roll_number','registration_no');
//             $query->with([
//                 'student' => function ($q) {
//                     $q->with('latestPhoto');
//                     $q->select('id');
//                     $q->where('user_type', 'student');
//                 },
//                 'year','shift','department','stClass','classGroup','session','section'
//             ]);
//         }, 'academicResultPrimaryType'])
//             ->whereIn('student_history_id', $request->select_student_user_ids)
//             ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
//             ->where('status', true)
//             ->get();


//         $resultSetting = SiteExamResultReportSetting::first();

//         if (!$resultSetting) {
//             return Response::json(['message' => 'First make rsult settings'], 411);
//         }

//    $student_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
//                 ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
//                     return $query->where('academic_year_id', $data['academic_year_id']);
//                 })
//                 ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
//                     return $query->where('academic_shift_id', $data['academic_shift_id']);
//                 })
//                 ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
//                     return $query->where('academic_department_id', $data['academic_department_id']);
//                 })
//                 ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
//                     return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
//                 })
//                 ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
//                     return $query->where('academic_class_id', $data['academic_class_id']);
//                 })
//                 ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
//                     return $query->where('academic_session_id', $data['academic_session_id']);
//                 })
//                 ->where('status', true)
//                 ->pluck('id');

//         if (!$resultSetting->section_wise_highest_mark_show_status) {

         

          
//             $hight_marks_ids = SiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
//                 ->whereIn('student_history_id', $student_ids)
//                 ->where('status', true)
//                 ->pluck('exam_dependent_academic_subject_id')
//                 ->unique()
//                 ->filter();

//             $hight_marks_list = [];
//             foreach ($hight_marks_ids as $key => $value) {
//                 $hight_marks_subject = SiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
//                     ->whereIn('student_history_id', $student_ids)
//                     ->where('exam_dependent_academic_subject_id', $value)
//                     ->where('status', true)
//                     //    ->orderBy('obtain_raw_total_marks', 'desc')
//                     ->orderBy('obtain_total_marks_for_show', 'desc')
//                     // ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks')
//                     ->select('exam_dependent_academic_subject_id', 'obtain_total_marks_for_show', 'obtain_raw_total_marks')
//                     ->first();



//                 if ($hight_marks_subject) {
//                     $hight_marks_list[] = $hight_marks_subject;
//                 }
//             }
//         }
//         // dd($hight_marks_list);
//         // Employee
//         $institute_head = Employee::where('institute_head', 1)->first();
//         $site_info =  SiteInfo::find(Session::get('SITE_ID'));

//         $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
//         $get_designation = $institute_head->designation->name ?? 'Institution Head';



//         $a_arr = array();
//         $a_array = [];
//         foreach ($dataaa as $key => $value) {
//             // dd($value);
//             $b_array = [];
//             foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet) {

//                 $b_array[] = $valuet->subject_detail;
//             }

//             if ($resultSetting->section_wise_highest_mark_show_status) {
//                 $highest_marks_list = json_decode($value->highest_marks_list);
//             } else {
//                 $subject_ids = collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
//                 $highest_marks_list = collect($hight_marks_list)->whereIn('exam_dependent_academic_subject_id', $subject_ids);
//             }

//             $result_show_in_table_bellow_status_present = collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

//             $a_arr['academic_result_primary_type_id'] = $value->academic_result_primary_type_id;
//             $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
//             $a_arr['student_history_id'] = $value->student_history_id;
//             $a_arr['fail_subject_count'] = $value->fail_subject_count;
//             $a_arr['gpa'] = $value->gpa;
//             $a_arr['grade'] = $value->grade;

//             $a_arr['student_rank'] = $value->student_rank;
//             $a_arr['site_result_primary_setting_id'] = $value->site_result_primary_setting_id;
//             $a_arr['academic_result_primary_type_id'] = $value->academic_result_primary_type_id;
//             $a_arr['subject_list'] = $b_array;
//             $a_arr['table_header'] = $value->table_header;
//             $a_arr['highest_marks'] = $highest_marks_list;
//             $a_arr['student_history'] = $value->studentHistory;

//             ///   $a_arr['total_student']=count($student_ids);
//             $a_arr['total_student'] = $value->total_student;

//             $a_arr['student_photo'] = $value->studentHistory->student->latestPhoto ?
//                 $value->studentHistory->student->latestPhoto->name : 'image-not.png';

//             $a_arr['result_show_in_table_bellow_status_present'] = count($result_show_in_table_bellow_status_present) > 0 ? 1 : 0;

//             $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
//             $a_arr['result_type_id'] = $value->academicResultPrimaryType->id;

//             $a_arr['classtest_is_present'] = $value->classtest_is_present;
//             $a_arr['combine_subject_present'] = $value->combine_subject_present;
//             $a_arr['final_grade_without_optional'] = $value->final_grade_without_optional;
//             $a_arr['final_point_without_optional'] = $value->final_point_without_optional;
//             $a_arr['id'] = $value->id;
//             $a_arr['raw_obtain_marks_percentage'] = number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
//             $a_arr['sum_of_obtain_percent_total_marks'] = $value->sum_of_obtain_percent_total_marks;
//             $a_arr['sum_of_obtain_raw_total_marks'] = $value->sum_of_obtain_raw_total_marks;
//             $a_arr['sum_of_raw_total_marks'] = $value->sum_of_raw_total_marks;
//             $a_arr['sum_of_obtain_total_marks_for_show'] = $value->sum_of_obtain_total_marks_for_show;
//             $a_arr['sum_of_obtain_total_percent_for_show'] = $value->sum_of_obtain_total_percent_for_show;
//             //  $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;

//             $a_arr['institute_head_teacher_signature'] = $get_signature;
//             $a_arr['institute_head_teacher_designation'] = $get_designation;
//             $a_arr['address'] = $site_info->site_name;

//             $a_arr['comment'] = $value->comment;
//             $a_arr['academic_days'] = $value->academic_days;
//             $a_arr['present_days'] = $value->present_days;
//             $a_arr['absent_days'] = $value->absent_days;
//             $a_arr['behaviour'] = $value->behaviour;
//             $a_arr['cultural_activities'] = $value->cultural_activities;
//             $a_arr['bncc'] = $value->bncc;
//             $a_arr['debate'] = $value->bncc;
//             $a_arr['scout'] = $value->scout;
//             $a_arr['sports'] = $value->sports;
//             $a_arr['others'] = $value->others;
//             $a_arr['result_generated_by'] = $value->result_generated_by;

//             $a_array[$key] = array_merge($a_arr);
//         }

//         $academic_primary_type = AcademicResultPrimaryType::where('id', $data['academic_result_primary_type_id'])
//             ->where('use_key', 'site_group')
//             ->first();

//         if (!$academic_primary_type) {
//             $siteResultSystemSettingPresent = SiteResultSystemSetting::with(['academicResultSystem'])
//                 ->where('academic_year_id', $request->academic_year_id)
//                 ->where('academic_version_id', $request->academic_version_id)
//                 ->where('academic_class_id', $request->academic_class_id)
//                 ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
//                     return $query->where('academic_department_id', $data['academic_department_id']);
//                 })
//                 ->where('status', true)
//                 ->get()
//                 ->sortBy(function ($item) {
//                     return $item->academicResultSystem->serial ?? 0;
//                 });
//         } else {
//             $siteResultSystemSettingPresent = GlobalSiteGroupResultSystemSettingStore::with(['academicResultSystem'])
//                 ->where('academic_year_id', $request->academic_year_id)
//                 ->where('academic_version_id', $request->academic_version_id)
//                 ->where('academic_class_id', $request->academic_class_id)
//                 ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
//                     return $query->where('academic_department_id', $data['academic_department_id']);
//                 })
//                 ->where('status', true)
//                 ->get()
//                 ->sortBy(function ($item) {
//                     return $item->academicResultSystem->serial ?? 0;
//                 });;
//         }



//         ////==== title list ===

//         $site_info =  SiteInfo::find(Session::get('SITE_ID'));

//         $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
//         $get_designation = $institute_head->designation->name ?? 'Institution Head';


//         $title_list = AcademicReportCardDesignation::orderBy('serial', 'ASC')->get();

     

//         return [$a_array, $siteResultSystemSettingPresent, $title_list];
    }



    public function siteBaseMultipleStudentDetailResultPdf(Request $request)
    {
        $data=[];
        $data=$request->all();
        $data['site_id']=Session::get('SITE_ID');
        $data['academic_group_id']=Session::get('ACADEMIC_GROUP_ID');
        $student_history_ids=$data['select_student_user_ids'];

        $resultPdf=$this->studentResulDetailsPdf($data,$student_history_ids,'site_admin');

        return Response::json([
            'link' => route('open-pdf-file-storage-for-public', [$resultPdf['file_name']]),
            'message' => 'Successfully Created Card Report'
        ],200);


    }

    public function getSiteBaseResultReportSettings()
    {

        $title_list = AcademicReportCardDesignation::orderBy('serial', 'ASC')->get();

        $resultSetting = SiteExamResultReportSetting::where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->first();

        if(!$resultSetting){
            $resultSetting = SiteExamResultReportSetting::first();
        }

        if (!$resultSetting) {
            $resultSetting = [
                'sheet_no' => 'one',
                'site_address_show_status' => true,
                'exam_type_show_status' => true,
                'std_image_show_status' => true,
                'qrcode_show_status' => true,
                'countable_mark_show_status' => false,
                'row_mark_show_status' => false,
                'mark_percentage_show_status' => true,
                'academic_perform_show_status' => true,
                'behaviour_show_status' => true,
                'curriculam_activities_show_status' => true,
                'merit_list_show_status' => true,
                'head_signature_show_status' => '',
                'left_designation' => null,
                'center_designation' => null,
                'right_designation' => 'Institute Head',
            ];
        }

        return [$title_list, $resultSetting];
    }

    public function createUpdateSiteBaseResultReportSettings(Request $request)
    {

        $checkSetting = SiteExamResultReportSetting::where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->first();

        // if(!$checkSetting){
        //     $checkSetting = SiteExamResultReportSetting::first();
        // }


        if ($checkSetting) {
            $imageName = $checkSetting->bottom_logo ?? null;
            if ($request->bottom_logo) {
                // Delete previous image if it exists
                if ($imageName && file_exists(public_path('uploads/') . $imageName)) {
                    unlink(public_path('uploads/') . $imageName);
                }

                // Process and save the new image
                $image = $request->bottom_logo;
                $extension = explode('/', explode(';', $image)[0])[1];
                $imageName = time() . "." . $extension;
                Image::make($image)->save(public_path('uploads/') . $imageName);
            }

            $checkSetting->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
            $checkSetting->site_address_show_status = $request->site_address_show_status;
            $checkSetting->exam_type_show_status = $request->exam_type_show_status;
            $checkSetting->std_image_show_status = $request->std_image_show_status;
            $checkSetting->qrcode_show_status = $request->qrcode_show_status;
            $checkSetting->merit_list_show_status = $request->merit_list_show_status;
            $checkSetting->academic_perform_show_status = $request->academic_perform_show_status;
            $checkSetting->section_wise_highest_mark_show_status = $request->section_wise_highest_mark_show_status;
            $checkSetting->head_signature_show_status = $request->head_signature_show_status;
            $checkSetting->countable_mark_show_status = $request->countable_mark_show_status;
            $checkSetting->row_mark_show_status = $request->row_mark_show_status;
            $checkSetting->mark_percentage_show_status = $request->mark_percentage_show_status;
            $checkSetting->left_designation = $request->left_designation;
            $checkSetting->center_designation = $request->center_designation;
            $checkSetting->right_designation = $request->right_designation;
            $checkSetting->sheet_no = $request->sheet_no;
            $checkSetting->combine_result_sheet_no = $request->combine_result_sheet_no;
            $checkSetting->behaviour_show_status = $request->behaviour_show_status;
            $checkSetting->curriculam_activities_show_status = $request->curriculam_activities_show_status;
            $checkSetting->comment_show_status = $request->comment_show_status;
            $checkSetting->exam_marks_show_status = $request->exam_marks_show_status;
            $checkSetting->obtained_marks_show_status = $request->obtained_marks_show_status;
            $checkSetting->percentage_show_status = $request->percentage_show_status;
            $checkSetting->grade_show_status = $request->grade_show_status;
            $checkSetting->class_show_status = $request->class_show_status;
            $checkSetting->section_show_status = $request->section_show_status;
            $checkSetting->roll_no_show_status = $request->roll_no_show_status;
            $checkSetting->shift_show_status = $request->shift_show_status;
            $checkSetting->mother_name_show_status = $request->mother_name_show_status;
            $checkSetting->father_name_show_status = $request->father_name_show_status;
            $checkSetting->failed_show_status = $request->failed_show_status;
            $checkSetting->gpa_show_status = $request->gpa_show_status;
            $checkSetting->group_show_status = $request->group_show_status;
            $checkSetting->session_show_status = $request->session_show_status;
            $checkSetting->bottom_logo_show_status = $request->bottom_logo_show_status;
            $checkSetting->bottom_logo = $imageName;
            $checkSetting->pdf_type = $request->pdf_type;
            $checkSetting->signature_show_status_for_public = $request->signature_show_status_for_public;
            $checkSetting->save();

            return Response::json(['message' => 'Settings Update Succesfully']);
        } else {
            $resultSetting = new SiteExamResultReportSetting;
            $imageName = null;

            if ($request->bottom_logo) {
                $image = $request->bottom_logo;
                $extension = explode('/', explode(';', $image)[0])[1];
                $imageName = time() . "." . $extension;
                Image::make($image)->save(public_path('uploads/') . $imageName);
            }

            $resultSetting->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
            $resultSetting->site_address_show_status = $request->site_address_show_status;
            $resultSetting->exam_type_show_status = $request->exam_type_show_status;
            $resultSetting->std_image_show_status = $request->std_image_show_status;
            $resultSetting->qrcode_show_status = $request->qrcode_show_status;
            $resultSetting->merit_list_show_status = $request->merit_list_show_status;
            $resultSetting->section_wise_highest_mark_show_status = $request->section_wise_highest_mark_show_status;
            $resultSetting->academic_perform_show_status = $request->academic_perform_show_status;
            $resultSetting->head_signature_show_status = $request->head_signature_show_status;
            $resultSetting->countable_mark_show_status = $request->countable_mark_show_status;
            $resultSetting->row_mark_show_status = $request->row_mark_show_status;
            $resultSetting->mark_percentage_show_status = $request->mark_percentage_show_status;
            $resultSetting->left_designation = $request->left_designation;
            $resultSetting->center_designation = $request->center_designation;
            $resultSetting->right_designation = $request->right_designation;
            $resultSetting->sheet_no = $request->sheet_no;
            $resultSetting->combine_result_sheet_no = $request->combine_result_sheet_no;
            $resultSetting->behaviour_show_status = $request->behaviour_show_status;
            $resultSetting->curriculam_activities_show_status = $request->curriculam_activities_show_status;
            $resultSetting->comment_show_status = $request->comment_show_status;
            $resultSetting->exam_marks_show_status = $request->exam_marks_show_status;
            $resultSetting->obtained_marks_show_status = $request->obtained_marks_show_status;
            $resultSetting->percentage_show_status = $request->percentage_show_status;
            $resultSetting->grade_show_status = $request->grade_show_status;
            $resultSetting->class_show_status = $request->class_show_status;
            $resultSetting->section_show_status = $request->section_show_status;
            $resultSetting->roll_no_show_status = $request->roll_no_show_status;
            $resultSetting->shift_show_status = $request->shift_show_status;
            $resultSetting->mother_name_show_status = $request->mother_name_show_status;
            $resultSetting->father_name_show_status = $request->father_name_show_status;
            $resultSetting->failed_show_status = $request->failed_show_status;
            $resultSetting->gpa_show_status = $request->gpa_show_status;
            $resultSetting->group_show_status = $request->group_show_status;
            $resultSetting->session_show_status = $request->session_show_status;
            $resultSetting->bottom_logo_show_status = $request->bottom_logo_show_status;
            $resultSetting->bottom_logo = $imageName;
            $resultSetting->pdf_type = $request->pdf_type;

            $resultSetting->save();

            return Response::json(['message' => 'Settings Saved Successfully']);
        }
    }



    //
    //    public function siteBaseMultipleStudentDetailResultPdfShow($data)
    //    {
    //
    //        try {
    //
    //            $user_id = Auth::user()->id;
    //
    //            $name_split = preg_split("/\-/", $data);
    //
    //            if ($name_split[0] != $user_id) {
    //                return 'You are unauthorized!';
    //            }
    //
    //
    //            if (!file_exists(storage_path('pdf/' . $data))) {
    //
    //                return "The file existed only for 1 day and deleted today!";
    //
    //            }
    //
    //
    //            return response()->file(storage_path('pdf/' . $data));
    //
    //        } catch (Exception $exception) {
    //            return Response::json(['message' => $exception->getMessage()], 410);
    //        }
    //    }

    //================================Tabulation Sheet======================

    private function getStudenthistoryList(Request $request)
    {


        $data = $request->all();
        $studentList = StudentHistory::select('id', 'user_id', 'student_roll_number_prefix', 'student_roll_number', 'site_batch_detail_id')
            ->with([
                'student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id');
                    $q->where('user_type', 'student');
                },
                'year',
                'shift',
                'department',
                'batch',
                'stClass',
                'classGroup',
                'session',
                'section'
            ])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(isset($data['status']), function ($query) use ($data) {
                return $query->where('status', $data['status']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->get();

        //    dd($studentList);
        return $studentList;
    }

    public function getSiteBasePrimaryResultList(Request $request)
    {
        $data = $request->all();
        $studentList = $this->getStudenthistoryList($request);
        $student_ids = $studentList->pluck('id');

        $primary_exam_type_ids = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list = AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->get();


        return $result_primary_type_list;
    }

    public function getSiteBaseStudentSimpleTabulationSheet(Request $request)
    {

        if (!$this->checkSiteGroupResultPermission($request)) {
            return Response::json(['message' => 'You have no permission!'], 401);
        }

        $data = $request->all();

        $studentList = $this->getStudenthistoryList($request);
        //  $studentList->sortByDesc('student_roll_number');

        $student_ids = $studentList->pluck('id');

        $placeholders = implode(',', array_fill(0, count($student_ids), '?'));

        $columns = Schema::getColumnListing('site_student_primary_result_details'); // assuming 'students' is your table name

        //  $columns = array_diff($columns, ['student_rank']);
        $columns = array_diff($columns, []);

        $primary_result_tabulation = SiteStudentPrimaryResultDetailForTabulation::with(['studentHistory' => function ($query) {
            $query->select(
                'id',
                'user_id',
                'academic_shift_id',
                'academic_class_id',
                'academic_department_id',
                'academic_session_id',
                'academic_student_category_id',
                'site_batch_detail_id',
                'academic_class_group_id',
                'academic_section_id',
                'academic_year_id',
                'student_roll_number_prefix',
                'student_roll_number'
            );

            $query->with([
                'student' => function ($q) {
                    $q->select('id');
                    $q->where('user_type', 'student');
                },
                'year',
                'shift',
                'department',
                'stClass',
                'classGroup',
                'session',
                'section',
                'batch'
            ]);
        }, 'academicResultPrimaryType'])
            ->whereIn('student_history_id', $student_ids)
            //    ->where('student_history_id', '71707')
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->orderByRaw("field(student_history_id,{$placeholders})", $student_ids)
            ->select($columns)
            ->get();

        //   return $primary_result_tabulation;

        $getExaminationList = SiteResultPrimarySetting::with(['examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->select('id', 'examination_id')
            ->groupBy('examination_id')
            ->orderBy('show_position')
            ->get();



        if (!count($getExaminationList)) {

                $site_info=SiteInfo::where('id',Session::get('SITE_ID'))->first();

            $getExaminationList = GlobalSiteGroupResultPrimarySettingStore::with(['examination'])
                ->where('academic_version_id', $request->academic_version_id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                // })
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('site_group_id', $site_info->site_group_id)
                ->where('status', true)
                ->get();
        }


        $subject_id_array = [];
        foreach ($primary_result_tabulation as $key => $value) {
            $subject_id_array[] = $value['site_individual_combine_subject_result_store_ids']
                ->pluck('exam_dependent_academic_subject_id')
                ->unique();

            // dd($value);

        }



        $selected_subject_ids = collect($subject_id_array)->collapse()->unique(); //->filter();
        // dd($subject_id_array);
        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', [
            'onlyforexam',
            'forclassandexam',
            'onlyresultshow'
        ])
            ->pluck('id');

        $resultSettingListIds = $getExaminationList->pluck('examination_id');

        $independent_subject_list = SubjectGroupConditionSetting::with([
                'siteSubjectExaminationMark' => function ($que) use ($resultSettingListIds) {
                    $que->whereIn('examination_id', $resultSettingListIds)->orderBy('id')

                        ->with(['siteSubjectExaminationExamTypeMark' => function ($qu) {
                            $qu->with(['academicExamType' => function ($q) {
                                $q->select('id', 'marks_type');
                            }]);
                        }, 'examination']);
                },
                'academicSubjectClassExamCondition',
                'examDependentAcademicSubject'
            ])
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            //z ->whereIn('academic_subject_id', $selected_subject_ids)
            ->whereIn('exam_dependent_academic_subject_id', $selected_subject_ids)
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->orderBy('subject_position')
            ->where('status', true)
            // ->select('id','exam_dependent_academic_subject_id', 'academic_subject_id', 'subject_position', 'academic_subject_condition_ids','exam_dependent_academic_subject_id')
            ->get();
        // ->groupBy('exam_dependent_academic_subject_id');
        $s_array = [];
        $keys = 0;

        foreach ($selected_subject_ids as $key => $id) {

            $induvisial_subject_list = $independent_subject_list->where('exam_dependent_academic_subject_id', $id);
            $induvisial_subject = $induvisial_subject_list->first();

            $s_array[$keys]['dependent_subject_list'] = $induvisial_subject_list;
            $s_array[$keys]['exam_dependent_academic_subject_id'] = $induvisial_subject->exam_dependent_academic_subject_id;
            $s_array[$keys]['subject_name'] = $induvisial_subject->examDependentAcademicSubject->subject_name;
            $s_array[$keys]['count_dependent_subject'] = count($induvisial_subject_list);
            // $s_array[$key]['subject']=$induvisial_subject;
            $keys++;
        }

        $combine_subject_row = (count($independent_subject_list) == count($s_array)) ? 1 : 2;


        ///////////////// this is test /////////
        $subject_array = [];

        foreach ($independent_subject_list as $key => $subject_group_condition) {

            $induvisial_subject_list = $independent_subject_list->where('exam_dependent_academic_subject_id', $subject_group_condition->exam_dependent_academic_subject_id);

            $subject_array[$key]['subject_name'] = $subject_group_condition->subject_name;
            $subject_array[$key]['site_subject_group_condition_setting_id'] = $subject_group_condition->id;
            $subject_array[$key]['academic_subject_id'] = $subject_group_condition->academic_subject_id;
            $subject_array[$key]['exam_dependent_academic_subject_id'] = $subject_group_condition->exam_dependent_academic_subject_id;
            $subject_array[$key]['subject_position'] = $subject_group_condition->subject_position;
        }


        //   return collect($subject_array)->groupBy('exam_dependent_academic_subject_id');

        /////=======sfsf////////////

        $subject_serial = SubjectGroupConditionSetting::with(['academicSubjectClassExamCondition'])
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->whereIn('exam_dependent_academic_subject_id', $selected_subject_ids)
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->orderBy('subject_position')
            ->select('id', 'academic_subject_id', 'academic_subject_condition_ids', 'subject_position', 'exam_dependent_academic_subject_id')
            ->get();

        $dependent_subject = [];
        foreach ($subject_serial as $key => $value) {

            if ($value->academic_subject_id != $value->exam_dependent_academic_subject_id) {
                //  dd($value->academicSubjectConditions);
                foreach ($value->academicSubjectConditions as $keys => $values) {

                    if ($values->condition_key != "religion") {
                        $dependent_subject[] = $value->examination;
                    }
                }
            }
        }


        $final_arr = array();
        $final_array = [];

        foreach ($primary_result_tabulation as $key => $value) {

            $aa_arr = array();
            $test_array = [];
            foreach ($subject_serial as $keys => $values) {

                $check_data = $value['site_individual_combine_subject_result_store_ids']
                    ->where('exam_dependent_academic_subject_id', $values->exam_dependent_academic_subject_id)
                    //  ->whereIn('student_history_id',$student_list_ids)
                    ->first();


                if (!$check_data) {
                    $aa_arr['subject_present'] = 0;
                    $aa_arr['exam_dependent_academic_subject_id'] = $values->exam_dependent_academic_subject_id;
                    $test_array[$keys] = array_merge($aa_arr);
                }
            }
            $final_arr['absent_subject_list'] = collect($test_array)->unique('exam_dependent_academic_subject_id')->values();

            $final_array[$key] = array_merge($final_arr, $value->toArray());
        }



        $final_subject_arr = array();
        $final_subject_array = [];
        $exam_marke_type = [];

        foreach ($independent_subject_list as $key => $value) {

            ////=== colspan for tabulution shirt
            $exam_col_span = 0;
            $exam_type = 0;
            foreach ($value->siteSubjectExaminationMark as $valuesss) {

                foreach ($valuesss->siteSubjectExaminationExamTypeMark as $valuessss) {
                    $exam_col_span++;
                    $exam_type++;
                    $exam_marke_type[] = $valuessss->academicExamType;
                }
            }

            ////=========

            $final_subject_arr['exam_col_span'] = $exam_col_span;
            $final_subject_arr['exam_type'] = $exam_type;


            $check_value = collect($dependent_subject)->where('exam_dependent_academic_subject_id', $value->academic_subject_id);

            if (count($check_value) > 0) {
                $final_subject_arr['dependent_subject_list'] = $check_value;
                $final_subject_arr['count_dependent_subject'] = count($check_value);
            } else {
                $final_subject_arr['dependent_subject_list'] = [];
                $final_subject_arr['count_dependent_subject'] = 0;
            }
            $final_subject_array[$key] = array_merge($final_subject_arr, $value->toArray());
            // dd($final_subject_arr);
        }


        //  $test = collect($exam_marke_type)->sortBy('id','DESC');

        $unique_marke_type = array_unique($exam_marke_type);
        $examTypeIds = collect($unique_marke_type)->pluck('id');

        $final_student_subject_array = collect($final_array);

        //  SiteResultPrimarySetting::

        $exam_type_serial = SiteExaminationExamTypeSetting::with('academicExamType')
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->whereIn('academic_exam_type_id', $examTypeIds)
            ->whereIn('examination_id', $resultSettingListIds)
            ->orderBy('position_show')
            ->get();
        //  dd($resultSettingListIds);

        $examTypeArray = [];
        $key = 0;
        foreach ($exam_type_serial as $item) {
            $examTypeArray[$key]['id'] = $item->academicExamType ? $item->academicExamType->id : '';
            $examTypeArray[$key]['marks_type'] = $item->academicExamType ? $item->academicExamType->marks_type : '';
            $key++;
        }
        $mark_type_array = collect($examTypeArray)->filter()->unique();

        $markTypeArray = [];
        $keys = 0;
        foreach ($mark_type_array as $items) {
            $markTypeArray[$keys]['id'] = $items['id'];
            $markTypeArray[$keys]['marks_type'] = $items['marks_type'];
            $keys++;
        }

        $site_info = SiteInfo::where('id', Session::get('SITE_ID'))->first();
        $primary_result = AcademicResultPrimaryType::where('id', $request->academic_result_primary_type_id)->first();
        $academic_class = AcademicClass::where('id', $request->academic_class_id)->first();
        $academic_shift = AcademicShift::where('id', $request->academic_shift_id)->first();
        $academic_year = AcademicYear::where('id', $request->academic_year_id)->first();

        $site_name = $site_info->site_name;
        $result_name = $primary_result->name;
        $class_name = $academic_class->class_name;
        $shift_name = $academic_shift->shift_name;
        $year_name = $academic_year->year_name;

        $sheet_info = [
            'site_name' => $site_name,
            'result_name' => $result_name,
            'class_name' => $class_name,
            'shift_name' => $shift_name,
            'year_name' => $year_name,
        ];
        // dd($markTypeArray);


        return [$final_student_subject_array, $s_array, $getExaminationList, $markTypeArray, $combine_subject_row, $sheet_info];
    }

    public function getSiteBaseStudentSimpleTabulationSheetPdf(Request $request)
    {
        $data = $request->all();
        $tabulation_array = $this->getSiteBaseStudentSimpleTabulationSheet($request);
        //  return $tabulation_array;
        $primary_result_tabulation = $tabulation_array[0];
        $final_subject_array = $tabulation_array[1];
        $examinationList = $tabulation_array[2];
        $exam_type_list = $tabulation_array[3];
        $combine_subject_row = $tabulation_array[4];
        //  dd($combine_subject_row);

        $result_name = $primary_result_tabulation[0]['academic_result_primary_type']['name'];
        ////////////////
        // $report_tittle2 = '';


        // $report_tittle2 .= '<b>Version:</b>' . ($student_history[0]['version_name'] ?? 'n/a');
        // $report_tittle2 .= '<b> Year:</b>' . ($student_history[0]['year_name'] ?? 'n/a');
        // $report_tittle2 .= ' <b> Shift:</b>' . ($student_history[0]['shift_name'] ?? 'n/a');

        // if ($data['academic_department_id']) {
        //     $report_tittle2 .= ' <b>Dept:</b>' . ($student_history[0]['department_name'] ?? 'n/a');
        // }

        // if ($data['academic_class_id']) {
        //     $report_tittle2 .= ' <b>Class:</b>' . ($student_history[0]['class_name'] ?? 'n/a');
        // }

        // if ($data['academic_class_group_id']) {
        //     $report_tittle2 .= ' <b>Group:</b>' . ($student_history[0]['group_name'] ?? 'n/a');
        // }

        // if ($data['academic_section_id']) {
        //     $report_tittle2 .= ' <b>Section:</b>' . ($student_history[0]['section_name'] ?? 'n/a');
        // }


        ////////////////
        $report_tittle = "";
        $report_tittle .= $result_name;
        $report_tittle .= " ";
        $report_tittle .= "Tabulation Sheet";


        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . ($primary_result_tabulation[0]['student_history']['year']['year_name'] ?? '');
        $report_tittle2 .= " <b>Shift: </b>" . ($primary_result_tabulation[0]['student_history']['shift']['shift_name'] ?? '');


        // $report_tittle .= "<br>";
      
        if ($request->academic_department_id) {
            $department=AcademicDepartment::where('id',$request->academic_department_id)->first();
            $report_tittle2 .= "<b> Dept: </b>". ($department?$department->name:'');
        }

        if ($request->academic_class_id) {
            $class=AcademicClass::where('id',$request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>". ($class?$class->class_name:'');
        }

     
         if ($request->academic_class_group_id) {
            $group=AcademicClassGroup::where('id',$request->academic_class_group_id)->first();
            $report_tittle2 .= "<b> Group: </b>". ($group?$group->group_name:'');
        }

        if ($request->academic_section_id) {
            $section=AcademicSection::where('id',$request->academic_section_id)->first();
            $report_tittle2 .= "<b> Section: </b>". ($section?$section->section_name:'');
        }
        if ($request->academic_session_id) {
            $session=AcademicSession::where('id',$request->academic_session_id)->first();
            $report_tittle2 .= "<b> Session: </b>". ($session?$session->session_name:'');
        }

    

        if ($request->tabulation_type == 'simple') {
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-student-result-tabulation-sheet-report-one',
                compact('primary_result_tabulation', 'report_tittle', 'report_tittle2', 'final_subject_array', 'combine_subject_row', 'examinationList', 'result_name')
            )
                ->setPaper('a4', 'landscape')->setWarnings(false);
        }
        if ($request->tabulation_type == 'advance') {

            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-student-result-tabulation-sheet-report-two',
                compact('primary_result_tabulation', 'report_tittle', 'report_tittle2', 'final_subject_array', 'combine_subject_row', 'examinationList', 'result_name', 'exam_type_list')
            )
                ->setPaper('a4', 'landscape')->setWarnings(false);
        }

        // $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-student-result-tabulation-sheet-report',
        //     compact('primary_result_tabulation', 'report_tittle', 'report_tittle2', 'final_subject_array', 'examinationList', 'result_name'))
        //     ->setPaper('a4', 'landscape')->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }


    //=========================Tabulation Sheet Two====================

    public function getSiteBaseStudentTabulationTwoSheet(Request $request)
    {

        $data = $request->all();

        $student_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->orderBy('student_roll_number')
            ->pluck('id');

        $placeholders = implode(',', array_fill(0, count($student_ids), '?'));

        $dataaa = SiteStudentPrimaryResultDetail::with(['studentHistory' => function ($query) {
            $query->select(
                'id',
                'user_id',
                'academic_shift_id',
                'academic_class_id',
                'academic_department_id',
                'academic_session_id',
                'academic_student_category_id',
                'board_registration_number',
                'academic_class_group_id',
                'academic_section_id',
                'academic_year_id',
                'student_roll_number_prefix',
                'student_roll_number',
                'registration_no',
                'fail_subject_count'
            );
            $query->with([
                'student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id');
                    $q->where('user_type', 'student');
                },
                'year',
                'shift',
                'department',
                'stClass',
                'classGroup',
                'session',
                'section'
            ]);
        }, 'academicResultPrimaryType'])
            ->whereIn('student_history_id', $student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->orderByRaw("field(student_history_id,{$placeholders})", $student_ids)
            ->get();

        $subject_id_array = [];
        foreach ($dataaa as $key => $value) {


            $subject_id_array[] = $value['site_individual_combine_subject_result_store_ids']
                ->pluck('exam_dependent_academic_subject_id');
        }

        $selected_subject_ids = collect($subject_id_array)->collapse()->unique()->filter()->values();

        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam', 'onlyresultshow'])
            ->pluck('id');

        $independent_subject_list = SubjectGroupConditionSetting::with(['academicSubjectClassExamCondition'])
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->whereIn('academic_subject_id', $selected_subject_ids)
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->orderBy('subject_position')
            ->select('id', 'academic_subject_id', 'subject_position', 'academic_subject_condition_ids')
            ->get();


        $subject_serial = SubjectGroupConditionSetting::with(['academicSubjectClassExamCondition'])
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->whereIn('exam_dependent_academic_subject_id', $selected_subject_ids)
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->orderBy('subject_position')
            ->select('id', 'academic_subject_id', 'academic_subject_condition_ids', 'subject_position', 'exam_dependent_academic_subject_id')
            ->get();


        //        return $subject_serial;

        $dependent_subject = [];
        foreach ($subject_serial as $key => $value) {

            if ($value->academic_subject_id != $value->exam_dependent_academic_subject_id) {

                foreach ($value->academicSubjectConditions as $keys => $values) {

                    if ($values->condition_key != "religion") {
                        $dependent_subject[] = $value;
                    }
                }
            }
        }


        $final_subject_arr = array();
        $final_subject_array = [];
        foreach ($independent_subject_list as $key => $value) {


            $check_value = collect($dependent_subject)->where('exam_dependent_academic_subject_id', $value->academic_subject_id);

            if (count($check_value) > 0) {
                $final_subject_arr['dependent_subject_list'] = $check_value;
                $final_subject_arr['count_dependent_subject'] = count($check_value);
            } else {
                $final_subject_arr['dependent_subject_list'] = [];
                $final_subject_arr['count_dependent_subject'] = 0;
            }


            $final_subject_array[$key] = array_merge($final_subject_arr, $value->toArray());
        }



        $getExaminationList = SiteResultPrimarySetting::with(['examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->select('id', 'examination_id')
            ->orderBy('show_position')
            ->get();

        $term_exam_count =  $getExaminationList->where('examination.name_key', 'termexam')->pluck('examination_id')->unique()->count();
        $class_test_count =  $getExaminationList->where('examination.name_key', 'classtest')->pluck('examination_id')->unique()->count();


        $a_arr = array();
        $final_array = [];
        foreach ($dataaa as $key => $value) {

            $b_array = [];
            foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet) {

                $b_array[] = $valuet->subject_detail;
            }

            $subject_ids = collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
            $result_show_in_table_bellow_status_present = collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();



            //            $highest_marks_list=collect($hight_marks_list)->whereIn('exam_dependent_academic_subject_id', $subject_ids);

            $a_arr['academic_result_primary_type_id'] = $value->academic_result_primary_type_id;
            $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
            $a_arr['student_history_id'] = $value->student_history_id;
            $a_arr['fail_subject_count'] = $value->fail_subject_count;
            $a_arr['gpa'] = $value->gpa;
            $a_arr['grade'] = $value->grade;
            $a_arr['student_rank'] = $value->student_rank;
            $a_arr['site_result_primary_setting_id'] = $value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id'] = $value->academic_result_primary_type_id;
            $a_arr['subject_list'] = $b_array;
            $a_arr['table_header'] = $value->table_header;
            //            $a_arr['highest_marks']=$highest_marks_list;
            $a_arr['student_history'] = $value->studentHistory;

            $a_arr['student_photo'] = $value->studentHistory->student ? $value->studentHistory->student->latestPhoto ?
                $value->studentHistory->student->latestPhoto->name : 'image-not.png' : 'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present'] = count($result_show_in_table_bellow_status_present) > 0 ? 1 : 0;


            $a_arr['classtest_is_present'] = $value->classtest_is_present;
            $a_arr['combine_subject_present'] = $value->combine_subject_present;
            $a_arr['final_grade_without_optional'] = $value->final_grade_without_optional;
            $a_arr['final_point_without_optional'] = $value->final_point_without_optional;
            $a_arr['id'] = $value->id;
            $a_arr['raw_obtain_marks_percentage'] = number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
            $a_arr['sum_of_obtain_percent_total_marks'] = $value->sum_of_obtain_percent_total_marks;
            $a_arr['sum_of_obtain_raw_total_marks'] = $value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_raw_total_marks'] = $value->sum_of_raw_total_marks;
            // $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
            // $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;

            //            optional_subject_ids

            $final_array[$key] = array_merge($a_arr);
        }


        $final_arr = array();
        $subject_student_array = [];
        foreach ($final_array as $key => $value) {

            $aa_arr = array();
            $test_array = [];
            foreach ($subject_serial as $keys => $values) {

                $subject_dependent_count = collect($value['subject_list'])
                    ->where('exam_dependent_academic_subject_id', $values->exam_dependent_academic_subject_id)
                    ->sum('subject_count');

                $check_data = collect($value['subject_list'])
                    ->where('exam_dependent_academic_subject_id', $values->exam_dependent_academic_subject_id)->count();

                if ($check_data == 0) {
                    $aa_arr['subject_present'] = 0;
                    $aa_arr['exam_dependent_academic_subject_id'] = $values->exam_dependent_academic_subject_id;
                    $aa_arr['subject_dependent_count'] = $subject_dependent_count;

                    $test_array[$keys] = array_merge($aa_arr);
                }
            }
            $final_arr['absent_subject_list'] = $test_array;

            $subject_student_array[$key] = array_merge($final_arr, collect($value)->toArray());
        }

        $data = $request->all();
        $siteResultSystemSettingPresent = SiteResultSystemSetting::with(['academicResultSystem'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get()
            ->sortBy(function ($item) {
                return $item->academicResultSystem->serial ?? 0;
            });

        //        return collect(collect($subject_student_array[0])['table_header']);
        //for Percentage
        $marks_percentage_count = collect(collect($subject_student_array[0])['table_header'])
            ->where('marks_percentage', '>', 0)
            ->where('marks_percentage', '<', 100)
            ->count();


        //for Exam type
        $count_sum_of_exam_type_single = collect(collect($subject_student_array[0])['table_header'])
            ->sum('academic_exam_type_count');


        // for Obt
        $count_sum_of_exam_type_multiple = collect(collect($subject_student_array[0])['table_header'])
            ->where('academic_exam_type_count', '>', 1)
            ->count();

        // for examination type
        $count_examination = collect(collect($subject_student_array[0])['table_header'])->count();

        // for term exam count
        $count_term_exam = $term_exam_count > 1 ? 2 : 0;

        // for Class Test count
        $count_class_test = $class_test_count > 1 ? 2 : 0;

        $last_count = 0;
        if ($count_examination == 1 && $count_sum_of_exam_type_single == 3) {
            $last_count = 1;
        } else if ($count_examination == 1 && $count_sum_of_exam_type_single == 4) {
            $last_count = 2;
        } else if ($count_examination == 1 && $count_sum_of_exam_type_single == 5) {
            $last_count = 3;
        }


        //return $row_span_count_value;
        $row_span_count_value = $marks_percentage_count + $count_sum_of_exam_type_single
            + $count_sum_of_exam_type_multiple * 2 + ($count_examination > 1 ? $count_examination * 2 : 0) +
            $count_term_exam +
            $count_class_test + ($count_examination > 1 ? 2 : 3) + 2 + $last_count;

        // for dependent subject count type
        $count_dependent_subject_sum = collect($final_subject_array)
            ->where('count_dependent_subject', '>', 0)->sum('count_dependent_subject');

        $count_row_span = $count_dependent_subject_sum + count($final_subject_array) +
            ($count_examination > 1 ? 1 : 0) + 1;

        // return '$subject_student_array';

        return compact(
            'subject_student_array',
            'final_subject_array',
            'siteResultSystemSettingPresent',
            'term_exam_count',
            'class_test_count',
            'row_span_count_value',
            'marks_percentage_count',
            'count_sum_of_exam_type_single',
            'count_sum_of_exam_type_multiple',
            'count_examination',
            'count_term_exam',
            'count_class_test',
            'count_row_span'
        );
    }
}
