<?php

namespace App\Http\Controllers\Site\Result;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject; ///test
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Employee\Employee;

use App\Models\Academic\AcademicClassGroup;
use App\Models\AcademicYear\AcademicYear;
use App\Http\Controllers\ProjectController;

use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use Exception;

use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicClass;

use Auth;
use PDF;
use Response;
use Illuminate\Support\facades\Http;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use Session;

class SiteResultSendController extends ProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Site Result Report SMS';

        return view('default.admin.layouts.master', compact('viewType'));

    }
    
    private function getStudenthistoryList(Request $request){
      
        
        $data = $request->all();
        $studentList = StudentHistory::select('id', 'user_id','student_roll_number','site_batch_detail_id')
            ->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','batch','stClass','classGroup','session','section'
            ])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status',true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->get();

    //    dd($studentList);
        return $studentList;
    
    }

    
    public function getSiteBasePrimaryResultListForSms(Request $request){

        $studentList=$this->getStudenthistoryList($request);
        $student_ids=$studentList->pluck('id');

        $primary_exam_type_ids=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->get();

        return $result_primary_type_list;

    }



    public function getSiteBaseStudentResultListForSms(Request $request){
        $data = $request->all();

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }

        $studentList=$this->getStudenthistoryList($request);
      //  $studentList->sortByDesc('student_roll_number');

        $student_ids=$studentList->pluck('id');
      
        $placeholders = implode(',',array_fill(0, count($student_ids), '?'));


        $primary_result_tabulation=SiteStudentPrimaryResultDetailForTabulation::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id',
                'site_batch_detail_id', 'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number');

            // $query->with(['student' => function ($q) {
            //     $q->select('id');
            //     $q->where('user_type', 'student');
            // },
            //     'year', 'shift','department','stClass','classGroup','session','section','batch'
            // ]);
        }])
            ->select('student_history_id','academic_result_primary_type_id','gpa','grade','exam_attendance_status',
        'final_point_without_optional','final_grade_without_optional','sum_of_obtain_raw_total_marks','fail_subject_count',
        'student_rank','sum_of_obtain_total_percent_for_show','total_marks_base_percentage',
        'sum_of_obtain_total_marks_for_show')
            ->whereIn('student_history_id', $student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->orderByRaw("field(student_history_id,{$placeholders})", $student_ids)
            ->get();

            $result_list=[];

            foreach($primary_result_tabulation as $key=>$item){

                $result_list[$key]['student_history_id']=$item->student_history_id;
                $result_list[$key]['full_name']=$item->studentHistory->full_name;
                $result_list[$key]['student_full_roll_number']=$item->studentHistory->student_full_roll_number;
                $result_list[$key]['phone']=$item->studentHistory?$item->studentHistory->student->contact_number:'';
                $result_list[$key]['father_contact_number']=$item->studentHistory?$item->studentHistory->student->father_contact_number:'';
                $result_list[$key]['mother_contact_number']=$item->studentHistory?$item->studentHistory->student->mother_contact_number:'';
                $result_list[$key]['exam_attendance_status']=$item->exam_attendance_status;
                $result_list[$key]['gpa']=$item->gpa;
                $result_list[$key]['grade']=$item->grade;
                $result_list[$key]['rank']=$item->student_rank;
              
                $result_list[$key]['total_marks_percentage']=$item->total_marks_base_percentage;
                $result_list[$key]['total_mark']=$item->sum_of_obtain_total_marks_for_show;
                $result_list[$key]['mark_percent']=$item->sum_of_obtain_total_percent_for_show;
              
                $result_list[$key]['select_student']=false;
                $result_list[$key]['select_gpa']=false;
                $result_list[$key]['select_grade']=false;
                $result_list[$key]['select_rank']=false;
                $result_list[$key]['select_total_marks_percentage']=false;
                $result_list[$key]['select_total_mark']=false;
                $result_list[$key]['select_mark_percent']=false;
            //    dd($item);
            }


        return $result_list;

    }

    public function resultSendToSingleStudent(Request $request){

    //    dd($request->all());
        $data=$request->all();

        $academic_year = AcademicYear::find($data['academic_year_id']);
        $academic_class_group = AcademicClassGroup::find($data['academic_class_group_id']);
        $site_info = SiteInfo::find(Session::get('SITE_ID'));
        $site_id = Session::get('SITE_ID');
        $academic_class=AcademicClass::find($data['academic_class_id']);
        $result_type=AcademicResultPrimaryType::find($data['academic_result_primary_type_id']);

        $academic_year=$academic_year?$academic_year->year_name:'';
        $academic_class_group=$academic_class_group?$academic_class_group->group_name:'';
        $site_name=$site_info?$site_info->site_name:'';
        $short_name=$site_info?$site_info->translate('en')->short_name:'';
        $site_alias=$site_info?$site_info->site_alias:'';
        $class=$academic_class?$academic_class->class_name:'';
        $result_name=$result_type?$result_type->name:'';

        $phone=$data['single_student_data']['phone'];


     
        if($data['single_student_data']['select_student']){
            $text="";
            $text .= 'Year:'.$academic_year;
            $text .= ', '.'Group:'.$academic_class_group;
            $text .= ', '.'Class:'.$class;
            $text .= ', '.'Name:'.$data['single_student_data']['full_name']; 
            $text .= ', '.'Roll:'.$data['single_student_data']['student_full_roll_number']; 
            $text .= ', '.'Result:'.$result_name;

            if($data['single_student_data']['select_gpa']){
                $text .= ', '.'GPA:'.$data['single_student_data']['gpa'];
            }
            if($data['single_student_data']['select_grade']){
                $text .= ', '.'Grade:'.$data['single_student_data']['grade'];
            }
            if($data['single_student_data']['select_total_mark']){
                $text .= ', '.'Total Mark:'.$data['single_student_data']['total_mark'];
            }
            $text .= ', '.'Thanks: '.$site_alias;

          
            
          $sms_status = $this->sendSms($site_id, [$phone], $text);

            if($sms_status){
                return response()->json(['message'=>'Message Send Successfully', 'status'=>'success'],200);
           }else{
            return response()->json(['message'=>'send message error', 'status'=>'error'],401);
           }

        }else{
          return response()->json(['message'=>'Select Student', 'status'=>'error'],401);
        }

    }

    public function resultSendToMultipleStudent(Request $requests){
        $data=$requests->all();
     //  dd($data);

        
        $academic_year = AcademicYear::find($data['academic_year_id']);
        $academic_class_group = AcademicClassGroup::find($data['academic_class_group_id']);
        $site_info = SiteInfo::find(Session::get('SITE_ID'));
        $site_id = Session::get('SITE_ID');
        $academic_class=AcademicClass::find($data['academic_class_id']);
        $result_type=AcademicResultPrimaryType::find($data['academic_result_primary_type_id']);

        $academic_year=$academic_year?$academic_year->year_name:'';
        $academic_class_group=$academic_class_group?$academic_class_group->group_name:'';
        $site_name=$site_info?$site_info->site_name:'';
        $short_name=$site_info?$site_info->translate('en')->short_name:'';
        $class=$academic_class?$academic_class->class_name:'';
        $result_name=$result_type?$result_type->name:'';

       // $phone=$data['single_student_data']['phone'];


     

        $total_send_sms=0;
        $total_success_sms=0;
        $total_fail_sms=0;

        foreach($data['StudentResultList'] as $student){

            if($student['select_student']){

                $text="";
                $text .= 'Year:'.$academic_year;
                $text .= ', '.'Group:'.$academic_class_group;
                $text .= ', '.'Class:'.$class;
                $text .= ', '.'Name:'.$student['full_name']; 
                $text .= ', '.'Roll:'.$student['student_full_roll_number']; 
                $text .= ', '.'Result:'.$result_name;

                if($student['select_gpa']){
                    $text .= ', '.'GPA:'.$student['gpa'];
                }
                if($student['select_grade']){
                    $text .= ', '.'Grade:'.$student['grade'];
                }
                if($student['select_total_mark']){
                    $text .= ', '.'Total Mark:'.$student['total_mark'];
                }
                $text .= ', '.'Thanks: '.$short_name;
    
                $phone=$student['phone'];

                $sms_status = $this->sendSms($site_id, [$phone], $text);
                if($sms_status){
                    $total_success_sms++;
                }else{
                    $total_fail_sms++;
                }
                $total_send_sms++;
            }
        }

        return response()->json(['message'=>'Total SMS '.$total_send_sms.' Success '.$total_success_sms.' Fail '.$total_fail_sms, 'status'=>'error'],200);

        


    }

}
