<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/3/2016
 * Time: 3:21 PM
 */

namespace App\Http\Controllers\Site\Routine;

use App\Http\Controllers\ProjectController;
use App\Http\Requests;
use App\Models\Academic\AcademicSubject;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Routine\EmployeeWeeklyClass;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Traits\Site\Routine\RoutineFunction;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Response;
use Session;

class RoutineController extends ProjectController
{
    use RoutineFunction;


    private $routineDetail;
    private $academicSubject;
    private $employee;
    private $employeeWeeklyClass;

    /**
     * @param Routine $routine
     */
    public function __construct(RoutineDetail $routineDetail, AcademicSubject $academicSubject, Employee $employee, EmployeeWeeklyClass $employeeWeeklyClass)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->routineDetail = $routineDetail;
        $this->academicSubject = $academicSubject;
        $this->employee = $employee;
        $this->employeeWeeklyClass = $employeeWeeklyClass;

    }


    public function index()
    {

        $viewType = 'Routine Master View';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.routine.routine-master', compact('viewType'));
    }


    public function getEmployeeWeeklyClassList(Request $request)
    {
        try {

            $search_txt = $request->search_txt;
            $paginate = $request->paginate;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';


            $data = $this->employee
                ->whereHas('activeHistory')
                // ->whereHas('empWeeklyClass')
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($q) use ($txt) {
                        $q->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })
                ->select('id', 'username', 'email')
                ->paginate($paginate);


            if (count($data) < 1) {
                throw new Error("No Teacher Found Associated With: " . Session::get('ACADEMIC_GROUP_NAME') . ". Assign Teacher To Shift First");
            }

            return response()->json($data, 200);


        } catch (Exception $exception) {
            throw  new  Error($exception->getMessage());

        }
    }

    public function saveEmployeeWeeklyClass(Request $request)
    {
        try {
            // \Log::info($request);

            $weekly_class = $this->employeeWeeklyClass->where('user_id', $request->id)->first();

            if ($weekly_class) {
                $weekly_class->weekly_class = $request->weekly_class;

            } else {
                $weekly_class = new EmployeeWeeklyClass();
                $weekly_class->user_id = $request->id;
                $weekly_class->weekly_class = $request->weekly_class;
            }

            if ($weekly_class->save()) {
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }


    /// Activation


    public function getRoutineActivation(Request $request)
    {

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_period_type_id'] = $request->academic_period_type_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_period_type_id']) {
            throw new Error('Please Select Version || Year || Period Type!');
        }


        $get_routine_details = $this->routineDetail
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('academic_period_type_id', $data['academic_period_type_id'])
            ->groupBy('academic_department_id', 'academic_class_id', 'academic_section_id', 'academic_class_group_id', 'academic_period_type_id')
            ->get();

        $total_period = "Total: <b>" . count($get_routine_details) . "</b>";
        $main_heading = "Details Report";

        if (!$total_period) {
            throw new Error('No Details Found!');
        }

        $final_list = [];

        foreach ($get_routine_details as $k => $v) {

            $title = "<b>Year: </b>" . ($v->academicYear->year_name ?? '');
            $title .= " <b>Shift: </b>" . ($v->academicShift->shift_name ?? '');
            $title .= "  <b> Period Type: </b>" . ($v->academicPeriodType->type_name ?? '');

            if ($v->dept) {
                $title .= "<b> Dept: </b>" . $v->dept->name;
            }

            if ($v->academicClass) {
                $title .= "  <b> Class: </b>" . ($v->academicClass->class_name ?? '');
            }

            if ($v->classGroup) {
                $title .= "<b> Group: </b>" . ($v->classGroup->group_name ?? '');
            }

            if ($v->academicSection) {
                $title .= "<b> Section: </b>" . ($v->academicSection->section_name ?? '');
            }

            if ($v->academicSession) {
                $title .= "<b> Session: </b>" . ($v->academicSession->session_name ?? '');
            }

            $final_list[$k]['id'] = $v->id;
            $final_list[$k]['heading'] = $title;
            $final_list[$k]['periods'] = $this->getTotalNonBreakPeriods($v->id) . " Periods";
            $final_list[$k]['status'] = $v->status;

        }

        return Response::json([$final_list, $total_period, $main_heading], 200);

    }


    public function getTotalNonBreakPeriods($id)
    {

        $total = 0;

        $the_routine = $this->routineDetail->findOrFail($id);

        $data = [];
        $data['academic_version_id'] = $the_routine->academic_version_id;
        $data['academic_year_id'] = $the_routine->academic_year_id;
        $data['academic_department_id'] = $the_routine->academic_department_id;
        $data['academic_class_id'] = $the_routine->academic_class_id;
        $data['academic_section_id'] = $the_routine->academic_section_id;
        $data['academic_shift_id'] = $the_routine->academic_shift_id;
        $data['academic_class_group_id'] = $the_routine->academic_class_group_id;
        $data['academic_period_type_id'] = $the_routine->academic_period_type_id;
        $data['academic_session_id'] = $the_routine->academic_session_id;


        $get_routine_details = $this->routineDetail
            ->where('is_break', false)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->where('academic_section_id', $data['academic_section_id'])
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->where('academic_period_type_id', $data['academic_period_type_id'])
            ->count();

        return $get_routine_details;


    }

    public function saveRoutineActivation(Request $request)
    {

        if (count($request->finalSlotList) < 1) {
            throw new  Error("Please Select At  Least One Slot");
        }

        foreach ($request->finalSlotList as $k => $value) {

            $slot_id = $value['id'];
            $status = $value['status'] ? true : false;

            $the_routine = $this->routineDetail->findOrFail($slot_id);

            $data = [];
            $data['academic_version_id'] = $the_routine->academic_version_id;
            $data['academic_year_id'] = $the_routine->academic_year_id;
            $data['academic_department_id'] = $the_routine->academic_department_id;
            $data['academic_class_id'] = $the_routine->academic_class_id;
            $data['academic_section_id'] = $the_routine->academic_section_id;
            $data['academic_shift_id'] = $the_routine->academic_shift_id;
            $data['academic_class_group_id'] = $the_routine->academic_class_group_id;
            $data['academic_period_type_id'] = $the_routine->academic_period_type_id;
            $data['academic_session_id'] = $the_routine->academic_session_id;


            $values = array('status' => $status);
            // ItemTable::whereIn('primary_key','value')->update($values);

            $get_routine_details = $this->routineDetail
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->update($values);
        }
        return Response::json(['mode' => 'success', 'message' => 'Successfully Updated!', $request->finalSlotList], 200);
    }


    public function copyPasteRoutine(Request $request)
    {
        //try {


        $from_form_data = $this->getDataArray($request->copyFromForm);
        $to_form_data = $this->getDataArray($request->copyToForm);


        if (!$from_form_data['academic_period_type_id'] || !$to_form_data['academic_period_type_id']) {
            throw new  Error("Please Select Period Type!");

        }

        // $this->checkClassSection($from_form_data);
        $this->checkClassSection($to_form_data);

        if (($from_form_data['academic_class_id'] != $to_form_data['academic_class_id'])) {
            throw new  Error("From Class & To Class Must Be Same!");
        }


        $check_to_form_exist = $this->routineDetail
            ->where('academic_version_id', $to_form_data['academic_version_id'])
            ->where('academic_year_id', $to_form_data['academic_year_id'])
            ->where('academic_class_id', $to_form_data['academic_class_id'])
            ->where('academic_section_id', $to_form_data['academic_section_id'])
            ->where('academic_period_type_id', $to_form_data['academic_period_type_id'])
            ->when($to_form_data['academic_shift_id'], function ($query) use ($to_form_data) {
                return $query->where('academic_shift_id', $to_form_data['academic_shift_id']);
            })->when($to_form_data['academic_session_id'], function ($query) use ($to_form_data) {
                return $query->where('academic_session_id', $to_form_data['academic_session_id']);
            })->when($to_form_data['academic_department_id'], function ($query) use ($to_form_data) {
                return $query->where('academic_department_id', $to_form_data['academic_department_id']);
            })
            ->when($to_form_data['academic_class_group_id'], function ($query) use ($to_form_data) {
                return $query->where('academic_class_group_id', $to_form_data['academic_class_group_id']);
            })->first();

        if ($check_to_form_exist) {

            $issue = new    IssueDetail();
            $issue->issue_type = 'routine';
            $issue->issuer_type = 'site';
            $issue->issue_details = "To Details Exists! " . json_encode($to_form_data);
            $issue->site_id = $check_to_form_exist->site_id;
            $issue->save();

            throw new  Error("To Details Exists! " . json_encode($to_form_data));

        }


        $get_from_routine_details = $this->routineDetail
            ->where('academic_version_id', $from_form_data['academic_version_id'])
            ->where('academic_year_id', $from_form_data['academic_year_id'])
            ->when($from_form_data['academic_shift_id'], function ($query) use ($from_form_data) {
                return $query->where('academic_shift_id', $from_form_data['academic_shift_id']);
            })->when($from_form_data['academic_department_id'], function ($query) use ($from_form_data) {
                return $query->where('academic_department_id', $from_form_data['academic_department_id']);
            })
            ->where('academic_class_id', $from_form_data['academic_class_id'])
            ->where('academic_section_id', $from_form_data['academic_section_id'])
            ->when($from_form_data['academic_class_group_id'], function ($query) use ($from_form_data) {
                return $query->where('academic_class_group_id', $from_form_data['academic_class_group_id']);
            })
            ->when($from_form_data['academic_session_id'], function ($query) use ($from_form_data) {
                return $query->where('academic_session_id', $from_form_data['academic_session_id']);
            })
            ->where('academic_period_type_id', $from_form_data['academic_period_type_id'])
            ->orderBy('start_time', 'ASC')
            ->pluck('id');


        foreach ($get_from_routine_details as $k => $id) {

            $the_detail = $this->routineDetail->find($id);
            $the_detail->load('routineAllocations');
            $new_detail = $the_detail->replicate();

            $new_detail->push();
            $new_detail->save();


            foreach ($the_detail->copyFields as $k1 => $field) {
                if ($to_form_data[$field]) {
                    $new_detail->{$field} = $to_form_data[$field];
                }
            }

            $new_detail->save();


            if ($request->subject || $request->teacher || $request->room) {
                foreach ($the_detail->getRelations() as $relation => $items) {
                    foreach ($items as $item) {
                        unset($item->id);
                        $new_detail->{$relation}()->create($item->toArray());
                    }
                }
            }

            $new_detail = $this->routineDetail->find($new_detail->id);


            if (!$request->subject && count($new_detail->routineAllocations)) {

                $values = array('subject_id' => 0);
                $new_detail->routineAllocations->update($values);
            }
            if (!$request->teacher && count($new_detail->routineAllocations)) {

                $values = array('employee_id' => 0);
                $new_detail->routineAllocations()->update($values);
            }
            if (!$request->room && count($new_detail->routineAllocations)) {

                $values = array('room_id' => 0);
                $new_detail->routineAllocations()->update($values);
            }
        }

        return response()->json(['message' => "Successfully Copied " . count($get_from_routine_details) . " Rows!"], 200);


        /*} catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }*/
    }


}