<?php

namespace App\Http\Controllers\Site;

use App\Models\Modules\Module;
use App\Models\Package\EduPackage;
use App\Models\Site\Permission\GlobalSiteRoleAccess;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\SiteInfo;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class SiteAccessController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return JsonResponse
     */
    public function getAssignedListForTheSite()
    {

        try {

            $site_id = Session::get('SITE_ID');
            $site_info = SiteInfo::findOrFail($site_id) ?? [];
            $package = EduPackage::whereId($site_info->siteMembership->edu_package_id ?? null)->first();

            $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];

            $module_list = Module::with(['subModule'])
                ->whereIn('id', $package_module_ids)
                ->orderBy('id', 'DESC')
                ->get();

            if (count($module_list) <= 0) {
                return JsonResponse::create(['message' => 'Don"t Have Assigned Module <br/> Contact With SuperAdmin'], 410);
            }

            return response()->json($module_list, 200, [], JSON_NUMERIC_CHECK);

        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


     /*   try {
            $site_id = Session::get('SITE_ID');

            $site_info = SiteInfo::findOrFail($site_id) ?? [];
            $site_group = $site_info->siteGroup ?? [];
            $module_Ids = array_unique($site_group->subModules->pluck('module_id')->toArray()) ?? [];
            $sub_module_Ids = array_unique($site_group->subModules->pluck('id')->toArray()) ?? [];

            $moduleList = Module::with(['subModule' => function ($q) use ($sub_module_Ids) {
                $q->whereIn('id', $sub_module_Ids);
            }])->whereIn('id', $module_Ids)
                ->orderBy('id', 'DESC')
                ->get();

            $assignedSubModules = array_unique($site_info->subModules->pluck('id')->toArray()) ?? null;
            $site_assigned_sm_ids =array_intersect($sub_module_Ids,$assignedSubModules) ?  explode(',', implode(',',array_intersect($sub_module_Ids,$assignedSubModules))) : [];

            return Response::json([$moduleList, $site_assigned_sm_ids]);

        } catch (ModelNotFoundException $e) {
            return Response::json([
                'message' => 'Sub Module not found',
            ], 404);
        }*/
    }

    public function assignSubModuleToSite(Request $req)
    {
        $this->validate($req, [
            'selectedSite' => 'required'
        ]);

        $sub_module_ids = $req->selectedSubModule;
        $site_id = $req->selectedSite;
        $total = count($sub_module_ids);
        $theSite = SiteInfo::findOrFail($site_id);
        $theSite->subModules()->sync($sub_module_ids);

        //assigned newly subModule to superAdmin too
        if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . $theSite->site_alias))) {
            deleteDir((base_path("resources/views/default/admin/layouts/sidebars/" . $theSite->site_alias)));
        }
        $roleId = GlobalSiteRole::firstOrCreate(['name' => 'admin', 'site_id' => $theSite->id])->id;
        $userAlreadyAssigned = GlobalSiteRoleAccess::whereSiteRoleId($roleId)->whereSiteId($theSite->id)->first();


        if ($userAlreadyAssigned) {
            $userAlreadyAssigned->update([
                'sub_module_ids' => implode(',', $sub_module_ids),
                'site_role_id' => $roleId

            ]);
        } else {
            GlobalSiteRoleAccess::insert([
                'sub_module_ids' => implode(',', $sub_module_ids),
                'site_role_id' => $roleId,
                'site_id' => $theSite->id
            ]);
        }

        return Response::json(['message' => $total . ' Sub Module Attached Successfully!']);
    }


}
