<?php

namespace App\Http\Controllers\Site;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Site\Employee\GlobalTeacherAssignToClassSection;
use App\Models\Site\Employee\TeacherAssignToClassSection;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Response;
use Session;
use Error;

class SiteShiftClassGroupSectionSettingController extends ProjectController
{


    private $SiteShiftClassGroupSectionSetting;

    public function __construct(SiteShiftClassGroupSectionSetting $SiteShiftClassGroupSectionSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->SiteShiftClassGroupSectionSetting = $SiteShiftClassGroupSectionSetting;
    }

    public function index()
    {
        $viewType = 'Site Shift Class Group Section Setting Page';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sites.site-shift-class-group-section-setting', compact('viewType'));

    }


    public function getDepartmentBaseClassList($department_id)
    {

        try {


            $siteClassIds = SiteShiftClassGroupSectionSetting::where('academic_department_id', $department_id)
                ->pluck('academic_class_id')->toArray();

            $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $siteClassIds)->get();


            return response()->json($academicClassList, 200);
        } catch (Exception $exception) {

            // dd('ggg');
            return response()->json(["message" => $exception->getMessage()], 420);


        }


    }

    public function getGlobalDepartmentBaseClassList($academic_group_id,$department_id)
    {

        try {

            $siteClassIds = GlobalSiteShiftClassGroupSectionSetting::where('site_id',Session::get('SITE_ID'))
                ->where('academic_group_id',$academic_group_id)
                ->where('academic_department_id', $department_id)
                ->pluck('academic_class_id')->toArray();

            $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $siteClassIds)->get();


            return response()->json($academicClassList, 200);
        } catch (Exception $exception) {

            return response()->json(["message" => $exception->getMessage()], 420);


        }


    }

    public function getDepartmentBaseClassListByUser($department_id)
    {

        try {

            $user_id = Auth::user()->id;


            $siteClassIds = TeacherAssignToClassSection::where('employee_id', $user_id)
                ->where('academic_department_id', $department_id)
                ->pluck('academic_class_id')->toArray();

            $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $siteClassIds)->get();


            return response()->json($academicClassList, 200);
        } catch (Exception $exception) {

            // dd('ggg');
            return response()->json(["message" => $exception->getMessage()], 420);


        }


    }

    public function getAcademicGroupBaseShiftYearVersion()
    {

        $SiteInfoTableData = SiteInfoSetting::select('shift_ids', 'academic_year_ids', 'academic_version_ids')
            ->first();

        $academicShift = explode(',', $SiteInfoTableData->shift_ids);
        $academicShiftList = AcademicShift::whereIn('id', $academicShift)
            ->get();

        $academicVersionIDs = explode(',', $SiteInfoTableData->academic_version_ids);
        $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();


        $academicYear = explode(',', $SiteInfoTableData->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('id','DESC')->get();

        return [$academicShiftList, $academicVersionList, $academicYearList];
    }


    public function getSiteYearVersionBaseDepartmentClass($version_id, $year_id)
    {
        $academicClassList = [];
        $academicDepartmentList = [];

        $SiteInfoTableData = SiteInfoSetting::select('shift_ids','academic_class_ids','academic_department_ids','academic_year_ids', 'academic_version_ids')
        ->first();
        $academic_class_ids= explode(',', $SiteInfoTableData->academic_class_ids ?? null);
        $academic_department_ids= explode(',', $SiteInfoTableData->academic_department_ids ?? null);
       
        if ($version_id) {


            $academicDepartment = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
//                ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->unique()
                ->filter();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];


            if (count($academicDepartment) > 0) {
                $academicDepartmentList = AcademicDepartment::whereIn('id', $academicDepartment)
                ->whereIn('id', $academic_department_ids)
                ->get();
            } else {


                $academicClass = $this->SiteShiftClassGroupSectionSetting
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
//                    ->groupBy('academic_class_id')
                    ->pluck('academic_class_id')
                    ->unique()
                    ->filter()
                    ->toArray();
                    
                 //   explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
                //   $academic_class_ids= explode(',', $SiteInfoTableData->academic_class_ids ?? null);
                $academicClassList = AcademicClass::whereIn('id', $academicClass)
                    ->whereIn('id', $academic_class_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
                  //  dd($academicClassList);

            }


        } else {

            $academicDepartment = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_year_id', $year_id)
//                ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->unique()
                ->filter();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
//            $academicDepartmentList = [];


            if (count($academicDepartment) > 0) {
                $academicDepartmentList = AcademicDepartment::whereIn('id', $academicDepartment)
                    ->whereIn('id', $academic_department_ids)
                    ->get();
            } else {

                
                $academicClass = $this->SiteShiftClassGroupSectionSetting
                    ->where('academic_year_id', $year_id)
//                    ->groupBy('academic_class_id')
                    ->pluck('academic_class_id')
                    ->unique()
                    ->filter()
                    ->toArray();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
                $academicClassList = AcademicClass::whereIn('id', $academicClass)
                    ->whereIn('id', $academic_class_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
                //    dd($academicClassList);
                if (count($academicClass) == 0) {
                    return Response::json(['message' => 'No Class Found For The Year! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

                }

            }


        }


        return [$academicClassList, $academicDepartmentList];
    }


    public function getYearVersionAndShiftBasedDepartmentClass(Request $request)
    {

   

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) { //|| 
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = SiteInfoSetting::select('academic_class_ids')
            ->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = $this->SiteShiftClassGroupSectionSetting
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->whereNotNull('academic_department_id')
//            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
           // ->whereIn('id', $academicDepartment)    
            ->get();
        } else {

//test
            $plucked_class_ids = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->whereIn('academic_class_id', $academicClassIds)
//                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }

        $academic_key = Session::get('ACADEMIC_KEY');



        $countDepartment = count($academic_department_list);

        return [$academic_class_list, $academic_department_list, $countDepartment, $academic_key];
    }

    public function getYearVersionAndMultipleShiftBasedDepartmentClass(Request $request)
    {

        dd($request->all());

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_ids'] = [$request->academic_shift_ids];


        if (!$data['academic_version_id'] || !$data['academic_year_id']) { //|| 
            return Response::json(['message' => 'Select Version, Year For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = SiteInfoSetting::select('academic_class_ids')
            ->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = $this->SiteShiftClassGroupSectionSetting
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->whereIn('academic_shift_id', $data['academic_shift_ids'])
            ->whereNotNull('academic_department_id')
//            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
           // ->whereIn('id', $academicDepartment)    
            ->get();
        } else {

//test
            $plucked_class_ids = $this->SiteShiftClassGroupSectionSetting
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->whereIn('academic_shift_id', $data['academic_shift_ids'])
                ->whereIn('academic_class_id', $academicClassIds)
//                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }

        $academic_key = Session::get('ACADEMIC_KEY');



        $countDepartment = count($academic_department_list);

        return [$academic_class_list, $academic_department_list, $countDepartment, $academic_key];
    }


    public function getAcademicGroupYearVersionAndShiftBasedDepartmentClass(Request $request)
    {

   

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_group_id'] = $request->academic_group_id == 'null' ? null : $request->academic_group_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = GlobalSiteInfoSetting::select('academic_class_ids')
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $data['academic_group_id'])
            ->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('academic_version_id', $data['academic_version_id'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $data['academic_group_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->whereNotNull('academic_department_id')
//            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
           // ->whereIn('id', $academicDepartment)    
            ->get();
        } else {

//test
            $plucked_class_ids = GlobalSiteShiftClassGroupSectionSetting::where('academic_version_id', $data['academic_version_id'])
                ->where('site_id', Session::get('SITE_ID'))
                ->where('academic_group_id', $data['academic_group_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->whereIn('academic_class_id', $academicClassIds)
//                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }

        $academic_key = Session::get('ACADEMIC_KEY');



        $countDepartment = count($academic_department_list);

        return [$academic_class_list, $academic_department_list, $countDepartment, $academic_key];
    }

    public function getAcademicGroupYearVersionAndShiftClassBasedGroupSection(Request $request){
        $data = $request->all();
       
        $classGroupIds = GlobalSiteShiftClassGroupSectionSetting::with(['academicClassGroup'])
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->whereNotNull('academic_class_group_id')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->whereIn('academic_class_id', $request->academic_class_ids)
            ->pluck('academic_class_group_id')
            ->unique()
            ->values();

        $classGroupList = AcademicClassGroup::whereIn('id',$classGroupIds)->get();

       // dd($classGroupList);

        $classSectionList = GlobalSiteShiftClassGroupSectionSetting::where('academic_version_id', $request->academic_version_id)
            ->where('site_id', Session::get('SITE_ID'))
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(count($data['academic_class_group_ids']), function ($query) use ($data) {
                return $query->whereIn('academic_class_group_id', $data['academic_class_group_ids']);
            })
            ->where('academic_group_id', $request->academic_group_id)
            ->whereIn('academic_class_id', $request->academic_class_ids)
            ->pluck('academic_section_ids');


        $section_ids = implode(',', $classSectionList->toArray());
        $sectionStringIds =array_unique(array_map('intval', explode(',', $section_ids)));

        $section_list = AcademicSection::whereIn('id',$sectionStringIds)->get();

        return [$classGroupList, $section_list];

    }


    public function getGlobalSiteYearVersionAndShiftBasedDepartmentClassByUser(Request $request)
    {

   //dd('sff');

        $data = [];
        $data['academic_group_id'] = $request->academic_group_id == 'null' ? null : $request->academic_group_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];

            $user_id = Auth::user()->id;
            $user_role = request()->user()->roles()->pluck('key')->first();
    
            $academic_class_list = [];
            $academic_department_list = [];
            $academic_department_ids = [];
            $academic_class_ids = [];
    
         //   if ($user_role == 'admin') {
              
                $site_info_setting = GlobalSiteInfoSetting::where('site_id',Session::get('SITE_ID'))
                    ->where('academic_group_id',$data['academic_group_id'])
                    ->first();
                $academic_class_idss=[];
                if ($site_info_setting->academic_class_ids) {
                    $academic_class_idss = explode(',', $site_info_setting->academic_class_ids);
                }

                $academic_class_ids = GlobalSiteShiftClassGroupSectionSetting::
                    where('academic_version_id', $data['academic_version_id'])
                    ->where('site_id', Session::get('SITE_ID'))
                    ->where('academic_group_id', $data['academic_group_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->whereIn('academic_class_id', $academic_class_idss)
                    ->pluck('academic_class_id')
                    ->unique()
                    ->filter()
                    ->toArray();
    
                if ($site_info_setting->academic_department_ids && $site_info_setting->academic_department_ids != 0) {
                    $academic_department_ids = explode(',', $site_info_setting->academic_department_ids);
                }
    
               
    
    //         } else {
    //             $academic_department_ids = GlobalTeacherAssignToClassSection::
    //                 where('site_id',Session::get('SITE_ID'))
    //                 ->where('academic_group_id',$data['academic_group_id'])
    //                 ->where('employee_id', $user_id)
    //                 ->where('academic_version_id', $data['academic_version_id'])
    //                 ->where('academic_year_id', $data['academic_year_id'])
    //                 ->where('academic_shift_id', $data['academic_shift_id'])
    //                 ->whereNotNull('academic_department_id')
    // //          ->groupBy('academic_department_id', 'academic_class_id')
    //                 ->pluck('academic_department_id')
    //                 ->unique()
    //                 ->filter()
    //                 ->toArray();
    
    //             $academic_class_ids = GlobalTeacherAssignToClassSection::
    //                 where('site_id',Session::get('SITE_ID'))
    //                 ->where('academic_group_id',$data['academic_group_id'])
    //                 ->where('employee_id', $user_id)
    //                 ->where('academic_version_id', $data['academic_version_id'])
    //                 ->where('academic_year_id', $data['academic_year_id'])
    //                 ->where('academic_shift_id', $data['academic_shift_id'])
    // //                ->groupBy('academic_class_id')
    //                 ->pluck('academic_class_id')
    //                 ->unique()
    //                 ->filter()
    //                 ->toArray();

    //                 if (count($academic_class_ids) == 0) {
    //                     return Response::json(['message' => 'You Have No Permission'], 411);
    //                 }
    
    //         }
    
            if (count($academic_department_ids) > 0) {
                $academic_department_list = AcademicDepartment::whereIn('id', $academic_department_ids)
                    ->get();
            } else {
                if (count($academic_class_ids) == 0) {
                    return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
                }
                $academic_class_list = AcademicClass::whereIn('id', $academic_class_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
            }
    
            $countDepartment = count($academic_department_list);
    
            return [$academic_class_list, $academic_department_list, $countDepartment];
    }

    public function getYearVersionAndShiftBasedDepartmentClassByUser(Request $request)
    {

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $user_id = Auth::user()->id;
        $user_role = request()->user()->roles()->pluck('key')->first();

        $academic_class_list = [];
        $academic_department_list = [];
        $academic_department_ids = [];
        $academic_class_ids = [];

        if ($user_role == 'admin') {
            $site_info_setting = SiteInfoSetting::first();

            if ($site_info_setting->academic_department_ids && $site_info_setting->academic_department_ids != 0) {

                $academic_department_ids = explode(',', $site_info_setting->academic_department_ids);
            }

            if ($site_info_setting->academic_class_ids) {
                $academic_class_ids = explode(',', $site_info_setting->academic_class_ids);
            }

        } else {
            $academic_department_ids = TeacherAssignToClassSection::where('employee_id', $user_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->whereNotNull('academic_department_id')
//          ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->unique()
                ->filter()
                ->toArray();

            $academic_class_ids = TeacherAssignToClassSection::where('employee_id', $user_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
//                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

        }

        if (count($academic_department_ids) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academic_department_ids)
                ->get();
        } else {
            if (count($academic_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
            }
            $academic_class_list = AcademicClass::whereIn('id', $academic_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }

        $countDepartment = count($academic_department_list);

        return [$academic_class_list, $academic_department_list, $countDepartment];
    }


    public function getShiftClassGroupSectionList($shiftid, $yearid, $versionid)
    {

        try {
            if (!$shiftid || !$yearid || !$versionid) {
                return response()->json(['message' => 'Shift Or Year Or Version missing!'], 410);
            }

            $SiteInfoTableData = SiteInfoSetting::select('shift_ids', 'academic_class_ids', 'academic_class_group_ids',
                'academic_section_ids', 'academic_department_ids')
                ->first();
            $SiteShiftClassGroupSectionTableData = SiteShiftClassGroupSectionSetting::
            where('academic_shift_id', $shiftid)->where('academic_year_id', $yearid)
                ->where('academic_version_id', $versionid)
                ->get();
                

            //return $SiteShiftClassGroupSectionTableData;


            $academicDepartment = explode(',', $SiteInfoTableData->academic_department_ids);
            $academicDepartmentList = AcademicDepartment::select('id as department_id', 'name as department_name')
                ->whereIn('id', $academicDepartment)
                ->get();


            $academicClassGroup = explode(',', $SiteInfoTableData->academic_class_group_ids);
            $academicClassGroupList = ClassGroup::select('id as group_id', 'group_name')
                ->whereIn('id', $academicClassGroup)
                ->get();


            if (count($academicDepartmentList) <= 0) {
                $academicclass = explode(',', $SiteInfoTableData->academic_class_ids);
                $academicClassGroupPresentList = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 1)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

                $academicClassGroupAbsentList = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 0)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
            } else {
                $academicclass = explode(',', $SiteInfoTableData->academic_class_ids);
                $academicClassGroupPresent = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 1)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

                $academicClassGroupAbsent = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 0)
                    ->orderBy('serial_no', 'ASC')
                    ->get();


                $academicClassGroupPresentListArray = [];
                foreach ($academicDepartmentList as $key => $value) {
                    $depArr1 = Array();
                    $deptArray1 = [];
                    foreach ($academicClassGroupPresent as $keys => $values) {

                        $depArr1['class_id'] = $values->class_id;
                        $depArr1['class_name'] = $values->class_name;

                        $deptArray1[$keys] = array_merge($value->toArray(), $depArr1);


                    }

                    $academicClassGroupPresentListArray[$key] = array_merge($deptArray1);
                }


                $test1 = collect($academicClassGroupPresentListArray);
                $academicClassGroupPresentList = $test1->collapse();
                // Log::info($academicClassGroupPresentList);


                $academicClassGroupAbsentListArray = [];
                foreach ($academicDepartmentList as $key => $value) {
                    $depArr = Array();
                    $deptArray = [];
                    foreach ($academicClassGroupAbsent as $keys => $values) {

                        $abc = $SiteShiftClassGroupSectionTableData
                            ->where('academic_department_id', $value['department_id'])
                            ->where('academic_class_id', $values['class_id'])
                            ->first();


//                        Log::info($abc);

                        if ($abc) {
                            $depArr['department_checked'] = true;
                        } else {
                            $depArr['department_checked'] = false;
                        }


                        $depArr['class_id'] = $values->class_id;
                        $depArr['class_name'] = $values->class_name;

                        $depArr['seat_capacity'] = $abc['seat_capacity'];
                        $depArr['admission_seat_capacity'] = $abc['admission_seat_capacity'];
                        $depArr['seat_extend'] = $abc['seat_extend'];


                        $deptArray[$keys] = array_merge($value->toArray(), $depArr);
                    }

                    $academicClassGroupAbsentListArray[$key] = array_merge($deptArray);
                }


                $test2 = collect($academicClassGroupAbsentListArray);
                $academicClassGroupAbsentList = $test2->collapse();

            }


            $academicSection = explode(',', $SiteInfoTableData->academic_section_ids);
            $academicSectionList = AcademicSection::select('id as section_id', 'section_name')
                ->whereIn('id', $academicSection)
                ->get();


            $classGroupArray = [];
            foreach ($academicClassGroupPresentList as $keys => $values) {
                $classArr = Array();
                $groupArray = [];
                // Log::info($values);


                foreach ($academicClassGroupList as $key => $value) {

                    $class_id = $values['class_id'] ? $values['class_id'] : $values->class_id;


                    $presentClassGroup = $SiteShiftClassGroupSectionTableData
                        ->when(!empty($values['academic_department_id']), function ($query) use ($values) {
                            return $query->where('academic_department_id', $values['department_id']);
                        })
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $value->group_id)
                        ->first();


                    if ($values['department_id']) {
                        $presentDepartmentClassGroup = $SiteShiftClassGroupSectionTableData
                            ->where('academic_department_id', $values['department_id'])
                            ->where('academic_class_id', $class_id)
                            ->where('academic_class_group_id', $value->group_id)
                            ->first();

//                        Log::info($values['department_id']);
//                        Log::info($class_id);
//                        Log::info($value->group_id);

                        if ($presentDepartmentClassGroup) {
                            if ($values['department_id'] == ($presentDepartmentClassGroup->academic_department_id)) {
                                $classArr['department_checked'] = true;
                            } else {
                                $classArr['department_checked'] = false;
                            }

                            if ($class_id == ($presentDepartmentClassGroup->academic_class_id)) {
                                $classArr['class_checked'] = true;
                            } else {
                                $classArr['class_checked'] = false;
                            }

                            if (($value->group_id) == ($presentDepartmentClassGroup->academic_class_group_id)) {
                                $classArr['group_checked'] = true;
                            } else {
                                $classArr['group_checked'] = false;
                            }


//                            Log::info($classArr);
                        } else {
                            $classArr['department_checked'] = false;
                            $classArr['class_checked'] = false;
                            $classArr['group_checked'] = false;
                        }

//                        $classArr['seat_capacity'] = $presentClassGroup['seat_capacity'];
//                        $classArr['admission_seat_capacity'] = $presentClassGroup['admission_seat_capacity'];
//                        $classArr['seat_extend'] = $presentClassGroup['seat_extend'];


                    } else {

                        if ($presentClassGroup) {
                            //    \Log::info(1);
                            if ($class_id == ($presentClassGroup->academic_class_id)) {
                                $classArr['class_checked'] = true;
                            } else {
                                $classArr['class_checked'] = false;
                            }

                            if (($value->group_id) == ($presentClassGroup->academic_class_group_id)) {
                                $classArr['group_checked'] = true;
                            } else {
                                $classArr['group_checked'] = false;
                            }
                        } else {
                            $classArr['class_checked'] = false;
                            $classArr['group_checked'] = false;
                        }


                    }

                    $classArr['seat_capacity'] = $presentClassGroup['seat_capacity'] ?? null;
                    $classArr['admission_seat_capacity'] = $presentClassGroup['admission_seat_capacity'] ?? null;
                    $classArr['seat_extend'] = $presentClassGroup['seat_extend'] ?? null;


                    $classArr['group_id'] = $value->group_id;
                    $classArr['group_name'] = $value->group_name;


                    if ($presentClassGroup) {


                        $checkedSection = explode(',', $presentClassGroup->academic_section_ids);
                        $findCheckedSectionName = $academicSectionList
                            ->whereIn('section_id', $checkedSection);

                        $findNonCheckedSectionName = $academicSectionList
                            ->whereNotIn('section_id', $checkedSection);


                        $checkSectionlist = Array();
                        $sectionArray = [];
                        if ($findCheckedSectionName) {


                            foreach ($findCheckedSectionName as $keyt => $valuet) {

                                if ($values['department_id']) {
                                    if ($presentClassGroup->academic_department_id == $values['department_id'] &&
                                        $class_id == ($presentClassGroup->academic_class_id)
                                        && ($value->group_id) == ($presentClassGroup->academic_class_group_id)
                                    ) {

                                        $checkSectionlist['section_checked'] = true;


                                    } else {
                                        $checkSectionlist['section_checked'] = false;
                                    }
                                } else {
                                    if ($class_id == ($presentClassGroup->academic_class_id)
                                        && ($value->group_id) == ($presentClassGroup->academic_class_group_id)
                                    ) {

                                        $checkSectionlist['section_checked'] = true;


                                    } else {
                                        $checkSectionlist['section_checked'] = false;
                                    }
                                }


                                $sectionArray[$keyt] = array_merge($valuet->toArray(), $checkSectionlist);

                            }

                            //$sectionlist=array_merge($groupArray);

                            $ClassSectionAllList = array_merge($sectionArray,
                                $findNonCheckedSectionName->toArray());

                            $classArr['section_list'] = $ClassSectionAllList;

                        }

                    } else {
                        $classArr['section_list'] = $academicSectionList;
                    }

                    if (count($academicDepartmentList) <= 0) {
                        $groupArray[$key] = array_merge($values->toArray(), $classArr);


                    } else {
                        $groupArray[$key] = array_merge($values, $classArr);


                    }


                }
                $classGroupArray[$keys] = array_merge($groupArray);

            }


            $test = collect($classGroupArray);
            $groupBaseClassList = $test->collapse();


            $onlyClassSectionArray = [];
            foreach ($academicClassGroupAbsentList as $keys => $values) {

                $sclassArr = Array();
                $sgroupArray = [];

                $class_id = $values['class_id'] ? $values['class_id'] : $values->class_id;

                $OnlyClass = $SiteShiftClassGroupSectionTableData
                    ->when(!empty($values['department_id']), function ($query) use ($values) {
                        return $query->where('academic_department_id', $values['department_id']);
                    })
                    ->where('academic_class_id', $class_id)
                    ->first();


                if ($OnlyClass) {

                    $sclassArr['class_checked'] = true;

                } else {
                    $sclassArr['class_checked'] = false;
                }

                $sclassArr['seat_capacity'] = $OnlyClass['seat_capacity'] ?? null;
                $sclassArr['admission_seat_capacity'] = $OnlyClass['admission_seat_capacity'] ?? null;
                $sclassArr['seat_extend'] = $OnlyClass['seat_extend'] ?? null;


                if (count($academicDepartmentList) <= 0) {
                    $sgroupArray[$keys] = array_merge($values->toArray(), $sclassArr);
                } else {
                    $sgroupArray[$keys] = array_merge($values, $sclassArr);
                }


                $stest = collect($sgroupArray);
                $onlyClassCheckList = $stest->collapse();


                $onlyClassSectionArr = [];
                if ($OnlyClass) {


                    $onlyCheckedSection = explode(',', $OnlyClass->academic_section_ids);
                    $onlyFindCheckedSectionName = $academicSectionList
                        ->whereIn('section_id', $onlyCheckedSection);

                    $onlyFindNonCheckedSectionName = $academicSectionList
                        ->whereNotIn('section_id', $onlyCheckedSection);


                    $onlyClassArr = Array();
                    $onlClassArrList = [];
                    if ($onlyFindCheckedSectionName) {


                        foreach ($onlyFindCheckedSectionName as $keyt => $valuet) {


                            if ($class_id == ($OnlyClass->academic_class_id)) {

                                $onlyClassArr['section_checked'] = true;

                                $onlClassArrList[$keyt] = array_merge($valuet->toArray(), $onlyClassArr);
                            }

                        }


                        //$sectionlist=array_merge($groupArray);

                        $ClassSectionAllList = array_merge($onlClassArrList,
                            $onlyFindNonCheckedSectionName->toArray());

                        $onlyClassSectionArr['section_list'] = $ClassSectionAllList;

                    }


                } else {
                    $onlyClassSectionArr['section_list'] = $academicSectionList;
                }

                $onlyClassSectionArray[$keys] = array_merge($onlyClassCheckList->toArray(), $onlyClassSectionArr);

            }


            $academicClassGroupAllList = array_merge($onlyClassSectionArray, $groupBaseClassList->toArray());


            $countSection = count($academicSectionList);
            $countClassGroup = count($academicClassGroupList);
            $countDepartment = count($academicDepartmentList);


            return [$academicClassGroupAllList, $countSection, $countClassGroup, $countDepartment];

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }


    }

    public function getShiftListForSite()
    {
        $SiteInfoTableData = SiteInfo::where('id', (Session::get('SITE_ID')))->first();
        $academicShift = explode(',', $SiteInfoTableData->shift_ids);
        $site_shifts = AcademicShift::whereIn('id', $academicShift)
            ->get();
        return $site_shifts;
    }


    /**
     * @param Request $request
     * @return mixed
     */
    public function insertUpdateShiftClassGroupSectionList(Request $request)
    {

        if (!$request->academic_shift_id || !$request->academic_year_id || !$request->academic_version_id) {
            return response()->json(['message' => 'Shift Or Year Or Version missing!'], 410);
        }


        $ShiftBaseList = SiteShiftClassGroupSectionSetting::where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->get();
        $count = 0;


        foreach ($request->FinalClassList as $key => $value) {

//            Log::info($value['seat_capacity']);

            $previousPresentdata = $ShiftBaseList
                ->when(!empty($value['academic_department_id']), function ($query) use ($value) {
                    return $query->where('academic_department_id', $value['academic_department_id']);
                })
                ->where('academic_class_id', $value['academic_class_id'])
                ->when(!empty($value['academic_class_group_id']), function ($query) use ($value) {
                    return $query->where('academic_class_group_id', $value['academic_class_group_id']);
                })
                ->first();

            if (!empty($value['academic_department_id']) && empty($previousPresentdata)) {
                if ($value['department_checked'] == true) {
                    if ($value['academic_class_group_id']) {
                        SiteShiftClassGroupSectionSetting::create([
                            'academic_shift_id' => $request->academic_shift_id,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_class_group_id' => $value['academic_class_group_id'],
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'admission_seat_capacity' => $value['admission_seat_capacity'],
                            'seat_extend' => $value['seat_extend']
                        ]);
                    } else {
                        SiteShiftClassGroupSectionSetting::create([
                            'academic_shift_id' => $request->academic_shift_id,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_class_group_id' => null,
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'admission_seat_capacity' => $value['admission_seat_capacity'],
                            'seat_extend' => $value['seat_extend']
                        ]);
                    }
                } else {
                    $count++;
                }
            } else if (!empty($value['academic_department_id']) && !empty($previousPresentdata)) {
                if ($value['department_checked'] == true) {
                    if ($value['academic_class_group_id']) {
                        $previousPresentDeptdata = $ShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->where('academic_class_group_id', $value['academic_class_group_id'])
                            ->first();


                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->update([
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend']
                            ]);

                        } else {
                            $count++;
                        }
                    } else {
                        $previousPresentDeptdata = $ShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->update([
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend']
                            ]);

                        } else {
                            $count++;
                        }
                    }
                } else {
                    if ($value['academic_class_group_id']) {
                        $previousPresentDeptdata = $ShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->where('academic_class_group_id', $value['academic_class_group_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->delete();
                        } else {
                            $count++;
                        }
                    } else {
                        $previousPresentDeptdata = $ShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->delete();

                        } else {
                            $count++;
                        }
                    }
                }

            } else {
                if ($value['academic_class_id'] != null && $value['academic_class_group_id'] != null) {
                    if ($previousPresentdata) {
                        if ($value['class_checked'] == true && $value['group_checked'] == true) {
                            if ($previousPresentdata->academic_class_id == $value['academic_class_id']
                                && $previousPresentdata->academic_class_group_id == $value['academic_class_group_id']
                            ) {
                                $previousPresentdata->update([
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend']
                                ]);

                            } else {
                                SiteShiftClassGroupSectionSetting::create([
                                    'academic_shift_id' => $request->academic_shift_id,
                                    'academic_year_id' => $request->academic_year_id,
                                    'academic_version_id' => $request->academic_version_id,
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_class_group_id' => $value['academic_class_group_id'],
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend']
                                ]);
                            }

                        } else if ($value['class_checked'] == false) {
                            if ($previousPresentdata->academic_class_id == $value['academic_class_id']
                                && $previousPresentdata->academic_class_group_id == $value['academic_class_group_id']
                            ) {
                                $previousPresentdata->delete();
                            }
                        } else {
                            $count++;
                        }
                    } else {
                        if ($value['class_checked'] == true && $value['group_checked'] == true) {
                            SiteShiftClassGroupSectionSetting::create([
                                'academic_shift_id' => $request->academic_shift_id,
                                'academic_year_id' => $request->academic_year_id,
                                'academic_version_id' => $request->academic_version_id,
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend']

                            ]);

                        }
                    }

                } else if ($value['academic_class_id'] != null && $value['academic_class_group_id'] == null) {

                    $previousPresentClassdata = $ShiftBaseList
                        ->where('academic_class_id', $value['academic_class_id'])
                        ->where('academic_class_group_id', null)->first();
                    if ($previousPresentClassdata) {
                        if ($value['class_checked'] == true) {
                            if ($previousPresentClassdata->academic_class_id == $value['academic_class_id']) {
                                $previousPresentClassdata->update([
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend']
                                ]);

                            } else {
                                SiteShiftClassGroupSectionSetting::create([
                                    'academic_shift_id' => $request->academic_shift_id,
                                    'academic_year_id' => $request->academic_year_id,
                                    'academic_version_id' => $request->academic_version_id,
                                    'academic_class_id' => $value['academic_class_id'],

                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend']

                                ]);
                            }
                        } else if ($value['class_checked'] == false) {
                            if ($previousPresentClassdata->academic_class_id == $value['academic_class_id']) {

                                $previousPresentClassdata->delete();

                            } else {
                                $count++;
                            }
                        } else {
                            $count++;
                        }
                    } else {
                        if ($value['class_checked'] == true) {
                            SiteShiftClassGroupSectionSetting::create([
                                'academic_shift_id' => $request->academic_shift_id,
                                'academic_year_id' => $request->academic_year_id,
                                'academic_version_id' => $request->academic_version_id,
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend']

                            ]);
                            $count++;
                        }
                    }

                } else {
                    $count++;
                }

            }

        }

        return Response::json(['message' => $count . ' Information Save Successfully!', 'mode' => 'Saved!']);


    }


    public function getAcademicClassListForSetSession(Request $request)
    {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;


        $this->checkVersionYearShiftDept($data);


        $SiteShiftClassGroupSection = SiteShiftClassGroupSectionSetting::select('academic_class_id')
            ->groupBy('academic_class_id')
            ->get();

        $SiteClassSessionSerialSetting = SiteClassSessionSerialSetting::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->orderBy('serial_no', 'asc')
            ->get();


        $class_final_array = [];
        $serial_no = 1;
        $academic_session_ids = SiteInfoSetting::where('status', true)->first()->academic_session_ids  ?? '0';

        $academic_session = AcademicSession::whereIn('id', explode(',', $academic_session_ids))->orderBy('id', 'DESC')->get();

        foreach ($SiteShiftClassGroupSection as $key => $value) {
            $existed = $SiteClassSessionSerialSetting->where('academic_class_id', $value->academic_class_id)->first();

            $class_final_array[$key]['id'] = $existed->id ?? null;
            $class_final_array[$key]['batches'] = [];
            $class_final_array[$key]['sessions'] = $academic_session;
            $class_final_array[$key]['batch_ids'] = [];
            $class_final_array[$key]['session_ids'] = $existed ? ($existed->session_ids != '0' ? array_map('intval', explode(',', $existed->session_ids)) : []) : [];

            $class_final_array[$key]['academic_class_id'] = $value->academic_class_id;
            $class_final_array[$key]['class_name'] = $value->academicClass->class_name ?? '';
            $class_final_array[$key]['serial_number'] = $existed->serial_no ?? $serial_no;
            $class_final_array[$key]['session_present'] = ($existed->session_ids ?? null) ? true : false;

            $serial_no++;

        }

        return response()->json($class_final_array, 200);
    }


    public function createClassSessionSerial(Request $request)
    {
        try {

            if (count($request->ClassList) < 1) {
                return Response::json(['message' => "No Class Selected!"], 412);
            }


            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? 0 : $request->academic_department_id;

            /*
                        $class_final_array[$key]['batches'] = [];
                        $class_final_array[$key]['sessions'] = $academic_session;
                        $class_final_array[$key]['batch_ids'] = [];
                        $class_final_array[$key]['session_ids'] = explode(',',$value->session_ids);*/

            $message = 'Not Saved Anything!';
            $mode = '';

            foreach ($request->ClassList as $key => $value) {

                $existed = (new SiteClassSessionSerialSetting())->where('id', $value['id'])->first();

                if ($existed) {
                    $existed->academic_version_id = $data['academic_version_id'];
                    $existed->academic_year_id = $data['academic_year_id'];
                    $existed->academic_shift_id = $data['academic_shift_id'];
                    $existed->academic_department_id = $data['academic_department_id'];


                    $existed->academic_class_id = $value['academic_class_id'];
                    $existed->session_present = count($value['session_ids']) ? 1 : 0;
                    $existed->serial_no = $value['serial_number'];
                    $existed->session_ids = count($value['session_ids']) ? implode(',', $value['session_ids']) : "0";
                    $existed->status = true;
                    $existed->save();

                    $message = 'Save Successfully!';
                    $mode = 'Saved';


                } else {
                    $new_data = (new SiteClassSessionSerialSetting());

                    $new_data->academic_version_id = $data['academic_version_id'];
                    $new_data->academic_year_id = $data['academic_year_id'];
                    $new_data->academic_shift_id = $data['academic_shift_id'];
                    $new_data->academic_department_id = $data['academic_department_id'];

                    $new_data->academic_class_id = $value['academic_class_id'];
                    $new_data->session_present = count($value['session_ids']) ? 1 : 0;
                    $new_data->serial_no = $value['serial_number'];
                    $new_data->session_ids = count($value['session_ids']) ? implode(',', $value['session_ids']) : "0";

                    $new_data->status = true;
                    $new_data->save();
                    $mode = 'Updated';
                    $message = 'Updated Successfully!';

                }

            }

            return Response::json(['message' => $message, 'mode' => $mode], 200);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 412);

        }


    }


}
