<?php

namespace App\Http\Controllers\Site\Sms;

use App\Models\Site\Sms\phoneBookGroup;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class phoneBookGroupController extends Controller
{
    private $phoneBookGroup;

    public function __construct(phoneBookGroup $phoneGroup)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->phoneBookGroup = $phoneGroup;
    }


    public function getPhoneBookGroupList(Request $request)
    {
        try {

            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;


            $txt = '%' . $search_txt . '%';
            $data = $this->phoneBookGroup
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('name', 'LIKE', $txt);
                    });
                })
                ->paginate($paginate);

            //dd(count($data)<1);


            if (count($data) < 1) {
                throw new Error('No Data Found!');
            }

            return response()->json($data, 200, []);
        } catch (Exception $exception) {

        }

    }


    public function create(Request $request)
    {


        try {

            $this->validate($request, [
                'mobile_number' => 'required'
            ]);

            foreach ($this->phoneBookGroup->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $this->phoneBookGroup->{$ownField} = $request->{$ownField};
                }
            }

            $this->phoneBookGroup->status = $request->status;
            $this->phoneBookGroup->site_id = \Session::get('SITE_ID');
            $this->phoneBookGroup->created_by = Auth::id();
            $this->phoneBookGroup->save();
            return response()->json(['data' => $this->phoneBookGroup, 'message' => ' Successfully Saved!', 'mode' => 'Save'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function update(Request $request)
    {

        try {

            $this->validate($request, [
                'mobile_number' => 'required'
            ]);

            $this->phoneBookGroup = $this->phoneBookGroup->findOrFail($request->id);


            foreach ($this->phoneBookGroup->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $this->phoneBookGroup->{$ownField} = $request->{$ownField};
                }
            }

            $this->phoneBookGroup->status = $request->status;
            $this->phoneBookGroup->save();
            return response()->json(['data' => $this->phoneBookGroup, 'message' => ' Successfully Updated!', 'mode' => 'Update'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function excelUpload(Request $request)

    {

        try {

            // \Log::info('ggg: '.$request->file->getRealPath());

            $fileName = time() . '.' . $request->file->getClientOriginalExtension();
            $request->file->move(storage_path('pdf'), $fileName);

            $this->validate($request, [
                //'select_file' => 'required|mimes:xls,xlsx'
            ]);
            $import = new SitephoneBookGroupImport;
            Excel::import($import, storage_path('pdf') . '/' . $fileName);
            $row_count = $import->getRowCount();

            if ($row_count) {
                return response()->json(['message' => 'You Have Successfully Uploaded . ' . $row_count . ' Rows', 'mode' => 'Upload'], 200);

            }
            return response()->json(['message' => 'No Unique Row Found!'], 410);


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function delete(Request $request)
    {

        try {

            $this->validate($request, [
                'id' => 'required'
            ]);

            $this->phoneBookGroup = $this->phoneBookGroup->findOrFail($request->id)->delete();


            return response()->json(['data' => $this->phoneBookGroup, 'message' => ' Successfully Delete!', 'mode' => 'Delete'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

}
