<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/16/16
 * Time: 2:25 PM
 */

namespace App\Http\Controllers\Site\Sms;


use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Jobs\site\GlobalUserMessageJob;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Guardian\Guardian;
use App\Models\Site\Notice\Notice;
use App\Models\Site\Sms\SiteSms;
use App\Models\Student\StudentHistory;
// use App\Models\User\User;
use App\Models\Site\Student\Student;
use App\Traits\SmsFunctionsTrait;
use Auth;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Traits\RequestHandlingWithMachine;
use App\Models\Edu\Device\DeviceLog;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\User\UserMessage;
use Illuminate\Validation\ValidationException;
use App\Notifications\Site\UserMessageNotification;
use App\User;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Session as FacadesSession;
use Response;
use Session;


class SmsController extends ProjectController
{

    use  SmsFunctionsTrait, RequestHandlingWithMachine;


    /**
     * NoticesController constructor.
     * @param Notice $notice
     */

    private $sms;
    private $employee;
    private $studentHistory;

    public function __construct(SiteSms $sms, Employee $employee, StudentHistory $studentHistory)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->sms = $sms;
        $this->employee = $employee;
        $this->studentHistory = $studentHistory;
    }


    public function index()
    {
        $viewType = 'Sms Master View';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sms.inbox', compact('viewType'));
    }

    /*
        public function createSmsForm()
        {
            $viewType = 'Create Message';

            return view('default.admin.sms.create', compact('viewType'));
        }*/


    public function createSms(Request $request)
    {

        try {

            $this->validate($request, [
                'sms_title' => 'required',
                'sms_description' => 'required',
            ]);

            $this->sms = new SiteSms();

            foreach ($this->sms->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $this->sms->{$ownField} = $request->{$ownField};
                }
            }

            $this->sms->status = $request->status;
            $this->sms->created_by = Auth::id();
            $this->sms->save();
            return response()->json(['data' => $this->sms, 'message' => $this->sms->sms_title . ' Successfully Saved!', 'mode' => 'Save'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function update(Request $request)
    {

        try {

            $this->validate($request, [
                'sms_title' => 'required',
                'sms_description' => 'required',
            ]);

            $this->sms = $this->sms->findOrFail($request->id);


            foreach ($this->sms->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $this->sms->{$ownField} = $request->{$ownField};
                }
            }

            $this->sms->status = $request->status;
            $this->sms->save();
            return response()->json(['data' => $this->sms, 'message' => $this->sms->sms_title . ' Successfully Updated!', 'mode' => 'Update'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function getListWithPagination(Request $request)
    {
        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            if (!$date_range) {
                throw new Error('Please select Date');
            }


            $date_start = $date_range->start;//.' 00:00:00';
            $date_end = $date_range->end ?? $date_start;

            $list = $this->sms
                ->where('status', $status)
                ->whereDate('created_at', '>=', $date_start)
                ->whereDate('created_at', '<=', $date_end)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('doc_number', 'LIKE', $txt)
                            ->orWhere('sms_title', 'LIKE', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return response()->json($list, 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    /*   public function getDetails(Request $request)
       {
           try {
               $track_no = $request->track_number;
               $id = $request->id;
               $the_sms = $this->sms
                   ->where('track_number', $track_no)
                   ->orWhere('id', $id)
                   ->first();

               if (!$the_sms) {
                   throw new Error('No Sms Found!');
               }

               return response()->json([$the_sms], 200);

           } catch (Exception $ex) {
               return Response::json([$ex->getMessage()], 405);
           }

       }*/

    public function sendToStudent(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id;
            $data['academic_student_category_id'] = $request->academic_student_category_id;
            $data['academic_admission_type_id'] = $request->academic_admission_type_id;

            $status = $request->status;
            $sms_id = $request->sms_id;
            $confirmed = $request->confirmed;


            $number_array = $this->studentHistory
                ->whereIn('id', $request->student_history_ids)
                ->where('status', $status)
                ->with('student')
                ->get()
                ->pluck('student.contact_number')
                ->filter()
                ->values()
                ->toArray();
             
            if (count($number_array) < 1) {
                throw new Error('No Student Found For the year !');
            }

            if (!$confirmed) {
                if($request->message_type_key=='message'){
                    return Response::json(['message' => 'You are going to send Notification'], 412);
                }
                $site_id = Session::get('SITE_ID');
                $the_sms = $this->sms->findOrFail($sms_id);
                $sms_count = $this->checkSmsCount($the_sms->sms_description);
                $sms_mem_data = $this->getSmsRelatedSiteMembershipData($site_id);
                $per_sms_cost = $sms_mem_data[1];

                $sms_balance_needed = ($sms_count * $per_sms_cost * count($number_array));


                return Response::json(['message' => 'You are going to send:' . count($number_array) . ' students & sms count:' . $sms_count . ' & balance needed:' . $sms_balance_needed], 412);

            } else {

                if($request->message_type_key=='message'){

                    // if(Session::get('USER_TYPE'!='site')){
                    //     return Response::json(['message' => 'You have no permission, This service for only site admin'], 412);
                    // }
                        $the_sms = $this->sms->findOrFail($sms_id);
                        $user_ids_array=[];
                        foreach($request->student_history_ids as $student_history_id){

                           

                            $history = $this->studentHistory->select('id','user_id')->findOrFail($student_history_id);

                            $message= new UserMessage;

                            $message->user_id=$history->user_id;
                            $message->title=$the_sms->sms_title;
                            $message->message=$the_sms->sms_description;
                            $message->message_type_key='message';
                            $message->created_by=Auth::user()->id;
                            $message->category='general';
                            $message->save();

                            $user_ids_array[]=$history->user_id;
                            // $user = User::where('id', $history->user_id)
                            //     ->select(['id'])
                            //     ->first();

                            //     dd($user);

                          //  $user=User::find($history->user_id);
                        
                         //   Notification::send($user, new UserMessageNotification('Hello users!','/'));
                        }
                      //  dd($user_ids_array);
                        // $users = User::whereIn('id', $user_ids_array)
                        // ->select(['id'])
                        // ->get();

                        // dd($users);

                        ///
                         $this->sendMessageNotification($user_ids_array, $the_sms);
                        // $this->logNoticeSentDetails($the_notice, 'Student of: ' . $this->getStudentHistoryDetails($data) . ' Total:' . count($user_ids_array));
            
                        ///
                return Response::json(['mode' => 'Success', 'message' => 'Message Send Successfully'], 200);

                }else{
                    $the_sms = $this->sms->findOrFail($sms_id);
                    $total_sms_cost_details = $this->sendSmsUsingQueue($number_array, $the_sms->sms_description);
                    $this->logSmsSentDetails($the_sms, 'Student Of: ' . $this->getStudentHistoryDetails($data) . ' :' . count($number_array) . ' Numbers');
                    return Response::json(['mode' => 'Success', 'message' => $total_sms_cost_details], 200);

                }

            }

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }

    private function sendMessageNotification($user_ids_array, SiteSms $sms)
    {

        $route = '/user/notification/view';// route('site-notice-view', ['']);
        dispatch(new GlobalUserMessageJob($user_ids_array, $sms, $route));

    }

    public function sendToGuardian(Request $request)
    {

      //  dd($request->all());
        try {
            $this->validate($request, [
                'sms_id' => 'required',
            ]);

            $data=$request->all();

            $status = $request->status;
            $sms_id = $request->sms_id;
            $confirmed = $request->confirmed;

            $number_array = $this->studentHistory
                ->whereIn('id', $request->student_history_ids)
                ->where('status', $status)
                ->with('guardian')
                ->get()
                ->pluck('guardian.contact_number')
                ->filter()
                ->toArray();


            if (count($number_array) < 1) {
                throw new Error('No Guardian Found!');
            }

            if (!$confirmed) {
                if($request->message_type_key=='message'){
                    return Response::json(['message' => 'You are going to send Notification'], 412);
                }
                $the_sms = $this->sms->findOrFail($sms_id);
                $sms_count = $this->checkSmsCount($the_sms->sms_description);

                return Response::json(['message' => 'You are going to send:' . count($number_array) . ' students & sms count:' . $sms_count], 412);

            } else {

                if($request->message_type_key=='message'){
                    if(Session::get('USER_TYPE'!='site')){
                        return Response::json(['message' => 'You have no permission, This service for only site admin'], 412);
                    }

                    foreach($number_array as $number){
                       $user = User::Where('contact_number',$number)->first();
                       if($user){
                        $the_sms = $this->sms->findOrFail($sms_id);
                        $message= new UserMessage;

                        $message->user_id=$user->id;
                        $message->title=$the_sms->sms_title;
                        $message->message=$the_sms->sms_description;
                        $message->message_type_key='message';
                        $message->created_by=Auth::user()->id;
                        $message->category='general';
                        $message->save();
                       }
                    }
            return Response::json(['mode' => 'Success', 'message' => 'Message Send Successfully'], 200);

            }else{

                $the_sms = $this->sms->findOrFail($sms_id);
                $total_sms_cost_details = $this->sendSmsUsingQueue($number_array, $the_sms->sms_description);
                $this->logSmsSentDetails($the_sms, 'Guardian of: ' . $this->getStudentHistoryDetails($data) . ' :' . count($number_array) . ' Numbers');

                return Response::json(['mode' => 'Success', 'message' => $total_sms_cost_details], 200);

            }
            }
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function sendToEmployee(Request $request)
    {
       // dd($request->all());

        try {
            $this->validate($request, [
                'number_array' => 'required',
                'sms_id' => 'required',
            ]);

            $sms_id = $request->sms_id;
            $number_array = $request->number_array;
            $confirmed = $request->confirmed;

            $site_id = Session::get('SITE_ID');


            if (count($number_array) < 1) {
                throw new Error('No User Found!');
            }

            if (!$confirmed) {

                if($request->message_type_key=='message'){
                    return Response::json(['message' => 'You are going to send Notification'], 412);
                }

                $the_sms = $this->sms->findOrFail($sms_id);
                $sms_count = $this->checkSmsCount($the_sms->sms_description);

                $sms_mem_data = $this->getSmsRelatedSiteMembershipData($site_id);
                $per_sms_cost = $sms_mem_data[1];

                $sms_balance_needed = ($sms_count * $per_sms_cost * count($number_array));


                return Response::json(['message' => 'You are going to send:' . count($number_array) . ' number(s) & sms count:' . $sms_count . ' & balance needed' . $sms_balance_needed], 412);

            } else {

                if($request->message_type_key=='message'){
                    if(Session::get('USER_TYPE'!='site')){
                        return Response::json(['message' => 'You have no permission, This service for only site admin'], 412);
                    }

                     $users=[];
                    foreach($request->number_array as $number){
                       $user = User::Where('contact_number',$number)->first();
                     //  $users[]=$user;
                       if($user){
                        $the_sms = $this->sms->findOrFail($sms_id);

                        $message= new UserMessage;

                        $message->user_id=$user->id;
                        $message->title=$the_sms->sms_title;
                        $message->message=$the_sms->sms_description;
                        $message->message_type_key='message';
                        $message->created_by=Auth::user()->id;
                        $message->category='general';
                        $message->save();
                       }
                    }
                 //  dd($users);
            return Response::json(['mode' => 'Success', 'message' => 'Message Send Successfully'], 200);

            }else{

                $the_sms = $this->sms->findOrFail($sms_id);
                $total_sms_cost_details = $this->sendSmsUsingQueue($number_array, $the_sms->sms_description);
                $this->logSmsSentDetails($the_sms, '<b>Employee: </b> ' . count($number_array) . ' Numbers');
                return Response::json(['mode' => 'Success', 'message' => $total_sms_cost_details], 200);
            }
        }


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getNoticeListWithPagination(Request $request)
    {
        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            if (!$date_range) {
                throw new Error('Please select Date');
            }


            $date_start = $date_range->start;//.' 00:00:00';
            $date_end = $date_range->end ?? $date_start;

            $noticeList = $this->notice
                ->where('status', $status)
                ->where('type', 'notice')
                ->whereDate('created_at', '>=', $date_start)
                ->whereDate('created_at', '<=', $date_end)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('doc_number', 'LIKE', $txt)
                            ->orWhere('track_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('notice_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->paginate($paginate);
            //  ->toSql();

            return $noticeList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    private function logSmsSentDetails($the_sms, $sent_log)
    {
        $time = Carbon::now()->toDateTime()->format('d M Y g:i A');

        $the_sms->sent_request = ($the_sms->sent_request . ' <br/>' . $sent_log . ' <i class="fa fa-clock-o"></i>' . $time);
        $the_sms->save();

        return $the_sms;
    }

    public function delete($id)
    {
        try {

            $the_sms = $this->sms->findOrFail($id);
            $the_sms->delete();
            return response()->json(['message' => $the_sms->sms_title . ' Successfully Deleted'], 200);

        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);

        }

    }

    //========= SMS setting ==============


    public function studentListForSmsSetting(Request $request){
        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){
            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id', 'contact_number', 'father_contact_number',
                'mother_contact_number','sms_contact_field');
        }])
            ->select('id', 'user_id', 'student_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('academic_department_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->get();

        return response()->json(['student_list'=>$student_list]);

        }

        public function saveContactSettingForSms(Request $request){

            $StudentList=collect($request->StudentList);

            $user_ids=$StudentList->pluck('user_id')->unique()->values();
            $user_list=Student::whereIn('id', $user_ids)->get();

            foreach ($StudentList as $key => $value){

                $find_student= $user_list->where('id', $value['user_id'])->first();

                $find_student->sms_contact_field=$value['student']['sms_contact_field'];
                $find_student->save();

            }

            return Response::json(['message' => 'Successfully Updated',
                'mode' => 'success'], 200);
        }

        private function classGroupSectionValidation($request){

            $check_group_section=SiteShiftClassGroupSectionSetting::
            where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->first();


            if($check_group_section->academic_department_id && !$request->academic_department_id){
                return Response::json(['message' => 'Plese Select Department!', 'mode' => 'Error'], 200);
            }


        }


}
