<?php

namespace App\Http\Controllers\Site\Student\Attendance;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSubject;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Traits\Site\Leave\Employee\LeaveFunction;
use App\Traits\Site\Routine\RoutineFunction;
use Carbon\Carbon;
use DateInterval;
use DatePeriod;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Site\Duty\Employee\DutyFunction;
use Response;
use PDF;
use Session;


class AttendanceReportController extends ProjectController
{
    use RoutineFunction, LeaveFunction, DutyFunction;

    private $carbon_now;

    private $studentAttendance;
    private $studentHistory;
    private $user;
    private $student;
    private $siteShiftDetails;
    private $academicClass;
    private $academicSection;
    private $periodTypeDuration;
    private $routineDetail;
    private $routineAllocation;


    public function __construct(RoutineDetail $routineDetail, StudentAttendance $studentAttendance, User $user, RoutineAllocation $routineAllocation,
                                SiteShiftDetails $siteShiftDetails, AcademicSection $academicSection, Student $student, StudentHistory $studentHistory,
                                AcademicClass $academicClass, SitePeriodTypeDuration $periodTypeDuration)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->carbon_now = Carbon::now();

        $this->studentAttendance = $studentAttendance;
        $this->user = $user;
        $this->student = $student;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->academicClass = $academicClass;
        $this->academicSection = $academicSection;
        $this->routineDetail = $routineDetail;
        $this->routineAllocation = $routineAllocation;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->studentHistory = $studentHistory;

    }


    public function subjectAndDateWise($academic_version_id, $academic_year_id, $academic_shift_id, $academic_department_id, $academic_class_id, $academic_class_group_id, $academic_section_id, $academic_session_id, $routine_allocation_id, $attDate, $status)
    {
        $report_tittle = 'Attendance Report';

        if (!$routine_allocation_id) {
            return Response::json(['message' => 'Please Select Subject!'], 411);

        }

        //  dd('fdhfg');
        $att_date = $attDate != '0' ? $attDate : date('Y-m-d', time());
        $routine_allocation = $this->routineAllocation->findOrFail($routine_allocation_id);


        $att_data = $this->studentAttendance
            ->where('present_date', $att_date)
            ->where('present_type', 'subject')
            ->where('routine_allocation_id', $routine_allocation_id)
            ->get();


//        return view('default.admin.site.attendance.report.routine-report',)
        $site = SiteInfo::findOrFail(Session::get('SITE_ID'));
        $subject = AcademicSubject::where('id', $routine_allocation->subject_id)->first();
        $class = AcademicClass::where('id', $academic_class_id)->first();
        $section = AcademicSection::where('id', $academic_section_id)->first();


        return 'The pdf in progress!';


        $pdf = PDF::loadView('default.admin.site.attendance.report.routine-report', compact('att_data', 'att_date', 'subject', 'class', 'section', 'report_tittle'));
        return $pdf->stream(time() . '-manual-attendance.pdf');
    }


    public function classWiseReport(Request $request)
    {

        ini_set('memory_limit', '-1');


        $start = $request->start_date;
        $end = $request->end_date;


        //  $this->periodWiseReport($request);

        $data = [];
        $data['status'] = $request->status ?? 1;
        $data['student_history_id'] = $request->student_history_id == 'null' ? null : $request->student_history_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;

        $advance_date = ($this->carbon_now->toDateString() < $start);

        if ($advance_date) {
            return 'The date can"t be future date!';
        }

        if (!$start || !$end) {
            return 'Select * Marked Fields!';
        }

     //   dd($data);

        $st_att_list = $this->studentHistory
        // ->when($data['student_history_id'], function ($query) use ($data) {
        //     $query->where('id', $data['student_history_id']);
        // })
        ->when($data['academic_version_id'], function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })->when($data['academic_year_id'], function ($query) use ($data) {
            return $query->where('academic_year_id', $data['academic_year_id']);
        })->when($data['academic_shift_id'], function ($query) use ($data) {
            return $query->where('academic_shift_id', $data['academic_shift_id']);
        })->when($data['academic_class_id'], function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })->when($data['academic_department_id'], function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })->when($data['academic_section_id'], function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })->when($data['academic_class_group_id'], function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })->when($data['academic_session_id'], function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })->when($data['site_batch_detail_id'], function ($query) use ($data) {
            return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
        })
        ->orderBy('student_roll_number', 'ASC')
        ->orderBy('academic_section_id', 'ASC')
        ->orderBy('academic_class_id', 'ASC')
        ->where('status', $data['status'])
        ->with(['attendances' => function ($q) use ($start, $end) {
            $q->whereBetween('present_date', [$start, $end]);
        }])
        ->select('id', 'user_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id', 'academic_section_id',
            'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id')
        //  ->limit(10)
        ->get();



        $final_data = [];

        foreach ($st_att_list as $k => $item) {

            $begins = $start;
            $ends = $end;
            $dk = 0;


         while (strtotime($begins) <= strtotime($ends)) {
          //  $date = date("d-m-Y", strtotime($begins));
            $final_data[$k]['roll'] = ($item->student_roll_number ?? '');
            $final_data[$k]['name'] = ($item->full_name ?? '');

                $date = date("d-m-Y", strtotime($begins));

                // $final_data[$k]['data'][$dk]['date'] = $date??"";
                // $final_data[$k]['data'][$dk]['in_time'] = $item->attendances[$dk]->in_time ?? '';
                // $final_data[$k]['data'][$dk]['out_time'] = $item->attendances[$dk]->out_time ?? '';

                // if($date==$begins){
                //     $final_data[$k]['data'][$dk]['st_status'] = 'Present';
                // }else{
                //     $final_data[$k]['data'][$dk]['st_status'] = 'Absebt';
                // }


            foreach($item->attendances as $dk=>$attendance){

                $final_data[$k]['data'][$dk]['date'] = date("d-m-Y", strtotime($attendance->present_date))??"";
                $final_data[$k]['data'][$dk]['in_time'] = $attendance->in_time ?? '';
                $final_data[$k]['data'][$dk]['out_time'] = $attendance->out_time ?? '';
                $final_data[$k]['data'][$dk]['st_status'] = 'Present';

             }
             $begins = date("d-m-Y", strtotime("+1 day", strtotime($begins)));

             $dk++;
        }
        }

        $report_tittle2 = '';

        if (count($st_att_list) < 1) {
            return 'No Attendance Found For: ' . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        }


        $page_tittle = "Daily Attendance Report For " . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        $report_tittle = "<b>Daily Attendance Report </b> <br>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

        $report_tittle2 .= '<b>Version:</b>' . ($st_att_list[0]->version->version_name);
        $report_tittle2 .= '<b> Year:</b>' . ($st_att_list[0]->year->year_name);

        if ($st_att_list[0]->shift) {
            $report_tittle2 .= ' <b>Shift:</b>' . ($st_att_list[0]->shift->shift_name);
        }

        if ($st_att_list[0]->department) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($st_att_list[0]->department->dept_name);
        }

        if ($st_att_list[0]->stClass) {
            $report_tittle2 .= ' <b>Class:</b>' . ($st_att_list[0]->stClass->class_name);
        }

        if ($st_att_list[0]->classGroup) {
            $report_tittle2 .= ' <b>Group:</b>' . ($st_att_list[0]->classGroup->group_name);
        }

        if ($st_att_list[0]->section) {
            $report_tittle2 .= ' <b>Section:</b>' . ($st_att_list[0]->section->section_name);
        }

        // return view('default.site.student.attendance.report.class-wise-report', compact('st_att_list', 'sl', 'report_tittle', 'page_tittle', 'report_tittle2'));


        if ($data['student_history_id']) {
            $report_tittle = "<b>" . $st_att_list[0]['full_name'] . "'s Attendance Report </b>";
            $report_tittle2 = "<b>Date Range:</b>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

            /*  if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.student-wise-date-range-report')) {
                  $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.student-wise-date-range-report', compact('st_att_list', 'sl', 'page_tittle', 'report_tittle', 'report_tittle2'));
              } else {
                  $pdf = PDF::loadView('default.site.student.attendance.report.student-wise-date-range-report', compact('st_att_list', 'sl', 'report_tittle', 'page_tittle', 'report_tittle2'));
              }
              return $pdf->stream(time() . '-student-attendance.pdf');*/

        }

        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.class-wise-report')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.class-wise-report', compact('final_data', 'page_tittle', 'report_tittle', 'report_tittle2'));
        } else {
            $pdf = PDF::loadView('default.site.student.attendance.report.class-wise-report', compact('final_data', 'report_tittle', 'page_tittle', 'report_tittle2'));
        }
        return $pdf->stream(time() . '-student-attendance.pdf');


    }

    public function studentAttendanceCountReport(Request $request)
    {

        ini_set('memory_limit', '-1');

        $start = $request->start_date;
        $end = $request->end_date;

        //  $this->periodWiseReport($request);

        $data = [];
        $data['status'] = $request->status ?? 1;
        $data['st_id'] = $request->st_id == 'null' ? null : $request->st_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;

        $advance_date = ($this->carbon_now->toDateString() < $start);

        if ($advance_date) {
            return 'The date can"t be future date!';
        }

        if (!$start || !$end) {
            return 'Select * Marked Fields!';
        }

        $st_att_list = $this->studentHistory->when($data['st_id'], function ($query) use ($data) {
            $query->where('id', $data['st_id']);
        })->when($data['academic_version_id'], function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })->when($data['academic_year_id'], function ($query) use ($data) {
            return $query->where('academic_year_id', $data['academic_year_id']);
        })->when($data['academic_shift_id'], function ($query) use ($data) {
            return $query->where('academic_shift_id', $data['academic_shift_id']);
        })->when($data['academic_class_id'], function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })->when($data['academic_department_id'], function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })->when($data['academic_section_id'], function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })->when($data['academic_class_group_id'], function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })->when($data['academic_session_id'], function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })->when($data['site_batch_detail_id'], function ($query) use ($data) {
            return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
        })
        ->orderBy('academic_class_id', 'ASC')
        ->orderBy('academic_section_id', 'ASC')
        ->orderBy('student_roll_number', 'ASC')
        ->where('status', $data['status'])
        ->with(['attendances' => function ($q) use ($start, $end) {
            $q->whereBetween('present_date', [$start, $end]);
        }])
        ->select('id', 'user_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id', 'academic_section_id',
            'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id')
        //  ->limit(10)
        ->get();

        // for sections
        $unique_array_by_section = collect($st_att_list)->unique('academic_section_id')->all();

        $section = [];
        if(count($unique_array_by_section)>=1){
            foreach($unique_array_by_section as $key=>$value){
                $section[$key] = $value->section?$value->section->section_name:null;
               // dd($value->section);
            }
        }



        $final_data = [];

        foreach ($st_att_list as $k => $item) {

            $begins = $start;
            $ends = $end;
            $day_count = 1;


         while (strtotime($begins) <= strtotime($ends)) {
          //  $date = date("d-m-Y", strtotime($begins));

            if($item->attendances){
                $present_count = count($item->attendances);
            }

            $final_data[$k]['roll'] = ($item->student_roll_number ?? '');
            $final_data[$k]['name'] = ($item->full_name ?? '');
            $final_data[$k]['day_count'] = $day_count;
            $final_data[$k]['present_count'] = $present_count;
            $final_data[$k]['absent_count'] = $day_count - $present_count;

            $attendance_petcent=($present_count/$day_count)*100;

            $final_data[$k]['attendance_petcent'] =number_format((float)$attendance_petcent, 2, '.', '');

             $day_count++;
             $begins = date("d-m-Y", strtotime("+1 day", strtotime($begins)));

        }
        }

        $report_tittle2 = '';

        if (count($st_att_list) < 1) {
            return 'No Attendance Found For: ' . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        }


        $page_tittle = "Student Attendance Count Report For " . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        $report_tittle = "<b>Student Attendance Count Report </b> <br>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end)).' <br> Total Day: '.($day_count-1);

        $report_tittle2 .= '<b>Version:</b>' . ($st_att_list[0]->version->version_name);
        $report_tittle2 .= '<b> Year:</b>' . ($st_att_list[0]->year->year_name);

        if ($st_att_list[0]->shift) {
            $report_tittle2 .= ' <b>Shift:</b>' . ($st_att_list[0]->shift->shift_name);
        }

        if ($st_att_list[0]->department) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($st_att_list[0]->department->dept_name);
        }

        if ($st_att_list[0]->stClass) {
            $report_tittle2 .= ' <b>Class:</b>' . ($st_att_list[0]->stClass->class_name);
        }

        if ($st_att_list[0]->classGroup) {
            $report_tittle2 .= ' <b>Group:</b>' . ($st_att_list[0]->classGroup->group_name);
        }

        if ($st_att_list[0]->section) {
            $report_tittle2 .= ' <b>Section:</b>' . implode(', ',$section);
            //($st_att_list[0]->section->section_name);
        }

        // return view('default.site.student.attendance.report.class-wise-report', compact('st_att_list', 'sl', 'report_tittle', 'page_tittle', 'report_tittle2'));


        if ($data['st_id']) {
           $report_tittle = "<b>" . $st_att_list[0]['name'] . "'s Attendance Report </b>";
           $report_tittle2 = "<b>Date Range:</b>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

        }


        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.student-attendance-report-count')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.student-attendance-report-count', compact('final_data', 'page_tittle', 'report_tittle', 'report_tittle2'));
        } else {
            $pdf = PDF::loadView('default.site.student.attendance.report.student-attendance-report-count', compact('final_data', 'report_tittle', 'page_tittle', 'report_tittle2'));
        }
        return $pdf->stream(time() . '-student-attendance-count.pdf');


    }

    private function studentHistoryList($request){

        $data = [];
        $data['status'] = $request->status ?? 1;
        $data['st_id'] = $request->st_id == 'null' ? null : $request->st_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;

      //  dd($data);
      $start = $request->start_date;
      $end = $request->end_date;

        $advance_date = ($this->carbon_now->toDateString() < $start);

        if ($advance_date) {
            return 'The date can"t be future date!';
        }

        if (!$start || !$end) {
            return 'Select * Marked Fields!';
        }

        $st_att_list = $this->studentHistory
        ->when($data['student_history_id'], function ($query) use ($data) {
            $query->where('id', $data['st_id']);
        })->when($data['academic_version_id'], function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })->when($data['academic_year_id'], function ($query) use ($data) {
            return $query->where('academic_year_id', $data['academic_year_id']);
        })->when($data['academic_shift_id'], function ($query) use ($data) {
            return $query->where('academic_shift_id', $data['academic_shift_id']);
        })->when($data['academic_class_id'], function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })->when($data['academic_department_id'], function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })->when($data['academic_section_id'], function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })->when($data['academic_class_group_id'], function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })->when($data['academic_session_id'], function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })->when($data['site_batch_detail_id'], function ($query) use ($data) {
            return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
        })

        ->where('status', $data['status'])
        ->with(['attendances' => function ($q) use ($start, $end) {
            $q->whereBetween('present_date', [$start, $end]);
        }])
        ->orderBy('student_roll_number', 'ASC')
        ->orderBy('academic_section_id', 'ASC')
        ->orderBy('academic_class_id', 'ASC')
        ->select('id', 'user_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id', 'academic_section_id',
            'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id')
        //  ->limit(10)
        ->get();

    }

    public function monthlyClassWiseReport(Request $request)
    {

        ini_set('memory_limit', '-1');




        $begins1 = $request->start_date;
        $ends1 = $request->end_date;
        $k = 0;
           $atten_date=[];
            while (strtotime($begins1) <= strtotime($ends1)) {
                $atten_date[$k] = date("d", strtotime($begins1));
                $begins1 = date("Y-m-d", strtotime("+1 day", strtotime($begins1)));
                $k++;
            }

        //  $this->periodWiseReport($request);



         $data = [];
         $data['status'] = $request->status ?? 1;
         $data['student_history_id'] = $request->student_history_id == 'null' ? null : $request->student_history_id; // Add this line
         $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
         $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
         $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
         $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
         $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
         $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
         $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
         $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
         $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;

       //  dd($data);
       $start = $request->start_date;
       $end = $request->end_date;

         $advance_date = ($this->carbon_now->toDateString() < $start);

         if ($advance_date) {
             return 'The date can"t be future date!';
         }

         if (!$start || !$end) {
             return 'Select * Marked Fields!';
         }

         $st_att_list = $this->studentHistory
         ->when(isset($data['student_history_id']), function ($query) use ($data) {
             $query->where('id', $data['student_history_id']);
         })->when($data['academic_version_id'], function ($query) use ($data) {
             return $query->where('academic_version_id', $data['academic_version_id']);
         })->when($data['academic_year_id'], function ($query) use ($data) {
             return $query->where('academic_year_id', $data['academic_year_id']);
         })->when($data['academic_shift_id'], function ($query) use ($data) {
             return $query->where('academic_shift_id', $data['academic_shift_id']);
         })->when($data['academic_class_id'], function ($query) use ($data) {
             return $query->where('academic_class_id', $data['academic_class_id']);
         })->when($data['academic_department_id'], function ($query) use ($data) {
             return $query->where('academic_department_id', $data['academic_department_id']);
         })->when($data['academic_section_id'], function ($query) use ($data) {
             return $query->where('academic_section_id', $data['academic_section_id']);
         })->when($data['academic_class_group_id'], function ($query) use ($data) {
             return $query->where('academic_class_group_id', $data['academic_class_group_id']);
         })->when($data['academic_session_id'], function ($query) use ($data) {
             return $query->where('academic_session_id', $data['academic_session_id']);
         })->when($data['site_batch_detail_id'], function ($query) use ($data) {
             return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
         })

         ->where('status', $data['status'])
         ->with(['attendances' => function ($q) use ($start, $end) {
             $q->whereBetween('present_date', [$start, $end]);
         }])
         ->orderBy('student_roll_number', 'ASC')
         ->orderBy('academic_section_id', 'ASC')
         ->orderBy('academic_class_id', 'ASC')
         ->select('id', 'user_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id', 'academic_section_id',
             'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id')
         //  ->limit(10)
         ->get();





       $final_data = [];

       foreach ($st_att_list as $k => $item) {

           $begins = $start;
           $ends = $end;
           $dk = 0;
           $present_days=0;
           $absent_days=0;

           while (strtotime($begins) <= strtotime($ends)) {


               $final_data[$k]['roll'] = ($item->student_roll_number ?? '');
               $final_data[$k]['name'] = ($item->full_name ?? '');

               $attendance_record = $item->attendances->firstWhere('present_date', $begins);

               if ($attendance_record) {
                $status_type = "P";
                $present_days++;
                } else {
                    $status_type = "A";
                    $absent_days++;
                }
                $final_data[$k]['data'][$dk]['st_status'] = $status_type;

               $begins = date("Y-m-d", strtotime("+1 day", strtotime($begins)));

               $dk++;

             //  $status_type++;
             $final_data[$k]['present_days'] = $present_days;
             $final_data[$k]['apsent_days'] = $absent_days;

           }
       }

        $report_tittle2 = '';

        if (count($st_att_list) < 1) { //$start,$end
            return 'No Attendance Found For: ' . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        }


        $page_tittle = "Daily Attendance Report For " . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        $report_tittle = "<b>Daily Attendance Report </b> <br>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

        $report_tittle2 .= '<b>Version:</b>' . ($st_att_list[0]->version->version_name);
        $report_tittle2 .= '<b> Year:</b>' . ($st_att_list[0]->year->year_name);

        if ($st_att_list[0]->shift) {
            $report_tittle2 .= ' <b>Shift:</b>' . ($st_att_list[0]->shift->shift_name);
        }

        if ($st_att_list[0]->department) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($st_att_list[0]->department->dept_name);
        }

        if ($st_att_list[0]->stClass) {
            $report_tittle2 .= ' <b>Class:</b>' . ($st_att_list[0]->stClass->class_name);
        }

        if ($st_att_list[0]->classGroup) {
            $report_tittle2 .= ' <b>Group:</b>' . ($st_att_list[0]->classGroup->group_name);
        }

        if ($st_att_list[0]->section) {
            $report_tittle2 .= ' <b>Section:</b>' . ($st_att_list[0]->section->section_name);
        }

        if ($data['student_history_id']) {
            $report_tittle = "<b>" . $st_att_list[0]['name'] . "'s Attendance Report </b>";
            $report_tittle2 = "<b>Date Range:</b>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

        }



        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.monthly-class-wise-report')) {

            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.monthly-class-wise-report',
                        compact('atten_date', 'final_data', 'page_tittle', 'report_tittle', 'report_tittle2'))
                        ->setPaper('a4', 'landscape')
                        ->setWarnings(false);
        } else {
            $pdf = PDF::loadView('default.site.student.attendance.report.monthly-class-wise-report',
                        compact('atten_date', 'final_data', 'report_tittle', 'page_tittle', 'report_tittle2'))
                        ->setPaper('a4', 'landscape')
                        ->setWarnings(false);
        }
      return $pdf->stream(time() . '-student-attendance.pdf');


    }


    public function periodWiseReport(Request $request)
    {

        ini_set('memory_limit', '-1');


        $start = $request->start_date;
        $end = $request->end_date;


        $data = [];
        $data['status'] = $request->status ?? 1;
        $data['st_id'] = $request->st_id == 'null' ? null : $request->st_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;
      

//        dd($data);


        $advance_date = ($this->carbon_now->toDateString() < $start);

        if ($advance_date) {
            return 'The date can"t be future date!';
        }

        if (!$start || !$end) {
            return 'Select * Marked Fields!';
        }

        


        $st_att_list = $this->studentHistory
            ->when($data['st_id'], function ($query) use ($data) {
                $query->where('id', $data['st_id']);

            })->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->where('status', $data['status'])
            ->with(['periodics' => function ($q) use ($start, $end) {
                $q->whereBetween('present_date', [$start, $end]);
            }, 'student', 'student.translations', 'version', 'year', 'shift', 'department', 'stClass', 'classGroup', 'session', 'section'])
            ->select('id', 'user_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id', 'academic_section_id',
                'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id')
             //  ->limit(1)
            //   ->count();
            ->get();


        $final_data = [];

        foreach ($st_att_list as $k => $item) {


            $begins = $start;
            $ends = $end;
            $dk = 0;

            while (strtotime($begins) <= strtotime($ends)) {
                $date = date("d M yy", strtotime($begins));
                $date_db_format = date("Y-m-d", strtotime($begins));
                $is_working_day = $this->isTheDateOpen($date_db_format);
                if (!$is_working_day) {
                    $begins = date("Y-m-d", strtotime("+1 day", strtotime($begins)));
                    continue;
                }

                $total_period = $this->getStudentsPeriodCount($date_db_format, $item->id);
                $present = count($item->periodics->where('is_present', true)->where('present_date', $date_db_format));

                if ($total_period) {
                    $final_data[$k]['roll'] = ($item->student_roll_number ?? '');
                    $final_data[$k]['name'] = ($item->full_name ?? '');
                    $final_data[$k]['data'][$dk]['date'] = $date;
                    $final_data[$k]['data'][$dk]['total_period'] = $total_period;
                    $final_data[$k]['data'][$dk]['attended'] = $present;
                    $final_data[$k]['data'][$dk]['absent'] = ($total_period - $present);
                    $final_data[$k]['data'][$dk]['leave'] = count($item->periodics->where('in_leave', true));
                }

                $begins = date("Y-m-d", strtotime("+1 day", strtotime($begins)));
                $dk++;

            }
        }

        $report_tittle2 = '';

        if (count($st_att_list) < 1) { //$start,$end
            return 'No Attendance Found For: ' . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        }


        $page_tittle = "Attendance Report For" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        $report_tittle = "<b>Student Attendance Report </b> <br>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

        $report_tittle2 .= '<b>Version:</b>' . ($st_att_list[0]->version->version_name);
        $report_tittle2 .= '<b> Year:</b>' . ($st_att_list[0]->year->year_name);

        if ($st_att_list[0]->shift) {
            $report_tittle2 .= ' <b>Shift:</b>' . ($st_att_list[0]->shift->shift_name);
        }

        if ($st_att_list[0]->department) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($st_att_list[0]->department->dept_name);
        }

        if ($st_att_list[0]->stClass) {
            $report_tittle2 .= ' <b>Class:</b>' . ($st_att_list[0]->stClass->class_name);
        }

        if ($st_att_list[0]->classGroup) {
            $report_tittle2 .= ' <b>Group:</b>' . ($st_att_list[0]->classGroup->group_name);
        }

        if ($st_att_list[0]->section) {
            $report_tittle2 .= ' <b>Section:</b>' . ($st_att_list[0]->section->section_name);
        }


        // return view('default.site.student.attendance.report.class-wise-report', compact('st_att_list', 'sl', 'report_tittle', 'page_tittle', 'report_tittle2'));

        if ($data['st_id']) {
            // $report_tittle2 .= "<b>" . $final_data[0]['name'] . " <b>Roll:</b>" . $final_data[0]['roll'];
            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.class-wise-report')) {
                $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.periodic-wise-report', compact('final_data', 'page_tittle', 'report_tittle', 'report_tittle2'));
            } else {
                $pdf = PDF::loadView('default.site.student.attendance.report.periodic-wise-report', compact('final_data', 'report_tittle', 'page_tittle', 'report_tittle2'));
            }
            return $pdf->stream(time() . '-student-periodic-attendance.pdf');

        }

        //  dd($report_tittle, $report_tittle2);

        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.class-wise-report')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.periodic-wise-report', compact('final_data', 'page_tittle', 'report_tittle', 'report_tittle2'));
        } else {
            $pdf = PDF::loadView('default.site.student.attendance.report.periodic-wise-report', compact('final_data', 'report_tittle', 'page_tittle', 'report_tittle2'));
        }
        return $pdf->stream(time() . '-student-periodic-attendance.pdf');


    }

    public function periodWiseDateRangeCountReport(Request $request)
    {
        // return 'The report is in progress';


        ini_set('memory_limit', '-1');


        $start = $request->start_date;
        $end = $request->end_date;


        $data = [];
        $data['status'] = $request->status ?? 1;
        $data['st_id'] = $request->st_id == 'null' ? null : $request->st_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;


        //   dd($data);


        $advance_date = ($this->carbon_now->toDateString() < $start);

        if ($advance_date) {
            return 'The date can"t be future date!';
        }

        if (!$start || !$end) {
            return 'Select * Marked Fields!';
        }


        $st_att_list = $this->studentHistory
            ->when($data['st_id'], function ($query) use ($data) {
                $query->where('id', $data['st_id']);
            })->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->where('status', $data['status'])
            ->with(['periodics.allocation', 'periodics' => function ($q) use ($start, $end) {
                $q->whereBetween('present_date', [$start, $end]);

            }, 'student', 'student.translations', 'version', 'year', 'shift', 'department', 'stClass', 'classGroup', 'session', 'section'])
            ->select('id', 'user_id', 'site_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id',
                'academic_department_id', 'academic_section_id', 'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id',
                'academic_subject_ids')
           //   ->limit(1)
            //   ->count();
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->get();

        $class_subjects = $this->getClassSubjects($request);


        $final_data = [];


        foreach ($st_att_list as $k => $item) {

            // $subjects = $this->studentSubjectIds($item);


            foreach ($class_subjects as $sk => $subject) {

                $subject_id = $subject->id;

                if (in_array($subject_id, $item->academic_subject_ids[1])) {

                    $total_period = $this->getStudentsSubjectPeriodCount($start, $end, $subject_id, $item->id);
                    $present = $item->periodics()
                        ->where('is_present', true)
                        ->whereHas('allocation', function ($q) use ($subject_id) {
                            $q->where('subject_id', $subject_id);
                        })->whereBetween('present_date', [$start, $end])
                        ->count();


                    // dd($present);

                    if ($total_period) {
                        $final_data[$k]['roll'] = ($item->student_roll_number ?? '');
                        $final_data[$k]['name'] = ($item->full_name ?? '');
                        $final_data[$k]['data'][$sk]['s_name'] = $subject->subject_name; //;. '- ' . $subject->id;
                        $final_data[$k]['data'][$sk]['total_period'] = $total_period ?? '';
                        $final_data[$k]['data'][$sk]['attended'] = $present;
                        $final_data[$k]['data'][$sk]['absent'] = $total_period ? ($total_period - $present) : null;
                        $final_data[$k]['data'][$sk]['leave'] = count($item->periodics->where('in_leave', true));
                    }


                }
            }
        }

        // dd($final_data);


        $report_tittle2 = '';

        if (count($st_att_list) < 1) { //$start,$end
            return 'No Attendance Found For: ' . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        }


        $page_tittle = "Attendance Report For" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));
        $report_tittle = "<b>Student Attendance Report </b> <br>" . date('d M Y', strtotime($start)) . ' - ' . date('d M Y', strtotime($end));

        $report_tittle2 .= '<b>Version:</b>' . ($st_att_list[0]->version->version_name);
        $report_tittle2 .= '<b> Year:</b>' . ($st_att_list[0]->year->year_name);

        if ($st_att_list[0]->shift) {
            $report_tittle2 .= ' <b>Shift:</b>' . ($st_att_list[0]->shift->shift_name);
        }

        if ($st_att_list[0]->department) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($st_att_list[0]->department->dept_name);
        }

        if ($st_att_list[0]->stClass) {
            $report_tittle2 .= ' <b>Class:</b>' . ($st_att_list[0]->stClass->class_name);
        }

        if ($st_att_list[0]->classGroup) {
            $report_tittle2 .= ' <b>Group:</b>' . ($st_att_list[0]->classGroup->group_name);
        }

        if ($st_att_list[0]->section) {
            $report_tittle2 .= ' <b>Section:</b>' . ($st_att_list[0]->section->section_name);
        }


        // return view('default.site.student.attendance.report.period-wise-date-range-count-report', compact('st_att_list', 'sl', 'report_tittle', 'page_tittle', 'report_tittle2'));

        if ($data['st_id']) {
            // $report_tittle2 .= "<b>" . $final_data[0]['name'] . " <b>Roll:</b>" . $final_data[0]['roll'];
            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.period-wise-date-range-count-report')) {
                $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.period-wise-date-range-count-report', compact('final_data', 'class_subjects', 'page_tittle', 'report_tittle', 'report_tittle2'));
            } else {
                $pdf = PDF::loadView('default.site.student.attendance.report.period-wise-date-range-count-report', compact('final_data', 'class_subjects', 'report_tittle', 'page_tittle', 'report_tittle2'));
            }
            return $pdf->stream(time() . '-student-periodic-attendance.pdf');

        }

        //  dd($report_tittle, $report_tittle2);

        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.period-wise-date-range-count-report')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.period-wise-date-range-count-report', compact('final_data', 'class_subjects', 'page_tittle', 'report_tittle', 'report_tittle2'));
        } else {
            $pdf = PDF::loadView('default.site.student.attendance.report.period-wise-date-range-count-report', compact('final_data', 'class_subjects', 'report_tittle', 'page_tittle', 'report_tittle2'));
        }

        return $pdf->stream(time() . '-student-periodic-attendance-count-report.pdf');



    }

    public function periodWiseDateRangeCountDetails(Request $request)
    {
        // return 'The report is in progress';


        ini_set('memory_limit', '-1');


        $start = $request->start_date;
        $end = $request->end_date;
        $paginate = $request->paginate ?? 20;


        $data = [];
        $data['status'] = $request->status ?? 1;
        $data['st_id'] = $request->st_id == 'null' ? null : $request->st_id;
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;


        //\Log::info($data);


        $this->checkClassSection($data);


        $advance_date = ($this->carbon_now->toDateString() < $start);

        if ($advance_date) {
            return response()->json(['message' => 'The date can"t be future date!'], 412);
        }

        if (!$start || !$end) {
            return response()->json(['message' => 'Select * Marked Fields!'], 412);
        }


        $st_att_list = $this->studentHistory
            ->when($data['st_id'], function ($query) use ($data) {
                $query->where('id', $data['st_id']);
            })->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_section_id', $data['academic_section_id'])
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->where('status', $data['status'])
            ->with(['periodics.allocation', 'periodics' => function ($q) use ($start, $end) {

                $q->whereBetween('present_date', [$start, $end]);

            }, 'student', 'student.translations', 'version', 'year', 'shift', 'department', 'stClass', 'classGroup', 'session', 'section'])
            ->select('id', 'user_id', 'site_id', 'student_roll_number', 'academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id',
                'academic_department_id', 'academic_section_id', 'academic_class_group_id', 'academic_session_id', 'academic_class_group_id', 'site_batch_detail_id',
                'academic_subject_ids')
            // ->limit(10)
            //->skip(1)
            //   ->count();
            ->paginate($paginate);


        $class_subjects = $this->getClassSubjects($request);


        $st_att_list->getCollection()->transform(function ($item) use ($class_subjects, $start, $end) {
            $final_data = [];
            $sk = 0;
            foreach ($class_subjects as $sk1 => $subject) {
                $subject_id = $subject->id;

                if (in_array($subject_id, $item->academic_subject_ids[1])) {
                    $total_period = $this->getStudentsSubjectPeriodCount($start, $end, $subject_id, $item->id);
                    $present = $item->periodics()
                        ->where('is_present', true)
                        ->whereHas('allocation', function ($q) use ($subject_id) {
                            $q->where('subject_id', $subject_id);
                        })->whereBetween('present_date', [$start, $end])
                        ->count();


                    if ($total_period) {
                        $final_data[$sk]['id'] = $subject->id; //;. '- ' . $subject->id;
                        $final_data[$sk]['s_name'] = $subject->subject_name; //;. '- ' . $subject->id;
                        $final_data[$sk]['total_period'] = $total_period ?? '';
                        $final_data[$sk]['attended'] = $present;
                        $final_data[$sk]['absent'] = $total_period ? ($total_period - $present) : null;
                        $final_data[$sk]['leave'] = count($item->periodics->where('in_leave', true));
                        $sk++;
                    }


                }

            }
            return [
                'username' => ($item->student->username ?? ''),
                'roll' => ($item->student_roll_number ?? ''),
                'sms_sending' => false,
                'name' => ($item->full_name ?? ''),
                'data' => $final_data ?? '',
                'contact_number' => $item->student->contact_number ?? '',
            ];


        });


//        \Log::info($st_att_list);

        return response()->json($st_att_list, 200);


    }

    public function studentWiseDateRangeReport(Request $request)
    {

        $start = $request->start_date;
        $end = $request->end_date;
        $user_name = $request->user_name;

        $page_tittle = "Student Wise Attendance Report";
        $report_tittle = "<b>Student Attendance Report</b> <br/>";
        $advance_date = ($this->carbon_now->toDateString() < $start);

        $student = $this->student->where('username', $user_name)->first();

        if (!$student) {
            return 'Student Not Found!';
        }

        if ($advance_date) {
            return 'The date can"t be future date!';
        }

        if (!$start || !$end || !$user_name) {
            return 'Select * Marked Fields!';
        }

        $att_data = $this->studentAttendance
            ->whereBetween('present_date', [$start, $end])
            ->where(function ($query) {
                $query->where('present_type', 'device')
                    ->orWhere('present_type', 'web');
            })->whereHas('studentHistory', function ($q) use ($user_name) {
                $q->whereHas('student', function ($q) use ($user_name) {
                    $q->where('username', $user_name);
                });
            })
            ->orderBy('present_date', 'ASC')
            ->get();

        if (count($att_data) < 1) {
            return 'No Data Found';
        }


        $report_tittle .= '<b> Version: </b>' . ($att_data[0]->studentHistory->version->version_name ?? 'n/a');
        $report_tittle .= '<b> Year: </b>' . ($att_data[0]->studentHistory->year->year_name ?? 'n/a');
        $report_tittle .= '<b> Shift:</b>' . ($att_data[0]->studentHistory->shift->shift_name ?? 'n/a');

        $report_tittle .= ' <br/><b> Student Name:</b> ' . ($att_data[0]->studentHistory->student->full_name ?? 'N/F');
        $report_tittle .= ' <b> Class:</b>' . ($att_data[0]->studentHistory->stClass->class_name ?? 'n/a');

        if ($att_data[0]->studentHistory->classGroup) {
            $report_tittle .= ' <b> Group:</b>' . ($att_data[0]->studentHistory->classGroup->group_name ?? 'n/a');
        }

        if ($att_data[0]->studentHistory->section) {
            $report_tittle .= ' Section:' . ($att_data[0]->studentHistory->section->section_name ?? 'n/a');
        }
        $report_tittle2 = '<br/><b> From</b> ' . date('d M Y', strtotime($start)) . ' <b>to</b> ' . date('d M Y', strtotime($end));

        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.attendance.report.student-wise-date-range-report')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.attendance.report.student-wise-date-range-report', compact('att_data', 'page_tittle', 'report_tittle', 'report_tittle2'));
        } else {
            view('default.site.student.attendance.report.student-wise-date-range-report', compact('att_data', 'report_tittle'));
            $pdf = PDF::loadView('default.site.student.attendance.report.student-wise-date-range-report', compact('att_data', 'report_tittle', 'page_tittle', 'report_tittle2'));
        }
        return $pdf->stream(time() . '-student-attendance.pdf');


    }


    public function getDailyAttendanceFullReport(Request $request)
    {



        ini_set('memory_limit', '-1');

        // \Log::info($request->studentlist[0]['student']['latest_photo']['name']);

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;

        $att_date = $request->att_date;
        $present = $request->present;
        $leave = $request->leave;
        $absent = $request->absent;
        $search_txt = $request->search_txt;
        $status = $request->status;
        $txt = '%' . $search_txt . '%';


        if ($present && $leave && $absent) {
            $present = 0;
            $leave = 0;
            $absent = 0;
        }


        $advance_date = ($this->carbon_now->toDateString() < $att_date);

        if ($advance_date) {
            throw new Error('The date can"t be future date!');
        }

        if (!$att_date || !$data['academic_version_id']) {
            throw new Error('Please Select Date|Version |Year  Fields!');
        }


        $student_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->get();

        if($present && ($absent || $leave)){
            $st_att_list = $student_list;
        }elseif($absent || $leave){

            $student_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(($absent || $leave), function ($qu) use ($att_date) {
                return $qu->whereHas('attendance', function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                })->orWhereHas('leaveDetail', function ($q) use ($att_date) {
                    $q->leaveToday($att_date);
                });
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->get();



        $present_student_id = $student_list->pluck('id')
        ->unique()
        ->filter();;


        $absent_student = $this->studentHistory
        ->when($data['academic_version_id'], function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })->when($data['academic_year_id'], function ($query) use ($data) {
            return $query->where('academic_year_id', $data['academic_year_id']);
        })->when($data['academic_shift_id'], function ($query) use ($data) {
            return $query->where('academic_shift_id', $data['academic_shift_id']);
        })->when($data['academic_class_id'], function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })->when($data['academic_department_id'], function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })->when($data['academic_section_id'], function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })->when($data['academic_class_group_id'], function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })->when($data['academic_session_id'], function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })->whereNotIn('id',$present_student_id)
        ->with(['student'])
        ->with(['attendance' => function ($q) use ($att_date) {
            $q->where('present_date', $att_date);
        }, 'absent' => function ($q) use ($att_date) {
            $q->where('absent_date', $att_date);
        }, 'leaveDetail' => function ($q) use ($att_date) {
            $q->where('leave_date', $att_date);
        }
        ])
        ->where('status', $status)
        ->get();
        //->paginate($paginate);

        $st_att_list = $absent_student;

    }elseif($present){
            $student_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })

            ->when(($present), function ($qu) use ($att_date) {
                return $qu->whereHas('attendance', function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                })->orWhereHas('leaveDetail', function ($q) use ($att_date) {
                    $q->leaveToday($att_date);
                });
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->get();
            //->paginate($paginate);

            $st_att_list = $student_list;

        }
      else{
        $st_att_list = $student_list;
      }



        $st_att_list = $st_att_list->map(function ($st_history) {

            return [

                'id' => $st_history->attendance->id ?? 0,
                'st_history_id' => $st_history->id ?? 0,
                'present' => $st_history->attendance ? 1 : 0,
                'sms_sending' => false,
                'st_status' => ($st_history->leaveDetail) ? "In Leave" : (($st_history->attendance) ? "Present" : "Absent"),
                'st_status_int' => ($st_history->leaveDetail) ? 2 : (($st_history->attendance) ? 1 : 0),
                'present_type' => $st_history->attendance->present_type ?? null,
                'student_attendance_id' => $st_history->attendance->id ?? null,

                'username' => $st_history->student->username ?? '',
                'attendance_sms' => $st_history->student->attendance_sms ?? '',
                'student_roll_number' => $st_history->student_roll_number ?? '',
                'contact_number' => $st_history->student->contact_number ?? '',
                'name' => ($st_history->full_name ?? ''),
                'details' => ($st_history->department->name ?? '') . ($st_history->stClass->class_name ?? '') . ($st_history->section->section_name ?? '') . ($st_history->classGroup->group_name ?? ''),

                'year_name' => $st_history->year->year_name ?? '',
                'version_name' => $st_history->version->version_name ?? '',
                'shift_name' => $st_history->shift->shift_name ?? '',
                'dept_name' => $st_history->department->name ?? '',
                'class_name' => $st_history->stClass->class_name ?? '',
                'class_group' => $st_history->classGroup->group_name ?? '',
                'section_name' => $st_history->section->section_name ?? '',
                'session' => $st_history->session->session_name ?? '',

                'in_sms_id' => $st_history->attendance->in_sms_id ?? null,
                'in_sms_sending' => false,
                'out_sms_id' => $st_history->attendance->out_sms_id ?? null,
                'out_sms_sending' => false,

                'site_shift_details_id' => $st_history->attendance->site_shift_details_id ?? 0,
                'in_time' => $st_history->attendance->in_time ?? '',
                'out_time' => $st_history->attendance->out_time ?? '',
                'present_date' => $st_history->attendance->present_date ?? '',
                'in_time_grace' => $st_history->student->in_time_grace ?? '',
                'out_time_grace' => $st_history->student->out_time_grace ?? '',
                'late_status' => $st_history->attendance->late_status ?? null,
                'updated_at' => $st_history->attendance->updated_at ?? $st_history->absent->updated_at ?? '',
                'updated_by' => $st_history->attendance->updateBy->full_name ?? '',

                //Absent

                'absent' => $st_history->absent ??  null,
                'absent_sms_status' => $st_history->absent->sms_status ??  null,

                //Leave

                'in_leave' => $st_history->leaveDetail ? 1 : 0,
                'leave_id' => $st_history->leaveDetail->id ?? null,


            ];


        });
        // this count develop by rayhan
        $present_count=0;
        $absent_count=0;
        foreach($st_att_list as $value){
            if($value['present']==1){
                $present_count++;
            }else{
                $absent_count++;
            }


        }

        //   \Log::info($st_att_list[0]['name']);

        if (count($st_att_list) < 1) {
            throw new Error('No Attendance Found For: ' . date('d M Y', strtotime($att_date)));
        }
        $report_tittle2 = " ";

        $page_tittle = "Student Attendance Report For" . date('d M Y', strtotime($att_date));
        $report_tittle = "<b>Student Attendance Report </b> <br>" . date('d M Y', strtotime($att_date));

        $report_tittle2 .= '<b>Version:</b>' . ($st_att_list[0]['version_name']);
        $report_tittle2 .= '<b> Year:</b>' . ($st_att_list[0]['year_name']);

        if ($data['academic_shift_id'] && $st_att_list[0]['shift_name']) {
            $report_tittle2 .= ' <b>Shift:</b>' . ($st_att_list[0]['shift_name']);
        }

        if ($data['academic_department_id'] && $st_att_list[0]['dept_name']) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($st_att_list[0]['dept_name']);
        }

        if ($data['academic_class_id'] && $st_att_list[0]['class_name']) {
            $report_tittle2 .= ' <b>Class:</b>' . ($st_att_list[0]['class_name']);
        }

        if ($data['academic_class_group_id'] && $st_att_list[0]['class_group']) {
            $report_tittle2 .= ' <b>Group:</b>' . ($st_att_list[0]['class_group']);
        }

        if ($data['academic_section_id'] && $st_att_list[0]['section_name']) {
            $report_tittle2 .= ' <b>Section:</b>' . ($st_att_list[0]['section_name']);
        }
            $report_tittle2 .= ' <b>Present:</b>' . $present_count;
            $report_tittle2 .= ' <b>Absent:</b>' . $absent_count;



        $pdf = PDF::loadView('default.site.student.attendance.report.daily-monitor-report', compact('st_att_list', 'report_tittle', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'landscape');


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';


        return Response::json(['link' => route('open-pdf-file-storage', [$name]), 'message' => 'Successfully Created Card Report'], 200);


    }
}
