<?php

namespace App\Http\Controllers\Site\Student\Attestation;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use PDF;
use Response;
use Session;

class StudentAttestationController extends Controller
{
    public function __construct()
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
       // $this->carbon_now = Carbon::now();

    }
 
    public function index()
    {
        $viewType = 'Student Attestation';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAttestationDataList(Request $request)
    {
        $siteStudentIDs = $this->returnSiteStudentIDs($request);

        $stdNumbers = collect($siteStudentIDs)->count();
      
        return [$siteStudentIDs, $stdNumbers];
    }

    private function returnSiteStudentIDs(Request $request)
    {

        $data = $request->all();
        $student_list=[];

        if ($request->academic_class_id) {

            $site_student_list = StudentHistory::with(['student' => function ($query) {
                $query->select('id','username');
            },'academicStudentCategory'])
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->select('id', 'user_id','student_roll_number','status','academic_student_category_id')
                ->orderBy('student_roll_number')
                ->orderBy('academic_section_id')
                ->orderBy('academic_class_group_id')
                ->orderBy('academic_class_id')
                ->get();

           

                $site_student_list=$site_student_list->where('status',true);
                    $key=0;
                    foreach($site_student_list as $item){
                        $student_list[$key]['student_history_id']=$item->id;
                        $student_list[$key]['full_name']=$item->full_name;
                        $student_list[$key]['username']=$item->student->username;
                        $student_list[$key]['student_roll_number']=$item->student_roll_number;
                        $student_list[$key]['category_name']=$item->academicStudentCategory->category_name;
                        $student_list[$key]['father_name']=$item->student->father_name;
                        $student_list[$key]['mother_name']=$item->student->mother_name;

                        $key++;
                    }

           
 
        }

        return $student_list;

    }

    public function downloadStudentPdfAttestation(Request $request){

        
        ini_set('memory_limit', '-1');


        $page_tittle = "Transfer Certificate";
        $report_tittle = "<b>Transfer Certificate</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Transfer Certificate";

        $student_info = StudentHistory::with(['student' => function ($query) {
            $query->with('gender')->select('id','username','gender_id');
        },'academicStudentCategory','stClass','classGroup'])
            ->where('id', $request->student_history_id)
           // ->select('id', 'user_id','student_roll_number','status','academic_student_category_id')
            ->first();
             //   dd($student->full_name);

   
        $site= SiteInfo::with(['district', 'photo', 'academicBoard'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id', 'site_logo', 'district_id', 'academic_board_id','eiin','college_code','nu_code')
            ->first();


//        return compact('student_detail', 'site');

        $institute_head = Employee::where('institute_head', 1)->first();

     

        $signature = $institute_head->signature ?? '/img/signature/signature.png';
        $designation = $institute_head->designation->name ?? 'Institution Head';
      //  dd('$student_detail->student');
           
        $pdf = PDF::loadView('default.admin.site.student.attestation.site-student-attestation-pdf',
            compact('site','student_info', 'signature', 'designation', 'report_tittle',
                'page_tittle', 'report_tittle2', 'title_view'))
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);

           
        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);
    }


}
