<?php

namespace App\Http\Controllers\Site\Student\Report;

use App\Forms\DataHelper;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Traits\Site\GlobalFunctionsTrait;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use niklasravnsborg\LaravelPdf\Facades\Pdf as FacadesPdf;
use niklasravnsborg\LaravelPdf\Pdf as LaravelPdfPdf;
use Response;
use PDF;
use Session;

class StudentReportController extends Controller
{

    use DataHelper, GlobalFunctionsTrait;

    private $carbon_now;

    private $studentHistory;
    private $student;
    private $routineDetail;


    public function __construct(RoutineDetail $routineDetail, Student $student, StudentHistory $studentHistory)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();

        $this->studentHistory = $studentHistory;
        $this->student = $student;
        $this->routineDetail = $routineDetail;

    }


    public function reportMaster()
    {
        $viewType = 'Student Report Master';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.site.student.report.report-master', compact('viewType'));
    }


    public function getStudents(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['academic_admission_type_id'] = $request->academic_admission_type_id;
            $data['academic_student_category_id'] = $request->academic_student_category_id;


            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';

            /*
                        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
                            throw new Error('Select * marked Fields');
                        }*/
            $student_list = [];


            $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->whereHas('student', function ($q) use ($search_txt, $txt) {
                    $q->where('status', 1)
                        ->when($search_txt, function ($q) use ($txt) {
                            return $q->where(function ($query) use ($txt) {
                                $query->where('username', 'LIKE', $txt)
                                    ->orWhere('email', 'LIKE', $txt)
                                    ->orWhere('contact_number', 'LIKE', $txt)
                                    ->orWhereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);

                            });
                        });
                })
                ->with(['student' => function ($q) {
                    $q->select('user_type', 'id', 'username', 'contact_number', 'attendance_sms');
                }])
                ->where('status', $status)
                ->orderBy('academic_class_id', 'ASC')
                ->orderBy('academic_section_id', 'ASC')
                ->orderBy('student_roll_number', 'ASC')
                ->where('status', 1)
                ->paginate($paginate);

            $student_list->getCollection()->transform(function ($st_history) {
                return [
                    'id' => $st_history->user_id,
                    'history_id' => $st_history->id,
                    'full_name' => $st_history->full_name,
                    'details' => ($st_history->stClass->class_name ?? '') . '-' . ($st_history->section->section_name ?? ''),
                    'username' => $st_history->student->username,
                    'student_roll_number' => $st_history->student_full_roll_number,
                    'attendance_sms' => $st_history->student->attendance_sms,
                    'contact_number' => $st_history->student->contact_number,
                    'site_id' => $st_history->site_id ?? 0,
                ];
            });


            if (count($student_list) < 1) {
                throw new Error('No Student Found!');
            }


            return Response::json($student_list, 200);

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }
    public function getStudentsForExcelShit(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['academic_admission_type_id']   = $request->academic_admission_type_id;
            $data['academic_student_category_id'] = $request->academic_student_category_id;


            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';


            $student_list = [];


             $student_list = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->whereHas('student', function ($q) use ($search_txt, $txt) {
                    $q->where('status', 1)
                        ->when($search_txt, function ($q) use ($txt) {
                            return $q->where(function ($query) use ($txt) {
                                $query->where('username', 'LIKE', $txt)
                                    ->orWhere('email', 'LIKE', $txt)
                                    ->orWhere('contact_number', 'LIKE', $txt)
                                    ->orWhereTranslationLike('first_name', $txt)
                                    ->orWhereTranslationLike('last_name', $txt);

                            });
                        });
                })
                ->with(['shift','student.religion'])
                ->with(['student' => function ($q) {
                    $q->select('user_type', 'id','religion_id', 'username', 'contact_number', 'date_of_birth', 'gender_id', 'permanent_district_id');
                }])
                ->where('status', $status)
                ->orderBy('academic_class_id', 'ASC')
                ->orderBy('academic_section_id', 'ASC')
                ->orderBy('student_roll_number', 'ASC')
                ->where('status', 1)
                ->get();

              $student_list->transform(function ($st_history) {
                return [
                    'id' => $st_history->id ?? null,
                    'full_name' => $st_history->full_name ?? null,
                    'father_name' => $st_history->student->father_name ?? null,
                    'mother_name' => $st_history->student->mother_name ?? null,
                    'username' => $st_history->student->username ?? null,
                    'student_roll_number_prefix' => $st_history->student_roll_number_prefix ?? null,
                    'class_name' => $st_history->stClass->class_name ?? null,
                    'group_name' => $st_history->classGroup->group_name ?? null,
                    'section_name' => $st_history->section->section_name ?? null,
                    'student_roll_number' => $st_history->student_roll_number ?? null,
                    'date_of_birth' => $st_history->student->date_of_birth ?? null,
                    'gender' => $st_history->student->gender->gender_name ?? null,
                    'contact_number' => $st_history->student->contact_number ?? null,
                    'permanent_district' => $st_history->student->permanentDistrict->district_name ?? null,
                    'address' => $st_history->student->address ?? null,
                    'religion' => $st_history->student->religion->name ?? null,
                    'shift' => $st_history->shift->shift_name ?? null,
                ];
            });


            if (count($student_list) < 1) {
                throw new Error('No Student Found!');
            }


            return Response::json($student_list, 200);

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function getTotListPdf(Request $request)
    {

        ini_set('memory_limit', '-1');

        //try {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == "null" ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == "null" ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == "null" ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == "null" ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == "null" ? null : $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == "null" ? null : $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id == "null" ? null : $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id == "null" ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == "null" ? null : $request->site_batch_detail_id;


        $class = $request->class == '1' ? 1 : 0;
        $group = $request->group == '1' ? 1 : 0;
        $address = $request->address == '1' ? 1 : 0;
        $passRollReg = $request->passRollReg == '1' ? 1 : 0;
        $username = $request->username == '1' ? 1 : 0;
        $picture = $request->picture == '1' ? 1 : 0;
        $subject = $request->subject == '1' ? 1 : 0;
        $sub_code = $request->sub_code == '1' ? 1 : 0;
        $optional = $request->optional == '1' ? 1 : 0;
        $signature = $request->signature == '1' ? 1 : 0;
        $contact_number = $request->contact_number == '1' ? 1 : 0;
        $comment = $request->comment == '1' ? 1 : 0;
        $report_type = $request->report_type == '1' ? 1 : 0;

        if (!$data['academic_version_id'] || !$data['academic_year_id']) {
            throw new Error('Select * marked Fields');
        }

        //     dd($picture,$subject,$sub_code, $request->picture,$request->subject,$request->sub_code);


        //


        $student_history = $this->studentHistory
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when($picture, function ($query) use ($data) {
                return $query->with(['student.latestPhoto']);
            })
            ->where('status', 1)
            ->whereHas('student', function ($q) {
                $q->where('status', 1);
            })
            ->with(['student' => function ($q) {
                $q->select('user_type', 'id', 'username', 'contact_number', 'date_of_birth', 'gender_id', 'permanent_district_id');
            }])
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->where('status', 1)
            // ->select('id', 'user_id','academic_subject_ids','')

    //        ->limit(5)
            ->get();


           // dd($student_history->academic_subject_ids[0]);

        // $has_optional = $student_history->where('optional_subject_ids', '!=', null)->first() ?? null;
        $has_previous_institute = $student_history->where('previous_institute_name', '!=', null)->first() ?? null;

        $student_history->transform(function ($value) {
            $all_sub = $this->studentSelectedSubject($value);

            // $general_subject_list = $all_sub[0] ?? [];
            // $compulsory_subject_list = $all_sub[1] ?? [];
            // $optional_subject_list = $all_sub[2] ?? [];

            $subject_list = $value->academic_subject_ids[0] ?? [];
           // $general_subject_list = $value->academic_subject_ids[0] ?? [];
            //$subject_list = $value->academic_subject_ids[0] ?? [];
            $optional_subject_list = $value->optional_subject_ids[0] ?? [];



            $image = $value->student->latestPhoto ? '/uploads/'.$value->student->latestPhoto->name : '/uploads/image-not.png';
            return [
                'id' => $value->id ?? null,
                'version_name' => $value->version->version_name ?? null,
                'year_name' => $value->year->year_name ?? null,
                'department_name' => $value->department->name ?? null,
                'shift_name' => $value->shift->shift_name ?? null,
                'picture' => $image,

                'subject_list' => $subject_list,
               // 'general_subjects' => $general_subject_list,
               // 'compulsory_subjects' => $compulsory_subject_list,
                'optional_subjects' => $optional_subject_list,
                'full_name' => $value->full_name ?? null,
                'father_name' => $value->student->father_name ?? null,
                'mother_name' => $value->student->mother_name ?? null,
                'username' => $value->student->username ?? null,
                'class_name' => $value->stClass->class_name ?? null,
                'group_name' => $value->classGroup->group_name ?? null,
                'section_name' => $value->section->section_name ?? null,
                'student_roll_number' => $value->student_full_roll_number ?? null,
                'academic_compulsory_ids' => $value->academic_compulsory_ids ?? null,
                'address' => $value->student->address ?? null,
                'permanent_district' => $value->student->permanentDistrict->district_name ?? null,
                'date_of_birth' => $value->student->date_of_birth ?? null,
                'gender' => $value->student->gender->gender_name ?? null,
                'contact_number' => $value->student->contact_number ?? null,
                'previous_institute_name' => $value->previous_institute_name ?? null,
                'passing_year' => $value->student->qualifications[0]->passing_year ?? null,
                'board' => strtoupper($value->student->qualifications[0]->board->key_name ?? null),
                'board_roll_number' => $value->student->qualifications[0]->board_roll_number ?? null,
                'board_registration_number' => $value->student->qualifications[0]->board_registration_number ?? null,
            ];
        });


        if (count($student_history) < 1) {
            return 'No Student Found!';
        }

        $page_tittle = "Student Tot Report";
        $report_tittle = "<b>Student Tot Report</b> <br/>";
        $report_tittle2 = '';


        $report_tittle2 .= '<b>Version:</b>' . ($student_history[0]['version_name'] ?? 'n/a');
        $report_tittle2 .= '<b> Year:</b>' . ($student_history[0]['year_name'] ?? 'n/a');
        $report_tittle2 .= ' <b> Shift:</b>' . ($student_history[0]['shift_name'] ?? 'n/a');

        if ($data['academic_department_id']) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($student_history[0]['department_name'] ?? 'n/a');
        }

        if ($data['academic_class_id']) {
            $report_tittle2 .= ' <b>Class:</b>' . ($student_history[0]['class_name'] ?? 'n/a');
        }

        if ($data['academic_class_group_id']) {
            $report_tittle2 .= ' <b>Group:</b>' . ($student_history[0]['group_name'] ?? 'n/a');
        }

        if ($data['academic_section_id']) {
            $report_tittle2 .= ' <b>Section:</b>' . ($student_history[0]['section_name'] ?? 'n/a');
        }


        //  return view('default.site.student.report.tort-list-report', compact('student_history','has_optional', 'report_tittle', 'page_tittle', 'report_tittle2'));

        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.tot-list-report')) {
            $pdf = PDf::loadView(Session::get('ALIAS1') . '.student.report.tot-list-report', compact('student_history', 'username', 'passRollReg', 'address', 'picture', 'subject', 'sub_code', 'class', 'group', 'optional', 'has_previous_institute', 'signature','contact_number', 'comment', 'report_type', 'page_tittle', 'report_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
        } else {
            $pdf = PDF::loadView('default.site.student.report.tot-list-report', compact('student_history', 'username', 'passRollReg', 'address', 'picture', 'subject', 'sub_code', 'class', 'group', 'optional', 'has_previous_institute', 'report_tittle', 'signature','contact_number', 'comment', 'report_type', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
        }
        return $pdf->stream('tot-list.pdf');

        //  $pdf = PDF::loadView('pdf.test_pdf');
        //  return $pdf->stream('test_pdf.pdf');si

       // return $pdf->stream(time() . '-student-tot-list.pdf');

        /*} catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }*/
    }

    public function getTotListSecondPdf(Request $request)
    {

        ini_set('memory_limit', '-1');

        //try {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == "null" ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == "null" ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == "null" ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == "null" ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == "null" ? null : $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == "null" ? null : $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id == "null" ? null : $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id == "null" ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == "null" ? null : $request->site_batch_detail_id;


        $class = $request->class == '1' ? 1 : 0;
        $group = $request->group == '1' ? 1 : 0;
        $address = $request->address == '1' ? 1 : 0;
        $passRollReg = $request->passRollReg == '1' ? 1 : 0;
        $username = $request->username == '1' ? 1 : 0;
        $picture = $request->picture == '1' ? 1 : 0;
        $subject = $request->subject == '1' ? 1 : 0;
        $sub_code = $request->sub_code == '1' ? 1 : 0;
        $optional = $request->optional == '1' ? 1 : 0;
        $signature = $request->signature == '1' ? 1 : 0;
        $contact_number = $request->contact_number == '1' ? 1 : 0;
        $comment = $request->comment == '1' ? 1 : 0;
        $report_type = $request->report_type == '1' ? 1 : 0;
        $house = $request->house == '1' ? 1 : 0;

        if (!$data['academic_version_id'] || !$data['academic_year_id']) {
            throw new Error('Select * marked Fields');
        }

        //     dd($picture,$subject,$sub_code, $request->picture,$request->subject,$request->sub_code);


        //


         $student_history = $this->studentHistory
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when($picture, function ($query) use ($data) {
                return $query->with(['student.latestPhoto']);
            })

            ->where('status', 1)
            ->whereHas('student', function ($q) {
                $q->where('status', 1);
            })
            ->with(['student' => function ($q) {
                $q->select('user_type', 'id', 'username', 'contact_number', 'date_of_birth', 'gender_id', 'permanent_district_id');
            }])
            ->with('house')
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->where('status', 1)
            // ->select('id', 'user_id','academic_subject_ids','')

    //        ->limit(5)
            ->get();


           // dd($student_history->academic_subject_ids[0]);

        // $has_optional = $student_history->where('optional_subject_ids', '!=', null)->first() ?? null;
        $has_previous_institute = $student_history->where('previous_institute_name', '!=', null)->first() ?? null;

        $student_history->transform(function ($value) {
            $all_sub = $this->studentSelectedSubject($value);

            // $general_subject_list = $all_sub[0] ?? [];
            // $compulsory_subject_list = $all_sub[1] ?? [];
            // $optional_subject_list = $all_sub[2] ?? [];

            $subject_list = $value->academic_subject_ids[0] ?? [];
           // $general_subject_list = $value->academic_subject_ids[0] ?? [];
            //$subject_list = $value->academic_subject_ids[0] ?? [];
            $optional_subject_list = $value->optional_subject_ids[0] ?? [];



            $image = $value->student->latestPhoto ? '/uploads/'.$value->student->latestPhoto->name : '/uploads/image-not.png';
            return [
                'id' => $value->id ?? null,
                'version_name' => $value->version->version_name ?? null,
                'year_name' => $value->year->year_name ?? null,
                'department_name' => $value->department->name ?? null,
                'shift_name' => $value->shift->shift_name ?? null,
                'picture' => $image,

                'subject_list' => $subject_list,
               // 'general_subjects' => $general_subject_list,
               // 'compulsory_subjects' => $compulsory_subject_list,
                'optional_subjects' => $optional_subject_list,
                'full_name' => $value->full_name ?? null,
                'father_name' => $value->student->father_name ?? null,
                'mother_name' => $value->student->mother_name ?? null,
                'username' => $value->student->username ?? null,
                'class_name' => $value->stClass->class_name ?? null,
                'group_name' => $value->classGroup->group_name ?? null,
                'section_name' => $value->section->section_name ?? null,
                'student_roll_number' => $value->student_full_roll_number ?? null,
                'academic_compulsory_ids' => $value->academic_compulsory_ids ?? null,
                'address' => $value->student->address ?? null,
                'permanent_district' => $value->student->permanentDistrict->district_name ?? null,
                'date_of_birth' => $value->student->date_of_birth ?? null,
                'gender' => $value->student->gender->gender_name ?? null,
                'contact_number' => $value->student->contact_number ?? null,
                'previous_institute_name' => $value->previous_institute_name ?? null,
                'passing_year' => $value->student->qualifications[0]->passing_year ?? null,
                'board' => strtoupper($value->student->qualifications[0]->board->key_name ?? null),
                'board_roll_number' => $value->student->qualifications[0]->board_roll_number ?? null,
                'board_registration_number' => $value->student->qualifications[0]->board_registration_number ?? null,
                'house_name' => $value->house->name ?? '',
            ];
        });


        if (count($student_history) < 1) {
            return 'No Student Found!';
        }

        $page_tittle = "Student Tot Report";
        $report_tittle = "<b>Student Tot Report</b> <br/>";
        $report_tittle2 = '';


        $report_tittle2 .= '<b>Version:</b>' . ($student_history[0]['version_name'] ?? 'n/a');
        $report_tittle2 .= '<b> Year:</b>' . ($student_history[0]['year_name'] ?? 'n/a');
        $report_tittle2 .= ' <b> Shift:</b>' . ($student_history[0]['shift_name'] ?? 'n/a');

        if ($data['academic_department_id']) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($student_history[0]['department_name'] ?? 'n/a');
        }

        if ($data['academic_class_id']) {
            $report_tittle2 .= ' <b>Class:</b>' . ($student_history[0]['class_name'] ?? 'n/a');
        }

        if ($data['academic_class_group_id']) {
            $report_tittle2 .= ' <b>Group:</b>' . ($student_history[0]['group_name'] ?? 'n/a');
        }

        if ($data['academic_section_id']) {
            $report_tittle2 .= ' <b>Section:</b>' . ($student_history[0]['section_name'] ?? 'n/a');
        }


        //  return view('default.site.student.report.tort-list-report', compact('student_history','has_optional', 'report_tittle', 'page_tittle', 'report_tittle2'));


        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.tot-list-report-second')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.report.tot-list-report-second', compact('student_history','house', 'username', 'passRollReg', 'address', 'picture', 'subject', 'sub_code', 'class', 'group', 'optional', 'has_previous_institute', 'signature','contact_number', 'comment', 'report_type', 'page_tittle', 'report_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
        } else {
            $pdf = PDF::loadView('default.site.student.report.tot-list-report-second', compact('student_history','house', 'username', 'passRollReg', 'address', 'picture', 'subject', 'sub_code', 'class', 'group', 'optional', 'has_previous_institute', 'report_tittle', 'signature','contact_number', 'comment', 'report_type', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
        }
        return $pdf->stream('second-tot-list.pdf');

        //  $pdf = PDF::loadView('pdf.test_pdf');
        //  return $pdf->stream('test_pdf.pdf');si

       // return $pdf->stream(time() . '-student-tot-list.pdf');

        /*} catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }*/
    }

    public function getEvaluationPdf(Request $request)
    {

        ini_set('memory_limit', '-1');

        //try {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == "null" ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == "null" ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == "null" ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == "null" ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == "null" ? null : $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == "null" ? null : $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id == "null" ? null : $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id == "null" ? null : $request->academic_session_id;
        $data['site_batch_detail_id'] = $request->site_batch_detail_id == "null" ? null : $request->site_batch_detail_id;


        $class = $request->class == '1' ? 1 : 0;
        $group = $request->group == '1' ? 1 : 0;
        $address = $request->address == '1' ? 1 : 0;
        $passRollReg = $request->passRollReg == '1' ? 1 : 0;
        $picture = $request->picture == '1' ? 1 : 0;
        $subject = $request->subject == '1' ? 1 : 0;
        $sub_code = $request->sub_code == '1' ? 1 : 0;
        $optional = $request->optional == '1' ? 1 : 0;
        $signature = $request->signature == '1' ? 1 : 0;
        $contact_number = $request->contact_number == '1' ? 1 : 0;
        $comment = $request->comment == '1' ? 1 : 0;
        $report_type = $request->report_type == '1' ? 1 : 0;

        if (!$data['academic_version_id'] || !$data['academic_year_id']) {
            throw new Error('Select * marked Fields');
        }

        //     dd($picture,$subject,$sub_code, $request->picture,$request->subject,$request->sub_code);


        //


        $student_history = $this->studentHistory
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when($picture, function ($query) use ($data) {
                return $query->with(['student.latestPhoto']);
            })
            ->where('status', 1)
            ->whereHas('student', function ($q) {
                $q->where('status', 1);
            })
            ->with(['student' => function ($q) {
                $q->select('user_type', 'id', 'username', 'contact_number', 'date_of_birth', 'gender_id', 'permanent_district_id');
            }])
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
//            ->where('status', 1)
            // ->select('id', 'user_id','academic_subject_ids','')
//            ->limit(5)
            ->get();


        // $has_optional = $student_history->where('optional_subject_ids', '!=', null)->first() ?? null;
        $has_previous_institute = $student_history->where('previous_institute_name', '!=', null)->first() ?? null;


        $student_history->transform(function ($value) {
            $all_sub = $this->studentSelectedSubject($value);

            $general_subject_list = $all_sub[0] ?? [];
            $compulsory_subject_list = $all_sub[1] ?? [];
            $optional_subject_list = $all_sub[2] ?? [];

//            dd($value->student->permanentDistrict->district_name);
        $image = $value->student->latestPhoto ? '/uploads/'.$value->student->latestPhoto->name : '/uploads/image-not.png';

            return [
                'id' => $value->id ?? null,
                'version_name' => $value->version->version_name ?? null,
                'year_name' => $value->year->year_name ?? null,
                'department_name' => $value->department->name ?? null,
                'shift_name' => $value->shift->shift_name ?? null,
                'picture' => $image,

                'general_subjects' => $general_subject_list,
                'compulsory_subjects' => $compulsory_subject_list,
                'optional_subjects' => $optional_subject_list,
                'full_name' => $value->full_name ?? null,
                //  'father_name' => $value->student->father_name ?? null,
                //  'mother_name' => $value->student->mother_name ?? null,
                //  'username' => $value->student->username ?? null,
                'class_name' => $value->stClass->class_name ?? null,
                'group_name' => $value->classGroup->group_name ?? null,
                'section_name' => $value->section->section_name ?? null,
                'student_roll_number' => $value->student_roll_number ?? null,
                'academic_compulsory_ids' => $value->academic_compulsory_ids ?? null,
                'address' => $value->student->address ?? null,
                'permanent_district' => $value->student->permanentDistrict->district_name ?? null,
                'date_of_birth' => $value->student->date_of_birth ?? null,
                'gender' => $value->student->gender->gender_name ?? null,
                'contact_number' => $value->student->contact_number ?? null,
                'previous_institute_name' => $value->previous_institute_name ?? null,
                'passing_year' => $value->student->qualifications[0]->passing_year ?? null,
                'board' => strtoupper($value->student->qualifications[0]->board->key_name ?? null),
                'board_roll_number' => $value->student->qualifications[0]->board_roll_number ?? null,
                'board_registration_number' => $value->student->qualifications[0]->board_registration_number ?? null,
            ];
        });


        if (count($student_history) < 1) {
            return 'No Student Found!';
        }

        $page_tittle = "Evaluation Report";
        $report_tittle = "<b>Assignment Evaluation Sheet " . date('Y', time()) . "</b> <br/>";
        $report_tittle2 = '';


        $report_tittle2 .= '<b>Version:</b>' . ($student_history[0]['version_name'] ?? 'n/a');
        $report_tittle2 .= '<b> Year:</b>' . ($student_history[0]['year_name'] ?? 'n/a');
        $report_tittle2 .= ' <b> Shift:</b>' . ($student_history[0]['shift_name'] ?? 'n/a');

        if ($data['academic_department_id']) {
            $report_tittle2 .= ' <b>Dept:</b>' . ($student_history[0]['department_name'] ?? 'n/a');
        }

        if ($data['academic_class_id']) {
            $report_tittle2 .= ' <b>Class:</b>' . ($student_history[0]['class_name'] ?? 'n/a');
        }

        if ($data['academic_class_group_id']) {
            $report_tittle2 .= ' <b>Group:</b>' . ($student_history[0]['group_name'] ?? 'n/a');
        }

        if ($data['academic_section_id']) {
            $report_tittle2 .= ' <b>Section:</b>' . ($student_history[0]['section_name'] ?? 'n/a');
        }


        $report_tittle2 .= ' <br/> <b>Subject:</b> ';
        $report_tittle2 .= ' <br/> <b>Assignment No:</b> ';


        //  return view('default.site.student.report.evaluation-list-report', compact('student_history','has_optional', 'report_tittle', 'page_tittle', 'report_tittle2'));



        $institute_head = (new Employee())->where('institute_head', 1)->first();

        $get_designation = $institute_head->designation->name ?? 'Institution Head';

        if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.evaluation-list-report')) {
            $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.report.evaluation-list-report', compact('student_history', 'passRollReg', 'address', 'picture', 'subject', 'sub_code', 'class', 'group', 'optional', 'has_previous_institute', 'signature','contact_number', 'comment','get_designation', 'report_type', 'page_tittle', 'report_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
        } else {
            $pdf = PDF::loadView('default.site.student.report.evaluation-list-report', compact('student_history', 'passRollReg', 'address', 'picture', 'subject', 'sub_code', 'class', 'group', 'optional', 'has_previous_institute', 'report_tittle', 'signature','contact_number', 'comment','get_designation', 'report_type', 'page_tittle', 'report_tittle2'))->setPaper('a4', 'Landscape');
        }
        return $pdf->stream(time() . '-evaluation-list-report.pdf');

        /*} catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }*/
    }


    public function detailsPdfReport(Request $request)
    {

        try {

            $report_tittle = "<b>Student Details Report</b> <br/>";
            $history_id = $request->history_id;

            $student_history = $this->studentHistory->with(['student' => function ($query) {
                $query->orderBy('id', 'desc')->limit(1);
            }])->findOrFail($history_id);


            // dd($student_history);


            $report_tittle3 = '';
            $report_tittle3 .= '<b>Version:</b>' . ($student_history->version->version_name ?? 'n/a');
            $report_tittle3 .= '<b> Year:</b>' . ($student_history->year->year_name ?? 'n/a');
            $report_tittle3 .= ' <b> Shift:</b>' . ($student_history->shift->shift_name ?? 'n/a');

            if ($student_history->department) {
                $report_tittle .= ' <b>Dept:</b>' . ($student_history->department->name ?? 'n/a');
            }

            $report_tittle3 .= ' <br/><b>Class:</b>' . ($student_history->stClass->class_name ?? 'n/a');

            if ($student_history->classGroup) {
                $report_tittle3 .= ' <b>Group:</b>' . ($student_history->classGroup->group_name ?? 'n/a');
            }

            if ($student_history->section) {
                $report_tittle3 .= ' <b>Section:</b>' . ($student_history->section->section_name ?? 'n/a');
            }

            //return view('default.site.student.report.details-pdf', compact('student_history', 'viewType'));
            $report_tittle2 = '';
            $page_tittle = $student_history->student->username . " Details report";

            // dd('dd');


            if (view()->exists('custom.' . Session::get('ALIAS1') . '.student.report.details-pdf')) {
                $pdf = PDF::loadView(Session::get('ALIAS1') . '.student.report.details-pdf', compact('student_history', 'page_tittle', 'report_tittle', 'report_tittle2', 'report_tittle3'))->setPaper('a4');
            } else {
                $pdf = PDF::loadView('default.site.student.report.details-pdf', compact('student_history', 'report_tittle', 'page_tittle', 'report_tittle2', 'report_tittle3'))->setPaper('a4');
            }

            //  $pdf = PDF::loadView('pdf.test_pdf');
            //  return $pdf->stream('test_pdf.pdf');

            return $pdf->stream($student_history->student->username . '-details.pdf');
        } catch (Exception $exception) {
            return $exception->getMessage();
        }

    }


    public function getRoutinePdf(Request $request)
    {
        //  dd($request->history_id);


        try {

            $his_id = $request->history_id;
            $academic_period_type_id = $request->academic_period_type_id == 'null' ? null : $request->academic_period_type_id;


            if (!$his_id || !$academic_period_type_id) {
                return "Please Select Period Type!";
            }


            $the_his = $this->studentHistory->find($his_id);

            if (!$the_his) {
                return "The Student History Not Found!";
            }


            $data = [];
            $data['academic_version_id'] = $the_his->academic_version_id == 'null' ? null : $the_his->academic_version_id;
            $data['academic_year_id'] = $the_his->academic_year_id == 'null' ? null : $the_his->academic_year_id;
            $data['academic_shift_id'] = $the_his->academic_shift_id == 'null' ? null : $the_his->academic_shift_id;
            $data['academic_department_id'] = $the_his->academic_department_id == 'null' ? null : $the_his->academic_department_id;
            $data['academic_class_id'] = $the_his->academic_class_id == 'null' ? null : $the_his->academic_class_id;
            $data['academic_section_id'] = $the_his->academic_section_id == 'null' ? null : $the_his->academic_section_id;
            $data['academic_class_group_id'] = $the_his->academic_class_group_id == 'null' ? null : $the_his->academic_class_group_id;
            $data['academic_session_id'] = $the_his->academic_session_id == 'null' ? null : $the_his->academic_session_id;
            $data['academic_period_type_id'] = $academic_period_type_id;


            $all_sub_ids = $this->studentSubjectIds($the_his);

            $getRoutineDetails = $this->routineDetail
                ->with(['routineAllocations' => function ($q) use ($all_sub_ids) {
                    $q->whereIn('subject_id', $all_sub_ids);
                }])
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->where('academic_section_id', $data['academic_section_id'])
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->orderBy('start_time', 'ASC')
                ->get();

            if (count($getRoutineDetails) < 1) {
                return "No routine found!";
            }

            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {

                $week_array[$weekDay->weekday_name] = $getRoutineDetails->where('weekday', $weekDay->weekday_key) ?? [];

                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }


            $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week

            $report_tittle2 = "<b>Routine For:</b>" . $the_his->student->full_name;
            $report_tittle = $this->reportTitle($getRoutineDetails[0]);

            $br_col[] = -1;


//             return  view('default.student.routine.routine-report', compact('week_array', 'headingList', 'max_col_count', 'report_tittle', 'br_col', 'report_tittle2'));
            $pdf = PDF::loadView('default.student.routine.routine-report', compact('week_array', 'headingList', 'max_col_count', 'report_tittle', 'br_col', 'report_tittle2'));
            return $pdf->stream($the_his->student->username . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


    public function getSiteBaseStudentStatistics(Request $request)
    {


        $data = $request->all();


        $getStudentList = StudentHistory::select('academic_year_id', 'academic_version_id', 'academic_shift_id',
            'academic_class_id', 'academic_department_id', 'academic_section_id', 'academic_class_group_id',
            'academic_student_category_id', 'academic_student_admission_type_id')
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', 1)
            ->where('transfer_status', 0)
            ->get();


        $totalStudent = count($getStudentList);

        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }


        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);


                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();


                    $class_array = $this->getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present);


                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;


            }


            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;

        }


        return compact('student_count_array', 'department_present', 'class_group_present', 'section_present', 'totalStudent');


    }


    public function getSiteBaseStudentStatisticsPdf(Request $request)
    {
        ini_set('memory_limit', '-1');


        $page_tittle = "Student Statistics";
        $report_tittle2 = "";
        $report_tittle = "<b>Student Statistics</b> <br/>";
        $title_view = "Student Statistics";


        $student_list = $this->getSiteBaseStudentStatistics($request);

        $student_count_array = $student_list['student_count_array'];
        $department_present = $student_list['department_present'];
        $class_group_present = $student_list['class_group_present'];
        $section_present = $student_list['section_present'];
        $totalStudent = $student_list['totalStudent'];

        $year = AcademicYear::where('id', $request->academic_year_id)->first();


        $report_tittle2 .= '<b> Year:</b>' . ($year->year_name ?? 'n/a');


        $pdf = PDF::loadView('default.site.student.report.student-statistics-summary-pdf',
            compact('student_count_array', 'department_present', 'class_group_present', 'section_present',
                'section_present', 'report_tittle', 'page_tittle',
                'totalStudent', 'report_tittle2', 'title_view'))
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Report'], 200);


    }


    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }


            }


            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }


    public function getSiteBaseStudentAttendanceStatisticsCount(Request $request)
    {


        $date_formate = Carbon::parse($request->present_date);
        $present_date = $date_formate->format('Y-m-d');


        $data = $request->all();
       // dd($data);

        $getStudentListFull = StudentHistory::with(['attendance' => function ($query) use ($present_date) {
            $query->where('present_date', $present_date);
            $query->select('id', 'student_history_id', 'late_status');

        }])
            ->select('id', 'academic_year_id', 'academic_version_id', 'academic_shift_id',
                'academic_class_id', 'academic_department_id', 'academic_section_id', 'academic_class_group_id',
                'academic_student_category_id', 'academic_student_admission_type_id')
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
//            ->when($data['academic_shift_id'], function ($query) use ($data) {
//                return $query->where('academic_shift_id', $data['academic_shift_id']);
//            })
//            ->when($data['academic_class_id'], function ($query) use ($data) {
//                return $query->where('academic_class_id', $data['academic_class_id']);
//            })
//            ->when($data['academic_department_id'], function ($query) use ($data) {
//                return $query->where('academic_department_id', $data['academic_department_id']);
//            })
//            ->when($data['academic_section_id'], function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
//            ->when($data['academic_class_group_id'], function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
            ->where('status', $data['status'])
            ->where('transfer_status', 0)
            ->get();



        $getStudentLists = [];
        $getStudentList_array = Array();
        foreach ($getStudentListFull as $key => $value) {

            if ($value->attendance) {
                $getStudentList_array['student_attendance_status'] = 1;
                $getStudentList_array['late_status'] = $value->attendance->late_status;

            } else {
                $getStudentList_array['student_attendance_status'] = 0;
                $getStudentList_array['late_status'] = 0;
            }


            $getStudentLists[$key] = array_merge($getStudentList_array, $value->toArray());
        }


        $getStudentList = collect($getStudentLists);

        $totalStudent = count($getStudentList);
        $totalPresentStudent = count($getStudentList->where('student_attendance_status', 1));
        $totalLateStudent = count($getStudentList->where('late_status', 1));



        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }


        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);

            $version_arr['version_present_student_count'] = count($filtered_version_list->where('student_attendance_status', 1));
            $version_arr['version_late_student_count'] = count($filtered_version_list->where('late_status', 1));


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);

                $shift_arr['shift_present_student_count'] = count($filtered_shift_list->where('student_attendance_status', 1));
                $shift_arr['shift_late_student_count'] = count($filtered_shift_list->where('late_status', 1));


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);

                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);

                        $department_arr['department_present_student_count'] = count($filtered_department_list->where('student_attendance_status', 1));
                        $department_arr['department_late_student_count'] = count($filtered_department_list->where('late_status', 1));

                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionAttendanceCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();


                    $class_array = $this->getClassGroupSectionAttendanceCount($classList, $filtered_shift_list, $class_group_present);


                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;


            }

            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;
            $student_count_array[$keyVersion] = $version_arr;

        }
       // dd($totalLateStudent);

        return compact('student_count_array', 'department_present', 'class_group_present',
            'section_present', 'totalStudent', 'totalPresentStudent', 'totalLateStudent');


    }


    private function getClassGroupSectionAttendanceCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);

            $class_arr['class_present_student_count'] = count($filtered_class_list->where('student_attendance_status', 1));
            $class_arr['class_late_student_count'] = count($filtered_class_list->where('late_status', 1));


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);

                    $class_group_arr['class_group_present_student_count'] = count($filtered_class_group_list->where('student_attendance_status', 1));
                    $class_group_arr['class_group_late_student_count'] = count($filtered_class_group_list->where('late_status', 1));


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);

                        $section_arr['section_present_student_count'] = count($filtered_section_list->where('student_attendance_status', 1));
                        $section_arr['section_late_student_count'] = count($filtered_section_list->where('late_status', 1));


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);

                    $section_arr['section_present_student_count'] = count($filtered_section_list->where('student_attendance_status', 1));
                    $section_arr['section_late_student_count'] = count($filtered_section_list->where('late_status', 1));

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }


            }


            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }


}
