<?php

namespace App\Http\Controllers\Site\StudentAdmission;

use App\Imports\Site\SiteAdmissionRollImport;
use App\Imports\Site\SitePhoneBookImport;
use App\Models\Academic\AcademicBank;
use App\Models\Academic\AcademicBoard;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicPaymentType;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicStudentType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApproveExcel;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclare;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclareOnlineApi;
use Error;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\Site\StudentAdmission\SiteStudentRollCreateRange;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Illuminate\Http\JsonResponse;
use Exception;
use Illuminate\Validation\ValidationException;
use Maatwebsite\Excel\Facades\Excel;
use Session;
use Response;

class SiteBaseStudentAdmissionDeclareController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Student Admission Declaration Page';
        return view('default.admin.layouts.master', compact('viewType'));

    }

    public function siteStudentAdmissionInsideForm(){
        $viewType = 'Student Admission Form';
        return view('default.admin.layouts.master', compact('viewType'));
    }





    public function getYearDeptClassShiftVersionSessionAdmissionDeclareList()
    {


        $site_info_setting = SiteInfoSetting::first();

        $site_info=SiteInfo::where('id', $site_info_setting->site_id)->first();


        $academic_version_ids = explode(',', $site_info_setting->academic_version_ids) ?? null;
        $academicVersionList = AcademicVersion::select('id', 'version_name')
            ->whereIn('id', $academic_version_ids)
            ->get();


        $shift_ids = explode(',', $site_info_setting->shift_ids) ?? null;
        $shiftList = AcademicShift::select('id')
            ->whereIn('id', $shift_ids)
            ->get();


        $academic_year_ids = explode(',', $site_info_setting->academic_year_ids) ?? null;
        $academicYearList = AcademicYear::select('id', 'year_name')
            ->whereIn('id', $academic_year_ids)
            ->get();

   //     $academic_year_ids = explode(',', $site_info_setting->academic_year_ids) ?? null;
        $studentTypeList = AcademicStudentType::select('id', 'student_type_name')
         //   ->whereIn('id', $academic_year_ids)
            ->get();


        $academicDepartmentList = [];
        if ($site_info_setting->academic_department_ids) {
            $academicDepartment = explode(',', $site_info_setting->academic_department_ids) ?? null;
            $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
                ->whereIn('id', $academicDepartment)->get();

//            $dept_arr=Array();
//            foreach ($academicDepartmentDetail as $keyt => $valuet) {
//
//                $check_class=GlobalSiteShiftClassGroupSectionSetting::where('academic_department_id', $valuet->id)
//                    ->pluck('academic_class_id')
//                    ->unique()
//                    ->filter();
//
//                $academicDeptClass = AcademicClass::select('id', 'class_name')
//                    ->whereIn('id', $check_class)
//                    ->orderBy('serial_no', 'ASC')
//                    ->get();
//
//                $class_arr=Array();
//                $academicClassList=[];
//                foreach ($academicDeptClass as $key => $value) {
//                    $class_arr['min_gpa']=null;
//                    $class_arr['min_number']=null;
//
//                    $check_group=GlobalSiteShiftClassGroupSectionSetting::where('academic_class_id', $value->id)
//                        ->pluck('academic_class_group_id')
//                        ->unique()
//                        ->filter();
//
//                    if(count($check_group)>0){
//                        $academicClassGroupDetail=AcademicClassGroup::whereIn('id', $check_group)
//                            ->get();
//
//                        $class_group_arr=Array();
//                        $academicClassGroupList=[];
//                        foreach ($academicClassGroupDetail as $keys => $values) {
//                            $class_group_arr['min_gpa']=null;
//                            $class_group_arr['min_number']=null;
//
//                            $academicClassGroupList[$keys]=array_merge($values->toArray(), $class_group_arr);
//                        }
//                    } else{
//                        $academicClassGroupList=[];
//                    }
//                    $class_arr['academic_class_group_list']=$academicClassGroupList;
//
//                    $academicClassList[$key]=array_merge($value->toArray(), $class_arr);
//                }
//
//
//
//                $dept_arr['academic_class_list']=$academicClassList;
//
//                $academicDepartmentList[$keyt]=array_merge($dept_arr, $valuet->toArray());
//            }

        }


        $academicClass = explode(',', $site_info_setting->academic_class_ids) ?? null;
        $academicClassList = AcademicClass::select('id', 'class_name')
            ->whereIn('id', $academicClass)
            ->orderBy('serial_no', 'ASC')
            ->get();

//        $class_arr=Array();
//        $academicClassList=[];
//        foreach ($academicClassdetail as $key => $value) {
//            $class_arr['min_gpa']=null;
//            $class_arr['min_number']=null;
//
//            $check_group=GlobalSiteShiftClassGroupSectionSetting::where('academic_class_id', $value->id)
//                ->pluck('academic_class_group_id')
//                ->unique()
//                ->filter();
//
//            if(count($check_group)>0){
//                $academicClassGroupDetail=AcademicClassGroup::whereIn('id', $check_group)
//                    ->get();
//
//                $class_group_arr=Array();
//                $academicClassGroupList=[];
//                foreach ($academicClassGroupDetail as $keys => $values) {
//                    $class_group_arr['min_gpa']=null;
//                    $class_group_arr['min_number']=null;
//
//                    $academicClassGroupList[$keys]=array_merge($values->toArray(), $class_group_arr);
//                }
//            } else{
//                $academicClassGroupList=[];
//            }
//            $class_arr['academic_class_group_list']=$academicClassGroupList;
//
//            $academicClassList[$key]=array_merge($value->toArray(), $class_arr);
//        }





        $academicSession = explode(',', $site_info_setting->academic_session_ids) ?? null;
        $academicSessionList = AcademicSession::select('id', 'session_name')
            ->whereIn('id', $academicSession)
            ->get();


        $educationQualification = explode(',', $site_info->employee_examination_ids) ?? null;
        $educationQualificationList = Examination::select('id', 'examination_name')
            ->whereIn('id', $educationQualification)
            ->get();


        $AdmissionDeclareDetail = SiteStudentAdmissionDeclare::with(['siteStudentAdmissionDeclareOnlineApi','SiteStudentRollCreateRange'])->get();

        $admission_dec_arr=Array();
        $AdmissionDeclareList=[];
        foreach ($AdmissionDeclareDetail as $key => $value) {

            $company_arr=Array();
            $company_array=[];
            foreach ($value->siteStudentAdmissionDeclareOnlineApi as $keys => $values) {
                $company_arr['select_payment_company']=true;
                $company_array[$keys]=array_merge($values->toArray(), $company_arr);
            }
            $admission_dec_arr['site_student_admission_declare_online_api']=collect($company_array)->values();

            $AdmissionDeclareList[$key]=array_merge($value->toArray(), $admission_dec_arr);
        }


        $academic_payment_type=AcademicPaymentType::get();

        $payment_list=[];
        $payment_arr=Array();
        foreach ($academic_payment_type as $key => $value) {

            if($value->name_key=='online'){
                $payment_com=AcademicOnlinePaymentMethod::where('payment_type_key','online')->get();

                $array_arr=Array();
                $array_array=[];
                foreach ($payment_com as $keys => $values) {
                    $array_arr['select_payment_company']=false;
                    $array_arr['username']=null;
                    $array_arr['password']=null;
                    $array_arr['partner_code']=null;
                    $array_arr['check_method']='online';

                    $array_arr['username_field_show']=true;
                    $array_arr['password_field_show']=true;
                    $array_arr['partner_code_field_show']=true;
                    $array_array[$keys]=array_merge($values->toArray(), $array_arr);
                }

                $payment_arr['company_list']=collect($array_array)->values();
            }
            else if($value->name_key=='bank'){
                $payment_com=AcademicBank::get();

                $array_arr=Array();
                $array_array=[];
                foreach ($payment_com as $keys => $values) {
                    $array_arr['select_payment_company']=false;
                    $array_arr['username']=null;
                    $array_arr['password']=null;
                    $array_arr['partner_code']=null;
                    $array_arr['check_method']='online';

                    $array_arr['username_field_show']=false;
                    $array_arr['password_field_show']=false;
                    $array_arr['partner_code_field_show']=false;
                    $array_array[$keys]=array_merge($values->toArray(), $array_arr);
                }


                $payment_arr['company_list']=collect($array_array)->values();


            }
            $payment_arr['select_payment_company']=[];


            $payment_list[$key]=array_merge($value->toArray(), $payment_arr);
        }
        $PaymentTypeList=collect($payment_list)->values();

        /// compulsory subject list

        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])->pluck('id');

      /// academic subject list

        $siteClassBaseSubjectDetail =SubjectGroupConditionSetting::whereIn('academic_class_id', $academicClass)
            ->whereIn('academic_year_id', $academic_year_ids)
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->where('status', true)
            ->get();



        $compulsory_subject_ids = [];
            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                    $subjectCondition = SubjectCondition::whereIn('condition_key', ['selectiveCompulsory','optional'])->first();
                    if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                        $compulsory_subject_ids[$key] = $value->academic_subject_id;
                    }
                }
            }
        

        $confligSubjectList=AcademicSubject::whereIn('id',$compulsory_subject_ids)->get();

  //  dd($academic_subject_list);


        return response()->json(
            [
                'academicVersionList'=>$academicVersionList,
                'shiftList'=>$shiftList,
                'academicYearList'=>$academicYearList,
                'studentTypeList'=>$studentTypeList,
                'academicDepartmentList'=>$academicDepartmentList,
                'academicClassList'=>$academicClassList,
                'academicSessionList'=>$academicSessionList,
                'AdmissionDeclareList'=>$AdmissionDeclareList,
                'educationQualificationList'=>$educationQualificationList,
                'PaymentTypeList'=>$PaymentTypeList,
                'confligSubjectList'=>$confligSubjectList,
            ]);
//        return compact('academicVersionList', 'shiftList', 'academicYearList', 'academicDepartmentList',
//            'academicClassList', 'academicSessionList', 'AdmissionDeclareList', 'educationQualificationList', 'PaymentTypeList');


    }


    public function getSiteClassWiseAcademicClassGroup(Request $request){

        $site_class_group_ids = GlobalSiteShiftClassGroupSectionSetting::
            whereIn('academic_class_id', $request->academic_class_ids)
            ->whereIn('academic_shift_id', $request->shift_ids)
            ->pluck('academic_class_group_id')
            ->unique();


        $classGroupDataList = AcademicClassGroup::select('id', 'group_name')
            ->whereIn('id', $site_class_group_ids)
            ->get();

        $classGroupArray=[];
        $key=0;
        foreach($classGroupDataList as $item){
            $classGroupArray[$key]['academic_class_group_id']=$item->id;
            $classGroupArray[$key]['group_name']=$item->group_name;
            $classGroupArray[$key]['start_roll']=$item->start_roll;
            $classGroupArray[$key]['end_roll']=$item->end_roll;

            $key++;
        }


        return $classGroupArray;


    }


    public function createSiteBaseStudentAdmissionDeclare(Request $request, SiteStudentAdmissionDeclare $sbsrd)
    {

        try {

            $this->validate($request, [
                "start_date" => "required",
                "end_date" => "required",
                "shift_ids" => "required",
                "academic_version_ids" => "required",
                "academic_year_ids" => "required",
                "academic_class_ids" => "required",
                "admission_form_language" => "required",

            ]);
            


            if ($request->start_date > $request->end_date) {

                $start_date = $request->end_date;
                $end_date = $request->start_date;

            } else {
                $start_date = $request->start_date;
                $end_date = $request->end_date;
            }


            $check_start_date = SiteStudentAdmissionDeclare::
            where('duration_from_date', '>=', $start_date)
                ->whereOr('duration_to_date', '>=', $start_date)
                ->where('status', true)
                ->first();


            $check_end_date = SiteStudentAdmissionDeclare::
            where('duration_from_date', '>=', $end_date)
                ->whereOr('duration_to_date', '>=', $end_date)
                ->where('status', true)
                ->first();


            if ($check_start_date || $check_end_date) {

                return 'sametimeerror';
            } else {

                $payment_list=collect($request->PaymentTypeList)->where('id', $request->academic_payment_type_id)->first();
                $payment_company_ids=$payment_list['select_payment_company'];

//                \Log::info($payment_company_ids);


                $check_actice_data = SiteStudentAdmissionDeclare::
                where('status', true)
                    ->first();

                if ($check_actice_data) {
                    $check_actice_data->update([
                        'status' => false
                    ]);
                }

               // dd('gdg');

                $sbsrd->duration_from_date = $start_date;
                $sbsrd->duration_to_date = $end_date;
                $sbsrd->extended_date = $request->extended_date;
                $sbsrd->remark = $request->remark;
                $sbsrd->send_sms = $request->send_sms;
//                $sbsrd->old_student_information_add = $request->old_student_information_add;

                $sbsrd->group_wise_roll_create_status = $request->group_wise_roll_create_status;
                $sbsrd->auto_roll_create_status = $request->auto_roll_create_status;
                $sbsrd->auto_roll_digit = $request->auto_roll_digit;
                $sbsrd->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;


                $sbsrd->subject_condition_status = $request->subject_condition_status;
                $sbsrd->guardian_information_add = $request->guardian_information_add;
                $sbsrd->address_information_add = $request->address_information_add;
                $sbsrd->communication_information_add = $request->communication_information_add;
//                $sbsrd->previous_institute_information_add = $request->previous_institute_information_add;
                $sbsrd->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
//                $sbsrd->student_admission_number_box_show = $request->student_admission_number_box_show;
                $sbsrd->parents_contact_number_required = $request->parents_contact_number_required;
                $sbsrd->birth_certificate_no_required = $request->birth_certificate_no_required;
                $sbsrd->office_will_fillup_text_show_status = $request->office_will_fillup_text_show_status;
                $sbsrd->unique_code_show_status = $request->unique_code_show_status;


                $sbsrd->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $sbsrd->site_id = Session::get('SITE_ID');

                $sbsrd->academic_shift_ids = implode(',', $request->shift_ids);
                $sbsrd->academic_version_ids = implode(',', $request->academic_version_ids);
                $sbsrd->academic_year_ids = implode(',', $request->academic_year_ids);
                $sbsrd->academic_department_ids = $request->academic_department_ids ? implode(',', $request->academic_department_ids) : null;
                $sbsrd->academic_class_ids = $request->academic_class_ids ? implode(',', $request->academic_class_ids) : null;
                $sbsrd->academic_session_ids = $request->academic_session_ids ? implode(',', $request->academic_session_ids) : null;
                $sbsrd->student_type_ids = $request->student_type_ids ? implode(',', $request->student_type_ids) : null;
                $sbsrd->conflig_compulsory_subject_ids = $request->conflig_compulsory_subject_ids ? implode(',', $request->conflig_compulsory_subject_ids) : null;


                $sbsrd->check_with_roll_number = $request->check_with_roll_number;
                $sbsrd->check_with_online_transaction_id = $request->check_with_online_transaction_id;
                $sbsrd->check_with_second_online_transaction_id = $request->check_with_second_online_transaction_id;
                $sbsrd->terms_condition_show_top = $request->terms_condition_show_top;
                $sbsrd->terms_condition_show_bellow = $request->terms_condition_show_bellow;
                $sbsrd->check_with_board_university = $request->check_with_board_university;
                $sbsrd->education_qualification_ids = $request->education_qualification_ids ? implode(',', $request->education_qualification_ids) : null;
                $sbsrd->admission_form_language = $request->admission_form_language;
                $sbsrd->academic_payment_type_id = $request->academic_payment_type_id;
                $sbsrd->payment_company_ids = $payment_company_ids ? implode(',', $payment_company_ids) : null;
                $sbsrd->term_condition = $request->term_condition;

                $sbsrd->exam_passing_year_show = $request->exam_passing_year_show;
                $sbsrd->passing_year_examination_id = $request->passing_year_examination_id;



                $sbsrd->save();
                $declare_id=$sbsrd->id;

                $academic_payment_type_key=AcademicPaymentType::where('id', $request->academic_payment_type_id)->first();



                $check_company_data=collect($payment_list['company_list'])->where('select_payment_company', true);

                if(count($check_company_data)>0){
                    foreach ($check_company_data as $key => $value) {

                        $company_api= new SiteStudentAdmissionDeclareOnlineApi();

                        $company_api->site_student_admission_declare_id=$declare_id;
                        $company_api->academic_payment_type_id= $request->academic_payment_type_id;
                        $company_api->academic_payment_type_key=$academic_payment_type_key->name_key;
                        $company_api->payment_company_id=$value['id'];
                        $company_api->vendor=$value['name_key'];
                        $company_api->username=$value['username'];
                        $company_api->password=$value['password'];
                        $company_api->partner_code=$value['partner_code'];
                        $company_api->check_method=$value['check_method'];
                        $company_api->save();

                    }
                }

                // spacefic roll create for class group
                if($request->group_wise_roll_create_status){
                    if(count($request->shift_ids)){
                        foreach($request->shift_ids as $shift_id){

                            if(count($request->academic_class_ids)){
                                foreach($request->academic_class_ids as $class_id){


                                    if(count($request->AcadmicClassGroupList)>0){
                                        foreach ($request->AcadmicClassGroupList as $key => $group) {
                                          //  dd($group);
                                            if($group['start_roll']){
                                                $student_roll_range= new SiteStudentRollCreateRange();
                                                $student_roll_range->site_student_admission_declare_id=$declare_id;
                                                $student_roll_range->academic_shift_id=$shift_id;
                                                $student_roll_range->academic_class_id=$class_id;
                                                $student_roll_range->academic_class_group_id=$group['academic_class_group_id'];
                                                $student_roll_range->start_roll=$group['start_roll'];
                                                $student_roll_range->save();
                                            }

                                        }
                                    }
                            
                                }
                            }
                        }
                    }
                }



                return Response::json(['message' => 'Admission Declare Create Successfully!', 'mode' => 'Create!'], 200);
            }


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function updateSiteBaseStudentAdmissionDeclare(Request $request)
    {
        try {

            $payment_list=collect($request->PaymentTypeList)->where('id', $request->academic_payment_type_id)->first();
            $payment_company_ids=$payment_list['select_payment_company'];

            $sbsrd = SiteStudentAdmissionDeclare::where('id', $request->site_base_student_admission_declare_id)
                ->first();

            $sbsrd->duration_from_date = $request->start_date;
            $sbsrd->duration_to_date = $request->end_date;
            $sbsrd->extended_date = $request->extended_date;
            $sbsrd->remark = $request->remark;
            $sbsrd->send_sms = $request->send_sms;
//            $sbsrd->old_student_information_add = $request->old_student_information_add;

            $sbsrd->group_wise_roll_create_status = $request->group_wise_roll_create_status;
            $sbsrd->auto_roll_create_status = $request->auto_roll_create_status;
            $sbsrd->auto_roll_digit = $request->auto_roll_digit;
            $sbsrd->bank_recipt_downlaod_status = $request->bank_recipt_downlaod_status;

            $sbsrd->subject_condition_status = $request->subject_condition_status;
            $sbsrd->guardian_information_add = $request->guardian_information_add;
            $sbsrd->address_information_add = $request->address_information_add;
            $sbsrd->communication_information_add = $request->communication_information_add;
//            $sbsrd->previous_institute_information_add = $request->previous_institute_information_add;
            $sbsrd->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
//            $sbsrd->student_admission_number_box_show = $request->student_admission_number_box_show;
            $sbsrd->parents_contact_number_required = $request->parents_contact_number_required;
            $sbsrd->birth_certificate_no_required = $request->birth_certificate_no_required;
            $sbsrd->office_will_fillup_text_show_status = $request->office_will_fillup_text_show_status;
            $sbsrd->unique_code_show_status = $request->unique_code_show_status;

            $sbsrd->academic_shift_ids = implode(',', $request->shift_ids);
            $sbsrd->academic_version_ids = implode(',', $request->academic_version_ids);
            $sbsrd->academic_year_ids = implode(',', $request->academic_year_ids);
            $sbsrd->academic_department_ids = $request->academic_department_ids ? implode(',', $request->academic_department_ids) : null;
            $sbsrd->academic_class_ids = $request->academic_class_ids ? implode(',', $request->academic_class_ids) : null;
            $sbsrd->academic_session_ids = $request->academic_session_ids ? implode(',', $request->academic_session_ids) : null;
            $sbsrd->student_type_ids = $request->student_type_ids ? implode(',', $request->student_type_ids) : null;
            $sbsrd->conflig_compulsory_subject_ids = $request->conflig_compulsory_subject_ids ? implode(',', $request->conflig_compulsory_subject_ids) : null;

            $sbsrd->check_with_roll_number = $request->check_with_roll_number;
            $sbsrd->check_with_online_transaction_id = $request->check_with_online_transaction_id;
            $sbsrd->check_with_second_online_transaction_id = $request->check_with_second_online_transaction_id;
            $sbsrd->terms_condition_show_top = $request->terms_condition_show_top;
            $sbsrd->terms_condition_show_bellow = $request->terms_condition_show_bellow;
            $sbsrd->check_with_board_university = $request->check_with_board_university;
            $sbsrd->education_qualification_ids = $request->education_qualification_ids ? implode(',', $request->education_qualification_ids) : null;
            $sbsrd->admission_form_language = $request->admission_form_language;
            $sbsrd->academic_payment_type_id = $request->academic_payment_type_id;
            $sbsrd->payment_company_ids = $payment_company_ids ? implode(',', $payment_company_ids) : null;
            $sbsrd->term_condition = $request->term_condition;
            $sbsrd->exam_passing_year_show = $request->exam_passing_year_show;
            $sbsrd->passing_year_examination_id = $request->passing_year_examination_id;

            $sbsrd->save();

            $declare_id=$request->site_base_student_admission_declare_id;

            $academic_payment_type_key=AcademicPaymentType::where('id', $request->academic_payment_type_id)->first();

            $all_payment_ids=SiteStudentAdmissionDeclareOnlineApi:: where('site_student_admission_declare_id', $declare_id)
//                ->where('academic_payment_type_id',  $request->academic_payment_type_id)
                ->pluck('id');


            $check_company_data=collect($payment_list['company_list'])
                ->where('select_payment_company', true)
                ->values();


            $present_ids=[];
            if(count($check_company_data)>0){
                foreach ($check_company_data as $key => $value) {

                    $check_payement_present=SiteStudentAdmissionDeclareOnlineApi::
                        where('site_student_admission_declare_id', $declare_id)
                        ->where('academic_payment_type_id',  $request->academic_payment_type_id)
                        ->where('payment_company_id',  $value['id'])
                        ->first();
                      //  dd($check_payement_present);
                    if($check_payement_present){
                        $present_ids[]=$check_payement_present->id;

                        $check_payement_present->vendor=$value['name_key'];
                        $check_payement_present->username=$value['username'];
                        $check_payement_present->password=$value['password'];
                        $check_payement_present->partner_code=$value['partner_code'];
                        $check_payement_present->check_method=$value['check_method'];

                        $check_payement_present->save();
                    }else{
                        $company_api= new SiteStudentAdmissionDeclareOnlineApi();

                        $company_api->site_student_admission_declare_id=$declare_id;
                        $company_api->academic_payment_type_id= $request->academic_payment_type_id;
                        $company_api->academic_payment_type_key=$academic_payment_type_key->name_key;
                        $company_api->payment_company_id=$value['id'];
                        $company_api->vendor=$value['name_key'];
                        $company_api->username=$value['username'];
                        $company_api->password=$value['password'];
                        $company_api->partner_code=$value['partner_code'];
                        $company_api->check_method=$value['check_method'];
                        $company_api->save();
                    }



                }
            }


                if(count($all_payment_ids)>0){
                    $check_data=array_diff($all_payment_ids->toArray(), $present_ids);

                    SiteStudentAdmissionDeclareOnlineApi::whereIn('id', $check_data)->delete();
                }

                
              //  spacefic roll create for class group
                if($request->group_wise_roll_create_status){
                    if(count($request->shift_ids)){
                        foreach($request->shift_ids as $shift_id){

                            if(count($request->academic_class_ids)){
                                foreach($request->academic_class_ids as $class_id){


                                    if(count($request->AcadmicClassGroupList)>0){
                                        foreach ($request->AcadmicClassGroupList as $key => $group) {
                                            if($group['start_roll']){
                                                $check_student_roll_range=SiteStudentRollCreateRange::where('academic_shift_id',$shift_id)
                                                        ->where('academic_class_id',$class_id)
                                                        ->where('site_student_admission_declare_id',$declare_id)
                                                        ->where('academic_class_group_id',$group['academic_class_group_id'])
                                                        ->first();

                                                if($check_student_roll_range){
                                                    $check_student_roll_range->start_roll=$group['start_roll'];
                                                    $check_student_roll_range->save();
                                                }else{
                                                    $student_roll_range= new SiteStudentRollCreateRange();
                                                    $student_roll_range->site_student_admission_declare_id=$declare_id;
                                                    $student_roll_range->academic_shift_id=$shift_id;
                                                    $student_roll_range->academic_class_id=$class_id;
                                                    $student_roll_range->academic_class_group_id=$group['academic_class_group_id'];
                                                    $student_roll_range->start_roll=$group['start_roll'];
                                                    $student_roll_range->save();
                                                }   
                                                
                                            }

                                        }
                                    }
                            
                                }
                            }
                        }
                    }
                }


            return Response::json(['message' => 'Declare Update Successfully!', 'mode' => 'Update!'], 200);

        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function deleteSiteBaseStudentAdmissionDeclare(Request $request)
    {

        try {

            $sbsrd = SiteStudentAdmissionDeclare::where('id', $request->site_base_student_admission_declare_id)
                ->first();

            $sbsrd->delete();

            SiteStudentAdmissionDeclareOnlineApi::
                where('site_student_admission_declare_id', $request->site_base_student_admission_declare_id)->delete();


            return Response::json(['message' => 'Delete Successfully!', 'mode' => 'Delete!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function pauseSiteBaseStudentAdmissionDeclare(Request $request)
    {

        try {

            $sbsrd = SiteStudentAdmissionDeclare::where('id', $request->site_base_student_admission_declare_id)
                ->first();

            $sbsrd->update([
                'status' => false
            ]);


            return Response::json(['message' => 'Pause Successfully!', 'mode' => 'Delete!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function activateSiteBaseStudentAdmissionDeclare(Request $request)
    {
        try {


            $checkActivePresent = SiteStudentAdmissionDeclare::where('status', true)
                ->first();

            if ($checkActivePresent) {

                return Response::json(['message' => 'There are already active declaretion present. You can not active this.!', 'mode' => 'Delete!'], 200);

            } else {
                $sbsrd = SiteStudentAdmissionDeclare::where('id', $request->site_base_student_admission_declare_id)
                    ->first();

                $sbsrd->update([
                    'status' => true
                ]);


                return Response::json(['message' => 'Activate Successfully!', 'mode' => 'Delete!'], 200);

            }


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }
    }







//    Roll Reg Validation


    /**
     * @param $group_id
     * @return \Illuminate\Database\Eloquent\Model|null|object|static
     */


    public function getRollRegistrationEntryListForAdmission(Request $request){

        $checked_value=$this->checkAdmissionDeclare($request);


//        $checked_value[0]=$academic_year_status
//        $checked_value[1]=$academic_shift_status
//        $checked_value[2]=$academic_department_status
//        $checked_value[3]=$academic_class_status
//        $checked_value[4]=$academic_session_status

        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->first();

        if($checked_value[0] && $checked_value[1]
            && $checked_value[2] && $checked_value[3]
            && $checked_value[4])
        {

            $data=$request->all();
            $check_data_present=SiteStudentAdmissionBoardApprove::where('academic_version_id', $request->academic_version_id)
                    ->where('site_student_admission_declare_id', $admission_declare_list->id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })

                    ->get();


            if(count($check_data_present)>0){
                return $check_data_present;
            }
            else{
                $blank_files=[[
                    'id'=>0,
                    'first_name'=>null,
                    'father_name'=>null,
                    'mother_name'=>null,
                    'board_roll_number'=>null,
                    'board_registration_number'=>null,
                    'academic_board_id'=>null,
                    'passing_year'=>null,
                ]];
                return $blank_files;
            }


        }
        else{
            return JsonResponse::create(['message' => 'No Admission Declare Found!'], 412);
        }

    }
   

    private function checkAdmissionDeclare($request){

        $data=$request->all();
        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->first();


        $academic_year_ids= $admission_declare_list->academic_year_ids[1];
        $academic_year_id_selected[]= $request->academic_year_id;
        $common_year_id=collect(array_intersect($academic_year_ids ?? [], $academic_year_id_selected))->first();
        if($common_year_id){
            $academic_year_status=1;
        }else{
            $academic_year_status=0;
        }



        $academic_shift_ids= $admission_declare_list->academic_shift_ids[1];
        $academic_shift_id_selected[]= $request->academic_shift_id;
        $common_shift_id=collect(array_intersect($academic_shift_ids ?? [], $academic_shift_id_selected))->first();
        if($common_shift_id){
            $academic_shift_status=1;
        }else{
            $academic_shift_status=0;
        }


        $check_dept_present=SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->pluck('academic_department_id')
            ->unique()
            ->filter();

        if(count($check_dept_present)>0){
            $academic_department_ids= $admission_declare_list->academic_department_ids[1];
            $academic_department_id_selected[]= $request->academic_department_id;
            $common_department_id=collect(array_intersect($academic_department_ids ?? [], $academic_department_id_selected))->first();

            if($common_department_id){
                $academic_department_status=1;
            }else{
                $academic_department_status=0;
            }

        }
        else{
            $academic_department_status=1;
        }


        //===========Class

        $academic_class_ids= $admission_declare_list->academic_class_ids[1];
        $academic_class_id_selected[]= $request->academic_class_id;
        $common_class_id=collect(array_intersect($academic_class_ids ?? [], $academic_class_id_selected))->first();

        if($common_class_id){
            $academic_class_status=1;
        }else{
            $academic_class_status=0;
        }



        //===========Session

        $check_session_present=SiteClassSessionSerialSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('session_ids', '!=',0)
            ->first();


        if($check_session_present){
            $academic_session_ids= $admission_declare_list->academic_session_ids[1];
            $academic_session_id_selected[]= $request->academic_session_id;
            $common_session_id=collect(array_intersect($academic_session_ids ?? [], $academic_session_id_selected))->first();
            if($common_session_id){
                $academic_session_status=1;
            }else{
                $academic_session_status=0;
            }
        }
        else{
            $academic_session_status=1;
        }

        return [$academic_year_status, $academic_shift_status, $academic_department_status,
            $academic_class_status, $academic_session_status];

    }


    public function createStudentRollRegForAdmissionValidation2(Request $request){

        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->first();
        $created=[];

        $data=$request->all();
        $present_all_data=SiteStudentAdmissionBoardApprove::where('academic_version_id', $request->academic_version_id)
            ->where('site_student_admission_declare_id', $admission_declare_list->id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })

            ->get();

        $all_ids=$present_all_data->pluck('id');


        $updated_ids=[];
        $created=[];

        foreach ($request->StudentList as $key => $value) {



            if($value['board_roll_number'] || $value['board_registration_number']){

                if(count($present_all_data)>0){
                    $check_data=$present_all_data->where('id', $value['id'])->first();

                    if($check_data){
                        $updated_ids[]=$value['id'];

                        $check_data->board_roll_number=$value['board_roll_number'];
                        $check_data->board_registration_number=$value['board_registration_number'];
                        $check_data->academic_board_id=$value['academic_board_id'];
                        $check_data->passing_year=$value['passing_year'];
                        $check_data->first_name=ucwords($value['first_name']);
                        $check_data->father_name=ucwords($value['father_name']);
                        $check_data->mother_name=ucwords($value['mother_name']);
                        $check_data->save();
                    }else{
                        $created[]=[
                            'site_student_admission_declare_id'=>$admission_declare_list->id,

                            'academic_year_id'=>$request->academic_year_id,
                            'academic_version_id'=>$request->academic_version_id,
                            'academic_class_id'=>$request->academic_class_id,
                            'academic_class_group_id'=>$request->academic_class_group_id,
                            'academic_department_id'=>$request->academic_department_id,
                            'academic_shift_id'=>$request->academic_shift_id,
                            'academic_session_id'=>$request->academic_session_id,
                            'site_id'=>Session::get('SITE_ID'),
                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                            'first_name' => ucwords($value['first_name']),
                            'father_name' => ucwords($value['father_name']),
                            'mother_name' => ucwords($value['mother_name']),
                            'board_roll_number' => $value['board_roll_number'],
                            'board_registration_number' => $value['board_registration_number'],
                            'academic_board_id' => $value['academic_board_id'],
                            'passing_year' => $value['passing_year'],
                        ];
                    }


                }
                else{
                    $created[]=[
                        'site_student_admission_declare_id'=>$admission_declare_list->id,

                        'academic_year_id'=>$request->academic_year_id,
                        'academic_version_id'=>$request->academic_version_id,
                        'academic_class_id'=>$request->academic_class_id,
                        'academic_class_group_id'=>$request->academic_class_group_id,
                        'academic_department_id'=>$request->academic_department_id,
                        'academic_shift_id'=>$request->academic_shift_id,
                        'academic_session_id'=>$request->academic_session_id,
                        'site_id'=>Session::get('SITE_ID'),
                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                        'first_name' => ucwords($value['first_name']),
                        'father_name' => ucwords($value['father_name']),
                        'mother_name' => ucwords($value['mother_name']),
                        'board_roll_number' => $value['board_roll_number'],
                        'board_registration_number' => $value['board_registration_number'],
                        'academic_board_id' => $value['academic_board_id'],
                        'passing_year' => $value['passing_year'],
                    ];
                }

            }




        }




        if(count($all_ids)>0){
            $validation_list=array_diff($all_ids->toArray(), $updated_ids);
            SiteStudentAdmissionBoardApprove::whereIn('id', $validation_list)->delete();
        }


        if(count($created)>0){
            SiteStudentAdmissionBoardApprove::insert($created);
        }

        return JsonResponse::create(['message' => 'Successfuly Saved!'], 200);

    }


    public function uploadRollRegExcell(Request $request)

    {

//        try {

//             \Log::info('ggg: '.$request->file->getRealPath());



            $registration_declare_list=SiteStudentAdmissionDeclare::where('status', true)
                ->first();

            if($registration_declare_list){
                $fileName = time() . '.' . $request->file->getClientOriginalExtension();
                $request->file->move(storage_path('pdf'), $fileName);


                $this->validate($request, [
                    //'select_file' => 'required|mimes:xls,xlsx'
                ]);
                $import = new SiteAdmissionRollImport;
                Excel::import($import, storage_path('pdf') . '/' . $fileName);
                $row_count = $import->getRowCount();

//                if ($row_count) {
//                    return response()->json(['message' => 'You Have Successfully Uploaded . ' . $row_count . ' Rows', 'mode' => 'Upload'], 200);
//
//                }
//                return response()->json(['message' => 'No Unique Row Found!'], 410);


                $checked_value=$this->checkAdmissionDeclare($request);


                if($checked_value[0] && $checked_value[1]
                    && $checked_value[2] && $checked_value[3]
                    && $checked_value[4])
                {
                    $get_excel_data=SiteStudentAdmissionBoardApproveExcel::get();


                    $data=$request->all();
                    $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)
                        ->first();

                    $get_present_data=SiteStudentAdmissionBoardApprove::
                    where('academic_version_id', $request->academic_version_id)
                        ->where('site_student_admission_declare_id', $admission_declare_list->id)
                        ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                            return $query->where('academic_year_id', $data['academic_year_id']);
                        })
                        ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                            return $query->where('academic_shift_id', $data['academic_shift_id']);
                        })
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                            return $query->where('academic_class_id', $data['academic_class_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->get();



                    $created=[];
                    foreach ($get_excel_data as $key => $value) {


                        $check_present_value=$get_present_data
                            ->when(!empty($value->board_roll_number), function ($query) use ($value) {
                                return $query->where('board_roll_number', $value->board_roll_number);
                            })
                            ->when(!empty($value->passing_year), function ($query) use ($value) {
                                return $query->where('passing_year', $value->passing_year);
                            })
                            ->first();



                        if(!$check_present_value){

                            $get_board_id=AcademicBoard::where('key_name', $value->board_name)->first();


                            $created[]=[
                                'site_student_admission_declare_id'=>$admission_declare_list->id,

                                'academic_year_id'=>$request->academic_year_id,
                                'academic_version_id'=>$request->academic_version_id,
                                'academic_class_id'=>$request->academic_class_id,
                                'academic_class_group_id'=>$request->academic_class_group_id,
                                'academic_department_id'=>$request->academic_department_id,
                                'academic_shift_id'=>$request->academic_shift_id,
                                'academic_session_id'=>$request->academic_session_id,
                                'site_id'=>Session::get('SITE_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                'first_name' => ucwords($value['student_name']),
                                'father_name' => ucwords($value['father_name']),
                                'mother_name' => ucwords($value['mother_name']),
                                'board_roll_number' => $value['board_roll_number'],
                                'board_registration_number' => $value['board_registration_number'],
                                'academic_board_id' => $get_board_id?$get_board_id->id:0,
                                'passing_year' => $value['passing_year'],
                            ];
                        }



                    }

                    if(count($created)>0){
                        SiteStudentAdmissionBoardApprove::insert($created);
                    }


                }
                else{
                    return JsonResponse::create(['message' => 'Your Admission Declare & your selected Data is not matched!'], 412);
                }

                if($get_excel_data->pluck('id')->count()>0){
                    SiteStudentAdmissionBoardApproveExcel::whereIn('id', $get_excel_data->pluck('id'))->delete();
                }


                return JsonResponse::create(['message' => 'Successfuly Saved!'], 200);

            }




//        } catch (ValidationException $exception) {
//            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
//        } catch (Exception $exception) {
//            throw new Error($exception->getMessage());
//        }
    }




    public function uploadRollRegForAdmissionValidation(Request $request){

        try {


            $checked_value=$this->checkAdmissionDeclare($request);


            if($checked_value[0] && $checked_value[1]
                && $checked_value[2] && $checked_value[3]
                && $checked_value[4])
            {
                $get_excel_data=SiteStudentAdmissionBoardApproveExcel::get();


                $data=$request->all();
                $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)
                    ->first();

                $get_present_data=SiteStudentAdmissionBoardApprove::
                where('academic_version_id', $request->academic_version_id)
                    ->where('site_student_admission_declare_id', $admission_declare_list->id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->get();



                $created=[];
                foreach ($get_excel_data as $key => $value) {


                    $check_present_value=$get_present_data
                        ->when(!empty($value->board_roll_number), function ($query) use ($value) {
                            return $query->where('board_roll_number', $value->board_roll_number);
                        })
                        ->when(!empty($value->passing_year), function ($query) use ($value) {
                            return $query->where('passing_year', $value->passing_year);
                        })
                        ->first();



                    if(!$check_present_value){

                        $get_board_id=AcademicBoard::where('key_name', $value->board_name)->first();


                        $created[]=[
                            'site_student_admission_declare_id'=>$admission_declare_list->id,

                            'academic_year_id'=>$request->academic_year_id,
                            'academic_version_id'=>$request->academic_version_id,
                            'academic_class_id'=>$request->academic_class_id,
                            'academic_class_group_id'=>$request->academic_class_group_id,
                            'academic_department_id'=>$request->academic_department_id,
                            'academic_shift_id'=>$request->academic_shift_id,
                            'academic_session_id'=>$request->academic_session_id,
                            'site_id'=>Session::get('SITE_ID'),
                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                            'first_name' => ucwords($value['first_name']),
                            'father_name' => ucwords($value['father_name']),
                            'mother_name' => ucwords($value['mother_name']),
                            'board_roll_number' => $value['board_roll_number'],
                            'board_registration_number' => $value['board_registration_number'],
                            'academic_board_id' => $get_board_id?$get_board_id->id:0,
                            'passing_year' => $value['passing_year'],
                        ];
                    }

                }

                if(count($created)>0){
                    SiteStudentAdmissionBoardApprove::insert($created);
                }


            }
            else{
                return JsonResponse::create(['message' => 'Your Admission Declare & your selected Data is not matched!'], 412);
            }

            if($get_excel_data->pluck('id')->count()>0){
                SiteStudentAdmissionBoardApproveExcel::whereIn('id', $get_excel_data->pluck('id'))->delete();
            }


            return JsonResponse::create(['message' => 'Successfuly Saved!'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }

}
