<?php

namespace App\Http\Controllers\Site\StudentPanel\Attendance;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Attendance\StudentAttendance;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Models\Student\StudentHistory;
use App\Traits\Site\EventTrait;
use App\Traits\Site\GlobalFunctionsTrait;
use App\Traits\Site\Routine\RoutineFunction;
use Auth;
use Carbon\Carbon;
use DateTime;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use PDF;

class AttendanceController extends ProjectController
{
    use DataHelper, RoutineFunction, EventTrait;
    private $studentAttendance;
    private $periodTypeDuration;
    private $routineAllocation;
    private $studentHistory;
    private $routineDetail;
    private $meetingInvitation;
    private $periodicAttendance;
    private $siteShiftDetails;


    public function __construct(StudentHistory $studentHistory, MeetingInvitation $meetingInvitation, StudentAttendance $studentAttendance, SitePeriodTypeDuration $periodTypeDuration,
                                RoutineDetail $routineDetail, RoutineAllocation $routineAllocation, PeriodicAttendance $periodicAttendance, SiteShiftDetails $siteShiftDetails)
    {

        $this->middleware('auth');
        $this->middleware('siteStudentchecker');

        $this->periodicAttendance = $periodicAttendance;

        $this->meetingInvitation = $meetingInvitation;
        $this->studentAttendance = $studentAttendance;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->routineAllocation = $routineAllocation;
        $this->studentHistory = $studentHistory;
        $this->routineDetail = $routineDetail;
        $this->siteShiftDetails = $siteShiftDetails;

    }


    public function master()
    {
        $viewType = 'Student Attendance';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getIndividualAttendance(Request $request)
    {
        $date_range = json_decode($request->date_range);

        $start_date = $date_range->start ?? null;
        $end_date = $date_range->end ?? null;


        if ($date_range) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }


        $id = Auth::user()->id;
        $paginate = $request->paginate ?? 20;

        $att_list = $this->studentAttendance
            ->whereHas('userHistory', function ($q) use ($id) {
                $q->where('user_id', $id);
            })
            ->orderBy('id', 'DESC')
            ->when($date_range, function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('present_date', [$start_date, $end_date]);
            })
            ->paginate($paginate);


        $att_list->getCollection()->transform(function ($value) {

            return [

                'user_id' => $value->user_id ?? 0,
                'full_name' => $value->user->full_name ?? 'n/a',
                'contact_number' => $value->user->contact_number ?? 'n/a',
                'date' => $value->present_date ?? 'n/a',
                'in_time' => $value->in_time ?? null,
                'out_time' => $value->out_time ?? null,
                'status' => $value->late_status ? 'Late' : 'Intime',
            ];
        });


        return response()->json($att_list, 200);
    }


    public function getPeriodList(Request $request)
    {

        $attDate = $request->att_date;//'2020-01-09';//;
        $history_id = $request->history_id;//'2020-01-09';//;


        $site_id = (int)session()->get('SITE_ID');
        $academic_group_id = (int)session()->get('ACADEMIC_GROUP_ID');
        $is_day_open = $this->isTheDateOpen($attDate, $academic_group_id, $site_id);

        if (!$is_day_open) {
            return response()->json(['message' => date('d M Y', strtotime($attDate)) . ' is holiday!'], 411);
        }


        $date = $attDate ? $attDate : date('Y-m-d', time());//'2019-05-09';
        $day = date('l', strtotime($date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $date)
            ->where('end_date', '>=', $date)
            ->first();


        $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
        if (!$period_id) {
            return response()->json(['message' => 'No Period Type Duration Found'], 411);
        }

        $history = $this->studentHistory
            ->with('subjects')
            ->find($history_id);

        $all_sub_ids = $history->subjects()->pluck('academic_subject_id');

        $route_details = $this->routineDetail
            /* ->whereHas('allocation', function ($q) use ($all_sub_ids, $date) {
                 $q->whereIn('subject_id', $all_sub_ids)
                     ->where('status', true)
                     ->orWhere(function ($q1) use ($date, $all_sub_ids) {
                         $q1->orWhereHas('swapCancel', function ($q) use ($date, $all_sub_ids) {
                             $q->where('swap_cancel_date', $date)
                                 ->whereIn('subject_id', $all_sub_ids);
                         });
                     });
             })*/
            ->where(function ($q1) use ($all_sub_ids, $date) {
                $q1->whereHas('allocation', function ($q) use ($all_sub_ids, $date) {
                    $q->whereIn('subject_id', $all_sub_ids)
                        ->where('status', true);
                });

            })
            ->where('weekday', $day)
            ->where('status', true)
            ->with(['allocation' => function ($q) use ($all_sub_ids, $date) {
                $q->where('status', true)
                    ->with(['liveMeeting' => function ($q) use ($date) {
                        $q->where('join_date', $date);
                    }]);
            }, 'allocation.swapCancel' => function ($q) use ($date) {
                $q->where('swap_cancel_date', $date);
            }/*,
                 'allocation.liveMeeting' => function ($q) use ($date) {
                     $q->where('join_date', $date);
                 }*/, 'allocation.liveMeeting.meeting', 'class', 'section'])
            ->where('academic_period_type_id', $period_id)
            ->where('academic_version_id', $history->academic_version_id)
            ->where('academic_year_id', $history->academic_year_id)
            ->where('academic_shift_id', $history->academic_shift_id)
            ->where('academic_class_id', $history->academic_class_id)
            ->when($history->academic_department_id, function ($query) use ($history) {
                return $query->where('academic_department_id', $history->academic_department_id);
            })->when($history->academic_section_id, function ($query) use ($history) {
                return $query->where('academic_section_id', $history->academic_section_id);
            })->when($history->academic_class_group_id, function ($query) use ($history) {
                return $query->where('academic_class_group_id', $history->academic_class_group_id);
            })->when($history->academic_session_id, function ($query) use ($history) {
                return $query->where('academic_session_id', $history->academic_session_id);
            })->orderBy('start_time', 'ASC')
            ->get();


//        dd($route_details[0]->allocation);

        /*   $routine_allocation_final = $route_allocations->merge($routine_allocation_final);

           //  }*/

        $allocation_lists = [];

        foreach ($route_details as $k => $detail) {


            $last_ind = (count($route_details) - 1);

            //   dd($detail->allocation->liveMeeting);

            $allocation_lists[$k]['id'] = $detail->allocation->id ?? '';
            $allocation_lists[$k]['first_last'] = ($k == 0 ? 'first' : null) ?? ($k == $last_ind ? 'last' : null);
            $allocation_lists[$k]['details'] = (addOrdinalNumberSuffix($k + 1)) . ' (' . ($detail->class->class_name ?? '') . ' ' . ($detail->section->section_name ?? '') . ')';
            $allocation_lists[$k]['start_time'] = $detail->start_time ?? '';
            $allocation_lists[$k]['end_time'] = $detail->end_time ?? '';
            $allocation_lists[$k]['swapCancel'] = $detail->allocation->swapCancel ?? null;
            $allocation_lists[$k]['subject_name'] = $detail->allocation->swapCancel->subject_name_ex ??  $detail->allocation->subject_name_ex ?? '';
            $allocation_lists[$k]['employee_name'] = $detail->allocation->swapCancel->employee_name_ex  ?? $detail->allocation->employee_name_ex  ?? '';

            $allocation_lists[$k]['invitation_id'] = $detail->allocation->liveMeeting->id ?? 0;
            $allocation_lists[$k]['live_join_link'] = ($detail->allocation->liveMeeting->status ?? null) ? ($detail->allocation->liveMeeting->meeting->join_url ?? null) : null;

        }
//        dd($allocation_lists);
//
        /*foreach ($routine_allocation_final as $k => $allocation) {


//              dd($allocation['liveMeeting']);

          $allocation_lists[$k]['id'] = $allocation['id'] ?? '';
          $allocation_lists[$k]['start_time'] = $allocation['routineDetail']['start_time'] ?? '';
          $allocation_lists[$k]['end_time'] = $allocation['routineDetail']['end_time'] ?? '';
          $allocation_lists[$k]['class_timing_detail_name'] = $allocation['routineDetail']['classTimingDetail']['name'] ?? '';
          $allocation_lists[$k]['class_name'] = $allocation['routineDetail']['class']['class_name'] ?? '';
          $allocation_lists[$k]['section_name'] = $allocation['routineDetail']['section']['section_name'] ?? '';
          $allocation_lists[$k]['swapCancel'] = $allocation['swapCancel'] ?? null;
          $allocation_lists[$k]['subject_name'] = $allocation['swapCancel']['subject_name_ex'] ?? $allocation['subject_name_ex'] ?? '';
          $allocation_lists[$k]['employee_name'] = $allocation['swapCancel']['employee_name_ex'] ?? $allocation['employee_name_ex'] ?? '';

          $allocation_lists[$k]['invitation_id'] = $allocation['liveMeeting']['id'] ?? 0;
          $allocation_lists[$k]['live_join_link'] = $allocation['liveMeeting']['status'] ? $allocation['liveMeeting']['meeting']['join_url'] : null;

      }
      // dd($allocation_lists);*/


        if (count($allocation_lists) < 1) {
            return response()->json(['message' => 'No Routine Is Assigned For You on ' . $day], 411);
        }
        return response()->json([$allocation_lists, $date], 200);
    }


    public function savePeriodicAttendance(Request $request)
    {


        $invitation_id = $request->invitation_id;
        $history_id = $request->history_id;
        $first_last_period = $request->first_last;
        $auth_id = Auth::user()->id;

        $the_inv = $this->meetingInvitation
            //  ->with(['meeting', 'routineAllocation', 'routineAllocation.routineDetail'])
            ->find($invitation_id);
        if (!$the_inv->status) {
            return response()->json(['message' => 'Your invitation has expired!'], 410);
        }

        //return response()->json(['message' =>  $first_last_period], 410);

        $att_date = $the_inv->join_date;
        $start_time = $the_inv->routineAllocation->routineDetail->start_time ?? null;
        $end_time = $the_inv->routineAllocation->routineDetail->end_time ?? null;

        $start = strtotime("$att_date $start_time");
        $end = strtotime("$att_date $end_time");

        if (time() >= $start && time() <= $end) {
            //current time is within class start and end time
        } else {
            return response()->json(['message' => 'Oops,Class time either not started or ended! Start Time:' . date('d M Y h:i A', $start) . '-' . date('d M Y h:i A', $end)], 410);
        }
        $current_time = strtotime(Carbon::now()->toDateTimeString());
        $difference = (abs($current_time - $start) / 60);

        $routine_allocation = $the_inv->routineAllocation;
        $day = date('D', strtotime($att_date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();

        if (!$get_period_type_duration) {
            throw new Error('No Period Found On ' . $att_date);
        }

        $current_time = Carbon::now()->toTimeString();
        $late_status = $difference >= 1 ? true : false;

        $existed = $this->periodicAttendance
            ->where('student_history_id', $history_id)
            ->where('present_date', $att_date)
            ->where('routine_allocation_id', $routine_allocation->id)
            ->first();


        if (!$existed) {

            $this->periodicAttendance = new PeriodicAttendance();
            $this->periodicAttendance->routine_allocation_id = $routine_allocation->id;
            $this->periodicAttendance->student_history_id = $history_id;
            $this->periodicAttendance->in_time = $current_time;
            $this->periodicAttendance->out_time = $end_time;
            $this->periodicAttendance->present_date = $att_date;
            $this->periodicAttendance->present_year = date('Y', strtotime($att_date));
            $this->periodicAttendance->present_month = date('m', strtotime($att_date));
            $this->periodicAttendance->present_day = date('d', strtotime($att_date));
            $this->periodicAttendance->in_leave = false;
            $this->periodicAttendance->is_present = true;
            $this->periodicAttendance->late_status = $late_status;
            $this->periodicAttendance->note = '';
            $this->periodicAttendance->taken_by = $auth_id;
            $this->periodicAttendance->save();
        }

        $the_history = $this->studentHistory->find($history_id);

        $day_present_exited = $this->studentAttendance
            ->where('present_date', $att_date)
            ->where('student_history_id', $history_id)
            ->first();

        $st_shift_details = $this->siteShiftDetails
            ->where('academic_shift_id', $the_history->academic_shift_id)
            ->where('belongs_to', 'student')
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->where('academic_group_id', $the_history->academic_group_id)
            ->where('week_day', $day)
            ->where('status', true)
            ->first();

        if (!$st_shift_details) {
            throw new Error('Shift Setting not found!');
        }

        $st_attendance = $day_present_exited ?? new StudentAttendance();
        $st_attendance->student_history_id = $history_id;
        $st_attendance->present_type = 'web';
        $st_attendance->site_shift_details_id = $st_shift_details->id ?? 0;
        $st_attendance->in_time = $first_last_period == 'first' ? $start_time : ($st_attendance->in_time);
        $st_attendance->out_time = $end_time ?? $st_attendance->out_time;


        $st_attendance->present_date = $att_date;
        $st_attendance->present_date_time = ($st_attendance->present_date_time ?? $att_date . ' ' . $start_time);
        $st_attendance->present_year = date('Y', strtotime($att_date));
        $st_attendance->present_month = date('m', strtotime($att_date));
        $st_attendance->present_day = date('d', strtotime($att_date));
        $st_attendance->late_status = $late_status;
        $st_attendance->created_by = $auth_id;
        $st_attendance->updated_by = $auth_id;
        $st_attendance->save();


        return response()->json(['message' => 'Periodic In Time Attendance Successfully Taken', 'join_url' => ($the_inv->meeting->join_url ?? null)], 200);


    }

    public function getRoutinePdf(Request $request)
    {
        try {

            $his_id = $request->history_id;
            $academic_period_type_id = $request->academic_period_type_id;


            if (!$his_id || !$academic_period_type_id) {
                return " Period type not found!";
            }
            $the_his = $this->studentHistory->find($his_id);

            if (!$the_his) {
                return "The Student History Not Found!";
            }

            $data = [];
            $data['academic_version_id'] = $the_his->academic_version_id == 'null' ? null : $the_his->academic_version_id;
            $data['academic_year_id'] = $the_his->academic_year_id == 'null' ? null : $the_his->academic_year_id;
            $data['academic_shift_id'] = $the_his->academic_shift_id == 'null' ? null : $the_his->academic_shift_id;
            $data['academic_department_id'] = $the_his->academic_department_id == 'null' ? null : $the_his->academic_department_id;
            $data['academic_class_id'] = $the_his->academic_class_id == 'null' ? null : $the_his->academic_class_id;
            $data['academic_section_id'] = $the_his->academic_section_id == 'null' ? null : $the_his->academic_section_id;
            $data['academic_class_group_id'] = $the_his->academic_class_group_id == 'null' ? null : $the_his->academic_class_group_id;
            $data['academic_session_id'] = $the_his->academic_session_id == 'null' ? null : $the_his->academic_session_id;
            $data['academic_period_type_id'] = $academic_period_type_id ?? 0;

            $all_sub_ids = $this->studentSubjectIds($the_his);

            $getRoutineDetails = $this->routineDetail
                ->with(['routineAllocations' => function ($q) use ($all_sub_ids) {
                    $q->whereIn('subject_id', $all_sub_ids)
                        ->where('status', true);
                }])->whereHas('routineAllocations', function ($q) use ($all_sub_ids) {
                    $q->whereIn('subject_id', $all_sub_ids)
                        ->where('status', true);
                })
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->orderBy('start_time', 'ASC')
                ->where('status', true)
                ->get();

            if (count($getRoutineDetails) < 1) {
                return "No Routine Found!";
            }

            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {

                $week_array[$weekDay->weekday_name] = $getRoutineDetails->where('weekday', $weekDay->weekday_key) ?? [];
                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }

            $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week
            $report_tittle2 = "<b>Routine For:</b>" . $the_his->student->full_name;
            $report_tittle = $this->reportTitle($getRoutineDetails[0]);

            $br_col[] = -1;

            $pdf = PDF::loadView('default.student.routine.routine-report', compact('week_array', 'headingList', 'max_col_count', 'report_tittle', 'br_col', 'report_tittle2'));
            return $pdf->stream($the_his->student->username . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }

}
