<?php

namespace App\Http\Controllers\Site\StudentPanel\Transaction;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Edu\Transaction\EduStudentInvoice;
use App\Models\Edu\Transaction\EduTransactionDetail;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Employee\Employee;
use App\Models\Site\SiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use App\Traits\Site\Payment\StudentBkashTransactionTrait;
use App\Traits\Site\Payment\StudentNagadTransactionTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Student\StudentHistory;
use App\Traits\EduTransaction\EduStudentNagadTransactionTrait;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use App\Traits\Site\Fee\StudentFeeTrait;
use App\Traits\Site\Payment\StudentSonaliPayTransactionTrait;
use PDF;
use Response;
Use Error;
use Session;
use Auth;
use Carbon\CarbonPeriod;

class SiteStudentTransactionController extends Controller
{
    use StudentNagadTransactionTrait, PaymentGatewayTrait, StudentBkashTransactionTrait, SonaliPayStudentFeeTrait;


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('siteStudentchecker');
    }


    public function index()
    {
        $viewType = 'Student Transaction';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    //===========================edu student transaction===========================================

    public function getOnlinePaymentMethodListForTransaction(){

        $payment_list=AcademicOnlinePaymentMethod::get();

        return $payment_list;

    }

    //=============================================================================================

   
    //===========================sonalipay transaction by using portal=================================

  


    public function getStudentPaymentInfoForGateway(Request $request){

        
        $site_id=Session::get('SITE_ID');
    //    $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        $site_info = SiteInfo::findOrFail($site_id);

        if($site_info->student_fee_collection_status==false){
            return response()->json(['Message'=>'The service is temporarily unavailable, please try again after some time.','Status'=>'404'],404);
        }

        $user_id = Auth::user()->id;
        $username = Auth::user()->username;


        if($request->gateway_name_key=='sonali_pay'){
           
            $request_data=[
                'site_id'=>$site_id,
                'user_id'=>$user_id,
                'username'=>$username,
                'request_amount'=>$request->payable_amount,
                'redirect_path'=>"/student/payment/sonali-pay-message"
            ];
            $api_response = $this->studentFeeInfoForSonaliPay($request_data);

           return response()->json($api_response);

        }else{
            return response()->json(['Message'=>'it is developing','Status'=>'404'],404);
        }
        
    }

    public function checkSonaliPayTokenMode(Request $request){
     //   dd('sf');

        $data=$request->all();

        //session check
        $currentTime = Carbon::now('Asia/Dhaka');
        $session=PaymentSession::where('user_id',auth()->id())
            ->where('end_date_time','>',$currentTime)
            ->where('token',$data['Token'])
            ->where('ip_address',request()->ip())
            ->where('status',1)
            ->orderBy('id','DESC')
            ->first();
        
        if(!$session){      
            $response=[
                'Status'=>'403',
                'Message'=>'Payment Session expired!',
            ];

            return $response;
        }


        $site_id=Session::get('SITE_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        $username = Auth::user()->username;
        $user_id = Auth::user()->id;
       
       $req_data=[
            'site_id'=>$site_id,
            'academic_group_id'=>$academic_group_id,
            'username'=>$username,
            'user_id'=>$user_id,
        ];

        if($data['Mode']==='success'){ 
            
          $req_response=$this->feePaymentAndSonaliPayTokenVerify($data,$req_data);

          if($req_response['Status']=='200'){

            $host = request()->getSchemeAndHttpHost();
            $site_voucher_link=$host.'/student/payment/student-payment-slip-pdf/'.$req_response['InvoiceNo'];
            $req_response['site_voucher_link']=$site_voucher_link;
            $response=$req_response;

          }else{
            $response=[
                'Status'=>$req_response['Status'],
                'Message'=>'Your transaction was unsuccessful',
            ];
          }

        }else{
            $response=[
                'Status'=>'400',
                'Message'=>'Your transaction was unsuccessful. Please check and retry!',
                'Details'=>'Mode failed'
            ];

            $response_test=json_encode($response);

            $issue = new IssueDetail();
            $issue->issue_type='online-transaction-failed:site-student';
            $issue->issuer_type='site';
            $issue->issue_details=$response_test;
            $issue->site_id=$req_data['site_id'];
            $issue->username=$req_data['username'];
            $issue->ip_address=request()->ip();
            $issue->save();

        }

        // session clear
        $session->status=0;
        $session->save();

        return $response;
    }




    public function checkPaymentDetailsWithTransactionID(Request $request){
            $req_data=$request->all();


            $site_id=Session::get('SITE_ID');
            $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
            $user = Auth::user();
            $username = Auth::user()->username;
            $user_id = Auth::user()->id;

            $this->validate($request, [
                'gateway_name_key' => 'required',
                'transaction_id' => 'required',
            ]);

            $req_data=[
                'site_id'=>$site_id,
                'academic_group_id'=>$academic_group_id,
                'username'=>$username,
                'user_id'=>$user_id,
                'gateway_name_key'=>$request->gateway_name_key,
                'transaction_id'=>$request->transaction_id,
                'InvoiceNo'=>$request->transaction_id,
                'transaction_id'=>$request->transaction_id,
                'transaction_id'=>$request->transaction_id,
            ];

         

            if($request->gateway_name_key=='sonali_pay'){
                $result=$this->checkBySonaliPayTransactionIDAndGetInfoForWeb($req_data,$user);

                if($result['status']=='200'){
                    return response()->json($result,200);
                }else{
                    return response()->json($result,410);
                }



            }else if($request->gateway_name_key=='bkash'){

                return response()->json(['message'=>'Gateway not found!'],410);

            }else if($request->gateway_name_key=='surecash'){

                return response()->json(['message'=>'Gateway not found!'],410);

            }
        }



    //=============================================================================================

    //===========================nagad transaction by using portal=================================

    public function getPaymentDetailsForNagadTransaction(Request $request){

        $details = $request->payment_details;
        $payable_amount = $details['total_amount'];
        $slip_id = $details['slip_no'] - 100000;
        $site_id = (int)session()->get('SITE_ID');
        $site_info = SiteInfo::findOrFail($site_id);
        $site_alias = $site_info->site_alias;

        //====================nagad==================
        if($request->gateway_name_key=='nagad'){

            $payment_gateway_details = PaymentGateway::where('academic_payment_method_key', $request->gateway_name_key)
                                                        ->whereHas('academicOnlinePaymentMarchentType', function ($qr) {
                                                            return $qr->where('name_key', 'e_commerce');
                                                        })->first();

            $MerchantID=$payment_gateway_details->partner_code;
            $merchant_number=$payment_gateway_details->partner_number;

            $OrderId = $site_alias.strtotime("now").rand(1000, 10000);

            $demand_slip = SiteStudentFeeDemandSlipDetails::where('order_id',$OrderId)->first();
            if($demand_slip){
                throw new Error('Sorry! Please try again');
            }

            $DateTime=Carbon::now()->format('YmdHis');

            $trans_data=[
                'merchant_id'=>$MerchantID,
                'order_id'=>$OrderId,
                'date_time'=>$DateTime,
                'amount'=>$payable_amount,
                'merchant_number'=>$merchant_number,

            ];

//            dd($trans_data) ;

            $Result_Data = $this->siteStudentTransactionRequest($trans_data);
//            dd($Result_Data) ;
            if($Result_Data){
                SiteStudentFeeDemandSlipDetails::where('id',$slip_id)
                    ->update([
                        'order_id'=>$OrderId,
                        'site_payment_gateway_id'=>$payment_gateway_details->id,
                    ]);

                return $Result_Data;
            }else{
                throw new Error('Sorry! merchant invalid!');
            }


        }

    }

    //---------------------------------nagad call back page------------------------------------

    public function getNagadSiteStudentCallbackWebsite(){

        $return_data=$this->TransactionComplition();
        $return_data=json_decode($return_data, true);
        $get_demand_slip=SiteStudentFeeDemandSlipDetails::where('order_id', $return_data['orderId'])->first();
        $payment_type = 'nagad';
        $transaction_by_id = false;
        $data = $this->getDemandSlipDetails($get_demand_slip);
        $final_data = $this->paymentReceive($data, $return_data, $payment_type, $transaction_by_id);

        //=====Log Start

        $user_list=GlobalStudentHistory::with(['student'=>function($query){
            $query->select('id', 'username');
        }])
            ->select('id', 'user_id')
            ->where('id', $get_demand_slip->student_history_id)
            ->first();

        $issue = new    IssueDetail();
        $issue->issue_type = 'transaction:site-student';

        $issue->bearer_type = 'site';
        $issue->bearer_id = \Session::get('SITE_ID');
        $issue->username = $user_list->student->username;
        $issue->ip_address = request()->ip();
        $issue->issue_details = $return_data;

        $issue->save();

        //=====Log End

        if($final_data){
            return redirect()->route('site-student-payment-master');

        }

    }

    //=============================================================================================



    //==========================site student transaction with transaction id=======================

    public function getPaymentDetailsForTransactionWithTransactionID(Request $request){
//        return $request;
        if($request->name_key == 'nagad'){
            $this->paymentTakeByNagadTransactionID($request);
        }else if($request->name_key == 'bkash'){

        }else if($request->name_key == 'surecash'){

        }
    }

    //----------------------------transaction by nagad transaction id------------------------------

    public function paymentTakeByNagadTransactionID(Request $request){


//      $PostURL = "https://ws-external.mynagad.com:8162/theWorld/api/v1/data?requestType=getDataByTxnId";
//      $authorizatioin_code = "Basic ZEdobFYyOXliR1E9Okl6RklNak14TXpSQUlVQWpjMnhoYzJSbVlXVmhQUT092:";
//        $header = array(
//            'Content-Type:application/json',
//            'Authorization:Basic ZEdobFYyOXliR1E9Okl6RklNak14TXpSQUlVQWpjMnhoYzJSbVlXVmhQUT092:',
//        );

        $authorizatioin_code = "";
//        dd($request);

        //==========================check validation========================

        $payment_gateway = PaymentGateway::where('academic_payment_method_key', $request->name_key)
        ->whereHas('academicOnlinePaymentMarchentType', function ($qr) {
            return $qr->where('name_key', 'normal_marchent');
        })->first();

        if($payment_gateway){
            $authorizatioin_code = $payment_gateway->authorization;
            $PostURL = $payment_gateway->api_link;
            if(!$authorizatioin_code || !$PostURL){
                throw new Error('Sorry! authorization code or api link not found!');
            }

        }else{
            throw new Error('Sorry! gateway not found!');
        }

        //====================initial data for nagad api===================

        $content_type = "application/json";
        $header[0] = 'Content-Type:'.$content_type;
        $header[1] = 'Authorization:'.$authorizatioin_code;

        $trans_data=[
            "txnId"=> $request->agent_transaction_id,
        ];

        $data = json_encode($trans_data);

        $url = curl_init($PostURL);

        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $data);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_SSL_VERIFYPEER, false);

        $resultData = curl_exec($url);
        $error_msg = null;
        if (curl_errno($url)) {
            $error_msg = curl_error($url);
//            throw new Error($error_msg);
        }

        $ResultArray = json_decode($resultData, true);
        curl_close($url);
        if($ResultArray['error_code']){
            throw new Error($ResultArray['error_message']);
        }else{

            //====================payment update to database===================

            $details = $request->payment_details;
            $payable_amount = $details['total_amount'];
            $slip_id = $details['slip_no'] - 100000;

            $return_data=$ResultArray;
            if($payable_amount == $return_data['txnAmount']){

                $get_demand_slip=SiteStudentFeeDemandSlipDetails::where('id', $slip_id)->first();
                $payment_type = 'nagad';
                $transaction_by_id = true;
                $data = $this->getDemandSlipDetails($get_demand_slip);
                $final_data = $this->paymentReceive($data, $return_data, $payment_type, $transaction_by_id);

                //=====Log Start

                $user_list=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id', 'username');
                }])
                    ->select('id', 'user_id')
                    ->where('id', $get_demand_slip->student_history_id)
                    ->first();

                $issue = new    IssueDetail();
                $issue->issue_type = 'transaction:site-student';

                $issue->bearer_type = 'site';
                $issue->bearer_id = \Session::get('SITE_ID');
                $issue->username = $user_list->student->username;
                $issue->ip_address = request()->ip();
                $issue->issue_details = $return_data;
                $issue->save();

                //=====Log End

                if($final_data){
                    return Response::json(['message' => 'Transaction successfully completed!', 'mode' => 'Saved!'], 200);
                }

            }else{
                throw new Error('Sorry! paid amount not matched!');
            }

        }

    }

    //----------------------transaction for edu by nagad transaction id----------------------------

    public function paymentTakeByNagadTransactionIDForEdu(Request $request){

        $trans_data=[
            "txnId"=> $request->agent_transaction_id,
        ];

        $data = json_encode($trans_data);

        $PostURL = "https://ws-external.mynagad.com:8162/theWorld/api/v1/data?requestType=getDataByTxnId";

        $url = curl_init($PostURL);
        $authorizatioin_code = "Basic ZEdobFYyOXliR1E9Okl6RklNak14TXpSQUlVQWpjMnhoYzJSbVlXVmhQUT092:";
        $content_type = "application/json";
        $header[0] = 'Content-Type:'.$content_type;
        $header[1] = 'Authorization:'.$authorizatioin_code;

//        $header = array(
//            'Content-Type:application/json',
//            'Authorization:Basic ZEdobFYyOXliR1E9Okl6RklNak14TXpSQUlVQWpjMnhoYzJSbVlXVmhQUT092:',
//        );


        curl_setopt($url, CURLOPT_HTTPHEADER, $header);
        curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url, CURLOPT_POSTFIELDS, $data);
        curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($url, CURLOPT_SSL_VERIFYPEER, false);

        $resultData = curl_exec($url);
        $error_msg = null;
        if (curl_errno($url)) {
            $error_msg = curl_error($url);
//            throw new Error($error_msg);
        }

        $ResultArray = json_decode($resultData, true);
        curl_close($url);
        if($ResultArray['error_code']){
            throw new Error($ResultArray['error_message']);
        }else{

        }

    }


    //==============================================================================================





    //=====================================bkash transaction========================================

    public function getToken(){
//        return 'ok';
        $token = $this->token();

        return $token;
    }

    public function createBkashPayment(){
        $create_payment = $this->createPayment();
        return $create_payment;
    }

    public function executeBakashPayment(Request $request){
        $execute_payment = $this->executePayment($request);
        return $execute_payment;
    }


}
