<?php

namespace App\Http\Controllers\Site\StudentRegistration;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\StudentRegistration\SiteBaseStudentRegistrationDeclare;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicSection;
use Illuminate\Http\JsonResponse;
use Exception;
use Illuminate\Validation\ValidationException;
use Session;
use Response;

class SiteBaseStudentRegistationDeclareController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Student Registration Declaration Page';
        return view('default.admin.layouts.master', compact('viewType'));

        return view('default.site.student_registration.site-base-student-registration-declare', compact('viewType'));

    }


    public function getYearDeptClassShiftVersionSessionRegistrationDeclareList()
    {

        $site_info_setting = SiteInfoSetting::first();


        $academic_version_ids = explode(',', $site_info_setting->academic_version_ids) ?? null;
        $academicVersionList = AcademicVersion::select('id', 'version_name')
            ->whereIn('id', $academic_version_ids)
            ->get();


        $shift_ids = explode(',', $site_info_setting->shift_ids) ?? null;
        $shiftList = AcademicShift::select('id')
            ->whereIn('id', $shift_ids)
            ->get();


        $academic_year_ids = explode(',', $site_info_setting->academic_year_ids) ?? null;
        $academicYearList = AcademicYear::select('id', 'year_name')
            ->whereIn('id', $academic_year_ids)
            ->get();


        $academicDepartmentList = [];
        if ($site_info_setting->academic_department_ids) {
            $academicDepartment = explode(',', $site_info_setting->academic_department_ids) ?? null;
            $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
                ->whereIn('id', $academicDepartment)->get();
        }
        $academicClass = explode(',', $site_info_setting->academic_class_ids) ?? null;
        $academicClassList = AcademicClass::select('id', 'class_name')
            ->whereIn('id', $academicClass)
            ->orderBy('serial_no', 'ASC')
            ->get();

        $academicSectionIds = explode(',', $site_info_setting->academic_section_ids) ?? null;
        $AcademicSectionList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $academicSectionIds)
            ->get();


        $academicSession = explode(',', $site_info_setting->academic_session_ids) ?? null;
        $academicSessionList = AcademicSession::select('id', 'session_name')
            ->whereIn('id', $academicSession)
            ->get();


        $RegistrationDeclareList = SiteBaseStudentRegistrationDeclare::get();


        return compact('academicVersionList', 'shiftList', 'academicYearList', 'academicDepartmentList',
            'academicClassList', 'academicSessionList', 'RegistrationDeclareList','AcademicSectionList');


    }


    public function createSiteBaseStudentRegistrationDeclare(Request $request, SiteBaseStudentRegistrationDeclare $sbsrd)
    {

        try {


            $this->validate($request, [
                "start_date" => "required",
                "end_date" => "required",
                "shift_ids" => "required",
                "academic_version_ids" => "required",
                "academic_year_ids" => "required",
                "academic_class_ids" => "required",
            ]);


            if ($request->start_date > $request->end_date) {

                $start_date = $request->end_date;
                $end_date = $request->start_date;

            } else {
                $start_date = $request->start_date;
                $end_date = $request->end_date;
            }


            $check_start_date = SiteBaseStudentRegistrationDeclare::
            where('duration_from_date', '>=', $start_date)
                ->whereOr('duration_to_date', '>=', $start_date)
                ->where('status', true)
                ->first();


            $check_end_date = SiteBaseStudentRegistrationDeclare::
            where('duration_from_date', '>=', $end_date)
                ->whereOr('duration_to_date', '>=', $end_date)
                ->where('status', true)
                ->first();


            if ($check_start_date || $check_end_date) {

                return 'sametimeerror';
            } else {

                $check_actice_data = SiteBaseStudentRegistrationDeclare::
                where('status', true)
                    ->first();

                if ($check_actice_data) {
                    $check_actice_data->update([
                        'status' => false
                    ]);
                }


                $sbsrd->duration_from_date = $start_date;
                $sbsrd->duration_to_date = $end_date;
                $sbsrd->extended_date = $request->extended_date;
                $sbsrd->remark = $request->remark;
                $sbsrd->send_sms = $request->send_sms;
                $sbsrd->old_student_information_add = $request->old_student_information_add;


                $sbsrd->guardian_information_add = $request->guardian_information_add;
                $sbsrd->address_information_add = $request->address_information_add;
                $sbsrd->communication_information_add = $request->communication_information_add;
                $sbsrd->previous_institute_information_add = $request->previous_institute_information_add;
                $sbsrd->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
                $sbsrd->student_registration_number_box_show = $request->student_registration_number_box_show;


                $sbsrd->academic_group_id = Session::get('ACADEMIC_GROUP_ID');
                $sbsrd->site_id = Session::get('SITE_ID');

                $sbsrd->academic_shift_ids = implode(',', $request->shift_ids);
                $sbsrd->academic_version_ids = implode(',', $request->academic_version_ids);
                $sbsrd->academic_year_ids = implode(',', $request->academic_year_ids);
                $sbsrd->academic_department_ids = $request->academic_department_ids ? implode(',', $request->academic_department_ids) : null;
                $sbsrd->academic_class_ids = $request->academic_class_ids ? implode(',', $request->academic_class_ids) : null;
                $sbsrd->academic_session_ids = $request->academic_session_ids ? implode(',', $request->academic_session_ids) : null;
                $sbsrd->academic_section_ids = $request->academic_section_ids ? implode(',', $request->academic_section_ids) : null;

                $sbsrd->terms_condition = $request->terms_condition;
                $sbsrd->terms_condition_show_top = $request->terms_condition_show_top;
                $sbsrd->terms_condition_show_bellow = $request->terms_condition_show_bellow;
                $sbsrd->last_name_show_status = $request->last_name_show_status;

                $sbsrd->save();


                return Response::json(['message' => 'Registration Declare Create Successfully!', 'mode' => 'Create!'], 200);
            }


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function updateSiteBaseStudentRegistrationDeclare(Request $request)
    {


        try {

            $sbsrd = SiteBaseStudentRegistrationDeclare::where('id', $request->site_base_student_registration_declare_id)
                ->first();

            $sbsrd->duration_from_date = $request->start_date;
            $sbsrd->duration_to_date = $request->end_date;
            $sbsrd->extended_date = $request->extended_date;
            $sbsrd->remark = $request->remark;
            $sbsrd->send_sms = $request->send_sms;
            $sbsrd->old_student_information_add = $request->old_student_information_add;


            $sbsrd->guardian_information_add = $request->guardian_information_add;
            $sbsrd->address_information_add = $request->address_information_add;
            $sbsrd->communication_information_add = $request->communication_information_add;
            $sbsrd->previous_institute_information_add = $request->previous_institute_information_add;
            $sbsrd->local_guardian_detail_information_add = $request->local_guardian_detail_information_add;
            $sbsrd->student_registration_number_box_show = $request->student_registration_number_box_show;

            $sbsrd->academic_shift_ids = implode(',', $request->shift_ids);
            $sbsrd->academic_version_ids = implode(',', $request->academic_version_ids);
            $sbsrd->academic_year_ids = implode(',', $request->academic_year_ids);
            $sbsrd->academic_department_ids = $request->academic_department_ids ? implode(',', $request->academic_department_ids) : null;
            $sbsrd->academic_class_ids = $request->academic_class_ids ? implode(',', $request->academic_class_ids) : null;
            $sbsrd->academic_session_ids = $request->academic_session_ids ? implode(',', $request->academic_session_ids) : null;
            $sbsrd->academic_section_ids = $request->academic_section_ids ? implode(',', $request->academic_section_ids) : null;
           
            $sbsrd->terms_condition = $request->terms_condition;
            $sbsrd->terms_condition_show_top = $request->terms_condition_show_top;
            $sbsrd->terms_condition_show_bellow = $request->terms_condition_show_bellow;
            $sbsrd->last_name_show_status = $request->last_name_show_status;
            $sbsrd->save();


            return Response::json(['message' => 'Declare Update Successfully!', 'mode' => 'Update!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function deleteSiteBaseStudentRegistrationDeclare(Request $request)
    {

        try {

            $sbsrd = SiteBaseStudentRegistrationDeclare::where('id', $request->site_base_student_registration_declare_id)
                ->first();

            $sbsrd->delete();


            return Response::json(['message' => 'Delete Successfully!', 'mode' => 'Delete!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function pauseSiteBaseStudentRegistrationDeclare(Request $request)
    {

        try {

            $sbsrd = SiteBaseStudentRegistrationDeclare::where('id', $request->site_base_student_registration_declare_id)
                ->first();

            $sbsrd->update([
                'status' => false
            ]);


            return Response::json(['message' => 'Pause Successfully!', 'mode' => 'Delete!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }


    }


    public function activateSiteBaseStudentRegistrationDeclare(Request $request)
    {
        try {


            $checkActivePresent = SiteBaseStudentRegistrationDeclare::where('status', true)
                ->first();

            if ($checkActivePresent) {

                return Response::json(['message' => 'There are already active declaretion present. You can not active this.!', 'mode' => 'Delete!'], 200);

            } else {
                $sbsrd = SiteBaseStudentRegistrationDeclare::where('id', $request->site_base_student_registration_declare_id)
                    ->first();

                $sbsrd->update([
                    'status' => true
                ]);


                return Response::json(['message' => 'Activate Successfully!', 'mode' => 'Delete!'], 200);

            }


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }
    }


}
