<?php

namespace App\Http\Controllers\SiteGroup\Attendence;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Event\Event;
use App\Models\Event\GlobalEvent;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Models\Site\EmployeeDuty\SiteEmployeeDutyHistory;
use Error;
use Exception;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\User\GlobalEmployeeHistory;
use App\Traits\SiteGroup\Leave\Employee\GlobalLeaveFunction;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Support\Facades\DB;
use PDF;

class SiteGroupEmployeeAttedenceController extends SiteGroupProjectController
{
    use GlobalLeaveFunction;

    private $employee, $GlobalEmployeeAttendance, $site;
    public function __construct(GlobalEmployeeAttendance $EmployeeAttendance, SiteInfo $site, GlobalEmployee $GlobalEmployee)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker', ['only' => []]);
        $this->GlobalEmployeeAttendance = $EmployeeAttendance;
        $this->employee = $GlobalEmployee;
        $this->site = $site;
    }
    public function index()
    {
        $viewType = "Site Group Attedence";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    // graph
    public function siteGroupCheckEmployeeAbsent($employee_id, $month, $currentYear, $site_id)
    {

        $off_day = GlobalEvent::whereYear('activate_date', $currentYear)
            ->WhereMonth('activate_date', $month)
            ->where('status', 1)
            ->where('attendance_active_for_employee', 0)
            ->where('site_id', $site_id)
            ->count();

        $TotalDayOfMonth = Carbon::createFromDate($currentYear, $month, 1)->daysInMonth;

        $employees = $this->employee
            ->select('id', 'username')
            ->with([
                'attendances' => function ($query) use ($month, $currentYear) {
                    $query->whereYear('present_date', $currentYear)
                        ->where(function ($q) use ($month) {
                            $q->orWhereMonth('present_date', $month);
                        });
                }
            ])
            ->where('id', $employee_id)
            ->where('status', true)
            ->first();

        $EmployeeAttendence = $employees->attendances->count();

        return ($TotalDayOfMonth - $off_day) - $EmployeeAttendence;
    }
    public function siteGroupEmployeeAttendenceMonthWiseForGraph(Request $request)
    {


        $today          = Carbon::today();
        $previousMonths = [];
        $site_id        = $request->site_id;

        for ($i = 1; $i <= 4; $i++) {
            $previousMonths[] = (clone $today)->subMonth($i)->format('m');
        }
        $previousMonthNames = [];
        foreach ($previousMonths as $month) {
            $date = Carbon::createFromFormat('m', $month);
            $previousMonthNames[] = $date->format('F');
        }


        $currentYear = Carbon::now()->year;

        if ($site_id) {
            $data = [];
            $presentCount = 0;
            $absentCount = 0;
            $sl = 0;
            foreach ($previousMonths as $month) {

                $date = Carbon::createFromFormat('m-Y', "$month-$currentYear")->format('m-Y');
                $GlobalEmployeeAttendance = $this->GlobalEmployeeAttendance
                    ->select(
                        'user_id',
                        DB::raw('MONTH(present_date) as month'),
                        DB::raw('COUNT(*) as attendance_count')
                    )
                    ->WhereMonth('present_date', $month)
                    ->whereYear('present_date', $currentYear)
                    ->groupBy('user_id', 'month')
                    ->where('site_id', $site_id)
                    ->get();

                foreach ($GlobalEmployeeAttendance as $EmployeeAttendance) {
                    $presentCount += $EmployeeAttendance->attendance_count;
                }


                $startDate = Carbon::createFromDate($currentYear, $month, 1);
                $endDate = $startDate->copy()->endOfMonth();

                $period = CarbonPeriod::create($startDate, $endDate);


                $employees = $this->employee
                    ->select('id', 'username')
                    ->where('status', true)
                    ->where('site_id', $site_id)
                    ->get();


                foreach ($period as $key => $dt) {

                    $TotalemployeesAbsent = $this->employee
                        ->select('id', 'username')
                        ->where('status', true)
                        ->where(function ($q) use ($dt) {
                            $q->whereDoesntHave('attendances', function ($q1) use ($dt) {
                                $q1->whereDate('present_date', '=', $dt);
                            });
                        })
                        ->where('site_id', $site_id)
                        ->count();

                    $absentCount += $TotalemployeesAbsent;
                }



                $leave_days = $this->getTotalLeaveByMonth($date, $employees);
                $Total_present = $presentCount + $leave_days;

                $data[$sl]['label'] = $month;
                $data[$sl]['values']  = [
                    ['value' => $Total_present, 'color' => '#ffaa00', 'status' => 'present'],
                    ['value' => $absentCount, 'color'   => '#00aaff', 'status' => 'Absent'],
                    ['value' => $leave_days, 'color'    => '#00ff00', 'status' => 'leave'],
                ];
                $sl++;
                $absentCount = 0;
            }
            return response()->json([
                'data' => $data,
                'previousMonthNames' => $previousMonthNames
            ], 200);
        } else {
        }
    }
    public function siteGroupEmployeeAttendenceForGraph(Request $request)
    {


        $date             = $request->input('date');
        $site_id          = $request->site_id;
        $search_txt       = $request->search_txt;
        $txt              = '%' . $search_txt . '%';


        if (!$date) {
            throw new Error('Please Select Date');
        }

        $groupWiseSiteEmployeeAttendence = [];
        $key  = 0;

        if ($site_id) {


            $site = GlobalSiteInfo::select('id')
                ->where('id', $site_id)
                ->first();

            $off_day = GlobalEvent::where('activate_date', $date)
                ->where('status', 1)
                ->where('attendance_active_for_employee', 0)
                ->where('site_id', $site_id)
                ->count();


            $employees = $this->employee
                ->select('id', 'username')
                ->with([
                    'attendances' => function ($query) use ($date) {
                        $query->select(
                            'user_id',
                            'present_date'
                        )
                            ->where('present_date', $date);
                    }
                ])

                ->where('site_id', $site->id)
                ->where('status', true)
                ->get();

            $TotalAttendances = 0;
            $TotalLeave       = 0;
            foreach ($employees as  $employee) {

                $EmployeeLeave = $this->getEmployeeInLeave($employee->id, $date);

                if ($EmployeeLeave) {
                    $TotalLeave += 1;
                }

                if ($employee->attendances->isNotEmpty()) {
                    $TotalAttendances += 1;
                }
            }

            $TotalEmplployee = $employees->count();

            $groupWiseSiteEmployeeAttendence[$key]['site_id']           = $site->id;
            $groupWiseSiteEmployeeAttendence[$key]['site_name']         = $site->site_name;
            $groupWiseSiteEmployeeAttendence[$key]['TotalEmplployee']   = $TotalEmplployee;
            $groupWiseSiteEmployeeAttendence[$key]['Total_present']     = $TotalAttendances;
            $groupWiseSiteEmployeeAttendence[$key]['Total_leave']       = $TotalLeave;
            $groupWiseSiteEmployeeAttendence[$key]['Total_absent']      = $TotalEmplployee - ($TotalAttendances + $TotalLeave);
            $groupWiseSiteEmployeeAttendence[$key]['off_day']           = $off_day == 1 ? true : false;


            $totalPresent = 0;
            $totalLeave = 0;
            $totalAbsent = 0;
            $totalEmployee = 0;

            foreach ($groupWiseSiteEmployeeAttendence as $site) {
                $totalEmployee += $site['TotalEmplployee'];
                $totalPresent += $site['Total_present'];
                $totalLeave += $site['Total_leave'];
                $totalAbsent += $site['Total_absent'];
            }

            if ($totalAbsent === 0 && $totalLeave === 0 && $totalPresent === 0) {
                $FinalgroupWiseSiteEmployeeAttendence = []; // or handle this case as needed
            } else {
                $FinalgroupWiseSiteEmployeeAttendence = [$totalAbsent, $totalLeave, $totalPresent];
            }

            $FinalgroupWiseSiteEmployeeAttendence = [$totalAbsent, $totalLeave, $totalPresent];
        } else {

            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })

                ->orderBy('id', 'DESC')
                ->get();




            foreach ($GroupWiseSites as  $site) {

                $off_day = GlobalEvent::where('activate_date', $date)
                    ->where('status', 1)
                    ->where('attendance_active_for_employee', 0)
                    ->where('site_id', $site->id)
                    ->count();

                $employees = $this->employee
                    ->select('id', 'username')
                    ->with([
                        'attendances' => function ($query) use ($date) {
                            $query->select(
                                'user_id',
                                'present_date'
                            )
                                ->where('present_date', $date);
                        }
                    ])
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();

                $TotalAttendances  = 0;
                $TotalLeave        = 0;

                foreach ($employees as  $employee) {
                    $EmployeeLeave = $this->getEmployeeInLeave($employee->id, $date);

                    if ($EmployeeLeave != null) {
                        $TotalLeave += 1;
                    }
                    if ($employee->attendances->isNotEmpty()) {
                        $TotalAttendances += 1;
                    }
                }
                $TotalEmplployee = $employees->count();

                $groupWiseSiteEmployeeAttendence[$key]['site_id']         = $site->id;
                $groupWiseSiteEmployeeAttendence[$key]['site_name']       = $site->site_name;
                $groupWiseSiteEmployeeAttendence[$key]['TotalEmplployee'] = $TotalEmplployee;
                $groupWiseSiteEmployeeAttendence[$key]['Total_present']   = $TotalAttendances;
                $groupWiseSiteEmployeeAttendence[$key]['Total_leave']     = $TotalLeave;
                $groupWiseSiteEmployeeAttendence[$key]['Total_absent']    = $TotalEmplployee - ($TotalAttendances + $TotalLeave);
                $groupWiseSiteEmployeeAttendence[$key]['off_day']         = $off_day == 1 ? true : false;
                $key++;

                $totalPresent = 0;
                $totalLeave = 0;
                $totalAbsent = 0;
                $totalEmployee = 0;

                foreach ($groupWiseSiteEmployeeAttendence as $site) {
                    $totalEmployee += $site['TotalEmplployee'];
                    $totalPresent += $site['Total_present'];
                    $totalLeave += $site['Total_leave'];
                    $totalAbsent += $site['Total_absent'];
                }
            }

            $FinalgroupWiseSiteEmployeeAttendence = [$totalAbsent, $totalLeave, $totalPresent];
        }
        return $FinalgroupWiseSiteEmployeeAttendence;
    }
    public function getEmployeeInDuty($employee_id, $date)
    {
        $employee_history = GlobalEmployeeHistory::where('user_id', $employee_id)
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->first();

        if ($employee_history === null) {
            return false; // No employee history found
        }


        $duty_history = SiteEmployeeDutyHistory::where('employee_history_id', $employee_history->id)
            ->where('status', 1)
            //->where('leave_status', 'approved')
            ->get();

        if ($duty_history->isEmpty()) {
            return false; // No leave history found
        }



        if (count($duty_history)) {
            foreach ($duty_history as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $date) {
                    $dd = $date->format('Y-m-d');
                    if ($dd == $date) {

                        return true;
                    }
                }
            }
            return false;
        }
    }
    public function siteGroupEmployeeAttendence(Request $request)
    {

        $date             = $request->input('date');
        $date_range_array = $request->input('date_range');
        $site_id          = $request->site_id;
        $search_txt       = $request->search_txt;
        $txt              = '%' . $search_txt . '%';


        if (!$date) {
            throw new Error('Please Select Date');
        }

        $groupWiseSiteEmployeeAttendence = [];
        $key  = 0;

        $TotalCount                          = [];
        $TotalCount['total_Grpup_site']      = 0;
        $TotalCount['total_Group_employees'] = 0;
        $TotalCount['Total_present']          = 0;
        $TotalCount['total_absent']          = 0;
        $TotalCount['total_leave']           = 0;
        $TotalCount['total_duty']            = 0;

        if ($site_id) {


            $site = GlobalSiteInfo::select('id')
                ->where('id', $site_id)
                ->first();

            $off_day = GlobalEvent::where('activate_date', $date)
                ->where('status', 1)
                ->where('attendance_active_for_employee', 0)
                ->where('site_id', $site_id)
                ->count();


            $employees = $this->employee
                ->select('id', 'username')
                ->with([
                    'attendances' => function ($query) use ($date) {
                        $query->select(
                            'user_id',
                            'present_date'
                        )
                            ->where('present_date', $date);
                    }
                ])

                ->where('site_id', $site->id)
                ->where('status', true)
                ->get();

            $TotalAttendances = 0;
            $TotalLeave       = 0;
            $TotalDuty        = 0;
            foreach ($employees as  $employee) {

                $EmployeeLeave = $this->getEmployeeInLeave($employee->id, $date);
                $EmployeeDuty = $this->getEmployeeInDuty($employee->id, $date);


                if ($EmployeeDuty) {
                    $TotalDuty += 1;
                }
                if ($EmployeeLeave) {
                    $TotalLeave += 1;
                }

                if ($employee->attendances->isNotEmpty()) {
                    $TotalAttendances += 1;
                }
            }

            $TotalEmplployee = $employees->count();
            $TotalAbsent = $TotalEmplployee - ($TotalAttendances + $TotalLeave);

            $groupWiseSiteEmployeeAttendence[$key]['site_id']           = $site->id;
            $groupWiseSiteEmployeeAttendence[$key]['site_name']         = $site->site_name;
            $groupWiseSiteEmployeeAttendence[$key]['TotalEmplployee']   = $TotalEmplployee;
            $groupWiseSiteEmployeeAttendence[$key]['Total_present']     = $TotalAttendances;
            $groupWiseSiteEmployeeAttendence[$key]['Total_leave']       = $TotalLeave;
            $groupWiseSiteEmployeeAttendence[$key]['Total_duty']        = $TotalDuty;
            $groupWiseSiteEmployeeAttendence[$key]['Total_absent']      = $TotalAbsent;
            $groupWiseSiteEmployeeAttendence[$key]['off_day']           = $off_day == 1 ? true : false;

            $TotalCount['total_Grpup_site']++;
            $TotalCount['total_Group_employees'] += $TotalEmplployee;
            $TotalCount['Total_present']         += $TotalAttendances;
            $TotalCount['total_absent']          += $TotalAbsent;
            $TotalCount['total_leave']           += $TotalLeave;
            $TotalCount['total_duty']            += $TotalDuty;
        } else {

            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })

                ->orderBy('id', 'DESC')
                ->get();




            foreach ($GroupWiseSites as  $site) {

                $off_day = GlobalEvent::where('activate_date', $date)
                    ->where('status', 1)
                    ->where('attendance_active_for_employee', 0)
                    ->where('site_id', $site->id)
                    ->count();

                $employees = $this->employee
                    ->select('id', 'username')
                    ->with([
                        'attendances' => function ($query) use ($date) {
                            $query->select(
                                'user_id',
                                'present_date'
                            )
                                ->where('present_date', $date);
                        }
                    ])
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();

                $TotalAttendances = 0;
                $TotalLeave       = 0;
                $TotalDuty        = 0;

                foreach ($employees as  $employee) {
                    $EmployeeLeave = $this->getEmployeeInLeave($employee->id, $date);
                    $EmployeeDuty = $this->getEmployeeInDuty($employee->id, $date);


                    if ($EmployeeDuty) {
                        $TotalDuty += 1;
                    }

                    if ($EmployeeLeave != null) {
                        $TotalLeave += 1;
                    }
                    if ($employee->attendances->isNotEmpty()) {
                        $TotalAttendances += 1;
                    }
                }
                $TotalEmplployee = $employees->count();
                $TotalAbsent     = $TotalEmplployee - ($TotalAttendances + $TotalLeave);

                $groupWiseSiteEmployeeAttendence[$key]['site_id']         = $site->id;
                $groupWiseSiteEmployeeAttendence[$key]['site_name']       = $site->site_name;
                $groupWiseSiteEmployeeAttendence[$key]['TotalEmplployee'] = $TotalEmplployee;
                $groupWiseSiteEmployeeAttendence[$key]['Total_present']   = $TotalAttendances;
                $groupWiseSiteEmployeeAttendence[$key]['Total_leave']     = $TotalLeave;
                $groupWiseSiteEmployeeAttendence[$key]['Total_duty']      = $TotalDuty;
                $groupWiseSiteEmployeeAttendence[$key]['Total_absent']    = $TotalAbsent;
                $groupWiseSiteEmployeeAttendence[$key]['off_day']         = $off_day == 1 ? true : false;
                $key++;

                $TotalCount['total_Grpup_site']++;
                $TotalCount['total_Group_employees'] += $TotalEmplployee;
                $TotalCount['Total_present']         += $TotalAttendances;
                $TotalCount['total_absent']          += $TotalAbsent;
                $TotalCount['total_leave']           += $TotalLeave;
                $TotalCount['total_duty']            += $TotalDuty;
            }
        }

        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.attendence.site-employees-group-attendence-pdf',
            compact(
                'groupWiseSiteEmployeeAttendence',
                'SiteGroupInfo',
                'TotalCount',
            )
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);



        return response()->json([
            'groupWiseSiteEmployeeAttendence' => $groupWiseSiteEmployeeAttendence,
            'TotalCount'                      => $TotalCount,
            'link' => $route_name,
        ], 200);
    }


    public function SinglesiteGroupEmployeeAttendencePdfDonwload(Request $request)
    {


        $date       = $request->input('date');
        $paginate   = $request->paginate ?? 20;
        $site_id    = $request->site_id;
        $search_txt = $request->search_txt;
        $txt        = '%' . $search_txt . '%';

        if ($site_id) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $site_id)
                ->first();

            $off_day = GlobalEvent::where('activate_date', $date)
                ->where('status', 1)
                ->where('attendance_active_for_employee', 0)
                ->where('site_id', $site_id)
                ->count();

            $SingleSiteEmployeeAttendance = $this->employee
                ->select('id', 'username', 'contact_number', 'designation_id')
                ->with(['designation'])
                ->with([
                    'attendances' => function ($query) use ($date) {
                        $query->select(
                            'user_id',
                            'present_date',
                            'out_time',
                            'in_time'
                        )
                            ->where('present_date', $date);
                    }
                ])
                ->where('site_id', $site->id)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })
                ->orderBy('employee_serial', 'ASC')
                ->where('status', true)
                ->get();

            $SingleSiteEmployeeAttendance->transform(function ($employee) use ($date) {

                $EmployeeLeave = $this->getEmployeeInLeave($employee->id, $date);
                $EmployeeDuty = $this->getEmployeeInDuty($employee->id, $date);

                if ($EmployeeLeave) {
                    $employee->attendence_status = "Leave";
                    $employee->bg_color          = "#559BCE";
                } elseif ($EmployeeDuty) {
                    $employee->attendence_status = "Duty";
                    $employee->bg_color          = "#7dacff";
                } elseif ($employee->attendances->isNotEmpty()) {
                    $employee->attendence_status = "Present";
                    $employee->bg_color          = "#468847";
                } else {
                    $employee->attendence_status = "Absent";
                    $employee->bg_color          = "#f71717";
                }

                $employee->out_time = $employee->attendances->isNotEmpty() ? $employee->attendances[0]->out_time  : '--';
                $employee->in_time  = $employee->attendances->isNotEmpty() ? $employee->attendances[0]->in_time : '--';
                $employee->designation_name  = $employee->designation ? $employee->designation->name : '--';

                return $employee;
            });
            $Single_site_off_day = $off_day == 1 ? true : false;
            $dateformat = Carbon::parse($date)->format('d M Y');
            $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
            $pdf = PDF::loadView(
                'default.admin.site_group.attendence.single-site-employees-attendence-wise-pdf',
                compact(
                    'SingleSiteEmployeeAttendance',
                    'SiteGroupInfo',
                    'Single_site_off_day',
                    'site',
                    'dateformat',

                )
            )
                ->setPaper('a4', 'landscape')
                ->setWarnings(false);


            $path = storage_path() . '/pdf';
            $time = \Auth::user()->id . '-' . Carbon::now()->unix();
            $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
            $name = $time . '.pdf';
            $route_name = route('open-pdf-file-storage-for-group', [$name]);

            return response()->json([
                'link' => $route_name,
            ], 200);
        }
    }
    public function SinglesiteGroupEmployeeAttendence(Request $request)
    {
        $date       = $request->input('date');
        $paginate   = $request->paginate ?? 20;
        $site_id    = $request->site_id;
        $search_txt = $request->search_txt;
        $txt        = '%' . $search_txt . '%';

        if ($site_id) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $site_id)
                ->first();

            $off_day = GlobalEvent::where('activate_date', $date)
                ->where('status', 1)
                ->where('attendance_active_for_employee', 0)
                ->where('site_id', $site_id)
                ->count();

            $SingleSiteEmployeeAttendance = $this->employee
                ->select('id', 'username', 'contact_number', 'designation_id')
                ->with(['designation'])
                ->with([
                    'attendances' => function ($query) use ($date) {
                        $query->select(
                            'user_id',
                            'present_date',
                            'out_time',
                            'in_time'
                        )
                            ->where('present_date', $date);
                    }
                ])
                ->where('site_id', $site->id)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })
                ->orderBy('employee_serial', 'ASC')
                ->where('status', true)
                ->paginate($paginate);

            $SingleSiteEmployeeAttendance->getCollection()->transform(function ($employee) use ($date) {

                $EmployeeLeave = $this->getEmployeeInLeave($employee->id, $date);
                $EmployeeDuty = $this->getEmployeeInDuty($employee->id, $date);

                if ($EmployeeLeave) {
                    $employee->attendence_status = "Leave";
                    $employee->bg_color          = "#559BCE";
                } elseif ($EmployeeDuty) {
                    $employee->attendence_status = "Duty";
                    $employee->bg_color          = "#7dacff";
                } elseif ($employee->attendances->isNotEmpty()) {
                    $employee->attendence_status = "Present";
                    $employee->bg_color          = "#468847";
                } else {
                    $employee->attendence_status = "Absent";
                    $employee->bg_color          = "#f71717";
                }

                $employee->out_time = $employee->attendances->isNotEmpty() ? $employee->attendances[0]->out_time  : '--';
                $employee->in_time  = $employee->attendances->isNotEmpty() ? $employee->attendances[0]->in_time : '--';
                $employee->designation_name  = $employee->designation ? $employee->designation->name : '--';


                return $employee;
            });
        }

        return response()->json([
            'SingleSiteEmployeeAttendance' => $SingleSiteEmployeeAttendance,
            'site_name'                    => $site->site_name,
            'off_day'                      => $off_day == 1 ? true : false,
        ], 200);
    }
}
