<?php

namespace App\Http\Controllers\SiteGroup\Attendence;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Event\GlobalEvent;
use Error;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\GlobalSiteGroup;
use Carbon\Carbon;
use PDF;
use Illuminate\Support\Facades\DB;

class SiteGroupStudentAttedenceController extends SiteGroupProjectController
{
    public $GlobalEmployeeAttendance;
    public $StudentAttendance;
    private $site , $GlobalStudentHistory;
    public function __construct(GlobalStudentAttendance $StudentAttendance,  SiteInfo $site, GlobalStudentHistory $GlobalStudentHistory)
    {

        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->StudentAttendance = $StudentAttendance;
        $this->site = $site;
        $this->GlobalStudentHistory = $GlobalStudentHistory;
    }
    public function index()
    {
        $viewType = "Site Group Attedence";
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function siteGroupStudentAttendence(Request $request)
    {
        // return 'jahin';
        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $date = $request->input('date');

        if (!$date) {
            throw new Error('Please Select Date');
        }

        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id          ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id           ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id        ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id          ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id        ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id        ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id            ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_class_group_id']              = $request->academic_class_group_id  ? $request->academic_class_group_id : null;
        $data['site_id']                              = $request->site_id  ? $request->site_id : null;



        $s_List = [];
        $key = 0;

        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();

            $student_lists_for_single_site = $this->GlobalStudentHistory
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id',)
                ->with('student:id')

                ->with([
                    'attendances' => function ($q) use ($date) {
                        $q->whereDate('present_date', '=', $date);
                    },
                    'absents' => function ($q) use ($date) {
                        $q->whereDate('absent_date', '=', $date);
                    },
                    'leaveDetails' => function ($q) use ($date) {
                        $q->whereDate('leave_date', '=', $date);
                    },
                ])

                ->orderBy('student_roll_number')
                ->where('status', true)
                ->where('site_id', $data['site_id'])
                ->get();

            $TotalAttendancesCountOfStudents = 0;
            $TotalAbsentsCountOfStudents     = 0;
            $TotalLeaveCountOfStudents       = 0;
            $TotalStudent  = $student_lists_for_single_site->count();

            foreach ($student_lists_for_single_site as  $student) {
                $TotalAttendancesCountOfStudents += $student->attendances->count();
                $TotalAbsentsCountOfStudents     += $student->absents->count();
                $TotalLeaveCountOfStudents       += $student->leaveDetails->count();
            }

            $s_List[$key]['id']               = $site->id;
            $s_List[$key]['site_name']        = $site->site_name;
            $s_List[$key]['total_present']    = $TotalAttendancesCountOfStudents;
            $s_List[$key]['total_students']   = $TotalStudent;
            $s_List[$key]['total_absent']     = $TotalStudent - $TotalAttendancesCountOfStudents;
            $s_List[$key]['total_leave']      = $TotalLeaveCountOfStudents;
        }
        else {


            $siteList = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->get();

            foreach ($siteList as  $item) {

                $student_lists = $this->GlobalStudentHistory
                    ->select('id', 'user_id')
                    ->with('student:id')
                    ->with([
                        'attendances' => function ($q) use ($date) {
                            $q->whereDate('present_date', '=', $date);
                        },
                        'absents' => function ($q) use ($date) {
                            $q->whereDate('absent_date', '=', $date);
                        },
                        'leaveDetails' => function ($q) use ($date) {
                            $q->whereDate('leave_date', '=', $date);
                        },
                    ])
                    ->when($data['academic_year_id'], function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when($data['academic_class_id'], function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when($data['academic_version_id'], function ($query) use ($data) {
                        return $query->where('academic_version_id', $data['academic_version_id']);
                    })
                    ->when($data['academic_shift_id'], function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_category_id'], function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when($data['academic_student_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->where('academic_group_id', $data['academic_group_id'])
                    ->where('site_id', $item->id)
                    ->where('status', true)
                    ->get();


                $TotalAttendancesCountOfStudents = 0;
                $TotalAbsentsCountOfStudents     = 0;
                $TotalLeaveCountOfStudents       = 0;
                $TotalStudent  = $student_lists->count();

                foreach ($student_lists as  $student) {
                    $TotalAttendancesCountOfStudents += $student->attendances->count();
                    $TotalAbsentsCountOfStudents     += $student->absents->count();
                    $TotalLeaveCountOfStudents       += $student->leaveDetails->count();
                }

                $s_List[$key]['id']               = $item->id;
                $s_List[$key]['site_name']        = $item->site_name;
                $s_List[$key]['total_present']    = $TotalAttendancesCountOfStudents;
                $s_List[$key]['total_students']   = $TotalStudent;
                $s_List[$key]['total_absent']     = $TotalStudent - $TotalAttendancesCountOfStudents;
                $s_List[$key]['total_leave']      = $TotalLeaveCountOfStudents;
                $key++;
            }
        }
        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        // $pdf = PDF::loadView(
        //     'default.admin.site_group.attendence.site-student-group-attendence-pdf',
        //     compact(
        //         's_List',
        //         'SiteGroupInfo',
        //     )
        // )
        //     ->setPaper('a4', 'landscape')
        //     ->setWarnings(false);

        // $path = storage_path() . '/pdf';
        // $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        // $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        // $name = $time . '.pdf';
        // $route_name = route('open-pdf-file-storage-for-group', [$name]);
        return response()->json([$s_List]);
    }
    public function siteGroupSingleSiteAttendencePdfDownload(Request $request)
    {
        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $date = $request->input('date');

        if (!$date) {
            throw new Error('Please Select Date');
        }

        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id  ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id  ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id  ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id  ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id  ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id  ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id  ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['site_id']                              = $request->site_id  ? $request->site_id : null;

        $site = GlobalSiteInfo::select('id')
            ->where('id', $data['site_id'])
            ->first();

            $off_day = GlobalEvent::where('activate_date', $date)
            ->where('status', 1)
            ->where('attendance_active_for_employee', 0)
            ->where('site_id', $data['site_id'])
            ->count();


        if ($data['site_id']) {



            $student_lists = $this->GlobalStudentHistory
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id',)
                ->with('student:id')
                ->with([
                    'attendances' => function ($q) use ($date) {
                        $q->whereDate('present_date', '=', $date);
                    },
                    'absents' => function ($q) use ($date) {
                        $q->whereDate('absent_date', '=', $date);
                    },
                    'leaveDetails' => function ($q) use ($date) {
                        $q->whereDate('leave_date', '=', $date);
                    },
                ])
                ->where('status', true)
                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->get();


          $student_lists->transform(function ($student) {

                if ($student->leaveDetails->isNotEmpty()) {
                    $student->attendence_status = "Leave";
                    $student->bg_color          = "#559BCE";
                }  elseif ($student->attendances->isNotEmpty()) {
                    $student->attendence_status = "Present";
                    $student->bg_color          = "#468847";
                }elseif($student->attendances->isEmpty()) {
                    $student->attendence_status = "Absent";
                    $student->bg_color          = "#f71717";
                }

                $student->out_time = $student->attendances->isNotEmpty() ? $student->attendances[0]->out_time  : '--';
                $student->in_time  = $student->attendances->isNotEmpty() ? $student->attendances[0]->in_time : '--';

                return $student;
            });


            $Single_site_off_day = $off_day == 1 ? true : false;
            $dateformat = Carbon::parse($date)->format('d M Y');
           $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
           $pdf = PDF::loadView(
               'default.admin.site_group.attendence.single-site-student-attendence-wise-pdf',
               compact(
                   'student_lists',
                   'SiteGroupInfo',
                   'Single_site_off_day',
                   'site',
                   'dateformat',
               )
           )
               ->setPaper('a4', 'landscape')
               ->setWarnings(false);


           $path = storage_path() . '/pdf';
           $time = \Auth::user()->id . '-' . Carbon::now()->unix();
           $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
           $name = $time . '.pdf';
           $route_name = route('open-pdf-file-storage-for-group', [$name]);

           return response()->json([
               'link' => $route_name,
           ], 200);


        }
    }
    public function siteGroupSingleSiteAttendence(Request $request)
    {
        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $date = $request->input('date');

        if (!$date) {
            throw new Error('Please Select Date');
        }

        $data = [];

        $data['academic_class_id']                   =  $request->academic_class_id  ? $request->academic_class_id : null;
        $data['academic_year_id']                    =  $request->academic_year_id  ? $request->academic_year_id : null;
        $data['academic_group_id']                   =  session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                 =  $request->academic_version_id  ? $request->academic_version_id : null;
        $data['academic_shift_id']                   =  $request->academic_shift_id  ? $request->academic_shift_id : null;
        $data['academic_session_id']                 =  $request->academic_session_id  ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']  =  $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']        =  $request->academic_student_category_id  ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']            =  $request->academic_student_type_id  ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']  =  $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['site_id']                             =  $request->site_id  ? $request->site_id : null;




        $site = GlobalSiteInfo::select('id')
            ->where('id', $data['site_id'])
            ->first();

            $off_day = GlobalEvent::where('activate_date', $date)
            ->where('status', 1)
            ->where('attendance_active_for_employee', 0)
            ->where('site_id', $data['site_id'])
            ->count();


        if ($data['site_id']) {



            $student_lists = $this->GlobalStudentHistory
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id',)
                ->with('student:id')
                ->with([
                    'attendances' => function ($q) use ($date) {
                        $q->whereDate('present_date', '=', $date);
                    },
                    'absents' => function ($q) use ($date) {
                        $q->whereDate('absent_date', '=', $date);
                    },
                    'leaveDetails' => function ($q) use ($date) {
                        $q->whereDate('leave_date', '=', $date);
                    },
                ])
                ->where('status', true)
                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->paginate($paginate);

            $attendances  = [];
            $absents      = [];
            $leaveDetails = [];
          $student_lists->getCollection()->transform(function ($student) {

                if ($student->leaveDetails->isNotEmpty()) {
                    $student->attendence_status = "Leave";
                    $student->bg_color          = "#559BCE";
                }  elseif ($student->attendances->isNotEmpty()) {
                    $student->attendence_status = "Present";
                    $student->bg_color          = "#468847";
                }elseif($student->attendances->isEmpty()) {
                    $student->attendence_status = "Absent";
                    $student->bg_color          = "#f71717";
                }

                $student->out_time = $student->attendances->isNotEmpty() ? $student->attendances[0]->out_time  : '--';
                $student->in_time  = $student->attendances->isNotEmpty() ? $student->attendances[0]->in_time : '--';

                return $student;
            });


            return response()->json([
                'student_lists' => $student_lists,
                'site_name'                    => $site->site_name,
                'off_day'                      => $off_day == 1 ? true : false,
            ], 200);


        }
    }
}
