<?php

namespace App\Http\Controllers\SiteGroup\Employee;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Employee\GlobalSiteEmployeeDepartmentClassSubject;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\EmployeeTransfer\EmployeeTransferHistory;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\User\GlobalEmployeeHistory;
use App\Models\User\User;
use App\Traits\Site\UserPermission\UserAccessTrait;
use Error;
use Exception;
use Response;
use Session;
use PDF;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class SiteGroupEmployeeListController extends SiteGroupProjectController
{
    use  UserAccessTrait;

    private $GlobalEmployee;
    private $employee;

    public function __construct(GlobalEmployeeHistory $GlobalEmployee, GlobalEmployee $employee)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->GlobalEmployee = $GlobalEmployee;
        $this->employee = $employee;
    }
    public function index()
    {
        $viewType = "Site Group employee List";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function openReport($name)
    {
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $name);

            // if ($name_split[0] != $user_id) {
            //     return 'You are unauthorized!';
            // }


            if (!file_exists(storage_path('pdf/' . $name))) {

                return "The file existed only for 1 day and deleted today!";
            }


            return response()->file(storage_path('pdf/' . $name));
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }
    public function siteGroupWiseEmployeeAssignDutyListPdfDownload(Request $request)
    {
        $groupWiseSiteAllEmployeesAssignDutyList = $request->groupWiseSiteAllEmployeesAssignDutyList;
        if (!$request->groupWiseSiteAllEmployeesAssignDutyList) {
            throw new Error('Data not found!');
        }
        if (is_string($groupWiseSiteAllEmployeesAssignDutyList)) {
            $groupWiseSiteAllEmployeesAssignDutyList = json_decode($groupWiseSiteAllEmployeesAssignDutyList, true);
        } else {
            $groupWiseSiteAllEmployeesAssignDutyList = array_map(function ($item) {
                $decoded = json_decode($item, true);
                return $decoded !== null ? $decoded : [];
            }, $groupWiseSiteAllEmployeesAssignDutyList);
        }



        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.asssin_duty.site-employees-assign-duty-pdf',
            compact(
                'groupWiseSiteAllEmployeesAssignDutyList',
                'SiteGroupInfo',
            )
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);

        return response()->json([
            'link' => $route_name,
        ], 200);
    }
    public function siteGroupWiseEmployeeSubjectListPdfDownload(Request $request)
    {
        // return 'jahin ami';
        $groupWiseSiteEmployeeSubjectsCount =   json_decode($request->groupWiseSiteEmployeeSubjectsCount, true);
        $groupWiseSiteAllEmployeesSubjectList = $request->groupWiseSiteAllEmployeesSubjectList;
        if (!$groupWiseSiteAllEmployeesSubjectList) {
            throw new Error('Data not found!');
        }
        if (is_string($groupWiseSiteAllEmployeesSubjectList)) {
            $groupWiseSiteAllEmployeesSubjectList = json_decode($groupWiseSiteAllEmployeesSubjectList, true);
        } else {
            $groupWiseSiteAllEmployeesSubjectList = array_map(function ($item) {
                $decoded = json_decode($item, true);
                return $decoded !== null ? $decoded : [];
            }, $groupWiseSiteAllEmployeesSubjectList);
        }


        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.site-employees-subject-wise-pdf',
            compact(
                'groupWiseSiteEmployeeSubjectsCount',
                'groupWiseSiteAllEmployeesSubjectList',
                'SiteGroupInfo',
            )
        )
            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);

        return response()->json([
            'link' => $route_name,
        ], 200);
    }

    public function siteGroupWiseEmployeeAssignDutyListCount(Request $request)
    {



        $data = [];
        $data['site_id'] = $request->site_id ?? null;
        $data['search_txt'] = $request->search_txt ?? null;
        $data['paginate'] = $request->paginate ?? null;
        $data['txt'] = '%' . $data['search_txt'] . '%' ?? null;

        $groupWiseSiteEmployeeSubjects = [];
        $groupWiseSiteEmployeeSubjectsCount = [];
        $groupWiseSiteEmployeeSubjectsCount['EmployeeHasSubject'] = 0;
        $groupWiseSiteEmployeeSubjectsCount['total_Grpup_site']   = 0;
        $key  = 0;
        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();


            return  $GlobalEmployees = $this->GlobalEmployee::with('SiteEmployeeAssignDutyHistory')->whereHas('SiteEmployeeAssignDutyHistory')
                ->where('site_id', $data['site_id'])
                ->where('status', true)
                ->get();

            foreach ($GlobalEmployees as $inedx => $employee) {
                $groupWiseSiteEmployeeSubjects[$key][$inedx]['site_id']             = $site->id;
                $groupWiseSiteEmployeeSubjects[$key][$inedx]['site_name']           = $site->site_name;
                $groupWiseSiteEmployeeSubjects[$key][$inedx]['full_name']           = $employee->full_name;
                $groupWiseSiteEmployeeSubjects[$key][$inedx]['assign_subject_name'] = $employee->assign_subject_name ?? null;
                $groupWiseSiteEmployeeSubjects[$key][$inedx]['designation_name']    = $employee->designation_name ?? null;
                $groupWiseSiteEmployeeSubjects[$key][$inedx]['assign_duty']         = $employee->SiteEmployeeAssignDutyHistory->map(function ($history) {
                    $SiteInfo = SiteInfo::where('id', $history->assign_site_id)->first();
                    return [
                        'start_time' => $history->start_time ?? null,
                        'end_time' => $history->end_time ?? null,
                        'selected_week' => Carbon::now()->startOfWeek(Carbon::SUNDAY)->addDays($history->selected_week  - 1)->format('l') ?? null,
                        'assign_site_name' => $SiteInfo->site_name,
                    ];
                });
            }
        } else {

            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($data['search_txt'], function ($q) use ($data) {
                    return $q->where(function ($query) use ($data) {
                        $query->orWhere('site_alias', 'LIKE', $data['txt']);
                        $query->orWhereTranslationLike('site_name', $data['txt']);
                    });
                })
                ->orderBy('id', 'ASC')
                ->get();

            foreach ($GroupWiseSites as  $site) {

                $GlobalEmployees = $this->GlobalEmployee::with('SiteEmployeeAssignDutyHistory')->whereHas('SiteEmployeeAssignDutyHistory')
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();


                foreach ($GlobalEmployees as  $inedx => $employee) {
                    $groupWiseSiteEmployeeSubjects[$key][$inedx]['site_id']             = $site->id;
                    $groupWiseSiteEmployeeSubjects[$key][$inedx]['site_name']           = $site->site_name;
                    $groupWiseSiteEmployeeSubjects[$key][$inedx]['full_name']           = $employee->full_name;
                    $groupWiseSiteEmployeeSubjects[$key][$inedx]['assign_subject_name'] = $employee->assign_subject_name ?? null;
                    $groupWiseSiteEmployeeSubjects[$key][$inedx]['designation_name']    = $employee->designation_name ?? null;
                    $groupWiseSiteEmployeeSubjects[$key][$inedx]['assign_duty']         = $employee->SiteEmployeeAssignDutyHistory->map(function ($history) {
                        $SiteInfo = SiteInfo::where('id', $history->assign_site_id)->first();
                        return [
                            'start_time' => $history->start_time ?? null,
                            'end_time' => $history->end_time ?? null,
                            'selected_week' => Carbon::now()->startOfWeek(Carbon::SUNDAY)->addDays($history->selected_week  - 1)->format('l') ?? null,
                            'assign_site_name' => $SiteInfo->site_name,
                        ];
                    });
                }

                $key++;
            }
        }
        return response()->json([
            'groupWiseSiteEmployeeSubjects'      => $groupWiseSiteEmployeeSubjects,
            'groupWiseSiteEmployeeSubjectsCount' => $groupWiseSiteEmployeeSubjectsCount,
        ], 200);
    }
    public function siteGroupWiseEmployeeListCount(Request $request)
    {

    //     $employees = $this->employee
    //         ->select('id', 'username', 'religion_id', 'gender_id','designation_id','site_id')
    //         ->with(['latestPhoto', 'gender', 'religion', 'designation','site'])
    //         ->where('status', true)
    //         ->whereIn('site_id',$this->siteIds())
    //         ->whereIn('designation_id',[53,25])
    //         ->orderBy('site_id', 'ASC')
    //         ->orderBy('designation_id', 'DESC')
    //         ->get();

    //     $emp_array=[];
    //     foreach ($employees as  $key=>$employee) {

    //         $emp_array[$key]['id']               = $employee->id;
    //         $emp_array[$key]['designation_id']         = $employee->designation_id;
    //         $emp_array[$key]['full_name']        = $employee->full_name;
    //         $emp_array[$key]['site_name']        = $employee->site->site_name ?? null;
    //         $emp_array[$key]['designation']        = $employee->designation->name??null;
            
    //     }
    // $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
    // $pdf = Pdf::loadView('default.admin.site_group.site-employees-designation-wise-pdf', compact('emp_array','SiteGroupInfo'))
    //     ->setPaper('a4', 'landscape')
    //     ->setWarnings(false);

    //     $path = storage_path() . '/pdf';
    //     $time = \Auth::user()->id . '-' . Carbon::now()->unix();
    //     $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
    //     $name = $time . '.pdf';
    //     $route_name = route('open-pdf-file-storage-for-group', [$name]);

    //     return response()->json([
    //         'link' => $route_name,
    //     ], 200);

   // return $pdf->download('site_employees.pdf');




        $site_id = $request->site_id;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $groupWiseSiteEmployee = [];
        $key  = 0;

        $TotalCount                          = [];
        $TotalCount['total_Grpup_site']      = 0;
        $TotalCount['total_Group_employees'] = 0;
        $TotalCount['total_Group_male']      = 0;
        $TotalCount['total_Group_female']    = 0;
        $TotalCount['total_Group_others']    = 0;

        if ($site_id) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $site_id)
                ->first();

            $employees = $this->employee
                ->select('id', 'username', 'religion_id', 'gender_id')
                ->where('site_id', $site_id)
                ->with(['latestPhoto', 'gender', 'religion'])
                ->where('status', true)
                ->get();

            $TotalMale     = 0;
            $TotalFemale   = 0;
            $TotalOthers   = 0;
            $TotalEmployee = $employees->count();

            foreach ($employees as  $employee) {
                if ($employee->gender) {
                    if ($employee->gender->gender_name == 'Male') {
                        $TotalMale += 1;
                    } elseif ($employee->gender->gender_name == 'Female') {
                        $TotalFemale += 1;
                    } elseif ($employee->gender->gender_name == 'Others') {
                        $TotalOthers += 1;
                    }
                } else {
                    $TotalOthers += 1;
                }
            }

            $groupWiseSiteEmployee[$key]['site_id']       = $site->id;
            $groupWiseSiteEmployee[$key]['site_name']     = $site->site_name;
            $groupWiseSiteEmployee[$key]['TotalEmployee'] = $TotalEmployee;
            $groupWiseSiteEmployee[$key]['TotalMale']     = $TotalMale;
            $groupWiseSiteEmployee[$key]['TotalFemale']   = $TotalFemale;
            $groupWiseSiteEmployee[$key]['TotalOthers']   = $TotalOthers;

            $TotalCount['total_Grpup_site']++;
            $TotalCount['total_Group_employees'] += $TotalEmployee;
            $TotalCount['total_Group_male']      += $TotalMale;
            $TotalCount['total_Group_female']    += $TotalFemale;
            $TotalCount['total_Group_others']    += $TotalOthers;
        } else {

            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })

                ->orderBy('id', 'DESC')
                ->get();



            foreach ($GroupWiseSites as  $site) {
                $employees = $this->employee
                    ->select('id', 'username', 'religion_id', 'gender_id')
                    ->where('site_id', $site->id)
                    ->with(['latestPhoto', 'gender', 'religion'])
                    ->where('status', true)
                    ->get();

                $TotalMale     = 0;
                $TotalFemale   = 0;
                $TotalOthers   = 0;
                $TotalEmployee = $employees->count();

                foreach ($employees as  $employee) {
                    if ($employee->gender) {
                        if ($employee->gender->gender_name == 'Male') {
                            $TotalMale += 1;
                        } elseif ($employee->gender->gender_name == 'Female') {
                            $TotalFemale += 1;
                        } elseif ($employee->gender->gender_name == 'Others') {
                            $TotalOthers += 1;
                        }
                    } else {
                        $TotalOthers += 1;
                    }
                }

                $groupWiseSiteEmployee[$key]['site_id']       = $site->id;
                $groupWiseSiteEmployee[$key]['site_name']     = $site->site_name;
                $groupWiseSiteEmployee[$key]['TotalEmployee'] = $TotalEmployee;
                $groupWiseSiteEmployee[$key]['TotalMale']     = $TotalMale;
                $groupWiseSiteEmployee[$key]['TotalFemale']   = $TotalFemale;
                $groupWiseSiteEmployee[$key]['TotalOthers']   = $TotalOthers;

                $TotalCount['total_Grpup_site']++;
                $TotalCount['total_Group_employees'] += $TotalEmployee;
                $TotalCount['total_Group_male']      += $TotalMale;
                $TotalCount['total_Group_female']    += $TotalFemale;
                $TotalCount['total_Group_others']    += $TotalOthers;

                $key++;
            }
        }


        return response()->json([
            'groupWiseSiteEmployee' => $groupWiseSiteEmployee,
            'TotalCount'            => $TotalCount,
        ], 200);
    }
    public function SingleSiteGroupWiseEmployeeList(Request $request)
    {

        $site_id = $request->single_site_id;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $SiteEmployeeCount = [];

        $site = GlobalSiteInfo::select('id')
            ->where('id', $site_id)
            ->first();

        $TotalEmployessCount = $this->employee
            ->select('id', 'religion_id', 'gender_id', 'designation_id', 'contact_number')
            ->where('site_id', $site_id)
            ->with(['latestPhoto', 'gender', 'religion', 'designation'])
            ->where('status', true)
            ->get();

        $TotalMale = 0;
        $TotalFemale = 0;
        $TotalOthers = 0;

        foreach ($TotalEmployessCount as  $employee) {
            if ($employee->gender) {
                if ($employee->gender->gender_name == 'Male') {
                    $TotalMale += 1;
                } elseif ($employee->gender->gender_name == 'Female') {
                    $TotalFemale += 1;
                } elseif ($employee->gender->gender_name == 'Others') {
                    $TotalOthers += 1;
                }
            } else {
                $TotalOthers += 1;
            }
        }

        $employees = $this->employee
            ->select('id', 'religion_id', 'gender_id', 'designation_id', 'contact_number')
            ->where('site_id', $site_id)
            ->with(['latestPhoto', 'gender', 'religion', 'designation'])
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('username', 'LIKE', $txt)
                        ->orWhere('email', 'LIKE', $txt)
                        ->orWhere('contact_number', 'LIKE', $txt)
                        ->orWhereTranslationLike('first_name', $txt)
                        ->orWhereTranslationLike('last_name', $txt);
                });
            })
            ->orderBy('employee_serial', 'ASC')
            ->where('status', true)
            ->paginate($paginate);

        $employees->getCollection()->transform(function ($employee) {
            $employee->gender_name      = $employee->gender      ? $employee->gender->gender_name : null;
            $employee->religion_name    = $employee->religion    ? $employee->religion->name      : null;
            $employee->designation_name = $employee->designation ? $employee->designation->name   : null;
            return $employee;
        });



        $SiteEmployeeCount['site_id']       = $site->id;
        $SiteEmployeeCount['site_name']     = $site->site_name;
        $SiteEmployeeCount['TotalEmployee'] = $TotalEmployessCount->count();
        $SiteEmployeeCount['TotalMale']     = $TotalMale;
        $SiteEmployeeCount['TotalFemale']   = $TotalFemale;
        $SiteEmployeeCount['TotalOthers']   = $TotalOthers;

        return response()->json([
            'employees'             => $employees,
            'SiteEmployeeCount'     => $SiteEmployeeCount,
        ]);
    }
    public function GetEmployeetransferList(Request $request)
    {

        // return $request;
        $site_id = $request->site_id;
        if ($site_id) {
            $site_id = is_array($site_id) ? $site_id : [$site_id];
            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $site_id)
                ->orderBy('id', 'DESC')
                ->get();

            $groupedEmployees = $GroupWiseSites->map(function ($site) {
                $employees = $this->employee
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->whereHas('EmployeeTransferHistory') // Ensure only employees with transfer history are fetched
                    ->with(['designation', 'EmployeeTransferHistory'])
                    ->orderBy('employee_serial', 'ASC')
                    ->get();

                return [
                    'site_id'   => $site->id,
                    'site_name' => $site->site_name     ?? 'Unknown Site', // Assuming 'site' is a relation
                    'Employees' => $employees->map(function ($employee) {
                        $transferList = $employee->EmployeeTransferHistory->map(function ($transfer) {
                            return [
                                'user_id' => $transfer->user_id,
                                'previous_site_id' => GlobalSiteInfo::select('id')
                                    ->where('id', $transfer->previous_site_id)
                                    ->first()->site_name,

                                'present_site_id' =>  GlobalSiteInfo::select('id')
                                    ->where('id', $transfer->present_site_id)
                                    ->first()->site_name,
                                'employee_transfer_date' => Carbon::parse($transfer->employee_transfer_date)->format('d F Y'),
                            ];
                        })->toArray();

                        return [
                            'full_name' => $employee->full_name,
                            'assign_subject_name' => $employee->assign_subject_name ?? 'N/A', // Assuming assign_subject_name exists
                            'designation_name' => $employee->designation->name ?? 'N/A',
                            'transfer_rowspan' => count($transferList), // Count of transfers
                            'transfer_list' => $transferList,
                        ];
                    })->toArray(),
                ];
            })->toArray();


            // Return the structured array

        } else {
            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->orderBy('id', 'DESC')
                ->get();

            $groupedEmployees = $GroupWiseSites->map(function ($site) {
                $employees = $this->employee
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->whereHas('EmployeeTransferHistory') // Ensure only employees with transfer history are fetched
                    ->with(['designation', 'EmployeeTransferHistory'])
                    ->orderBy('employee_serial', 'ASC')
                    ->get();

                return [
                    'site_id'   => $site->id,
                    'site_name' => $site->site_name     ?? 'Unknown Site', // Assuming 'site' is a relation
                    'Employees' => $employees->map(function ($employee) {
                        $transferList = $employee->EmployeeTransferHistory->map(function ($transfer) {
                            return [
                                'user_id' => $transfer->user_id,
                                'previous_site_id' => GlobalSiteInfo::select('id')
                                    ->where('id', $transfer->previous_site_id)
                                    ->first()->site_name,

                                'present_site_id' =>  GlobalSiteInfo::select('id')
                                    ->where('id', $transfer->present_site_id)
                                    ->first()->site_name,
                                'employee_transfer_date' => Carbon::parse($transfer->employee_transfer_date)->format('d F Y'),
                            ];
                        })->toArray();

                        return [
                            'full_name' => $employee->full_name,
                            'assign_subject_name' => $employee->assign_subject_name ?? 'N/A', // Assuming assign_subject_name exists
                            'designation_name' => $employee->designation->name ?? 'N/A',
                            'transfer_rowspan' => count($transferList), // Count of transfers
                            'transfer_list' => $transferList,
                        ];
                    })->toArray(),
                ];
            })->toArray();
        }
        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        return response()->json([
            'groupedEmployees' => (array)$groupedEmployees,
            'SiteGroupInfo'    => $SiteGroupInfo->group_logo,
        ], 200);
    }
    public function GetEmployeeList(Request $request)
    {

        $site_id = $request->params['site_id'];
        if (!$site_id) {
            throw new Error('Please Select Institution');
        }

        $employees = $this->employee
            ->where('site_id', $site_id)
            ->with(['designation'])
            ->orderBy('employee_serial', 'ASC')
            ->where('status', true)
            ->get();
        return $employees;
    }

    public function TransferEmployeeFromGroup(Request $request)
    {
        try {

            $transfer_site_id  = $request->params['transfer_site_id'];
            $site_id           = $request->params['site_id'];
            $selected_employee = $request->params['selected_employee'];
            $employee_transfer_date     = $request->params['employee_transfer_date'];

            if (!$site_id || !$transfer_site_id) {
                throw new Error('Please Select Both Institution');
            }
            if (!$selected_employee) {
                throw new Error('Please Select Employee');
            }
            if ($site_id == $transfer_site_id) {
                throw new Error('Present institute and transfer institute should not be the same.');
            }

            $employee = $this->employee->where('id', $selected_employee)->first();

            if (!$employee) {
                throw new Error('Employee not found.');
            }
            if (!$employee_transfer_date) {
                throw new Error('Please select transfer Date.');
            }


            $site = GlobalSiteInfo::where('id', $transfer_site_id)->first();
            $employee->site_id = $transfer_site_id;
            $employee->alias = $site->site_alias;

            if ($employee->save()) {
                $employee_history = GlobalEmployeeHistory::where('user_id', $selected_employee)->where('site_id', $site_id)->first();

                if ($employee_history) {
                    $employee_history->update([
                        'status' => 0,
                    ]);
                }
                // dd($employee_history->status);


                // return $employee_history;
                $GlobalEmployeeHistory = new GlobalEmployeeHistory();
                if (isset($GlobalEmployeeHistory->ownFields)) {
                    foreach ($GlobalEmployeeHistory->ownFields as $ownField) {


                        if ($employee_history->{$ownField}) {
                            if (is_array($employee_history->{$ownField})) {
                                $GlobalEmployeeHistory->{$ownField} = collect($employee_history->{$ownField})->implode(',');
                            } else {
                                $GlobalEmployeeHistory->{$ownField} = $employee_history->{$ownField};
                            }
                        }
                    }

                    // $GlobalEmployeeHistory->designation_id = $employee->id;
                    $GlobalEmployeeHistory->user_id = $employee->id;
                    $GlobalEmployeeHistory->is_teacher = 1;
                    $GlobalEmployeeHistory->site_id = $transfer_site_id;
                    $GlobalEmployeeHistory->status = 1;
                }

                if ($GlobalEmployeeHistory->save()) {
                    EmployeeTransferHistory::create([
                        'user_id' => $selected_employee,
                        'previous_site_id' => $site_id,
                        'present_site_id' => $transfer_site_id,
                        'employee_transfer_date' => $employee_transfer_date,
                    ]);
                }
                return 'done';
            }
            DB::commit();
            return $employee;
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }
    public function GetEmployeeRetirementList(Request $request)
    {

        $site_id = $request->site_id;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $month = $request->selectedMonthIndex;
        $academic_year_id = $request->academic_year_id;
        $txt = '%' . $search_txt . '%';

        // if (!$site_id) {
        //     throw new Error('Please Select Institution');
        // }

        $academicYear = GlobalSiteShiftClassGroupSectionSetting::with('academicYear')
            ->select('academic_year_id')
            ->where('academic_year_id', $academic_year_id)
            ->first();

        if ($academicYear && $academicYear->academicYear) {
            $year = $academicYear->academicYear->year_name;
        } else {
            $year = null;
        }
        // Create a new array with employees and the date they turn 60 years old
        $employeesTurningSixty = [];
        $DateOfBirthNotFound   = 0;
        $key = 0;
        if ($site_id) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $site_id)
                ->first();
            $Employees = $this->GlobalEmployee
                ->select('id', 'username', 'designation_id', 'contact_number', 'date_of_birth')
                ->where('site_id', $site_id)
                ->with(['designation'])
                ->where('status', true)
                ->orderBy('employee_serial', 'ASC')
                ->get();




            foreach ($Employees as $index => $employee) {

                if (!empty($employee['date_of_birth'])) {
                    $dateOfBirth = Carbon::parse($employee['date_of_birth']);
                    $dateWhenSixty = $dateOfBirth->copy()->addYears(60);



                    $employeesTurningSixty[$key]['site_name']        = $site->site_name;
                    $employeesTurningSixty[$key]['full_name']        = $employee->full_name;
                    $employeesTurningSixty[$key]['contact_number']   = $employee->contact_number;
                    $employeesTurningSixty[$key]['designation_name'] = isset($employee['designation'])  ? $employee['designation']['name'] : null;
                    $employeesTurningSixty[$key]['date_when_sixty']  = $dateWhenSixty->format('d F Y');
                    $employeesTurningSixty[$key]['date_of_birth']    =  $dateOfBirth->format('d F Y');
                    $key++;
                } else {
                    $DateOfBirthNotFound++;
                }
            }




            $filteredEmployees = array_filter($employeesTurningSixty, function ($employee) use ($year, $month) {
                $dateWhenSixty = Carbon::parse($employee['date_when_sixty']);
                if ($year && $month) {
                    return $dateWhenSixty->year == $year && $dateWhenSixty->month == $month;
                } elseif ($year) {
                    return $dateWhenSixty->year == $year;
                } else {
                    return $employee;
                }
            });
        } else {
            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })

                ->orderBy('id', 'DESC')
                ->get();



            foreach ($GroupWiseSites as  $site) {
                $Employees = $this->GlobalEmployee
                    ->select('id', 'username', 'designation_id', 'contact_number', 'date_of_birth')
                    ->where('site_id', $site->id)
                    ->with(['designation'])
                    ->where('status', true)
                    ->orderBy('employee_serial', 'ASC')
                    ->get();




                foreach ($Employees as $index => $employee) {

                    if (!empty($employee['date_of_birth'])) {
                        $dateOfBirth = Carbon::parse($employee['date_of_birth']);
                        $dateWhenSixty = $dateOfBirth->copy()->addYears(60);



                        $employeesTurningSixty[$key]['site_name']        = $site->site_name;
                        $employeesTurningSixty[$key]['full_name']        = $employee->full_name;
                        $employeesTurningSixty[$key]['contact_number']   = $employee->contact_number;
                        $employeesTurningSixty[$key]['designation_name'] = isset($employee['designation'])  ? $employee['designation']['name'] : null;
                        $employeesTurningSixty[$key]['date_when_sixty']  = $dateWhenSixty->format('d F Y');
                        $employeesTurningSixty[$key]['date_of_birth']    =  $dateOfBirth->format('d F Y');
                        $key++;
                    } else {
                        $DateOfBirthNotFound++;
                    }
                }




                $filteredEmployees = array_filter($employeesTurningSixty, function ($employee) use ($year, $month) {
                    $dateWhenSixty = Carbon::parse($employee['date_when_sixty']);
                    if ($year && $month) {
                        return $dateWhenSixty->year == $year && $dateWhenSixty->month == $month;
                    } elseif ($year) {
                        return $dateWhenSixty->year == $year;
                    } else {
                        return $employee;
                    }
                });
            }
        }


        return response()->json([
            'filteredEmployees'   => $filteredEmployees,
            'DateOfBirthNotFound' => $DateOfBirthNotFound,
        ], 200);
    }
}
