<?php

namespace App\Http\Controllers\SiteGroup\ExamResult;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\SiteGroup\Exam\SiteGroupExaminationExamTypeSettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultCombineSettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultSystemSettingStore;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use Response;
use Session;

class SiteGroupBaseResultSystemSettingController extends Controller
{
    private $siteGroupSettings;

    public function __construct(SiteGroupAcademicSettingsStore $siteGroupSettings)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroupSettings = $siteGroupSettings;
      
    }




    public function index(){
        $viewType = "Site Group Exam Answer Paper";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteGroupExaminationExamTypeList(Request $request){
      //  dd('sf');

        $siteGroupInfoSetting=$this->siteGroupSettings->select('academic_result_primary_type_ids','academic_result_combine_type_ids')
            ->first();

        $academic_primary_result_type=AcademicResultPrimaryType::
            whereIn('id', explode(',', $siteGroupInfoSetting->academic_result_primary_type_ids))
            ->where('use_key','site_group')
            ->get();

        $academic_combine_result_type=AcademicResultCombineType::
            whereIn('id', explode(',', $siteGroupInfoSetting->academic_result_combine_type_ids))
            ->where('use_key','site_group')
            ->get();


        $siteExaminationList=SiteGroupExaminationExamTypeSettingStore::select('examination_id')
            ->distinct('examination_id')
            ->get();

        $data = $request->all();

        $resultSettingList =SiteGroupResultPrimarySettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $combineResultSettingList = SiteGroupResultCombineSettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $examination_arr=Array();
        $examination_array=[];

        foreach ($academic_primary_result_type as $key => $value) {

            $siteExaminationList_arr=Array();
            $siteExaminationList_array=[];
            foreach ($siteExaminationList as $k => $v) {


                $checkResultSetting=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                    ->where('examination_id', $v['examination_id'])
                    ->first();

                if($checkResultSetting){
                    $siteExaminationList_arr['select_examination_id']=true;
                    $siteExaminationList_arr['marks_percentage']=$checkResultSetting->marks_percentage;
                    $siteExaminationList_arr['show_position']=$checkResultSetting->show_position;
                }
                else{
                    $siteExaminationList_arr['select_examination_id']=false;
                    $siteExaminationList_arr['marks_percentage']=null;
                    $siteExaminationList_arr['show_position']=null;
                }

                $siteExaminationList_array[$k]=array_merge($siteExaminationList_arr, $v->toArray());
            }

            $examination_arr['examination_list']=$siteExaminationList_array;


            $checkPrimayTypeid=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                ->first();
            if($checkPrimayTypeid){
                $examination_arr['select_primary_result_type']=true;
            }else{
                $examination_arr['select_primary_result_type']=false;
            }



            $examination_array[$key]=array_merge($examination_arr, $value->toArray());
        }

        $result_type_arr=Array();
        $result_type_array=[];

        foreach ($academic_combine_result_type as $key => $value) {

            $academic_primary_result_type_arr=Array();
            $academic_primary_result_type_array=[];
            foreach ($academic_primary_result_type as $k => $v) {


                $checkComResultSetting=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                    ->where('academic_result_primary_type_id', $v['id'])
                    ->first();


                if($checkComResultSetting){
                    $academic_primary_result_type_arr['select_primary_result_type_id']=true;
                    $academic_primary_result_type_arr['marks_percentage']=$checkComResultSetting->marks_percentage;
                    $academic_primary_result_type_arr['show_position']=$checkComResultSetting->show_position;
                }
                else{
                    $academic_primary_result_type_arr['select_primary_result_type_id']=false;
                    $academic_primary_result_type_arr['marks_percentage']=null;
                    $academic_primary_result_type_arr['show_position']=null;
                }

                $academic_primary_result_type_array[$k]=array_merge($academic_primary_result_type_arr, $v->toArray());
            }

            $result_type_arr['result_type_list']=$academic_primary_result_type_array;



            $checkCombineTypeid=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                ->first();
            if($checkCombineTypeid){
                $result_type_arr['select_result_type']=true;
            }else{
                $result_type_arr['select_result_type']=false;
            }



            $result_type_array[$key]=array_merge($result_type_arr, $value->toArray());
        }

        return [$examination_array, $result_type_array];

    }

    public function createUpdateSiteGroupResultSetting(Request $request){

        $data = $request->all();

        $resultSettingList = SiteGroupResultPrimarySettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
//            ->where('examination_id', $request->examination_id)
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();



            $charges=[];
        $checkPrimayResultSettingId=[];
            foreach ($request->ResultTypeList as $key => $value) {
                if($value['select_primary_result_type']){


                    foreach ($value['examination_list'] as $k => $v) {
                        if($v['select_examination_id']){

                            if(count($resultSettingList)>0){

                                $checkResultSetting=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                                    ->where('examination_id', $v['examination_id'])
                                    ->first();
                                if($checkResultSetting){

                                    $checkPrimayResultSettingId[]=$checkResultSetting->id;

                                    $checkResultPercent=$resultSettingList->where('academic_result_primary_type_id', $value['id'])
                                        ->where('examination_id', $v['examination_id'])
                                        ->where('marks_percentage', $v['marks_percentage'])
                                        ->where('show_position', $v['show_position'])
                                        ->first();


                                    if(!$checkResultPercent){

                                        $checkResultSetting->update(['status'=>false]);
                                        $charges[] = [
                                            'academic_year_id'=>$request->academic_year_id,
                                            'academic_version_id'=>$request->academic_version_id,
                                            'academic_shift_id'=>$request->academic_shift_id,
                                            'academic_department_id'=>$request->academic_department_id,
                                            'academic_class_id'=>$request->academic_class_id,
                                            'academic_class_group_id'=>$request->academic_class_group_id,
                                            'academic_result_primary_type_id'=>$value['id'],
                                            'examination_id'=>$v['examination_id'],
                                            'marks_percentage'=>$v['marks_percentage'],
                                            'show_position'=>$v['show_position'],
                                            'status'=>true,
                                            'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                        ];

                                    }

                                }else{

                                    $charges[] = [
                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_version_id'=>$request->academic_version_id,
                                        'academic_shift_id'=>$request->academic_shift_id,
                                        'academic_department_id'=>$request->academic_department_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_class_group_id'=>$request->academic_class_group_id,
                                        'academic_result_primary_type_id'=>$value['id'],
                                        'examination_id'=>$v['examination_id'],
                                        'marks_percentage'=>$v['marks_percentage'],
                                        'show_position'=>$v['show_position'],
                                        'status'=>true,
                                        'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                    ];

                                }
                            }
                            else{
                                $charges[] = [
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_version_id'=>$request->academic_version_id,
                                    'academic_shift_id'=>$request->academic_shift_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_class_group_id'=>$request->academic_class_group_id,
                                    'academic_result_primary_type_id'=>$value['id'],
                                    'examination_id'=>$v['examination_id'],
                                    'marks_percentage'=>$v['marks_percentage'],
                                    'show_position'=>$v['show_position'],
                                    'status'=>true,
                                    'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                ];
                            }
                        }
                    }
                }
            }


            if(count($resultSettingList)>0){
                $resultId=$resultSettingList->pluck('id');
                $resultIdDiff=array_diff($resultId->toArray(), $checkPrimayResultSettingId);
                SiteGroupResultPrimarySettingStore::whereIn('id', $resultIdDiff)->update(['status'=>false]);
            }

            if(count($charges)>0){
                SiteGroupResultPrimarySettingStore::insert($charges);
            }

        $combineResultSettingList = SiteGroupResultCombineSettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
//            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

          //  dd($combineResultSettingList);
           


        $chargest=[];
        $checkCombineResultSettingId=[];
        foreach ($request->CombineResultTypeList as $key => $value) {
            if($value['select_result_type']){


                foreach ($value['result_type_list'] as $k => $v) {
                    if($v['select_primary_result_type_id']){

                        if(count($combineResultSettingList)>0){

                            $checkComResultSetting=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                                ->where('academic_result_primary_type_id', $v['id'])
                                ->first();
                            if($checkComResultSetting){

                                $checkCombineResultSettingId[]=$checkComResultSetting->id;

                                $checkComResultPercent=$combineResultSettingList->where('academic_result_combine_type_id', $value['id'])
                                    ->where('academic_result_primary_type_id', $v['id'])
                                    ->where('marks_percentage', $v['marks_percentage'])
                                    ->where('show_position', $v['show_position'])
                                    ->first();


                                if(!$checkComResultPercent){

                                    $checkComResultSetting->update(['status'=>false]);
                                    $chargest[] = [
                                        'academic_year_id'=>$request->academic_year_id,
                                        'academic_version_id'=>$request->academic_version_id,
                                        'academic_shift_id'=>$request->academic_shift_id,
                                        'academic_department_id'=>$request->academic_department_id,
                                        'academic_class_id'=>$request->academic_class_id,
                                        'academic_class_group_id'=>$request->academic_class_group_id,
                                        'academic_result_combine_type_id'=>$value['id'],
                                        'academic_result_primary_type_id'=>$v['id'],
                                        'marks_percentage'=>$v['marks_percentage'],
                                        'show_position'=>$v['show_position'],
                                        'status'=>true,
                                        'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                        'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                    ];
                                }

                            }else{

                                $chargest[] = [
                                    'academic_year_id'=>$request->academic_year_id,
                                    'academic_version_id'=>$request->academic_version_id,
                                    'academic_shift_id'=>$request->academic_shift_id,
                                    'academic_department_id'=>$request->academic_department_id,
                                    'academic_class_id'=>$request->academic_class_id,
                                    'academic_class_group_id'=>$request->academic_class_group_id,
                                    'academic_result_combine_type_id'=>$value['id'],
                                    'academic_result_primary_type_id'=>$v['id'],
                                    'marks_percentage'=>$v['marks_percentage'],
                                    'show_position'=>$v['show_position'],
                                    'status'=>true,
                                    'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                ];

                            }
                        }
                        else{
                            $chargest[] = [
                                'academic_year_id'=>$request->academic_year_id,
                                'academic_version_id'=>$request->academic_version_id,
                                'academic_shift_id'=>$request->academic_shift_id,
                                'academic_department_id'=>$request->academic_department_id,
                                'academic_class_id'=>$request->academic_class_id,
                                'academic_class_group_id'=>$request->academic_class_group_id,
                                'academic_result_combine_type_id'=>$value['id'],
                                'academic_result_primary_type_id'=>$v['id'],
                                'marks_percentage'=>$v['marks_percentage'],
                                'show_position'=>$v['show_position'],
                                'status'=>true,
                                'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                            ];
                        }

                    }
                }
            }
        }


        if(count($resultSettingList)>0){
            $resultId=$resultSettingList->pluck('id');
            $resultIdDiff=array_diff($resultId->toArray(), $checkPrimayResultSettingId);
            SiteGroupResultCombineSettingStore::whereIn('id', $resultIdDiff)->update(['status'=>false]);
        }

        if(count($chargest)>0){
            SiteGroupResultCombineSettingStore::insert($chargest);
        }

        

        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

    }

    public function getSiteGroupBaseResultSystemList(Request $request){

        $data = $request->all();
       
        $siteGroupInfoSetting=$this->siteGroupSettings->select('academic_result_system_ids','academic_result_primary_type_ids','academic_result_combine_type_ids','academic_class_ids')
            ->first();

        $academic_result_system=AcademicResultSystem::
        whereIn('id', explode(',', $siteGroupInfoSetting->academic_result_system_ids))
            ->get();

        $academic_class_list=AcademicClass::whereIn('id', explode(',',$siteGroupInfoSetting->academic_class_ids))->get();

        $siteResultSystemSettingPresent=SiteGroupResultSystemSettingStore::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status',true)
            ->get();

        $class_list_arr=Array();
        $class_list_array=[];
        foreach ($academic_class_list as $key => $value) {

            $result_system_arr=Array();
            $result_system_array=[];
            foreach ($academic_result_system as $k => $v) {

                if(count($siteResultSystemSettingPresent)>0){
                    $check= $siteResultSystemSettingPresent->where('academic_class_id', $value['id'])
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->where('academic_result_system_id',$v['id'])
                        ->first();

                    if($check){
                        $result_system_arr['select_result_system']=true;
                        $result_system_arr['number_from']=$check->number_from;
                        $result_system_arr['number_to']=$check->number_to;
                        $result_system_arr['point']=$check->point;
                        $result_system_arr['point_from']=$check->point_from;
                        $result_system_arr['point_to']=$check->point_to;
                        $result_system_arr['pass_fail_status']=$check->pass_fail_status?'pass':'fail';
                    }
                    else{
                        $result_system_arr['select_result_system']=false;
                        $result_system_arr['number_from']=null;
                        $result_system_arr['number_to']=null;
                        $result_system_arr['point']=null;
                        $result_system_arr['point_from']=null;
                        $result_system_arr['point_to']=null;
                        $result_system_arr['pass_fail_status']=null;
                    }
                }
                else{
                    $result_system_arr['select_result_system']=false;
                    $result_system_arr['number_from']=null;
                    $result_system_arr['number_to']=null;
                    $result_system_arr['point']=null;
                    $result_system_arr['point_from']=null;
                    $result_system_arr['point_to']=null;
                    $result_system_arr['pass_fail_status']=null;
                }

                $result_system_array[$k]=array_merge($v->toArray(), $result_system_arr);
            }



            if(count($siteResultSystemSettingPresent)>0) {
                $checks = $siteResultSystemSettingPresent->where('academic_class_id', $value['id'])
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->first();

                if($checks){
                    $class_list_arr['select_class']=true;
                }else{
                    $class_list_arr['select_class']=false;
                }
            }else{
                $class_list_arr['select_class']=false;
            }

            $class_list_arr['result_system_list']=$result_system_array;


            $class_list_array[$key]=array_merge($value->toArray(), $class_list_arr);
        }
        return $class_list_array;
    }

    public function createUpdateSiteGroupResultSystemSetting(Request $request){


        $data = $request->all();

        $siteResultSystemSettingPresent=SiteGroupResultSystemSettingStore::where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();

        $present_ids=[];
        if(count($siteResultSystemSettingPresent)>0){

            $present_ids=$siteResultSystemSettingPresent->pluck('id');
        }


        $charges=[];
        $check_ids=[];
        foreach ($request->ResultSystemTypeList as $key => $value) {

            if($value['select_class']){

                foreach ($value['result_system_list'] as $k => $v) {

                    if($v['select_result_system']){



                        if(count($siteResultSystemSettingPresent)>0){

                          $check= $siteResultSystemSettingPresent->where('academic_class_id', $value['id'])
                              ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                                  return $query->where('academic_department_id', $data['academic_department_id']);
                              })
                              ->where('academic_result_system_id',$v['id'])
                              ->first();

                            if($check){

                                $check_ids[]=$check->id;

                                $check->update([
                                    'number_from'=>$v['number_from'],
                                    'number_to'=>$v['number_to'],
                                    'point'=>$v['point'],
                                    'point_from'=>$v['point_from'],
                                    'point_to'=>$v['point_to'],
                                    'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                    'status'=>true,
                                ]);

                            }
                            else{
                                $charges[] = [
                                    'academic_department_id'=>$request->academic_department_id,
                                    'academic_class_id'=>$value['id'],
                                    'academic_shift_id'=>$request->academic_shift_id,
                                    'academic_version_id'=>$request->academic_version_id,
                                    'academic_year_id'=>$request->academic_year_id,

                                    'academic_result_system_id'=>$v['id'],

                                    'number_from'=>$v['number_from'],
                                    'number_to'=>$v['number_to'],
                                    'point'=>$v['point'],
                                    'point_from'=>$v['point_from'],
                                    'point_to'=>$v['point_to'],
                                    'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,

                                    'status'=>true,
                                    'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                    'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                                ];
                            }
                        }
                        else{
                            $charges[] = [
                                'academic_department_id'=>$request->academic_department_id,
                                'academic_class_id'=>$value['id'],
                                'academic_shift_id'=>$request->academic_shift_id,
                                'academic_version_id'=>$request->academic_version_id,
                                'academic_year_id'=>$request->academic_year_id,

                                'academic_result_system_id'=>$v['id'],

                                'number_from'=>$v['number_from'],
                                'number_to'=>$v['number_to'],
                                'point'=>$v['point'],
                                'point_from'=>$v['point_from'],
                                'point_to'=>$v['point_to'],
                                'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,

                                'status'=>true,
                                'site_group_id'=>Session::get('SITE_GROUP_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),

                            ];
                        }
                    }
                }
            }

        }

        if(count($charges)>0){
            SiteGroupResultSystemSettingStore::insert($charges);
        }

        if(count($present_ids)>0){
            $resultSystemAbsentCheck=array_diff($present_ids->toArray(), $check_ids);

            SiteGroupResultSystemSettingStore::whereIn('id', $resultSystemAbsentCheck)->update(['status'=>false]);
        }

        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

    }




}
