<?php

namespace App\Http\Controllers\SiteGroup\ExamResult;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudent;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudentSubject;
use App\Models\Site\Exam\GlobalSiteExaminationExamTypeSetting;
use App\Models\Site\Exam\GlobalSiteSubjectExaminationMark;
use App\Models\Site\Result\GlobalSiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultSystemSettingStore;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use Carbon\Carbon;
use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;


class SiteGroupExamResultGenerateController extends SiteGroupProjectController
{
    private $siteGroupSettings;
    private $globalSiteIndividualCombineSubjectResultStore;

    public function __construct(SiteGroupAcademicSettingsStore $siteGroupSettings, GlobalSiteIndividualCombineSubjectResultStore $globalSiteIndividualCombineSubjectResultStore)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroupSettings = $siteGroupSettings;
    }

    public function index()
    {
        //  dd('sf');
        $viewType = "Site Group Exam Result Generate";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function getStudenthistoryList(Request $request, $site_ids)
    {
        $data = $request->all();

        $studentList = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_group_id', session()->get('ACADEMIC_GROUP_ID'))
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->whereIn('site_id', $site_ids)
            ->where('status', true)
            ->get();

        return $studentList;
    }

    public function getStieGroupBaseMeritListResultTypeList(Request $request)
    {
        $data = $request->all();

        $siteExamDeclares = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('exam_declared_by', 'site_group')
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

        $site_ids = $siteExamDeclares->pluck('site_id');
        $studentList = $this->getStudenthistoryList($request, $site_ids);
        $student_ids = $studentList->pluck('id');
       
        $primary_exam_type_ids = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();


        $result_primary_type_list = AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->where('use_key', 'site_group')
            ->get(['id', 'name']);

        return $result_primary_type_list;
    }
    public function getStieGroupBaseResultTypeList(Request $request)
    {


        $data = $request->all();

        $resultSettingList = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

        //            ->distinct('academic_result_primary_type_id')
        //            ->pluck('academic_result_primary_type_id');


        $resultSettingListIds = $resultSettingList->pluck('academic_result_primary_type_id')->unique()->filter();

        $siteExamDeclares = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('exam_declared_by', 'site_group')
            // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            //     return $query->where('academic_department_id', $data['academic_department_id']);
            // })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

        $site_ids = $siteExamDeclares->pluck('site_id');


        //  return $resultSettingListIds;

        $academic_result_primary_type_id_array = [];
        foreach ($resultSettingListIds as $key => $value) {

            $ExaminationFromSetting = $resultSettingList->where('academic_result_primary_type_id', $value);
            $ExaminationIDsFromSetting = $ExaminationFromSetting->pluck('examination_id')->unique();
            $countExaminationFromSetting = count($ExaminationIDsFromSetting);

            $ExaminationFromExamDeclare = $siteExamDeclares->whereIn('examination_id', $ExaminationIDsFromSetting);
            $ExaminationIDsFromExamDeclare = $ExaminationFromExamDeclare->pluck('examination_id')->unique();
            $countExaminationFromExamDeclare = count($ExaminationIDsFromExamDeclare);

            if ($countExaminationFromSetting == $countExaminationFromExamDeclare) {
                $academic_result_primary_type_id_array[] = $value;
            }
        }
        //  dd($academic_result_primary_type_id_array);
        $resultlist_test = AcademicResultPrimaryType::whereIn('id', $academic_result_primary_type_id_array)->get();
        //  dd($resultlist_test);
        $test_arr = array();
        $resultlist = [];
        foreach ($resultlist_test as $key => $value) {

            $student_list_ids = GlobalStudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->whereIn('site_id', $site_ids)
                //                ->where('status', true)
                ->pluck('id');


            $check_result_present = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->pluck('id');

            if (count($check_result_present) > 0) {
                $test_arr['result_generate_status'] = true;
            } else {
                $test_arr['result_generate_status'] = false;
            }


            $check_result__publish_emp_panel = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_employee_publish_status', true)
                ->first();

            $check_result_publish_std_panel = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_student_publish_status', true)
                ->first();

            $check_result_publish_public = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_public_publish_status', true)
                ->first();

            if ($check_result__publish_emp_panel) {
                $test_arr['result_employee_publish_status'] = true;
            } else {
                $test_arr['result_employee_publish_status'] = false;
            }


            if ($check_result_publish_std_panel) {
                $test_arr['result_student_publish_status'] = true;
            } else {
                $test_arr['result_student_publish_status'] = false;
            }

            if ($check_result_publish_public) {
                $test_arr['result_public_publish_status'] = true;
            } else {
                $test_arr['result_public_publish_status'] = false;
            }



            $test_arr['loading_result_generate_image'] = false;

            $resultlist[$key] = array_merge($test_arr, $value->toArray());
        }
        return $resultlist;
    }


    public function createUpdateSiteGroupMeritListExamResultGenerate(Request $request)
    {
        $data = $request->all();
        $offset = $request->offset ?? 0;
        $limit = 500;

        // Step 1: Get eligible site IDs
        $examDeclareSiteIds = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('site_id', $this->siteIds())
            ->where('exam_declared_by', 'site_group')
            ->where('status', true)
            ->pluck('site_id');

        // Step 2: Get student list
        $studentList = $this->getStudenthistoryList($request, $examDeclareSiteIds);
        $student_list_ids = $studentList->pluck('id');
        $total_students = $student_list_ids->count();

        // Step 3: If no students, exit early
        if ($total_students === 0) {
            return response()->json([
                'message' => 'No students found.',
                'next_offset' => 0,
                'completed_percent' => 100,
                'completed' => true,
            ]);
        }

        // Step 4: Highest marks calculation (only once on offset 0)
        if ($offset === 0) {
            $highest_marks_list = GlobalSiteIndividualCombineSubjectResultStore::select(
                'exam_dependent_academic_subject_id',
                DB::raw('MAX(obtain_total_marks_for_show) as obtain_total_marks_for_show'),
                DB::raw('MAX(obtain_raw_total_marks) as obtain_raw_total_marks')
            )
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_list_ids)
                ->where('status', true)
                ->groupBy('exam_dependent_academic_subject_id')
                ->get();


            $highest_marks_json = json_encode($highest_marks_list);
        } else {
            $highest_marks_json = $request->highest_marks_json ?? json_encode([]);
        }

        // Step 5: Process result details for current chunk
        $resultDetails = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->join('student_histories', 'site_student_primary_result_details.student_history_id', '=', 'student_histories.id')
            ->orderByDesc('gpa')
            ->orderBy('fail_subject_count')
            ->orderByDesc('sum_of_obtain_raw_total_marks')
            ->orderBy('student_histories.student_roll_number')
            ->select('site_student_primary_result_details.*')
            ->skip($offset)
            ->take($limit)
            ->get();

        // Step 6: Check if finished
        if ($resultDetails->isEmpty()) {
            return response()->json([
                'message' => 'Merit list generation completed.',
                'next_offset' => $offset,
                'completed_percent' => 100,
                'completed' => true
            ]);
        }

        // Step 7: Update each student's result info
        $central_rank = $offset + 1;

        foreach ($resultDetails as $result) {
            $result->update([
                'total_student' => $total_students,
                'central_rank' => $central_rank,
                'highest_marks_list' => $highest_marks_json,
            ]);

            $central_rank++;
        }

        // Step 8: Calculate progress and prepare next chunk
        $next_offset = $offset + $limit;
        $raw_percent = $total_students > 0 ? ($next_offset / $total_students) * 100 : 100;
        $isCompleted = $next_offset >= $total_students;
        $completed_percent = $isCompleted ? 100 : max(1, round($raw_percent));

        return response()->json([
            'message' => $isCompleted ? 'Merit list generation completed.' : 'Chunk processed!',
            'next_offset' => $next_offset,
            'totalStudnets' => $total_students,
            'completed_percent' => $completed_percent,
            'completed' => $isCompleted,
            'highest_marks_json' => $highest_marks_json,
        ]);
    }


     public function createUpdateSiteGroupExamResultGenerate(Request $request)
    {
        $startTime = microtime(true);
        $data = $request->all();
        $offset = $request->offset ?? 0;
        $limit = 500;
        $completed_percent = $request->completed_percent ?? 0;


       // Log::info('Start Result Generation', ['timestamp' => now()]);

        // Step 1: Fetch result settings
        $resultSettingList = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
            ->where([
                'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
                'academic_shift_id' => $request->academic_shift_id,
                'academic_class_id' => $request->academic_class_id,
                'academic_result_primary_type_id' => $request->academic_result_primary_type_id,
                'status' => true
            ])
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->orderBy('show_position', 'asc')
            ->get(['id', 'academic_result_primary_type_id', 'examination_id', 'marks_percentage', 'show_position']);

        // Step 2: Fetch exam declarations and total student count
        if ($offset == 0) {
            $examDeclareListIDs = GlobalSiteExamDeclares::where([
                'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
                'academic_shift_id' => $request->academic_shift_id,
                'academic_class_id' => $request->academic_class_id,
                'status' => true,
                'exam_declared_by' => 'site_group'
            ])
                ->whereIn('site_id', $this->siteIds())
              //  ->whereIn('site_id', [33,171])
                ->whereIn('examination_id', $resultSettingList->pluck('examination_id')->unique())
                ->pluck('id');

            $total_student_count = GlobalSiteExamDeclareStudent::whereIn('site_exam_declare_id', $examDeclareListIDs)
                ->whereIn('site_id', $this->siteIds())
                ->pluck('student_history_id')
                ->unique()
                ->count();
        } else {
            $examDeclareListIDs = $request->examDeclareListIDs;
            $total_student_count = $request->total_student_count ?? 0;

          //  dd($total_student_count);
        }

       //  Log::info('Step 2: Fetch Exam Declarations and Students', ['elapsed' => microtime(true) - $startTime]);

        // Step 3: Chunk student history
        $declare_student_history_ids = GlobalSiteExamDeclareStudent::whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->whereIn('site_id', $this->siteIds())
            ->skip($offset)
            ->take($limit)
            ->pluck('student_history_id')
            ->unique();

        $studentHistoryList = GlobalStudentHistory::whereIn('id', $declare_student_history_ids)->get();
        $student_history_ids = $declare_student_history_ids;

        // Step 4: Fetch student marks
        $studentMarksList = GlobalSiteExamDeclareStudentSubject::with(['examination:id,examination_name', 'academicExamType:id,marks_type'])
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->whereIn('site_id', $this->siteIds())
            ->whereIn('student_history_id', $student_history_ids)
            ->get();

        // Step 5: Subject settings
        $student_site_ids = $studentHistoryList->pluck('site_id')->unique();
        $subject_condition_setting = GlobalSubjectGroupConditionSetting::where([
            'academic_year_id' => $request->academic_year_id,
            'academic_class_id' => $request->academic_class_id,
            'status' => true
        ])
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->when(!empty($data['academic_class_group_id']), fn($q) => $q->where('academic_class_group_id', $data['academic_class_group_id']))
            ->whereIn('site_id', $student_site_ids)
            ->get(['id', 'result_show_in_table_bellow']);

        $showTableBellowSubjectIDs = $subject_condition_setting->where('result_show_in_table_bellow', true)->pluck('id')->unique();
        $OtherSubjectIDs = $subject_condition_setting->where('result_show_in_table_bellow', false)->pluck('id')->unique();

        // Step 6: Filtered marks by type
        $showTableBellowSubjectExamList = $studentMarksList->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
            ->unique(fn($item) => $item['examination_id'] . '-' . $item['academic_exam_type_id'])->values();
        $OtherSubjectExamList = $studentMarksList->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
            ->unique(fn($item) => $item['examination_id'] . '-' . $item['academic_exam_type_id'])->values();

        // Step 7: Fetch grades
        $grade_list = SiteGroupResultSystemSettingStore::with('academicResultSystem')
            ->where([
                'academic_version_id' => $request->academic_version_id,
                'academic_year_id' => $request->academic_year_id,
                'academic_class_id' => $request->academic_class_id,
                'status' => true
            ])
            ->when(!empty($data['academic_department_id']), fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
            ->get()
            ->sortBy(fn($item) => $item->academicResultSystem->serial ?? 0);

       //  Log::info('Step 3: Fetch Exam Declarations and Students', ['elapsed' => microtime(true) - $startTime]);

        // Step 8: Get subject-wise result data
        $academic_result_primary_type_id = $request->academic_result_primary_type_id;
        $student_indivisual_subject_list = $this->studentMarkslist(
            $studentMarksList,
            $studentHistoryList,
            $grade_list,
            $resultSettingList,
            $academic_result_primary_type_id,
            $showTableBellowSubjectExamList,
            $OtherSubjectExamList
        );
      //   Log::info('Step 4: Fetch Exam Declarations and Students', ['elapsed' => microtime(true) - $startTime]);


        // Step 9: Update or create final results
        $student_ids = collect($student_indivisual_subject_list)->pluck('student_history_id');
        $existingResults = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->get();

        $resultSett = SiteGroupResultPrimarySettingStore::where([
            'academic_version_id' => $request->academic_version_id,
            'academic_year_id' => $request->academic_year_id,
            'academic_shift_id' => $request->academic_shift_id,
            'academic_class_id' => $request->academic_class_id,
            'academic_result_primary_type_id' => $request->academic_result_primary_type_id
        ])->first();

        ////
            
         $filter_for_examination_ids = Examination::whereIn('id', $studentMarksList->pluck('examination_id')
            ->unique()
            ->filter())
            ->get(['id', 'examination_name', 'name_key']);

        $exam_type_arr = array();
        $exam_type_array = [];
        foreach ($filter_for_examination_ids as $key => $value) {

            $get_postions = $resultSettingList->where('examination_id', $value->id)->first();

            $exam_type_ids = $studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();

            $exam_type_ids_for_table_bellow = $studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();

            // exam position wise serial
            $exam_type_setting = GlobalSiteExaminationExamTypeSetting::where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $value->id)
                ->whereIn('academic_exam_type_id', $exam_type_ids)
                ->whereIn('site_id', $student_site_ids)
                ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                ->orderBy('position_show', 'ASC')
                ->get();

            $exam_type_list = [];
            $key = 0;
            foreach ($exam_type_setting as $type_sett) {

                $exam_type = AcademicExamType::where('id', $type_sett->academic_exam_type_id)->first();

                $exam_type_list[$key]['id'] = $exam_type->id;
                $exam_type_list[$key]['marks_type'] = $exam_type->marks_type;
                $exam_type_list[$key]['head_key'] = $exam_type->head_key;
                $key++;
            }

            $unique_exam_type_list = collect($exam_type_list)->unique('id')->values()->all();


            $exam_type_list_for_table_bellow = AcademicExamType::whereIn('id', $exam_type_ids_for_table_bellow)->get(['id', 'marks_type']);

            $exam_type_arr['academic_exam_type_list'] = $unique_exam_type_list;
            $exam_type_arr['grade_setting_list'] = $grade_list;
            $exam_type_arr['academic_exam_type_list_for_table_bellow'] = $exam_type_list_for_table_bellow;
            $exam_type_arr['table_bellow_status'] = count($exam_type_list_for_table_bellow) > 0 ? 1 : 0;
            $exam_type_arr['obtain_marks'] = 'Obt';
            $exam_type_arr['academic_exam_type_count'] = count($unique_exam_type_list);
            $exam_type_arr['exam_type_list_for_table_bellow_count'] = count($exam_type_list_for_table_bellow);
            $exam_type_arr['show_position'] = $get_postions->show_position;
            $exam_type_arr['marks_percentage'] = $get_postions->marks_percentage ?? 0;

            $exam_type_array[$key] = array_merge($exam_type_arr, $value->toArray());
        }


        $exam_type_array_with_sort = array_values(array_sort(collect($exam_type_array), function ($value) {
            return $value['show_position'];
        }));

        ////


         $header_items = [
            'grade_list' => $grade_list,
            'exam_list' => $exam_type_array_with_sort,
        ];


        $examRolls = SiteGroupStudentExamRoll::whereIn('student_history_id', $student_ids)
            ->where('examination_id', $resultSett->examination_id)
            ->pluck('roll', 'student_history_id');

        foreach ($student_indivisual_subject_list as $record) {
            $this->saveOrUpdateStudentResult($record, $existingResults, $request, $examRolls, $header_items);
        }
      //   Log::info('Step 5: Fetch Exam Declarations and Students', ['elapsed' => microtime(true) - $startTime]);


        // Step 10: Progress tracking
        $next_offset = $offset + $limit;
        $raw_percent = $total_student_count > 0 ? ($next_offset / $total_student_count) * 100 : 100;
        $isCompleted = $next_offset >= $total_student_count;
        $completed_percent = $isCompleted ? 100 : max(1, round($raw_percent));

        return response()->json([
            'message' => $isCompleted ? 'Result generation completed.' : 'Chunk processed!',
            'next_offset' => $next_offset,
            'total_student_count' => $total_student_count,
            'examDeclareListIDs' => $examDeclareListIDs,
            'completed_percent' => $completed_percent,
            'completed' => $isCompleted,
        ]);
    }

    private function saveOrUpdateStudentResult($record, $existingResults, $request, $examRolls, $header_items)
    {
        $examRoll = $examRolls[$record['student_history_id']] ?? '';

        $data = [
            'academic_result_primary_type_id' => $request->academic_result_primary_type_id,
            'student_history_id' => $record['student_history_id'],
            'gpa' => $record['final_point'],
            'grade' => $record['final_grade'],
            'fail_subject_count' => $record['fail_subject_count'],
            'optional_subject_ids' => $record['optional_subject_ids'],
            'final_point_without_optional' => $record['final_point_without_optional'],
            'final_grade_without_optional' => $record['final_grade_without_optional'],
            'combine_subject_present' => $record['combine_subject_present'],
            'classtest_is_present' => $record['classtest_is_present'],
            'exam_attendance_status' => $record['exam_attendance_status'],
            'sum_of_obtain_raw_total_marks' => ceil($record['sum_of_obtain_raw_total_marks']),
            'sum_of_obtain_percent_total_marks' => ceil($record['sum_of_obtain_percent_total_marks']),
            'sum_of_raw_total_marks' => ceil($record['sum_of_raw_total_marks']),
            'raw_obtain_marks_percentage' => $record['sum_of_raw_total_marks'] > 0
                ? ($record['sum_of_obtain_raw_total_marks'] * 100 / $record['sum_of_raw_total_marks'])
                : 0,
            'sum_of_obtain_raw_total_marks_only_passed_subject' => ceil($record['sum_of_obtain_raw_total_marks_only_passed_subject']),
            'pass_subject_base_marks_percentage' => $record['pass_subject_base_marks_percentage'],
            'total_marks_base_percentage' => $record['total_marks_base_percentage'],
            'pass_subject_base_marks_grade' => $record['pass_subject_base_marks_grade'],
            'total_marks_base_grade' => $record['total_marks_base_grade'],
            'pass_subject_base_marks_point' => $record['pass_subject_base_marks_point'],
            'total_marks_base_point' => $record['total_marks_base_point'],
            'sum_of_obtain_total_marks_for_show' => ceil($record['sum_of_obtain_total_marks_for_show']),
            'sum_of_obtain_total_percent_for_show' => $record['sum_of_obtain_total_percent_for_show'],
            'table_header' => json_encode($header_items['grade_list']), // Add headers if needed
            'sheet_header' => json_encode($header_items),
            'site_individual_combine_subject_result_store_ids' => implode(',', $record['site_individual_combine_subject_result_store_ids']),
            'site_id' => $record['site_id'],
            'result_generated_by' => 'site_group',
            'examination_roll' => $examRoll,
        ];

        $existing = $existingResults->where('student_history_id', $record['student_history_id'])->first();
        if ($existing) {
            $existing->update($data);
        } else {
            GlobalSiteStudentPrimaryResultDetail::create($data);
        }
    }



    private function studentMarkslist(
        $studentMarksList,
        $student_list,
        $grade_list,
        $resultSettingList,
        $academic_result_primary_type_id,
        $showTableBellowSubjectExamList,
        $OtherSubjectExamList
    ) {

        $exam_type_ids = collect($OtherSubjectExamList)->pluck('academic_exam_type_id');

        $academicExamType = AcademicExamType::whereIn('id', $exam_type_ids)->get();

        $student_array = $this->examTypePassFailStatus($studentMarksList);

        $class_test_present_list = $resultSettingList->where('examination.name_key', 'classtest');

        if (count($class_test_present_list) > 0) {
            $classtest_is_present = 1;
        } else {
            $classtest_is_present = 0;
        }

        // $exam_percentage_sum=$resultSettingList->sum('marks_percentage');
        // dd($class_test_present_list);

        $student_history_ids = collect($student_array)->pluck('student_history_id')->unique()->filter()->values();

        $site_subject_examination_marks_ids = collect($student_array)->pluck('site_subject_group_condition_setting_id')->unique()->filter();

        $site_subject_examination_marks_list = GlobalSiteSubjectExaminationMark::whereIn('site_subject_group_condition_setting_id', $site_subject_examination_marks_ids)
            ->where('status', true)
            ->get(['id', 'site_subject_group_condition_setting_id', 'examination_id', 'marks', 'pass_marks']);


        $siteIndividualCombineSubjectStudentList = GlobalSiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $academic_result_primary_type_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();


        $student_list_arr = array();
        $student_list_array = [];
        $studentr_count = 0;
        foreach ($student_history_ids as $key => $value) {


            $student_present_check = $student_list->where('id', $value)->first();
            //   $student_present_check=GlobalStudentHistory::findOrFail($value);

            $student_exam_number_list = collect($student_array)->where('student_history_id', $value);
            $site_subject_group_condition_setting_ids = collect($student_array)->where('student_history_id', $value)
                ->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->values();


            $examination_ids = $student_exam_number_list
                ->pluck('examination_id')
                ->unique()
                ->filter();

            $individual_subject_entry = [];
            $subject_arr = array();
            $subject_array = [];
            $keye_count = 0;

             foreach ($site_subject_group_condition_setting_ids as $key => $subjectGroupId) {

        $examinationListForSubject = $student_exam_number_list
            ->where('site_subject_group_condition_setting_id', $subjectGroupId);

        $attendanceStatus = $examinationListForSubject
            ->where('exam_attendance_status', true)
            ->isNotEmpty();

        $passFailMarksList = $site_subject_examination_marks_list
            ->where('site_subject_group_condition_setting_id', $subjectGroupId);

        $selectedSubject = GlobalSubjectGroupConditionSetting::where('id', $subjectGroupId)->first();

        if (!$selectedSubject) {
            continue; // skip if subject not found
        }

        $examTypeSummaryArray = [];

        // Loop through each examination id and prepare exam type summary
        foreach ($examination_ids as $examId) {

                $examTypeArray = $this->processExamType(
                    $examinationListForSubject,
                    $academicExamType,
                    $examId,
                    $selectedSubject->result_show_in_table_bellow,
                    $showTableBellowSubjectExamList
                );

                $examSetting = $resultSettingList->where('examination_id', $examId)->first();
                $basePassFail = $passFailMarksList->where('examination_id', $examId)->first();

                // Calculate total obtained marks (considering countable marks)
                $totalObtainedMarks = $this->calculateTotalObtainedMarks($examinationListForSubject->where('examination_id', $examId));

                // Calculate combined marks percentage (class test + term exam) and adjust
                list($classTestTermPercentage, $countableDependentMarks, $countableDependentMarksForShow) =
                    $this->calculateCountableDependentMarks(
                        $examinationListForSubject,
                        $resultSettingList,
                        $examSetting,
                        $basePassFail,
                        $totalObtainedMarks
                    );

                // Check individual pass count
                $passCount = $examinationListForSubject->where('examination_id', $examId)->sum('primary_pass_fail_status');
                $allExamTypeIds = $examinationListForSubject->where('examination_id', $examId)->pluck('academic_exam_type_id')->unique()->filter();
                $subjectIndividualPassFailStatus = (count($allExamTypeIds) == $passCount) ? 1 : 0;

                $examHeldStatus = $examinationListForSubject
                    ->where('examination_id', $examId)
                    ->where('exam_held', 1)
                    ->first()['exam_held'] ?? 0;

                $examTypeSummaryArray[] = [
                    'examination_id' => $examId,
                    'id' => $examSetting->show_position ?? 0,
                    'examination_marks' => $basePassFail->marks ?? 0,
                    'examination_pass_marks' => $basePassFail->pass_marks ?? 0,
                    'subject_indivisual_pass_fail_status' => $subjectIndividualPassFailStatus,
                    'exam_type_list' => collect($examTypeArray)->values(),
                    'obtaine_total_marks' => ceil($totalObtainedMarks),
                    'exam_held_status' => $examHeldStatus,
                    'examination_name' => $examSetting->examination->examination_name ?? '',
                    'examination_name_key' => $examSetting->examination->name_key ?? '',
                    'marks_percentage' => $examSetting->marks_percentage ?? 0,
                    'show_position' => $examSetting->show_position ?? 0,
                    'countable_dependent_obtain_exam_type_marks' => $countableDependentMarks,
                    'countable_dependent_obtain_exam_type_marks_for_show' => ceil($countableDependentMarksForShow),
                ];
            }

            $examTypeSummaryCollection = collect($examTypeSummaryArray);

            // Calculate term exam and class test summaries
            $termExamMarksPercentageSum = $examTypeSummaryCollection->where('examination_name_key', 'termexam')->sum('marks_percentage');
            $termExamObtainedTotalMarksSum = $examTypeSummaryCollection->where('examination_name_key', 'termexam')->sum('obtaine_total_marks');
            $termExamObtainedForShow = $examTypeSummaryCollection->where('examination_name_key', 'termexam')->sum('countable_dependent_obtain_exam_type_marks_for_show');
            $termExamHeld = $examTypeSummaryCollection->where('examination_name_key', 'termexam')->where('exam_held_status', 1)->first();
            $termExamHeldStatus = $termExamHeld['exam_held_status'] ?? 0;
            $termExamMarksSum = $examTypeSummaryCollection->where('examination_name_key', 'termexam')->sum('examination_marks');
            $termExamPassMarksSum = $examTypeSummaryCollection->where('examination_name_key', 'termexam')->sum('examination_pass_marks');

            $classTestMarksPercentageSum = $examTypeSummaryCollection->where('examination_name_key', 'classtest')->sum('marks_percentage');
            $classTestObtainedTotalMarksSum = $examTypeSummaryCollection->where('examination_name_key', 'classtest')->sum('obtaine_total_marks');
            $classTestObtainedForShow = $examTypeSummaryCollection->where('examination_name_key', 'classtest')->sum('countable_dependent_obtain_exam_type_marks_for_show');
            $classTestHeld = $examTypeSummaryCollection->where('examination_name_key', 'classtest')->where('exam_held_status', 1)->first();
            $classTestHeldStatus = $classTestHeld['exam_held_status'] ?? 0;
            $classTestMarksSum = $examTypeSummaryCollection->where('examination_name_key', 'classtest')->sum('examination_marks');

            $termPassFailPrimaryStatus = $termExamObtainedTotalMarksSum >= $termExamPassMarksSum ? 1 : 0;

            $individualPassFailStatuses = $examTypeSummaryCollection->pluck('subject_indivisual_pass_fail_status')->unique();

            $subjectBasePassFailStatus = 0;
            if ($termPassFailPrimaryStatus) {
                if ($individualPassFailStatuses->count() == 1) {
                    $subjectBasePassFailStatus = 1;
                } elseif ($individualPassFailStatuses->count() == 2) {
                    $subjectBasePassFailStatus = 0;
                }
            } else {
                $subjectBasePassFailStatus = 0;
            }

            // Calculate final marks in term exam and class test
            if ($classTestObtainedTotalMarksSum <= 0 && !$classTestHeldStatus) {
                if ($termExamMarksPercentageSum <= 0) {
                    $obtainTotalMarksTermExam = $termExamObtainedTotalMarksSum;
                } else {
                    $obtainTotalMarksTermExam = ($termExamObtainedTotalMarksSum * 100) / $termExamMarksSum;
                }
                $obtainTotalMarksClassTest = 0;
            } else {
                if ($termExamMarksPercentageSum <= 0) {
                    $obtainTotalMarksTermExam = $termExamObtainedTotalMarksSum;
                    $obtainTotalMarksClassTest = $classTestObtainedTotalMarksSum;
                } else {
                    $obtainTotalMarksTermExam = ($termExamObtainedTotalMarksSum * $termExamMarksPercentageSum) / $termExamMarksSum;
                    $obtainTotalMarksClassTest = ($classTestObtainedTotalMarksSum * $classTestMarksPercentageSum) / $classTestMarksSum;
                }
            }

            $subjectTotalNumber = $obtainTotalMarksTermExam + $obtainTotalMarksClassTest;

            // Build final subject summary array
            $subjectSummary = [
                'total_marks_in_term_exam' => $termExamMarksSum,
                'total_marks_in_class_test' => $classTestMarksSum,
                'obtain_raw_total_marks_in_term_exam' => $termExamObtainedTotalMarksSum,
                'obtain_raw_total_marks_in_class_test' => $classTestObtainedTotalMarksSum,
                'obtain_total_marks_in_term_exam' => ceil($obtainTotalMarksTermExam),
                'obtain_total_marks_in_class_test' => $obtainTotalMarksClassTest,
                'obtain_total_marks_in_term_exam_for_show' => ceil($termExamObtainedForShow),
                'obtain_total_marks_in_class_test_for_show' => ceil($classTestObtainedForShow),
                'termexam_exam_held_status' => $termExamHeldStatus,
                'classtest_exam_held_status' => $classTestHeldStatus,
                'student_exam_subject_attendance_status' => $attendanceStatus,
                'subject_base_pass_fail_status' => $subjectBasePassFailStatus,
                'result_show_in_table_bellow' => $selectedSubject->result_show_in_table_bellow,
                'obtain_subject_total_marks' => ceil($subjectTotalNumber),
                'subject_code' => $selectedSubject->subject_code,
                'subject_name' => $selectedSubject->subject_name,
                'exam_dependent_academic_subject' => $selectedSubject->examDependentAcademicSubject->subject_name ?? null,
                'subject_exam_name_key' => $selectedSubject->academicSubjectClassExamCondition->name_key ?? null,
                'subject_exam_name' => $selectedSubject->academicSubjectClassExamCondition->name ?? null,
                'exam_dependent_academic_subject_id' => $selectedSubject->exam_dependent_academic_subject_id,
                'academic_subject_id' => $selectedSubject->academic_subject_id,
                'subject_position' => $selectedSubject->subject_position,
                'site_subject_group_condition_setting_id' => $subjectGroupId,
                'examination_list' => $examTypeSummaryCollection->sortBy('show_position')->values()->all(),
                'countable_subject_total' => $examTypeSummaryCollection->sum('countable_dependent_obtain_exam_type_marks_for_show'),
            ];

            // Optional academic subject status check
            if ($student_present_check && !empty($student_present_check->optional_subject_ids[0])) {
                $optionalSubject = collect($student_present_check->optional_subject_ids[0])
                    ->where('id', $selectedSubject->academic_subject_id)
                    ->first();
                $subjectSummary['optional_academic_subject_status'] = $optionalSubject ? 1 : 0;
            } else {
                $subjectSummary['optional_academic_subject_status'] = 0;
            }

            $subject_array[$key] = $subjectSummary;
        }

  
  
        $subject_group_by_array = collect($subject_array)
            ->groupBy('exam_dependent_academic_subject_id')
            ->values();

        $dependent_single_subject_array = [];
        $individual_combine_subject_entry = [];
        $stable_ids = [];

        foreach ($subject_group_by_array as $key => $groupedSubjects) {
            $combine_subject_present[] = count($groupedSubjects) > 1 ? 1 : 0;

            // Flatten all examinations inside this group
            $examination_list_array = $groupedSubjects
                ->flatMap(fn($subject) => $subject['examination_list'])
                ->all();

            $dependent_subject_array = [];

            // Handle multiple subjects combined
            if (count($groupedSubjects) > 1) {
                // Unique examination IDs in this dependent group
                $dependent_subject_examination_ids = collect($examination_list_array)
                    ->pluck('examination_id')
                    ->unique()
                    ->filter();

                $dependent_subject_arr = [];
                $dependent_subject_array = [];
                $examtype_array = [];

                foreach ($dependent_subject_examination_ids as $examinationId) {
                    $exam_setting = $resultSettingList->where('examination_id', $examinationId)->first();

                    $only_dependent_subject_lists = collect($examination_list_array)
                        ->where('examination_id', $examinationId);

                    // Extract all exam types for this examination
                    $exam_type_list_array = $only_dependent_subject_lists
                        ->flatMap(fn($exam) => $exam['exam_type_list'])
                        ->filter(fn($examType) => $examType['exam_exist_status'])
                        ->values();

                    // Unique exam type IDs
                    $only_dependent_subject_exam_type_ids = $exam_type_list_array
                        ->pluck('academic_exam_type_id')
                        ->unique()
                        ->filter();

                    $examtype_array = [];
                    foreach ($only_dependent_subject_exam_type_ids as $examTypeId) {
                        $examTypeGroup = $exam_type_list_array
                            ->where('academic_exam_type_id', $examTypeId);

                        $sum_marks = $examTypeGroup->sum('subject_exam_type_mark');
                        $sum_pass_mark = $examTypeGroup->sum('pass_mark');
                        $sum_obtained_marks = $examTypeGroup->sum('obtaine_marks');
                        $pass_fail_count = $examTypeGroup->where('primary_pass_fail_status', 1)->count();

                        $examTypeName = $examTypeGroup->first()['academic_exam_type_name'] ?? '';

                        // Pass/fail status for this exam type
                        $pass_fail_status = $examTypeGroup->count() === $pass_fail_count ? 1 : 0;

                        $examtype_array[] = [
                            'examination_id' => $examinationId,
                            'academic_exam_type_id' => $examTypeId,
                            'academic_exam_type_name' => $examTypeName,
                            'pass_mark' => $sum_pass_mark,
                            'subject_exam_type_mark' => $sum_marks,
                            'obtaine_marks' => (int)ceil($sum_obtained_marks),
                            'primary_pass_fail_status' => $pass_fail_status,
                            'exam_held_status' => true, // assuming always true here
                        ];
                    }

                    $examtype_collection = collect($examtype_array)->where('examination_id', $examinationId);

                    $sum_marks = $examtype_collection->sum('subject_exam_type_mark');
                    $sum_pass_mark = $examtype_collection->sum('pass_mark');
                    $sum_obtained_marks = $examtype_collection->sum('obtaine_marks');
                    $sum_pass_fail = $examtype_collection->sum('primary_pass_fail_status');

                    // Sum of dependent obtain marks for show (per subject)
                    $sum_obtained_for_show_arr = [];
                    foreach ($groupedSubjects as $idx => $subject) {
                        $sum_obtained_for_show_arr[$idx] = collect($subject['examination_list'])
                            ->where('examination_id', $examinationId)
                            ->sum('countable_dependent_obtain_exam_type_marks_for_show');
                    }
                    $sum_obtained_for_show = array_sum($sum_obtained_for_show_arr);

                    // Calculate countable dependent obtain marks with percentage if applicable
                    $countable_dependent_obtain_marks = $exam_setting->marks_percentage
                        ? ($sum_obtained_marks * $exam_setting->marks_percentage) / 100
                        : $sum_obtained_marks;

                    // Exam held status check
                    $exam_held = collect($examination_list_array)
                        ->where('examination_id', $examinationId)
                        ->where('exam_held', 1)
                        ->first();
                    $exam_held_status = $exam_held ? $exam_held['exam_held'] : 0;

                    $dependent_subject_arr = [
                        'exam_held_status' => $exam_held_status,
                        'exam_type_list' => collect($examtype_array),
                        'examination_id' => $examinationId,
                        'examination_name' => $exam_setting->examination->examination_name ?? '',
                        'examination_marks' => $sum_marks,
                        'examination_name_key' => $only_dependent_subject_lists->first()['examination_name_key'] ?? '',
                        'examination_pass_marks' => $sum_pass_mark,
                        'marks_percentage' => $exam_setting->marks_percentage ?? 0,
                        'show_position' => $exam_setting->show_position ?? 0,
                        'obtaine_total_marks' => (int)ceil($sum_obtained_marks),
                        'subject_indivisual_pass_fail_status' => $sum_pass_fail === count($examtype_array) ? 1 : 0,
                        'countable_dependent_obtain_exam_type_marks' => (int)ceil($countable_dependent_obtain_marks),
                        'countable_dependent_obtain_exam_type_marks_for_show' => (int)ceil($sum_obtained_for_show),
                    ];

                    $dependent_subject_array[$examinationId] = $dependent_subject_arr;
                }
            } else {
                // Single subject - just take its examination list
                $dependent_subject_array = $groupedSubjects[0]['examination_list'];
            }

            // Average result_show_in_table_bellow for this group
            $result_show_sum = $groupedSubjects->sum('result_show_in_table_bellow');
            $result_show_status = ($result_show_sum / count($groupedSubjects)) > 0 ? 1 : 0;

            $dependentCollection = collect($dependent_subject_array);

            // Subject codes (concatenate if multiple)
            $subject_code = count($groupedSubjects) > 1
                ? $dependentCollection->pluck('subject_code')->unique()->filter()->implode(', ')
                : ($groupedSubjects[0]['subject_code'] ?? '');

            // Filter by termexam and classtest exams
            $termExam = $dependentCollection->where('examination_name_key', 'termexam');
            $classTest = $dependentCollection->where('examination_name_key', 'classtest');

            // Calculate sums
            $countable_term_marks = $termExam->sum('countable_dependent_obtain_exam_type_marks');
            $term_marks_percentage_sum = $termExam->sum('marks_percentage');
            $term_obtained_total = $termExam->sum('obtaine_total_marks');
            $term_obtained_show = $termExam->sum('countable_dependent_obtain_exam_type_marks_for_show');
            $term_exam_marks = $termExam->sum('examination_marks');
            $term_exam_pass_marks = $termExam->sum('examination_pass_marks');
            $term_pass_fail_status = $term_obtained_total >= $term_exam_pass_marks ? 1 : 0;

            $countable_class_test_marks = $classTest->sum('countable_dependent_obtain_exam_type_marks');
            $class_test_marks_percentage_sum = $classTest->where('countable_dependent_obtain_exam_type_marks', '>=', 0)->sum('marks_percentage');
            $class_test_exam_held_status = $classTest->where('exam_held_status', 1)->isNotEmpty() ? 1 : 0;
            $class_test_obtained_total = $classTest->sum('obtaine_total_marks');
            $class_test_obtained_show = $classTest->sum('obtaine_total_marks');
            $class_test_exam_marks = $classTest->sum('examination_marks');

            $exam_count = $dependentCollection->pluck('examination_id')->count();
            $indiv_pass_fail_sum = $dependentCollection->sum('subject_indivisual_pass_fail_status');
            $obtain_total_for_show = $dependentCollection->sum('obtaine_total_marks');

            // Calculations for total marks and pass/fail
        //   if ($dependent_classtest_obtaine_total_marks <= 0 && $class_test_exam_held_status == 0) {
        if ($class_test_obtained_total <= 0 && $class_test_exam_held_status == 0){

                $dependent_obtain_total_in_term = $term_exam_marks > 0
                    ? ($term_marks_percentage_sum > 0
                        ? ($countable_term_marks * 100) / $term_marks_percentage_sum
                        : $countable_term_marks)
                    : 0;
                $dependent_obtain_total_in_class_test = 0;

                $total_marks_in_term = $term_exam_marks;
                $total_marks_in_class_test = 0;
                $obtain_raw_term = $term_obtained_total;
                $obtain_raw_class_test = 0;
            } else {
                $rest_percentage = 100 - ($term_marks_percentage_sum + $class_test_marks_percentage_sum);
                $dependent_obtain_total_in_term = $term_exam_marks > 0
                    ? ($term_marks_percentage_sum > 0
                        ? ($countable_term_marks * ($rest_percentage + $term_marks_percentage_sum)) / $term_marks_percentage_sum
                        : $countable_term_marks)
                    : 0;

                $dependent_obtain_total_in_class_test = $countable_class_test_marks;
                $total_marks_in_term = $term_exam_marks;
                $total_marks_in_class_test = $class_test_exam_marks;
                $obtain_raw_term = (int)ceil($term_obtained_total);
                $obtain_raw_class_test = (int)ceil($class_test_obtained_total);
            }

            // Calculate final pass fail status
            $dependent_subject_base_pass_fail_status = $term_pass_fail_status && ($exam_count == $indiv_pass_fail_sum) ? 1 : 0;

            // Calculate total subject marks and grade
            $dependent_subject_total_number = $dependent_obtain_total_in_class_test > 0
                ? $dependent_obtain_total_in_term + $dependent_obtain_total_in_class_test
                : ($obtain_raw_term + $obtain_raw_class_test) * 100 / ($total_marks_in_term + $total_marks_in_class_test);

            $subject_grade_find = $dependent_subject_base_pass_fail_status
                ? $grade_list
                    ->where('number_from', '<=', ceil($dependent_subject_total_number))
                    ->where('number_to', '>=', ceil($dependent_subject_total_number))
                    ->first()
                : $grade_list
                    ->where('number_from', '<=', 0)
                    ->where('number_to', '>=', 0)
                    ->first();

            $first_subject = $groupedSubjects->first();

            // Compose dependent single subject array
            $dependent_single_subject_arr = [
                'exam_dependent_academic_subject_id' => $first_subject['exam_dependent_academic_subject_id'],
                'subject_position' => $first_subject['subject_position'],
                'exam_dependent_academic_subject' => $first_subject['exam_dependent_academic_subject'],
                'subject_code' => $subject_code,
                'dependent_optional_academic_subject_status' => collect($groupedSubjects)->pluck('optional_academic_subject_status')->unique()->filter()->count() > 0 ? 1 : 0,
                'subject_countable_point' => collect($groupedSubjects)->pluck('optional_academic_subject_status')->unique()->filter()->count() > 0
                    ? max(0, ($subject_grade_find->point ?? 0) - 2)
                    : ($subject_grade_find->point ?? 0),
                'result_show_in_table_bellow_status' => $result_show_status,
                'subject_base_pass_fail_status' => $subject_grade_find->pass_fail_status ?? 0,
                'obtain_subject_total_marks' => (int)floor($obtain_raw_term + $obtain_raw_class_test),
                'subject_marks_percentage' => (int)floor($dependent_subject_total_number),
                'subject_point' => $subject_grade_find->point ?? 0,
                'subject_grade' => $subject_grade_find->academicResultSystem->name ?? 0,
                'indivisual_student_subject_list' => $groupedSubjects,
                'subject_count' => count($groupedSubjects),
                'dependent_subject_list' => $dependentCollection->sortBy('show_position')->values()->all(),
                'obtain_total_marks_in_term_exam_for_show' => (int)ceil($term_obtained_show),
                'obtain_total_marks_in_class_test_for_show' => (int)ceil($class_test_obtained_show),
                'obtain_total_marks_for_show' => (int)ceil($obtain_total_for_show),
                'total_marks_in_term_exam' => $total_marks_in_term,
                'total_marks_in_class_test' => $total_marks_in_class_test,
                'obtain_raw_total_marks_in_term_exam' => (int)ceil($obtain_raw_term),
                'obtain_raw_total_marks_in_class_test' => (int)ceil($obtain_raw_class_test),
                'obtain_total_marks_in_term_exam' => (int)ceil(number_format((float)$dependent_obtain_total_in_term, 2, '.', '')),
                'obtain_total_marks_in_class_test' => (int)ceil(number_format((float)$dependent_obtain_total_in_class_test, 2, '.', '')),
                'obtain_raw_total_marks' => $obtain_raw_term + $obtain_raw_class_test,
                'obtain_percent_total_marks' => (int)ceil($dependent_obtain_total_in_term + $dependent_obtain_total_in_class_test),
                'raw_total_marks' => $total_marks_in_term + $total_marks_in_class_test,
            ];

            // Build tabulation list for UI display
            $tab_array = [];
            foreach ($groupedSubjects as $idx => $subject) {
                $tab_exam_array = [];
                foreach ($subject['examination_list'] as $exKey => $exam) {
                    $tab_exam_array[$exKey] = [
                        'exam_type_list' => $exam['exam_type_list'],
                        'examination_id' => $exam['examination_id'],
                        'examination_name' => $exam['examination_name'],
                        'obtaine_total_marks' => (int)ceil($exam['obtaine_total_marks']),
                        'examination_marks' => $exam['examination_marks'],
                        'countable_dependent_obtain_exam_type_marks' => $exam['countable_dependent_obtain_exam_type_marks'],
                    ];
                }

                $tab_array[$idx] = [
                    'countable_obtain_marks' => (int)ceil(collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks')),
                    'obtain_marks' => (int)ceil($subject['obtain_total_marks_in_term_exam'] + $subject['obtain_total_marks_in_class_test']),
                    'subject_name' => $subject['subject_name'],
                    'academic_subject_id' => $subject['academic_subject_id'],
                    'subject_base_pass_fail_status' => $subject['subject_base_pass_fail_status'],
                    'examination_list' => $tab_exam_array,
                ];
            }

            // Store tabulation list in dependent_single_subject_arr
            $dependent_single_subject_arr['list_for_tabulation'] = json_encode($tab_array);

            // Check for existing combine subject record
            $existingCombineSubject = $siteIndividualCombineSubjectStudentList
                ->where('student_history_id', $value)
                ->where('exam_dependent_academic_subject_id', $dependent_single_subject_arr['exam_dependent_academic_subject_id'])
                ->first();

            $student_exam_combine_subject_attendance_status = collect($groupedSubjects)
                ->where('student_exam_subject_attendance_status', true)
                ->isNotEmpty();

            if ($existingCombineSubject) {
                $stable_ids[] = $existingCombineSubject->id;

                // Update existing record
                $existingCombineSubject->update([
                    'subject_base_pass_fail_status' => $dependent_single_subject_arr['subject_base_pass_fail_status'],
                    'obtain_subject_total_marks' => $dependent_single_subject_arr['obtain_subject_total_marks'],
                    'subject_marks_percentage' => $dependent_single_subject_arr['subject_marks_percentage'],
                    'subject_grade' => $dependent_single_subject_arr['subject_grade'],
                    'subject_point' => $dependent_single_subject_arr['subject_point'],
                    'exam_attendance_status' => $student_exam_combine_subject_attendance_status,
                    'subject_position' => $dependent_single_subject_arr['subject_position'],
                    'subject_count' => $dependent_single_subject_arr['subject_count'],
                    'subject_detail' => json_encode($dependent_single_subject_arr),
                    'list_for_tabulation' => $dependent_single_subject_arr['list_for_tabulation'],
                    'result_show_in_table_bellow_status' => $dependent_single_subject_arr['result_show_in_table_bellow_status'],
                    'updated_at' => Carbon::today(),
                    'obtain_raw_total_marks' => (int)ceil($dependent_single_subject_arr['obtain_raw_total_marks']),
                    'raw_total_marks' => (int)ceil($dependent_single_subject_arr['raw_total_marks']),
                    'obtain_total_marks_for_show' => $dependent_single_subject_arr['obtain_total_marks_for_show'],
                    'obtain_percent_total_marks' => (int)ceil($dependent_single_subject_arr['obtain_total_marks_in_term_exam'] + $dependent_single_subject_arr['obtain_total_marks_in_class_test']),
                    'site_id' => $student_present_check->site_id,
                    'result_generated_by' => 'site_group',
                ]);
            } else {
                // Prepare insert array for batch insert later
                $individual_combine_subject_entry[] = [
                    'student_history_id' => $value,
                    'academic_result_primary_type_id' => $academic_result_primary_type_id,
                    'exam_dependent_academic_subject_id' => $dependent_single_subject_arr['exam_dependent_academic_subject_id'],
                    'optional_academic_subject_status' => $dependent_single_subject_arr['dependent_optional_academic_subject_status'],
                    'subject_base_pass_fail_status' => $dependent_single_subject_arr['subject_base_pass_fail_status'],
                    'obtain_subject_total_marks' => $dependent_single_subject_arr['obtain_subject_total_marks'],
                    'subject_marks_percentage' => $dependent_single_subject_arr['subject_marks_percentage'],
                    'subject_grade' => $dependent_single_subject_arr['subject_grade'],
                    'subject_point' => $dependent_single_subject_arr['subject_point'],
                    'exam_attendance_status' => $student_exam_combine_subject_attendance_status,
                    'subject_position' => $dependent_single_subject_arr['subject_position'],
                    'subject_count' => $dependent_single_subject_arr['subject_count'],
                    'subject_detail' => json_encode($dependent_single_subject_arr),
                    'list_for_tabulation' => $dependent_single_subject_arr['list_for_tabulation'],
                    'result_show_in_table_bellow_status' => $dependent_single_subject_arr['result_show_in_table_bellow_status'],
                    'created_at' => Carbon::today(),
                    'updated_at' => Carbon::today(),
                    'obtain_raw_total_marks' => (int)ceil($dependent_single_subject_arr['obtain_raw_total_marks']),
                    'raw_total_marks' => (int)ceil($dependent_single_subject_arr['raw_total_marks']),
                    'obtain_total_marks_for_show' => $dependent_single_subject_arr['obtain_total_marks_for_show'],
                    'obtain_percent_total_marks' => (int)ceil($dependent_single_subject_arr['obtain_total_marks_in_term_exam'] + $dependent_single_subject_arr['obtain_total_marks_in_class_test']),
                    'site_id' => $student_present_check->site_id,
                    'result_generated_by' => 'site_group',
                ];
            }
        }

        // After the loop ends, you can batch insert new entries if needed:
        if (count($individual_combine_subject_entry) > 0) {
            $siteIndividualCombineSubjectStudentList->insert($individual_combine_subject_entry);
        }


            $getlatestSubjectStoreCombineList = $siteIndividualCombineSubjectStudentList
                ->where('student_history_id', $value);


            $full_exam_attendance_list = $getlatestSubjectStoreCombineList->where('exam_attendance_status', true)->first();

            $checkFailSubject = $getlatestSubjectStoreCombineList->where('optional_academic_subject_status', false)
                        ->where('subject_base_pass_fail_status', false)
                        ->first();


            if ($full_exam_attendance_list) {
                $full_exam_attendance_list_status = true;
            } else {
                $full_exam_attendance_list_status = false;
            }

            if ($checkFailSubject) {
                $check_failed_subject_without_optional = false;
            } else {
                $check_failed_subject_without_optional = true;
            }

            $getlatestSubjectStoreCombineIDs = $getlatestSubjectStoreCombineList->pluck('id');

            //    dd($getlatestSubjectStoreCombineIDs);

            $subject_detail = [];
            $optional_subject_list = [];
            foreach ($getlatestSubjectStoreCombineList as $keyt => $valuet) {

                $subject_detail[] = $valuet->subject_detail;
                if ($valuet->optional_academic_subject_status == 1) {
                    $optional_subject_list[] = $valuet->exam_dependent_academic_subject_id;
                }
            }

            $subjectCollection = collect($subject_detail);

            $sum_of_obtain_total_marks_for_show = $subjectCollection->sum('obtain_total_marks_for_show');
            $sum_of_obtain_total_percent_for_show = $subjectCollection->avg('subject_marks_percentage');
            $sum_of_obtain_raw_total_marks = $subjectCollection->sum('obtain_raw_total_marks');
            $sum_of_obtain_percent_total_marks = $subjectCollection->sum('obtain_percent_total_marks');
            $sum_of_raw_total_marks = $subjectCollection->sum('raw_total_marks');

            $sum_of_total_point_with_optional = $subjectCollection->sum('subject_countable_point');

            $filteredCollection = $subjectCollection->where('dependent_optional_academic_subject_status', 0);

            $sum_of_total_point_without_optional = $filteredCollection->sum('subject_countable_point');
            $sum_of_total_countable_subject = $filteredCollection->count('exam_dependent_academic_subject_id');

            $failed_subject_count = $filteredCollection->where('subject_base_pass_fail_status',0)->count();

          //  dd($sum_of_total_countable_subject, $failed_subject_count,$filteredCollection);

            if($checkFailSubject){
                $student_final_point_with_optional= 0;
                $student_final_point_without_optional= 0;
            }else{
                if ($sum_of_total_countable_subject <= 0) {
                    $student_final_point_with_optional = 0;
                    $student_final_point_without_optional = 0;
                }else{
                    $student_final_point_with_optional = ($sum_of_total_point_with_optional / $sum_of_total_countable_subject) > 5 ? 5 : ($sum_of_total_point_with_optional / $sum_of_total_countable_subject);

                    $student_final_point_without_optional = $sum_of_total_point_without_optional / $sum_of_total_countable_subject ?? 1;
                }
            }

            $total_grade_find = collect($grade_list)
                ->where('point_from', '<=', $student_final_point_with_optional)
                ->Where('point_to', '>=', $student_final_point_with_optional)
                ->first();


            $total_grade_find_without_optional = $grade_list
                ->where('point_from', '<=', $student_final_point_without_optional)
                ->Where('point_to', '>=', $student_final_point_without_optional)
                ->first();

            $academic_primary_id_get = collect($resultSettingList)->first();

            $multiple_subject_present = collect($combine_subject_present)->unique()->filter();

            //=======================এইগুলো টেবিলে দিতে হবে।===================

            $sum_of_obtain_raw_total_marks_only_passed_subject = collect($subject_detail)
                ->where('subject_base_pass_fail_status', 1)
                ->sum('obtain_raw_total_marks');

            if ($sum_of_raw_total_marks <= 0) {
                $pass_subject_base_marks_percentage = 0;
                $total_marks_base_percentage = 0;
            } else {
                $pass_subject_base_marks_percentage = $sum_of_obtain_raw_total_marks_only_passed_subject * 100 /
                    $sum_of_raw_total_marks;

                $total_marks_base_percentage = $sum_of_obtain_raw_total_marks * 100 /
                    $sum_of_raw_total_marks;
            }

            $pass_subject_base_marks_grade = $grade_list
                ->where('number_from', '<=', ceil($pass_subject_base_marks_percentage))
                ->Where('number_to', '>=', ceil($pass_subject_base_marks_percentage))
                ->first();


            if ($total_marks_base_percentage > 100) {
                $total_marks_base_percentage = 100;
            }

            $total_marks_base_grade = $grade_list
                ->where('number_from', '<=', ceil($total_marks_base_percentage))
                ->Where('number_to', '>=', ceil($total_marks_base_percentage))
                ->first();

            //    dd($total_marks_base_grade);

            $pass_subject_base_marks_point = $pass_subject_base_marks_grade->point;

            $total_marks_base_point = $total_marks_base_grade->point;


            $student_list_arr['sum_of_obtain_raw_total_marks_only_passed_subject'] = ceil($sum_of_obtain_raw_total_marks_only_passed_subject);
            $student_list_arr['pass_subject_base_marks_percentage'] = $pass_subject_base_marks_percentage;
            $student_list_arr['total_marks_base_percentage'] = $total_marks_base_percentage;
            $student_list_arr['pass_subject_base_marks_grade'] = $pass_subject_base_marks_grade->academicResultSystem->name;
            $student_list_arr['total_marks_base_grade'] = $total_marks_base_grade->academicResultSystem->name;
            $student_list_arr['pass_subject_base_marks_point'] = $pass_subject_base_marks_point;
            $student_list_arr['total_marks_base_point'] = $total_marks_base_point;

            $student_list_arr['exam_attendance_status'] = $full_exam_attendance_list_status;

            $student_list_arr['fail_subject_count'] = $failed_subject_count;
            $student_list_arr['academic_result_primary_type_id'] = $academic_primary_id_get->academicResultPrimaryType->id;
            $student_list_arr['final_grade'] = $total_grade_find->academicResultSystem->name ?? null;

            $student_list_arr['final_point'] = number_format((float)$student_final_point_with_optional, 2, '.', '');

            $student_list_arr['student_history_id'] = $value;
            $student_list_arr['subject_list'] = $subject_detail;
            $student_list_arr['site_individual_combine_subject_result_store_ids'] = $getlatestSubjectStoreCombineIDs->toArray();


            $student_list_arr['final_grade_without_optional'] = $total_grade_find_without_optional->academicResultSystem->name ?? null;
            $student_list_arr['final_point_without_optional'] = number_format((float)$student_final_point_without_optional, 2, '.', '');
            $student_list_arr['optional_subject_ids'] = implode(',', $optional_subject_list);
            $student_list_arr['combine_subject_present'] = count($multiple_subject_present) >= 1 ? 1 : 0;
            $student_list_arr['classtest_is_present'] = $classtest_is_present;

            $student_list_arr['sum_of_obtain_total_marks_for_show'] = ceil($sum_of_obtain_total_marks_for_show);
            $student_list_arr['sum_of_obtain_total_percent_for_show'] = number_format((float)$sum_of_obtain_total_percent_for_show, 2, '.', '');

            $student_list_arr['sum_of_obtain_raw_total_marks'] = ceil($sum_of_obtain_raw_total_marks);
            $student_list_arr['sum_of_obtain_percent_total_marks'] = $sum_of_obtain_percent_total_marks;
            $student_list_arr['sum_of_raw_total_marks'] = $sum_of_raw_total_marks;
            $student_list_arr['site_id'] = $student_present_check->site_id;


            $student_list_array[$studentr_count] = array_merge($student_list_arr);
            $studentr_count++;

            //   }
        }

        return $student_list_array;
    }


    private function examTypePassFailStatus($studentMarksList)
    {

        $student_arr = array();
        $student_array = [];
        foreach ($studentMarksList as $key => $value) {

            if ($value['exam_held_status']) {

                if ($value['exam_attendance_status']) {

                    if ($value['obtaine_marks'] >= $value['pass_mark']) {

                        $student_arr['primary_pass_fail_status'] = 1;
                        $student_arr['exam_held'] = 1;
                    } else {
                        $student_arr['primary_pass_fail_status'] = 0;
                        $student_arr['exam_held'] = 1;
                    }
                } else {
                    $student_arr['primary_pass_fail_status'] = 0;
                    $student_arr['exam_held'] = 1;
                    $student_arr['is_countable_mark'] = 1;
                }
            } else {
                $student_arr['primary_pass_fail_status'] = 1;
                $student_arr['exam_held'] = 0;
            }

            $student_array[$key] = array_merge($student_arr, is_array($value) ? $value : $value->toArray());
        }

        return $student_array;
    }

        protected function processExamType(
            $examinationList,
            $academicExamType,
            $examId,
            $resultShowInTableBellow,
            $showTableBellowSubjectExamList = null
        ) {
            $examTypes = [];

            if (!$resultShowInTableBellow) {
                $usedAcademicExamTypeIds = $examinationList->pluck('academic_exam_type_id')->unique()->filter();
                $usedAcademicExamTypes = $academicExamType->whereIn('id', $usedAcademicExamTypeIds);
            } else {
                if (is_null($showTableBellowSubjectExamList)) {
                    return [];
                }
                $usedAcademicExamTypeIds = $showTableBellowSubjectExamList
                    ->where('examination_id', $examId)
                    ->pluck('academic_exam_type_id')
                    ->unique()
                    ->filter();
                $usedAcademicExamTypes = $academicExamType->whereIn('id', $usedAcademicExamTypeIds);
            }

       //     foreach ($usedAcademicExamTypes as $key => $academicExam) {
            foreach ($academicExamType as $key => $academicExam) {
                $examRecord = $examinationList
                    ->where('examination_id', $examId)
                    ->where('academic_exam_type_id', $academicExam->id)
                    ->first();

                $examTypes[$key] = $this->buildExamTypeArray($examRecord, $academicExam, $examId);
            }

            return $examTypes;
        }

        protected function buildExamTypeArray($examRecord, $academicExam, $examId)
        {
            if ($examRecord) {
                $countable = $examRecord['exam_type_countable_marks_status'];
                if ($countable) {
                    $obtainMarks = ($examRecord['exam_type_countable_persent_of_obtain_marks'] / 100) * $examRecord['obtaine_marks'];
                    $passMark = ($examRecord['exam_type_countable_persent_of_obtain_marks'] / 100) * $examRecord['pass_mark'];
                } else {
                    $obtainMarks = $examRecord['obtaine_marks'];
                    $passMark = $examRecord['pass_mark'];
                }

                return [
                    'academic_exam_type_id' => $academicExam->id,
                    'academic_exam_type_name' => $academicExam->marks_type,
                    'examination_id' => $examId,
                    'id' => $examRecord['id'],
                    'obtaine_marks' => ceil($obtainMarks),
                    'pass_mark' => ceil($passMark),
                    'primary_pass_fail_status' => $examRecord['primary_pass_fail_status'],
                    'site_subject_group_condition_setting_id' => $examRecord['site_subject_group_condition_setting_id'],
                    'student_history_id' => $examRecord['student_history_id'],
                    'subject_exam_type_mark' => $examRecord['subject_exam_type_mark'],
                    'exam_type_countable_marks' => $examRecord['exam_type_countable_marks'],
                    'exam_held_status' => $examRecord['exam_held_status'],
                    'exam_attendance_status' => $examRecord['exam_attendance_status'],
                    'exam_exist_status' => true,
                ];
            }

            // If no record found, default zeros/false values:
            return [
                'academic_exam_type_id' => $academicExam->id,
                'academic_exam_type_name' => $academicExam->marks_type,
                'examination_id' => $examId,
                'id' => 0,
                'obtaine_marks' => 0,
                'pass_mark' => 0,
                'primary_pass_fail_status' => 1,
                'site_subject_group_condition_setting_id' => 0,
                'student_history_id' => 0,
                'subject_exam_type_mark' => 0,
                'exam_exist_status' => false,
                'exam_held_status' => false,
                'exam_attendance_status' => false,
            ];
        }

        protected function calculateTotalObtainedMarks($examList)
        {
            $sum = 0;
            foreach ($examList as $exam) {
                if ($exam['exam_type_countable_marks_status']) {
                    $sum += $exam['countable_obtaine_marks'] ?? $exam['obtaine_marks'];
                } else {
                    $sum += $exam['obtaine_marks'];
                }
            }
            return $sum;
        }

        protected function calculateCountableDependentMarks($examinationList, $resultSettingList, $examSetting, $basePassFail, $totalObtainedMarks)
        {
            // Default fallback values
            $countableDependentMarks = $totalObtainedMarks;
            $countableDependentMarksForShow = $totalObtainedMarks;

            if (!$examSetting || !$basePassFail) {
                return [0, $countableDependentMarks, $countableDependentMarksForShow];
            }

            $examId = $examSetting->examination_id;

            $examTypeSum = $totalObtainedMarks;

            $examList = $examinationList->where('examination_id', $examId);

            $findTermExamUnheld = $examinationList->where('examination.name_key', 'termexam')->first();

            $findClassTestUnheldList = $examinationList
                ->where('examination.name_key', 'classtest')
                ->where('exam_held_status', true)
                ->pluck('examination_id')
                ->unique();

            $findClassTestUnheldPercentage = $resultSettingList
                ->where('examination.name_key', 'classtest')
                ->whereNotIn('examination_id', $findClassTestUnheldList)
                ->sum('marks_percentage');

            if (
                $findClassTestUnheldPercentage > 0 &&
                $findTermExamUnheld['examination_id'] == $examId
            ) {
                $classTestPercentageWithTermExam = $examSetting->marks_percentage + $findClassTestUnheldPercentage;
            } else {
                $classTestPercentageWithTermExam = $examSetting->marks_percentage;
            }

            if ($examSetting->marks_percentage && $basePassFail) {
                if ($examSetting->marks_percentage > $basePassFail->marks) {
                    $marksPercent = $classTestPercentageWithTermExam * ($basePassFail->marks ?: 1) / 100;
                    $countableDependentMarksForShow = $examTypeSum * $marksPercent / ($basePassFail->marks ?: 1);
                } else {
                    $countableDependentMarksForShow = $examTypeSum * $classTestPercentageWithTermExam / ($basePassFail->marks ?: 1);
                }
                $countableDependentMarks = $examTypeSum * $examSetting->marks_percentage / ($basePassFail->marks ?: 1);
            }

            return [$classTestPercentageWithTermExam, $countableDependentMarks, $countableDependentMarksForShow];
        }

}
