<?php

namespace App\Http\Controllers\SiteGroup\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\SiteGroup\Fee\SiteGroupFeeSubHeadAllocation;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;
use Response;

class SiteGroupFeeSettingController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }

    public function index()
    {
        $viewType = 'Site Group Fee Setting Page';

        return view('default.admin.site_group.fee.fee-setting', compact('viewType'));
    }



    public function getSiteGroupFeeHeadSubheadGroupList(){


        $siteGroupSettinglist=SiteGroupSetting::select('academic_fee_head_ids','academic_fee_group_ids', 'academic_fee_sub_head_ids')
            ->where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->first();


        $feeheadSplite = explode(',', $siteGroupSettinglist->academic_fee_head_ids);
        $feeheadList = AcademicFeeHead::whereIn('id', $feeheadSplite)->get();


        $feegroupSplite = explode(',', $siteGroupSettinglist->academic_fee_group_ids);
        $feegroupList = AcademicFeeGroup::whereIn('id', $feegroupSplite)->get();


        $feeSubHeadSplite = explode(',', $siteGroupSettinglist->academic_fee_sub_head_ids);
        $feeSubHeadList = AcademicFeeSubHead::whereIn('id', $feeSubHeadSplite)->get();



        $headArr=Array();
        $headArray=[];
        foreach ($feeheadList as $key => $value) {

            $groupArr=Array();
            $groupArray=[];
            foreach ($feegroupList as $keys => $values) {

                $groupArr['id']=$values->id;
                $groupArr['name']=$values->name;
                $groupArr['select_fee_group_id']=false;

                $subheadArr=Array();
                $subHeadArray=[];
                foreach ($feeSubHeadList as $keyst => $valuest) {
                    $subheadArr['select_fee_sub_head_id']=false;

                    $subHeadArray[$keyst]=array_merge($valuest->toArray(), $subheadArr);
                }

                $groupArr['fee_sub_head']=$subHeadArray;

                $groupArray[$keys]= array_merge($groupArr);
            }
            $headArr['fee_group']=$groupArray;
            $headArr['select_fee_head_id']=false;

            $headArray[$key]= array_merge($value->toArray(), $headArr);
        }


        return $headArray;

    }




    public function createUpdateFeeHeadGroupSubHead(Request $request){

        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');



        foreach ($request->FeeHeadSubHeadGroupList as $key => $value) {


            if($value['select_fee_head_id']){
                foreach ($value['fee_group'] as $keys => $values) {


                    if($values['select_fee_group_id']){

                        $subheadArr=Array();

                        foreach ($values['fee_sub_head'] as $keyst => $valuest) {
                            if($valuest['select_fee_sub_head_id']){
                                $subheadArr[$keyst]=$valuest['id'];


                            }
                        }
                        $subHeadIDs=implode(',', $subheadArr);

                        $charges[] = [
                            'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                            'academic_fee_head_id'=>$value['id'],
                            'academic_fee_group_id'=>$values['id'],
                            'academic_fee_sub_head_ids'=>$subHeadIDs,
                            'site_group_id'=>Session::get('SITE_GROUP_ID'),
                            'status'=>true,

                        ];


                        foreach ($siteIDs as $keysts => $valuests) {

                            $siteFeeHead=SiteFeeSubHeadAllocation::where('site_id',$valuests)
                                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                                ->where('academic_fee_head_id',$value['id'])
                                ->where('academic_fee_group_id',$values['id'])
                                ->get();

                            return $siteFeeHead;

//                            $chargest[] = [
//                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
//                                'academic_fee_head_id'=>$value['id'],
//                                'academic_fee_group_id'=>$values['id'],
//                                'academic_fee_sub_head_ids'=>$subHeadIDs,
//                                'site_group_id'=>Session::get('SITE_GROUP_ID'),
//                                'site_id'=>$valuests,
//                                'status'=>true,
//
//                            ];
                        }


                    }


                }
            }



        }

        if(count($charges)>0){
            SiteGroupFeeSubHeadAllocation::insert($charges);

            SiteFeeSubHeadAllocation::insert($chargest);
        }


        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);


    }




}
