<?php

namespace App\Http\Controllers\SiteGroup\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclares;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;

use Auth;
use Response;
use DB;
use Exception;
use Illuminate\Validation\Rules\Unique;
use Session;

class SiteGroupQuizRoomController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

    }

    public function getSiteGroupActiveQuizList(Request $request){
               
        $declared_quiz_list = SiteGroupQuizDeclares::with('quizDeclareSettings','quiz','siteInfo')
            ->withCount('quizDeclareStudents')
            ->withCount('presentStudent')
            ->orderBy('quiz_id')
            ->orderBy('id','ASC')
            ->paginate($request->paginate);

        return $declared_quiz_list;
  
    }



    public function getSiteGroupQuizEventStudentsInfo(Request $request){

       
       
        $activeQuizInfo = SiteGroupQuizDeclares::with(['quiz','quizDeclareSettings'])
                        ->withCount('quizDeclareStudents')
                      //  ->where('id', $request->quiz_declared_id)
                        ->groupBy('site_group_id','quiz_id')

                        ->first();
                  

            return response()->json($activeQuizInfo);
      
            
    }

    public function getSiteGroupPresentStudents($quiz_declare_id){

       $present_student_count = QuizDeclareStudents::where('quiz_declare_id', $quiz_declare_id)
                        ->where('join_status',1)
                        ->count();
         return response()->json($present_student_count);
    }

    public function quizStartByAdmin(Request $request){

        $active_quiz = QuizDeclareSettings::where('id', $request->quiz_declared_id)
                    ->update([
                        'is_start'=>1,
                      
                    ]);
            if($active_quiz){
                return response()->json(['message'=>'Quiz Start Succefully', 'mode'=>'success'],200);
            }
    }

     
}
