<?php

namespace App\Http\Controllers\SiteGroup\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\SiteGroup\Settings\SiteGroupShiftClassGroupSectionSettingStore;
use App\Models\SiteGroup\Settings\SiteGroupClassSessionSerialSettingsStore;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;

use Response;
use Session;
use Error;
use File;
use Exception; 

class SiteGroupAcademicSessionSectionClassSettingsController extends SiteGroupProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
      
    }

    public function index()
    {
        $viewType = "Site Group Subject Settings";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteGroupAcademicGroupBaseShiftYearVersion()
    {
        $SiteGroupSettingsStore = SiteGroupAcademicSettingsStore::select('shift_ids', 'academic_year_ids', 'academic_version_ids')
            ->first();
      //  dd($SiteGroupSettingsStore);
        $academicShift = explode(',', $SiteGroupSettingsStore->shift_ids);
        $academicShiftList = AcademicShift::whereIn('id', $academicShift)
            ->get();

        $academicVersionIDs = explode(',', $SiteGroupSettingsStore->academic_version_ids);
        $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

        $academicYear = explode(',', $SiteGroupSettingsStore->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('id','DESC')->get();

        return [$academicShiftList, $academicVersionList, $academicYearList];
    }

    
    public function getSiteGroupShiftClassGroupSectionList($shiftid, $yearid, $versionid)
    {

        try {
            if (!$shiftid || !$yearid || !$versionid) {
                return response()->json(['message' => 'Shift Or Year Or Version missing!'], 410);
            }

            $SiteGroupSettingsStore = SiteGroupAcademicSettingsStore::select('shift_ids', 'academic_class_ids', 'academic_class_group_ids',
                'academic_section_ids', 'academic_department_ids')
                ->first();
            $SiteGroupShiftClassGroupSectionTableData = SiteGroupShiftClassGroupSectionSettingStore::
            where('academic_shift_id', $shiftid)->where('academic_year_id', $yearid)
                ->where('academic_version_id', $versionid)
                ->get();

            //return $SiteGroupShiftClassGroupSectionTableData;


            $academicDepartment = explode(',', $SiteGroupSettingsStore->academic_department_ids);
            $academicDepartmentList = AcademicDepartment::select('id as department_id', 'name as department_name')
                ->whereIn('id', $academicDepartment)
                ->get();


            $academicClassGroup = explode(',', $SiteGroupSettingsStore->academic_class_group_ids);
            $academicClassGroupList = ClassGroup::select('id as group_id', 'group_name')
                ->whereIn('id', $academicClassGroup)
                ->get();


            if (count($academicDepartmentList) <= 0) {
                $academicclass = explode(',', $SiteGroupSettingsStore->academic_class_ids);
                $academicClassGroupPresentList = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 1)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

                $academicClassGroupAbsentList = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 0)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
            } else {
                $academicclass = explode(',', $SiteGroupSettingsStore->academic_class_ids);
                $academicClassGroupPresent = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 1)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

                $academicClassGroupAbsent = AcademicClass::select('id as class_id', 'class_name')
                    ->whereIn('id', $academicclass)
                    ->where('academic_group_present', 0)
                    ->orderBy('serial_no', 'ASC')
                    ->get();


                $academicClassGroupPresentListArray = [];
                foreach ($academicDepartmentList as $key => $value) {
                    $depArr1 = Array();
                    $deptArray1 = [];
                    foreach ($academicClassGroupPresent as $keys => $values) {
                        $depArr1['class_id'] = $values->class_id;
                        $depArr1['class_name'] = $values->class_name;
                        $deptArray1[$keys] = array_merge($value->toArray(), $depArr1);
                    }
                    $academicClassGroupPresentListArray[$key] = array_merge($deptArray1);
                }


                $test1 = collect($academicClassGroupPresentListArray);
                $academicClassGroupPresentList = $test1->collapse();

                $academicClassGroupAbsentListArray = [];
                foreach ($academicDepartmentList as $key => $value) {
                    $depArr = Array();
                    $deptArray = [];
                    foreach ($academicClassGroupAbsent as $keys => $values) {

                        $abc = $SiteGroupShiftClassGroupSectionTableData
                            ->where('academic_department_id', $value['department_id'])
                            ->where('academic_class_id', $values['class_id'])
                            ->first();

                        if ($abc) {
                            $depArr['department_checked'] = true;
                        } else {
                            $depArr['department_checked'] = false;
                        }


                        $depArr['class_id'] = $values->class_id;
                        $depArr['class_name'] = $values->class_name;

                        $depArr['seat_capacity'] = $abc['seat_capacity'];
                        $depArr['admission_seat_capacity'] = $abc['admission_seat_capacity'];
                        $depArr['seat_extend'] = $abc['seat_extend'];

                        $deptArray[$keys] = array_merge($value->toArray(), $depArr);
                    }

                    $academicClassGroupAbsentListArray[$key] = array_merge($deptArray);
                }

                $test2 = collect($academicClassGroupAbsentListArray);
                $academicClassGroupAbsentList = $test2->collapse();
            }


            $academicSection = explode(',', $SiteGroupSettingsStore->academic_section_ids);
            $academicSectionList = AcademicSection::select('id as section_id', 'section_name')
                ->whereIn('id', $academicSection)
                ->get();

            $classGroupArray = [];
            foreach ($academicClassGroupPresentList as $keys => $values) {
                $classArr = Array();
                $groupArray = [];

                foreach ($academicClassGroupList as $key => $value) {

                    $class_id = $values['class_id'] ? $values['class_id'] : $values->class_id;

                    $presentClassGroup = $SiteGroupShiftClassGroupSectionTableData
                        ->when(!empty($values['academic_department_id']), function ($query) use ($values) {
                            return $query->where('academic_department_id', $values['department_id']);
                        })
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $value->group_id)
                        ->first();
                    if ($values['department_id']) {
                        $presentDepartmentClassGroup = $SiteGroupShiftClassGroupSectionTableData
                            ->where('academic_department_id', $values['department_id'])
                            ->where('academic_class_id', $class_id)
                            ->where('academic_class_group_id', $value->group_id)
                            ->first();

                        if ($presentDepartmentClassGroup) {
                            if ($values['department_id'] == ($presentDepartmentClassGroup->academic_department_id)) {
                                $classArr['department_checked'] = true;
                            } else {
                                $classArr['department_checked'] = false;
                            }

                            if ($class_id == ($presentDepartmentClassGroup->academic_class_id)) {
                                $classArr['class_checked'] = true;
                            } else {
                                $classArr['class_checked'] = false;
                            }

                            if (($value->group_id) == ($presentDepartmentClassGroup->academic_class_group_id)) {
                                $classArr['group_checked'] = true;
                            } else {
                                $classArr['group_checked'] = false;
                            }

                        } else {
                            $classArr['department_checked'] = false;
                            $classArr['class_checked'] = false;
                            $classArr['group_checked'] = false;
                        }

//                        $classArr['seat_capacity'] = $presentClassGroup['seat_capacity'];
//                        $classArr['admission_seat_capacity'] = $presentClassGroup['admission_seat_capacity'];
//                        $classArr['seat_extend'] = $presentClassGroup['seat_extend'];


                    } else {

                        if ($presentClassGroup) {
                            if ($class_id == ($presentClassGroup->academic_class_id)) {
                                $classArr['class_checked'] = true;
                            } else {
                                $classArr['class_checked'] = false;
                            }

                            if (($value->group_id) == ($presentClassGroup->academic_class_group_id)) {
                                $classArr['group_checked'] = true;
                            } else {
                                $classArr['group_checked'] = false;
                            }
                        } else {
                            $classArr['class_checked'] = false;
                            $classArr['group_checked'] = false;
                        }

                    }

                    $classArr['seat_capacity'] = $presentClassGroup['seat_capacity'] ?? null;
                    $classArr['admission_seat_capacity'] = $presentClassGroup['admission_seat_capacity'] ?? null;
                    $classArr['seat_extend'] = $presentClassGroup['seat_extend'] ?? null;


                    $classArr['group_id'] = $value->group_id;
                    $classArr['group_name'] = $value->group_name;

                    if ($presentClassGroup) {

                        $checkedSection = explode(',', $presentClassGroup->academic_section_ids);
                        $findCheckedSectionName = $academicSectionList
                            ->whereIn('section_id', $checkedSection);

                        $findNonCheckedSectionName = $academicSectionList
                            ->whereNotIn('section_id', $checkedSection);

                        $checkSectionlist = Array();
                        $sectionArray = [];
                        if ($findCheckedSectionName) {

                            foreach ($findCheckedSectionName as $keyt => $valuet) {

                                if ($values['department_id']) {
                                    if ($presentClassGroup->academic_department_id == $values['department_id'] &&
                                        $class_id == ($presentClassGroup->academic_class_id)
                                        && ($value->group_id) == ($presentClassGroup->academic_class_group_id)
                                    ) {
                                        $checkSectionlist['section_checked'] = true;
                                    } else {
                                        $checkSectionlist['section_checked'] = false;
                                    }
                                } else {
                                    if ($class_id == ($presentClassGroup->academic_class_id)
                                        && ($value->group_id) == ($presentClassGroup->academic_class_group_id)
                                    ) {
                                        $checkSectionlist['section_checked'] = true;

                                    } else {
                                        $checkSectionlist['section_checked'] = false;
                                    }
                                }
                                $sectionArray[$keyt] = array_merge($valuet->toArray(), $checkSectionlist);
                            }

                            $ClassSectionAllList = array_merge($sectionArray,
                                $findNonCheckedSectionName->toArray());

                            $classArr['section_list'] = $ClassSectionAllList;

                        }

                    } else {
                        $classArr['section_list'] = $academicSectionList;
                    }

                    if (count($academicDepartmentList) <= 0) {
                        $groupArray[$key] = array_merge($values->toArray(), $classArr);
                    } else {
                        $groupArray[$key] = array_merge($values, $classArr);
                    }

                }
                $classGroupArray[$keys] = array_merge($groupArray);

            }

            $test = collect($classGroupArray);
            $groupBaseClassList = $test->collapse();

            $onlyClassSectionArray = [];
            foreach ($academicClassGroupAbsentList as $keys => $values) {

                $sclassArr = Array();
                $sgroupArray = [];
                $class_id = $values['class_id'] ? $values['class_id'] : $values->class_id;

                $OnlyClass = $SiteGroupShiftClassGroupSectionTableData
                    ->when(!empty($values['department_id']), function ($query) use ($values) {
                        return $query->where('academic_department_id', $values['department_id']);
                    })
                    ->where('academic_class_id', $class_id)
                    ->first();

                if ($OnlyClass) {
                    $sclassArr['class_checked'] = true;
                } else {
                    $sclassArr['class_checked'] = false;
                }

                $sclassArr['seat_capacity'] = $OnlyClass['seat_capacity'] ?? null;
                $sclassArr['admission_seat_capacity'] = $OnlyClass['admission_seat_capacity'] ?? null;
                $sclassArr['seat_extend'] = $OnlyClass['seat_extend'] ?? null;

                if (count($academicDepartmentList) <= 0) {
                    $sgroupArray[$keys] = array_merge($values->toArray(), $sclassArr);
                } else {
                    $sgroupArray[$keys] = array_merge($values, $sclassArr);
                }

                $stest = collect($sgroupArray);
                $onlyClassCheckList = $stest->collapse();

                $onlyClassSectionArr = [];
                if ($OnlyClass) {

                    $onlyCheckedSection = explode(',', $OnlyClass->academic_section_ids);
                    $onlyFindCheckedSectionName = $academicSectionList
                        ->whereIn('section_id', $onlyCheckedSection);

                    $onlyFindNonCheckedSectionName = $academicSectionList
                        ->whereNotIn('section_id', $onlyCheckedSection);

                    $onlyClassArr = Array();
                    $onlClassArrList = [];
                    if ($onlyFindCheckedSectionName) {
                        foreach ($onlyFindCheckedSectionName as $keyt => $valuet) {

                            if ($class_id == ($OnlyClass->academic_class_id)) {
                                $onlyClassArr['section_checked'] = true;
                                $onlClassArrList[$keyt] = array_merge($valuet->toArray(), $onlyClassArr);
                            }
                        }

                        $ClassSectionAllList = array_merge($onlClassArrList,
                            $onlyFindNonCheckedSectionName->toArray());
                        $onlyClassSectionArr['section_list'] = $ClassSectionAllList;

                    }

                } else {
                    $onlyClassSectionArr['section_list'] = $academicSectionList;
                }

                $onlyClassSectionArray[$keys] = array_merge($onlyClassCheckList->toArray(), $onlyClassSectionArr);
            }


            $academicClassGroupAllList = array_merge($onlyClassSectionArray, $groupBaseClassList->toArray());

            $countSection = count($academicSectionList);
            $countClassGroup = count($academicClassGroupList);
            $countDepartment = count($academicDepartmentList);

                 // existing site ids
            if (count($SiteGroupShiftClassGroupSectionTableData)) {
                $existing_site_ids = GlobalSiteShiftClassGroupSectionSetting::whereIn('site_id',$this->siteIds())
                    ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_shift_id', $shiftid)
                    ->where('academic_year_id', $yearid)
                    ->where('academic_version_id', $versionid)
                    ->where('status', true)
                    ->groupBy('site_id')
                    ->pluck('site_id');

                }else{
                    $existing_site_ids=[];
                }

            return [$academicClassGroupAllList, $countSection, $countClassGroup, $countDepartment, $existing_site_ids];

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }

    }

    public function siteGroupInsertUpdateShiftClassGroupSectionList(Request $request)
    {

        if (!$request->academic_shift_id || !$request->academic_year_id || !$request->academic_version_id) {
            return response()->json(['message' => 'Shift Or Year Or Version missing!'], 410);
        }

        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

      $siteGroupShiftBaseList = SiteGroupShiftClassGroupSectionSettingStore::where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->get();
        
        $count = 0;
        foreach ($request->FinalClassList as $key => $value) {

            $previousPresentdata = $siteGroupShiftBaseList
                ->when(!empty($value['academic_department_id']), function ($query) use ($value) {
                    return $query->where('academic_department_id', $value['academic_department_id']);
                })
                ->where('academic_class_id', $value['academic_class_id'])
                ->when(!empty($value['academic_class_group_id']), function ($query) use ($value) {
                    return $query->where('academic_class_group_id', $value['academic_class_group_id']);
                })
                ->first();

            if (!empty($value['academic_department_id']) && empty($previousPresentdata)) {
                if ($value['department_checked'] == true) {
                    if ($value['academic_class_group_id']) {
                        SiteGroupShiftClassGroupSectionSettingStore::create([
                            'academic_shift_id' => $request->academic_shift_id,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_class_group_id' => $value['academic_class_group_id'],
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'admission_seat_capacity' => $value['admission_seat_capacity'],
                            'seat_extend' => $value['seat_extend'],
                            'status' => true

                        ]);
                    } else {
                        SiteGroupShiftClassGroupSectionSettingStore::create([
                            'academic_shift_id' => $request->academic_shift_id,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_class_group_id' => null,
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'admission_seat_capacity' => $value['admission_seat_capacity'],
                            'seat_extend' => $value['seat_extend'],
                            'status' => true

                        ]);
                    }
                } else {
                    $count++;
                }
            } else if (!empty($value['academic_department_id']) && !empty($previousPresentdata)) {
                if ($value['department_checked'] == true) {
                    if ($value['academic_class_group_id']) {
                        $previousPresentDeptdata = $siteGroupShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->where('academic_class_group_id', $value['academic_class_group_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->update([
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);

                        } else {
                            $count++;
                        }
                    } else {
                        $previousPresentDeptdata = $siteGroupShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->update([
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);

                        } else {
                            $count++;
                        }
                    }
                } else {
                    if ($value['academic_class_group_id']) {
                        $previousPresentDeptdata = $siteGroupShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->where('academic_class_group_id', $value['academic_class_group_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->delete();
                        } else {
                            $count++;
                        }
                    } else {
                        $previousPresentDeptdata = $siteGroupShiftBaseList
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->first();
                        if ($previousPresentDeptdata) {
                            $previousPresentDeptdata->delete();

                        } else {
                            $count++;
                        }
                    }
                }

            } else {
                if ($value['academic_class_id'] != null && $value['academic_class_group_id'] != null) {
                    if ($previousPresentdata) {
                        if ($value['class_checked'] == true && $value['group_checked'] == true) {
                            if ($previousPresentdata->academic_class_id == $value['academic_class_id']
                                && $previousPresentdata->academic_class_group_id == $value['academic_class_group_id']
                            ) {
                                $previousPresentdata->update([
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);

                            } else {
                                SiteGroupShiftClassGroupSectionSettingStore::create([
                                    'academic_shift_id' => $request->academic_shift_id,
                                    'academic_year_id' => $request->academic_year_id,
                                    'academic_version_id' => $request->academic_version_id,
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_class_group_id' => $value['academic_class_group_id'],
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);
                            }

                        } else if ($value['class_checked'] == false) {
                            if ($previousPresentdata->academic_class_id == $value['academic_class_id']
                                && $previousPresentdata->academic_class_group_id == $value['academic_class_group_id']
                            ) {
                                $previousPresentdata->delete();
                            }
                        } else {
                            $count++;
                        }
                    } else {
                        if ($value['class_checked'] == true && $value['group_checked'] == true) {
                            SiteGroupShiftClassGroupSectionSettingStore::create([
                                'academic_shift_id' => $request->academic_shift_id,
                                'academic_year_id' => $request->academic_year_id,
                                'academic_version_id' => $request->academic_version_id,
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);

                        }
                    }

                } else if ($value['academic_class_id'] != null && $value['academic_class_group_id'] == null) {

                    $previousPresentClassdata = $siteGroupShiftBaseList
                        ->where('academic_class_id', $value['academic_class_id'])
                        ->where('academic_class_group_id', null)->first();
                    if ($previousPresentClassdata) {
                        if ($value['class_checked'] == true) {
                            if ($previousPresentClassdata->academic_class_id == $value['academic_class_id']) {
                                $previousPresentClassdata->update([
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);

                            } else {
                                SiteGroupShiftClassGroupSectionSettingStore::create([
                                    'academic_shift_id' => $request->academic_shift_id,
                                    'academic_year_id' => $request->academic_year_id,
                                    'academic_version_id' => $request->academic_version_id,
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);
                            }
                        } else if ($value['class_checked'] == false) {
                            if ($previousPresentClassdata->academic_class_id == $value['academic_class_id']) {
                                $previousPresentClassdata->delete();
                            } else {
                                $count++;
                            }
                        } else {
                            $count++;
                        }
                    } else {
                        if ($value['class_checked'] == true) {
                            SiteGroupShiftClassGroupSectionSettingStore::create([
                                'academic_shift_id' => $request->academic_shift_id,
                                'academic_year_id' => $request->academic_year_id,
                                'academic_version_id' => $request->academic_version_id,
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);
                            $count++;
                        }
                    }

                } else {
                    $count++;
                }

            }
       

            //==== site settings start====
            $siteShiftBaseList = GlobalSiteShiftClassGroupSectionSetting::where('academic_group_id', $academic_group_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->get();
       // foreach ($request->FinalClassList as $key => $value) {
         
            foreach($request->site_ids as $key=>$site_id){

                $sitePreviousPresentdata = $siteShiftBaseList
                ->when(!empty($value['academic_department_id']), function ($query) use ($value) {
                    return $query->where('academic_department_id', $value['academic_department_id']);
                })
                ->where('academic_class_id', $value['academic_class_id'])
                ->where('site_id', $site_id)
                ->when(!empty($value['academic_class_group_id']), function ($query) use ($value) {
                    return $query->where('academic_class_group_id', $value['academic_class_group_id']);
                })
                ->first();

            if (!empty($value['academic_department_id']) && empty($sitePreviousPresentdata)) {
                if ($value['department_checked'] == true) {
                    if ($value['academic_class_group_id']) {
                        GlobalSiteShiftClassGroupSectionSetting::create([
                            'site_id' => $site_id,
                            'academic_group_id' => $academic_group_id,
                            'academic_shift_id' => $request->academic_shift_id,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_class_group_id' => $value['academic_class_group_id'],
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'admission_seat_capacity' => $value['admission_seat_capacity'],
                            'seat_extend' => $value['seat_extend'],
                            'status' => true
                        ]);
                    } else {
                        GlobalSiteShiftClassGroupSectionSetting::create([
                            'site_id' => $site_id,
                            'academic_group_id' => $academic_group_id,
                            'academic_shift_id' => $request->academic_shift_id,
                            'academic_year_id' => $request->academic_year_id,
                            'academic_version_id' => $request->academic_version_id,
                            'academic_class_id' => $value['academic_class_id'],
                            'academic_department_id' => $value['academic_department_id'],
                            'academic_class_group_id' => null,
                            'academic_section_ids' => $value['academic_section_ids'],
                            'seat_capacity' => $value['seat_capacity'],
                            'admission_seat_capacity' => $value['admission_seat_capacity'],
                            'seat_extend' => $value['seat_extend'],
                            'status' => true
                        ]);
                    }
                }
            } else if (!empty($value['academic_department_id']) && !empty($sitePreviousPresentdata)) {
                if ($value['department_checked'] == true) {
                    if ($value['academic_class_group_id']) {
                        $sitePreviousPresentDeptdata = $siteShiftBaseList
                            ->where('site_id', $site_id)
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->where('academic_class_group_id', $value['academic_class_group_id'])
                            ->first();

                        if ($sitePreviousPresentDeptdata) {
                            $sitePreviousPresentDeptdata->update([
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);

                        } 
                    } else {
                        $sitePreviousPresentDeptdata = $siteShiftBaseList
                            ->where('site_id', $site_id)
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->first();
                        if ($sitePreviousPresentDeptdata) {
                            $sitePreviousPresentDeptdata->update([
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);

                        } 
                    }
                } else {
                    if ($value['academic_class_group_id']) {
                        $sitePreviousPresentDeptdata = $siteShiftBaseList
                            ->where('site_id', $site_id)
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->where('academic_class_group_id', $value['academic_class_group_id'])
                            ->first();
                        if ($sitePreviousPresentDeptdata) {
                            $sitePreviousPresentDeptdata->delete();
                        }
                    } else {
                        $sitePreviousPresentDeptdata = $siteShiftBaseList
                            ->where('site_id', $site_id)
                            ->where('academic_department_id', $value['academic_department_id'])
                            ->where('academic_class_id', $value['academic_class_id'])
                            ->first();
                        if ($sitePreviousPresentDeptdata) {
                            $sitePreviousPresentDeptdata->delete();
                        } 
                    }
                }

            } else {
                if ($value['academic_class_id'] != null && $value['academic_class_group_id'] != null) {
                    if ($sitePreviousPresentdata) {
                        if ($value['class_checked'] == true && $value['group_checked'] == true) {
                            if ($sitePreviousPresentdata->academic_class_id == $value['academic_class_id']
                                && $sitePreviousPresentdata->academic_class_group_id == $value['academic_class_group_id']
                            ) {
                                $sitePreviousPresentdata->update([
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);

                            } else {
                                GlobalSiteShiftClassGroupSectionSetting::create([
                                    'site_id' => $site_id,
                                    'academic_group_id' => $academic_group_id,
                                    'academic_shift_id' => $request->academic_shift_id,
                                    'academic_year_id' => $request->academic_year_id,
                                    'academic_version_id' => $request->academic_version_id,
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_class_group_id' => $value['academic_class_group_id'],
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);
                            }

                        } else if ($value['class_checked'] == false) {
                            if ($sitePreviousPresentdata->academic_class_id == $value['academic_class_id']
                                && $sitePreviousPresentdata->academic_class_group_id == $value['academic_class_group_id']
                            ) {
                                $sitePreviousPresentdata->delete();
                            }
                        }
                    } else {
                        if ($value['class_checked'] == true && $value['group_checked'] == true) {
                            GlobalSiteShiftClassGroupSectionSetting::create([
                                'site_id' => $site_id,
                                'academic_group_id' => $academic_group_id,
                                'academic_shift_id' => $request->academic_shift_id,
                                'academic_year_id' => $request->academic_year_id,
                                'academic_version_id' => $request->academic_version_id,
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_class_group_id' => $value['academic_class_group_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'status' => true
                            ]);

                        }
                    }

                } else if ($value['academic_class_id'] != null && $value['academic_class_group_id'] == null) {
                     
                    $sitePreviousPresentClassdata = $siteShiftBaseList
                        ->where('site_id', $site_id)
                        ->where('academic_class_id', $value['academic_class_id'])
                        ->where('academic_class_group_id', null)
                        ->first();
                      
                    if ($sitePreviousPresentClassdata) {
                        if ($value['class_checked'] == true) {
                            if ($sitePreviousPresentClassdata->academic_class_id == $value['academic_class_id']) {
                                $sitePreviousPresentClassdata->update([
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);

                            } else {
                                GlobalSiteShiftClassGroupSectionSetting::create([
                                    'site_id' => $site_id,
                                    'academic_group_id' => $academic_group_id,
                                    'academic_shift_id' => $request->academic_shift_id,
                                    'academic_year_id' => $request->academic_year_id,
                                    'academic_version_id' => $request->academic_version_id,
                                    'academic_class_id' => $value['academic_class_id'],
                                    'academic_section_ids' => $value['academic_section_ids'],
                                    'seat_capacity' => $value['seat_capacity'],
                                    'admission_seat_capacity' => $value['admission_seat_capacity'],
                                    'seat_extend' => $value['seat_extend'],
                                    'status' => true
                                ]);
                            }
                        } else if ($value['class_checked'] == false) {
                            if ($sitePreviousPresentClassdata->academic_class_id == $value['academic_class_id']) {
                                $sitePreviousPresentClassdata->delete();
                            }
                        } 
                    } else {
                       
                        if ($value['class_checked'] == true) {
                          $teste=  GlobalSiteShiftClassGroupSectionSetting::create([
                                'academic_group_id' => $academic_group_id,
                                'academic_shift_id' => $request->academic_shift_id,
                                'academic_year_id' => $request->academic_year_id,
                                'academic_version_id' => $request->academic_version_id,
                                'academic_class_id' => $value['academic_class_id'],
                                'academic_section_ids' => $value['academic_section_ids'],
                                'seat_capacity' => $value['seat_capacity'],
                                'admission_seat_capacity' => $value['admission_seat_capacity'],
                                'seat_extend' => $value['seat_extend'],
                                'site_id' => $site_id,
                                'status' => true
                            ]);
                          
                        }
                    }

                } 

            }
           }
         }


            //==== site settings end====

        return Response::json(['message' => $count . ' Information Save Successfully!', 'mode' => 'Saved!']);

    }


     ////========= Session Settings =======

     public function checkVersionYearShiftDept(array $data)
     {
 
         if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
             throw new Error("Please Select * Marked Fields!");
         }
 
         $get_section_class_group_detail = SiteGroupShiftClassGroupSectionSettingStore::
            where('academic_version_id', $data['academic_version_id'])
             ->where('academic_year_id', $data['academic_year_id'])
             ->where('academic_shift_id', $data['academic_shift_id'])
             /*  ->when($data['academic_department_id'], function ($query) use ($data) {
                   return $query->where('academic_department_id', $data['academic_department_id']);
               })*/
             ->first();
 
         if (!$get_section_class_group_detail) {
             throw new Error("No ShiftClassGroupSectionSetting Found! <a target='_blank' href='" . route('site-shift-class-group-section-setting-opening-page') . "'>Click Here</a>");
             //  return Response::json(['message' => 'No Class Found For The Year! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
         }
 
 
         if (!$data['academic_department_id'] && $get_section_class_group_detail->academic_department_id) {
             throw new Error("Please Select Department!");
         }
     }
    public function getSiteGroupAcademicClassListForSetSession(Request $request)
    {

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;

        $this->checkVersionYearShiftDept($data);

        $SiteGroupShiftClassGroupSection = SiteGroupShiftClassGroupSectionSettingStore::select('academic_class_id')
            ->groupBy('academic_class_id')
            ->get();

        $SiteGroupClassSessionSerialSetting = SiteGroupClassSessionSerialSettingsStore::
            where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->orderBy('serial_no', 'asc')
            ->get();

        $class_final_array = [];
        $serial_no = 1;
      //  $academic_session_ids = SiteInfoSetting::where('status', true)->first()->academic_session_ids  ?? '0';
        $academic_session_ids = SiteGroupAcademicSettingsStore::where('status', true)->first()->academic_session_ids  ?? '0';

        $academic_session = AcademicSession::whereIn('id', explode(',', $academic_session_ids))->orderBy('id', 'DESC')->get();

        foreach ($SiteGroupShiftClassGroupSection as $key => $value) {
            $existed = $SiteGroupClassSessionSerialSetting->where('academic_class_id', $value->academic_class_id)->first();

            $class_final_array[$key]['id'] = $existed->id ?? null;
            $class_final_array[$key]['batches'] = [];
            $class_final_array[$key]['sessions'] = $academic_session;
            $class_final_array[$key]['batch_ids'] = [];
            $class_final_array[$key]['session_ids'] = $existed ? ($existed->session_ids != '0' ? array_map('intval', explode(',', $existed->session_ids)) : []) : [];
            $class_final_array[$key]['academic_class_id'] = $value->academic_class_id;
            $class_final_array[$key]['class_name'] = $value->academicClass->class_name ?? '';
            $class_final_array[$key]['serial_number'] = $existed->serial_no ?? $serial_no;
            $class_final_array[$key]['session_present'] = ($existed->session_ids ?? null) ? true : false;
            $serial_no++;
        }
         // existing site ids
        if (count($SiteGroupClassSessionSerialSetting)) {
            $existing_site_ids = GlobalSiteClassSessionSerialSetting::whereIn('site_id',$this->siteIds())
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->groupBy('site_id')
                ->pluck('site_id');
            }else{
                $existing_site_ids=[];
            }

        return response()->json([$class_final_array, $existing_site_ids], 200);
    }

    public function createSiteGroupClassSessionSerial(Request $request)
    {
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        try {

            if (count($request->ClassList) < 1) {
                return Response::json(['message' => "No Class Selected!"], 412);
            }

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? 0 : $request->academic_department_id;

            $message = 'Not Saved Anything!';
            $mode = '';

            foreach ($request->ClassList as $key => $value) {
                
                $existed = (new SiteGroupClassSessionSerialSettingsStore())->where('id', $value['id'])->first();

                if ($existed) {
                    $existed->academic_version_id = $data['academic_version_id'];
                    $existed->academic_year_id = $data['academic_year_id'];
                    $existed->academic_shift_id = $data['academic_shift_id'];
                    $existed->academic_department_id = $data['academic_department_id'];
                    $existed->academic_class_id = $value['academic_class_id'];
                    $existed->session_present = count($value['session_ids']) ? 1 : 0;
                    $existed->serial_no = $value['serial_number'];
                    $existed->session_ids = count($value['session_ids']) ? implode(',', $value['session_ids']) : "0";
                    $existed->status = true;
                    $existed->save();
                    $message = 'Save Successfully!';
                    $mode = 'Saved';

                } else {
                    $new_data = (new SiteGroupClassSessionSerialSettingsStore());

                    $new_data->academic_version_id = $data['academic_version_id'];
                    $new_data->academic_year_id = $data['academic_year_id'];
                    $new_data->academic_shift_id = $data['academic_shift_id'];
                    $new_data->academic_department_id = $data['academic_department_id'];
                    $new_data->academic_class_id = $value['academic_class_id'];
                    $new_data->session_present = count($value['session_ids']) ? 1 : 0;
                    $new_data->serial_no = $value['serial_number'];
                    $new_data->session_ids = count($value['session_ids']) ? implode(',', $value['session_ids']) : "0";
                    $new_data->status = true;
                    $new_data->save();
                    $mode = 'Updated';
                    $message = 'Updated Successfully!';
                }

                foreach(array_unique($request->site_ids) as $key=>$site_id){
                $existed = (new GlobalSiteClassSessionSerialSetting())
                        ->where('academic_version_id', $data['academic_version_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('academic_shift_id', $data['academic_shift_id'])
                        ->where('site_id', $site_id)
                        ->first();

                if ($existed) {
                    $existed->academic_group_id = $academic_group_id;
                    $existed->site_id = $site_id;
                    $existed->academic_version_id = $data['academic_version_id'];
                    $existed->academic_year_id = $data['academic_year_id'];
                    $existed->academic_shift_id = $data['academic_shift_id'];
                    $existed->academic_department_id = $data['academic_department_id'];
                    $existed->academic_class_id = $value['academic_class_id'];
                    $existed->session_present = count($value['session_ids']) ? 1 : 0;
                    $existed->serial_no = $value['serial_number'];
                    $existed->session_ids = count($value['session_ids']) ? implode(',', $value['session_ids']) : "0";
                    $existed->status = true;
                    $existed->save();
                    $message = 'Save Successfully!';
                    $mode = 'Saved';
                } else {
                    $new_data = (new GlobalSiteClassSessionSerialSetting());
                    $new_data->academic_group_id = $academic_group_id;
                    $new_data->site_id = $site_id;
                    $new_data->academic_version_id = $data['academic_version_id'];
                    $new_data->academic_year_id = $data['academic_year_id'];
                    $new_data->academic_shift_id = $data['academic_shift_id'];
                    $new_data->academic_department_id = $data['academic_department_id'];
                    $new_data->academic_class_id = $value['academic_class_id'];
                    $new_data->session_present = count($value['session_ids']) ? 1 : 0;
                    $new_data->serial_no = $value['serial_number'];
                    $new_data->session_ids = count($value['session_ids']) ? implode(',', $value['session_ids']) : "0";
                    $new_data->status = true;
                    $new_data->save();
                    $mode = 'Updated';
                    $message = 'Updated Successfully!';
                }
                }
            }

            return Response::json(['message' => $message, 'mode' => $mode], 200);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 412);
        }
    }
}
