<?php

namespace App\Http\Controllers\SiteGroup;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicFiscalYear;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentOfferType;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicWaiverType;
use App\Models\Academic\GroupBaseDetail;
use App\Models\AcademicYear\AcademicYear;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Designation\Designation;
use App\Models\Examinations\Examination;
use App\Models\Gender\Gender;
use App\Models\Academic\SubjectCondition;
use App\Models\Religion\Religion;
use App\Models\SiteGroup\GlobalSiteGroup;
use Doctrine\DBAL\Exception\ConnectionException;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteGroupSetting;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use App\Models\Employee\EmpExamCommitteePosition;
use Response;


class SiteGroupSettingController extends Controller
{


    private $siteGroupSetting;

    public function __construct(SiteGroupSetting $siteGroupSetting)
    {
        $this->siteGroupSetting = $siteGroupSetting;
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Institution Group Setting List';
        return view('default.admin.site_group_setting.index', compact('viewType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return JsonResponse
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'academic_group_id' => 'required',
            'academic_class_ids' => 'required',
            'academic_subject_condition_ids' => 'required',
            'academic_subject_ids' => 'required',

        ]);

     //   $the_site_group_setting = GlobalSiteGroupSetting::where('id', $request->siteGroupSetting_id)->first();
        $the_site_group_setting = GlobalSiteGroupSetting::where('academic_group_id', $request->academic_group_id)
                                ->where('site_group_id', $request->site_group_id)
                                ->first();

        if($the_site_group_setting){
            $action='Update';
        }else{
            $the_site_group_setting = new GlobalSiteGroupSetting;
            $action='Save';
        }

   
            if (isset($the_site_group_setting->ownfields)) {
                foreach ($the_site_group_setting->ownfields as $ownField) {
    
                    if (is_array($request->{$ownField})) {
                        $the_site_group_setting->{$ownField} = implode(',', $request->{$ownField});
                    } else {
                        $the_site_group_setting->{$ownField} = $request->{$ownField};
                    }
                    $the_site_group_setting->status = 1;
                }
            }
    
            $the_site_group_setting->save();
    
            return Response::json(['message' => $action.' Successfully!', 'mode' => 'Saved!'], 200);
    
    }


    public function getGroupNameListFromSiteGroups($id)
    {
        try {

            $groupnameListFromSiteGroups = GlobalSiteGroup::findOrFail($id);

            $academicids = explode(',', $groupnameListFromSiteGroups->academic_group_ids);

            $academicGroup = AcademicGroup::whereIn('id', $academicids)->get();


            return [$academicGroup];

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'SiteGroup Not Found'], 410);

        } catch (ConnectionException $exception) {
            return JsonResponse::create(['message' => 'Database Connection Failed'], 410);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }

    public function getGroupSettingsList($academic_group_id, $site_group_id){
        try {
      
          //  $groupSetting = SiteGroupSetting::first();
            $groupSetting = GlobalSiteGroupSetting::
                where('site_group_id', $site_group_id)
                ->where('academic_group_id', $academic_group_id)
                ->first();
         
 
             if (!$groupSetting) {
                 return Response::json(['message' => 'No Site Group Setting Found! <a class="btn btn-xs btn-warning" target="_blank" href=" ' . route("site-group-list") . '" >Click<a/>'], 301);
             }
             $data = [];
           //  dd($groupSetting->ownfields);
 
             if ($groupSetting) {
                 foreach ($groupSetting->ownfields as $ownField) {
                     $data[$ownField] = array_map('intval', explode(',', $groupSetting->{$ownField}));
                 }
                 $data['id'] = $groupSetting->id;
 
             } else {
                 foreach ($groupSetting->ownfields as $ownField) {
                     $data[$ownField] = [];
                 }
             }
 
             return response()->json($data);
 
         } catch (Exception $exception) {
             return JsonResponse::create(['message' => $exception->getMessage()], 410);
         }
    }

    public function getDataByChangeAcademicGroup22($academic_group_id, $site_group_id)
    {
        try {


            $academic_detail = GroupBaseDetail::where('academic_group_id', $academic_group_id)->first();

            $academic_class = explode(',', $academic_detail->academic_class_ids);
            $academic_class_list = AcademicClass::select('id', 'class_name')->whereIn('id', $academic_class)->get();

            $academic_department = explode(',', $academic_detail->academic_department_ids);
            $academic_department_list = AcademicDepartment::select('id', 'name')->whereIn('id', $academic_department)->get();

            $academic_class_group = explode(',', $academic_detail->academic_class_group_ids);
            $academic_class_group_list = ClassGroup::select('id', 'group_name')->whereIn('id', $academic_class_group)->get();

            $academic_section = explode(',', $academic_detail->academic_section_ids);
            $academic_section_list = AcademicSection::select('id', 'section_name')->whereIn('id', $academic_section)->get();



            $academic_subject_condition = explode(',', $academic_detail->academic_subject_condition_ids);
            $academic_subject_condition_list = SubjectCondition::select('id', 'name')->whereIn('id', $academic_subject_condition)->get();

            $academic_subject = explode(',', $academic_detail->academic_subject_ids);
            $academic_subject_list = AcademicSubject::whereIn('id', $academic_subject)->get();

            $academic_session = explode(',', $academic_detail->academic_session_ids);
            $academic_session_list = AcademicSession::select('id', 'session_name', 'status')->whereIn('id', $academic_session)->get();


            $designation = explode(',', $academic_detail->designation_ids);
            $designation_list = Designation::select('id', 'name', 'status')->whereIn('id', $designation)->get();

            $academic_version_list = AcademicVersion::all();
            $academic_student_type_list = AcademicStudentType::all();
            $academic_student_category_list = AcademicStudentCategory::all();
            $academic_shift_list = AcademicShift::all();
            $academic_gender_list = Gender::all();

//            if (count($academic_version_list)<=0) {
//                return Response::json(['message' => 'No Version Found'], 301);
//            }

            $siteGroupSettingCheck = SiteGroupSetting::where([
                ['academic_group_id', $academic_group_id],
                ['site_group_id', $site_group_id]
            ])->first();


            //fee
            $academic_fee_head = AcademicFeeHead::get();
            $academic_fee_sub_head = AcademicFeeSubHead::get();
            $academic_fee_group = AcademicFeeGroup::get();
            $academic_waiver_types = AcademicWaiverType::get();
            $academic_student_offer_types = AcademicStudentOfferType::get();
            $academic_calendar_head = AcademicCalendarHead::get();
            $academic_leave_category = AcademicLeaveCategory::get();
            $academic_leave_type = AcademicLeaveType::get();
            $academic_year = AcademicYear::get();


            return [$academic_class_list,
                $academic_class_group_list,
                $academic_section_list,
                $academic_subject_condition_list,
                $academic_subject_list,
                $academic_session_list,
                $academic_version_list,
                $academic_student_type_list,
                $academic_student_category_list,
                $academic_shift_list,
                $academic_gender_list,
                $siteGroupSettingCheck,
                $academic_department_list,
                $designation_list,


                $academic_fee_head,
                $academic_fee_sub_head,
                $academic_fee_group,
                $academic_waiver_types,
                $academic_student_offer_types,
                $academic_calendar_head,
                $academic_leave_category,
                $academic_leave_type,
                $academic_year
            ];

        } catch (Exception $e) {
            return JsonResponse::create(['message' => 'Data not found for Academic Group Id: ' . $academic_group_id], 300);

        }
    }

    public function getDataByChangeAcademicGroup( $academic_group_id, $site_group_id)
    {
      // dd($site_group_id);

        try {

        $groupSetting = GroupBaseDetail::where('academic_group_id', $academic_group_id)->first();

            // $groupSetting = $this->siteGroupSetting
            //      ->where('site_group_id', $site_group_id)
            //     ->where('academic_group_id', $academic_group_id)
            //     ->first();


            if (!$groupSetting) {
                return Response::json(['message' => 'No Site Group Setting Found! <a class="btn btn-xs btn-warning" target="_blank" href=" ' . route("site-group-list") . '" >Click<a/>'], 301);
            }


            $academicClassList = [];
            if ($groupSetting->academic_class_ids) {
                $academicClass = explode(',', $groupSetting->academic_class_ids) ?? null;
                $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $academicClass)->get();
            }


            $academicDepartmentList = [];
            if ($groupSetting->academic_department_ids) {
                $academicDepartment = explode(',', $groupSetting->academic_department_ids) ?? null;
                $academicDepartmentList = AcademicDepartment::select('id', 'name')->whereIn('id', $academicDepartment)->get();
            }


            $academicClassGroupList = [];
            if ($groupSetting->academic_class_group_ids) {
                $academicClassGroup = explode(',', $groupSetting->academic_class_group_ids);
                $academicClassGroupList = ClassGroup::select('id', 'group_name')->whereIn('id', $academicClassGroup)->get();

            }


            $academicSectionList = [];
            if ($groupSetting->academic_section_ids) {
                $academicSection = explode(',', $groupSetting->academic_section_ids);
                $academicSectionList = AcademicSection::select('id', 'section_name')->whereIn('id', $academicSection)->get();
            }


//            $academicYearList = [];
//            if ($groupSetting->academic_year_ids) {
//                $academicYear = explode(',', $groupSetting->academic_year_ids);
//                $academicYearList = AcademicYear::select('id', 'year_name')->whereIn('id', $academicYear)->get();
//            }


            $academicSubjectConditionList = [];
            if ($groupSetting->academic_subject_condition_ids) {
                $academicSubjectCondition = explode(',', $groupSetting->academic_subject_condition_ids);
                $academicSubjectConditionList = SubjectCondition::select('id', 'name')->whereIn('id', $academicSubjectCondition)->get();


            }
            if (count($academicSubjectConditionList) <= 0) {
                return Response::json(['message' => 'No Subject Condition Found For The Group Type'], 301);
            }


            $genderList = Gender::select('id')->get();
            $shiftList = AcademicShift::select('id')->get();

            if (count($genderList) <= 0 || count($shiftList) <= 0) {
                return Response::json(['message' => 'No Gender or Shift Found!'], 301);
            }

            $academic_subject_from_group_setting = explode(',', $groupSetting->academic_subject_ids);

            $academicSubject = AcademicSubject::select('id')->whereIn('id', $academic_subject_from_group_setting)->get();


          //  $academicVersionList = [];
         //   if ($groupSetting->academic_version_ids) {
              //  $academicVersion = explode(',', $groupSetting->academic_version_ids) ?? null;
                $academicVersionList = AcademicVersion::select('id', 'version_name')
               // ->whereIn('id', $academicVersion)
                ->get();
         //   }

            //return $groupSetting->academic_version_ids;


            $academicSessionList = [];
            if ($groupSetting->academic_session_ids) {
                $academicSession = explode(',', $groupSetting->academic_session_ids) ?? null;
                $academicSessionList = AcademicSession::select('id', 'session_name')->whereIn('id', $academicSession)->get();
            }


            $academicStudentCategoryList = [];
            if ($groupSetting->student_category_ids) {
                $academicCategory = explode(',', $groupSetting->student_category_ids) ?? null;
                $academicStudentCategoryList = AcademicStudentCategory::select('id', 'category_name')->whereIn('id', $academicCategory)->get();
            }


            $designationList = [];
            if ($groupSetting->designation_ids) {
                $designation = explode(',', $groupSetting->designation_ids) ?? null;
                $designationList = Designation::select('id', 'name')->whereIn('id', $designation)->get();
            }
            $academicYearList = AcademicYear::get();


//fee

            $academic_fee_head = [];
            if ($groupSetting->academic_fee_head_ids) {
                $fee_head = explode(',', $groupSetting->academic_fee_head_ids) ?? null;
                $academic_fee_head = AcademicFeeHead::select('id', 'name')->whereIn('id', $fee_head)->get();
            }


            $academic_fee_sub_head = [];
           // if ($groupSetting->academic_fee_sub_head_ids) {
                $fee_sub_head = explode(',', $groupSetting->academic_fee_sub_head_ids) ?? null;
                $academic_fee_sub_head = AcademicFeeSubHead::select('id', 'name')
               // ->whereIn('id', $fee_sub_head)
                ->get();
          //  }


            $academic_fee_group = [];
           // if ($groupSetting->academic_fee_group_ids) {
                $fee_group = explode(',', $groupSetting->academic_fee_group_ids) ?? null;
                $academic_fee_group = AcademicFeeGroup::select('id', 'name')
                //->whereIn('id', $fee_group)
                ->get();
           // }


            $academic_waiver_types = [];
           // if ($groupSetting->academic_waiver_type_ids) {
                $waiver_type = explode(',', $groupSetting->academic_waiver_type_ids) ?? null;
                $academic_waiver_types = AcademicWaiverType::select('id', 'name')
                //->whereIn('id', $waiver_type)
                ->get();
          //  }


            $academic_student_offer_types = [];
           // if ($groupSetting->academic_student_offer_type_ids) {
                $student_offer_type = explode(',', $groupSetting->academic_student_offer_type_ids) ?? null;
                $academic_student_offer_types = AcademicStudentOfferType::select('id', 'name')
                //->whereIn('id', $student_offer_type)
                ->get();
          //  }

//            $batch_present_status=$groupSetting->batch_present_status;


            $examinations = Examination::select('id', 'examination_name','use_key')->get();
            $academicStudentTypeList = AcademicStudentType::select('id', 'student_type_name')->get();
            $religionList = Religion::get();
            $academicResidenceList = AcademicResidence::select('id', 'residence_name')->get();
            $academicExamTypeList = AcademicExamType::select('id', 'marks_type')->get();
            $academicFiscalYearList = AcademicFiscalYear::select('id', 'year_name')->get();
            $academicLeaveTypeList = AcademicLeaveType::select('id', 'name')->get();
            $academicLeaveCategoryList = AcademicLeaveCategory::select('id', 'name')->get();
            $academicCalendarHeadList = AcademicCalendarHead::select('id', 'name')->get();
            $academicResultPrimaryTypeList = AcademicResultPrimaryType::select('id', 'name')->get();
            $academicResultCombineTypeList = AcademicResultCombineType::select('id', 'name')->get();
            $academicSubjectClassExamConditionList = AcademicSubjectClassExamCondition::select('id', 'name')->get();
            $admission_type_list = AcademicAdmissionType::select('id', 'admission_type_name')->get();
            $academicResultSystemList = AcademicResultSystem::select('id', 'name')->get();


            $data1 = [];
            $data1['academicDepartmentList'] = $academicDepartmentList;
            $data1['academicClassList'] = $academicClassList;
            $data1['academicClassGroupList'] = $academicClassGroupList;
            $data1['academicSectionList'] = $academicSectionList;
            $data1['academicSubjectConditionList'] = $academicSubjectConditionList;
            $data1['genderList'] = $genderList;
            $data1['ShiftList'] = $shiftList;
            $data1['academicSubject'] = $academicSubject;
            $data1['academicVersionList'] = $academicVersionList;
            $data1['academicSessionList'] = $academicSessionList;
            $data1['academicStudentCategoryList'] = $academicStudentCategoryList;
            $data1['academicYearList'] = $academicYearList;
            $data1['academicStudentTypeList'] = $academicStudentTypeList;
            $data1['religionList'] = $religionList;
            $data1['academicResidenceList'] = $academicResidenceList;
            $data1['designationList'] = $designationList;
            $data1['academic_fee_head'] = $academic_fee_head;
            $data1['academic_fee_sub_head'] = $academic_fee_sub_head;
            $data1['academic_fee_group'] = $academic_fee_group;
            $data1['academic_waiver_types'] = $academic_waiver_types;
            $data1['academic_student_offer_types'] = $academic_student_offer_types;
            $data1['examinations'] = $examinations;
            $data1['academicLeaveTypeList'] = $academicLeaveTypeList;
            $data1['academicFiscalYearList'] = $academicFiscalYearList;
            $data1['academicLeaveCategoryList'] = $academicLeaveCategoryList;
            $data1['academicExamTypeList'] = $academicExamTypeList;
            $data1['academicCalendarHeadList'] = $academicCalendarHeadList;
            $data1['academicResultCombineTypeList'] = $academicResultCombineTypeList;
            $data1['academicResultPrimaryTypeList'] = $academicResultPrimaryTypeList;
            $data1['academicSubjectClassExamConditionList'] = $academicSubjectClassExamConditionList;
            $data1['admission_type_list'] = $admission_type_list;
            $data1['academicResultSystemList'] = $academicResultSystemList;
//            $data1['batch_present_status'] = $batch_present_status;


            return response()->json($data1);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


    }

    public function getAllAcademicDataList($site_group_id, $academic_group_id)
    {

        try {

            $siteGroup=GroupBaseDetail::whereAcademicGroupId($academic_group_id)->first();

           
            $groupSetting = $this->siteGroupSetting
                ->where([
                    ['site_group_id', $site_group_id],
                    ['academic_group_id', $academic_group_id]
                ])->first();


            if (!$groupSetting) {
                return Response::json(['message' => 'No Site Group Setting Found! <a class="btn btn-xs btn-warning" target="_blank" href=" ' . route("site-group-list") . '" >Click<a/>'], 301);
            }


            $academicClassList = [];
            if ($groupSetting->academic_class_ids) {
                $academicClass = explode(',', $groupSetting->academic_class_ids) ?? null;
                $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $academicClass)->get();
            }


            $academicDepartmentList = [];
            if ($groupSetting->academic_department_ids) {
                $academicDepartment = explode(',', $groupSetting->academic_department_ids) ?? null;
                $academicDepartmentList = AcademicDepartment::select('id', 'name')->whereIn('id', $academicDepartment)->get();
            }


            $academicClassGroupList = [];
            if ($groupSetting->academic_class_group_ids) {
                $academicClassGroup = explode(',', $groupSetting->academic_class_group_ids);
                $academicClassGroupList = ClassGroup::select('id', 'group_name')->whereIn('id', $academicClassGroup)->get();

            }


            $academicSectionList = [];
            if ($groupSetting->academic_section_ids) {
                $academicSection = explode(',', $groupSetting->academic_section_ids);
                $academicSectionList = AcademicSection::select('id', 'section_name')->whereIn('id', $academicSection)->get();
            }


//            $academicYearList = [];
//            if ($groupSetting->academic_year_ids) {
//                $academicYear = explode(',', $groupSetting->academic_year_ids);
//                $academicYearList = AcademicYear::select('id', 'year_name')->whereIn('id', $academicYear)->get();
//            }


            $academicSubjectConditionList = [];
            if ($groupSetting->academic_subject_condition_ids) {
                $academicSubjectCondition = explode(',', $groupSetting->academic_subject_condition_ids);
                $academicSubjectConditionList = SubjectCondition::select('id', 'name')->whereIn('id', $academicSubjectCondition)->get();


            }
            if (count($academicSubjectConditionList) <= 0) {
                return Response::json(['message' => 'No Subject Condition Found For The Group Type'], 301);
            }


            $genderList = Gender::select('id')->get();
            $shiftList = AcademicShift::select('id')->get();

            if (count($genderList) <= 0 || count($shiftList) <= 0) {
                return Response::json(['message' => 'No Gender or Shift Found!'], 301);
            }

            $academic_subject_from_group_setting = explode(',', $groupSetting->academic_subject_ids);

            $academicSubject = AcademicSubject::select('id')->whereIn('id', $academic_subject_from_group_setting)->get();


            $academicVersionList = [];
            if ($groupSetting->academic_version_ids) {
                $academicVersion = explode(',', $groupSetting->academic_version_ids) ?? null;
                $academicVersionList = AcademicVersion::select('id', 'version_name')->whereIn('id', $academicVersion)->get();
            }

            //return $groupSetting->academic_version_ids;


            $academicSessionList = [];
            if ($groupSetting->academic_session_ids) {
                $academicSession = explode(',', $groupSetting->academic_session_ids) ?? null;
                $academicSessionList = AcademicSession::select('id', 'session_name')->whereIn('id', $academicSession)->get();
            }


            $academicStudentCategoryList = [];
           // if ($groupSetting->student_category_ids) {
                $academicCategory = explode(',', $groupSetting->student_category_ids) ?? null;
                $academicStudentCategoryList = AcademicStudentCategory::select('id', 'category_name')
                  //  ->whereIn('id', $academicCategory)
                    ->get();
           // }


            $designationList = [];
            if ($siteGroup->designation_ids) {
                $designation = explode(',', $siteGroup->designation_ids) ?? null;
                $designationList = Designation::select('id', 'name')->whereIn('id', $designation)->get();
            }
            $academicYearList = AcademicYear::get();


//fee

            $academic_fee_head = [];
           // if ($groupSetting->academic_fee_head_ids) {
                $fee_head = explode(',', $groupSetting->academic_fee_head_ids) ?? null;
                $academic_fee_head = AcademicFeeHead::select('id', 'name')
                //->whereIn('id', $fee_head)
                ->get();
          //  }


            $academic_fee_sub_head = [];
           // if ($groupSetting->academic_fee_sub_head_ids) {
                $fee_sub_head = explode(',', $groupSetting->academic_fee_sub_head_ids) ?? null;
                $academic_fee_sub_head = AcademicFeeSubHead::select('id', 'name')
                  //  ->whereIn('id', $fee_sub_head)
                    ->get();
          //  }


            $academic_fee_group = [];
            if ($groupSetting->academic_fee_group_ids) {
                $fee_group = explode(',', $groupSetting->academic_fee_group_ids) ?? null;
                $academic_fee_group = AcademicFeeGroup::select('id', 'name')->whereIn('id', $fee_group)->get();
            }


            $academic_waiver_types = [];
            if ($groupSetting->academic_waiver_type_ids) {
                $waiver_type = explode(',', $groupSetting->academic_waiver_type_ids) ?? null;
                $academic_waiver_types = AcademicWaiverType::select('id', 'name')->whereIn('id', $waiver_type)->get();
            }


            $academic_student_offer_types = [];
            if ($groupSetting->academic_student_offer_type_ids) {
                $student_offer_type = explode(',', $groupSetting->academic_student_offer_type_ids) ?? null;
                $academic_student_offer_types = AcademicStudentOfferType::select('id', 'name')->whereIn('id', $student_offer_type)->get();
            }

//            $batch_present_status=$groupSetting->batch_present_status;


            $examinations = Examination::select('id', 'examination_name','use_key')->where('use_key','site')->get();
            $academicStudentTypeList = AcademicStudentType::select('id', 'student_type_name')->get();
            $religionList = Religion::get();
            $academicResidenceList = AcademicResidence::select('id', 'residence_name')->get();
            $academicExamTypeList = AcademicExamType::select('id', 'marks_type')->get();
            $academicFiscalYearList = AcademicFiscalYear::select('id', 'year_name')->get();
            $academicLeaveTypeList = AcademicLeaveType::select('id', 'name')->get();
            $academicLeaveCategoryList = AcademicLeaveCategory::select('id', 'name')->get();
            $academicCalendarHeadList = AcademicCalendarHead::select('id', 'name')->get();
            $academicResultPrimaryTypeList = AcademicResultPrimaryType::select('id', 'name')->get();
            $academicResultCombineTypeList = AcademicResultCombineType::select('id', 'name')->get();
            $academicSubjectClassExamConditionList = AcademicSubjectClassExamCondition::select('id', 'name')->get();
            $admission_type_list = AcademicAdmissionType::select('id', 'admission_type_name')->get();
            $academicResultSystemList = AcademicResultSystem::select('id', 'name')->get();
            $empExamCommitteePosition = EmpExamCommitteePosition::select('id', 'name')->get();


            $data1 = [];
            $data1['academicDepartmentList'] = $academicDepartmentList;
            $data1['academicClassList'] = $academicClassList;
            $data1['academicClassGroupList'] = $academicClassGroupList;
            $data1['academicSectionList'] = $academicSectionList;
            $data1['academicSubjectConditionList'] = $academicSubjectConditionList;
            $data1['genderList'] = $genderList;
            $data1['ShiftList'] = $shiftList;
            $data1['academicSubject'] = $academicSubject;
            $data1['academicVersionList'] = $academicVersionList;
            $data1['academicSessionList'] = $academicSessionList;
            $data1['academicStudentCategoryList'] = $academicStudentCategoryList;
            $data1['academicYearList'] = $academicYearList;
            $data1['academicStudentTypeList'] = $academicStudentTypeList;
            $data1['religionList'] = $religionList;
            $data1['academicResidenceList'] = $academicResidenceList;
            $data1['designationList'] = $designationList;
            $data1['academic_fee_head'] = $academic_fee_head;
            $data1['academic_fee_sub_head'] = $academic_fee_sub_head;
            $data1['academic_fee_group'] = $academic_fee_group;
            $data1['academic_waiver_types'] = $academic_waiver_types;
            $data1['academic_student_offer_types'] = $academic_student_offer_types;
            $data1['examinations'] = $examinations;
            $data1['academicLeaveTypeList'] = $academicLeaveTypeList;
            $data1['academicFiscalYearList'] = $academicFiscalYearList;
            $data1['academicLeaveCategoryList'] = $academicLeaveCategoryList;
            $data1['academicExamTypeList'] = $academicExamTypeList;
            $data1['academicCalendarHeadList'] = $academicCalendarHeadList;
            $data1['academicResultCombineTypeList'] = $academicResultCombineTypeList;
            $data1['academicResultPrimaryTypeList'] = $academicResultPrimaryTypeList;
            $data1['academicSubjectClassExamConditionList'] = $academicSubjectClassExamConditionList;
            $data1['admission_type_list'] = $admission_type_list;
            $data1['academicResultSystemList'] = $academicResultSystemList;
            $data1['empExamCommitteePosition'] = $empExamCommitteePosition;
//            $data1['batch_present_status'] = $batch_present_status;


            return response()->json($data1);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


    }



}