<?php

namespace App\Http\Controllers\SiteGroup;

use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SIte\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class SiteGroupVersionYearShiftDeptClassGroupController extends SiteGroupProjectController
{

    public function __construct()
    {
        $this->middleware('auth');
//        $this->middleware('sitepagechecker');
    }


    /**
     *
     */



    public function getSiteGroupYearMonthtLoad(){


        $site_group_id=Session::get('SITE_GROUP_ID');

        $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');

        $siteGroupYear=GlobalSiteShiftClassGroupSectionSetting::with('academicYear')
            ->whereIn('site_id',$siteIDs)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_year_id')
            ->select('academic_year_id')
            ->orderBy('academic_year_id','DESC')
            ->get();

         $months = [
                1 => 'January',
                2 => 'February',
                3 => 'March',4 => 'April',5 => 'May',6 => 'June',7 => 'July',8 => 'August',9 => 'September',10 => 'October',11 => 'November',12 => 'December'
            ];


        return response()->json([
            'siteGroupYear' => $siteGroupYear,
            'months'=>$months,
        ],200);

    }
    public function getSiteGroupVersionYearShiftLoad(){

        $site_group_id=Session::get('SITE_GROUP_ID');

        $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');


        $siteGroupVersion=GlobalSiteShiftClassGroupSectionSetting::with(['academicVersion'])
            ->whereIn('site_id',$siteIDs)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_version_id')
            ->select('academic_version_id')
            ->get();


        $siteGroupYear=GlobalSiteShiftClassGroupSectionSetting::with('academicYear')
            ->whereIn('site_id',$siteIDs)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_year_id')
            ->select('academic_year_id')
            ->orderBy('academic_year_id','DESC')
            ->get();


        $siteGroupShift=GlobalSiteShiftClassGroupSectionSetting::with(['academicShift'])
            ->whereIn('site_id',$siteIDs)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_shift_id')
            ->select('academic_shift_id')
            ->get();



        return [$siteGroupVersion, $siteGroupYear, $siteGroupShift];

    }










    public function getSiteGroupVersionYearShiftBaseDepartmentClass($version_id, $year_id, $shift_id)
    {

        $site_group_id=Session::get('SITE_GROUP_ID');

        $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');


        $academicDepartmentList=GlobalSiteShiftClassGroupSectionSetting::with(['academicDepartment'])
            ->whereIn('site_id',$siteIDs)
            ->where('academic_version_id',$version_id)
            ->where('academic_year_id',$year_id)
            ->where('academic_shift_id',$shift_id)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->whereNotNull('academic_department_id')
            ->distinct()
            ->get(['academic_department_id']);


        $academicClassList=[];
        if(count($academicDepartmentList)<=0){
            $academicClassList=GlobalSiteShiftClassGroupSectionSetting::with(['academicClass'])
                ->whereIn('site_id',$siteIDs)
                ->where('academic_version_id',$version_id)
                ->where('academic_year_id',$year_id)
                ->where('academic_shift_id',$shift_id)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->whereNotNull('academic_class_id')
                ->distinct()
                ->get(['academic_class_id']);
        }


        return [$academicClassList, $academicDepartmentList];
    }


    public function getSiteGroupVersionYearBaseDepartmentClass($version_id, $year_id){

        $site_group_id=Session::get('SITE_GROUP_ID');

        $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');


        $academicDepartmentList=GlobalSiteShiftClassGroupSectionSetting::with(['academicDepartment'])
            ->whereIn('site_id',$siteIDs)
            ->where('academic_version_id',$version_id)
            ->where('academic_year_id',$year_id)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->whereNotNull('academic_department_id')
            ->distinct()
            ->get(['academic_department_id']);


        $academicClassList=[];
        if(count($academicDepartmentList)<=0){
            $academicClassList=GlobalSiteShiftClassGroupSectionSetting::with(['academicClass'])
                ->whereIn('site_id',$siteIDs)
                ->where('academic_version_id',$version_id)
                ->where('academic_year_id',$year_id)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->whereNotNull('academic_class_id')
                ->distinct()
                ->get(['academic_class_id']);
        }


        return [$academicClassList, $academicDepartmentList];
    }




    public function getSiteGroupDepartmentBaseClassList($department_id){

        $site_group_id=Session::get('SITE_GROUP_ID');

        $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');


        $academicClassList=GlobalSiteShiftClassGroupSectionSetting::with(['academicClass'])
            ->whereIn('site_id',$siteIDs)
            ->where('academic_department_id',$department_id)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->whereNotNull('academic_class_id')
            ->distinct()
            ->get(['academic_class_id']);

        return $academicClassList;

    }




    public function getSiteGroupClassBaseGroupSession(Request $request){


         $site_group_id=Session::get('SITE_GROUP_ID');

        // $siteid=SiteInfo::where('site_group_id',$site_group_id)->pluck('id');
        // $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
        //     ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');

        $siteIDs=$this->siteIds();

        //session list

        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::whereIn('site_id', $siteIDs)
            ->where('academic_class_id', $request->academic_class_id)
            ->distinct()
            ->get(['academic_class_id', 'session_present']);


        $Sessionlist = [];
        if(count($sessionPresentCheck)==1){

            if ($sessionPresentCheck[0]->session_present) {
                $SitegroupTableData = SiteGroupSetting::where('site_group_id',$site_group_id)->first();
                $Sessionlistsplite = explode(',', $SitegroupTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            } else {
                $Sessionlist = [];
            }
        }else if(count($sessionPresentCheck)>1){
            $SitegroupTableData = SiteGroupSetting::where('site_group_id',$site_group_id)->first();
            $Sessionlistsplite = explode(',', $SitegroupTableData->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
        }



        //class group list

        $data = $request->all();

        $classGroupList = GlobalSiteShiftClassGroupSectionSetting::with(['academicClassGroup'])
            ->whereIn('site_id', $siteIDs)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->whereNotNull('academic_class_group_id')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $request->academic_class_id)
            ->distinct()
            ->get(['academic_class_group_id']);




        $SiteInfoSetting=GlobalSiteInfoSetting::whereIn('site_id', $siteIDs)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->get();


        //academic_student_category List
        $categoryIds=$SiteInfoSetting->pluck('academic_student_category_ids');
        $categoryStringIDs = implode(',', $categoryIds->toArray());
        $categoryIntegerIDs = array_unique(array_map('intval', explode(',', $categoryStringIDs)));
        $studentCategoryList=AcademicStudentCategory::whereIn('id', $categoryIntegerIDs)->get();



        //academic_student_category List
        $studentTypeIds=$SiteInfoSetting->pluck('academic_student_type_ids');
        $studentTypeStringIDs = implode(',', $studentTypeIds->toArray());
        $studentTypeIntegerIDs = array_unique(array_map('intval', explode(',', $studentTypeStringIDs)));
        $studentTypeList=AcademicStudentType::whereIn('id', $studentTypeIntegerIDs)->get();

        //academic_student_admission_type List
        $studentAdmissionList = AcademicAdmissionType::where('status', 1)->get();


        return [$classGroupList, $Sessionlist, $studentCategoryList, $studentTypeList, $studentAdmissionList];


    }


    /**
     *
     */
    public function getSiteGroupBaseSiteList(){

        $siteIDs=$this->siteIds();
        $siteList=GlobalSiteInfo::select('id')
            ->whereIn('id',$siteIDs)
            ->get();

        return $siteList;
    }








}
