<?php

namespace App\Http\Controllers\SiteGroup\Student;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use Error;
use Exception;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class SiteGroupStudentSubjectListController extends SiteGroupProjectController
{
    public $StudentAttendance;
    private $site, $GlobalStudentHistory;
    public function __construct(GlobalStudentHistory $GlobalStudentHistory)
    {
        $this->GlobalStudentHistory = $GlobalStudentHistory;
    }
    public function index()
    {
        $viewType = "Site Group Student List";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function SiteGroupwiseStudentSubjectListCount(Request $request)
    {

        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id          ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id           ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id        ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id          ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id        ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id        ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id            ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_class_group_id']              = $request->academic_class_group_id  ? $request->academic_class_group_id : null;
        $data['site_id']                              = $request->site_id           ? $request->site_id : null;


        if (!$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select Class, Shift, Year');
        }

        $s_List = [];
        $key = 0;

        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();

            $student_lists_for_single_site = $this->GlobalStudentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })

                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })

                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id', 'academic_subject_ids')
                ->with([
                    'student' => function ($query) {
                        $query->select('id');
                    }
                ])
                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->where('status', true)
                ->get();

            $SubjectCounts = [];

            foreach ($student_lists_for_single_site as $student) {
                if ($student->academic_subject_ids) {
                    foreach ($student->academic_subject_ids[0] as $subject) {
                        // Get the subject name
                        $subjectName = $subject->subject_name;

                        // Check if the subject exists in $SubjectCounts
                        $index = array_search($subjectName, array_column($SubjectCounts, 'subject_name'));

                        // If the subject exists, increment its count
                        if ($index !== false) {
                            $SubjectCounts[$index]['subject_count']++;
                        } else {
                            // If the subject doesn't exist, add it with count 1
                            $SubjectCounts[] = ['subject_name' => $subjectName, 'subject_count' => 1];
                        }
                    }
                }
            }

            $s_List[$key]['id']               = $site->id;
            $s_List[$key]['site_name']        = $site->site_name;
            $s_List[$key]['subjects']          = $SubjectCounts;
        } else {
            $siteLists = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->get();

            foreach ($siteLists as $site) {

                $student_lists = $this->GlobalStudentHistory
                    ->when($data['academic_version_id'], function ($query) use ($data) {
                        return $query->where('academic_version_id', $data['academic_version_id']);
                    })
                    ->when($data['academic_shift_id'], function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when($data['academic_year_id'], function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when($data['academic_class_id'], function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_category_id'], function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when($data['academic_student_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })

                    ->where('academic_group_id', $data['academic_group_id'])
                    ->select('id', 'user_id', 'academic_subject_ids')
                    ->with([
                        'student' => function ($query) {
                            $query->select('id');
                        }
                    ])

                    ->orderBy('student_roll_number')
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();

                $SubjectCounts = [];

                foreach ($student_lists as $student) {
                    if ($student->academic_subject_ids) {
                        foreach ($student->academic_subject_ids[0] as $subject) {
                            // Get the subject name
                            $subjectName = $subject->subject_name;

                            // Check if the subject exists in $SubjectCounts
                            $index = array_search($subjectName, array_column($SubjectCounts, 'subject_name'));

                            // If the subject exists, increment its count
                            if ($index !== false) {
                                $SubjectCounts[$index]['subject_count']++;
                            } else {
                                // If the subject doesn't exist, add it with count 1
                                $SubjectCounts[] = ['subject_name' => $subjectName, 'subject_count' => 1];
                            }
                        }
                    }
                }

                $s_List[$key]['id']               = $site->id;
                $s_List[$key]['site_name']        = $site->site_name;
                $s_List[$key]['subjects']         = $SubjectCounts;
                $key++;
            }
        }
        return response()->json($s_List);
    }
    public function SiteGroupwiseStudentOptionalSubjectListCount(Request $request)
    {

        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id          ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id           ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id        ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id          ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id        ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id        ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id            ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_class_group_id']              = $request->academic_class_group_id  ? $request->academic_class_group_id : null;
        $data['site_id']                              = $request->site_id           ? $request->site_id : null;


        if (!$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select Class, Shift, Year');
        }

        $s_List = [];
        $key = 0;

        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();

            $student_lists_for_single_site = $this->GlobalStudentHistory
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })

                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id', 'optional_subject_ids')
                ->with([
                    'student' => function ($query) {
                        $query->select('id');
                    }
                ])
                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->where('status', true)
                ->get();

            $SubjectCounts = [];

            foreach ($student_lists_for_single_site as $student) {
                if ($student->optional_subject_ids) {
                    foreach ($student->optional_subject_ids[0] as $subject) {
                        // Get the subject name
                        $subjectName = $subject->subject_name;

                        // Check if the subject exists in $SubjectCounts
                        $index = array_search($subjectName, array_column($SubjectCounts, 'subject_name'));

                        // If the subject exists, increment its count
                        if ($index !== false) {
                            $SubjectCounts[$index]['subject_count']++;
                        } else {
                            // If the subject doesn't exist, add it with count 1
                            $SubjectCounts[] = ['subject_name' => $subjectName, 'subject_count' => 1];
                        }
                    }
                }
            }

            $s_List[$key]['id']               = $site->id;
            $s_List[$key]['site_name']        = $site->site_name;
            $s_List[$key]['subjects']          = $SubjectCounts;
        } else {
            $siteLists = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->get();

            foreach ($siteLists as $site) {

                $student_lists = $this->GlobalStudentHistory
                    ->when($data['academic_year_id'], function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when($data['academic_class_id'], function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when($data['academic_version_id'], function ($query) use ($data) {
                        return $query->where('academic_version_id', $data['academic_version_id']);
                    })
                    ->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when($data['academic_shift_id'], function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_category_id'], function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when($data['academic_student_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })

                    ->where('academic_group_id', $data['academic_group_id'])
                    ->select('id', 'user_id', 'optional_subject_ids')
                    ->with([
                        'student' => function ($query) {
                            $query->select('id');
                        }
                    ])

                    ->orderBy('student_roll_number')
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();

                $SubjectCounts = [];

                foreach ($student_lists as $student) {
                    if ($student->optional_subject_ids) {
                        foreach ($student->optional_subject_ids[0] as $subject) {
                            // Get the subject name
                            $subjectName = $subject->subject_name;

                            // Check if the subject exists in $SubjectCounts
                            $index = array_search($subjectName, array_column($SubjectCounts, 'subject_name'));

                            // If the subject exists, increment its count
                            if ($index !== false) {
                                $SubjectCounts[$index]['subject_count']++;
                            } else {
                                // If the subject doesn't exist, add it with count 1
                                $SubjectCounts[] = ['subject_name' => $subjectName, 'subject_count' => 1];
                            }
                        }
                    }
                }

                $s_List[$key]['id']               = $site->id;
                $s_List[$key]['site_name']        = $site->site_name;
                $s_List[$key]['subjects']          = $SubjectCounts;
                $key++;
            }
        }
        return response()->json($s_List);
    }
    public function SiteGroupwiseStudentRiligionSubjectListCount(Request $request)
    {

        $paginate = $request->paginate ?? 20;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';


        $data = [];

        $data['academic_class_id']                    = $request->academic_class_id          ? $request->academic_class_id : null;
        $data['academic_year_id']                     = $request->academic_year_id           ? $request->academic_year_id : null;
        $data['academic_group_id']                    = session()->get('ACADEMIC_GROUP_ID')  ? session()->get('ACADEMIC_GROUP_ID') : null;
        $data['academic_version_id']                  = $request->academic_version_id        ? $request->academic_version_id : null;
        $data['academic_shift_id']                    = $request->academic_shift_id          ? $request->academic_shift_id : null;
        $data['academic_session_id']                  = $request->academic_session_id        ? $request->academic_session_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_student_category_id']         = $request->academic_student_category_id        ? $request->academic_student_category_id : null;
        $data['academic_student_type_id']             = $request->academic_student_type_id            ? $request->academic_student_type_id : null;
        $data['academic_student_admission_type_id']   = $request->academic_student_admission_type_id  ? $request->academic_student_admission_type_id : null;
        $data['academic_class_group_id']              = $request->academic_class_group_id  ? $request->academic_class_group_id : null;
        $data['site_id']                              = $request->site_id           ? $request->site_id : null;


        if (!$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select Class, Shift, Year');
        }

        $s_List = [];
        $key = 0;

        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();

            return  $student_lists_for_single_site = $this->GlobalStudentHistory
                ->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when($data['academic_student_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })

                ->where('academic_group_id', $data['academic_group_id'])
                ->select('id', 'user_id', 'religion_subject_id')
                ->with([
                    'student' => function ($query) {
                        $query->select('id', 'religion_subject_id');
                    }
                ])
                ->with(['religionSubject'])
                ->orderBy('student_roll_number')
                ->where('site_id', $data['site_id'])
                ->where('status', true)
                ->get();

            $SubjectCounts = [];

            foreach ($student_lists_for_single_site as $student) {
                if ($student->religion_subject_id) {
                    foreach ($student->religion_subject_id[0] as $subject) {
                        // Get the subject name
                        $subjectName = $subject->subject_name;

                        // Check if the subject exists in $SubjectCounts
                        $index = array_search($subjectName, array_column($SubjectCounts, 'subject_name'));

                        // If the subject exists, increment its count
                        if ($index !== false) {
                            $SubjectCounts[$index]['subject_count']++;
                        } else {
                            // If the subject doesn't exist, add it with count 1
                            $SubjectCounts[] = ['subject_name' => $subjectName, 'subject_count' => 1];
                        }
                    }
                }
            }

            $s_List[$key]['id']               = $site->id;
            $s_List[$key]['site_name']        = $site->site_name;
            $s_List[$key]['subjects']          = $SubjectCounts;
        } else {
            $siteLists = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->get();

            foreach ($siteLists as $site) {

                $student_lists = $this->GlobalStudentHistory
                    ->when($data['academic_year_id'], function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when($data['academic_class_id'], function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when($data['academic_version_id'], function ($query) use ($data) {
                        return $query->where('academic_version_id', $data['academic_version_id']);
                    })
                    ->when($data['academic_class_group_id'], function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when($data['academic_shift_id'], function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when($data['academic_session_id'], function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when($data['academic_student_category_id'], function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when($data['academic_student_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when($data['academic_student_admission_type_id'], function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })

                    ->where('academic_group_id', $data['academic_group_id'])
                    ->select('id', 'user_id', 'religion_subject_id')
                    ->with([
                        'student' => function ($query) {
                            $query->select('id');
                        }
                    ])
                    ->orderBy('student_roll_number')
                    ->where('site_id', $site->id)
                    ->where('status', true)
                    ->get();

                $SubjectCounts = [];

                foreach ($student_lists as $student) {
                    if ($student->religion_subject_id) {
                        foreach ($student->religion_subject_id[0] as $subject) {
                            // Get the subject name
                            $subjectName = $subject->subject_name;

                            // Check if the subject exists in $SubjectCounts
                            $index = array_search($subjectName, array_column($SubjectCounts, 'subject_name'));

                            // If the subject exists, increment its count
                            if ($index !== false) {
                                $SubjectCounts[$index]['subject_count']++;
                            } else {
                                // If the subject doesn't exist, add it with count 1
                                $SubjectCounts[] = ['subject_name' => $subjectName, 'subject_count' => 1];
                            }
                        }
                    }
                }

                $s_List[$key]['id']               = $site->id;
                $s_List[$key]['site_name']        = $site->site_name;
                $s_List[$key]['subjects']          = $SubjectCounts;
                $key++;
            }
        }

        return response()->json($s_List);
    }
}
