<?php

namespace App\Http\Controllers\SitePublic\Site\Admission;

use App;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicBoard;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicOccupation;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Designation\Designation;
use App\Models\Examinations\Examination;
use App\Models\Relation\Relation;
use App\Models\Relation\RelationTranslation;
use App\Models\Site\Employee\Employee;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionApplication;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionDeclare;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionEducationQualification;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionApplication;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionEducationQualification;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Traits\TransactionCheckApiTrait;
use Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentQuata;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use App\Models\Site\StudentAdmission\GlobalStudentRollCreateRange;
use Carbon\Carbon;
use DB;
use Error;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\ValidationException;
use Image;
use Lang;
use PDF;
use Session;


use Response;
use View;

class SiteStudentAdmissionApplicationFormController extends ProjectController
{

    use TransactionCheckApiTrait;

    public function index()
    {
        $viewType = 'Site Student Remote Registration';

        return view('web.index', compact('viewType'));
//        return view('default.web_site.site.site-student-entry-application-form', compact('viewType'));

    }


    private function getSiteId()
    {
        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        $get_site_id = SiteInfo::select('id', 'site_logo', 'site_alias','site_phone','eiin','college_code','nu_code')->where('site_alias', $domain)->first();

        return $get_site_id;
    }


    public function globalGetSiteAcademicGroupList()
    {

        $site_list = $this->getSiteId();
       
        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');


        $admission_declare_group_ids = GlobalSiteStudentAdmissionDeclare::where('site_id', $site_list->id)
            ->where('duration_from_date', '<=', $today)
            ->where('duration_to_date', '>=', $today)
            ->where('status', true)
            ->pluck('academic_group_id')
            ->unique();

        if (count($admission_declare_group_ids) > 0) {
            $admission_declare_group_list = GlobalSiteStudentAdmissionDeclare::with(['academicGroup','globalSiteStudentAdmissionDeclareOnlineApi'])
                ->select('id', 'duration_from_date',
                    'duration_to_date', 'extended_date', 'academic_group_id','check_with_online_transaction_id')
                ->where('site_id', $site_list->id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->get();

            $declared_time_present = 1;
        } else {

            $admission_declare = GlobalSiteStudentAdmissionDeclare::with(['academicGroup','globalSiteStudentAdmissionDeclareOnlineApi'])
                ->select('id', 'duration_from_date',
                    'duration_to_date', 'extended_date', 'academic_group_id','check_with_online_transaction_id')
                ->where('site_id', $site_list->id)
                ->where('status', true)
                ->orderBy('id','desc')
                ->first();

            if($admission_declare){
                $declared_time_present = 'Admission form will open from ' 
                . date('d/m/Y', strtotime($admission_declare->duration_from_date)) 
                . '. Pls pay admission fee first..!';
            }else{
                $declared_time_present = 'No Online Admission.!';
            }
             
            $admission_declare_group_list = [];
        }



        $site_group_ids = GlobalSiteInfoSetting::where('site_id', $site_list->id)
            ->pluck('academic_group_id');


        $declared_group_ids = array_intersect($admission_declare_group_ids->toArray(), $site_group_ids->toArray());


        $academic_group_list = AcademicGroup::whereIn('id', $declared_group_ids)->get();

       

        return response()->json(
            [
                'academic_group_list' => $academic_group_list,
                'declared_time_present' => $declared_time_present,
                'admission_declare_group_list' => $admission_declare_group_list,
                'site_info' => $site_list

            ]);


//        return compact('academic_group_list', 'declared_time_present', 'admission_declare_group_list', 'site_list');
    }


    public function globalGetAdmissionSiteClassBaseSection($class_id, $shift_id, $class_group_id, $year_id, $group_id)
    {


        $site_list = $this->getSiteId();

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();


        $getDeclaredList = $this->getDeclaredList($group_id);


        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::
        where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $class_id)
            ->where('session_ids', '!=', 0)
            ->first();


        $Sessionlist = [];
        if ($sessionPresentCheck && $getDeclaredList->academic_session_ids[1]) {
         //   dd($getDeclaredList->academic_session_ids);
            $declared_session_ids = $getDeclaredList->academic_session_ids[1];

            $Sessionlist = AcademicSession::whereIn('id', $declared_session_ids)->orderBy('serial_no','DESC')
                ->get();
        }


        $site_class_group_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $class_id)
            ->where('academic_shift_id', $shift_id)
            ->pluck('academic_class_group_id')
            ->unique();


        $classGroupDataList = AcademicClassGroup::select('id', 'group_name')
            ->whereIn('id', $site_class_group_ids)
            ->get();


//        if (!$groupPresentCount) {
//
//            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
//                ->where('site_id', $site_list->id)
//                ->where('academic_group_id', $group_id)
//                ->where('academic_class_id', $class_id)
//                ->get()
//                ->count();
//
//
//            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
//                return 4001;
//            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
//                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
//                    ->where('site_id', $site_list->id)
//                    ->where('academic_group_id', $group_id)
//                    ->where('academic_class_id', $class_id)
//                    ->first();
//
//
//            } else if ($shift_id && $class_id) {
//                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
//                    ->where('site_id', $site_list->id)
//                    ->where('academic_group_id', $group_id)
//                    ->where('academic_class_id', $class_id)
//                    ->where('academic_shift_id', $shift_id)
//                    ->first();
//
//            }
//        }
//        else {
//            if (!$shift_id && !$class_group_id) {
//                return 4001;
//            } else if ($shift_id && !$class_group_id) {
//                $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
//                    ->where('site_id', $site_list->id)
//                    ->where('academic_group_id', $group_id)
//                    ->where('academic_class_id', $class_id)
//                    ->where('academic_shift_id', $shift_id)
//                    ->get();
//
//
//                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
//                    ->whereIn('id', $SiteGroup)
//                    ->get();
//
//
//                return [2001, $sectionDataList, $Sessionlist];
//            } else {
//                $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
//                    ->where('site_id', $site_list->id)
//                    ->where('academic_group_id', $group_id)
//                    ->where('academic_class_id', $class_id)
//                    ->where('academic_class_group_id', $class_group_id)
//                    ->get()
//                    ->count();
//
//
//                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
//                    return 4001;
//                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
//                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
//                        ->where('site_id', $site_list->id)
//                        ->where('academic_group_id', $group_id)
//                        ->where('academic_class_id', $class_id)
//                        ->where('academic_class_group_id', $class_group_id)
//                        ->first();
//
//
//                } else if ($shift_id && $class_id) {
//                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
//                        ->where('site_id', $site_list->id)
//                        ->where('academic_group_id', $group_id)
//                        ->where('academic_class_id', $class_id)
//                        ->where('academic_shift_id', $shift_id)
//                        ->where('academic_class_group_id', $class_group_id)
//                        ->first();
//
//
//                }
//            }
//
//        }
//
//
//        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);
//
//        $SectionDataList = AcademicSection::select('id', 'section_name')
//            ->whereIn('id', $SectionData)
//            ->get();


        return [$classGroupDataList, $Sessionlist];
//        return $Sessionlist;


    }



    public function checkValideStudentForAdmission(Request $request, $form_submit=false, $mode = 'check')
    {

        $this->validate($request, [
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "academic_class_group_id" => count($request->AcademicClassGroupList) > 0 ? "required" : "",
        ]);

        $getDeclaredList = $this->getDeclaredList($request->academic_group_id);

      
        $this->validate($request, [
            "academic_board_id" => $getDeclaredList->check_with_board_university ? "required" : "",
            "board_roll_number" => $getDeclaredList->check_with_roll_number ? "required" : "",
            "transaction_number" => $getDeclaredList->check_with_online_transaction_id ? "required" : "",
            "second_transaction_number" => $getDeclaredList->check_with_second_online_transaction_id ? "required" : "",
            "passing_year" => $getDeclaredList->exam_passing_year_show ? "required" : "",
        ]);

        $data = $request->all();
        $site_list = $this->getSiteId();



        if($getDeclaredList->form_number_check){

            $check_data_in_applied = GlobalSiteStudentAdmissionApplication::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })

                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when($mode=='update', function ($query) use ($data) {
                    return $query->where('id', '!=', $data['site_student_admission_application_id']);
                })
                ->where('site_id', $site_list->id)
                ->where('menual_form_number', $request->menual_form_number)
                ->first();


            if ($check_data_in_applied) {

                return Response::json(['message' => 'This Admission Roll Already present in your list.
                 Please change Roll Number.', 'mode' => 'fill'], 412);
            }
        }

      

        if ($getDeclaredList->check_with_roll_number) {
            $check_data_in_applied = GlobalSiteStudentAdmissionApplication::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                    return $query->where('board_roll_number', $data['board_roll_number']);
                })
                ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                    return $query->where('academic_board_id', $data['academic_board_id']);
                })
                ->when($mode=='update', function ($query) use ($data) {
                    return $query->where('id', '!=', $data['site_student_admission_application_id']);
                })
                ->where('board_roll_number', $data['board_roll_number'])
                ->where('site_id', $site_list->id)
                ->first();

            if ($check_data_in_applied) {
                if ($request->unique_code) {
                    return Response::json(['message' => 'Success', 'mode' => 'success'], 200);
                }else{
                    return Response::json(['message' => 'You already fillup your admission form!.
                                        To update use your unique code.', 'mode' => 'fill'], 412);
                }

            }
        }

        $student_name='';
        $invoice_no='';

        if ($getDeclaredList->check_with_roll_number || $getDeclaredList->check_with_online_transaction_id || $getDeclaredList->check_with_second_online_transaction_id) {

            $check_board_data = GlobalSiteStudentAdmissionBoardApprove::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                    return $query->where('board_roll_number', $data['board_roll_number']);
                })
                ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                    return $query->where('academic_board_id', $data['academic_board_id']);
                })
                ->when(!empty($data['passing_year']), function ($query) use ($data) {
                    return $query->where('passing_year', $data['passing_year']);
                })
                ->where('site_id', $site_list->id)
                ->where('status',1)
                ->first();
                

            if(!$check_board_data) {
                return Response::json(['message' => 'Wrong Information. Please check & try again!', 'mode' => 'error'], 412);
            }else{
                $student_name= $check_board_data->first_name;
                $invoice_no= $check_board_data->invoice_no;
            }
    
        }

    

        //Transction Check
        if ($getDeclaredList->check_with_second_online_transaction_id) {
      
            if($request->transaction_number==$request->second_transaction_number){
                return Response::json(['message' => 'Must be different transeciton number.', 'mode' => 'fill'], 412);
            }
        }

          // separate transection id
          $transaction_number=$request->transaction_number;
          $second_transaction_number=$request->second_transaction_number;
  
          if ($getDeclaredList->check_with_second_online_transaction_id) {
            // first check
              if($check_board_data->transaction_number==$request->transaction_number || $check_board_data->transaction_number==$request->second_transaction_number){
                 $transaction_number=$check_board_data->transaction_number;
              }else{
                $transaction_number='000';
              }
         
  
            // second check
              if($check_board_data->second_transaction_number==$request->transaction_number || $check_board_data->second_transaction_number==$request->second_transaction_number){
                 $second_transaction_number=$check_board_data->second_transaction_number;
              }else{
                $second_transaction_number='000';
              }
          }
  
          $data['transaction_number']=$transaction_number;
          $data['second_transaction_number']=$second_transaction_number;
      //    dd($data);

        $declare_payment_detail = ($getDeclaredList->globalSiteStudentAdmissionDeclareOnlineApi)
            ->where('academic_payment_type_id', $data['academic_payment_type_id'])
            ->where('payment_company_id', $data['academic_payment_method_id'])
            ->first();

        $transaction_amount = 0;
        $transaction_date = null;
        $transaction_check=null;
       
        // check second transection id
        if ($getDeclaredList->check_with_second_online_transaction_id) {
       

        if($declare_payment_detail->check_method=='online'){

            if ($request->academic_board_id && $request->board_roll_number) {
                $unique_vendor = $request->academic_board_id . $request->board_roll_number;
            } else if (!$request->academic_board_id && $request->board_roll_number) {
                $unique_vendor = $request->board_roll_number;
            } else {
                $unique_vendor = $site_list->site_alias;
            }

            $request_data = [
                "transaction_id" => $data['second_transaction_number'],
                "partner_code" => $declare_payment_detail->partner_code,
                "user_name" => $declare_payment_detail->username,
                "password" => $declare_payment_detail->password,
                "edu_user_name" => $unique_vendor,
                "bearer_type" => 'site',
                "bearer_id" => $site_list->id,
                "invoice_no" => $invoice_no,
                "site_id" => $declare_payment_detail->site_id,
            ];

            //primary transection check

            if($check_board_data->second_transaction_number!=$data['second_transaction_number']){
                return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
            }



            $transaction_check = $this->verifyOnlineTransId($request_data, $declare_payment_detail->vendor);
          //  dd($transaction_check);
          
            if($declare_payment_detail->vendor=='cellfin'){
              //  dd($transaction_check);
                if($transaction_check['invoiceNo']!=$invoice_no){
                    return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                }
            
                $payment_date = Carbon::createFromFormat('d/m/Y H:i A', $transaction_check['date_time'])->format('Y-m-d');

                $transaction_amount = $transaction_check['cr_amount']; //Credit amount
                $transaction_date = $payment_date;

                if ($transaction_check['statusCode']==0) {
                    return Response::json(['message' => 'Wrong Payment Method!', 'mode' => 'error'], 412);
                } else if ($transaction_check['statusCode']!=200) {
                    return Response::json(['message' => $transaction_check['description'], 'mode' => 'error'], 412);
                }
             
            }else if($declare_payment_detail->vendor == 'sure_cash'){
              
                if($transaction_check['customerId']!=$data['board_roll_number']){
                    return Response::json(['message' => 'Wrong Second transaction ID', 'mode' => 'error'], 412);
                }

                $transaction_amount = $transaction_check['amount'];
                $transaction_date = $transaction_check['txnDate'];
           
            }else if($declare_payment_detail->vendor=='sonali_pay'){
                if($transaction_check['Status']!='200'){
                    return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                }
                if($transaction_check['InvoiceNo']!=$invoice_no){
                    return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                }
            
                $transaction_amount = $transaction_check['CustomerPaidAmount'];
                $transaction_date = $transaction_check['TransactionDate'];
           
            }else{
                
                if($transaction_check['invoiceNo']!=$invoice_no){
                    return Response::json(['message' => 'Wrong Second transaction ID', 'mode' => 'error'], 412);
                }

                $payment_date = Carbon::createFromFormat('d/m/Y H:i A', $transaction_check['date_time'])->format('Y-m-d H:i:s');

                $transaction_amount = $transaction_check['cr_amount']; // Credit amount
                $transaction_date = $payment_date;
            }


            


         }

        }

        // check transection id
        if ($getDeclaredList->check_with_online_transaction_id) {
          
            $check_same_transaction_id = GlobalSiteStudentAdmissionApplication::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($mode=='update', function ($query) use ($data) {
                    return $query->where('id', '!=', $data['site_student_admission_application_id']);
                })
                ->where('transaction_number', $data['transaction_number'])
                ->where('site_id', $site_list->id)
                ->first();
             //  dd($check_same_transaction_id);

            if ($check_same_transaction_id) {
                if ($request->unique_code) {
                    return Response::json(['message' => 'Success', 'mode' => 'success'], 200);
                } else {
                    return Response::json(['message' => 'Transaction ID Already used.', 'mode' => 'fill'], 412);
                }

            }
            
           
               
            if($declare_payment_detail->check_method=='online'){

                if ($request->academic_board_id && $request->board_roll_number) {
                    $unique_vendor = $request->academic_board_id . $request->board_roll_number;
                } else if (!$request->academic_board_id && $request->board_roll_number) {
                    $unique_vendor = $request->board_roll_number;
                } else {
                    $unique_vendor = $site_list->site_alias;
                }

                $request_data = [
                    "transaction_id" => $data['transaction_number'],
                    "partner_code" => $declare_payment_detail->partner_code,
                    "user_name" => $declare_payment_detail->username,
                    "password" => $declare_payment_detail->password,
                    "edu_user_name" => $unique_vendor,
                    "bearer_type" => 'site',
                    "bearer_id" => $site_list->id,
                    "invoice_no" => $invoice_no,
                    "site_id" => $declare_payment_detail->site_id,
                ];

    
                 //primary transection check
              //  dd($check_board_data);
                if($check_board_data->transaction_number!=$data['transaction_number']){
                    return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                }

                $transaction_check = $this->verifyOnlineTransId($request_data, $declare_payment_detail->vendor);

            //    dd($transaction_check);
              
              
                if($declare_payment_detail->vendor=='cellfin'){
                 
                    if($transaction_check['invoiceNo']!=$invoice_no){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }

               
                    $payment_date = Carbon::createFromFormat('d/m/Y H:i A', $transaction_check['date_time'])->format('Y-m-d');

                    $transaction_amount = $transaction_check['cr_amount']; //Credit amount
                    $transaction_date = $payment_date;

                    if ($transaction_check['statusCode']==0) {
                        return Response::json(['message' => 'Wrong Payment Method!', 'mode' => 'error'], 412);
                    } else if ($transaction_check['statusCode']!=200) {
                        return Response::json(['message' => $transaction_check['description'], 'mode' => 'error'], 412);
                    }

                   
                }else if($declare_payment_detail->vendor=='sure_cash'){
                  
                    if($transaction_check['customerId']!=$data['board_roll_number']){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
    
                    $transaction_amount = $transaction_check['amount'];
                    $transaction_date = $transaction_check['txnDate'];
               
                }else if($declare_payment_detail->vendor=='sonali_pay'){
                    
                    if($transaction_check['Status']!='200'){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
                    if($transaction_check['InvoiceNo']!=$invoice_no){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
                
                //    $transaction_amount = $transaction_check['CustomerPaidAmount'];
                    $transaction_amount = $transaction_check['RequestTotalAmount'];
                    $transaction_date = $transaction_check['TransactionDate'];
               
                }else{
                    if($transaction_check['invoiceNo']!=$invoice_no){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
    
                    $payment_date = Carbon::createFromFormat('d/m/Y H:i A', $transaction_check['date_time'])->format('Y-m-d H:i:s');
    
                    $transaction_amount = $transaction_check['cr_amount']; // Credit amount
                    $transaction_date = $payment_date;
                }

    
            

             }else{
                $check_trId = GlobalSiteStudentAdmissionBoardApprove::
                    where('academic_version_id', $request->academic_version_id)
                    ->where('academic_group_id', $request->academic_group_id)
                    ->where('site_student_admission_declare_id', $getDeclaredList->id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                        return $query->where('board_roll_number', $data['board_roll_number']);
                    })
                    ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                        return $query->where('academic_board_id', $data['academic_board_id']);
                    })
                    ->when(!empty($data['passing_year']), function ($query) use ($data) {
                        return $query->where('passing_year', $data['passing_year']);
                    })
                    ->where('site_id', $site_list->id)
                    ->where('transaction_number', $request->transaction_number)
                    ->where('status',1)
                    ->first();

           
                if ($check_trId) {
                    $transaction_amount=$check_trId->tr_amount;
                    $transaction_date=$check_trId->payment_date;
                    $student_name=$check_trId->first_name;
                    $transaction_check='';

                }else{
                    return Response::json(['message' => 'Wrong transaction ID!', 'mode' => 'error'], 412);
                }
             }
      
        }

        if($form_submit==false){
            return compact('transaction_amount', 'transaction_date', 'student_name', 'transaction_check');
        }


    }


    public function globalGetDepartmentBaseClassForAdmission($department_id, $year_id, $group_id)
    {


        try {

            $site_list = $this->getSiteId();
            $getDeclaredList = $this->getDeclaredList($group_id);


            $siteClassIds = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_department_id', $department_id)
                ->pluck('academic_class_id')->toArray();

            $declared_class_ids = $getDeclaredList->academic_class_ids[1];
            $final_class_ids = array_intersect($declared_class_ids, $siteClassIds);

            $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $final_class_ids)->get();


            return response()->json($academicClassList, 200);

        } catch (Exception $exception) {

            // dd('ggg');
            return response()->json(["message" => $exception->getMessage()], 420);


        }

    }

    public function globalGetGenderReligionBloodStudentCategoryQuataOccupationList($group_id)
        {

            $site_list=$this->getSiteId();

            $siteInfoSettinglist = GlobalSiteInfoSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->first();


            $genderlistsplite = explode(',', $siteInfoSettinglist->gender_ids);
            $genderlist = Gender::whereIn('id', $genderlistsplite)->get();


            $religionlistsplite = explode(',', $siteInfoSettinglist->religion_ids);
            $religionlist = Religion::whereIn('id', $religionlistsplite)->get();


            $bloodlist = BloodGroup::get();

            $studentCategorylistsplite = explode(',', $siteInfoSettinglist->academic_student_category_ids);
            $studentCategorylist = AcademicStudentCategory::whereIn('id', $studentCategorylistsplite)->get();


            $StudentQuatalistdata = AcademicStudentQuata::where('status', 1)->get();

            $fatherOccupationlistdata = AcademicOccupation::where('status', 1)->whereNotIn('id',[2])->get();
            $motherOccupationlistdata = AcademicOccupation::where('status', 1)->whereNotIn('id',[49])->get();


            $residencelistsplite = explode(',', $siteInfoSettinglist->academic_residence_ids);
            $residencelist = AcademicResidence::whereIn('id', $residencelistsplite)->get();

            $declareList=$this->getDeclaredList($group_id);

            return compact('genderlist', 'religionlist','bloodlist','studentCategorylist',
            'StudentQuatalistdata','fatherOccupationlistdata', 'motherOccupationlistdata', 'residencelist', 'declareList');


        
        }



    public function globalSiteYearShiftVersionAdmissiontypeStudenttypeLoad($group_id)
    {


        $site_list = $this->getSiteId();
        $getDeclaredList = $this->getDeclaredList($group_id);


        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->first();
        if (!$SiteInfoTableData) {
            return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
        }

        $siteGroupShift = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->distinct('academic_shift_id')
            ->select('academic_shift_id')
            ->pluck('academic_shift_id');


        $previousAcademicShiftList = AcademicShift::whereIn('id', $siteGroupShift)->get();

        $previousAcademicYear = explode(',', $SiteInfoTableData->academic_year_ids ?? null);
        $previousAcademicYearList = AcademicYear::whereIn('id', $previousAcademicYear)->orderBy('serial_no','DESC')->get();


//        $academicVersionIDs = explode(',', $SiteInfoTableData->academic_version_ids);
//        $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();


        $academicShiftList = $getDeclaredList->academic_shift_ids[0];
        $academicYearList = $getDeclaredList->academic_year_ids[0];
        $academicVersionList = $getDeclaredList->academic_version_ids[0];

        $oldStudentInformationAdd = $getDeclaredList->old_student_information_add;


        $subject_condition_status = $getDeclaredList->subject_condition_status;
        $guardian_information_add = $getDeclaredList->guardian_information_add;
        $address_information_add = $getDeclaredList->address_information_add;
        $communication_information_add = $getDeclaredList->communication_information_add;
//        $previous_institute_information_add=$getDeclaredList->previous_institute_information_add;
        $local_guardian_detail_information_add = $getDeclaredList->local_guardian_detail_information_add;
        $student_admission_number_box_show = $getDeclaredList->student_admission_number_box_show;


        $form_number_entry_box_show = $getDeclaredList->form_number_entry_box_show;
        $check_with_online_transaction_id_show = $getDeclaredList->check_with_online_transaction_id;
        $check_with_second_online_transaction_id_show = $getDeclaredList->check_with_second_online_transaction_id;
        $check_with_roll_number_show = $getDeclaredList->check_with_roll_number;
        $term_condition_show = $getDeclaredList->term_condition;
        $term_condition = $getDeclaredList->term_condition;
        $terms_condition_show_bellow = $getDeclaredList->terms_condition_show_bellow;
        $terms_condition_show_top = $getDeclaredList->terms_condition_show_top;
        $check_with_board_university_show = $getDeclaredList->check_with_board_university;
        $birth_certificate_no_required = $getDeclaredList->birth_certificate_no_required;
        $parents_contact_number_required = $getDeclaredList->parents_contact_number_required;


        $passing_year_examination_name_show = $getDeclaredList->examination ? $getDeclaredList->examination->examination_name : null;
        $exam_passing_year_show = $getDeclaredList->exam_passing_year_show;
        $admission_form_language = $getDeclaredList->admission_form_language;


        $academic_payment_type_id = collect($getDeclaredList->globalSiteStudentAdmissionDeclareOnlineApi)
            ->pluck('academic_payment_type_id')
            ->unique()
            ->first();

        $payment_company_ids = collect($getDeclaredList->globalSiteStudentAdmissionDeclareOnlineApi)
            ->pluck('payment_company_id')
            ->unique();
        $academic_payment_method_list = AcademicOnlinePaymentMethod::whereIn('id', $payment_company_ids)
            ->get();


        $academicAdmissionTypeIDs = explode(',', $SiteInfoTableData->academic_admission_type_ids);
        $admissionlistdata = AcademicAdmissionType::whereIn('id', $academicAdmissionTypeIDs)
            ->where('status', 1)
            ->get();


        // $academicStudentTypeIDs = explode(',', $SiteInfoTableData->academic_student_type_ids);
        // $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();

        $academicStudentTypeList = $getDeclaredList->student_type_ids[0];


        $relationList = Relation::all();
        $boardUniversityList = AcademicBoard::all();
        $academicBoardList = AcademicBoard::all();


        $academicSessionForEduBack = explode(',', $SiteInfoTableData->academic_session_ids ?? null);
        $academicSessionForEduBackList = AcademicSession::whereIn('id', $academicSessionForEduBack)->get();

        $qualificationIDs = explode(',', $getDeclaredList->education_qualification_ids);
        $degree_list = Examination::whereIn('id', $qualificationIDs)->get();

        $qualificationList[] = [
            'id' => null,
            'examination_id' => null,
            'site_student_admission_application_id' => null,
            'board_roll_number' => null,
            'board_registration_number' => null,
            'institution_name' => null,
            'passing_year' => null,
            'academic_board_id' => null,
            'academic_session_id' => null,
            'gpa_with_optional' => null,
            'gpa_without_optional' => null,

        ];
       // dd('sfsf');


        return response()->json(
            [
                'academicVersionList' => $academicVersionList,
                'academicYearList' => $academicYearList,
                'academicShiftList' => $academicShiftList,
                'admissionlistdata' => $admissionlistdata,
                'academicStudentTypeList' => $academicStudentTypeList,
                'previousAcademicShiftList' => $previousAcademicShiftList,
                'previousAcademicYearList' => $previousAcademicYearList,
                'oldStudentInformationAdd' => $oldStudentInformationAdd,
                'subject_condition_status' => $subject_condition_status,
                'guardian_information_add' => $guardian_information_add,

                'address_information_add' => $address_information_add,
                'communication_information_add' => $communication_information_add,
                'student_admission_number_box_show' => $student_admission_number_box_show,
                'local_guardian_detail_information_add' => $local_guardian_detail_information_add,
                'relationList' => $relationList,
                'boardUniversityList' => $boardUniversityList,
                'academicSessionForEduBackList' => $academicSessionForEduBackList,
                'academicBoardList' => $academicBoardList,

                'check_with_online_transaction_id_show' => $check_with_online_transaction_id_show,
                'check_with_second_online_transaction_id_show' => $check_with_second_online_transaction_id_show,
                'check_with_roll_number_show' => $check_with_roll_number_show,
                'terms_condition_show' => $term_condition_show,
                'terms_condition' => $term_condition,
                'terms_condition_show_bellow' => $terms_condition_show_bellow,
                'terms_condition_show_top' => $terms_condition_show_top,
                'check_with_board_university_show' => $check_with_board_university_show,
                'academic_payment_type_id' => $academic_payment_type_id,

                'academic_payment_method_list' => $academic_payment_method_list,
                'degree_list' => $degree_list,
                'qualificationList' => $qualificationList,

                'passing_year_examination_name_show' => $passing_year_examination_name_show,
                'exam_passing_year_show' => $exam_passing_year_show,
                'form_number_entry_box_show' => $form_number_entry_box_show,
                'admission_form_language' => $admission_form_language,
                'birth_certificate_no_required' => $birth_certificate_no_required,
                'parents_contact_number_required' => $parents_contact_number_required,

            ]);


    }


    private function getDeclaredList($group_id)
    {
        $site_list = $this->getSiteId();
        $registration_declare_list = GlobalSiteStudentAdmissionDeclare::with(['globalSiteStudentAdmissionDeclareOnlineApi', 'examination'])
            ->where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('status', true)
            ->first();


        return $registration_declare_list;
    }


    public function globalGetSiteYearVersionBaseDepartmentClass($version_id, $year_id, $group_id, $shift_id)
    {


        $academicClassList = [];
        $academicDepartmentList = [];

        $site_list = $this->getSiteId();
        $getDeclaredList = $this->getDeclaredList($group_id);

        if ($version_id) {

            $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->filter();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];


            if (count($academicDepartment) > 0) {
//                $academicDepartmentList = AcademicDepartment::whereIn('id', $academicDepartment)
//                    ->get();
                $academicDepartmentList = $getDeclaredList->academic_department_ids[0];


            } else {


                $academicClass = $getDeclaredList->academic_class_ids[1];

                $academicClass_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_shift_id', $shift_id)
                    ->whereIn('academic_class_id', $academicClass)
                    ->pluck('academic_class_id');

                $academicClassList = AcademicClass::whereIn('id', $academicClass_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

            }


        } else {

            $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->filter();


            if (count($academicDepartment) > 0) {
//                $academicDepartmentList = AcademicDepartment::whereIn('id', $academicDepartment)
//                    ->get();
                $academicDepartmentList = $getDeclaredList->academic_department_ids[0];
            } else {


                $academicClass = $getDeclaredList->academic_class_ids[1];

                $academicClass_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_shift_id', $shift_id)
                    ->whereIn('academic_class_id', $academicClass)
                    ->pluck('academic_class_id');

                $academicClassList = AcademicClass::whereIn('id', $academicClass_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

                if (count($academicClass) == 0) {
                    return Response::json(['message' => 'No Class Found For The Year! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

                }

            }


        }


        return [$academicClassList, $academicDepartmentList];
    }


    public function globalGetSiteExaminationQualificationForAdmission($group_id)
    {

        $site_list = $this->getSiteId();
        $getDeclaredList = $this->getDeclaredList($group_id);

        $qualificationIDs = explode(',', $getDeclaredList->education_qualification_ids);
        $qualification_list = Examination::whereIn('id', $qualificationIDs)->get();


        return $qualification_list;

    }

    public function checkCreateValideAdmission($request)
    {

        $this->validate($request, [
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "academic_class_group_id" => count($request->AcademicClassGroupList) > 0 ? "required" : "",
            "academic_session_id" => count($request->AcademicSessionList) > 0 ? "required" : "",
        ]);

        $getDeclaredList = $this->getDeclaredList($request->academic_group_id);

        $this->validate($request, [
            "academic_board_id" => $getDeclaredList->check_with_board_university ? "required" : "",
            "board_roll_number" => $getDeclaredList->check_with_roll_number ? "required" : "",
            "transaction_number" => $getDeclaredList->check_with_online_transaction_id ? "required" : "",
            "passing_year" => $getDeclaredList->exam_passing_year_show ? "required" : "",
        ]);

        $data = $request->all();
        $site_list = $this->getSiteId();

        if($getDeclaredList->form_number_check){
            $check_data_in_applied = GlobalSiteStudentAdmissionApplication::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })

                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })

                ->where('site_id', $site_list->id)
                ->where('menual_form_number', $request->menual_form_number)

                ->first();


            if ($check_data_in_applied) {

                return Response::json(['message' => 'This Admission Roll Already present in your list. Please change Roll Number.', 'mode' => 'fill'], 412);


            }


        }


        if ($getDeclaredList->check_with_roll_number) {
            $check_data_in_applied = GlobalSiteStudentAdmissionApplication::
              where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                    return $query->where('board_roll_number', $data['board_roll_number']);
                })
                ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                    return $query->where('academic_board_id', $data['academic_board_id']);
                })
                ->where('site_id', $site_list->id)
                ->first();

            if ($check_data_in_applied) {

                    return Response::json(['message' => 'You already fillup your admission form!.
                                        To update use your unique code.', 'mode' => 'fill'], 412);

            }
        }


        //Board Roll Number================
        $student_name='';
        if ($getDeclaredList->check_with_roll_number) {

            $check_roll = GlobalSiteStudentAdmissionBoardApprove::
                where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                // ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                //     return $query->where('board_roll_number', $data['board_roll_number']);
                // })
                ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                    return $query->where('academic_board_id', $data['academic_board_id']);
                })
                ->when(!empty($data['passing_year']), function ($query) use ($data) {
                    return $query->where('passing_year', $data['passing_year']);
                })
                ->where('board_roll_number', $data['board_roll_number'])
                ->where('site_id', $site_list->id)
                ->where('status',1)
                ->first();


            if (!$check_roll) {
                return Response::json(['message' => 'Wrong Information. Please check & try again!', 'mode' => 'error'], 412);
            }
            $invoice_no= $check_roll->invoice_no;
        }


        //Transction Check

        $transaction_amount = 0;
        $transaction_date = null;

        if ($getDeclaredList->check_with_online_transaction_id) {

            $check_same_transaction_id = GlobalSiteStudentAdmissionApplication::
            where('academic_version_id', $request->academic_version_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('site_student_admission_declare_id', $getDeclaredList->id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('transaction_number', $request->transaction_number)
                ->where('site_id', $site_list->id)
                ->first();


            if ($check_same_transaction_id) {
                return Response::json(['message' => 'Transaction ID Already used.', 'mode' => 'fill'], 412);
            }

            $declare_payment_detail = ($getDeclaredList->globalSiteStudentAdmissionDeclareOnlineApi)
                ->where('academic_payment_type_id', $request->academic_payment_type_id)
                ->where('payment_company_id', $request->academic_payment_method_id)
                ->first();


              // manually check payment transaction ID for cellfin
            if($declare_payment_detail->check_method=='online'){

                if ($request->academic_board_id && $request->board_roll_number) {
                    $unique_vendor = $request->academic_board_id . $request->board_roll_number;
                } else if (!$request->academic_board_id && $request->board_roll_number) {
                    $unique_vendor = $request->board_roll_number;
                } else {
                    $unique_vendor = $site_list->site_alias;
                }


            $request_data = [
                "transaction_id" => $request->transaction_number,
                "partner_code" => $declare_payment_detail->partner_code,
                "user_name" => $declare_payment_detail->username,
                "password" => $declare_payment_detail->password,
                "edu_user_name" => $unique_vendor,
                "bearer_type" => 'site',
                "bearer_id" => $site_list->id,
            ];



            $transaction_check = $this->verifyOnlineTransId($request_data, $declare_payment_detail->vendor);

              if($declare_payment_detail->vendor=='cellfin'){
              
                    if($transaction_check['invoiceNo']!=$invoice_no){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }

                }else if($declare_payment_detail->vendor == 'sure_cash'){
                  
                    if($transaction_check['customerId']!=$data['board_roll_number']){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
    
                  //  $transaction_amount = $transaction_check['amount'];
                  //  $transaction_date = $transaction_check['txnDate'];
               
                }else if($declare_payment_detail->vendor=='sonali_pay'){
                    if($transaction_check['Status']!='200'){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
                    if($transaction_check['InvoiceNo']!=$invoice_no){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
               
                }else{
                    if($transaction_check['invoiceNo']!=$invoice_no){
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
    
                }
    

            if ($transaction_check['statusCode'] == 0) {
                return Response::json(['message' => 'Wrong Payment Method!', 'mode' => 'error'], 412);
            } else if ($transaction_check['statusCode'] != 200) {
                return Response::json(['message' => $transaction_check['description'], 'mode' => 'error'], 412);
            }

            
            }else{

                    $check_trId = GlobalSiteStudentAdmissionBoardApprove::
                        where('academic_version_id', $request->academic_version_id)
                        ->where('academic_group_id', $request->academic_group_id)
                        ->where('site_student_admission_declare_id', $getDeclaredList->id)
                        ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                            return $query->where('academic_year_id', $data['academic_year_id']);
                        })
                        ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                            return $query->where('academic_shift_id', $data['academic_shift_id']);
                        })
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                            return $query->where('academic_class_id', $data['academic_class_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                            return $query->where('board_roll_number', $data['board_roll_number']);
                        })
                        ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                            return $query->where('academic_board_id', $data['academic_board_id']);
                        })
                        ->when(!empty($data['passing_year']), function ($query) use ($data) {
                            return $query->where('passing_year', $data['passing_year']);
                        })
                        ->where('site_id', $site_list->id)
                        ->where('transaction_number', $request->transaction_number)
                        ->where('status',1)
                        ->first();
    
               
                    if (!$check_trId) {
                        return Response::json(['message' => 'Wrong transaction ID', 'mode' => 'error'], 412);
                    }
              
            }


        }


    }


    public function createStudentEntryApplication(GlobalSiteStudentAdmissionApplication $student, Request $requests)
    {

        DB::beginTransaction();

       //  try {

            $this->validate($requests, [
                "academic_version_id" => "required",
                "academic_year_id" => "required",
                "academic_shift_id" => "required",
                "academic_class_id" => "required",
                'first_name' => 'required',
                'father_name' => 'required',
                'mother_name' => 'required',
                "religion_id" => "required",
                "gender_id" => "required",
                "student_contact_number" => "required",
                "date_of_birth" => "required",
                "bcn" =>  $requests->birth_certificate_no_required ? "required" : "",

//                "name_native_lan guage" => "required",
//                "father_name_native_language" => "required",
//                "mother_name_native_language" => "required",


                "academic_class_group_id" => count($requests->AcademicClassGroupList) > 0 ? "required" : "",

                "local_gurdian_name" => $requests->local_gurdian_name ? "required" : "",
                "local_gurdian_mobile" => $requests->local_gurdian_name ? "required" : "",
                "academic_session_id" => count($requests->AcademicSessionList) > 0 ? "required" : "",
                "religion_subject_id" => count($requests->ReligionSubjectList) > 0 ? "required" : "",
//                "present_address" => "required",
                "academic_student_type_id" => count($requests->getStudentTypeList) > 0 ? "required" : "",

            ]);
           
     
           // $valiedate_data=$this->checkCreateValideAdmission($requests);
            $valiedate_data=$this->checkValideStudentForAdmission($requests,true,'create');
         
            if($valiedate_data){
                return $valiedate_data;
            } 
            $data = $requests->all();
            $site_list = $this->getSiteId();
            $site_id = $site_list->id;

//            return $site_list->short_name;

            $date_formate = Carbon::today();
            $today = $date_formate->format('Y-m-d');

            $admission_declare_group_list = GlobalSiteStudentAdmissionDeclare::with(['academicGroup'])
                ->select('id', 'auto_roll_create_status', 'auto_roll_digit', 'education_qualification_ids',
                    'form_number_check', 'form_show_to_website', 'site_can_not_approve_student','group_wise_roll_create_status',
                    'conflig_compulsory_subject_ids','parents_contact_number_required','subject_condition_status')
                ->where('site_id', $site_list->id)
                ->where('academic_group_id', $requests->academic_group_id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->first();

       
            // check same subject 

            if($requests->subject_condition_status){

            
            if(is_array($requests->selective_compulsory_subject_ids)){
                $selective_compulsory_subject_ids= $requests->selective_compulsory_subject_ids;
            }else{
                $selective_compulsory_subject_ids= explode(',', $requests->selective_compulsory_subject_ids);
            }
    
            if(is_array($requests->optional_subject_ids)){
                $optional_subject_ids= $requests->optional_subject_ids;
            }else{
                $optional_subject_ids= explode(',', $requests->optional_subject_ids);
            }
           
    
            if($selective_compulsory_subject_ids && $optional_subject_ids){          
               for($i=0;$i<count($selective_compulsory_subject_ids);$i++){
                for($j=0;$j<count($optional_subject_ids);$j++){
                    if($selective_compulsory_subject_ids[$i]==$optional_subject_ids[$j]){
                        return Response::json(['message' => 'Compulsory and Optional Subject Match', 'mode' => 'Error'], 412);
                    }
                }
               }
    
            }
    
            //check limit subject
            
            if($requests->selective_compulsory_subject_limit){
                if(is_array($requests->selective_compulsory_subject_ids)){
                    $selective_compulsory_subject_ids_list=$requests->selective_compulsory_subject_ids;
                }else{
                    $selective_compulsory_subject_ids_list[]=$requests->selective_compulsory_subject_ids;
                }

                if($requests->selective_compulsory_subject_limit<count($selective_compulsory_subject_ids_list) ||
                    $requests->selective_compulsory_subject_limit>count($selective_compulsory_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->selective_compulsory_subject_limit . ' Compulsory Subject!.',
                        'mode' => 'Error'], 412);
                }

            }

            if($requests->optional_subject_limit){
                if(is_array($requests->optional_subject_ids)){
                    $optional_subject_ids_list=$requests->optional_subject_ids;
                }else{
                    $optional_subject_ids_list[]=$requests->optional_subject_ids;
                }

                if($requests->optional_subject_limit<count($optional_subject_ids_list) ||
                    $requests->optional_subject_limit>count($optional_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->optional_subject_limit . ' Optional Subject!.',
                        'mode' => 'Error'], 412);
                }

            }


            if (count($requests->CompulsorySubjectList) > 0) {
                if (is_array($requests->compulsory_subject_ids)) {
                    if (count($requests->compulsory_subject_ids) <= 0) {
                        return Response::json(['message' => 'You must Choose Compulsory Subject!'], 412);
                    }
                } else {
                    if (!$requests->compulsory_subject_ids) {
                        return Response::json(['message' => 'You must Choose Compulsory Subject!'], 412);
                    }

                }


            } else if (count($requests->OptionalSubjectList) > 0) {
                if (is_array($requests->optional_subject_ids)) {
                    if (count($requests->optional_subject_ids) <= 0) {
                        return Response::json(['message' => 'You must Choose 4th Subject!'], 412);
                    }
                } else {
                    if (!$requests->optional_subject_ids) {
                        return Response::json(['message' => 'You must Choose 4th Subject!'], 412);
                    }

                }

            }

            // validation End

         

         

        // conflig subject list

            if(count($admission_declare_group_list->conflig_compulsory_subject_ids[0])){

                $allConfligSubject = collect($requests->SelectiveCompulsorySubjectList)
                    ->merge($requests->OptionalSubjectList)
                    ->unique()
                    ->values()
                    ->all();

                $request_subject_ids = array_merge($selective_compulsory_subject_ids, $optional_subject_ids);

                // dd($request_subject_ids);

                $checkConfligSubject = collect($allConfligSubject)->filter(function ($subject) use ($request_subject_ids, $admission_declare_group_list) {
                        return in_array($subject['academic_subject_id'], $request_subject_ids)
                            && in_array($subject['academic_subject_id'], $admission_declare_group_list->conflig_compulsory_subject_ids[1]);
                    })->values();


                $subjectNames = $checkConfligSubject->pluck('subject_name')->values(); 

                if ($subjectNames->count() > 1) {
                    $last = $subjectNames->pop(); 
                    $subject_array = $subjectNames->implode(', ') . ' and ' . $last;
                } else {
                    $subject_array = $subjectNames->first() ?? '';
                }

                if(count($checkConfligSubject)>1){
                    return Response::json(['message' => 'You may take any one subject from '.$subject_array], 412);
                }
            }

        } /// subject_condition_status end

          //  dd($checkConfligSubject);

         
             if($admission_declare_group_list->parents_contact_number_required){

                  if($requests->father_contact_number=='' && $requests->father_occupation_id!=36){
                    return Response::json(['message' => "Fathers' contact numbers is required."], 412);

                }
                if($requests->mother_contact_number=='' && $requests->mother_occupation_id!=36){
                    return Response::json(['message' => "Mothers' contact numbers is required."], 412);

                }
              
            }

          

         
            // dd($admission_declare_group_list);

          
            //Education Qualification validation

            $check_valid_exam_qua = collect($requests->QualificationList)
                ->where('examination_id', '!=', null)
                ->where('board_roll_number', '!=', null)
                ->where('board_registration_number', '!=', null)
                ->where('institution_name', '!=', null)
                ->where('academic_board_id', '!=', null)
                ->where('academic_session_id', '!=', null)
                ->where('passing_year', '!=', null)
                ->where('gpa_with_optional', '!=', null);


            if ($admission_declare_group_list->education_qualification_ids && count($check_valid_exam_qua) <= 0) {
                return Response::json(['message' => 'You must Fillup Education Qualification!'], 412);
            }

           

            //=========End


            $date_formate = Carbon::parse($requests->date_of_birth);
            $date_of_birth = $date_formate->format('Y-m-d');


//            $studentList = SiteStudentRegistrationApplication::where('first_name', $requests->first_name)
//                ->where('father_name', $requests->father_name)
//                ->where('mother_name', $requests->mother_name)
//                ->where('site_id', $site_id)
//                ->where('date_of_birth', $date_of_birth)
//                ->first();


            $getStudentSameBirthDate = GlobalSiteStudentAdmissionApplication::where('site_id', $site_id)
                ->where('date_of_birth', $date_of_birth)
                ->select('id', 'first_name', 'last_name', 'father_name', 'mother_name')
                ->get();


            $full_name_request = ($requests->first_name) . ($requests->last_name ? $requests->last_name : '');

            if (count($getStudentSameBirthDate) > 0) {

                foreach ($getStudentSameBirthDate as $key => $value) {
                    $full_name_with_out_space = strtoupper(str_replace(' ', '', $value->full_name));
                    $father_name_with_out_space = strtoupper(str_replace(' ', '', $value->father_name));
                    $mother_name_with_out_space = strtoupper(str_replace(' ', '', $value->mother_name));


                    $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $full_name_request));
                    $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $requests->father_name));
                    $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $requests->mother_name));

//                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
//                    $present_full_name_with_out_space, $present_father_name_with_out_space,
//                        $present_mother_name_with_out_space];

                    if ($full_name_with_out_space == $present_full_name_with_out_space &&
                        $father_name_with_out_space == $present_father_name_with_out_space &&
                        $mother_name_with_out_space == $present_mother_name_with_out_space
                    ) {

                        $student_birth_date_present_array[] = 1;

                    } else {
                        $student_birth_date_present_array[] = 0;
                    }


                }

            } else {
                $student_birth_date_present_array[] = 0;
            }


            $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
            if (count($student_birth_date_present_count) > 0) {
                $student_birth_date_present = 1;
            } else {
                $student_birth_date_present = 0;
            }


            if($admission_declare_group_list->form_show_to_website){
                if ($requests->student_image == 'image-not.png') {
                    return Response::json(['message' => 'You must attach your passport size photo!'], 412);
                }
            }


            if (!$requests->date_of_birth) {
                return Response::json(['message' => 'You must fill up Date of birth Field!'], 412);

            } else if ($requests->date_of_birth) {

                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }
            }



            $date_of_birth_range=AcademicClass::where('id', $requests->academic_class_id)
                ->where('minimum_birth_date', '<=', $date_of_birth)
                ->first();

            if($date_of_birth_range){

                return Response::json(['message' => 'Your Date of Birth is not cross the govt. minimum birth date range!'], 412);

            }


           // $academicSubjectIDs = $this->academicSubjectList($requests);
            $subjectIds = $this->academicSubjectList($requests);
            $academicSubjectIDs = $subjectIds[0];
            $compulsorySubjectIDs = $subjectIds[1];

          

            $savePhoto = $this->savePhoto($requests);

            $unique_code = intval("0" . rand(1, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(1, 9) .
                    rand(0, 9) . rand(0, 9) . rand(0, 9)) . $site_id;


            $clientIP = request()->ip();

//            \Log::info('ok');


            $latest_roll = 0;
            if ($admission_declare_group_list->auto_roll_create_status) {

                $check_last_roll = $student->where('academic_version_id', $requests->academic_version_id)
                    ->where('site_student_admission_declare_id', $admission_declare_group_list->id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->select('student_roll_number')
                    ->orderBy('student_roll_number', 'desc')
                    ->first();
                    
//                \Log::info($check_last_roll);

                if ($check_last_roll) {
                    $latest_roll = $check_last_roll->student_roll_number ? $check_last_roll->student_roll_number + 1 : 1;
                } else {
                    $latest_roll = 1;
                }

            }


            // class group wise roll create

            if ($admission_declare_group_list->group_wise_roll_create_status) {

                $check_last_roll = $student->where('academic_version_id', $requests->academic_version_id)
                    ->where('site_student_admission_declare_id', $admission_declare_group_list->id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->select('student_roll_number')
                    ->orderBy('student_roll_number', 'DESC')
                    ->first();
                    
//                \Log::info($check_last_roll);

                if ($check_last_roll) {
                    $latest_roll = $check_last_roll->student_roll_number ? $check_last_roll->student_roll_number + 1 : 1;

                } else {

                    $check_student_roll_range=GlobalStudentRollCreateRange::where('site_student_admission_declare_id',$admission_declare_group_list->id)
                                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                                })
                                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                                    return $query->where('academic_class_id', $data['academic_class_id']);
                                })
                                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                                })
                                ->where('site_id', $site_list->id)
                                ->where('academic_group_id', $requests->academic_group_id)
                                ->first();

                            
                    $latest_roll = $check_student_roll_range?$check_student_roll_range->start_roll:'';
                }

            }

            $student_approve_right=$admission_declare_group_list->site_can_not_approve_student;

           // $student->where()->get()

           $single_student = $student->where('site_id', $site_list->id)->orderBy('admission_form_no','DESC')->first();
           if($single_student){
           
              $admission_form_serial_no = $single_student->admission_form_serial_no+1;
           }else{
              $admission_form_serial_no = 1;
              
           }
           $admission_form_no = sprintf('%s%04s', $site_id, $admission_form_serial_no);
          
        
            if (isset($student->ownFields)) {
                foreach ($student->ownFields as $studentField) {
                    if ($requests->{$studentField}) {
                        if (is_array($requests->{$studentField})) {
                            $student->{$studentField} = collect($requests->{$studentField})->implode(',');
                        } else {
                            $student->{$studentField} = $requests->{$studentField};

                        }
                    }
                }
               
                //   $student->passing_year = $student->passing_year;
                // $student->academic_year_id = $student->academic_year_id;
                // $student->academic_class_id = $student->academic_group_id;
                // $student->academic_class_group_id = $student->academic_class_group_id;
                // $student->board_roll_number = $student->board_roll_number;

                $student->academic_subject_ids = $academicSubjectIDs;
                $student->compulsory_subject_ids = $compulsorySubjectIDs;
                $student->admission_form_serial_no = $admission_form_serial_no;
                $student->admission_form_no = $admission_form_no;
                $student->unique_code = $unique_code;
                $student->student_image = $savePhoto;
                $student->site_id = $site_id;
                $student->client_ip = $clientIP;
                $student->site_student_admission_declare_id = $admission_declare_group_list->id;
                $student->student_roll_number = $latest_roll;
                $student->site_can_approve_student = $admission_declare_group_list->site_can_not_approve_student?false:true;
                $student->transaction_number = $requests->transaction_number??'';
//                $student->father_nid = null;

                /// add accupation and relation
                $occu_rela=$this->addAccupationAndRelation($requests);

                $student->father_occupation_id = $occu_rela['father_occupation_id'];
                $student->mother_occupation_id = $occu_rela['mother_occupation_id'];
                $student->guardian_student_relation_id = $occu_rela['guardian_student_relation_id'];

              
                /////
            }
            $student->save();
            $site_student_admission_application_id = $student->id;


            if (count($check_valid_exam_qua) > 0) {
                foreach ($check_valid_exam_qua as $key => $value) {

                    $edu = new GlobalSiteStudentAdmissionEducationQualification();

                    $edu->site_student_admission_application_id = $site_student_admission_application_id;
                    $edu->examination_id = $value['examination_id'];
                    $edu->board_roll_number = $value['board_roll_number'];
                    $edu->board_registration_number = $value['board_registration_number'];
                    $edu->institution_name = $value['institution_name'];
                    $edu->academic_board_id = $value['academic_board_id'];
                    $edu->academic_session_id = $value['academic_session_id'];
                    $edu->passing_year = $value['passing_year'];
                    $edu->gpa_with_optional = $value['gpa_with_optional'];
                    $edu->gpa_without_optional = $value['gpa_without_optional'];

                    $edu->save();

                }
            }


            $message = [$student->full_name, $unique_code];

            // update board selected list

            $this->updateBoardSelectedCandidateList($data,$site_list);
           
            $admission_declare_list = GlobalSiteStudentAdmissionDeclare::where('site_id', $site_id)
                ->where('academic_group_id', $requests->academic_group_id)
                ->where('status', true)
                ->first();


            if ($admission_declare_list->send_sms) {
                if ($requests->student_contact_number) {

                    $url = config('app.url');

                    // $sms_txt = 'Congrats, ' . $student->full_name;
                    // $sms_txt .= '[nl]' . '. Your admission form has been successfully submitted.';
                    // $sms_txt .= '[nl]' . 'Your Unique Code: ' . $unique_code;
                    // $sms_txt .= '[nl]' . 'Regards: ' . $site_list->short_name;
                 
                    $sms_txt = 'Congrats, ' . $student->full_name;
                    $sms_txt .= ',' . ' Your admission form has been successfully submitted';
                    $sms_txt .= '.' . 'Your Unique Code: ' . $unique_code;
                    $sms_txt .= ', ' . 'Thanks : ' . $site_list->site_alias;

                    $tt = $this->sendSms($site_id, [$requests->student_contact_number], $sms_txt);
                } else {
                    DB::rollBack();
                    throw new Error('Please Input Contact Number Field');
                }
            }


            DB::commit();
            return Response::json(['message' => $message, 'mode' => 'Registred!'], 200);

        // }
        // catch (ValidationException $exception) {
        //     DB::rollBack();
        //     return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        // } catch (Exception $exception) {
        //     DB::rollBack();
        //     return Response::json(['message' => $exception->getMessage()], 410);
        // }


    }

    private function addAccupationAndRelation($requests){
     
        $father_occupation_id=$requests->father_occupation_id;
        $mother_occupation_id=$requests->mother_occupation_id;
        $guardian_student_relation_id=$requests->guardian_student_relation_id;

        if($requests->father_occupation_id=='others' && !empty($requests->father_occupation)){
            $check_occu=AcademicOccupation::where('occupation_name',$requests->father_occupation)
                ->where('status',1)
                ->first();
            if($check_occu){
                $father_occupation_id=$check_occu->id;
            }else{
                $academic_occu=new AcademicOccupation;
                $academic_occu->occupation_name=ucwords($requests->father_occupation);
                $academic_occu->status=1;
                $academic_occu->save();
                $father_occupation_id=$academic_occu->id;
            }

        }

        if($requests->mother_occupation_id=='others' && !empty($requests->mother_occupation)){
            $check_occu=AcademicOccupation::where('occupation_name',$requests->mother_occupation)
                ->where('status',1)
                ->first();
            if($check_occu){
                $mother_occupation_id=$check_occu->id;
            }else{
                $academic_occu=new AcademicOccupation;
                $academic_occu->occupation_name=ucwords($requests->mother_occupation);
                $academic_occu->status=1;
                $academic_occu->save();
                $mother_occupation_id=$academic_occu->id;
            }

        }

        if($requests->guardian_student_relation_id=='others' && !empty($requests->guardian_student_relation)){
            $check_rel=RelationTranslation::where('relation_name',$requests->guardian_student_relation)->first();
           
            if($check_rel){
                $guardian_student_relation_id=$check_rel->relation_id;
            }else{
                $rela=new Relation;
                $rela->status=1;
                $rela->save();

                $rela_tra=new RelationTranslation;
                $rela_tra->relation_name=ucwords($requests->guardian_student_relation);
                $rela_tra->relation_id=$rela->id;
                $rela_tra->locale='en';
                $rela_tra->save();
                $guardian_student_relation_id=$rela->id;
            }

        }
       

       return [
            'father_occupation_id'=>$father_occupation_id,
            'mother_occupation_id'=>$mother_occupation_id,
            'guardian_student_relation_id'=>$guardian_student_relation_id
       ];

    }

    private function updateBoardSelectedCandidateList($data,$site_list){
        $getDeclaredList = $this->getDeclaredList($data['academic_group_id']);

        $selectedCandidate = GlobalSiteStudentAdmissionBoardApprove::
            where('academic_version_id', $data['academic_version_id'])
            ->where('academic_group_id', $data['academic_group_id'])
            ->where('site_student_admission_declare_id', $getDeclaredList->id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['board_roll_number']), function ($query) use ($data) {
                return $query->where('board_roll_number', $data['board_roll_number']);
            })
            ->when(!empty($data['academic_board_id']), function ($query) use ($data) {
                return $query->where('academic_board_id', $data['academic_board_id']);
            })
            ->when(!empty($data['passing_year']), function ($query) use ($data) {
                return $query->where('passing_year', $data['passing_year']);
            })
            ->where('site_id', $site_list->id)
            ->where('status',1)
            ->first();

            if($selectedCandidate){
              //  $selectedCandidate->payment_status=1;
                $selectedCandidate->admission_status=1;
                
                if($selectedCandidate->save()){
                    return true;
                }else{
                    return false;
                }
            }else{
                return false;
            }
           

    }


    private function savePhoto(Request $requests)
    {


        if ($requests->student_image == "image-not.png") {
            $fileName = $requests->student_image;
        } else {

            $unique_code = intval("0" . rand(1, 9) . rand(0, 9) . rand(0, 9));

            $name = $unique_code. time() . '.' . explode('/', explode(':', substr($requests->student_image, 0, strpos($requests->student_image, ';')))[1])[1];
            $fileName = $name;
            Image::make($requests->student_image)->resize(440, 442)->save(public_path('uploads/') . $name);
        }


        return $fileName;

    }


    private function academicSubjectList(Request $requests)
    {
        $data = $requests->all();
        $site_list = $this->getSiteId();
        $site_id = $site_list->id;

        $subjectList = GlobalSubjectGroupConditionSetting::where('academic_class_id', $requests->academic_class_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('site_id', $site_id)
            ->where('academic_group_id', $requests->academic_group_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();


        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_markingless_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();

            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
            }
        }
     
        $compulsory_subject_ids = [];
        if ($requests->academic_class_group_id) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($requests->academic_class_group_id, $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }



        $selective_compulsory_subject_idList = [];
        if ($requests->selective_compulsory_subject_ids) {
            if (is_array($requests->selective_compulsory_subject_ids)) {
                $selective_compulsory_subject_idList = $requests->selective_compulsory_subject_ids;
            }else{
                $selective_compulsory_subject_idList[] = $requests->selective_compulsory_subject_ids;
            }

        }


       

      //  dd($selective_compulsory_subject_idList);

        // $compulsory_subject_idList = [];
        // if ($requests->compulsory_subject_ids) {
        //     if (is_array($requests->compulsory_subject_ids)) {
        //         $compulsory_subject_idList = $requests->compulsory_subject_ids;
        //     }else{
        //         $compulsory_subject_idList[] = $requests->compulsory_subject_ids;
        //     }

        // }

        $Optional_subject_idList = [];
        if($requests->optional_subject_ids){
            if (is_array($requests->optional_subject_ids)) {
                $Optional_subject_idList = $requests->optional_subject_ids;
            }else{
                $Optional_subject_idList[] = $requests->optional_subject_ids;
            }
        }


        $selective_markingless_subject_idList = [];
        if ($requests->selective_markingless_subject_ids) {
            if (is_array($requests->selective_markingless_subject_ids)) {
                $selective_markingless_subject_idList = $requests->selective_markingless_subject_ids;
            }else{
                $selective_markingless_subject_idList[] = $requests->selective_markingless_subject_ids;
            }
        }


        $religion_subject = [];
        if ($requests->religion_subject_id) {
            $religion_subject[] = $requests->religion_subject_id;
        }

      //  dd('$selective_compulsory_subject_idList');

        $Subjects = array_merge(
            $general_subject_ids,
            $general_markingless_subject_ids,
            $compulsory_subject_ids,
            // $compulsory_subject_idList,
            $Optional_subject_idList,
            // $selective_markingless_subject_idList,
            $religion_subject,
            $selective_compulsory_subject_idList
        );

        $academicSubjectIds = (string)implode(',', $Subjects);
        $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
        $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);
      
        $compulsory_ids = (string)implode(',', $compulsory_subject_ids);
        
        return [$finalAcademicSubjectIds,$compulsory_ids];
    }


    public function globalGetAdmissionAppliedStudentCheckForEditDownload($unique_code)
    {

        $site_list = $this->getSiteId();
        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');

        $student_list = GlobalSiteStudentAdmissionApplication::where('unique_code', $unique_code)
            ->where('status', true)
            ->where('site_id', $site_list->id)
            ->first();


        if ($student_list) {
            if ($student_list->approve_as_student) {
                return Response::json(['message' => 'Your form already accepted. you can not change any information.', 'mode' => 'error'], 412);
            } else if ($student_list) {
                $declare_list = GlobalSiteStudentAdmissionDeclare::where('id', $student_list->site_student_admission_declare_id)->first();
                $bank_recipt_downlaod_status = $declare_list->bank_recipt_downlaod_status;


                return response()->json(
                    [
                        'bank_recipt_downlaod_status' => $bank_recipt_downlaod_status,

                    ]);

            } else {
                return Response::json(['message' => 'Wrong Unique Code.', 'mode' => 'error'], 412);
            }
        } else {
            return Response::json(['message' => 'Wrong Unique Code.', 'mode' => 'error'], 412);
        }


    }

    public function globalGetAppliedStudentDetailForEdit($unique_code)
    {

        $site_list = $this->getSiteId();
        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');


        $student_list = GlobalSiteStudentAdmissionApplication::with(['siteStudentAdmissionEducationQualification'])
            ->where('unique_code', $unique_code)
            ->where('status', true)
            ->where('site_id', $site_list->id)
            ->first();


        if ($student_list) {
            $admission_declare_group_present = GlobalSiteStudentAdmissionDeclare::
            where('site_id', $site_list->id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->where('academic_group_id', $student_list->academic_group_id)
                ->first();

            if ($admission_declare_group_present) {

                if ($student_list->approve_as_student == 1) {
                    $student_final_list = 1;
                } else {
                    $student_final_list = $student_list;
                }


            } else {
                $student_final_list = 0;
            }
        } else {
            $student_final_list = 0;
        }


        return $student_final_list;

    }


    public function updateStudentEntryApplication(Request $requests)
    {
       
        try {
            DB::beginTransaction();


            $this->validate($requests, [
                "academic_version_id" => "required",
                "academic_year_id" => "required",
                "academic_shift_id" => "required",
                "academic_class_id" => "required",
                'first_name' => 'required',
                'father_name' => 'required',
                'mother_name' => 'required',
                "religion_id" => "required",
                "gender_id" => "required",
                "student_contact_number" => "required",
                "date_of_birth" => "required",
                "bcn" => "required",
                "site_student_admission_application_id" => "required",

//                "name_native_language" => "required",
//                "father_name_native_language" => "required",
//                "mother_name_native_language" => "required",


//                "academic_class_group_id" => count($requests->AcademicClassGroupList) > 0 ? "required" : "",

                "local_gurdian_name" => $requests->local_gurdian_name ? "required" : "",
                "local_gurdian_mobile" => $requests->local_gurdian_name ? "required" : "",
                "academic_session_id" => count($requests->AcademicSessionList) > 0 ? "required" : "",
//                "religion_subject_id" => count($requests->ReligionSubjectList) > 0 ? "required" : "",
                //"present_address" => "required",

            ]);

           

            $valiedate_data=$this->checkValideStudentForAdmission($requests,true,'update');
         
            if($valiedate_data){
                return $valiedate_data;
            }
            
          
            $student = GlobalSiteStudentAdmissionApplication::where('id', $requests->id)->first();

            $data = $requests->all();
            $site_list = $this->getSiteId();
            $site_id = $site_list->id;

            /////////
            $date_formate = Carbon::today();
            $today = $date_formate->format('Y-m-d');

            $admission_declare_group_list = GlobalSiteStudentAdmissionDeclare::with(['academicGroup'])
                ->select('id','site_id','academic_group_id', 'auto_roll_create_status', 'auto_roll_digit', 'education_qualification_ids',
                    'form_number_check', 'form_show_to_website', 'site_can_not_approve_student','group_wise_roll_create_status',
                    'conflig_compulsory_subject_ids','parents_contact_number_required','subject_condition_status')
                ->where('site_id', $site_list->id)
                ->where('academic_group_id', $requests->academic_group_id)
                ->where('id', $student->site_student_admission_declare_id)
                ->where('status', true)
                ->first();

        if($requests->subject_condition_status){

            if(is_array($requests->selective_compulsory_subject_ids)){
                $selective_compulsory_subject_ids= $requests->selective_compulsory_subject_ids;
            }else{
                $selective_compulsory_subject_ids= explode(',', $requests->selective_compulsory_subject_ids);
            }
    
            if(is_array($requests->optional_subject_ids)){
                $optional_subject_ids= $requests->optional_subject_ids;
            }else{
                $optional_subject_ids= explode(',', $requests->optional_subject_ids);
            }
           
    
            if($selective_compulsory_subject_ids && $optional_subject_ids){          
               for($i=0;$i<count($selective_compulsory_subject_ids);$i++){
                for($j=0;$j<count($optional_subject_ids);$j++){
                    if($selective_compulsory_subject_ids[$i]==$optional_subject_ids[$j]){
                        return Response::json(['message' => 'Compulsory and Optional Subject Match', 'mode' => 'Error'], 412);
                    }
                }
               }
    
            }
    
            //check limit subject
            
            if($requests->selective_compulsory_subject_limit){
                if(is_array($requests->selective_compulsory_subject_ids)){
                    $selective_compulsory_subject_ids_list=$requests->selective_compulsory_subject_ids;
                }else{
                    $selective_compulsory_subject_ids_list[]=$requests->selective_compulsory_subject_ids;
                }

                if($requests->selective_compulsory_subject_limit<count($selective_compulsory_subject_ids_list) ||
                    $requests->selective_compulsory_subject_limit>count($selective_compulsory_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->selective_compulsory_subject_limit . ' Compulsory Subject!.',
                        'mode' => 'Error'], 412);
                }

            }

       


            if (count($requests->CompulsorySubjectList) > 0) {
                if (is_array($requests->compulsory_subject_ids)) {
                    if (count($requests->compulsory_subject_ids) <= 0) {
                        return Response::json(['message' => 'You must Choose Compulsory Subject!'], 412);
                    }
                } else {
                    if (!$requests->compulsory_subject_ids) {
                        return Response::json(['message' => 'You must Choose Compulsory Subject!'], 412);
                    }

                }


            } else if (count($requests->OptionalSubjectList) > 0) {
                if (is_array($requests->optional_subject_ids)) {
                    if (count($requests->optional_subject_ids) <= 0) {
                        return Response::json(['message' => 'You must Choose 4th Subject!'], 412);
                    }
                } else {
                    if (!$requests->optional_subject_ids) {
                        return Response::json(['message' => 'You must Choose 4th Subject!'], 412);
                    }

                }

            }

        
            if($requests->optional_subject_limit){
                if(is_array($requests->optional_subject_ids)){
                    $optional_subject_ids_list=$requests->optional_subject_ids;
                }else{
                    $optional_subject_ids_list[]=$requests->optional_subject_ids;
                }

                if($requests->optional_subject_limit<count($optional_subject_ids_list) ||
                    $requests->optional_subject_limit>count($optional_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->optional_subject_limit . ' Optional Subject!.',
                        'mode' => 'Error'], 412);
                }

            }

           
            //  dd($admission_declare_group_list->parents_contact_number_required);

        // conflig subject list
         if(count($admission_declare_group_list->conflig_compulsory_subject_ids[0])){
            $checkConfligSubject = collect($requests->SelectiveCompulsorySubjectList)
                ->whereIn('academic_subject_id', $requests->selective_compulsory_subject_ids)
                ->whereIn('academic_subject_id', $admission_declare_group_list->conflig_compulsory_subject_ids[1]);

            $subjectNames = $checkConfligSubject->pluck('subject_name')->values(); 

            if ($subjectNames->count() > 1) {
                $last = $subjectNames->pop(); 
                $subject_array = $subjectNames->implode(', ') . ' and ' . $last;
            } else {
                $subject_array = $subjectNames->first() ?? '';
            }

            if(count($checkConfligSubject)>1){
                 return Response::json(['message' => 'You may take any one subject from '.$subject_array], 412);
            }
        }

        } //subject_condition_status end
            /////


            if($admission_declare_group_list->parents_contact_number_required){

                  if($requests->father_contact_number=='' && $requests->father_occupation_id!=36){
                    return Response::json(['message' => "Fathers' contact numbers is required."], 412);

                }
                if($requests->mother_contact_number=='' && $requests->mother_occupation_id!=36){
                    return Response::json(['message' => "Mothers' contact numbers is required."], 412);

                }
              
            }



            $date_formate = Carbon::parse($requests->date_of_birth);
            $date_of_birth = $date_formate->format('Y-m-d');


            $getStudentSameBirthDate = GlobalSiteStudentAdmissionApplication::where('site_id', $site_id)
                ->where('date_of_birth', $date_of_birth)
                ->where('id', '!=', $requests->id)
                ->select('id', 'first_name', 'last_name', 'father_name', 'mother_name')
                ->get();


            $full_name_request = ($requests->first_name) . ($requests->last_name ? $requests->last_name : '');

            if (count($getStudentSameBirthDate) > 0) {

                foreach ($getStudentSameBirthDate as $key => $value) {
                    $full_name_with_out_space = strtoupper(str_replace(' ', '', $value->full_name));
                    $father_name_with_out_space = strtoupper(str_replace(' ', '', $value->father_name));
                    $mother_name_with_out_space = strtoupper(str_replace(' ', '', $value->mother_name));


                    $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $full_name_request));
                    $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $requests->father_name));
                    $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $requests->mother_name));

//                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
//                    $present_full_name_with_out_space, $present_father_name_with_out_space,
//                        $present_mother_name_with_out_space];

                    if ($full_name_with_out_space == $present_full_name_with_out_space &&
                        $father_name_with_out_space == $present_father_name_with_out_space &&
                        $mother_name_with_out_space == $present_mother_name_with_out_space
                    ) {

                        $student_birth_date_present_array[] = 1;

                    } else {
                        $student_birth_date_present_array[] = 0;
                    }


                }

            } else {
                $student_birth_date_present_array[] = 0;
            }


            $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
            if (count($student_birth_date_present_count) > 0) {
                $student_birth_date_present = 1;
            } else {
                $student_birth_date_present = 0;
            }


            //  throw new \Error($requests->user_id);
            //  throw new \Error($studentList);


//            if ($requests->student_image == 'image-not.png') {
//                return Response::json(['message' => 'You must be attach your passport size photo!'], 412);
//            }

            if (!$requests->date_of_birth) {
                return Response::json(['message' => 'You must be fill up Date of birth Field!'], 412);

            } else if ($requests->date_of_birth) {

                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }

            }


            $subjectIds = $this->academicSubjectList($requests);

        //    dd($subjectIds);
            $academicSubjectIDs = $subjectIds[0];
            $compulsorySubjectIDs = $subjectIds[1];




            if ($student->student_image == $requests->student_image) {
                $image_name = $student->student_image;
            } else {
                if ($student->student_image != 'image-not.png') {
                    $image_path = "uploads/" . $student->student_image;  // Value is not URL but directory file path
                    if (File::exists($image_path)) {
                        File::delete($image_path);
                    }

                    $image_name = $this->savePhoto($requests);

                } else if ($student->student_image == 'image-not.png') {

                    $image_name = $this->savePhoto($requests);

                }

            }


            $clientIP = request()->ip();

            if (isset($student->ownFields)) {
                foreach ($student->ownFields as $studentField) {
                    if ($requests->{$studentField}) {
                        if (is_array($requests->{$studentField})) {
                            $student->{$studentField} = collect($requests->{$studentField})->implode(',');
                        } else {
                            $student->{$studentField} = $requests->{$studentField};

                        }
                    }
                }

                $student->site_id = $site_id;
                $student->student_image = $image_name;
                $student->academic_subject_ids = $academicSubjectIDs;
                $student->compulsory_subject_ids = $compulsorySubjectIDs;
//               $student->father_nid = null;
                $student->client_ip = $clientIP;

                 /// add accupation and relation
                 $occu_rela=$this->addAccupationAndRelation($requests);

                 $student->father_occupation_id = $occu_rela['father_occupation_id'];
                 $student->mother_occupation_id = $occu_rela['mother_occupation_id'];
                 $student->guardian_student_relation_id = $occu_rela['guardian_student_relation_id'];


            }
            $student->save();


            $qualification_all_ids = GlobalSiteStudentAdmissionEducationQualification::where('site_student_admission_application_id', $requests->id)->pluck('id');

            $check_valid_exam_qua = collect($requests->QualificationList)->where('examination_id', '!=', null);


            $qualification_present_ids = [];
            if (count(collect($check_valid_exam_qua)) > 0) {

                foreach ($check_valid_exam_qua as $key => $value) {

                    if ($value['id']) {
                        $qualification_present_ids[] = $value['id'];
                        $edu = GlobalSiteStudentAdmissionEducationQualification::where('id', $value['id'])->first();
                    } else {
                        $edu = new GlobalSiteStudentAdmissionEducationQualification();
                    }


                    $edu->site_student_admission_application_id = $requests->id;
                    $edu->examination_id = $value['examination_id'];
                    $edu->board_roll_number = $value['board_roll_number'];
                    $edu->board_registration_number = $value['board_registration_number'];
                    $edu->institution_name = $value['institution_name'];
                    $edu->academic_board_id = $value['academic_board_id'];
                    $edu->academic_session_id = $value['academic_session_id'];
                    $edu->passing_year = $value['passing_year'];
                    $edu->gpa_with_optional = $value['gpa_with_optional'];
                    $edu->gpa_without_optional = $value['gpa_without_optional'];

                    $edu->save();

                }
            }


            if (count($qualification_all_ids) > 0) {
                $check_data = array_diff($qualification_all_ids->toArray(), $qualification_present_ids);


                GlobalSiteStudentAdmissionEducationQualification::whereIn('id', $check_data)->delete();
            }


//        if ($student->save()) {
//            if (strpos($requests->student_image, 'base64')) {
//                $this->savePhoto($student, $requests);
//            }
//
//        }

            DB::commit();
            return Response::json(['message' => 'Information Update Successfully!', 'mode' => 'Update!']);


        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);


        }
    }


    public function downloadStudentAdmissionForm($unique_code)
    {

        $site_list = $this->getSiteId();
        $site_id = $site_list->id;
        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');


        $student_list = GlobalSiteStudentAdmissionApplication::with(['siteStudentAdmissionEducationQualification' => function ($query) {
            $query->with(['examination', 'academicBoard', 'academicSession']);
        },
            'presentCountry', 'presentDivision', 'presentDistrict', 'presentThana',
            'permanentCountry', 'permanentDivision', 'permanentDistrict', 'permanentThana',
            'religion', 'gender', 'bloodGroup', 'relation','studentType',
            'year', 'shift', 'department', 'stClass', 'classGroup', 'session','fatherOccupation','motherOccupation'])
            ->where('unique_code', $unique_code)
            ->where('status', true)
            ->where('site_id', $site_list->id)
            ->first();


          //  dd($student_list->siteStudentAdmissionEducationQualification);

         
        $getDeclaredList = $this->getDeclaredList($student_list->academic_group_id);

        $language_set = $getDeclaredList->admission_form_language;
        $pdf_language_set = $getDeclaredList->admission_form_pdf_language;


        $roll_number = sprintf("%0" . $getDeclaredList->auto_roll_digit . "d", $student_list->student_roll_number);


        $subject_arr = $this->studentSelectedSubject($student_list);

        $general_subject_list = $subject_arr[0];
        $compulsory_subject_list = $subject_arr[1];
        $optional_subject_list = $subject_arr[2];


        $emp_designation = Employee::where('institute_head', true)->pluck('designation_id');
        $designation_list = Designation::whereIn('id', $emp_designation)->first();
        $designation_name = $designation_list->name ?? '';


        $term_condition = $getDeclaredList->term_condition;


        $viewType = 'Dashboard';
        $report_tittle = 'Admission Form';
        $report_tittle2 = '';

        $file_name_combination = $student_list->unique_code;
      //  dd($student_list);

        $view = View::make('default.admin.site.admission.admission-form-details-pdf',
            compact('viewType', 'student_list','getDeclaredList', 'term_condition', 'report_tittle', 'report_tittle2', 'general_subject_list',
                'compulsory_subject_list', 'optional_subject_list', 'designation_name', 'site_list', 'language_set','pdf_language_set',
                'roll_number'));

        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
        $time = 'admission-form-'.$site_list->site_alias.'-'.$file_name_combination . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
     //   $time = $file_name_combination . '-' . Carbon::now()->unix();
       //$mpdf->Output($time . '.pdf', 'D');

        $name = $time . '.pdf';


        return Response::json(['link' => route('web-open-pdf-file', [$name]), 'message' => 'Successfully Created Report'], 200);

    }


    private function studentSelectedSubject($student_list)
    {
      //  dd($student_list);

        $site_list = $this->getSiteId();
        $site_id = $site_list->id;


        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');

    //    $test = explode(',', $student_list->academic_class_group_id);

       // dd($academic_class_group_id);

        $subjectList = GlobalSubjectGroupConditionSetting::where('academic_class_id', $student_list->academic_class_id)
            ->where('academic_year_id', $student_list->academic_year_id)
            ->where('site_id', $site_id)
            ->where('academic_group_id', $student_list->academic_group_id)
          //  ->whereIn('academic_class_group_ids', $student_list->academic_class_group_id)
            ->when(!empty($student_list['academic_department_id']), function ($query) use ($student_list) {
                return $query->where('academic_department_id', $student_list['academic_department_id']);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();


        //====Geleral Subject
        $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);


            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_subject_list = $subjectList->whereIn('academic_subject_id', $general_subject_ids)
            ->values();

   ////////////

         //====Compulsory Subject

         $compulsory_subject_ids = [];
         $sielective_compulsory_subject_ids = [];
         foreach ($subjectList as $key => $value) {
 
             $academicCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
 
             $subjectCompulsoryCondition = SubjectCondition::where('condition_key', 'compulsory')->first();
             $subjectSelectiveCompulsoryCondition = SubjectCondition::where('condition_key', 'selectiveCompulsory')->first();
 
             if (in_array($subjectCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                 $compulsory_subject_ids[$key] = $value->academic_subject_id;
             }
             if (in_array($subjectSelectiveCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                 $sielective_compulsory_subject_ids[$key] = $value->academic_subject_id;
             }
           
         }

        
         
       //  dd($compulsory_subject_ids);
         $student_compulsory_subject_ids = ($student_list->compulsory_subject_ids)[1]?? [];
         $student_selective_compulsory_subject_ids = ($student_list->selective_compulsory_subject_ids)[1]?? [];
        
         $student_selective_compulsory_subject_ids = $student_list->selective_compulsory_subject_ids[1] ?? [];
 
 
         if (count($student_selective_compulsory_subject_ids) > 0) {
             $compulsory_subject_final_ids = collect(array_merge($student_compulsory_subject_ids,
                 $student_selective_compulsory_subject_ids))->unique();
         } else {
             $compulsory_subject_final_ids = $student_compulsory_subject_ids;
         }

        //  dd($compulsory_subject_final_ids);
         
         $compulsory_subject_list = $subjectList->whereIn('academic_subject_id', $compulsory_subject_final_ids)
             ->values();

        //     dd($compulsory_subject_list);


        //====Compulsory Subject
        // $subjectCompulsoryCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

        // $compulsory_subject_ids = [];
        // foreach ($subjectList as $key => $value) {

        //     $academicCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

        //     if (in_array($subjectCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
        //         $compulsory_subject_ids[$key] = $value->academic_subject_id;
        //     }
        // }

        // $student_compulsory_subject_ids = $student_list->compulsory_subject_ids[1] ?? [];
        // $student_selective_compulsory_subject_ids = $student_list->selective_compulsory_subject_ids[1] ?? [];


        // if (count($student_selective_compulsory_subject_ids) > 0) {
        //     $compulsory_subject_final_ids = collect(array_merge($student_compulsory_subject_ids,
        //         $student_selective_compulsory_subject_ids))->unique();
        // } else {
        //     $compulsory_subject_final_ids = $student_compulsory_subject_ids;
        // }


        // $compulsory_subject_list = $subjectList->whereIn('academic_subject_id', $compulsory_subject_final_ids)
        //     ->values();


        //====Optional Subject
        $subjectOptionalCondition = SubjectCondition::where('condition_key', 'optional')->first();

        $optional_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            if (in_array($subjectOptionalCondition->id, $academicOptionalSubjectConditionIds)) {
                $optional_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $student_selective_optional_subject_ids = ($student_list->optional_subject_ids)[1];


        $optional_subject_list = $subjectList->whereIn('academic_subject_id', $student_selective_optional_subject_ids)
            ->whereIn('academic_subject_id', $optional_subject_ids)
            ->values();

          //  dd($compulsory_subject_list);
        return [$general_subject_list, $compulsory_subject_list, $optional_subject_list];


    }


}
