<?php

namespace App\Http\Controllers\SitePublic\Site;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Auth\Guard;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use Response;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Student\StudentHistory;
use App\Models\Student\PublicStudentHistory;
use App\Models\Site\Student\Student;
use App\Models\User\User;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\GlobalSiteInfo;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Site\Result\ExamResultTrait;
use Session;
use Exception;
use Illuminate\Http\JsonResponse;

class PublicDataForQrCodeController extends Controller
{
    use ExamResultTrait;
    
    public function index()
    {
        $viewType ='Student Information';
        return view('web.index', compact('viewType'));
    }

    public function checkExamResultForQrCode($exam_id,$student_history_id,$result_id){
     
        try{
        $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                'registration_no');
            $query->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }, 'academicResultPrimaryType'])
            ->where('id', $exam_id)
            ->where('student_history_id', $student_history_id)
            ->where('academic_result_primary_type_id', $result_id)
            ->where('status', true)
            ->first();

            $data=[];

            $data['full_name']=$dataaa->studentHistory->full_name;
            $data['father_name']=$dataaa->studentHistory->student->father_name;
            $data['mother_name']=$dataaa->studentHistory->student->mother_name;
            $data['year_name']=$dataaa->studentHistory->year->year_name;
            $data['shift_name']=$dataaa->studentHistory->shift->shift_name;
            $data['department_name']=$dataaa->studentHistory->department?$dataaa->studentHistory->department->name:null;
            $data['class_name']=$dataaa->studentHistory->stClass?$dataaa->studentHistory->stClass->class_name:null;
            $data['student_roll_number']=$dataaa->studentHistory->student_roll_number;
            $data['group_name']=$dataaa->studentHistory->classGroup?$dataaa->studentHistory->classGroup->group_name:null;
            $data['session_name']='';
            $data['section_name']=$dataaa->studentHistory->section?$dataaa->studentHistory->section->section_name:null;
            $data['registration_no']=$dataaa->studentHistory->registration_no;
            $data['board_registration_number']=$dataaa->studentHistory->board_registration_number;
           
            $data['academic_result_primary_type']=$dataaa->academicResultPrimaryType->name;
            $data['sum_of_raw_total_marks']='';
            $data['sum_of_obtain_raw_total_marks']='';
            $data['raw_obtain_marks_percentage']='';
            $data['gpa']=$dataaa->gpa;
            $data['grade']=$dataaa->grade;
            $data['student_rank']=$dataaa->student_rank;
            $data['fail_subject_count']=$dataaa->fail_subject_count;

           return Response::json($data);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function studentQrResultPdf($result_id,$student_history_id,$result_type_id){


        $data=[];
       // $data['site_id']=Session::get('SITE_ID');
        $student_history_ids=[$student_history_id];

        $checkResult=GlobalSiteStudentPrimaryResultDetail::where('id',$result_id)
            ->where('student_history_id', $student_history_id)
            ->where('academic_result_primary_type_id', $result_type_id)
            ->first();

        
        $studentHistory=GlobalStudentHistory::with('site')
            ->where('id', $student_history_id)
        //    ->where('status',true)
            ->orderBy('id','DESC')
            ->first();

        if(!$studentHistory || !$checkResult){
            abort(404);
        }    
        
        $data['site_id']=$studentHistory->site_id;
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;
        $data['academic_result_primary_type_id']=$result_type_id;

        $resultPdf=$this->studentResulDetailsPdf($data,$student_history_ids,'site_qr');

        if($resultPdf['status']==200){
            return $resultPdf['stream_pdf'];
        }else{
            abort(404);
        }
    
    }

    public function getStudentDetails(Request $request,$username, $site_id, $student_history_id){

        $currenturl = explode('.',$request->getHttpHost());
        $site_alias=$currenturl[0];
        
        $site_info=SiteInfo::where('site_alias',$site_alias)->where('id',$site_id)->first();

        if($site_info){
        $getStudent=PublicStudentHistory::with(['publicUser' => function ($q) use ($username){
           return $q->with('latestPhoto')
                ->where('username', $username)
                ->where('user_type', 'student')
                ->select('id','username');
        },
            'year', 'shift','department','stClass','classGroup','session','section','version'
        ])
        ->whereHas('publicUser',function($que) use ($username){
          return $que->where('username', $username);
        })
        ->where('id',$student_history_id)
        ->where('site_id',$site_info->id)
        ->where('status', true)
        ->select('id','user_id','student_roll_number','academic_class_id','academic_department_id',
        'academic_shift_id','academic_session_id','academic_class_group_id')
        ->first();
           
        if($getStudent){
            $image_path=$getStudent->publicUser->latestPhoto?$getStudent->publicUser->latestPhoto->path:null;
            $default_image = "\images\image-not.png";

            // this extra condition for mistech path
            if(substr_count($image_path,"/")==1){
                $image_path='/'.$image_path;
            }
          
              if($image_path){
                  if(file_exists( public_path().$image_path )){
                      $image=$image_path;
                  }else{
                      $image=$default_image;
                  }
              }else{
                  $image=$default_image;
              }
      
              $data=[];
              $data['name']=$getStudent->full_name;
              $data['username']=$getStudent->publicUser->username;
              $data['roll_number']=$getStudent->student_roll_number??null;
              $data['email']=$getStudent->publicUser->email??null;
              $data['image']=$image;
              $data['shift']=$getStudent->shift?$getStudent->shift->shift_name:null;
              $data['version']=$getStudent->version?$getStudent->version->version_name:null;
              $data['class']=$getStudent->stClass?$getStudent->stClass->class_name:null;
              $data['department']=$getStudent->department?$getStudent->department->name:null;
              $data['group']=$getStudent->classGroup?$getStudent->classGroup->group_name:null;
              $data['section']=$getStudent->section?$getStudent->section->section_name:null;
              $data['session']=$getStudent->session?$getStudent->session->session_name:null;
              $data['year']=$getStudent->year?$getStudent->year->session_year:null;
             
            return Response::json($data,200);
        }else{
            return Response::json('This Student is not Active',401);
        }
    }else{
        return Response::json('This Student is not Active',401);
    }
    
    }

    public function checkCombineExamResultForQR($student_history_id,$result_id, $academic_version_id,$academic_year_id,$academic_shift_id,$academic_class_id){

        $academic_department_id = null;
        $academic_class_group_id = 4;

        $CombineResultSettingList = SiteResultCombineSetting::with([
           'academicResultCombineType',
           'academicResultPrimaryType'
            ])
            ->where('academic_version_id', $academic_version_id)
            ->where('academic_year_id', $academic_year_id)
            ->where('academic_shift_id', $academic_shift_id)
            ->where('academic_class_id', $academic_class_id)
            ->when(!empty($academic_department_id), function ($query) use ($academic_department_id) {
                return $query->where('academic_department_id', $academic_department_id);
            })
            ->when(!empty($academic_class_group_id), function ($query) use ($academic_class_group_id) {
                return $query->where('academic_class_group_id', $academic_class_group_id);
            })
           ->where('academic_result_combine_type_id', $result_id)
           ->where('status', true)
            ->get();

            
          
        $primary_result_ids=$CombineResultSettingList->pluck('academic_result_primary_type_id')->unique();
        $marks_percentage_status=$CombineResultSettingList->first();
          
        $primary_result_list=SiteStudentPrimaryResultDetailForTabulation::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id',
                'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number');

            $query->with(['student' => function ($q) {
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }, 'academicResultPrimaryType'])

        ->where('student_history_id', $student_history_id)
        ->whereIn('academic_result_primary_type_id', $primary_result_ids)
        ->first();

            $getStudent=StudentHistory::with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ])
            ->where('id',$student_history_id)
            ->first();
            
            $single_student_primary_result_list=$primary_result_list->where('student_history_id', $student_history_id);
            $site_individual_combine_subject_result_store_array=[];

            foreach ($CombineResultSettingList as $keys => $values){
                    $check_primary_result=$single_student_primary_result_list
                        ->where('academic_result_primary_type_id', $values->academic_result_primary_type_id)
                        ->first();
                        
                    if($check_primary_result){
                        foreach ($check_primary_result->site_individual_combine_subject_result_store_ids as $keyst => $valuest){
                            $site_individual_combine_subject_result_store_array[]=$valuest;
                        }
                    }
            }

            $site_individual_combine_subject_result_store_groupby=collect($site_individual_combine_subject_result_store_array)
                ->groupBy('exam_dependent_academic_subject_id');

            $grade_list=SiteResultSystemSetting::with(['academicResultSystem'])
                 ->where('academic_version_id', $academic_version_id)
                 ->where('academic_year_id', $academic_year_id)
                // ->where('academic_shift_id', $academic_shift_id)
                 ->where('academic_class_id', $academic_class_id)
                // ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                //     return $query->where('academic_department_id', $data['academic_department_id']);
                // })
                ->where('status', true)
                ->get()
                ->sortBy(function ($item) {
                    return $item->academicResultSystem->serial ?? 0;
                });

            $subject_arr=Array();
            $sudent_subject_info=[];
            $subject_array=[];
           
            foreach ($site_individual_combine_subject_result_store_groupby as $keysr => $valuesr){
               
                if(count($valuesr)==1){
                  
                    $subject_arr['raw_average_total_marks']=$valuesr[0]->raw_total_marks;
                    $subject_arr['obtain_average_subject_total_marks']=$valuesr[0]->obtain_subject_total_marks;
                    $subject_arr['subject_average_marks_percentage']=$valuesr[0]->subject_marks_percentage;
                    $subject_arr['obtain_average_raw_total_marks']=$valuesr[0]->obtain_raw_total_marks;
                    $subject_arr['obtain_average_percent_total_marks']=$valuesr[0]->obtain_percent_total_marks;
                    $subject_arr['subject_position']=$valuesr[0]->subject_position;
                    $subject_arr['subject_code']=$valuesr[0]->subject_position;
                  
                    $subject_array[$keysr]=array_merge($subject_arr, $valuesr->toArray());
                    $raw_total_marksee=collect($subject_array)->sum('subject_marks_percentage');
                }
                else{
                    $student_subject_exam_arr=Array();
                    $student_subject_exam_array=[];
                    foreach ($CombineResultSettingList as $keys => $values){
                        $check_primary_result_list=$valuesr
                            ->where('academic_result_primary_type_id', $values->academic_result_primary_type_id)
                            ->first();
                        if($check_primary_result_list){
                            if($marks_percentage_status->marks_percentage){
                                $student_subject_exam_arr['exam']=$values->academicResultPrimaryType;
                                $student_subject_exam_arr['combine_percentage']=$values->marks_percentage;
                                $student_subject_exam_arr['academic_result_primary_type_id']=$check_primary_result_list->academic_result_primary_type_id;
                                $student_subject_exam_arr['exam_dependent_academic_subject_id']=$check_primary_result_list->exam_dependent_academic_subject_id;
                                $student_subject_exam_arr['optional_academic_subject_status']=$check_primary_result_list->optional_academic_subject_status;
                                $student_subject_exam_arr['subject_base_pass_fail_status']=$check_primary_result_list->subject_base_pass_fail_status;
                                $student_subject_exam_arr['result_show_in_table_bellow_status']=$check_primary_result_list->result_show_in_table_bellow_status;
                                $student_subject_exam_arr['subject_position']=$check_primary_result_list->subject_position;
                                $student_subject_exam_arr['raw_total_marks']=$check_primary_result_list->raw_total_marks*$values->marks_percentage/100;
                                $student_subject_exam_arr['obtain_subject_total_marks']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                                    *$check_primary_result_list->obtain_subject_total_marks/$check_primary_result_list->raw_total_marks;
                                $student_subject_exam_arr['subject_marks_percentage']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                    *$check_primary_result_list->subject_marks_percentage/$check_primary_result_list->raw_total_marks;
                                $student_subject_exam_arr['obtain_raw_total_marks']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                    *$check_primary_result_list->obtain_raw_total_marks/$check_primary_result_list->raw_total_marks;
                                $student_subject_exam_arr['obtain_percent_total_marks']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                    *$check_primary_result_list->obtain_percent_total_marks/$check_primary_result_list->raw_total_marks;

                                $student_subject_exam_array[$keys]=array_merge($student_subject_exam_arr);
                            }else{
                                $student_subject_exam_array[$keys]=$check_primary_result_list;
                            }
                        }
                    }
                    $subject_condition = SubjectGroupConditionSetting::with(['academicSubject'])->where('academic_subject_id', $valuesr[0]->exam_dependent_academic_subject_id)->first();;
              
                  
                    $subject_arr['subject_code']=$subject_condition->subject_code;
                    $subject_arr['subject_name']=$subject_condition->academicSubject->subject_name;

                    $first_value_of_data=collect($student_subject_exam_array)->first();

                    $subject_arr['exam_list']=$student_subject_exam_array;
                    $subject_arr['academic_result_primary_type_id']=$first_value_of_data['academic_result_primary_type_id'];
                    $subject_arr['exam_dependent_academic_subject_id']=$first_value_of_data['exam_dependent_academic_subject_id'];
                    $subject_arr['result_show_in_table_bellow_status']=$first_value_of_data['result_show_in_table_bellow_status'];
                    $subject_arr['subject_position']=$first_value_of_data['subject_position'];

                    $optional_subject_present=collect($student_subject_exam_array)
                        ->pluck('optional_academic_subject_status')
                        ->unique()
                        ->filter();
                    $subject_arr['optional_academic_subject_status']=count($optional_subject_present)>0?1:0;

                    $subject_base_pass_fail_count=collect($student_subject_exam_array)
                        ->sum('subject_base_pass_fail_status');
                    $subject_arr['subject_base_pass_fail_status']=$subject_base_pass_fail_count/count(collect($student_subject_exam_array))==1?1:0;

                    $raw_total_marks=collect($student_subject_exam_array)
                        ->sum('raw_total_marks');
                      
                    $subject_arr['raw_total_marks']=$raw_total_marks;

                    $obtain_subject_total_marks=collect($student_subject_exam_array)
                        ->sum('obtain_subject_total_marks');
                    $subject_arr['obtain_subject_total_marks']=$obtain_subject_total_marks;

                    $subject_marks_percentage=collect($student_subject_exam_array)
                        ->sum('subject_marks_percentage');
                    $subject_arr['subject_marks_percentage']= number_format((float)$subject_marks_percentage, 2, '.', '');

                    $sbj_total_grade=$grade_list
                    ->where('number_from', '<=', $subject_marks_percentage)
                    ->Where('number_to', '>=', $subject_marks_percentage)
                    ->first();

                    $subject_arr['combine_grade_point']=$sbj_total_grade->point ?? '-';
                    $subject_arr['combine_grade']=$sbj_total_grade->academicResultSystem->name ?? '-';

                    $obtain_raw_total_marks=collect($student_subject_exam_array)
                        ->sum('obtain_raw_total_marks');
                    $subject_arr['obtain_raw_total_marks']=$obtain_raw_total_marks;

                    $obtain_percent_total_marks=collect($student_subject_exam_array)
                        ->sum('obtain_percent_total_marks');
                    $subject_arr['obtain_percent_total_marks']=$obtain_percent_total_marks ?? '-';

                    if($marks_percentage_status->marks_percentage){
                        $subject_arr['raw_average_total_marks']=$raw_total_marks ?? '-';
                        $subject_arr['obtain_average_subject_total_marks']=$obtain_subject_total_marks ?? '-';
                        $subject_arr['subject_average_marks_percentage']=$subject_marks_percentage ?? '-';
                        $subject_arr['obtain_average_raw_total_marks']=$obtain_raw_total_marks ?? '-';
                        $subject_arr['obtain_average_percent_total_marks']=$obtain_percent_total_marks ?? '-';
                    }else{

                        $subject_arr['raw_average_total_marks']=$raw_total_marks/count(collect($student_subject_exam_array)) ?? '-';
                        $subject_arr['obtain_average_subject_total_marks']=$obtain_subject_total_marks/count(collect($student_subject_exam_array)) ?? '-';
                        $subject_arr['subject_average_marks_percentage']=$subject_marks_percentage/count(collect($student_subject_exam_array)) ?? '-';
                        $subject_arr['obtain_average_raw_total_marks']=$obtain_raw_total_marks/count(collect($student_subject_exam_array)) ?? '-';
                        $subject_arr['obtain_average_percent_total_marks']=$obtain_percent_total_marks/count(collect($student_subject_exam_array)) ?? '-';
                    }
                    $subject_array[$keysr]=array_merge($subject_arr, $valuesr->toArray());
                    $raw_total_marksee=collect($subject_array)->sum('subject_marks_percentage');
                    
                   
                }
            }

            usort($subject_array, function($a, $b) {
                return $a['subject_position'] > $b['subject_position'] ? 1 : -1;
            });
            $average_marks = $raw_total_marksee/count(collect($subject_array));
            $total_grade=$grade_list
            ->where('number_from', '<=', $average_marks)
            ->Where('number_to', '>=', $average_marks)
            ->first();

      
            $sudent_subject_info['subjects'] = $subject_array;
            $sudent_subject_info['student_history'] = $getStudent;
            $sudent_subject_info['combine_exam_type']=$marks_percentage_status->academicResultCombineType->name;
            $sudent_subject_info['combine_result_type_id']=$marks_percentage_status->academicResultCombineType->id;
            
            $sudent_subject_info['student_history_id']=$getStudent->id;

            $sudent_subject_info['student_photo']=$getStudent->student->latestPhoto?
            $getStudent->student->latestPhoto->name:'image-not.png';
            
            $sudent_subject_info['combine_total_percent_marks']= number_format((float)$raw_total_marksee, 2, '.', '');
            $sudent_subject_info['combine_total_average_percent_marks'] = number_format((float)$average_marks, 2, '.', '');
            $sudent_subject_info['combine_grade_point']=$total_grade->point;
            $sudent_subject_info['combine_grade']=$total_grade->academicResultSystem->name;
    }

}
