<?php

namespace App\Http\Controllers\student;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Student\Student;
use App\Models\User\UserMessage;
use App\Models\Student\StudentHistory;
use App\Models\Attendance\StudentAttendance;
use Auth;
use Session;

class StudentTimelineController extends Controller
{
    private $student;
    private $studentHistory;
    private $studentAttendance;
    private $timeline;

    public function __construct(UserMessage $timeline, Student $student, StudentHistory $studentHistory, StudentAttendance $studentAttendance)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->student = $student;
        $this->studentHistory = $studentHistory;
        $this->studentAttendance = $studentAttendance;
        $this->timeline = $timeline;
    }

    public function addStudentTimeline(Request $request){
      
        $this->validate($request, [
            "student_history_id" => "required",
            "title" => "required",
            "message" => "required",
        ]);
        $history = $this->studentHistory->select('id','user_id')->findOrFail($request->student_history_id);

        if($request->id){
            $timeline=$this->timeline->findOrFail($request->id);
            if($timeline->created_by==Auth::user()->id || Auth::user()->user_type=='admin'){
            //    return response()->json($item, 200);
            }else{
                return response()->json(['message'=>'You Have No Permission'], 402);
            }
        }else{
            $timeline=new $this->timeline;
        }

        $timeline->user_id=$history->user_id;
        $timeline->title=$request->title;
        $timeline->message=$request->message;
        $timeline->message_type_key='timeline';
        $timeline->created_by=Auth::user()->id;
        $timeline->category=$request->category;
        $timeline->save();

        return response()->json(['message'=>'Seve Successfully']);
        
    }

    public function getStudentTimeline(Request $request){
     
        $history = $this->studentHistory->select('id','user_id')->findOrFail($request->student_history_id);
    
        $timeline = UserMessage::with('user')
                ->where('user_id', $history->user_id)
                ->where('message_type_key', 'timeline')
                ->orderBy('id','DESC')
                ->get();

        return response()->json($timeline, 200);
        
    }

  

    public function deleteStudentTimeline(Request $request){

        $item=$this->timeline->findOrFail($request->id);
        
        if($item->created_by==Auth::user()->id || Auth::user()->user_type=='admin'){
            $item->delete();
            return response()->json(['message'=>'Timeline Delete Successfully'], 200);
        }else{
            return response()->json(['message'=>'You Have No Permission'], 200);
        }
      
    }
}
