<?php

namespace App\Http\Controllers\Timetable;

use App\Forms\ClassTimingForm;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Site\Routine\ClassTiming;
use App\Models\Site\Routine\ClassTimingDetail;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Routine\WeekdayClassTiming;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Response;
use Exception;
use Illuminate\Http\JsonResponse;

use PDF;


class ClassTimingController extends ProjectController
{

    private $classTiming;
    private $weekdayClassTiming;
    private $routineDetail;


    public function __construct(ClassTiming $classTiming, WeekdayClassTiming $weekdayClassTiming, RoutineDetail $routineDetail)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->classTiming = $classTiming;
        $this->weekdayClassTiming = $weekdayClassTiming;
        $this->routineDetail = $routineDetail;
    }


    public function getClassTimingNameList()
    {


        $classTimings = $this->classTiming
            ->orderBy('id', 'DESC')
            ->paginate(10);

        return [$classTimings];
    }

    public function store(Request $validatedRequest)
    {

        try {
            $this->validate($validatedRequest, [
                'name' => 'required',
            ]);

            $this->classTiming = new ClassTiming();
            $this->classTiming->name = $validatedRequest->name;
            $this->classTiming->status = $validatedRequest->status;
            $this->classTiming->save();
            return Response::json(['message' => 'Saved Successfully!'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
        /*  if(isset($this->classTiming->ownFields)){
              foreach($this->classTiming->ownFields as $ownField){
                  if($validatedRequest->{$ownField})
                      $this->classTiming->{$ownField} = $validatedRequest->{$ownField} ;
              }
          }


          if ($this->classTiming->save()){
              return Response::json(['message' => 'Save Successfully!'], 200);

             // return \Redirect::route('class-timing-list')->with('Successfully Created');
          }else{
              return back()->withError('Something Went Wrong');
          }*/
    }


    public function copyClassTiming(Request $request)
    {
        $timing_id = $request->timing_id;

        $timing = $this->classTiming->findOrFail($timing_id);

        $this->classTiming = new ClassTiming();
        $this->classTiming->name = (rand(30, 50)) . '-' . $timing->name;
        $this->classTiming->status = true;
        $this->classTiming->save();




        foreach ($timing->classTimingDetails as $detail) {

            $classTimingDetail = new ClassTimingDetail();

            $classTimingDetail->class_timing_id = $this->classTiming->id;
            $classTimingDetail->name = $detail->name;
            $classTimingDetail->start_time = $detail->start_time;
            $classTimingDetail->end_time = $detail->end_time;
            $classTimingDetail->is_break = $detail->is_break;

            $classTimingDetail->save();

        }


        return response()->json(['message' => 'Successfully Copied:' . $timing->name, 'mode' => 'Copied']);
    }


    public function editClassTiming($id, Request $request)
    {

        try {
            $this->validate($request, [
                'name' => 'required',
            ]);
            $classTimingEdit = $this->classTiming->findOrFail($id);

            $classTimingEdit->name = $request->name;
            $classTimingEdit->status = $request->status;


            if ($classTimingEdit->save()) {
                return Response::json(['message' => 'Successfully Updated!'], 200);
            }

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }

    public function destroy($id)
    {
        try {

            $classTimingToDelete = $this->classTiming->findOrFail($id);
            if ($classTimingToDelete->delete()) {
                $classTimingToDelete->classTimingDetails()->delete();
                return Response::json(['message' => 'Successfully Deleted'], 200);
            }
            return back()->withErrors('Something Went Wrong!');

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


//    =========================Report=======================


    public function classTimingReport()
    {

        try {

            // \Log::info($request);
            $page_tittle = 'Class Timing Details Report';
            $report_tittle = 'Class Timing Details Report';
            $report_tittle2 = '';

            $data = $this->classTiming
                ->with(['classTimingDetails' => function ($q) {
                    $q->orderBy('start_time', 'ASC');
                }])->get();

            //return view('default.site.routine.report.class-timing-report', compact('data','page_tittle','report_tittle', 'report_tittle2'));
            $pdf = PDF::loadView('default.site.routine.report.class-timing-report', compact('data', 'page_tittle', 'report_tittle', 'report_tittle2'));
            return $pdf->stream(time() . '-class-timing.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


}
