<?php

namespace App\Http\Controllers\Timetable;

use App\Models\Academic\AcademicClass;
use App\Models\Building\Building;
use App\Models\Role\Role;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\Section;
use App\Models\Student\StudentClass;

use App\Models\Subject\Subject;
use App\Models\Timetable\ClassTimingDetail;
use App\Models\Timetable\Timetable;
use App\Models\Timetable\TimetableWeekdayClasstimingHistory;
use App\Models\Timetable\WeekdayClassTiming;
use Exception;
use Faker\Provider\cs_CZ\DateTime;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use DB;
use App\Http\Controllers\Controller;
use App\Forms\TimeTableForm;
use App\Forms\FormControll;
use App\Http\Controllers\ProjectController;
use App\Http\Requests;
use Illuminate\Validation\ValidationException;
use Response;


class TimetableController extends ProjectController
{
    use FormControll;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    private $timetable;
    private $fileName;
    private $extension;


    /**
     * StudentController constructor.
     * @param Timetable $student
     */
    public function __construct(Timetable $timetable)
    {
        $this->middleware('auth');
        $this->timetable = $timetable;

    }
    public function createTimetableForm()
    {
        $viewType = 'Create Timetable';
        return view('default.admin.timetable.create',compact('viewType'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function createTimetable(Request $validatedRequest)
    {
        $this->validate($validatedRequest,[
            'start_date'=>'required',
            'end_date'=>'required'

        ]);



        if( $validatedRequest->end_date < $validatedRequest->start_date){
            return back()->withError('Range is negative.');
        }

        $startdate = $validatedRequest->start_date;
        $enddate = $validatedRequest->end_date;
        $checkdate = DB::table('timetables')
            ->where(function ($query) use ($startdate,$enddate ){
                $query->where('start_date', '>=', $startdate)
                    ->where('start_date', '<=', $enddate);
            })->orwhere(function($r)use ($startdate,$enddate ){
                $r->where('start_date', '<=', $startdate)
                    ->where('end_date', '>=', $enddate);
            })->orwhere(function($q)use ($startdate,$enddate ){
                $q->where('end_date', '>=', $startdate)
                    ->where('end_date', '<=', $enddate);
            })->first();


        if($checkdate == null && $validatedRequest->start_date !=  $validatedRequest->end_date){

            $this->timetable->start_date = $validatedRequest->get('start_date');
            $this->timetable->end_date = $validatedRequest->get('end_date');
            $this->timetable->status = $validatedRequest->get('status');

            if($this->timetable->save()){
                return back()->withSuccess('Successfully Inserted');
            }

        }else{
            return back()->withError('Please Check Your Input Date. Date can not be over laped!');
        }





        /* if( $validatedRequest->end_date < $validatedRequest->start_date){

             redirect()->back()->withErrors('Range is negative.');
         }

         $timeTable=Timetable::all();
         $inRange= $this->checkTimetableExistsInRange($timeTable,$validatedRequest->start_date,$validatedRequest->end_date);

         if ($inRange){
             return back()->withError('Another timetable exists within the selected date range. Timetable dates cannot overlap.')->withInput();
         }

         $this->timetable->start_date = ucwords($validatedRequest->get('start_date'));
         $this->timetable->end_date = ucwords($validatedRequest->get('end_date'));
         $this->timetable->status = ucwords($validatedRequest->get('status'));

         if($this->timetable->save()){
             return back()->withSuccess('Successfully Created');

         } else{
             return back()->withError('Please Check Your Input');
         }
        */




    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, TimeTableForm $timeTableForm)
    {
        $viewType = 'Edit Time Table';
        $editTimeTable = $timeTableForm;
        $timeTableData = $this->editFormModel($this->timetable->findOrFail($id));

        return view('default.admin.timetable.edit', compact('viewType', 'editTimeTable', 'timeTableData'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Requests\Validator $validatedRequest)
    {
        $timetableToEdit = $this->timetable->findOrFail($id);

        if( $validatedRequest->end_date < $validatedRequest->start_date){
            return back()->withError('Range is negative.');
        }

        $startdate = $validatedRequest->start_date;
        $enddate = $validatedRequest->end_date;
        $checkdate = DB::table('timetables')
            ->where(function ($query) use ($startdate,$enddate ){
                $query->where('start_date', '>=', $startdate)
                    ->where('start_date', '<=', $enddate);
            })->orwhere(function($r)use ($startdate,$enddate ){
                $r->where('start_date', '<=', $startdate)
                    ->where('end_date', '>=', $enddate);
            })->orwhere(function($q)use ($startdate,$enddate ){
                $q->where('end_date', '>=', $startdate)
                    ->where('end_date', '<=', $enddate);
            })->first();

        if($checkdate == null && $validatedRequest->start_date !=  $validatedRequest->end_date){

            $timetableToEdit->start_date = $validatedRequest->get('start_date');
            $timetableToEdit->end_date = $validatedRequest->get('end_date');
            $timetableToEdit->status = $validatedRequest->get('status');

            if($timetableToEdit->save()){
                return back()->withSuccess('Successfully Updated');
            }

        }else{
            return back()->withErrors('Please Check Your Input');
            //dd($this->timetable->start_date);
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function manageAllocation($id)
    {
        $viewType = 'Manage Allocation';


        $theTimetable = $this->timetable->findOrFail($id);
        $sectionIds = explode(',', $theTimetable->section_ids);
        $sections = (new Section())->whereIn('id', $sectionIds)->select('student_class_id')->get();
        $classes = $sections->unique('student_class_id');
        $classList = (new StudentClass())->whereIn('id', $classes)->get();

// return $classes;
        return view('default.admin.timetable.manage-allocation', compact('viewType','theTimetable', 'classList'));
    }


    public function manageSection($id)
    {
        $viewType = 'Manage Section';

        $theTimetable = $this->timetable->findOrFail($id);
        $sectionList = (new Section())->all();
        $sectionIds = explode(',', $theTimetable->section_ids);
        //return $sectionList;
        return view('default.admin.timetable.manage-section', compact('viewType','theTimetable', 'sectionList','sectionIds'));
    }

    public function saveSectionForTimetable(Request $request)
    {

        try {


            $sectionIds = $request->data;
            $timetableId = $request->timetableId;

            if (isset($sectionIds) && !empty($sectionIds)) {
                $sectionIds = implode(",", $sectionIds);
            }


            $theTimetable = $this->timetable->findOrFail($timetableId);

            if ($theTimetable) {
                $theTimetable->section_ids = $sectionIds;
                $theTimetable->save();
                return response()->json(['message' => 'Successfully Updated!'], 200);

            } else {
                $this->timetable->section_ids = $sectionIds;
                $this->timetable->save();
                return response()->json(['message' => 'Successfully Saved!'], 200);

            }
        } catch (ModelNotFoundException $exception) {
            return \Response::json("The Timetable Not Found!", 400);

        }

    }


    public function timetableEntries($timetableId, $sectionId)
    {
        //save json to weekday history table
        $viewType='Timetable Entry';
        $getWeekdayClassTimingHistory = (new TimetableWeekdayClasstimingHistory())->whereSectionId($sectionId)->whereTimetableId($timetableId)->first();

        if (!$getWeekdayClassTimingHistory) {//create weekdayhistroy first time for a section

            $getWeekdayClassTiming = (new WeekdayClassTiming())->whereSectionId($sectionId)->first();

            // return $sectionId;

            if ($getWeekdayClassTiming) {
                $weekdayArray = json_decode($getWeekdayClassTiming->weekday_timing_info);
                foreach ($weekdayArray as $k => $value) {

                    $cd = (new  ClassTimingDetail())->whereClassTimingId($value)->orderBy('start_time', 'ASC')->get();

                    foreach ($cd as $kk => $val) {

                        $weekdayHistory = new TimetableWeekdayClasstimingHistory();
                        $weekdayHistory->timetable_id = $timetableId;
                        $weekdayHistory->section_id = $sectionId;
                        $weekdayHistory->weekday = $k;
                        $weekdayHistory->class_timing_details_id = $val->id;
                        $weekdayHistory->save();

                    }
                }

            } else {
//                return redirect()->back()->with('message', 'IT WORKS!');
                return   redirect()->route('weekday-class-timing')->withError('Plz Create Class Weekday Timing First');
//                \redirect()->route('weekday-class-timing')->withError(['errorData'=>'Plz Create Class Weekdat First']);
            }
        }

        $theTimetable = $this->timetable->findOrFail($timetableId);
        $sectionIds = explode(',', $theTimetable->section_ids);
        $sections = (new Section())->whereIn('id', [2,3,4])->get();
        //$classes = $sections->unique('student_class_id');
        $classList = (new AcademicClass())->whereIn('id', [1,2])->get();
        $class = (new Section())->findOrFail($sectionId);

        // dd($class->student_class_id);


        return view('default.admin.timetable.timetable-entries', compact('viewType','theTimetable', 'classList','sectionId','class'));
    }


    public function getTimetableEntriesList($timetableId, $sectinId)
    {

//      $weekDays = array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');
        $weekDays = array();

        $weekDays1 = (new TimetableWeekdayClasstimingHistory())->whereSectionId($sectinId)->whereTimetableId($timetableId)->select('weekday')->distinct('weekday')->get();
        foreach ($weekDays1 as $k=>$weekDay){
            $weekDays[$k]=$weekDay->weekday;
        }


        $weekdayTiming = (new TimetableWeekdayClasstimingHistory())->with('classTimingDetail')->whereSectionId($sectinId)->whereTimetableId($timetableId)->get();
        $getClassId = (new Section())->findOrFail($sectinId);
        $subjects = (new Subject())->whereStudentClassId($getClassId->student_class_id)->get();
        $buildings = (new Building())->get();

        $roleId = (new SiteRole())->whereName('employee')->first();
        $roleOfTeacher = (new SiteRole())->findOrFail($roleId->id);
        $teacherList = $roleOfTeacher->users()->get();



        $finalSlotList = $weekdayTiming;

      //  dd($finalSlotList[0]->classTimingDetail);

        /*$finSlotList = $finalSlotList->rooms->room_name->last();


        dd($finSlotList);*/

        return view('default.admin.timetable.timetable-entries-list', compact('weekDays', 'finalSlotList', 'subjects', 'teacherList','buildings'));

        //dd('ok');
    }

    public function saveTimetableEntriesSlotData(Request $request)
    {
        //return $request->rooms;
        //dd('ok');
        $employees = $request->data;
        $subjectId = $request->subjectId;
        $slotIds = $request->slotIds;
        $roomIds = $request->rooms;


        foreach ($slotIds as $k => $v) {
            $checkSlotExist = (new TimetableWeekdayClasstimingHistory)->findOrFail($v);

            if ($checkSlotExist) {
                if ($subjectId) {
                    $checkSlotExist->subjects = $subjectId;
                }
                if ($employees) {
                    $checkSlotExist->teachers = $employees;
                }

                if ($roomIds) {
                    $checkSlotExist->rooms = $roomIds;
                }

                // dd($roomIds);

                $checkSlotExist->save();
            }

        }

        \Response::json('Successfull Saved', 201);

    }

    public function removeTimetableEntriesSlotData(Request $request)
    {
        if ($request->slotId) {

            $checkSlotExist = (new TimetableWeekdayClasstimingHistory)->findOrFail($request->slotId);

            if ($checkSlotExist) {

                $checkSlotExist->subjects = null;
                $checkSlotExist->teachers = null;
                $checkSlotExist->save();
            }

            \Response::json('Successfull Removed', 201);

        }
    }






    public function checkTimetableExistsInRange($timetableList,$start_time1,$end_time1)
    {
        foreach ($timetableList as $k=>$v){

            if (($end_time1 < $v->start_date) || ($v->end_date < $start_time1)){// true not in range
                //   dd ($end_time1 < $start_time2) || ($end_time2 < $start_time1);// true not in range

                //  dd($v->end_date);
            }else{
                return true;//found in range
                break;
            }

        }
        return false;

    }


}
